/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.content.Context;
import android.text.format.DateFormat;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Utils;
import java.util.Date;

public class FilterProps {
    public String file_mask;
    public boolean dirs;
    public boolean files;
    public boolean include_matched;
    public long larger_than;
    public long smaller_than = Long.MAX_VALUE;
    public Date mod_after;
    public Date mod_before;
    protected String[] cards;

    private boolean isItMatched(CommanderAdapter.Item item) {
        String item_name = item.name;
        if (item.dir) {
            if (!this.dirs) {
                return false;
            }
            item_name = item.name.replace("/", "");
        } else {
            if (!this.files) {
                return false;
            }
            if (item.size < this.larger_than || item.size > this.smaller_than) {
                return false;
            }
        }
        if (Utils.str(this.file_mask)) {
            if (this.cards == null) {
                this.cards = Utils.prepareWildcard(this.file_mask);
            }
            if (!Utils.match(item_name, this.cards)) {
                return false;
            }
        }
        long modified = item.date.getTime();
        if (this.mod_after != null && modified < this.mod_after.getTime()) {
            return false;
        }
        return this.mod_before == null || modified <= this.mod_before.getTime();
    }

    public boolean isMatched(CommanderAdapter.Item item) {
        return !(this.isItMatched(item) ^ this.include_matched);
    }

    public String getString(Context ctx) {
        String pr;
        StringBuilder sb = new StringBuilder();
        if (!this.dirs || !this.files) {
            if (this.dirs) {
                sb.append(ctx.getString(2131361943));
            } else if (this.files) {
                sb.append(ctx.getString(2131361942));
            } else {
                sb.append("Nothing!!!");
            }
        }
        if (Utils.str(this.file_mask) && !"*".equals(this.file_mask) && !"*.*".equals(this.file_mask)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.file_mask);
        }
        java.text.DateFormat df = null;
        if (this.mod_after != null) {
            df = DateFormat.getDateFormat((Context)ctx);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ctx.getString(2131361948));
            sb.append(" ");
            sb.append(df.format(this.mod_after));
        }
        if (this.mod_before != null) {
            if (df == null) {
                df = DateFormat.getDateFormat((Context)ctx);
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ctx.getString(2131361949));
            sb.append(" ");
            sb.append(df.format(this.mod_before));
        }
        if (this.larger_than > 0L) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            pr = ctx.getString(2131361946);
            sb.append(pr.replace('\n', ' ').replace(':', ' '));
            sb.append(Utils.getHumanSize(this.larger_than));
        }
        if (this.smaller_than < Long.MAX_VALUE) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            pr = ctx.getString(2131361947);
            sb.append(pr.replace('\n', ' ').replace(':', ' '));
            sb.append(Utils.getHumanSize(this.smaller_than));
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.append(" ");
        return ctx.getString(this.include_matched ? 2131361950 : 2131361951) + ": " + sb.toString();
    }
}

