/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.ItemComparator;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileComparer
extends AsyncTask<CommanderAdapter, Integer, Void> {
    private static final String TAG = "FileComparer";
    private ListView lv0;
    private ListView lv1;
    private boolean compare_content;
    private boolean case_ignore;

    public FileComparer(ListView ... lvs) {
        this.lv0 = lvs[0];
        this.lv1 = lvs[1];
    }

    void setOptions(boolean compare_content, boolean case_ignore) {
        this.compare_content = compare_content;
        this.case_ignore = case_ignore;
    }

    protected Void doInBackground(CommanderAdapter ... aa) {
        try {
            ListAdapter la0 = (ListAdapter)aa[0];
            ListAdapter la1 = (ListAdapter)aa[1];
            boolean[] matched_cache1 = new boolean[la1.getCount()];
            for (int i0 = 1; i0 < la0.getCount(); ++i0) {
                CommanderAdapter.Item item0 = (CommanderAdapter.Item)la0.getItem(i0);
                boolean found = false;
                for (int i1 = 1; i1 < la1.getCount(); ++i1) {
                    CommanderAdapter.Item item1 = (CommanderAdapter.Item)la1.getItem(i1);
                    int cmp_opts = 7;
                    if (this.case_ignore) {
                        cmp_opts |= 0x10;
                    }
                    if (ItemComparator.compare(item0, item1, cmp_opts) != 0) continue;
                    boolean bl = found = !item0.dir && this.compare_content ? this.compareContent(aa[0], i0, aa[1], i1) : true;
                    if (!found) continue;
                    matched_cache1[i1] = true;
                    break;
                }
                if (found) continue;
                this.publishProgress(new Integer[]{i0, null});
            }
            for (int i1 = 1; i1 < la1.getCount(); ++i1) {
                if (matched_cache1[i1]) continue;
                this.publishProgress(new Integer[]{null, i1});
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... poss) {
        int pos;
        ListView lv = null;
        if (poss[0] != null) {
            lv = this.lv0;
            pos = poss[0];
        } else if (poss[1] != null) {
            lv = this.lv1;
            pos = poss[1];
        } else {
            Log.e((String)TAG, (String)"Unknown side");
            return;
        }
        lv.setItemChecked(pos, true);
    }

    protected void onPostExecute(Void v) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compareContent(CommanderAdapter ca0, int i0, CommanderAdapter ca1, int i1) {
        boolean bl;
        InputStream is1;
        InputStream is0;
        block19: {
            block20: {
                boolean bl2;
                block17: {
                    block18: {
                        is0 = null;
                        is1 = null;
                        try {
                            Uri u0 = ca0.getItemUri(i0);
                            if (u0 == null) {
                                boolean bl3 = false;
                                return bl3;
                            }
                            Log.d((String)TAG, (String)("u0 " + u0));
                            is0 = ca0.getContent(u0);
                            if (is0 == null) {
                                boolean bl4 = false;
                                if (is0 != null) {
                                    ca0.closeStream(is0);
                                }
                                if (is1 == null) return bl4;
                                ca1.closeStream(is1);
                                return bl4;
                            }
                            Uri u1 = ca1.getItemUri(i1);
                            if (u1 == null) {
                                boolean bl5 = false;
                                if (is0 != null) {
                                    ca0.closeStream(is0);
                                }
                                if (is1 == null) return bl5;
                                ca1.closeStream(is1);
                                return bl5;
                            }
                            Log.d((String)TAG, (String)("u1 " + u1));
                            is1 = ca1.getContent(u1);
                            if (is1 == null) {
                                bl2 = false;
                                if (is0 == null) break block17;
                                break block18;
                            }
                            bl = this.compareContent(is0, is1);
                            if (is0 == null) break block19;
                            break block20;
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)"");
                            return false;
                        }
                    }
                    ca0.closeStream(is0);
                }
                if (is1 == null) return bl2;
                ca1.closeStream(is1);
                return bl2;
            }
            ca0.closeStream(is0);
        }
        if (is1 == null) return bl;
        ca1.closeStream(is1);
        return bl;
        finally {
            if (is0 != null) {
                ca0.closeStream(is0);
            }
            if (is1 != null) {
                ca1.closeStream(is1);
            }
        }
    }

    private boolean compareContent(InputStream is0, InputStream is1) {
        try {
            byte[] buf0 = new byte[8192];
            byte[] buf1 = new byte[8192];
            int hr0 = 0;
            int hr1 = 0;
            while ((hr0 = is0.read(buf0)) > 0) {
                hr1 = is1.read(buf1);
                if (hr1 <= 0) {
                    return false;
                }
                if (hr0 != hr1) {
                    return false;
                }
                for (int i = 0; i < hr0; ++i) {
                    if (buf0[i] == buf1[i]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"");
            return false;
        }
    }
}

