/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.Scroller;
import android.widget.TextView;
import android.widget.Toast;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Editor
extends Activity
implements TextWatcher,
View.OnTouchListener,
GestureDetector.OnGestureListener {
    private static final String TAG = "EditorActivity";
    private static final String SP_ENC = "encoding";
    private static final String SP_NOWRAP = "no_wrap";
    static final int MENU_SAVE = 214;
    static final int MENU_SVAS = 212;
    static final int MENU_RELD = 439;
    static final int MENU_WRAP = 241;
    static final int MENU_ENC = 363;
    static final int MENU_EXIT = 323;
    private EditText te;
    private boolean horScroll = true;
    public Uri uri;
    public CommanderAdapter ca;
    public boolean dirty = false;
    public String encoding;
    private DataLoadTask loader = null;
    private GestureDetector gd = null;
    private Scroller sc = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            ImageButton mb;
            SharedPreferences prefs = this.getPreferences(0);
            if (prefs != null) {
                this.encoding = prefs.getString(SP_ENC, "");
                this.horScroll = prefs.getBoolean(SP_NOWRAP, true);
            }
            boolean ct_enabled = false;
            boolean ab = Utils.needActionBar(this);
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            Utils.setTheme((Context)this, shared_pref.getString("color_themes", "d"));
            if (ab) {
                ab = Utils.setActionBar(this);
            } else {
                ct_enabled = this.requestWindowFeature(7);
            }
            this.setContentView(2130903045);
            if (!ab && Build.VERSION.SDK_INT >= 17 && !ForwardCompat.hasPermanentMenuKey((Context)this) && (mb = (ImageButton)this.findViewById(2131230755)) != null) {
                mb.setVisibility(0);
                mb.setOnClickListener(new View.OnClickListener(){

                    @SuppressLint(value={"NewApi"})
                    public void onClick(View v) {
                        try {
                            Log.d((String)Editor.TAG, (String)("hasFeature(OP) " + Editor.this.getWindow().hasFeature(0)));
                            Log.d((String)Editor.TAG, (String)("getActionBar() " + Editor.this.getActionBar()));
                            new Handler().postDelayed(new Runnable(){

                                public void run() {
                                    Editor.this.openOptionsMenu();
                                }
                            }, 100L);
                        }
                        catch (Exception e) {
                            Log.e((String)Editor.TAG, (String)"Exception onclick", (Throwable)e);
                        }
                    }
                });
            }
            this.te = (EditText)this.findViewById(2131230797);
            this.te.addTextChangedListener((TextWatcher)this);
            this.te.setOnTouchListener((View.OnTouchListener)this);
            this.sc = new Scroller((Context)this);
            this.te.setScroller(this.sc);
            this.te.setVerticalScrollBarEnabled(true);
            this.gd = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)this);
            this.te.setFilters(new InputFilter[]{new InputFilter.LengthFilter(Integer.MAX_VALUE)});
            int fs = Integer.parseInt(shared_pref != null ? shared_pref.getString("font_size", "12") : "12");
            this.te.setTextSize((float)fs);
            ColorsKeeper ck = new ColorsKeeper((Context)this);
            ck.restore();
            this.te.setBackgroundColor(ck.bgrColor);
            this.te.setTextColor(ck.fgrColor);
            if (ct_enabled) {
                TextView act_name_tv;
                this.getWindow().setFeatureInt(7, 2130903041);
                View at = this.findViewById(2131230786);
                if (at != null) {
                    ViewParent vp = at.getParent();
                    if (vp instanceof FrameLayout) {
                        FrameLayout flp = (FrameLayout)vp;
                        flp.setBackgroundColor(ck.ttlColor);
                        flp.setPadding(0, 0, 0, 0);
                    }
                    at.setBackgroundColor(ck.ttlColor);
                }
                if ((act_name_tv = (TextView)this.findViewById(2131230787)) != null) {
                    act_name_tv.setText(2131362094);
                }
            }
            this.uri = this.getIntent().getData();
            this.loader = new DataLoadTask();
            this.loader.execute(new Void[0]);
            TextView file_name_tv = (TextView)this.findViewById(2131230788);
            if (file_name_tv != null) {
                String label_text = " - " + this.uri.getPath();
                String frgm = this.uri.getFragment();
                if (frgm != null) {
                    label_text = label_text + " (" + frgm + ")";
                }
                file_name_tv.setText((CharSequence)label_text);
            }
            this.te.setHorizontallyScrolling(this.horScroll);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            this.finish();
        }
    }

    protected void onPause() {
        super.onPause();
        SharedPreferences.Editor editor = this.getPreferences(0).edit();
        editor.putString(SP_ENC, this.encoding == null ? "" : this.encoding);
        editor.putBoolean(SP_NOWRAP, this.horScroll);
        editor.commit();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.loader != null) {
            this.loader.cancel(true);
        }
        if (this.ca != null) {
            this.ca.prepareToDestroy();
            this.ca = null;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (!this.dirty) break;
                this.askToSave();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.clear();
        menu2.add(0, 214, 0, (CharSequence)this.getString(2131362200)).setIcon(17301582);
        menu2.add(0, 212, 0, (CharSequence)this.getString(2131362201)).setIcon(17301582);
        menu2.add(0, 439, 0, (CharSequence)this.getString(2131362202)).setIcon(17301580);
        menu2.add(0, 241, 0, (CharSequence)((this.horScroll ? "" : "~ ") + this.getString(2131362203))).setIcon(2130837551);
        menu2.add(0, 363, 0, (CharSequence)(this.getString(2131362211) + " '" + Utils.getEncodingDescr((Context)this, this.encoding, 1) + "'")).setIcon(17301660);
        menu2.add(0, 323, 0, (CharSequence)this.getString(2131361860)).setIcon(17301594);
        return true;
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        switch (item.getItemId()) {
            case 214: {
                new DataSaveTask(false).execute(new Uri[]{this.uri});
                return true;
            }
            case 212: {
                try {
                    LayoutInflater factory = LayoutInflater.from((Context)this);
                    View iv = factory.inflate(2130903048, null);
                    if (iv != null) {
                        TextView prompt = (TextView)iv.findViewById(2131230801);
                        final EditText edit = (EditText)iv.findViewById(2131230802);
                        prompt.setText(2131361957);
                        String path = this.uri.getPath();
                        if (path == null) {
                            return false;
                        }
                        final int _alsp = path.lastIndexOf(47) + 1;
                        edit.setText((CharSequence)path.substring(_alsp));
                        new AlertDialog.Builder((Context)this).setTitle(2131362201).setView(iv).setPositiveButton(2131362200, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int i) {
                                String fn = edit.getText().toString();
                                if (!Utils.str(fn)) {
                                    return;
                                }
                                Editor.this.uri = Editor.this.uri.buildUpon().path(Editor.this.uri.getPath().substring(0, _alsp) + fn).build();
                                new DataSaveTask(false).execute(new Uri[]{Editor.this.uri});
                            }
                        }).setNegativeButton(2131361930, null).show();
                    }
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
                return true;
            }
            case 439: {
                this.loader = new DataLoadTask();
                this.loader.execute(new Void[0]);
                return true;
            }
            case 363: {
                int cen = Integer.parseInt(Utils.getEncodingDescr((Context)this, this.encoding, 0));
                new AlertDialog.Builder((Context)this).setTitle(2131362211).setSingleChoiceItems(2131296263, cen, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        dialog.dismiss();
                        Editor.this.encoding = Editor.this.getResources().getStringArray(2131296264)[i];
                        Log.i((String)Editor.TAG, (String)("Chosen encoding: " + Editor.this.encoding));
                        Editor.this.showMessage(Editor.this.getString(2131362212, new Object[]{Utils.getEncodingDescr((Context)Editor.this, Editor.this.encoding, 1)}));
                    }
                }).show();
                return true;
            }
            case 241: {
                try {
                    EditText te = (EditText)this.findViewById(2131230797);
                    this.horScroll = !this.horScroll;
                    te.setHorizontallyScrolling(this.horScroll);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
                return true;
            }
            case 323: {
                if (this.dirty) {
                    this.askToSave();
                    break;
                }
                this.finish();
            }
        }
        return super.onMenuItemSelected(featureId, item);
    }

    private final void askToSave() {
        DialogInterface.OnClickListener ocl = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which_button) {
                if (which_button == -1) {
                    new DataSaveTask(true).execute(new Uri[]{Editor.this.uri});
                } else if (which_button == -2) {
                    Editor.this.finish();
                }
            }
        };
        new AlertDialog.Builder((Context)this).setIcon(17301543).setTitle(2131362200).setMessage(2131362199).setPositiveButton(2131362200, ocl).setNegativeButton(2131361930, ocl).show();
    }

    public final void showMessage(String s) {
        Toast.makeText((Context)this, (CharSequence)s, (int)1).show();
    }

    public void afterTextChanged(Editable s) {
        this.dirty = true;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public boolean onTouch(View view, MotionEvent ev) {
        this.sc.abortAnimation();
        return this.gd.onTouchEvent(ev);
    }

    public boolean onDown(MotionEvent ev) {
        return false;
    }

    public void onShowPress(MotionEvent ev) {
    }

    public boolean onSingleTapUp(MotionEvent ev) {
        return false;
    }

    public boolean onScroll(MotionEvent ev1, MotionEvent ev2, float distanceX, float distanceY) {
        return false;
    }

    public void onLongPress(MotionEvent ev) {
    }

    public boolean onFling(MotionEvent ev1, MotionEvent ev2, float velocityX, float velocityY) {
        if (Math.abs(velocityY) < 1000.0f) {
            return false;
        }
        float maxY = this.te.getLineCount() * this.te.getLineHeight();
        this.sc.fling(this.te.getScrollX(), this.te.getScrollY(), (int)velocityX, -((int)velocityY), 0, 0, 0, (int)maxY);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataSaveTask
    extends AsyncTask<Uri, String, Boolean> {
        private ProgressDialog pd;
        private boolean close_on_finish;

        DataSaveTask(boolean close_on_finish_) {
            this.close_on_finish = close_on_finish_;
        }

        protected void onPreExecute() {
            this.pd = ProgressDialog.show((Context)Editor.this, (CharSequence)"", (CharSequence)Editor.this.getString(2131361916), (boolean)true, (boolean)true);
        }

        protected Boolean doInBackground(Uri ... save_uri_) {
            Uri save_uri;
            Uri uri = save_uri = save_uri_.length > 0 ? save_uri_[0] : null;
            if (Editor.this.ca == null) {
                Log.e((String)Editor.TAG, (String)"Adapter is null ");
                return false;
            }
            if (save_uri == null) {
                Log.e((String)Editor.TAG, (String)"No URI to save");
                return false;
            }
            Credentials crd = null;
            try {
                crd = (Credentials)Editor.this.getIntent().getParcelableExtra(Credentials.KEY);
            }
            catch (Exception e) {
                Log.e((String)Editor.TAG, (String)"on taking credentials from parcel", (Throwable)e);
            }
            Editor.this.ca.setCredentials(crd);
            OutputStream os = Editor.this.ca.saveContent(save_uri);
            if (os == null) {
                Log.e((String)Editor.TAG, (String)"No output stream");
                return false;
            }
            try {
                int BUF_SIZE = 16384;
                OutputStreamWriter osw = Editor.this.encoding != null && Editor.this.encoding.length() != 0 ? new OutputStreamWriter(os, Editor.this.encoding) : new OutputStreamWriter(os);
                Editable e = Editor.this.te.getText();
                int len = e.length();
                if (len < 16384) {
                    osw.write(e.toString());
                    osw.flush();
                } else {
                    char[] chars = new char[16384];
                    int start = 0;
                    int end = 16384;
                    int cnt = 0;
                    while (start < len - 1) {
                        e.getChars(start, end, chars, 0);
                        osw.write(chars, 0, end - start);
                        start = end;
                        if ((end += 16384) > len) {
                            end = len;
                        }
                        ++cnt;
                    }
                    osw.flush();
                }
                Editor.this.ca.closeStream(os);
                File f = new File(save_uri.getPath());
                this.publishProgress(new String[]{Editor.this.getString(2131362198, new Object[]{f != null ? f.getName() : "file"})});
                if (f != null) {
                    return true;
                }
            }
            catch (Throwable e) {
                Log.e((String)Editor.TAG, (String)Favorite.screenPwd(save_uri), (Throwable)e);
            }
            return false;
        }

        protected void onProgressUpdate(String ... err) {
            if (err.length > 0) {
                Editor.this.showMessage(err[0]);
            }
        }

        protected void onPostExecute(Boolean succeeded) {
            this.pd.cancel();
            if (succeeded.booleanValue()) {
                Editor.this.dirty = false;
            } else {
                Editor.this.showMessage(Editor.this.getString(2131362219));
            }
            if (this.close_on_finish) {
                Editor.this.finish();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataLoadTask
    extends AsyncTask<Void, String, CharSequence> {
        private ProgressDialog pd;

        private DataLoadTask() {
        }

        protected void onPreExecute() {
            this.pd = ProgressDialog.show((Context)Editor.this, (CharSequence)"", (CharSequence)Editor.this.getString(2131362008), (boolean)true, (boolean)true);
        }

        protected CharSequence doInBackground(Void ... v) {
            Uri uri = Editor.this.uri;
            try {
                String scheme = uri.getScheme();
                InputStream is = null;
                if (Editor.this.ca == null) {
                    Editor.this.ca = CA.CreateAdapterInstance(uri, (Context)Editor.this);
                }
                if (Editor.this.ca != null) {
                    Credentials crd = null;
                    try {
                        crd = (Credentials)Editor.this.getIntent().getParcelableExtra(Credentials.KEY);
                    }
                    catch (Exception e) {
                        Log.e((String)Editor.TAG, (String)"on taking credentials from parcel", (Throwable)e);
                    }
                    Editor.this.ca.setCredentials(crd);
                    is = Editor.this.ca.getContent(uri);
                }
                if (is != null) {
                    CharSequence cs = Utils.readStreamToBuffer(is, Editor.this.encoding);
                    if (Editor.this.ca != null) {
                        Editor.this.ca.closeStream(is);
                    } else {
                        is.close();
                    }
                    return cs;
                }
                this.publishProgress(new String[]{Editor.this.getString(2131362019, new Object[]{uri.toString()})});
            }
            catch (OutOfMemoryError e) {
                Log.e((String)Editor.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{Editor.this.getString(2131362214, new Object[]{uri.getPath()})});
            }
            catch (Throwable e) {
                Log.e((String)Editor.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{Editor.this.getString(2131361918) + e.getLocalizedMessage()});
            }
            return null;
        }

        protected void onProgressUpdate(String ... err) {
            if (err.length > 0) {
                Editor.this.showMessage(err[0]);
            }
        }

        protected void onPostExecute(CharSequence cs) {
            this.pd.cancel();
            Editor.this.te.setText(cs);
            Editor.this.dirty = false;
            Editor.this.loader = null;
        }
    }
}

