/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.Html;
import android.text.format.DateFormat;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.ghostsq.commander.FileCommander;
import com.ghostsq.commander.FilterProps;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Dialogs
implements DialogInterface.OnClickListener {
    private static final String TAG = "Dialogs";
    public static final int ARI_DIALOG = 148;
    public static final int ALERT_DIALOG = 193;
    public static final int CONFIRM_DIALOG = 396;
    public static final int INPUT_DIALOG = 860;
    public static final int PROGRESS_DIALOG = 493;
    public static final int INFO_DIALOG = 864;
    public static final int LOGIN_DIALOG = 995;
    public static final int SELECT_DIALOG = 239;
    public static final int UNSELECT_DIALOG = 762;
    public static final int FILE_EXIST_DIALOG = 328;
    public static final int SMB_PLG_DIALOG = 275;
    public static final int SFTP_PLG_DIALOG = 245;
    public static final int numDialogTypes = 7;
    protected String toShowInAlertDialog = null;
    protected String cookie = null;
    protected String activeFileName;
    private int dialogId;
    private long taskId = 0L;
    public Dialog dialogObj;
    private FileCommander owner;
    private boolean valid = true;
    private int progressCounter = 0;
    private long progressAcSpeed = 0L;
    private Credentials crd = null;
    private int which_panel = -1;
    private boolean pw_only = false;

    Dialogs(FileCommander owner_, int id2) {
        this.owner = owner_;
        this.dialogObj = null;
        this.dialogId = id2;
    }

    public final int getId() {
        return this.dialogId;
    }

    public final long getTaskId() {
        return this.taskId;
    }

    public final void setTaskId(long taskId_) {
        this.taskId = taskId_;
    }

    public final Dialog getDialog() {
        return this.dialogObj;
    }

    public final void showDialog() {
        if (this.dialogObj == null || !this.dialogObj.isShowing()) {
            this.owner.showDialog(this.dialogId);
        }
    }

    public final void cancelDialog() {
        if (this.dialogObj != null && this.dialogObj.isShowing()) {
            this.dialogObj.cancel();
        }
        this.progressCounter = 0;
        this.progressAcSpeed = 0L;
        this.taskId = 0L;
    }

    private final AlertDialog build(View inner_view, String title) {
        AlertDialog ad = new AlertDialog.Builder((Context)this.owner).setView(inner_view).setTitle((CharSequence)title).setPositiveButton(2131361929, (DialogInterface.OnClickListener)this).setNegativeButton(2131361930, (DialogInterface.OnClickListener)this).create();
        ad.getWindow().setSoftInputMode(2);
        return ad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Dialog createDialog(int id2) {
        try {
            Utils.changeLanguage((Context)this.owner);
            LayoutInflater factory = LayoutInflater.from((Context)this.owner);
            switch (id2) {
                case 860: 
                case 2131230760: {
                    View openArchiveView = factory.inflate(2130903054, null);
                    Dialog dialog = this.dialogObj = this.build(openArchiveView, " ");
                    return dialog;
                }
                case 2131230759: 
                case 2131230924: {
                    View newArchiveView = factory.inflate(2130903052, null);
                    Dialog dialog = this.dialogObj = this.build(newArchiveView, " ");
                    return dialog;
                }
                case 2131230721: 
                case 2131230722: 
                case 2131230727: 
                case 2131230728: 
                case 2131230729: 
                case 2131230730: 
                case 2131230731: 
                case 2131230732: 
                case 2131230923: {
                    View textEntryView = factory.inflate(2130903048, null);
                    Dialog dialog = this.dialogObj = this.build(textEntryView, " ");
                    return dialog;
                }
                case 239: 
                case 762: 
                case 2131230763: {
                    View search_params;
                    View searchView = factory.inflate(2130903060, null);
                    if (id2 == 2131230763 && (search_params = searchView.findViewById(2131230803)) != null) {
                        search_params.setVisibility(0);
                    }
                    this.dialogObj = this.build(searchView, " ");
                    search_params = this.dialogObj;
                    return search_params;
                }
                case 2131230764: {
                    View filterView = factory.inflate(2130903046, null);
                    Dialog search_params = this.dialogObj = this.build(filterView, " ");
                    return search_params;
                }
                case 995: {
                    View textEntryView = factory.inflate(2130903049, null);
                    Dialog search_params = this.dialogObj = this.build(textEntryView, "Login");
                    return search_params;
                }
                case 328: {
                    this.dialogObj = new AlertDialog.Builder((Context)this.owner).setIcon(17301543).setTitle(2131362060).setMessage(2131362060).setPositiveButton(2131361937, (DialogInterface.OnClickListener)this).setNeutralButton(2131361938, (DialogInterface.OnClickListener)this).setNegativeButton(2131361930, (DialogInterface.OnClickListener)this).create();
                    AlertDialog textEntryView = this.dialogObj;
                    return textEntryView;
                }
                case 245: 
                case 275: 
                case 396: 
                case 2131230733: 
                case 2131230734: 
                case 2131230765: {
                    this.dialogObj = new AlertDialog.Builder((Context)this.owner).setIcon(17301543).setTitle(2131362062).setMessage((CharSequence)"").setPositiveButton(2131361929, (DialogInterface.OnClickListener)this).setNegativeButton(2131361930, (DialogInterface.OnClickListener)this).create();
                    AlertDialog textEntryView = this.dialogObj;
                    return textEntryView;
                }
                case 493: {
                    View progressView = factory.inflate(2130903056, null);
                    this.dialogObj = new AlertDialog.Builder((Context)this.owner).setView(progressView).setTitle(2131362064).setPositiveButton(2131361931, (DialogInterface.OnClickListener)this).setNegativeButton(2131361930, (DialogInterface.OnClickListener)this).setCancelable(false).create();
                    AlertDialog search_params = this.dialogObj;
                    return search_params;
                }
                case 193: {
                    this.dialogObj = new AlertDialog.Builder((Context)this.owner).setIcon(17301543).setTitle(2131362063).setMessage((CharSequence)"").setPositiveButton(2131361929, (DialogInterface.OnClickListener)this).create();
                    AlertDialog progressView = this.dialogObj;
                    return progressView;
                }
                case 864: 
                case 2131230934: {
                    AlertDialog.Builder adb = new AlertDialog.Builder((Context)this.owner).setIcon(17301659).setTitle(2131362061).setPositiveButton(2131361929, (DialogInterface.OnClickListener)this);
                    View tvs = factory.inflate(2130903064, null);
                    if (tvs != null) {
                        tvs.setPadding(0, 20, 0, 0);
                        adb.setView(tvs);
                    } else {
                        adb.setMessage((CharSequence)"");
                    }
                    this.dialogObj = adb.create();
                    AlertDialog alertDialog = this.dialogObj;
                    return alertDialog;
                }
            }
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("id=" + id2), (Throwable)e);
            return null;
        }
        finally {
            if (this.dialogObj == null) {
                Log.e((String)TAG, (String)("Failed. id=" + id2));
            }
        }
    }

    protected void prepareDialog(int id2, Dialog dialog) {
        if (dialog != this.dialogObj) {
            Log.e((String)TAG, (String)"Dialogs corrupted!");
            return;
        }
        Utils.changeLanguage((Context)this.owner);
        boolean move = false;
        try {
            TextView prompt = (TextView)dialog.findViewById(2131230801);
            EditText edit = (EditText)dialog.findViewById(2131230802);
            switch (id2) {
                case 493: {
                    TextView t = (TextView)this.dialogObj.findViewById(2131230858);
                    if (t == null) break;
                    t.setText((CharSequence)"");
                    break;
                }
                case 2131230721: 
                case 2131230722: {
                    String op_title = this.owner.getString(2131361962);
                    String op = this.owner.getString(2131361970);
                    if (op == null || op.length() <= 1) {
                        op = op_title;
                    }
                    dialog.setTitle((CharSequence)op_title);
                    String item_name = this.owner.panels.getSelectedItemName(2131230722 == id2);
                    if (item_name == null) {
                        this.owner.showMessage(this.owner.getString(2131361976));
                        item_name = "";
                    }
                    if (prompt != null) {
                        prompt.setText((CharSequence)this.owner.getString(2131361984, new Object[]{op, item_name}));
                    }
                    if (edit == null) break;
                    edit.setWidth(this.owner.getWidth() - 80);
                    edit.setText((CharSequence)item_name);
                    break;
                }
                case 2131230727: 
                case 2131230923: {
                    dialog.setTitle(2131361956);
                    if (prompt != null) {
                        prompt.setText(2131361957);
                    }
                    if (edit == null) break;
                    edit.setWidth(this.owner.getWidth() - 80);
                    edit.setText((CharSequence)"");
                    break;
                }
                case 2131230730: 
                case 2131230731: {
                    move = true;
                }
                case 2131230728: 
                case 2131230729: {
                    int qm_pos;
                    String cts;
                    boolean touch;
                    String op_title = this.owner.getString(move ? 2131361965 : 2131361964);
                    String op = this.owner.getString(move ? 2131361969 : 2131361968);
                    if (op == null || op.length() <= 1) {
                        op = op_title;
                    }
                    dialog.setTitle((CharSequence)op_title);
                    boolean bl = touch = this.dialogId == 2131230729 || this.dialogId == 2131230731;
                    if (prompt != null) {
                        String summ = this.owner.panels.getActiveItemsSummary(touch);
                        if (summ == null) {
                            dialog.cancel();
                            this.owner.showMessage(this.owner.getString(2131361983, new Object[]{op}));
                            this.valid = false;
                            return;
                        }
                        this.valid = true;
                        prompt.setText((CharSequence)this.owner.getString(2131361984, new Object[]{op, summ}));
                    }
                    if (edit == null) break;
                    edit.setWidth(this.owner.getWidth() - 70);
                    CommanderAdapter ca = this.owner.panels.getListAdapter(false);
                    Uri u = ca != null ? ca.getUri() : null;
                    String string2 = cts = u != null ? u.toString() : "";
                    if (!Utils.str(cts)) {
                        return;
                    }
                    if (cts.charAt(0) == '/') {
                        cts = Utils.unEscape(cts);
                    }
                    if ((qm_pos = cts.indexOf(63)) > 0) {
                        cts = cts.substring(0, qm_pos);
                    }
                    edit.setText((CharSequence)Utils.mbAddSl(cts));
                    if (Utils.getCount(this.owner.panels.getMultiple(touch)) == 1) {
                        edit.selectAll();
                    }
                    break;
                }
                case 2131230760: {
                    String op = this.owner.getString(2131361908);
                    dialog.setTitle((CharSequence)op);
                    prompt.setText((CharSequence)this.owner.getString(2131361915));
                    TextView file_path = (TextView)dialog.findViewById(2131230835);
                    file_path.setText((CharSequence)this.activeFileName);
                    ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this.owner, (int)2131296263, (int)17367048);
                    adapter.setDropDownViewResource(0x1090009);
                    Spinner encoding_spin = (Spinner)dialog.findViewById(2131230832);
                    encoding_spin.setAdapter((SpinnerAdapter)adapter);
                    CheckBox encrypr_cb = (CheckBox)dialog.findViewById(2131230829);
                    encrypr_cb.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            CheckBox encrypr_cb = (CheckBox)v;
                            View pwb = Dialogs.this.dialogObj.findViewById(2131230830);
                            pwb.setVisibility(encrypr_cb.isChecked() ? 0 : 8);
                        }
                    });
                    break;
                }
                case 2131230759: 
                case 2131230924: {
                    String op = this.owner.getString(2131361913);
                    dialog.setTitle((CharSequence)op);
                    if (prompt != null) {
                        String summ = this.owner.panels.getActiveItemsSummary(2131230759 == id2);
                        if (summ == null) {
                            dialog.dismiss();
                            summ = this.owner.getString(2131361978);
                            this.owner.showMessage(this.owner.getString(2131361983, new Object[]{op}));
                        }
                        prompt.setText((CharSequence)this.owner.getString(2131361984, new Object[]{this.owner.getString(2131361964), summ}));
                    }
                    if (edit != null) {
                        edit.setWidth(this.owner.getWidth() - 70);
                        CommanderAdapter oth_ca = this.owner.panels.getListAdapter(false);
                        String path = this.owner.panels.getFolderUriWithAuth(!oth_ca.hasFeature(CommanderAdapter.Feature.FS)) + ".zip";
                        edit.setText((CharSequence)path);
                        edit.setSelection(path.length() - 4);
                    }
                    CheckBox encrypr_cb = (CheckBox)dialog.findViewById(2131230829);
                    encrypr_cb.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            CheckBox encrypr_cb = (CheckBox)v;
                            View pwb = Dialogs.this.dialogObj.findViewById(2131230830);
                            pwb.setVisibility(encrypr_cb.isChecked() ? 0 : 8);
                        }
                    });
                    ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this.owner, (int)2131296263, (int)17367048);
                    adapter.setDropDownViewResource(0x1090009);
                    Spinner encoding_spin = (Spinner)dialog.findViewById(2131230832);
                    encoding_spin.setAdapter((SpinnerAdapter)adapter);
                    break;
                }
                case 2131230732: {
                    dialog.setTitle(2131361958);
                    if (prompt != null) {
                        prompt.setText(2131361959);
                    }
                    if (edit == null) break;
                    edit.setWidth(this.owner.getWidth() - 90);
                    break;
                }
                case 2131230764: {
                    dialog.setTitle(2131361829);
                }
                case 2131230763: {
                    Button mod_before_date;
                    Button mod_after_date;
                    Editable edit_text;
                    if (id2 == 2131230763) {
                        dialog.setTitle(2131361960);
                        if (prompt != null) {
                            prompt.setText(2131361961);
                        }
                    }
                    if (edit != null && (edit_text = edit.getText()).length() == 0) {
                        edit.setText((CharSequence)"*");
                    }
                    if ((mod_after_date = (Button)dialog.findViewById(2131230807)) != null) {
                        new DatePickerButton((Context)this.owner, mod_after_date);
                    }
                    if ((mod_before_date = (Button)dialog.findViewById(2131230811)) == null) break;
                    new DatePickerButton((Context)this.owner, mod_before_date);
                    break;
                }
                case 239: 
                case 762: {
                    dialog.setTitle(id2 == 239 ? 2131361939 : 2131361940);
                    if (edit == null) break;
                    Editable edit_text = edit.getText();
                    if (edit_text.length() == 0) {
                        edit.setText((CharSequence)"*");
                    }
                    break;
                }
                case 995: {
                    EditText n_v = (EditText)dialog.findViewById(2131230815);
                    EditText p_v = (EditText)dialog.findViewById(2131230817);
                    if (this.crd != null) {
                        String un = this.crd.getUserName();
                        n_v.setText((CharSequence)un);
                        p_v.setText((CharSequence)(this.crd.getPassword() != null ? this.crd.getPassword() : ""));
                        this.crd = null;
                    }
                    if (this.pw_only) {
                        dialog.findViewById(2131230814).setVisibility(8);
                        n_v.setVisibility(8);
                    }
                    AlertDialog ad = (AlertDialog)dialog;
                    String title = Utils.str(this.toShowInAlertDialog) ? this.toShowInAlertDialog : this.owner.getString(2131361985);
                    int nl_pos = title.indexOf(10);
                    if (nl_pos > 0 && prompt != null) {
                        prompt.setText((CharSequence)title.substring(nl_pos + 1));
                        title = title.substring(0, nl_pos);
                    }
                    ad.setTitle((CharSequence)title);
                    this.toShowInAlertDialog = null;
                    break;
                }
                case 2131230733: 
                case 2131230734: {
                    String str;
                    AlertDialog ad = (AlertDialog)dialog;
                    ad.setTitle(2131361986);
                    String summ = this.owner.panels.getActiveItemsSummary(2131230734 == id2);
                    if (summ == null) {
                        str = this.owner.getString(2131361978);
                        dialog.cancel();
                    } else {
                        str = this.owner.getString(2131361988, new Object[]{summ});
                    }
                    ad.setMessage((CharSequence)str);
                    break;
                }
                case 2131230765: {
                    ((AlertDialog)dialog).setMessage((CharSequence)this.owner.getString(2131362243));
                    break;
                }
                case 275: {
                    ((AlertDialog)dialog).setMessage((CharSequence)this.owner.getString(2131362239));
                    break;
                }
                case 245: {
                    ((AlertDialog)dialog).setMessage((CharSequence)this.owner.getString(2131362240));
                    break;
                }
                case 2131230934: {
                    PackageInfo pi = null;
                    try {
                        pi = this.owner.getPackageManager().getPackageInfo(this.owner.getPackageName(), 0);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.e((String)TAG, (String)"Package name not found", (Throwable)e);
                    }
                    String txt = this.owner.getString(2131362244, new Object[]{pi != null ? pi.versionName : "?", this.owner.getString(2131362250)});
                    TextView tv = (TextView)dialog.findViewById(2131230898);
                    tv.setMovementMethod(LinkMovementMethod.getInstance());
                    tv.setText((CharSequence)Html.fromHtml((String)txt));
                    break;
                }
                case 864: {
                    if (this.toShowInAlertDialog == null) break;
                    TextView tv = (TextView)dialog.findViewById(2131230898);
                    if (tv != null) {
                        boolean reduce_size;
                        SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this.owner);
                        int fnt_sz = Integer.parseInt(shared_pref != null ? shared_pref.getString("font_size", "12") : "12");
                        boolean bl = reduce_size = this.toShowInAlertDialog.length() > 128;
                        if (!reduce_size) {
                            String[] ss;
                            for (String s : ss = this.toShowInAlertDialog.split("\n")) {
                                if (s.length() <= 31) continue;
                                reduce_size = true;
                                break;
                            }
                        }
                        int fs = (reduce_size ? 15 : 18) + (fnt_sz - 12);
                        tv.setTextSize(fs > 12 ? (float)fs : 12.0f);
                        if (Utils.isHTML(this.toShowInAlertDialog)) {
                            if (this.toShowInAlertDialog.indexOf("</a>", 3) > 0) {
                                tv.setMovementMethod(LinkMovementMethod.getInstance());
                            }
                            tv.setText((CharSequence)Html.fromHtml((String)this.toShowInAlertDialog.replaceAll("\\n", "<br/>")));
                        } else {
                            tv.setText((CharSequence)this.toShowInAlertDialog);
                        }
                    } else {
                        ((AlertDialog)dialog).setMessage((CharSequence)this.toShowInAlertDialog);
                    }
                    this.toShowInAlertDialog = null;
                    break;
                }
                case 193: 
                case 328: {
                    if (this.toShowInAlertDialog == null) break;
                    AlertDialog ad = (AlertDialog)dialog;
                    ad.setMessage((CharSequence)this.toShowInAlertDialog);
                    this.toShowInAlertDialog = null;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public void setProgress(String string2, int progress, int progressSec, int speed) {
        if (this.dialogObj == null) {
            return;
        }
        try {
            TextView t;
            if (string2 != null && (t = (TextView)this.dialogObj.findViewById(2131230858)) != null) {
                t.setSingleLine(string2.indexOf(8230) < 0);
                t.setText((CharSequence)string2);
            }
            ProgressBar p_bar = (ProgressBar)this.dialogObj.findViewById(2131230859);
            TextView perc_t = (TextView)this.dialogObj.findViewById(2131230860);
            if (progress >= 0) {
                p_bar.setProgress(progress);
            }
            if (progressSec >= 0) {
                p_bar.setSecondaryProgress(progressSec);
            }
            if (perc_t != null) {
                perc_t.setTextSize(14.0f);
                perc_t.setText((CharSequence)("" + (progressSec > 0 ? progressSec : progress) + "%"));
            }
            TextView speed_t = (TextView)this.dialogObj.findViewById(2131230861);
            if (speed > 0) {
                ++this.progressCounter;
                this.progressAcSpeed += (long)speed;
                long avgsp = this.progressAcSpeed / (long)this.progressCounter;
                String str = Utils.getHumanSize(speed) + "/" + this.owner.getString(2131362009) + " (" + Utils.getHumanSize(avgsp) + "/" + this.owner.getString(2131362009) + ")";
                speed_t.setText((CharSequence)str);
            } else if (speed < 0 || progress == 0) {
                speed_t.setText((CharSequence)"");
                this.progressCounter = 0;
                this.progressAcSpeed = 0L;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public void setActiveFile(String fn) {
        this.activeFileName = fn;
    }

    public void setMessageToBeShown(String string2, String cookie_) {
        this.toShowInAlertDialog = string2;
        this.cookie = cookie_;
    }

    public void setCookie(String cookie_) {
        this.cookie = cookie_;
    }

    public void setCredentials(Credentials crd_, int which_panel_, boolean pw_only) {
        this.crd = crd_;
        this.which_panel = which_panel_;
        this.pw_only = pw_only;
    }

    public void onClick(DialogInterface idialog, int whichButton) {
        if (this.dialogObj == null) {
            return;
        }
        try {
            block55: {
                block54: {
                    if (!this.valid || whichButton != -1) break block54;
                    switch (this.dialogId) {
                        case 239: 
                        case 762: 
                        case 2131230721: 
                        case 2131230722: 
                        case 2131230727: 
                        case 2131230728: 
                        case 2131230729: 
                        case 2131230730: 
                        case 2131230731: 
                        case 2131230732: 
                        case 2131230759: 
                        case 2131230763: 
                        case 2131230764: 
                        case 2131230923: 
                        case 2131230924: {
                            EditText edit = (EditText)this.dialogObj.findViewById(2131230802);
                            if (edit == null) break;
                            String file_name = edit.getText().toString();
                            if (!Utils.str(file_name)) {
                                return;
                            }
                            switch (this.dialogId) {
                                case 2131230721: 
                                case 2131230722: {
                                    this.owner.panels.renameItem(file_name, 2131230722 == this.dialogId);
                                    break;
                                }
                                case 2131230727: 
                                case 2131230923: {
                                    this.owner.panels.createNewFile(file_name);
                                    break;
                                }
                                case 2131230728: 
                                case 2131230729: 
                                case 2131230730: 
                                case 2131230731: {
                                    if (file_name.charAt(0) == '/') {
                                        file_name = Utils.escapePath(file_name);
                                    }
                                    boolean touch = this.dialogId == 2131230729 || this.dialogId == 2131230731;
                                    boolean move = this.dialogId == 2131230730 || this.dialogId == 2131230731;
                                    this.owner.panels.copyFiles(file_name, move, touch);
                                    break;
                                }
                                case 2131230732: {
                                    this.owner.panels.createFolder(file_name);
                                    break;
                                }
                                case 2131230759: 
                                case 2131230924: {
                                    String password = null;
                                    CheckBox encrypr_cb = (CheckBox)this.dialogObj.findViewById(2131230829);
                                    if (encrypr_cb.isChecked()) {
                                        EditText pw_edit = (EditText)this.dialogObj.findViewById(2131230817);
                                        password = pw_edit.getText().toString();
                                    }
                                    String encoding = null;
                                    Spinner encoding_spin = (Spinner)this.dialogObj.findViewById(2131230832);
                                    int i = encoding_spin.getSelectedItemPosition();
                                    if (i > 0) {
                                        encoding = this.owner.getResources().getStringArray(2131296264)[i];
                                    }
                                    this.owner.panels.createZip(file_name.trim(), 2131230759 == this.dialogId, password, encoding);
                                    break;
                                }
                                case 2131230764: {
                                    if (file_name.length() == 0) break;
                                    try {
                                        CharSequence mbcs;
                                        CharSequence macs;
                                        String sts;
                                        FilterProps filter = new FilterProps();
                                        filter.file_mask = file_name;
                                        filter.dirs = ((CheckBox)this.dialogObj.findViewById(2131230799)).isChecked();
                                        filter.files = ((CheckBox)this.dialogObj.findViewById(2131230800)).isChecked();
                                        String bts = ((EditText)this.dialogObj.findViewById(2131230805)).getText().toString();
                                        if (bts.length() > 0) {
                                            filter.larger_than = Long.parseLong(bts);
                                        }
                                        if ((sts = ((EditText)this.dialogObj.findViewById(2131230809)).getText().toString()).length() > 0) {
                                            filter.smaller_than = Long.parseLong(sts);
                                        }
                                        java.text.DateFormat df = DateFormat.getDateFormat((Context)this.owner);
                                        if (((CheckBox)this.dialogObj.findViewById(2131230806)).isChecked() && (macs = ((Button)this.dialogObj.findViewById(2131230807)).getText()).length() > 0) {
                                            filter.mod_after = df.parse(macs.toString());
                                        }
                                        if (((CheckBox)this.dialogObj.findViewById(2131230810)).isChecked() && (mbcs = ((Button)this.dialogObj.findViewById(2131230811)).getText()).length() > 0) {
                                            filter.mod_before = df.parse(mbcs.toString());
                                        }
                                        RadioButton rb = (RadioButton)this.dialogObj.findViewById(2131230812);
                                        filter.include_matched = rb.isChecked();
                                        this.owner.panels.setFilter(filter);
                                    }
                                    catch (Exception e) {
                                        Log.e((String)TAG, (String)file_name, (Throwable)e);
                                    }
                                    break;
                                }
                                case 2131230763: {
                                    if (file_name.length() > 0) {
                                        StringBuilder sb = new StringBuilder(128);
                                        sb.append("q=").append(Utils.escapeRest(file_name));
                                        try {
                                            CharSequence mbcs;
                                            CharSequence macs;
                                            String sts;
                                            String bts;
                                            String cs;
                                            boolean one_level_only;
                                            boolean dirs = ((CheckBox)this.dialogObj.findViewById(2131230799)).isChecked();
                                            boolean files = ((CheckBox)this.dialogObj.findViewById(2131230800)).isChecked();
                                            if (dirs != files) {
                                                sb.append(dirs ? "&d=1" : "&f=1");
                                            } else if (!dirs) break;
                                            boolean bl = one_level_only = !((CheckBox)this.dialogObj.findViewById(2131230877)).isChecked();
                                            if (one_level_only) {
                                                sb.append("&o=1");
                                            }
                                            if ((cs = ((EditText)this.dialogObj.findViewById(2131230879)).getText().toString()).length() > 0) {
                                                sb.append("&c=").append(Utils.escapeRest(cs));
                                            }
                                            if ((bts = ((EditText)this.dialogObj.findViewById(2131230805)).getText().toString()).length() > 0) {
                                                sb.append("&l=").append(bts);
                                            }
                                            if ((sts = ((EditText)this.dialogObj.findViewById(2131230809)).getText().toString()).length() > 0) {
                                                sb.append("&s=").append(sts);
                                            }
                                            if (((CheckBox)this.dialogObj.findViewById(2131230806)).isChecked() && (macs = ((Button)this.dialogObj.findViewById(2131230807)).getText()).length() > 0) {
                                                sb.append("&a=").append(macs);
                                            }
                                            if (((CheckBox)this.dialogObj.findViewById(2131230810)).isChecked() && (mbcs = ((Button)this.dialogObj.findViewById(2131230811)).getText()).length() > 0) {
                                                sb.append("&b=").append(mbcs);
                                            }
                                        }
                                        catch (Exception e) {
                                            Log.e((String)TAG, (String)file_name, (Throwable)e);
                                        }
                                        Uri.Builder uri_b = new Uri.Builder().scheme("find").path(this.cookie).encodedQuery(sb.toString());
                                        this.owner.Navigate(uri_b.build(), null, null);
                                        break;
                                    }
                                    break block55;
                                }
                                case 239: 
                                case 762: {
                                    CheckBox for_dirs = (CheckBox)this.dialogObj.findViewById(2131230799);
                                    CheckBox for_files = (CheckBox)this.dialogObj.findViewById(2131230800);
                                    this.owner.panels.checkItems(this.dialogId == 239, file_name, for_dirs.isChecked(), for_files.isChecked());
                                    break;
                                }
                            }
                            break block55;
                        }
                        case 2131230760: {
                            Spinner encoding_spin;
                            int i;
                            Uri.Builder ub = Uri.parse((String)this.activeFileName).buildUpon().scheme("zip");
                            Credentials crd = null;
                            CheckBox encrypr_cb = (CheckBox)this.dialogObj.findViewById(2131230829);
                            if (encrypr_cb.isChecked()) {
                                EditText pw_edit = (EditText)this.dialogObj.findViewById(2131230817);
                                crd = new Credentials(null, pw_edit.getText().toString());
                            }
                            if ((i = (encoding_spin = (Spinner)this.dialogObj.findViewById(2131230832)).getSelectedItemPosition()) > 0) {
                                ub.encodedQuery("e=" + this.owner.getResources().getStringArray(2131296264)[i]);
                            }
                            this.owner.Navigate(ub.build(), crd, null);
                            break;
                        }
                        case 2131230733: 
                        case 2131230734: {
                            this.owner.panels.deleteItems(2131230734 == this.dialogId);
                            break;
                        }
                        case 995: {
                            EditText name_edit = (EditText)this.dialogObj.findViewById(2131230815);
                            EditText pass_edit = (EditText)this.dialogObj.findViewById(2131230817);
                            if (name_edit != null && pass_edit != null) {
                                this.owner.panels.login(new Credentials(name_edit.getText().toString(), pass_edit.getText().toString()), this.which_panel);
                            }
                            this.which_panel = -1;
                            break;
                        }
                        case 2131230765: {
                            this.owner.startViewURIActivity(2131362250);
                            break;
                        }
                        case 275: {
                            this.owner.startViewURIActivity(2131362248);
                            break;
                        }
                        case 245: {
                            this.owner.startViewURIActivity(2131362249);
                            break;
                        }
                        case 328: {
                            this.owner.setResolution(10);
                            break;
                        }
                        case 493: {
                            this.owner.addBgNotifId(this.taskId);
                            this.taskId = 0L;
                            this.cancelDialog();
                        }
                    }
                    break block55;
                }
                if (whichButton == -2) {
                    if (this.dialogId == 493) {
                        this.owner.stopEngine(this.taskId);
                    } else if (this.dialogId == 328) {
                        this.owner.setResolution(1);
                    }
                } else if (whichButton == -3 && this.dialogId == 328) {
                    this.owner.setResolution(12);
                }
            }
            this.owner.panels.focus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DatePickerButton
    implements View.OnClickListener {
        java.text.DateFormat df;
        Calendar cal = Calendar.getInstance();
        Button button;

        public DatePickerButton(Context ctx, Button button_) {
            this.df = DateFormat.getDateFormat((Context)ctx);
            this.button = button_;
            CharSequence cs = this.button.getText();
            if (cs == null || cs.length() == 0) {
                this.button.setText((CharSequence)this.df.format(this.cal.getTime()));
            }
            this.button.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            Date d = null;
            try {
                d = this.df.parse(this.button.getText().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cal.setTime(d == null ? new Date() : d);
            new DatePickerDialog((Context)Dialogs.this.owner, new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker vw, int y, int m, int d) {
                    GregorianCalendar cda = new GregorianCalendar(y, m, d);
                    DatePickerButton.this.button.setText((CharSequence)DatePickerButton.this.df.format(cda.getTime()));
                }
            }, this.cal.get(1), this.cal.get(2), this.cal.get(5)).show();
        }
    }
}

