/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.IBackgroundWork;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;

public class BackgroundWork
extends Service
implements IBackgroundWork {
    private static final String TAG = "BackgroundWork";
    private Engines engines = null;
    private Commander commander = null;
    private WorkerHandler workerHandler = null;
    private final IBinder binder = new BackgroundWorkBinder();

    public void onCreate() {
        super.onCreate();
        this.engines = new Engines();
        this.workerHandler = new WorkerHandler();
    }

    public void onStart(Intent intent, int start_id) {
        super.onStart(intent, start_id);
    }

    public void onDestroy() {
        super.onDestroy();
        this.engines.terminateAll();
        Log.d((String)TAG, (String)"onDestroy");
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void start(Engine engine) {
        engine.setHandler(this.workerHandler);
        this.engines.addAndStart(engine);
    }

    public boolean stopEngine(long task_id) {
        this.engines.remove(task_id);
        return true;
    }

    protected class WorkerHandler
    extends Handler {
        protected WorkerHandler() {
        }

        public void handleMessage(Message msg) {
            Bundle b = msg.getData();
            long id2 = b.getLong("task");
            try {
                Engines.IReciever recipient;
                Engine eng;
                String[] items = b.getStringArray("itms");
                if (items != null && (eng = BackgroundWork.this.engines.get(id2)) != null && (recipient = eng.getReciever()) != null) {
                    int mode = 3;
                    if (b.getBoolean("move")) {
                        mode |= 4;
                    }
                    recipient.receiveItems(items, mode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (BackgroundWork.this.commander == null || BackgroundWork.this.commander.notifyMe(msg)) {
                BackgroundWork.this.engines.remove(id2);
            }
        }
    }

    private class BackgroundWorkBinder
    extends Binder
    implements IBackgroundWork.IBackgroundWorkBinder {
        private BackgroundWorkBinder() {
        }

        public IBackgroundWork init(Commander c) {
            BackgroundWork.this.commander = c;
            return BackgroundWork.this;
        }
    }
}

