-dontobfuscate
# https://stackoverflow.com/questions/9651703/using-proguard-with-android-without-obfuscation
-optimizations !code/simplification/arithmetic,!field/*,!class/merging/*,!code/allocation/variable

# Keep annotations for custom Moshi adapters in SDK
-keep @interface com.meisolsson.githubsdk.core.*

# Keep SearchView (used in menu XML)
-keep class androidx.appcompat.widget.SearchView { *; }

# Keep SimpleXML
-keep class org.simpleframework.xml.**{ *; }
-keepclassmembers class * {
    @org.simpleframework.xml.** *;
}
-keep class com.gh4a.model.GitHubFeed

# Keep attributes for SimpleXML
-keepattributes ElementList, Root

# Warning generated by SimpleXML
-dontwarn javax.xml.stream.**
# Warnings generated by OkHttp
-dontwarn okhttp3.**
-dontwarn okio.**

#
# PrettyTime rules copied from https://github.com/ocpsoft/prettytime/blob/master/core/src/main/resources/META-INF/proguard/prettytime.pro
#
-keep class org.ocpsoft.prettytime.i18n.**

#
# Moshi rules copied from https://github.com/square/moshi/blob/moshi-parent-1.8.0/moshi/src/main/resources/META-INF/proguard/moshi.pro
#

# JSR 305 annotations are for embedding nullability information.
-dontwarn javax.annotation.**

-keepclasseswithmembers class * {
    @com.squareup.moshi.* <methods>;
}

-keep @com.squareup.moshi.JsonQualifier interface *

# Enum field names are used by the integrated EnumJsonAdapter.
# Annotate enums with @JsonClass(generateAdapter = false) to use them with Moshi.
-keepclassmembers @com.squareup.moshi.JsonClass class * extends java.lang.Enum {
    <fields>;
}

# The name of @JsonClass types is used to look up the generated adapter.
-keepnames @com.squareup.moshi.JsonClass class *

# Retain generated JsonAdapters if annotated type is retained.
-if @com.squareup.moshi.JsonClass class *
-keep class <1>JsonAdapter {
    <init>(...);
    <fields>;
}
-if @com.squareup.moshi.JsonClass class **$*
-keep class <1>_<2>JsonAdapter {
    <init>(...);
    <fields>;
}
-if @com.squareup.moshi.JsonClass class **$*$*
-keep class <1>_<2>_<3>JsonAdapter {
    <init>(...);
    <fields>;
}
-if @com.squareup.moshi.JsonClass class **$*$*$*
-keep class <1>_<2>_<3>_<4>JsonAdapter {
    <init>(...);
    <fields>;
}
-if @com.squareup.moshi.JsonClass class **$*$*$*$*
-keep class <1>_<2>_<3>_<4>_<5>JsonAdapter {
    <init>(...);
    <fields>;
}
-if @com.squareup.moshi.JsonClass class **$*$*$*$*$*
-keep class <1>_<2>_<3>_<4>_<5>_<6>JsonAdapter {
    <init>(...);
    <fields>;
}

#
# Retrofit rules copied from https://github.com/square/retrofit/blob/parent-2.5.0/retrofit/src/main/resources/META-INF/proguard/retrofit2.pro
#

# Retrofit does reflection on generic parameters. InnerClasses is required to use Signature and
# EnclosingMethod is required to use InnerClasses.
-keepattributes Signature, InnerClasses, EnclosingMethod

# Retain service method parameters when optimizing.
-keepclassmembers,allowshrinking,allowobfuscation interface * {
    @retrofit2.http.* <methods>;
}

# Ignore annotation used for build tooling.
-dontwarn org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement

# Ignore JSR 305 annotations for embedding nullability information.
-dontwarn javax.annotation.**

# Guarded by a NoClassDefFoundError try/catch and only used when on the classpath.
-dontwarn kotlin.Unit

# Top-level functions that can only be used by Kotlin.
-dontwarn retrofit2.-KotlinExtensions