import 'package:flutter/material.dart';

const lightColorScheme = ColorScheme(
  brightness: Brightness.light,
  primary: Color(0xFF1960A5),
  onPrimary: Color(0xFFFFFFFF),
  primaryContainer: Color(0xFFD4E3FF),
  onPrimaryContainer: Color(0xFF001C39),
  secondary: Color(0xFF295EA7),
  onSecondary: Color(0xFFFFFFFF),
  secondaryContainer: Color(0xFFD6E3FF),
  onSecondaryContainer: Color(0xFF001B3E),
  tertiary: Color(0xFF0062A1),
  onTertiary: Color(0xFFFFFFFF),
  tertiaryContainer: Color(0xFFD0E4FF),
  onTertiaryContainer: Color(0xFF001D35),
  error: Color(0xFFBA1A1A),
  errorContainer: Color(0xFFFFDAD6),
  onError: Color(0xFFFFFFFF),
  onErrorContainer: Color(0xFF410002),
  surface: Color(0xFFFDFBFF),
  onSurface: Color(0xFF001B3D),
  surfaceContainerHighest: Color(0xFFDFE2EB),
  onSurfaceVariant: Color(0xFF43474E),
  outline: Color(0xFF73777F),
  onInverseSurface: Color(0xFFECF0FF),
  inverseSurface: Color(0xFF003062),
  inversePrimary: Color(0xFFA4C9FF),
  shadow: Color(0xFF000000),
  surfaceTint: Color(0xFF1960A5),
  outlineVariant: Color(0xFFC3C6CF),
  scrim: Color(0xFF000000),
);

const darkColorScheme = ColorScheme(
  brightness: Brightness.dark,
  primary: Color(0xFFA4C9FF),
  onPrimary: Color(0xFF00315D),
  primaryContainer: Color(0xFF004883),
  onPrimaryContainer: Color(0xFFD4E3FF),
  secondary: Color(0xFFA9C7FF),
  onSecondary: Color(0xFF003063),
  secondaryContainer: Color(0xFF00468C),
  onSecondaryContainer: Color(0xFFD6E3FF),
  tertiary: Color(0xFF9CCAFF),
  onTertiary: Color(0xFF003257),
  tertiaryContainer: Color(0xFF00497B),
  onTertiaryContainer: Color(0xFFD0E4FF),
  error: Color(0xFFFFB4AB),
  errorContainer: Color(0xFF93000A),
  onError: Color(0xFF690005),
  onErrorContainer: Color(0xFFFFDAD6),
  surface: Color(0xFF001B3D),
  onSurface: Color(0xFFD6E3FF),
  surfaceContainerHighest: Color(0xFF43474E),
  onSurfaceVariant: Color(0xFFC3C6CF),
  outline: Color(0xFF8D9199),
  onInverseSurface: Color(0xFF001B3D),
  inverseSurface: Color(0xFFD6E3FF),
  inversePrimary: Color(0xFF1960A5),
  shadow: Color(0xFF000000),
  surfaceTint: Color(0xFFA4C9FF),
  outlineVariant: Color(0xFF43474E),
  scrim: Color(0xFF000000),
);
