// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v26.1.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

bool _deepEquals(Object? a, Object? b) {
  if (a is List && b is List) {
    return a.length == b.length &&
        a.indexed.every(
          ((int, dynamic) item) => _deepEquals(item.$2, b[item.$1]),
        );
  }
  if (a is Map && b is Map) {
    return a.length == b.length &&
        a.entries.every(
          (MapEntry<Object?, Object?> entry) =>
              (b as Map<Object?, Object?>).containsKey(entry.key) &&
              _deepEquals(entry.value, b[entry.key]),
        );
  }
  return a == b;
}

enum SourceCamera { rear, front }

enum SourceType { camera, gallery }

enum CacheRetrievalType { image, video }

class GeneralOptions {
  GeneralOptions({
    required this.allowMultiple,
    required this.usePhotoPicker,
    this.limit,
  });

  bool allowMultiple;

  bool usePhotoPicker;

  int? limit;

  List<Object?> _toList() {
    return <Object?>[allowMultiple, usePhotoPicker, limit];
  }

  Object encode() {
    return _toList();
  }

  static GeneralOptions decode(Object result) {
    result as List<Object?>;
    return GeneralOptions(
      allowMultiple: result[0]! as bool,
      usePhotoPicker: result[1]! as bool,
      limit: result[2] as int?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! GeneralOptions || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

/// Options for image selection and output.
class ImageSelectionOptions {
  ImageSelectionOptions({this.maxWidth, this.maxHeight, required this.quality});

  /// If set, the max width that the image should be resized to fit in.
  double? maxWidth;

  /// If set, the max height that the image should be resized to fit in.
  double? maxHeight;

  /// The quality of the output image, from 0-100.
  ///
  /// 100 indicates original quality.
  int quality;

  List<Object?> _toList() {
    return <Object?>[maxWidth, maxHeight, quality];
  }

  Object encode() {
    return _toList();
  }

  static ImageSelectionOptions decode(Object result) {
    result as List<Object?>;
    return ImageSelectionOptions(
      maxWidth: result[0] as double?,
      maxHeight: result[1] as double?,
      quality: result[2]! as int,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! ImageSelectionOptions || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class MediaSelectionOptions {
  MediaSelectionOptions({required this.imageSelectionOptions});

  ImageSelectionOptions imageSelectionOptions;

  List<Object?> _toList() {
    return <Object?>[imageSelectionOptions];
  }

  Object encode() {
    return _toList();
  }

  static MediaSelectionOptions decode(Object result) {
    result as List<Object?>;
    return MediaSelectionOptions(
      imageSelectionOptions: result[0]! as ImageSelectionOptions,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! MediaSelectionOptions || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

/// Options for image selection and output.
class VideoSelectionOptions {
  VideoSelectionOptions({this.maxDurationSeconds});

  /// The maximum desired length for the video, in seconds.
  int? maxDurationSeconds;

  List<Object?> _toList() {
    return <Object?>[maxDurationSeconds];
  }

  Object encode() {
    return _toList();
  }

  static VideoSelectionOptions decode(Object result) {
    result as List<Object?>;
    return VideoSelectionOptions(maxDurationSeconds: result[0] as int?);
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! VideoSelectionOptions || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

/// Specification for the source of an image or video selection.
class SourceSpecification {
  SourceSpecification({required this.type, this.camera});

  SourceType type;

  SourceCamera? camera;

  List<Object?> _toList() {
    return <Object?>[type, camera];
  }

  Object encode() {
    return _toList();
  }

  static SourceSpecification decode(Object result) {
    result as List<Object?>;
    return SourceSpecification(
      type: result[0]! as SourceType,
      camera: result[1] as SourceCamera?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! SourceSpecification || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

/// An error that occurred during lost result retrieval.
///
/// The data here maps to the `PlatformException` that will be created from it.
class CacheRetrievalError {
  CacheRetrievalError({required this.code, this.message});

  String code;

  String? message;

  List<Object?> _toList() {
    return <Object?>[code, message];
  }

  Object encode() {
    return _toList();
  }

  static CacheRetrievalError decode(Object result) {
    result as List<Object?>;
    return CacheRetrievalError(
      code: result[0]! as String,
      message: result[1] as String?,
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! CacheRetrievalError || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

/// The result of retrieving cached results from a previous run.
class CacheRetrievalResult {
  CacheRetrievalResult({
    required this.type,
    this.error,
    this.paths = const <String>[],
  });

  /// The type of the retrieved data.
  CacheRetrievalType type;

  /// The error from the last selection, if any.
  CacheRetrievalError? error;

  /// The results from the last selection, if any.
  List<String> paths;

  List<Object?> _toList() {
    return <Object?>[type, error, paths];
  }

  Object encode() {
    return _toList();
  }

  static CacheRetrievalResult decode(Object result) {
    result as List<Object?>;
    return CacheRetrievalResult(
      type: result[0]! as CacheRetrievalType,
      error: result[1] as CacheRetrievalError?,
      paths: (result[2] as List<Object?>?)!.cast<String>(),
    );
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  bool operator ==(Object other) {
    if (other is! CacheRetrievalResult || other.runtimeType != runtimeType) {
      return false;
    }
    if (identical(this, other)) {
      return true;
    }
    return _deepEquals(encode(), other.encode());
  }

  @override
  // ignore: avoid_equals_and_hash_code_on_mutable_classes
  int get hashCode => Object.hashAll(_toList());
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is SourceCamera) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else if (value is SourceType) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    } else if (value is CacheRetrievalType) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    } else if (value is GeneralOptions) {
      buffer.putUint8(132);
      writeValue(buffer, value.encode());
    } else if (value is ImageSelectionOptions) {
      buffer.putUint8(133);
      writeValue(buffer, value.encode());
    } else if (value is MediaSelectionOptions) {
      buffer.putUint8(134);
      writeValue(buffer, value.encode());
    } else if (value is VideoSelectionOptions) {
      buffer.putUint8(135);
      writeValue(buffer, value.encode());
    } else if (value is SourceSpecification) {
      buffer.putUint8(136);
      writeValue(buffer, value.encode());
    } else if (value is CacheRetrievalError) {
      buffer.putUint8(137);
      writeValue(buffer, value.encode());
    } else if (value is CacheRetrievalResult) {
      buffer.putUint8(138);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : SourceCamera.values[value];
      case 130:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : SourceType.values[value];
      case 131:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : CacheRetrievalType.values[value];
      case 132:
        return GeneralOptions.decode(readValue(buffer)!);
      case 133:
        return ImageSelectionOptions.decode(readValue(buffer)!);
      case 134:
        return MediaSelectionOptions.decode(readValue(buffer)!);
      case 135:
        return VideoSelectionOptions.decode(readValue(buffer)!);
      case 136:
        return SourceSpecification.decode(readValue(buffer)!);
      case 137:
        return CacheRetrievalError.decode(readValue(buffer)!);
      case 138:
        return CacheRetrievalResult.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class ImagePickerApi {
  /// Constructor for [ImagePickerApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  ImagePickerApi({
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) : pigeonVar_binaryMessenger = binaryMessenger,
       pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty
           ? '.$messageChannelSuffix'
           : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// Selects images and returns their paths.
  Future<List<String>> pickImages(
    SourceSpecification source,
    ImageSelectionOptions options,
    GeneralOptions generalOptions,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickImages$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[source, options, generalOptions],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<String>();
    }
  }

  /// Selects video and returns their paths.
  Future<List<String>> pickVideos(
    SourceSpecification source,
    VideoSelectionOptions options,
    GeneralOptions generalOptions,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickVideos$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[source, options, generalOptions],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<String>();
    }
  }

  /// Selects images and videos and returns their paths.
  Future<List<String>> pickMedia(
    MediaSelectionOptions mediaSelectionOptions,
    GeneralOptions generalOptions,
  ) async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.image_picker_android.ImagePickerApi.pickMedia$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[mediaSelectionOptions, generalOptions],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<String>();
    }
  }

  /// Returns results from a previous app session, if any.
  Future<CacheRetrievalResult?> retrieveLostResults() async {
    final String pigeonVar_channelName =
        'dev.flutter.pigeon.image_picker_android.ImagePickerApi.retrieveLostResults$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as CacheRetrievalResult?);
    }
  }
}
