import 'dart:io';

import 'package:dart_style/dart_style.dart';
import 'package:html/src/constants.dart';
import 'package:path/path.dart';

/// Run this file to generate package:html/src/trie.dart
void main() {
  final root = <int, dynamic>{};
  for (final entity in entities.keys) {
    var node = root;
    for (final charCode in entity.codeUnits) {
      node = (node[charCode] ??= <int, dynamic>{}) as Map<int, dynamic>;
    }
  }
  final source =
      '''// AUTO GENERATED by 'tool/generate_trie.dart'. DO NOT EDIT!\n'''
              'const entitiesTrieRoot = $root;'
          .replaceAll('{}', '<int, dynamic>{}');
  final formatted = DartFormatter().format(source);
  final htmlDir = File(Platform.script.path).parent.parent;
  File(join(htmlDir.path, 'lib', 'src', 'trie.dart'))
      .writeAsStringSync(formatted);
}
