/*
 * Copyright 2017 Adam Feinstein
 *
 * This file is part of MTG Familiar.
 *
 * MTG Familiar is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * MTG Familiar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MTG Familiar.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.gelakinetic.mtgfam.helpers;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.Html.ImageGetter;
import android.text.Spanned;
import android.text.SpannedString;

import androidx.core.content.ContextCompat;

import com.gelakinetic.mtgfam.R;

/**
 * This class replaces text with mana symbols and other glyphs. It does so using Html.fromHtml and custom-processing
 * <img> tags
 * TODO make the whole thing static? subclass ImageGetter?
 */
public class ImageGetterHelper {

    private final static int[] drawableNumbers = {R.drawable.glyph_0, R.drawable.glyph_1, R.drawable.glyph_2,
            R.drawable.glyph_3, R.drawable.glyph_4, R.drawable.glyph_5, R.drawable.glyph_6, R.drawable.glyph_7,
            R.drawable.glyph_8, R.drawable.glyph_9, R.drawable.glyph_10, R.drawable.glyph_11, R.drawable.glyph_12,
            R.drawable.glyph_13, R.drawable.glyph_14, R.drawable.glyph_15, R.drawable.glyph_16, R.drawable.glyph_17,
            R.drawable.glyph_18, R.drawable.glyph_19, R.drawable.glyph_20};

    /**
     * Jellybean had a weird bug, and this fixes it. Silly google!
     * https://code.google.com/p/android/issues/detail?id=35466#c2
     *
     * @param source      The string to add glyphs to
     * @param imageGetter the custom imageGetter, returned by GlyphGetter
     * @return the Spanned with shiny new glyphs
     */
    public static Spanned formatStringWithGlyphs(String source, ImageGetter imageGetter) {
        /* Make sure we're not formatting a null string */
        if (source == null) {
            return new SpannedString("");
        }
        source = source.replace("{", "<img src=\"").replace("}", "\"/>");
        return Html.fromHtml(source, imageGetter, null);
    }

    /**
     * Same weird bug as above, but without the custom imageGetter / tagHandler
     *
     * @param source A string of HTML
     * @return a formatted Spanned which JellyBean is happy with
     */
    public static Spanned formatHtmlString(String source) {
        /* Make sure we're not formatting a null string */
        if (source == null) {
            return new SpannedString("");
        }
        return Html.fromHtml(source);
    }

    /**
     * This function returns a custom ImageGetter which replaces glyphs with text.
     * This could have been a new subclass of ImageGetter with a constructor that takes a resource, but I guess
     * I didn't feel like writing it that way on that day.
     *
     * @param context the context to get resources to get drawables from
     * @return a custom ImageGetter
     */
    public static ImageGetter GlyphGetter(final Context context) {
        return source -> {
            Drawable d = null;
            source = source.replace("/", "");

            final int tapRes = PreferenceAdapter.getTapSymbol(context);
            final int wRes = PreferenceAdapter.getWhiteSymbol(context);

            if (source.equalsIgnoreCase("w")) {
                d = ContextCompat.getDrawable(context, wRes);//ContextCompat.getDrawable(context, R.drawable.glyph_w, null);
            } else if (source.equalsIgnoreCase("u")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_u);
            } else if (source.equalsIgnoreCase("b")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_b);
            } else if (source.equalsIgnoreCase("r")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_r);
            } else if (source.equalsIgnoreCase("g")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_g);
            } else if (source.equalsIgnoreCase("t")) {
                d = ContextCompat.getDrawable(context, tapRes);
            } else if (source.equalsIgnoreCase("q")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_untap);
            } else if (source.equalsIgnoreCase("wu") || source.equalsIgnoreCase("uw")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_wu);
            } else if (source.equalsIgnoreCase("ub") || source.equalsIgnoreCase("bu")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_ub);
            } else if (source.equalsIgnoreCase("br") || source.equalsIgnoreCase("rb")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_br);
            } else if (source.equalsIgnoreCase("rg") || source.equalsIgnoreCase("gr")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_rg);
            } else if (source.equalsIgnoreCase("gw") || source.equalsIgnoreCase("wg")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_gw);
            } else if (source.equalsIgnoreCase("wb") || source.equalsIgnoreCase("bw")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_wb);
            } else if (source.equalsIgnoreCase("bg") || source.equalsIgnoreCase("gb")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_bg);
            } else if (source.equalsIgnoreCase("gu") || source.equalsIgnoreCase("ug")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_gu);
            } else if (source.equalsIgnoreCase("ur") || source.equalsIgnoreCase("ru")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_ur);
            } else if (source.equalsIgnoreCase("rw") || source.equalsIgnoreCase("wr")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_rw);
            } else if (source.equalsIgnoreCase("2w") || source.equalsIgnoreCase("w2")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_w2);
            } else if (source.equalsIgnoreCase("2u") || source.equalsIgnoreCase("u2")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_u2);
            } else if (source.equalsIgnoreCase("2b") || source.equalsIgnoreCase("b2")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_b2);
            } else if (source.equalsIgnoreCase("2r") || source.equalsIgnoreCase("r2")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_r2);
            } else if (source.equalsIgnoreCase("2g") || source.equalsIgnoreCase("g2")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_g2);
            } else if (source.equalsIgnoreCase("s")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_s);
            } else if (source.equalsIgnoreCase("pw") || source.equalsIgnoreCase("wp")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_pw);
            } else if (source.equalsIgnoreCase("pu") || source.equalsIgnoreCase("up")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_pu);
            } else if (source.equalsIgnoreCase("pb") || source.equalsIgnoreCase("bp")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_pb);
            } else if (source.equalsIgnoreCase("pr") || source.equalsIgnoreCase("rp")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_pr);
            } else if (source.equalsIgnoreCase("pg") || source.equalsIgnoreCase("gp")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_pg);
            } else if (source.equalsIgnoreCase("cw") || source.equalsIgnoreCase("wc")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_cw);
            } else if (source.equalsIgnoreCase("cu") || source.equalsIgnoreCase("uc")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_cu);
            } else if (source.equalsIgnoreCase("cb") || source.equalsIgnoreCase("bc")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_cb);
            } else if (source.equalsIgnoreCase("cr") || source.equalsIgnoreCase("rc")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_cr);
            } else if (source.equalsIgnoreCase("cg") || source.equalsIgnoreCase("gc")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_cg);
            } else if (source.equalsIgnoreCase("p")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_p);
            } else if (source.equalsIgnoreCase("bgp") || source.equalsIgnoreCase("bpg") || source.equalsIgnoreCase("gbp") || source.equalsIgnoreCase("gpb") || source.equalsIgnoreCase("pbg") || source.equalsIgnoreCase("pgb")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_bgp);
            } else if (source.equalsIgnoreCase("brp") || source.equalsIgnoreCase("bpr") || source.equalsIgnoreCase("rbp") || source.equalsIgnoreCase("rpb") || source.equalsIgnoreCase("pbr") || source.equalsIgnoreCase("prb")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_brp);
            } else if (source.equalsIgnoreCase("gup") || source.equalsIgnoreCase("gpu") || source.equalsIgnoreCase("ugp") || source.equalsIgnoreCase("upg") || source.equalsIgnoreCase("pgu") || source.equalsIgnoreCase("pug")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_gup);
            } else if (source.equalsIgnoreCase("gwp") || source.equalsIgnoreCase("gpw") || source.equalsIgnoreCase("wgp") || source.equalsIgnoreCase("wpg") || source.equalsIgnoreCase("pgw") || source.equalsIgnoreCase("pwg")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_gwp);
            } else if (source.equalsIgnoreCase("rgp") || source.equalsIgnoreCase("rpg") || source.equalsIgnoreCase("grp") || source.equalsIgnoreCase("gpr") || source.equalsIgnoreCase("prg") || source.equalsIgnoreCase("pgr")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_rgp);
            } else if (source.equalsIgnoreCase("rwp") || source.equalsIgnoreCase("rpw") || source.equalsIgnoreCase("wrp") || source.equalsIgnoreCase("wpr") || source.equalsIgnoreCase("prw") || source.equalsIgnoreCase("pwr")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_rwp);
            } else if (source.equalsIgnoreCase("ubp") || source.equalsIgnoreCase("upb") || source.equalsIgnoreCase("bup") || source.equalsIgnoreCase("bpu") || source.equalsIgnoreCase("pub") || source.equalsIgnoreCase("pbu")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_ubp);
            } else if (source.equalsIgnoreCase("urp") || source.equalsIgnoreCase("upr") || source.equalsIgnoreCase("rup") || source.equalsIgnoreCase("rpu") || source.equalsIgnoreCase("pur") || source.equalsIgnoreCase("pru")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_urp);
            } else if (source.equalsIgnoreCase("wbp") || source.equalsIgnoreCase("wpb") || source.equalsIgnoreCase("bwp") || source.equalsIgnoreCase("bpw") || source.equalsIgnoreCase("pwb") || source.equalsIgnoreCase("pbw")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_wbp);
            } else if (source.equalsIgnoreCase("wup") || source.equalsIgnoreCase("wpu") || source.equalsIgnoreCase("uwp") || source.equalsIgnoreCase("upw") || source.equalsIgnoreCase("pwu") || source.equalsIgnoreCase("puw")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_wup);
            } else if (source.equalsIgnoreCase("+oo")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_inf);
            } else if (source.equalsIgnoreCase("100")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_100);
            } else if (source.equalsIgnoreCase("1000000")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_1000000);
            } else if (source.equalsIgnoreCase("hr") || source.equalsIgnoreCase("rh")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_hr);
            } else if (source.equalsIgnoreCase("hw") || source.equalsIgnoreCase("wh")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_hw);
            } else if (source.equalsIgnoreCase("½")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_half);
            } else if (source.equalsIgnoreCase("c")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_c);
            } else if (source.equalsIgnoreCase("chaos")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_chaos);
            } else if (source.equalsIgnoreCase("z")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_z);
            } else if (source.equalsIgnoreCase("y")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_y);
            } else if (source.equalsIgnoreCase("x")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_x);
            } else if (source.equalsIgnoreCase("h")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_h);
            } else if (source.equalsIgnoreCase("pwk")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_pwk);
            } else if (source.equalsIgnoreCase("e")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_e);
            } else if (source.equalsIgnoreCase("a")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_a);
            } else if (source.equalsIgnoreCase("tk")) {
                d = ContextCompat.getDrawable(context, R.drawable.glyph_tk);
            } else {
                for (int i = 0; i < drawableNumbers.length; i++) {
                    if (source.equals(Integer.toString(i))) {
                        d = ContextCompat.getDrawable(context, drawableNumbers[i]);
                    }
                }
            }

            if (d == null) {
                return null;
            }

            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
            return d;
        };
    }
}