/*
 * Copyright (c) 2025 Meshtastic LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

plugins {
    alias(libs.plugins.kover)
    alias(libs.plugins.meshtastic.android.library)
    alias(libs.plugins.meshtastic.kotlinx.serialization)
    alias(libs.plugins.kotlin.parcelize)
}

android {
    buildFeatures {
        buildConfig = true
        aidl = true
    }
    namespace = "org.meshtastic.core.model"
}

dependencies {
    implementation(projects.core.proto)
    implementation(projects.core.strings)

    implementation(libs.androidx.annotation)
    implementation(libs.timber)
    implementation(libs.zxing.android.embedded) { isTransitive = false }
    implementation(libs.zxing.core)

    testImplementation(libs.androidx.core.ktx)
    testImplementation(libs.junit)

    androidTestImplementation(libs.androidx.test.ext.junit)
}
