/*
 * Geekttrss is a RSS feed reader application on the Android Platform.
 *
 * Copyright (C) 2017-2025 by Frederic-Charles Barthelery.
 *
 * This file is part of Geekttrss.
 *
 * Geekttrss is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Geekttrss is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Geekttrss.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.geekorum.ttrss.providers

import androidx.room.Dao
import androidx.room.Query

/**
 * Dao to purge old articles from database
 */
@Dao
interface PurgeArticlesDao {
    @Query("DELETE FROM articles WHERE unread=0 AND marked=0 AND published=0 and last_time_update<=:beforeTimeSec")
    fun deleteNonImportantArticlesBeforeTime(beforeTimeSec: Long): Int
}
