/*
 * Geekttrss is a RSS feed reader application on the Android Platform.
 *
 * Copyright (C) 2017-2025 by Frederic-Charles Barthelery.
 *
 * This file is part of Geekttrss.
 *
 * Geekttrss is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Geekttrss is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Geekttrss.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.geekorum.ttrss

import android.content.Intent
import android.os.Bundle
import androidx.activity.viewModels
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.lifecycleScope
import androidx.lifecycle.repeatOnLifecycle
import com.geekorum.geekdroid.app.lifecycle.EventObserver
import com.geekorum.ttrss.articles_list.ArticleListActivity
import com.geekorum.ttrss.articles_list.TtrssAccountViewModel
import com.geekorum.ttrss.core.BaseActivity
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.launch

private val UseSingleActivity = false

@AndroidEntryPoint
class MainActivity : BaseActivity() {

    private val accountViewModel: TtrssAccountViewModel by viewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        lifecycleScope.launch {
            repeatOnLifecycle(Lifecycle.State.CREATED) {
                accountViewModel.selectedAccount.collect { account ->
                    if (account != null) {
                        val intent = if (UseSingleActivity)
                            Intent(this@MainActivity, SingleActivity::class.java)
                        else
                            Intent(this@MainActivity, ArticleListActivity::class.java)
                        startActivity(intent)
                        finish()
                    } else {
                        accountViewModel.startSelectAccountActivity(this@MainActivity)
                    }
                }
            }
        }
        accountViewModel.noAccountSelectedEvent.observe(this, EventObserver { finish() })
    }
}
