/*
 * Geekttrss is a RSS feed reader application on the Android Platform.
 *
 * Copyright (C) 2017-2025 by Frederic-Charles Barthelery.
 *
 * This file is part of Geekttrss.
 *
 * Geekttrss is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Geekttrss is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Geekttrss.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.geekorum.ttrss.logging

import com.geekorum.geekdroid.firebase.logging.FirebaseCrashlyticsLoggingTree
import com.google.firebase.crashlytics.FirebaseCrashlytics
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import dagger.multibindings.IntoSet
import timber.log.Timber

/**
 * Provides logging output to Crashlytics
 */
@Module(includes = [TimberModule::class])
@InstallIn(SingletonComponent::class)
class CrashlyticsLoggingModule {
    @Provides
    @IntoSet
    fun provideCrashlyticsLoggingTree(): Timber.Tree = FirebaseCrashlyticsLoggingTree(FirebaseCrashlytics.getInstance())

}
