package com.futsch1.medtimer.overview

import android.content.Intent
import android.text.InputType
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import com.futsch1.medtimer.LogTags
import com.futsch1.medtimer.R
import com.futsch1.medtimer.helpers.DialogHelper
import com.futsch1.medtimer.reminders.AlarmProcessor
import com.futsch1.medtimer.reminders.ReminderWorkerReceiver
import com.futsch1.medtimer.reminders.notificationData.ReminderNotificationData

fun customSnoozeDialog(activity: AppCompatActivity, intent: Intent) {
    val reminderNotificationData = ReminderNotificationData.fromBundle(intent.extras!!)

    if (!reminderNotificationData.valid) {
        return
    }
    // Cancel a potential repeat alarm
    AlarmProcessor(activity).cancelPendingReminderNotifications(reminderNotificationData)

    DialogHelper(activity)
        .title(R.string.snooze_duration)
        .hint(R.string.minutes_string)
        .initialText("")
        .inputType(InputType.TYPE_NUMBER_FLAG_SIGNED or InputType.TYPE_CLASS_NUMBER)
        .textSink { snoozeTime: String? ->
            val snoozeTimeInt = snoozeTime?.toIntOrNull()
            if (snoozeTimeInt != null) {
                ReminderWorkerReceiver.requestSnooze(activity, reminderNotificationData, snoozeTimeInt)
            }
        }
        .cancelCallback {
            Log.d(LogTags.REMINDER, "Snooze dialog cancelled")
        }
        .show()

}
