[![Build](https://github.com/Futsch1/medTimer/actions/workflows/build.yml/badge.svg)](https://github.com/Futsch1/medTimer/actions/workflows/build.yml)
[![Unit test](https://github.com/Futsch1/medTimer/actions/workflows/test.yml/badge.svg)](https://github.com/Futsch1/medTimer/actions/workflows/test.yml)
[![Maintainability](https://qlty.sh/badges/f4b5a014-c24a-47d9-9ca8-89b806c98943/maintainability.svg)](https://qlty.sh/gh/Futsch1/projects/medTimer)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=Futsch1_medTimer&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=Futsch1_medTimer)
[![Coverage](https://sonarcloud.io/api/project_badges/measure?project=Futsch1_medTimer&metric=coverage)](https://sonarcloud.io/summary/new_code?id=Futsch1_medTimer)
[![OpenSSF Scorecard](https://api.scorecard.dev/projects/github.com/Futsch1/medTimer/badge)](https://scorecard.dev/viewer/?uri=github.com/Futsch1/medTimer)
[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/9439/badge)](https://www.bestpractices.dev/projects/9439)

# MedTimer for Android

![Feature Graphic](fastlane/metadata/android/en-US/images/featureGraphic.png)

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/com.futsch1.medtimer/)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png"
alt="Get it on IzzyOnDroid"
height="80">](https://apt.izzysoft.de/fdroid/index/apk/com.futsch1.medtimer)
[<img src="https://www.openapk.net/images/openapk-badge.png"
alt="Get it on OpenApk"
height="80">](https://www.openapk.net/medtimer/com.futsch1.medtimer/)
[<img src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png"
alt="Get it on Google Play"
height="80">](https://play.google.com/store/apps/details?id=com.futsch1.medtimer)

Or download the latest APK from
the [Releases Section](https://github.com/Futsch1/medTimer/releases/latest).

## Description

**Med reminders and history with full offline privacy**

<p float="left">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="150" />
  &nbsp;
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="150" />
  &nbsp;
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="150" />
  &nbsp;
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width="150" />

  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" width="150" />

  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.png" width="150" />
  &nbsp;
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.png" width="150" />

  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/8.png" width="150" />
</p>

Stay In Control of Your Medications with MedTimer

MedTimer is an open-source medication reminder app designed to help you manage your medications and
pills effectively and with full control of your sensitive data.

Flexible & Personalized Reminders:

- Manage unlimited medications with customizable reminders per medication (including simple defaults
  for daily reminders).
- Create flexible reminders with breaks and specific days (e.g. for birth control pills).
- Weekend mode: Delay reminders to a defined time on chosen days.
- Snooze notifications for later reminders or be reminded repeatedly.
- Add extra doses on the fly.
- Create interval based reminders, reminders following each other in intervals or interval reminders
  constrained with a start and end time per day.
- Use alarm type reminders to ensure notification even when the device is set to silent mode.

Simple & Secure Data Management:

- Confirm or dismiss reminders to record medication adherence accurately.
- Get an overview of past doses in a chart, tabular or calendar view.
- Export your medication history as a CSV file for easy record-keeping or sharing with healthcare
  professionals.
- Backup and restore your medication list as JSON file.
- Medication stock tracking and out of stock reminders.
- Tag and filter your medication.

Privacy & Offline Accessibility:

- All data is stored securely on your device, ensuring complete privacy and offline accessibility.
- No internet connection required – your medication reminders are always available.

MedTimer is a free app without adds.

## Documentation

See the [use cases documentation](doc/UseCases.md) for more details on how to use the app and
the specific use cases it can satisfy.

Some details of the reminder flow is documented in the [reminder flow documentation](doc/reminder_flow.md).

## Contributing

See the [contributing guide](CONTRIBUTING.md) for details on how to contribute.

If you want to contribute a translation, be welcomed to use
[Weblate](https://hosted.weblate.org/projects/medtimer/).

## Sponsor or support

If you like my work, you can [buy me a coffee](https://www.buymeacoffee.com/futsch1). Note
however that I will donate all the money I receive from your support to organizations supporting
open-source or open knowledge, like the Mozilla Foundation, or the Apache Software Foundation or
Wikimedia.

## Dependencies

MedTimer uses the following great open source libraries and dependencies:

- [Bootstrap icon](https://icons.getbootstrap.com/)
- [TableView](https://github.com/evrencoskun/TableView)
- [androidplot](https://github.com/halfhp/androidplot)
- [SimplyPDF](https://github.com/wwdablu/SimplyPDF)
- [AndroidX Preference eXtended](https://github.com/takisoft/preferencex-android)
- [Mockito](https://github.com/mockito/mockito)
- [Robolectric](https://github.com/robolectric/robolectric)
- [Calendar](https://github.com/kizitonwose/Calendar)
- [IconDialog](https://github.com/maltaisn/icondialoglib)
- [HSV-Alpha Color Picker for Android](https://github.com/martin-stone/hsv-alpha-color-picker-android)

Feature graphics generated using [hotpot.ai](https://hotpot.ai)
