package net.thunderbird.feature.notification.api.ui.icon.atom

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

@Suppress("MagicNumber", "MaxLineLength")
internal val NewEmail: ImageVector
    get() {
        val current = _newEmail
        if (current != null) return current

        return ImageVector.Builder(
            name = "net.thunderbird.feature.notification.api.ui.icon.atom.NewEmail",
            defaultWidth = 24.0.dp,
            defaultHeight = 24.0.dp,
            viewportWidth = 960.0f,
            viewportHeight = 960.0f,
        ).apply {
            path(
                fill = SolidColor(Color(0xFFFFFFFF)),
            ) {
                moveTo(x = 160.0f, y = 800.0f)
                quadTo(x1 = 127.0f, y1 = 800.0f, x2 = 103.5f, y2 = 776.5f)
                quadTo(x1 = 80.0f, y1 = 753.0f, x2 = 80.0f, y2 = 720.0f)
                lineTo(x = 80.0f, y = 240.0f)
                quadTo(x1 = 80.0f, y1 = 207.0f, x2 = 103.5f, y2 = 183.5f)
                quadTo(x1 = 127.0f, y1 = 160.0f, x2 = 160.0f, y2 = 160.0f)
                lineTo(x = 564.0f, y = 160.0f)
                quadTo(x1 = 560.0f, y1 = 180.0f, x2 = 560.0f, y2 = 200.0f)
                quadTo(x1 = 560.0f, y1 = 220.0f, x2 = 564.0f, y2 = 240.0f)
                lineTo(x = 160.0f, y = 240.0f)
                lineTo(x = 480.0f, y = 440.0f)
                lineTo(x = 626.0f, y = 349.0f)
                quadTo(x1 = 640.0f, y1 = 362.0f, x2 = 656.5f, y2 = 371.5f)
                quadTo(x1 = 673.0f, y1 = 381.0f, x2 = 691.0f, y2 = 388.0f)
                lineTo(x = 480.0f, y = 520.0f)
                lineTo(x = 160.0f, y = 320.0f)
                lineTo(x = 160.0f, y = 720.0f)
                quadTo(x1 = 160.0f, y1 = 720.0f, x2 = 160.0f, y2 = 720.0f)
                quadTo(x1 = 160.0f, y1 = 720.0f, x2 = 160.0f, y2 = 720.0f)
                lineTo(x = 800.0f, y = 720.0f)
                quadTo(x1 = 800.0f, y1 = 720.0f, x2 = 800.0f, y2 = 720.0f)
                quadTo(x1 = 800.0f, y1 = 720.0f, x2 = 800.0f, y2 = 720.0f)
                lineTo(x = 800.0f, y = 396.0f)
                quadTo(x1 = 823.0f, y1 = 391.0f, x2 = 843.0f, y2 = 382.0f)
                quadTo(x1 = 863.0f, y1 = 373.0f, x2 = 880.0f, y2 = 360.0f)
                lineTo(x = 880.0f, y = 720.0f)
                quadTo(x1 = 880.0f, y1 = 753.0f, x2 = 856.5f, y2 = 776.5f)
                quadTo(x1 = 833.0f, y1 = 800.0f, x2 = 800.0f, y2 = 800.0f)
                lineTo(x = 160.0f, y = 800.0f)
                close()
                moveTo(x = 160.0f, y = 240.0f)
                lineTo(x = 160.0f, y = 240.0f)
                lineTo(x = 160.0f, y = 240.0f)
                lineTo(x = 160.0f, y = 720.0f)
                quadTo(x1 = 160.0f, y1 = 720.0f, x2 = 160.0f, y2 = 720.0f)
                quadTo(x1 = 160.0f, y1 = 720.0f, x2 = 160.0f, y2 = 720.0f)
                lineTo(x = 160.0f, y = 720.0f)
                quadTo(x1 = 160.0f, y1 = 720.0f, x2 = 160.0f, y2 = 720.0f)
                quadTo(x1 = 160.0f, y1 = 720.0f, x2 = 160.0f, y2 = 720.0f)
                lineTo(x = 160.0f, y = 240.0f)
                quadTo(x1 = 160.0f, y1 = 240.0f, x2 = 160.0f, y2 = 240.0f)
                quadTo(x1 = 160.0f, y1 = 240.0f, x2 = 160.0f, y2 = 240.0f)
                quadTo(x1 = 160.0f, y1 = 240.0f, x2 = 160.0f, y2 = 240.0f)
                quadTo(x1 = 160.0f, y1 = 240.0f, x2 = 160.0f, y2 = 240.0f)
                close()
                moveTo(x = 760.0f, y = 320.0f)
                quadTo(x1 = 710.0f, y1 = 320.0f, x2 = 675.0f, y2 = 285.0f)
                quadTo(x1 = 640.0f, y1 = 250.0f, x2 = 640.0f, y2 = 200.0f)
                quadTo(x1 = 640.0f, y1 = 150.0f, x2 = 675.0f, y2 = 115.0f)
                quadTo(x1 = 710.0f, y1 = 80.0f, x2 = 760.0f, y2 = 80.0f)
                quadTo(x1 = 810.0f, y1 = 80.0f, x2 = 845.0f, y2 = 115.0f)
                quadTo(x1 = 880.0f, y1 = 150.0f, x2 = 880.0f, y2 = 200.0f)
                quadTo(x1 = 880.0f, y1 = 250.0f, x2 = 845.0f, y2 = 285.0f)
                quadTo(x1 = 810.0f, y1 = 320.0f, x2 = 760.0f, y2 = 320.0f)
                close()
            }
        }.build().also { _newEmail = it }
    }

@Suppress("ObjectPropertyName")
private var _newEmail: ImageVector? = null
