# 🤝 Contributing to Thunderbird for Android

Welcome to the Thunderbird for Android project! We're excited to have you here and welcome your contributions.

## 🌱 New Contributor Essentials

Before you start contributing, please take a moment to familiarize yourself with the following:

- [About Thunderbird for Android](about.md).
- [Thunderbird Developer Portal](https://developer.thunderbird.net/)
- [Mozilla Community Participation Guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/)
- [Matrix (developer chat)](https://matrix.to/#/#tb-mobile-dev:mozilla.org)
- [Frequently Asked Questions (historical K-9 forum)](https://forum.k9mail.app/c/faq)
- [Support Forum (historical K-9 forum)](https://forum.k9mail.app/)

Note: Some support resources currently point to the K-9 Mail forum due to the project’s history and ongoing migration.
Where appropriate, we’ll update links to Thunderbird-specific channels.

### 📋 Recommended knowledge

Helpful background (not strictly required):

- **[Kotlin](https://kotlinlang.org/docs/home.html)** - Primary programming language for the project
- **[Jetpack Compose](https://developer.android.com/jetpack/compose)** - UI toolkit used for Android
- **[Kotlin Multiplatform](https://kotlinlang.org/docs/multiplatform.html)** - Shared code across modules where applicable
- **[Android Development](https://developer.android.com/guide)** - Basic understanding of Android app development
- **[GitHub](https://docs.github.com/en)** - For managing contributions and pull requests

## 🐛 Bug Reports and Feature Ideas

When you encounter a bug or have a feature request or idea, please do the following:

**Bugs**:
- Search for [existing issues](https://github.com/thunderbird/thunderbird-android/issues?q=is%3Aissue) before filing a new one.
- If you can't find an existing issue, please [open a new GitHub issue](https://github.com/thunderbird/thunderbird-android/issues/new/choose) using the appropriate template.

**Feature Requests / Ideas:**

We don’t track new ideas or feature requests in GitHub Issues.

- Start a discussion in [Mozilla Connect – Ideas](https://connect.mozilla.org/t5/ideas/idb-p/ideas/label-name/thunderbird%20android)
- Once a feature is accepted and work is planned, maintainers will create the corresponding GitHub issue(s).

## 🌐 Translations

If you'd like to help to translate Thunderbird for Android, please visit:

- **[Translations](contributing/translations.md)** – How to help localize Thunderbird for Android via Weblate.
- **[Weblate - Thunderbird for Android project](https://hosted.weblate.org/projects/tb-android/)** - Translation platform where all localization happens.

## 🤝 Contributing Code

This should give you a detailed overview on how to contribute code to the project. Use it as a reference for setup,
development, testing, and review.

### 🚀 Getting Started

* **[Contribution Workflow](contributing/contribution-workflow.md)** – Step-by-step process: find an issue, fork, branch, commit, PR.
* **[Development Environment](contributing/development-environment.md)** – How to set up Android Studio, build, run, and debug the project.

### 🏗️ Development Practices

* **[Architecture](architecture/README.md)** – System design: module types, UI/Domain/Data layers, offline-first.
* **[Development Guidelines](contributing/development-guide.md)** – Project-specific conventions and quick “do’s & don’ts.”
* **[Code Quality Guide](contributing/code-quality-guide.md)** – Style rules, static analysis tools, and security practices.
* **[Testing Guide](contributing/testing-guide.md)** – Test layers, frameworks, and best practices.

### 🔍 Reviews & Collaboration

* **[Git Commit Guide](contributing/git-commit-guide.md)** – How to write clear, Conventional Commit-style messages.
* **[Code Review Guide](contributing/code-review-guide.md)** – Expectations for PR authors and reviewers, review etiquette.

### 🌐 Translations

* **[Translations](contributing/translations.md)** – How to help localize Thunderbird for Android via Weblate.
* **[Managing Strings](contributing/managing-strings.md)** – Developer guide for adding/changing/removing strings, languages, and handling Weblate sync.

## Thank You!

Thank you for taking the time to contribute to Thunderbird for Android! We appreciate your help in making the project better and more useful for everyone.
