package app.k9mail.feature.account.server.settings.domain.usecase

import assertk.assertThat
import assertk.assertions.isInstanceOf
import assertk.assertions.prop
import net.thunderbird.core.common.domain.usecase.validation.ValidationResult
import org.junit.Test

class ValidateUsernameTest {

    private val testSubject = ValidateUsername()

    @Test
    fun `should succeed when username is set`() {
        val result = testSubject.execute("username")

        assertThat(result).isInstanceOf<ValidationResult.Success>()
    }

    @Test
    fun `should fail when username is empty`() {
        val result = testSubject.execute("")

        assertThat(result).isInstanceOf<ValidationResult.Failure>()
            .prop(ValidationResult.Failure::error)
            .isInstanceOf<ValidateUsername.ValidateUsernameError.EmptyUsername>()
    }

    @Test
    fun `should fail when username is blank`() {
        val result = testSubject.execute(" ")

        assertThat(result).isInstanceOf<ValidationResult.Failure>()
            .prop(ValidationResult.Failure::error)
            .isInstanceOf<ValidateUsername.ValidateUsernameError.EmptyUsername>()
    }
}
