package app.k9mail.core.ui.compose.theme2.thunderbird

import androidx.compose.ui.graphics.Color
import app.k9mail.core.ui.compose.theme2.ThemeColorScheme

internal val lightThemeColorScheme = ThemeColorScheme(
    primary = Color(color = 0xFF004F9B),
    onPrimary = Color(color = 0xFFFFFFFF),
    primaryContainer = Color(color = 0xFF1373D9),
    onPrimaryContainer = Color(color = 0xFFFFFFFF),

    secondary = Color(color = 0xFF003D75),
    onSecondary = Color(color = 0xFFFFFFFF),
    secondaryContainer = Color(color = 0xFF2E61A0),
    onSecondaryContainer = Color(color = 0xFFFFFFFF),

    tertiary = Color(color = 0xFF54008E),
    onTertiary = Color(color = 0xFFFFFFFF),
    tertiaryContainer = Color(color = 0xFF7B35B8),
    onTertiaryContainer = Color(color = 0xFFFFFFFF),

    error = Color(color = 0xFF7F1D1D),
    onError = Color(color = 0xFFFFFFFF),
    errorContainer = Color(color = 0xFFFEF2F2),
    onErrorContainer = Color(color = 0xFF7F1D1D),

    surfaceDim = Color(color = 0xFFDCD9D9),
    surface = Color(color = 0xFFFCF8F8),
    surfaceBright = Color(color = 0xFFFCF8F8),
    onSurface = Color(color = 0xFF1C1B1B),
    onSurfaceVariant = Color(color = 0xFF45474A),

    surfaceContainerLowest = Color(color = 0xFFFFFFFF),
    surfaceContainerLow = Color(color = 0xFFF6F3F2),
    surfaceContainer = Color(color = 0xFFF1EDEC),
    surfaceContainerHigh = Color(color = 0xFFEBE7E7),
    surfaceContainerHighest = Color(color = 0xFFE5E2E1),

    inverseSurface = Color(color = 0xFF313030),
    inverseOnSurface = Color(color = 0xFFF3F0EF),
    inversePrimary = Color(color = 0xFFA9C7FF),

    outline = Color(color = 0xFF75777A),
    outlineVariant = Color(color = 0xFFC5C6CA),

    scrim = Color.Black,

    info = Color(color = 0xFF004F9B),
    onInfo = Color(color = 0xFFFFFFFF),
    infoContainer = Color(color = 0xFFF0F8FF),
    onInfoContainer = Color(color = 0xFF004F9B),

    success = Color(color = 0xFF194E2C),
    onSuccess = Color(color = 0xFFFFFFFF),
    successContainer = Color(color = 0xFFF4F9F4),
    onSuccessContainer = Color(color = 0xFF194E2C),

    warning = Color(color = 0xFF713F12),
    onWarning = Color(color = 0xFFFEFAE8),
    warningContainer = Color(color = 0xFFFEFAE8),
    onWarningContainer = Color(color = 0xFF713F12),
)

internal val darkThemeColorScheme = ThemeColorScheme(
    primary = Color(color = 0xFFBEE6FF),
    onPrimary = Color(color = 0xFF003549),
    primaryContainer = Color(color = 0xFF50C2F8),
    onPrimaryContainer = Color(color = 0xFF002E41),

    secondary = Color(color = 0xFF96CDFF),
    onSecondary = Color(color = 0xFF003352),
    secondaryContainer = Color(color = 0xFF24A7F7),
    onSecondaryContainer = Color(color = 0xFF001423),

    tertiary = Color(color = 0xFFFFFFFF),
    onTertiary = Color(color = 0xFF352D3E),
    tertiaryContainer = Color(color = 0xFFDCD0E6),
    onTertiaryContainer = Color(color = 0xFF443C4E),

    error = Color(color = 0xFFFCA5A5),
    onError = Color(color = 0xFF450A0A),
    errorContainer = Color(color = 0xFF7F1D1D),
    onErrorContainer = Color(color = 0xFFFEF2F2),

    surfaceDim = Color(color = 0xFF131314),
    surface = Color(color = 0xFF131314),
    surfaceBright = Color(color = 0xFF39393A),
    onSurface = Color(color = 0xFFE5E2E3),
    onSurfaceVariant = Color(color = 0xFFC5C6CC),

    surfaceContainerLowest = Color(color = 0xFF0E0E0F),
    surfaceContainerLow = Color(color = 0xFF1B1B1C),
    surfaceContainer = Color(color = 0xFF201F20),
    surfaceContainerHigh = Color(color = 0xFF2A2A2B),
    surfaceContainerHighest = Color(color = 0xFF353436),

    inverseSurface = Color(color = 0xFFE5E2E3),
    inverseOnSurface = Color(color = 0xFF313031),
    inversePrimary = Color(color = 0xFF006689),

    outline = Color(color = 0xFF8F9096),
    outlineVariant = Color(color = 0xFF44474C),

    scrim = Color.Black,

    info = Color(color = 0xFFBEE6FF),
    onInfo = Color(color = 0xFF002E41),
    infoContainer = Color(color = 0xFF262C40),
    onInfoContainer = Color(color = 0xFFBEE6FF),

    success = Color(color = 0xFF8EE7AA),
    onSuccess = Color(color = 0xFF082B16),
    successContainer = Color(color = 0xFF082B16),
    onSuccessContainer = Color(color = 0xFF8EE7AA),

    warning = Color(color = 0xFFFEE78A),
    onWarning = Color(color = 0xFF411107),
    warningContainer = Color(color = 0xFF423606),
    onWarningContainer = Color(color = 0xFFFEE78A),
)
