## Core - UI - Compose - Design system

Uses [`:core:ui:compose:theme`](../theme/README.md)

## Background

[Jetpack Compose](https://developer.android.com/jetpack/compose) is a declarative UI toolkit for Android that provides a modern and efficient way to build UIs for Android apps. In this context, design systems and atomic design can help designers and developers create more scalable, maintainable, and reusable UIs.

### Design system

A design system is a collection of guidelines, principles, and tools that help teams create consistent and cohesive visual designs and user experiences.
It typically includes a set of reusable components, such as icons, typography, color palettes, and layouts, that can be combined and customized to create new designs.

The design system also provides documentation and resources for designers and developers to ensure that the designs are implemented consistently and efficiently across all platforms and devices.
The goal of a design system is to streamline the design process, improve design quality, and maintain brand consistency.

An example is Google's [Material Design](https://m3.material.io/) that is used to develop cohesive apps.

### Atomic Design

![Atomic design](assets/images/atomic_design.svg)

Atomic design is a methodology for creating user interfaces (UI) in a design system by breaking them down into smaller, reusable components.
These components are classified into five categories based on their level of abstraction: **atoms**, **molecules**, **organisms**, **templates**, and **pages**.

- **Atoms** are the smallest building blocks, such as buttons, labels, and input fields and could be combined to create more complex components.
- **Molecules** are groups of atoms that work together, like search bars, forms or menus
- **Organisms** are more complex components that combine molecules and atoms, such as headers or cards.
- **Templates** are pages with placeholders for components
- **Pages** are the final UI

By using atomic design, designers and developers can create more consistent and reusable UIs.
This can save time and improve the overall quality, as well as facilitate collaboration between team members.

## Acknowledgement

- [Atomic Design Methodology | Atomic Design by Brad Frost](https://atomicdesign.bradfrost.com/chapter-2/)
- [Atomic Design: Getting Started | Blog | We Are Mobile First](https://www.wearemobilefirst.com/blog/atomic-design)

