package app.k9mail.core.ui.compose.theme2.k9mail

import androidx.compose.ui.graphics.Color
import app.k9mail.core.ui.compose.theme2.ThemeColorScheme

internal val lightThemeColorScheme = ThemeColorScheme(
    primary = Color(color = 0xFF5F303D),
    onPrimary = Color(color = 0xFFFFFFFF),
    primaryContainer = Color(color = 0xFF875360),
    onPrimaryContainer = Color(color = 0xFFFFFFFF),

    secondary = Color(color = 0xFF422129),
    onSecondary = Color(color = 0xFFFFFFFF),
    secondaryContainer = Color(color = 0xFF68414B),
    onSecondaryContainer = Color(color = 0xFFFFE2E7),

    tertiary = Color(color = 0xFF443968),
    onTertiary = Color(color = 0xFFFFFFFF),
    tertiaryContainer = Color(color = 0xFF685C8E),
    onTertiaryContainer = Color(color = 0xFFFFFFFF),

    error = Color(color = 0xFFA0000E),
    onError = Color(color = 0xFFFFFFFF),
    errorContainer = Color(color = 0xFFDC2626),
    onErrorContainer = Color(color = 0xFFFFFFFF),

    surfaceDim = Color(color = 0xFFDCD9D9),
    surface = Color(color = 0xFFFCF8F8),
    surfaceBright = Color(color = 0xFFFCF8F8),
    onSurface = Color(color = 0xFF1C1B1B),
    onSurfaceVariant = Color(color = 0xFF45474A),

    surfaceContainerLowest = Color(color = 0xFFFFFFFF),
    surfaceContainerLow = Color(color = 0xFFF6F3F2),
    surfaceContainer = Color(color = 0xFFF1EDEC),
    surfaceContainerHigh = Color(color = 0xFFEBE7E7),
    surfaceContainerHighest = Color(color = 0xFFE5E2E1),

    inverseSurface = Color(color = 0xFF313030),
    inverseOnSurface = Color(color = 0xFFF3F0EF),
    inversePrimary = Color(color = 0xFFF7B5C4),

    outline = Color(color = 0xFF75777A),
    outlineVariant = Color(color = 0xFFC5C6CA),

    scrim = Color.Black,

    info = Color(color = 0xFFCAA204),
    onInfo = Color(color = 0xFFFFFFFF),
    infoContainer = Color(color = 0xFFFACC15),
    onInfoContainer = Color(color = 0xFFFFFFFF),

    success = Color(color = 0xFF194E2C),
    onSuccess = Color(color = 0xFFFFFFFF),
    successContainer = Color(color = 0xFF1D783B),
    onSuccessContainer = Color(color = 0xFFFFFFFF),

    warning = Color(color = 0xFFAA6000),
    onWarning = Color(color = 0xFFFFFFFF),
    warningContainer = Color(color = 0xFFF09D38),
    onWarningContainer = Color(color = 0xFFFFFFFF),
)

internal val darkThemeColorScheme = ThemeColorScheme(
    primary = Color(color = 0xFFF1E7FF),
    onPrimary = Color(color = 0xFF37265D),
    primaryContainer = Color(color = 0xFFCBB7F9),
    onPrimaryContainer = Color(color = 0xFF39285F),

    secondary = Color(color = 0xFFF1E7FF),
    onSecondary = Color(color = 0xFF332D41),
    secondaryContainer = Color(color = 0xFFC7BDD7),
    onSecondaryContainer = Color(color = 0xFF352F43),

    tertiary = Color(color = 0xFFFFDBE5),
    onTertiary = Color(color = 0xFF472732),
    tertiaryContainer = Color(color = 0xFFDDAEBC),
    onTertiaryContainer = Color(color = 0xFF43242F),

    error = Color(color = 0xFFFFB3AD),
    onError = Color(color = 0xFF68000A),
    errorContainer = Color(color = 0xFFDA3437),
    onErrorContainer = Color(color = 0xFFFFFFFF),

    surfaceDim = Color(color = 0xFF131314),
    surface = Color(color = 0xFF131314),
    surfaceBright = Color(color = 0xFF39393A),
    onSurface = Color(color = 0xFFE5E2E3),
    onSurfaceVariant = Color(color = 0xFFC5C6CC),

    surfaceContainerLowest = Color(color = 0xFF0E0E0F),
    surfaceContainerLow = Color(color = 0xFF1B1B1C),
    surfaceContainer = Color(color = 0xFF201F20),
    surfaceContainerHigh = Color(color = 0xFF2A2A2B),
    surfaceContainerHighest = Color(color = 0xFF353436),

    inverseSurface = Color(color = 0xFFE5E2E3),
    inverseOnSurface = Color(color = 0xFF313031),
    inversePrimary = Color(color = 0xFF66558F),

    outline = Color(color = 0xFF8F9096),
    outlineVariant = Color(color = 0xFF44474C),

    scrim = Color.Black,

    info = Color(color = 0xFFFDD847),
    onInfo = Color(color = 0xFF423606),
    infoContainer = Color(color = 0xFFFEE78A),
    onInfoContainer = Color(color = 0xFF423606),

    success = Color(color = 0xFF8EE7AA),
    onSuccess = Color(color = 0xFF082B16),
    successContainer = Color(color = 0xFFC0F2CF),
    onSuccessContainer = Color(color = 0xFF082B16),

    warning = Color(color = 0xFFF09D38),
    onWarning = Color(color = 0xFF411107),
    warningContainer = Color(color = 0xFFAA6000),
    onWarningContainer = Color(color = 0xFF411107),
)
