export default {
    entrypoint: {
        type: "choice",
        category: "Global",
        default: "compilationUnit",
        // sed -nr 's/.*\.RULE\(([^,]+),.*/\1/p' $(ls path/to/java-parser/rules/folder/*)
        choices: [
            { value: "arrayInitializer", description: "" },
            { value: "variableInitializerList", description: "" },
            { value: "block", description: "" },
            { value: "blockStatements", description: "" },
            { value: "blockStatement", description: "" },
            { value: "localVariableDeclarationStatement", description: "" },
            { value: "localVariableDeclaration", description: "" },
            { value: "localVariableType", description: "" },
            { value: "statement", description: "" },
            { value: "statementWithoutTrailingSubstatement", description: "" },
            { value: "emptyStatement", description: "" },
            { value: "labeledStatement", description: "" },
            { value: "expressionStatement", description: "" },
            { value: "statementExpression", description: "" },
            { value: "ifStatement", description: "" },
            { value: "assertStatement", description: "" },
            { value: "switchStatement", description: "" },
            { value: "switchBlock", description: "" },
            { value: "switchBlockStatementGroup", description: "" },
            { value: "switchLabel", description: "" },
            { value: "switchRule", description: "" },
            { value: "caseConstant", description: "" },
            { value: "casePattern", description: "" },
            { value: "whileStatement", description: "" },
            { value: "doStatement", description: "" },
            { value: "forStatement", description: "" },
            { value: "basicForStatement", description: "" },
            { value: "forInit", description: "" },
            { value: "forUpdate", description: "" },
            { value: "statementExpressionList", description: "" },
            { value: "enhancedForStatement", description: "" },
            { value: "breakStatement", description: "" },
            { value: "continueStatement", description: "" },
            { value: "returnStatement", description: "" },
            { value: "throwStatement", description: "" },
            { value: "synchronizedStatement", description: "" },
            { value: "tryStatement", description: "" },
            { value: "catches", description: "" },
            { value: "catchClause", description: "" },
            { value: "catchFormalParameter", description: "" },
            { value: "catchType", description: "" },
            { value: "finally", description: "" },
            { value: "tryWithResourcesStatement", description: "" },
            { value: "resourceSpecification", description: "" },
            { value: "resourceList", description: "" },
            { value: "resource", description: "" },
            { value: "yieldStatement", description: "" },
            { value: "variableAccess", description: "" },
            { value: "classDeclaration", description: "" },
            { value: "normalClassDeclaration", description: "" },
            { value: "classModifier", description: "" },
            { value: "typeParameters", description: "" },
            { value: "typeParameterList", description: "" },
            { value: "classExtends", description: "" },
            { value: "classImplements", description: "" },
            { value: "interfaceTypeList", description: "" },
            { value: "classPermits", description: "" },
            { value: "classBody", description: "" },
            { value: "classBodyDeclaration", description: "" },
            { value: "classMemberDeclaration", description: "" },
            { value: "fieldDeclaration", description: "" },
            { value: "fieldModifier", description: "" },
            { value: "variableDeclaratorList", description: "" },
            { value: "variableDeclarator", description: "" },
            { value: "variableDeclaratorId", description: "" },
            { value: "variableInitializer", description: "" },
            { value: "unannType", description: "" },
            { value: "unannPrimitiveTypeWithOptionalDimsSuffix", description: "" },
            { value: "unannPrimitiveType", description: "" },
            { value: "unannReferenceType", description: "" },
            { value: "unannClassOrInterfaceType", description: "" },
            { value: "unannClassType", description: "" },
            { value: "unannInterfaceType", description: "" },
            { value: "unannTypeVariable", description: "" },
            { value: "methodDeclaration", description: "" },
            { value: "methodModifier", description: "" },
            { value: "methodHeader", description: "" },
            { value: "result", description: "" },
            { value: "methodDeclarator", description: "" },
            { value: "receiverParameter", description: "" },
            { value: "formalParameterList", description: "" },
            { value: "formalParameter", description: "" },
            { value: "variableParaRegularParameter", description: "" },
            { value: "variableArityParameter", description: "" },
            { value: "variableModifier", description: "" },
            { value: "throws", description: "" },
            { value: "exceptionTypeList", description: "" },
            { value: "exceptionType", description: "" },
            { value: "methodBody", description: "" },
            { value: "instanceInitializer", description: "" },
            { value: "staticInitializer", description: "" },
            { value: "constructorDeclaration", description: "" },
            { value: "constructorModifier", description: "" },
            { value: "constructorDeclarator", description: "" },
            { value: "simpleTypeName", description: "" },
            { value: "constructorBody", description: "" },
            { value: "explicitConstructorInvocation", description: "" },
            { value: "unqualifiedExplicitConstructorInvocation", description: "" },
            { value: "qualifiedExplicitConstructorInvocation", description: "" },
            { value: "enumDeclaration", description: "" },
            { value: "enumBody", description: "" },
            { value: "enumConstantList", description: "" },
            { value: "enumConstant", description: "" },
            { value: "enumConstantModifier", description: "" },
            { value: "enumBodyDeclarations", description: "" },
            { value: "recordDeclaration", description: "" },
            { value: "recordHeader", description: "" },
            { value: "recordComponentList", description: "" },
            { value: "recordComponent", description: "" },
            { value: "variableArityRecordComponent", description: "" },
            { value: "recordComponentModifier", description: "" },
            { value: "recordBody", description: "" },
            { value: "recordBodyDeclaration", description: "" },
            { value: "compactConstructorDeclaration", description: "" },
            { value: "isDims", description: "" },
            { value: "expression", description: "" },
            { value: "lambdaExpression", description: "" },
            { value: "lambdaParameters", description: "" },
            { value: "lambdaParametersWithBraces", description: "" },
            { value: "lambdaParameterList", description: "" },
            { value: "conciseLambdaParameterList", description: "" },
            { value: "normalLambdaParameterList", description: "" },
            { value: "normalLambdaParameter", description: "" },
            { value: "regularLambdaParameter", description: "" },
            { value: "lambdaParameterType", description: "" },
            { value: "conciseLambdaParameter", description: "" },
            { value: "lambdaBody", description: "" },
            { value: "conditionalExpression", description: "" },
            { value: "binaryExpression", description: "" },
            { value: "unaryExpression", description: "" },
            { value: "unaryExpressionNotPlusMinus", description: "" },
            { value: "primary", description: "" },
            { value: "primaryPrefix", description: "" },
            { value: "primarySuffix", description: "" },
            { value: "fqnOrRefType", description: "" },
            { value: "fqnOrRefTypePartRest", description: "" },
            { value: "fqnOrRefTypePartCommon", description: "" },
            { value: "fqnOrRefTypePartFirst", description: "" },
            { value: "parenthesisExpression", description: "" },
            { value: "castExpression", description: "" },
            { value: "primitiveCastExpression", description: "" },
            { value: "referenceTypeCastExpression", description: "" },
            { value: "newExpression", description: "" },
            { value: "unqualifiedClassInstanceCreationExpression", description: "" },
            { value: "classOrInterfaceTypeToInstantiate", description: "" },
            { value: "typeArgumentsOrDiamond", description: "" },
            { value: "diamond", description: "" },
            { value: "methodInvocationSuffix", description: "" },
            { value: "argumentList", description: "" },
            { value: "arrayCreationExpression", description: "" },
            {
                value: "arrayCreationExpressionWithoutInitializerSuffix",
                description: ""
            },
            { value: "arrayCreationWithInitializerSuffix", description: "" },
            { value: "dimExprs", description: "" },
            { value: "dimExpr", description: "" },
            { value: "classLiteralSuffix", description: "" },
            { value: "arrayAccessSuffix", description: "" },
            { value: "methodReferenceSuffix", description: "" },
            { value: "templateArgument", description: "" },
            { value: "template", description: "" },
            { value: "stringTemplate", description: "" },
            { value: "textBlockTemplate", description: "" },
            { value: "embeddedExpression", description: "" },
            { value: "pattern", description: "" },
            { value: "typePattern", description: "" },
            { value: "recordPattern", description: "" },
            { value: "componentPatternList", description: "" },
            { value: "componentPattern", description: "" },
            { value: "matchAllPattern", description: "" },
            { value: "guard", description: "" },
            { value: "isRefTypeInMethodRef", description: "" },
            { value: "interfaceDeclaration", description: "" },
            { value: "normalInterfaceDeclaration", description: "" },
            { value: "interfaceModifier", description: "" },
            { value: "interfaceExtends", description: "" },
            { value: "interfacePermits", description: "" },
            { value: "interfaceBody", description: "" },
            { value: "interfaceMemberDeclaration", description: "" },
            { value: "constantDeclaration", description: "" },
            { value: "constantModifier", description: "" },
            { value: "interfaceMethodDeclaration", description: "" },
            { value: "interfaceMethodModifier", description: "" },
            { value: "annotationInterfaceDeclaration", description: "" },
            { value: "annotationInterfaceBody", description: "" },
            { value: "annotationInterfaceMemberDeclaration", description: "" },
            { value: "annotationInterfaceElementDeclaration", description: "" },
            { value: "annotationInterfaceElementModifier", description: "" },
            { value: "defaultValue", description: "" },
            { value: "annotation", description: "" },
            { value: "elementValuePairList", description: "" },
            { value: "elementValuePair", description: "" },
            { value: "elementValue", description: "" },
            { value: "elementValueArrayInitializer", description: "" },
            { value: "elementValueList", description: "" },
            { value: "literal", description: "" },
            { value: "integerLiteral", description: "" },
            { value: "floatingPointLiteral", description: "" },
            { value: "booleanLiteral", description: "" },
            { value: "shiftOperator", description: "" },
            { value: "moduleName", description: "" },
            { value: "packageName", description: "" },
            { value: "typeName", description: "" },
            { value: "expressionName", description: "" },
            { value: "methodName", description: "" },
            { value: "packageOrTypeName", description: "" },
            { value: "ambiguousName", description: "" },
            { value: "compilationUnit", description: "" },
            { value: "ordinaryCompilationUnit", description: "" },
            { value: "modularCompilationUnit", description: "" },
            { value: "packageDeclaration", description: "" },
            { value: "packageModifier", description: "" },
            { value: "importDeclaration", description: "" },
            { value: "typeDeclaration", description: "" },
            { value: "moduleDeclaration", description: "" },
            { value: "moduleDirective", description: "" },
            { value: "requiresModuleDirective", description: "" },
            { value: "exportsModuleDirective", description: "" },
            { value: "opensModuleDirective", description: "" },
            { value: "usesModuleDirective", description: "" },
            { value: "providesModuleDirective", description: "" },
            { value: "requiresModifier", description: "" },
            { value: "primitiveType", description: "" },
            { value: "numericType", description: "" },
            { value: "integralType", description: "" },
            { value: "floatingPointType", description: "" },
            { value: "referenceType", description: "" },
            { value: "classOrInterfaceType", description: "" },
            { value: "classType", description: "" },
            { value: "interfaceType", description: "" },
            { value: "typeVariable", description: "" },
            { value: "dims", description: "" },
            { value: "typeParameter", description: "" },
            { value: "typeParameterModifier", description: "" },
            { value: "typeBound", description: "" },
            { value: "additionalBound", description: "" },
            { value: "typeArguments", description: "" },
            { value: "typeArgumentList", description: "" },
            { value: "typeArgument", description: "" },
            { value: "wildcard", description: "" },
            { value: "wildcardBounds", description: "" }
        ],
        description: "Prettify from the entrypoint, allowing to use prettier on snippet."
    },
    arrowParens: {
        type: "choice",
        category: "Java",
        default: "always",
        choices: [
            { value: "always", description: "" },
            { value: "avoid", description: "" }
        ],
        description: "Include parentheses around a sole arrow function parameter."
    },
    trailingComma: {
        type: "choice",
        category: "Java",
        default: "all",
        choices: [
            { value: "all", description: "" },
            { value: "es5", description: "" },
            { value: "none", description: "" }
        ],
        description: "Print trailing commas wherever possible when multi-line."
    },
    experimentalOperatorPosition: {
        type: "choice",
        category: "Java",
        default: "end",
        choices: [
            { value: "start", description: "" },
            { value: "end", description: "" }
        ],
        description: "Where to print operators when binary expressions wrap lines."
    }
};
