import { PluginWithOptions } from 'markdown-it';

interface MarkdownItGitHubAlertsOptions {
    /**
     * List of markers to match.
     * @default ['TIP', 'NOTE', 'IMPORTANT', 'WARNING', 'CAUTION']
     */
    markers?: string[] | '*';
    /**
     * If markers case sensitively on matching.
     * @default false
     */
    matchCaseSensitive?: boolean;
    /**
     * Custom icons for each marker. The key is the marker name, and the value is the html script represent the icon.
     * The key is always lowercase.
     *
     * @default inline svg icons from GitHub
     */
    icons?: Record<string, string>;
    /**
     * Custom titles for each marker. The key is the marker name, and the value is the title.
     * The key is always lowercase.
     *
     * When the title is not specified, the default title is the capitalized marker name.
     */
    titles?: Record<string, string>;
    /**
     * Prefix for the class names.
     *
     * @default 'markdown-alert'
     */
    classPrefix?: string;
}
declare const MarkdownItGitHubAlerts: PluginWithOptions<MarkdownItGitHubAlertsOptions>;

export { type MarkdownItGitHubAlertsOptions, MarkdownItGitHubAlerts as default };
