# Suntimes Calendars
<a href="https://f-droid.org/repository/browse/?fdid=com.forrestguice.suntimescalendars" target="_blank">
<img src="https://forrestguice.github.io/SuntimesWidget/assets/images/get-it-on-fdroid.png" alt="Get it on F-Droid" height="68" align="left" /></a>

An add-on for [Suntimes](https://github.com/forrestguice/SuntimesWidget) that supplies calendar events for the solstices, equinoxes, twilight periods (astronomical, nautical, civil (sunrise, sunset)), and the moon (moonrise, moonset, major phases). This app depends on Suntimes [v0.10.3](https://f-droid.org/en/packages/com.forrestguice.suntimeswidget/) or later.

[![F-Droid](https://img.shields.io/f-droid/v/com.forrestguice.suntimescalendars.svg)](https://f-droid.org/en/packages/com.forrestguice.suntimescalendars/)
[![GitHub release](https://img.shields.io/github/release/forrestguice/SuntimesCalendars.svg)](https://github.com/forrestguice/SuntimesCalendars/releases)
[![Android CI](https://github.com/forrestguice/SuntimesCalendars/workflows/Android%20CI/badge.svg?branch=master)](https://github.com/forrestguice/SuntimesCalendars/actions?query=branch%3Amaster)

* [Privacy and Permissions](#privacy-and-permissions)
* [Donations](#donations)
* [Bug Reports](#bug-reports)
* [Legal Stuff](#legal-stuff)
* [Contributions](#project-contributions)

<img alt="screenshot1" src='fastlane/metadata/android/en-US/images/phoneScreenshots/1.png' width="280px" />

## Privacy and Permissions ##

SuntimesCalendars does not collect, store, or transmit personal user data. It contains <b>no advertising</b>, <b>no analytics</b>, <b>no trackers</b>, and <b>no unnecessary permissions</b>. 
[https://github.com/forrestguice/SuntimesCalendars/wiki/Privacy](https://github.com/forrestguice/SuntimesCalendars/wiki/Privacy)
    
The app requires the following permissions...

|Permission||Since Version|
|---|---|---|
|READ_CALENDAR|To interact with the Calendar app (access events).|v0.1.0|
|WRITE_CALENDAR|To interact with the Calendar app (add/remove events).|v0.1.0|
|READ_SYNC_STATS|To interact with the Calendar app (access custom calendars).|v0.1.0|
|WRITE_SYNC_SETTINGS|To interact with the Calendar app (add/remove custom calendars).|v0.1.0|
|suntimes.permission.READ_CALCULATOR|To read data from the Suntimes provider.|v0.1.0|


## Donations ##

Do you find value in this software? Please pay as you feel. 

[![paypal](https://www.paypalobjects.com/webstatic/en_US/i/btn/png/silver-rect-paypal-26px.png)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=NZJ5FJBCKY6K2)

[:heart: Sponsor](https://github.com/sponsors/forrestguice)

## Bug Reports ##

Use the issue tracker to submit a bug report or a feature request.

When reporting a bug **please be detailed as possible**. What did you expect the app to do, what did you actually observe? Include the app version number in your report. Other useful information includes the Android OS version (and sometimes your specific device model).

## Legal Stuff
Copyright © 2018-2021 Forrest Guice <br />
The source code is available under [GPLv3](LICENSE) (https://github.com/forrestguice/SuntimesCalendars).

> This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the [GNU General Public License](LICENSE) for more details.

## Project Contributions

German translation by <u>Henrik "HerHde" Hüttemann</u> and <u>Wolkenschieber</u>.<br/>
Polish and Esperanto translations by <u>Verdulo</u>.<br/>
French translation by <u>Jej</u> and <u>Aloha</u>.<br/>
Hungarian translation by <u>Erci</u>.<br/>
Catalan and Spanish translations by <u><a href="https://github.com/Raulvo">Raulvo</a></u> and <u><a href="https://github.com/gnusuari0">gnusuari0</a></u>.<br/>
Basque translation by <u>beriain</u>.<br/>
Norwegian translation by <u>FTno</u>.<br/>
Italian translation by <u>Matteo Caoduro</u>.<br/>
Traditional Chinese translation by <u><a href=https://github.com/pggdt>ft42</a></u>.<br />
Brazilian Portuguese translation by <u><a href=https://github.com/netosilva15>NetoSilva</a></u>, <u><a href=https://github.com/naoliv>Nelson&#160;A.&#160;de&#160;Oliveira</a></u>, and <u><a href=https://github.com/efraletti>Enrico S. B. Fraletti</a></u>.<br />
Dutch translation by <u><a href=https://github.com/joppla>Joppla</a></u>.<br />
Russian translation by <u><a href=https://github.com/ddanilov>ddanilov</a></u>.<br />
