package com.foobnix.pdf.info.widget;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.FragmentActivity;

import com.buzzingandroid.ui.HSVColorPickerDialog.OnColorSelectedListener;
import com.buzzingandroid.ui.HSVColorWheel;
import com.buzzingandroid.ui.HSVValueSlider;
import com.foobnix.android.utils.IntegerResponse;
import com.foobnix.android.utils.LOG;
import com.foobnix.android.utils.ResultResponse2;
import com.foobnix.android.utils.TxtUtils;
import com.foobnix.android.utils.Views;
import com.foobnix.model.AppProfile;
import com.foobnix.model.AppState;
import com.foobnix.pdf.info.ExtUtils;
import com.foobnix.pdf.info.R;
import com.foobnix.pdf.info.model.BookCSS;
import com.foobnix.pdf.info.view.CustomSeek;
import com.foobnix.pdf.info.wrapper.MagicHelper;

public class ColorsDialog {
    int colorTextChoose, colorBgChoose, colorForegroundChoose;
    final private TextView fontRGB, bgRGB, fontRGBForeground;
    final private HSVColorWheel hsvColorWheelFont, hsvColorWheelBackground;
    final private HSVValueSlider hsvValueSliderFont, hsvValueSliderBackground, hsvValueSliderForeground;
    private TextView textPreview;
    private TextView textPreview2;
    private RelativeLayout foregroundLayout;

    TextView isColor, isImage;
    CustomSeek imageTransparency;
    LinearLayout configBGLayout, configBGLayout2;

    ImageView bg1, bg2, bg3, bg4;

    public static interface ColorsDialogResult {
        public void onChooseColor(int colorText, int colorBg, int colorForeground);
    }

    Handler handler;

    public ColorsDialog(final FragmentActivity c, final boolean isDayMode, final int colorTextDef, final int colorBgDef, final int colorFgDef, boolean onlyColorBg, final boolean soligBG, final ColorsDialogResult colorsDialogResult) {
        super();
        final View view = LayoutInflater.from(c).inflate(R.layout.dialog_colors, null, false);

        handler = new Handler(Looper.getMainLooper());

        int colorText = magicBlackColor(colorTextDef);
        int colorBg = magicBlackColor(colorBgDef);

        colorTextChoose = colorText;
        colorBgChoose = colorBg;
        colorForegroundChoose = colorFgDef;

        textPreview = (TextView) view.findViewById(R.id.textView1);
        textPreview2 = (TextView) view.findViewById(R.id.textView2);


        isColor = TxtUtils.underlineTextView((TextView) view.findViewById(R.id.isColor));
        isImage = TxtUtils.underlineTextView((TextView) view.findViewById(R.id.isImage));

        textPreview.setText(isDayMode ? R.string.day : R.string.nigth);

        textPreview.setTextColor(colorText);
        textPreview.setBackgroundColor(colorBg);

        textPreview2.setTextColor(colorText);
        textPreview2.setBackgroundColor(colorBg);

        hsvColorWheelFont = (HSVColorWheel) view.findViewById(R.id.HSVColorWheel1);
        hsvColorWheelBackground = (HSVColorWheel) view.findViewById(R.id.HSVColorWheel2);

        hsvValueSliderFont = (HSVValueSlider) view.findViewById(R.id.HSVValueSlider1);
        hsvValueSliderBackground = (HSVValueSlider) view.findViewById(R.id.HSVValueSlider2);
        hsvValueSliderForeground = (HSVValueSlider) view.findViewById(R.id.HSVValueSlider3);

        fontRGB = (TextView) view.findViewById(R.id.fontRGB);
        bgRGB = (TextView) view.findViewById(R.id.bgRGB);
        fontRGBForeground = (TextView) view.findViewById(R.id.fontRGBForeground);

        foregroundLayout = view.findViewById(R.id.foregroundLayout);

        imageTransparency = (CustomSeek) view.findViewById(R.id.bgTransparency);
        imageTransparency.init(10, 255, isDayMode ? AppState.get().bgImageDayTransparency : AppState.get().bgImageNightTransparency);
        imageTransparency.setOnSeekChanged(new IntegerResponse() {

            @Override
            public boolean onResultRecive(int result) {
                if (isDayMode) {
                    AppState.get().bgImageDayTransparency = result;
                } else {
                    AppState.get().bgImageNightTransparency = result;
                }
                Bitmap bg = MagicHelper.updateTextViewBG(textPreview2, result, MagicHelper.getImagePath(isDayMode));
                textPreview.setText("");
                Views.setBackground(textPreview, bg);


                return false;
            }
        });

        configBGLayout = (LinearLayout) view.findViewById(R.id.configBGLayout);
        configBGLayout2 = (LinearLayout) view.findViewById(R.id.configBGLayout2);

        bg1 = (ImageView) view.findViewById(R.id.bg1);
        bg2 = (ImageView) view.findViewById(R.id.bg2);
        bg3 = (ImageView) view.findViewById(R.id.bg3);
        bg4 = (ImageView) view.findViewById(R.id.bg4);

        bg1.setImageBitmap(MagicHelper.loadBitmap(MagicHelper.IMAGE_BG_1));
        bg2.setImageBitmap(MagicHelper.loadBitmap(MagicHelper.IMAGE_BG_2));
        bg3.setImageBitmap(MagicHelper.loadBitmap(MagicHelper.IMAGE_BG_3));

        if (isDayMode) {
            if (AppState.get().bgImageDayPath.startsWith("/")) {
                bg4.setImageBitmap(MagicHelper.loadBitmap(AppState.get().bgImageDayPath));
            }
        } else {
            if (AppState.get().bgImageNightPath.startsWith("/")) {
                bg4.setImageBitmap(MagicHelper.loadBitmap(AppState.get().bgImageNightPath));
            }
        }

        bg1.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                if (isDayMode) {
                    AppState.get().bgImageDayPath = MagicHelper.IMAGE_BG_1;
                } else {
                    AppState.get().bgImageNightPath = MagicHelper.IMAGE_BG_1;
                }

                Bitmap bg = MagicHelper.updateTextViewBG(textPreview2, imageTransparency.getCurrentValue(), MagicHelper.IMAGE_BG_1);
                textPreview.setText("");
                Views.setBackground(textPreview, bg);


            }
        });
        bg2.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                if (isDayMode) {
                    AppState.get().bgImageDayPath = MagicHelper.IMAGE_BG_2;
                } else {
                    AppState.get().bgImageNightPath = MagicHelper.IMAGE_BG_2;
                }

                Bitmap bg = MagicHelper.updateTextViewBG(textPreview2, imageTransparency.getCurrentValue(), MagicHelper.IMAGE_BG_2);
                textPreview.setText("");
                Views.setBackground(textPreview, bg);


            }
        });
        bg3.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                if (isDayMode) {
                    AppState.get().bgImageDayPath = MagicHelper.IMAGE_BG_3;
                } else {
                    AppState.get().bgImageNightPath = MagicHelper.IMAGE_BG_3;
                }

                Bitmap bg = MagicHelper.updateTextViewBG(textPreview2, imageTransparency.getCurrentValue(), MagicHelper.IMAGE_BG_3);
                textPreview.setText("");
                Views.setBackground(textPreview, bg);


            }
        });
        bg4.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {

                ChooserDialogFragment.chooseFile(c, "").setOnSelectListener(new ResultResponse2<String, Dialog>() {
                    @Override
                    public boolean onResultRecive(String nPath, Dialog dialog) {
                        if (!ExtUtils.isImagePath(nPath)) {
                            Toast.makeText(c, R.string.incorrect_value, Toast.LENGTH_SHORT).show();
                            return false;
                        }
                        if (isDayMode) {
                            AppState.get().bgImageDayPath = nPath;
                        } else {
                            AppState.get().bgImageNightPath = nPath;
                        }
                        bg4.setImageBitmap(MagicHelper.loadBitmap(nPath));

                        Bitmap bg = MagicHelper.updateTextViewBG(textPreview2, imageTransparency.getCurrentValue(), nPath);
                        textPreview.setText("");
                        Views.setBackground(textPreview, bg);


                        dialog.dismiss();
                        return false;
                    }
                });

            }
        });

        isColor.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                imageTransparency.setVisibility(View.GONE);
                configBGLayout.setVisibility(View.GONE);
                configBGLayout2.setVisibility(View.GONE);
                ((ViewGroup) bgRGB.getParent()).setVisibility(View.VISIBLE);
                hsvValueSliderBackground.setVisibility(View.VISIBLE);
                hsvColorWheelBackground.setVisibility(View.VISIBLE);

                textPreview2.setBackgroundColor(colorBgChoose);

                if (isDayMode) {
                    AppState.get().isUseBGImageDay = false;
                } else {
                    AppState.get().isUseBGImageNight = false;
                }

                textPreview.setText(isDayMode ? R.string.day : R.string.nigth);
                textPreview.setTextColor(colorTextChoose);
                textPreview.setBackgroundColor(colorBgChoose);
            }
        });

        isImage.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                if (isDayMode) {
                    AppState.get().isUseBGImageDay = true;
                    colorBgChoose = AppState.COLOR_WHITE;
                    textPreview2.setBackgroundColor(AppState.COLOR_WHITE);
                } else {
                    AppState.get().isUseBGImageNight = true;
                    colorBgChoose = AppState.COLOR_BLACK;
                    textPreview2.setBackgroundColor(AppState.COLOR_BLACK);
                }

                imageTransparency.setVisibility(View.VISIBLE);
                configBGLayout.setVisibility(View.VISIBLE);
                configBGLayout2.setVisibility(View.VISIBLE);
                ((ViewGroup) bgRGB.getParent()).setVisibility(View.GONE);
                hsvValueSliderBackground.setVisibility(View.GONE);
                hsvColorWheelBackground.setVisibility(View.GONE);

                Bitmap bg = MagicHelper.updateTextViewBG(textPreview2, imageTransparency.getCurrentValue(), MagicHelper.getImagePath(isDayMode));
                textPreview.setText("");
                Views.setBackground(textPreview, bg);

            }
        });

        fontRGB.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                final AlertDialog.Builder builder = new AlertDialog.Builder(c);
                builder.setTitle(R.string.dialog_color_picker);
                final EditText input = new EditText(c);
                input.setText(fontRGB.getText());
                builder.setView(input);
                builder.setPositiveButton(R.string.apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                });
                builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                final AlertDialog dialog = builder.show();
                dialog.getButton(AlertDialog.BUTTON_POSITIVE).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        try {
                            colorForegroundChoose = Color.parseColor(input.getText().toString());
                            updateAll(colorTextChoose, colorBgChoose, colorForegroundChoose);
                            dialog.dismiss();
                        } catch (Exception e) {
                            dialog.setTitle("Invalid color value");
                        }
                    }
                });
            }
        });

        bgRGB.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                final AlertDialog.Builder builder = new AlertDialog.Builder(c);
                builder.setTitle(R.string.dialog_color_picker);
                final EditText input = new EditText(c);
                input.setSingleLine();
                input.setText(bgRGB.getText());
                builder.setView(input);
                builder.setPositiveButton(R.string.apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                });
                builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                final AlertDialog dialog = builder.show();
                dialog.getButton(AlertDialog.BUTTON_POSITIVE).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        try {
                            colorBgChoose = Color.parseColor(input.getText().toString());
                            updateAll(colorTextChoose, colorBgChoose, colorForegroundChoose);
                            dialog.dismiss();
                        } catch (Exception e) {
                            dialog.setTitle(R.string.invalid_color_value);
                        }
                    }
                });
            }
        });

        fontRGBForeground.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                final AlertDialog.Builder builder = new AlertDialog.Builder(c);
                builder.setTitle(R.string.dialog_color_picker);
                final EditText input = new EditText(c);
                input.setSingleLine();
                input.setText(fontRGBForeground.getText());
                builder.setView(input);
                builder.setPositiveButton(R.string.apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                });
                builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                final AlertDialog dialog = builder.show();
                dialog.getButton(AlertDialog.BUTTON_POSITIVE).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        try {
                            colorForegroundChoose = Color.parseColor(input.getText().toString());

                            updateAll(colorTextChoose, colorBgChoose, colorForegroundChoose);

                            hsvValueSliderForeground.setColor(colorForegroundChoose, true);
                            foregroundLayout.setBackgroundColor(colorForegroundChoose);

                            dialog.dismiss();
                        } catch (Exception e) {
                            dialog.setTitle(R.string.invalid_color_value);
                        }
                    }
                });
            }
        });

        hsvColorWheelFont.setListener(new OnColorSelectedListener() {
            @Override
            public void colorSelected(Integer color) {
                LOG.d("hsvColorWheel1 colorSelected", MagicHelper.colorToString(color));
                hsvValueSliderFont.setColor(color, true);
                updateRGB(fontRGB, color);
            }
        });

        hsvColorWheelBackground.setListener(new OnColorSelectedListener() {
            @Override
            public void colorSelected(Integer color) {
                LOG.d("hsvColorWheel2 colorSelected", MagicHelper.colorToString(color));
                hsvValueSliderBackground.setColor(color, true);
                updateRGB(bgRGB, color);

                colorForegroundChoose = MagicHelper.ligtherColor(color);
                hsvValueSliderForeground.setColor(colorForegroundChoose, true);
                foregroundLayout.setBackgroundColor(colorForegroundChoose);
                updateRGB(fontRGBForeground, colorForegroundChoose);
            }
        });

        hsvValueSliderFont.setListener(new OnColorSelectedListener() {
            @Override
            public void colorSelected(final Integer color) {
                textPreview.setTextColor(color);
                textPreview2.setTextColor(color);
                colorTextChoose = color;

                updateRGB(fontRGB, color);
            }
        });

        hsvValueSliderBackground.setListener(new OnColorSelectedListener() {
            @Override
            public void colorSelected(final Integer color) {
                textPreview.setBackgroundColor(color);
                textPreview2.setBackgroundColor(color);

                colorBgChoose = color;
                updateRGB(bgRGB, color);

                colorForegroundChoose = MagicHelper.ligtherColor(colorBg);
                hsvValueSliderForeground.setColor(colorForegroundChoose, true);
                foregroundLayout.setBackgroundColor(colorForegroundChoose);
                updateRGB(fontRGBForeground, colorForegroundChoose);

            }
        });

        hsvValueSliderForeground.setListener(new OnColorSelectedListener() {
            @Override
            public void colorSelected(final Integer color) {
                //textPreview.setBackgroundColor(color);
                // textPreview2.setBackgroundColor(color);
                foregroundLayout.setBackgroundColor(color);
                colorForegroundChoose = color;
                updateRGB(fontRGBForeground, color);

            }
        });

        AlertDialog.Builder d = new AlertDialog.Builder(c);
        d.setView(view);
        d.setNegativeButton(R.string.close, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

            }
        });
        d.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                colorTextChoose = magicBlackColor(colorTextChoose);
                colorBgChoose = magicBlackColor(colorBgChoose);

                colorsDialogResult.onChooseColor(colorTextChoose, colorBgChoose, colorForegroundChoose);

                AppProfile.save(c);
            }
        });
        d.show();

        TextView isDefaults = TxtUtils.underlineTextView((TextView) view.findViewById(R.id.onDefaults));
        isDefaults.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                if (isDayMode) {
                    AppState.get().bgImageDayTransparency = AppState.DAY_TRANSPARENCY;
                    AppState.get().bgImageDayPath = MagicHelper.IMAGE_BG_1;
                    imageTransparency.reset(AppState.get().bgImageDayTransparency);
                } else {
                    AppState.get().bgImageNightTransparency = AppState.NIGHT_TRANSPARENCY;
                    AppState.get().bgImageNightPath = MagicHelper.IMAGE_BG_2;
                    imageTransparency.reset(AppState.get().bgImageNightTransparency);
                }
                updateAll(colorTextDef, colorBgDef, colorFgDef);
                handler.postDelayed(new Runnable() {

                    @Override
                    public void run() {
                        if (soligBG) {
                            isColor.performClick();
                        } else {
                            isImage.performClick();
                        }
                    }
                }, 25);

            }
        });

        // hsvColorWheel1.setColor(colorText);
        // hsvValueSlider1.setColor(colorText, false);
        //
        // hsvColorWheel2.setColor(colorBg);
        // hsvValueSlider2.setColor(colorBg, false);
        //
        // updateRGB(fontRGB, colorText);
        // updateRGB(bgRGB, colorBg);

        if (!(BookCSS.get().isTextFormat() || AppState.get().isCustomizeBgAndColors)) {
            fontRGB.setVisibility(View.GONE);
            hsvColorWheelFont.setVisibility(View.GONE);
            hsvValueSliderFont.setVisibility(View.GONE);
            view.findViewById(R.id.textFont).setVisibility(View.GONE);
            view.findViewById(R.id.fontLayout).setVisibility(View.GONE);
        }

        updateAll(colorTextChoose, colorBgChoose, colorForegroundChoose);
        handler.postDelayed(new Runnable() {

            @Override
            public void run() {
                if (soligBG) {
                    isColor.performClick();
                } else {
                    isImage.performClick();
                }
            }
        }, 25);

        if (onlyColorBg) {
            isImage.setVisibility(View.GONE);
            isDefaults.setVisibility(View.GONE);

        }

    }

    public void showHideByColor(boolean isColor) {
        if (isColor) {

        } else {

        }
    }

    public int magicBlackColor(int color) {
        if (color == Color.BLACK) {
            return AppState.COLOR_BLACK;
        }
        return color;
    }

    public void updateAll(int textColor, int backgroundColor, int foregroundColor) {


        hsvColorWheelFont.setColor(textColor);
        hsvColorWheelBackground.setColor(backgroundColor);

        textPreview.setTextColor(textColor);
        textPreview2.setTextColor(textColor);


        textPreview.setBackgroundColor(backgroundColor);
        textPreview2.setBackgroundColor(backgroundColor);
        foregroundLayout.setBackgroundColor(foregroundColor);

        hsvValueSliderFont.setColor(textColor, false);
        hsvValueSliderBackground.setColor(backgroundColor, false);
        hsvValueSliderForeground.setColor(foregroundColor, false);

        updateRGB(fontRGB, textColor);
        updateRGB(bgRGB, backgroundColor);
        updateRGB(fontRGBForeground, foregroundColor);
    }

    public void updateRGB(TextView font, Integer intColor) {
        if (intColor == AppState.COLOR_BLACK) {
            intColor = Color.BLACK;
        }

        String hexColor = MagicHelper.colorToString(intColor);
        font.setText(TxtUtils.underline(hexColor));
    }

}
