package com.foobnix.pdf.info;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.view.View;
import android.widget.Toast;

import com.foobnix.android.utils.LOG;
import com.foobnix.ext.CacheZipUtils;
import com.foobnix.ext.EpubExtractor;
import com.foobnix.mobi.parser.IOUtils;
import com.foobnix.model.AppProfile;
import com.foobnix.model.AppState;
import com.foobnix.opds.OPDS;
import com.foobnix.pdf.info.model.BookCSS;
import com.foobnix.pdf.info.view.AlertDialogs;
import com.foobnix.pdf.info.view.MyProgressDialog;
import com.foobnix.pdf.search.view.ProgressTask;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import okhttp3.CacheControl;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;

public class FontExtractor {

    final static Object lock = new Object();
    public static String FONT_HTTP_ZIP1 = "https://raw.github.com/foobnix/LirbiReader/master/Builder/fonts/fonts.zip";
    public static String FONT_HTTP_ZIP2 = "https://www.dropbox.com/s/c8v7d05vskmjt28/fonts.zip?raw=1";

    public static void extractFonts(final Context c) {
        LOG.d("extractFonts");
        if (c == null) {
            return;
        }
        new Thread("@T extractFonts") {
            @Override
            public void run() {
                // extractInside(c, "fonts", BookCSS.FONTS_DIR);
                try {
                    synchronized (lock) {

                        //critically important copy CSS
                        String[] rootFiles = c.getAssets().list("");
                        LOG.d("rootFiles", rootFiles != null);
                        for (String name : rootFiles) {
                            if (name.startsWith("app-")) {
                                LOG.d("getAssets", name);
                                File appFile = new File(AppProfile.SYNC_FOLDER_DEVICE_PROFILE, name);

                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                IOUtils.copyClose(c.getAssets().open(name), out);

                                long l1 = appFile.length();
                                long l2 = out.size();

                                if (l1 != l2) {
                                    LOG.d("Copy-Asset in out", l1, l2, name);
                                    IOUtils.copyClose(new ByteArrayInputStream(out.toByteArray()), new FileOutputStream(appFile));
                                }

                            }
                        }
                        //critically important

                        try {
                            if (hasZipFonts()) {
                                long lastModified = AppProfile.FONT_LOCAL_ZIP.lastModified();

                                File fontDir = new File(BookCSS.get().fontFolder);
                                File index = new File(fontDir, "index");
                                LOG.d("extractFonts index exist", index.exists());
                                if (lastModified != AppState.get().fontExtractTime || !index.exists()) {
                                    copyFontsFromZip(AppProfile.FONT_LOCAL_ZIP);
                                    boolean indexRes = index.createNewFile();
                                    AppState.get().fontExtractTime = lastModified;
                                    LOG.d("extractFonts YES", AppState.get().fontExtractTime, lastModified);
                                    LOG.d("extractFonts index create", indexRes);
                                } else {
                                    LOG.d("extractFonts NO");
                                }
                            }
                        } catch (Exception e) {
                            LOG.e(e);
                        }

                        try {
                            File temp = new File(AppProfile.FONT_LOCAL_ZIP.getPath());
                            if (!temp.isFile()) {
                                IOUtils.copyClose(c.getAssets().open("fonts.zip"), new FileOutputStream(temp));
                                copyFontsFromZip(temp);
                                LOG.d("extract-fonts", temp);
                            } else {
                                LOG.d("extract-fonts skip");
                            }
                        } catch (Exception e) {
                            LOG.d(e);
                        }


                    }
                } catch (Exception e) {
                    LOG.e(e);
                }
            }

        }.start();

    }

    private static void extractInside(final Context c, String from, String to) {
        try {
            File fontsDir = getFontsDir(c, to);
            if (fontsDir.exists()) {
                LOG.d("FontExtractor Dir exists", fontsDir);
            } else {
                fontsDir.mkdirs();
            }
            String[] list = c.getAssets().list(from);
            for (String fontName : list) {
                File fontFile = new File(fontsDir, fontName);
                if (!fontFile.exists()) {
                    LOG.d("FontExtractor Copy file" + fontName, "to", fontFile);
                    InputStream open = c.getAssets().open(from + "/" + fontName);
                    EpubExtractor.writeToStream(open, new FileOutputStream(fontFile));
                    open.close();
                }
            }

        } catch (Exception e) {
            LOG.e(e);
        }
    }

    public static File getFontsDir(final Context c, String to) {
        return new File(c.getExternalCacheDir(), to);
    }


    public static void copyFontsFromZip(File archive) {
        try {
            File fontDir = new File(BookCSS.get().fontFolder);
            fontDir.mkdirs();

            AppProfile.FONT_LOCAL_ZIP.getParentFile().mkdirs();
            CacheZipUtils.extractArchive(archive, fontDir);
        } catch (Exception e) {
            LOG.e(e);
        }

    }

    public static boolean hasZipFonts() {
        try {
            return AppProfile.FONT_LOCAL_ZIP.isFile() && AppProfile.FONT_LOCAL_ZIP.length() > 5 * 1024 * 1024;
        } catch (Exception e) {
            return false;
        }
    }

    public static void showDownloadFontsDialog(final Activity a, final View label1, final View label2) {
        AlertDialogs.showDialog(a, a.getString(R.string.do_you_want_to_download_more_book_fonts_10mb_), a.getString(R.string.download), new Runnable() {

            @Override
            public void run() {
                new ProgressTask<>() {

                    @Override
                    public Context getContext() {
                        return a;
                    }

                    ProgressDialog progressDialog;

                    @Override
                    protected void onPreExecute() {
                        progressDialog = MyProgressDialog.show(a, a.getString(R.string.please_wait));

                    }


                    @Override
                    protected Object doInBackground(Object... params) {
                        try {
                            downloadFontFile(FONT_HTTP_ZIP1);
                        } catch (Exception e) {
                            LOG.e(e);
                        }

                        if (!hasZipFonts()) {
                            try {
                                downloadFontFile(FONT_HTTP_ZIP2);
                            } catch (Exception e) {
                                LOG.e(e);
                            }
                        }
                        if (hasZipFonts()) {
                            copyFontsFromZip(AppProfile.FONT_LOCAL_ZIP);
                            return true;
                        }
                        return null;

                    }

                    private void downloadFontFile(String url) throws IOException, FileNotFoundException {
                        LOG.d("Download from", url);
                        LOG.d("Download to  ", AppProfile.FONT_LOCAL_ZIP);
                        AppProfile.FONT_LOCAL_ZIP.delete();

                        okhttp3.Request request = new okhttp3.Request.Builder()//
                                .cacheControl(new CacheControl.Builder().noCache().build()).url(url)//
                                .build();//

                        Response response = OPDS.client//
                                .newCall(request)//
                                .execute();

                        BufferedSource source = response.body().source();
                        FileOutputStream out = new FileOutputStream(AppProfile.FONT_LOCAL_ZIP);
                        BufferedSink sink = Okio.buffer(Okio.sink(out));
                        sink.writeAll(response.body().source());
                        sink.close();
                        out.close();
                    }

                    @Override
                    protected void onPostExecute(Object result) {
                        if (progressDialog != null) {
                            try {
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                LOG.e(e);
                            }
                        }
                        if (result == null) {
                            Toast.makeText(a, R.string.msg_unexpected_error, Toast.LENGTH_LONG).show();
                        }
                        label1.setVisibility(FontExtractor.hasZipFonts() ? View.GONE : View.VISIBLE);
                        if (hasZipFonts() && label2 != null) {
                            label2.performClick();
                        }
                    }

                    ;

                }.execute();
            }
        });
    }
}
