package com.foobnix.hypen;

import java.util.HashMap;
import java.util.Map;

//https://github.com/mnater/Hyphenator/tree/master/patterns
//https://github.com/mfietz/JHyphenator/blob/master/src/main/java/de/mfietz/jhyphenator/HyphenationPattern.java
public enum HyphenPattern {

    error("error", 0, 0, new HashMap<Integer, String>() {
        {

        }
    }),

    en("en", 2, 3, new HashMap<Integer, String>() {
        {
            put(3, "x1qei2e1je1f1to2tlou2w3c1tue1q4tvtw41tyo1q4tz4tcd2yd1wd1v1du1ta4eu1pas4y1droo2d1psw24sv1dod1m1fad1j1su4fdo2n4fh1fi4fm4fn1fopd42ft3fu1fy1ga2sss1ru5jd5cd1bg3bgd44uk2ok1cyo5jgl2g1m4pf4pg1gog3p1gr1soc1qgs2oi2g3w1gysk21coc5nh1bck1h1fh1h4hk1zo1ci4zms2hh1w2ch5zl2idc3c2us2igi3hi3j4ik1cab1vsa22btr1w4bp2io2ipu3u4irbk4b1j1va2ze2bf4oar1p4nz4zbi1u2iv4iy5ja1jeza1y1wk1bk3fkh4k1ikk4k1lk1mk5tk1w2ldr1mn1t2lfr1lr3j4ljl1l2lm2lp4ltn1rrh4v4yn1q1ly1maw1brg2r1fwi24ao2mhw4kr1cw5p4mkm1m1mo4wtwy4x1ar1ba2nn5mx1ex1h4mtx3i1muqu2p3wx3o4mwa1jx3p1naai2x1ua2fxx4y1ba2dn1jy1cn3fpr2y1dy1i");
            put(4, "4dryn2itni4on1inn1im_up3nik4ni4dy5giye4tyes4_ye44ab_nhe4nha4abe2n2gyn1guy1ery5eep2pe4abry3lay3lone4wne4v1nesy3chn1erne2q3neo1nenp2seps4hy2cey5lu2nedne2cyme44nk2y5at2adine2b2ne_y5ac2p1tp2ten1den1cun1cryn5dp2th4adup4twpub3ae4rxu3ayn5gaff4pue4n2au4p1ppuf4n2atag1ipu4mag1na2gon4asx3tix1t2pu2na4gya3haa3heah4la3ho_ti2a5ian2an5puspu2tnak4_th2n1kl_te4_ta4mu4u4mupmun23mum2alex4ob_sy25ynxal1i_st4y1o4xi5cxi5a4alm_si2_sh2m5sixhu4m4sh4m3r4amam2py2rabm2pixhi2yo5dr2ai4m1pmo2vmos2x2edmo2r4n1la2mor2asx3c2xas5yom4x4apxam3nme44mokrbi2nne44andy4osp4ot3noemn4omn4a4m1n4nog4m1l2angws4l1posw3shwri4wra4yp3iwom11wo2m2izrb4ow4nopo4pr2cem2isrd2iano4mig4y3pomi3awiz55mi_no4n4m1fme4v2re_wir42mes1menme2mme2gre1o2med4me_4nop4m5c4m1bwil21noureu2whi4w3ev4maprev2w1era2plpo4crfu4r4fyy5pu2maha3pu2mab2a2rn1p4npi44lyb4lya2p3nwam42l1w1lut4luplu3or1glluf4lu5a2wacltu2y3rol1tr4vv4r3guyr4rl1te4rh_nru4ar1il2sel4sc4l1rl5prl4plys4c4lovri3ar4ib4lof3lo_ar2par3q_os3ll4oll2i4as_ri1o3vokl2levoi44p1mlka35vo_ns4cas4ll1izr4iqr2is3vivl1it3lika2tan2sen2slrle42l3hlgo3l5gal5frns3mvi4p3ley_od2r2meles24athr4myle2al3drv1inldi4l2de2vilnt2il3civik4lce42l1b4lavv3ifrno4r3nua1trr2ocnt4sy4sok4syks4la2tuk4sck3ouko5ryss4a2tyau4b4klyys1tnu1akis4au3rki4pro4ek4ima2va5ki_nu4dn4umn3uokes4k1erav1irok2ke4g1keek2ed_me2aw3ikal4aws4k5agk3ab3ka_aye4ays4veg3jo4p5ba_4vedjew3n1v24ve_ja4pzar23vatizi4n1w41batba4z2b1bb2beix4o4i5w4b1d4be_rox5nym4nyp4n3za4ittr3por1r4i1ti1bel2ith2itei2su4rs2r1sars4cr2seis1p3betvag4i2sor1shbe3wr1sioad34b3hbi2bbi4d3bie3isf4ise2is_1bilr1sp5va_r5sw_le2uz4eir1ibi2tuxu3r1tiu1v2i1raze4nze4pb2l2uu4mo1biip3iz1eripe4b4louts44b1m4b3no3br3bodi4osbo4eru3aio4mi1ol4io_3booo1ce4inyin1u2insru2n2inn4inl4inkrv4e2inioch42iner3vo4indpi2np4idbt4lb4tob3trry4cry3t2in_o4elbu4ni2muim1i5saiil3v4ilnil1iil5fs1apo3er4b5w5by_bys4_in1sau4i1lazet4u2suo3ev2z1ii2go4igius1p5saw4s5bo2fi4ifti3fl4if_i3etsch2usc22ie4i2dui4dri2diid5dpi3au3ruz4ils1cuz4is4s5d4se_se4a2ce_2ici4ich3ceii1bri5bo1ceni1blse2g5seiibe43cepi2aniam4ur2li2al2i1acet4hy2scew41phy4ch_5phuhu4thu4gche2h4tyh4shur1durc44hr44h5p5sev5sexu1ra4s3fup3p2s3gph3t2sh_ho4g2h1n_he23ciau3pl4h1mci5ch2lozo4m4ciihi2vhi4p2cim2cin4phsu1peu1ouo1geu5osheu4sho4he4th1es4shwun5zun5ysi1bunu45cizo4glck3ihep5he2nh4ed1sioph2l5hazsi2rcly4zte4_ge21siscoe22cog5siu1siv5siz_ga24skes1l2s2leha4m2s1ms3ma1ogyo1h2u1ni3gus3gun2guegu4acov1gth3_eu3g4ros1n4_es3u2nez4zyum2pu1mi3som_ev2oig4cri2gov15goos4opgon2ul5v5goeu3lugob53go_2c1t4ph_g1nog1nic2te4sov4ulsgn4ag4myc4twcud5c4ufc4uipe2t3glo1gleul2igla4_eg23giz3cun5givgi4u3gir5gio1cusul4e2spagil4g1ic5gi__eb4cze41d2a5da_u1laggo44daf2dagg2gege4v1geo1gen2ged3dato1la2ge_ol2dol2i5daypek4p4eed1d42de_4gazol2tuiv3ol2vo2lys1sa2gamgaf4o2meui4n2ui2pe2cd4em4fugi4jku3fl3ufaf2tyf4to1denu4du4pe_2f3sfri2de1ps1si4f5pfos5d3eqs4sls4snfo2rss2tdes25fon4p1b_ci23payss5w2st_de1tf4l2de1v2fin4dey4d1fd4gast2idg1id2gyd1h25di_ud5dfi3au4cy_ch4pav43didu3cud1iff2fyu3crd1inst4r4f1ffev4fer11dio2fedfe4bdir2s2ty4fe_dis1on1au3ca4f5bon1c2ondd5k25far4fagpa1peys45eyc1exps4ul2dlyp4ale3whon3s3do_e1wa5doee5vud4oge1visu2msu2nub4euav4su2rp4ai6rk_d4or3dosu1atdo4v3doxp4adoo4k4swoo2padre4eus4e3upe5un2ophet5z4syc3syl4y3hoy1ads4pd4swd4syd2tho4wo3ta_du2c4etn2tabta2luac4es4wdu4g2ess4uabdu4n4duptav4st5bow1io1pr5dyn2tawe1sp2t1bop1uead1tz4et4chopy5ea4l4t1d4te_2tyle1si4esh1tee4tyat1cr4twoteg4es2c4eru1teoer1s2eroea2tte4po1rat1wh3tusea2v3teu3texer1i2e1ber1h4tey2t1f4t1ge3br2th_th2e4thle1ce3tumec2i2ths2erb1tia4tueer1aou5vtud2tif22tige1potu1aou4lttu41timt5toos4le1cre2pat4swe5owe1cue4ottsh4eos4e1ort4sce3ol4edieo2ge5of1tio4eno4enn5tiq4edoti4u1tive3my1tiz4othee2ct5laee2ft5lo4t1mee2mtme4e1meem5bcoi4to3be5exo1ry2tof1effel2iel2ftos24t1pe1la1traos2ceig2ei5de5ico2soe1h45egyeg5n");
            put(5, "_ach4e4go_e4goseg1ule5gurtre5feg4iceher4eg5ibeger44egaltre4mei5gle3imbe3infe1ingtra3beir4deit3eei3the5ity5triae4jud3efiteki4nek4la2trime4la_e4lactri4v4toute4law5toure3leaefil45elece4ledto2rae5len4tonye1lestro3ve4fic4tonoto3mytom4bto2mato5ice5limto2gre3lioe2listru5i4todo4ellaee4tyello4e5locel5ogeest4el2shel4tae5ludel5uge4mace4mage5man2t1n2ee2s4ee4p1e2mele4metee4naemi4eee4lyeel3i3tled3tle_e4mistlan4eed3iem3iztrus4emo4gti3zaem3pie4mule4dulemu3ne4dritiv4aedon2e4dolti3tle5neae5neeen3emtis4pti5sotis4m3tisee3newti3sae5niee5nile3nioedi5zen3ite5niu5enized1ited3imeno4ge4nosen3oven4swti5oc4t1s2en3uaen5ufe3ny_4en3zed3ibe3diae4oi4ede4s3tini4ed3deo3ret2ina2e2dae4culeo4toe5outec4te4t3t2t4tes2t1ine5pel4timpe2corephe4e4plie2col5tigutu3arti5fytu4bie3pro3tienep4sh5tidie4putt4icoeci4t4tick2ti2bec3imera4bti4aber3ar4tuf45tu3ier4bler3che4cib2ere_4thooecca54thil3thet4thea3turethan4e4cade4bitere4qe4ben5turieret4tur5oeav5oeav5itu5ry4tess4tes_ter5ve1rio4eriter4iueri4v1terier3m4ter3cte5pe4t1waer3noeast3er5obe5rocero4rer1oue3assea5sp1tent4ertler3twtwis4eru4t3tende1s4a3tenc5telsear2te2scateli4e3scres5cue1s2ee2sec3tel_te5giear5kear4cte5diear3ae3sha2t1ede5ande2sice2sid5tecttece44teattype3ty5phesi4uea4gees4mie2sole3acte2sone1a4bdys5pdy4sedu4petaun4d3uleta5sytas4e4tare4tarctar4ata5pl2estrta5mo4talke2surtal3idu5eleta4bta5lae3teoua5naet1ic4taf4etin4ta5doe5tir4taciuan4id1ucad1u1ae3trae3tre2d1s2syn5ouar2d4drowet3uaet5ymdro4pdril4dri4b5dreneu3rouar3ieute44draieu5truar3te2vasdop4pe5veadoo3ddoni4u4belsum3iev1erdoli4do4laev3idevi4le4vinevi4ve5voc2d5ofdo5dee4wage5wee4d1n4ewil54d5lue3wit2d3lou3ber5eye_u1b4i3dledfa3blfab3rfa4ce3dle_fain4suit3su5issu2g34d5lasu4b3fa3tasu1al4fato1di1vd2iti5disiuci4bfeas4di1redi4pl4feca5fectdio5gfe3life4mofen2d4st3wuc4it5ferr5diniucle3f4fesf4fie4stry1dinaf4flydi3ge3dictd4icedia5bs4tops1tle5stirs3tifs4ties1ticfic4is5tias4ti_4ficsfi3cuud3ers3thefil5iste2w4filyudev45finas4tedfi2nes2talfin4ns2tagde2tode4suflin4u1dicf2ly5ud5isu5ditde1scd2es_der5sfon4tu4don5dermss4lid4erhfor4is4siede2pudepi4fra4tf5reade3pade3nufril4frol5ud4side3nou4eneuens4ug5infu5el5dem_s5setfu5nefu3rifusi4fus4s4futade5lode5if4dee_5gal_3galiga3lo2d1eds3selg5amos2s5cssas3u1ing4ganouir4mgass4gath3uita4deaf5dav5e5dav44dato4darygeez44spotspor4s4pon4gelydark5s4ply4spio4geno4genydard5ge3omg4ery5gesigeth54getoge4tydan3g4g1g2da2m2g3gergglu5dach4gh3inspil4gh4to4cutr1gi4agia5rula5bspho5g4icogien5s2pheulch42sperspa4n5spai3c4utu1lenul4gigir4lg3islcu5pycu3picu4mic3umecu2maso5vi5glasu5liagli4bg3lig5culiglo3r4ul3mctu4ru1l4og4na_c3terul1tig2ning4nio4ultug4noncta4b4c3s2cru4dul5ulsor5dgo3isum5absor5ccris4go3nic4rinson4gsona45gos_cri5fcre4vum4bi5credg4raigran25solvsoft3so4ceunat44graygre4nco5zi4gritcoz5egruf4cow5ag5stecove4cos4es5menun4ersmel44corbco4pl4gu4tco3pacon5tsman3gy5racon3ghach4hae4mhae4th5aguha3lac4onecon4aun4ims3latu2ninhan4gs3ket5colocol5ihan4kuni3vhap3lhap5ttras4co4grhar2dco5agsir5aclim45sionhas5shaun44clichaz3acle4m1head3hearun3s4s3ingun4sws2ina2s1in4silysil4eh5elohem4p4clarhena45sidiheo5r1c4l4h4eras5icc2c1itu4orsh3ernshor4h3eryci3phshon34cipecion45cinoc1ingc4inahi5anhi4cohigh5h4il2shiv5h4ina3ship3cilihir4lhi3rohir4phir4rsh3iohis4ssh1inci4lau5pia4h1l4hlan44cier5shevcia5rhmet4ch4tish1erh5ods3cho2hoge4chi2z3chitho4mahome3hon4aho5ny3hoodhoon45chiouptu44ura_ho5ruhos4esew4ihos1p1housu4ragses5tu4rasur4behree5se5shs1e4s4h1s24chedh4tarht1enht5esur4fru3rifser4os4erlhun4tsen5gur1inu3riosen4dhy3pehy3phu1ritces5tur3iz4cesa4sencur4no4iancian3i4semeia5peiass45selv5selfi4atu3centse1le4ceniib5iaib3inseg3ruros43cencib3li3cell5cel_s5edli5bun4icam5icap4icar4s4ed3secticas5i4cayiccu44iceour4pe4ced_i5cidsea5wi2cipseas4i4clyur4pi4i1cr5icrai4cryic4teictu2ccon4urti4ic4umic5uoi3curcci4ai4daiccha5ca4thscof4ide4s4casys4cliscle5i5dieid3ios4choid1itid5iui3dlei4domid3owu5sadu5sanid5uous4apied4ecany4ield3s4cesien4ei5enn4sceii1er_i3esci1estus3ciuse5as4cedscav5if4frsca4pi3fieu5siau3siccan4eiga5bcan5d4calous5sli3gibig3ilig3inig3iti4g4lus1trig3orig5oti5greigu5iig1ur2c5ah4i5i44cag4cach4ca1blusur4sat3usa5tab5utoi3legil1erilev4uta4b4butail3iail2ibil3io3sanc2ilitil2izsal4t5bustil3oqil4tyil5uru3tati4magsa5losal4m4ute_4imetbu3res3act5sack2s1ab4imitim4nii3mon4utelbumi4bu3libu4ga4inav4utenbsor42b5s2u4tis4briti3neervi4vr3vic4inga4inger3vey4ingir3ven4ingo4inguu4t1li5ni_i4niain3ioin1isbo4tor5uscrunk5both5b5ota5bos42i1no5boriino4si4not5borein3seru3in2int_ru4glbor5di5nusut5of5bor_uto5gioge4io2grbon4au5tonru3enu4touion3iio5phior3ibod3iio5thi5otiio4toi4ourbne5gb3lisrt4shblen4ip4icr3triip3uli3quar4tivr3tigrti4db4le_b5itzira4bi4racird5ert5ibi4refbi3tri4resir5gibi5ourte5oir4isr3tebr4tagbin4diro4gvac3uir5ul2b3ifis5agis3arisas52is1cis3chbi4eris3erbi5enrson3be5yor5shais3ibisi4di5sisbe3tw4is4krs3es4ismsbe5trr3secva4geis2piis4py4is1sbe3sp4bes4be5nuval5ois1teis1tirrys4rros44be5mis5us4ita_rron4i4tagrri4vi3tani3tatbe3lorri4or4reoit4esbe1libe5gu4itiarre4frre4cbe3giit3igbe3dii2tim2itio4itisrp4h4r3pet4itonr4peait5rybe3debe3dai5tudit3ul4itz_4be2dbeat3beak4ro4varo4tyros4sro5roiv5ioiv1itror3i5root1roomval1ub3berva5mo4izarva5piron4eban3ijac4qban4ebal1ajer5srom4prom4iba4geazz5i5judgay5alax4idax4ickais4aw4ly3awaya1vorav5ocav3igke5liv3el_ve4lov4elyro1feke4tyv4erdv4e2sa5vanav3ag5k2ick4illkilo5au1thk4in_4ves_ro3crkin4gve4teaun5dk5ishau4l2au3gu4kleyaugh3ve4tyk5nes1k2noat3ulkosh4at5uekro5n4k1s2at5uaat4that5te5vianat4sk5vidil4abolaci4l4adela3dylag4nlam3o3landrob3la4tosr4noular4glar3ilas4ea4topr3nivr3nita2tomr5nica4toglbin44l1c2vi5gnat3ifat1ica5tiar3neyr5net4ati_ld5isat4hol4driv2incle4bileft55leg_5leggr4nerr3nel4len_3lencr4nar1lentle3phle4prvin5dler4e3lergr3mitl4eroat5evr4mio5lesq3lessr3menl3eva4vingrma5cvio3lvi1ou4leyevi5rovi3so4l1g4vi3sulgar3l4gesate5cat5apli4agli2amr3lo4li4asr4lisli5bir4ligr2led4lics4vitil4icul3icyl3idaat5ac3lidirk4lel4iffli4flr3ket3lighvit3r4vityriv3iri2tulim3ili4moris4pl4inar3ishris4clin3ir4is_li5og4l4iqlis4pas1trl2it_as4shas5phri2pla4socask3ia3sicl3kallka4ta3sibl4lawashi4l5leal3lecl3legl3lel5riphas4abar2shrin4grin4ear4sarin4dr2inal5lowarre4l5met3rimol4modlmon42l1n2a3roorim5ilo4civo4la5rigil5ogo3loguri5et5longlon4iri1erlood5r4icolop3il3opmlora44ricir4icerib3a5los_v5oleri4agria4blos4tlo4taar2mi2loutar2izar3iolpa5bl3phal5phi4rhall3pit5voltar4im3volv2l1s2vom5ivori4l4siear4fllt5agar4fivo4rylten4vo4talth3ia3reeltis4ar4drw5ablrgo4naraw4lu3brluch4lu3cilu3enwag5olu5idlu4ma5lumia5raur5gitwait5luo3rw5al_luss4r5gisar4atl5venrgi4nara3pwar4tar3alwas4tly5mely3no2lys4l5ysewa1teaque5ma2car3gicma4clr3get5magnwed4nmaid54maldrg3erweet3wee5vwel4lapoc5re4whwest3ap3in4aphires2tr4es_mar3vre5rumas4emas1t5matemath3rero4r4eriap5atr1er4m5bilre1pumbi4vapar4a5nuran3ul4med_an3uare5lure1lian4twre5itmel4tan2trre4fy4antomen4are3fire2fe4menemen4imens4re1de3ment2r2edme5onre4awwin4g5reavme4tare3anme1tere1alm4etr3wiserdin4rdi4aan4stwith3an2span4snan2samid4amid4gan5otwl4esr4dalm4illmin4a3mindrcum3rc4itr3charcen4min4tm4inumiot4wl3ina3niumis5lan3ita3nip4mithan3ioan1gla3neuws4per2bina3nena5neem4ninw5s4tan1dl4mocrrbi4fmo2d1mo4gomois2xac5ex4agor4bagmo3mer4baba3narrau4ta5monrare4rar5cra5nor4aniam1inr2amiam5ifra4lomo3spmoth3m5ouf3mousam3icxer4ixe5roraf4tr5aclm3petra3bixhil5mpi4aam3ag3quetm5pirmp5is3quer2que_qua5vmpov5mp4tram5ab3alyz4m1s25alyt4alysa4ly_ali4exi5di5multx4ime4aldia4laral3adal5abak1enain5opu3trn4abu4nac_na4can5act5putexpe3dna4lia4i4n4naltai5lya3ic_pur4rag5ulnank4nar3c4narenar3inar4ln5arm3agognas4c4ag4l4ageupul3cage4oaga4na4gab3nautnav4e4n1b4ncar5ad5umn3chaa3ducptu4rpti3mnc1innc4itad4suad3owad4len4dain5dana5diua3ditndi4ba3dion1ditn3dizn5ducndu4rnd2we3yar4n3eara3dianeb3uac4um5neckac3ulp4siba3cio5negene4laac1inne5mine4moa3cie4nene4a2cine4poyc5erac1er2p1s2pro1tn2erepro3lner4rych4e2nes_4nesp2nest4neswpri4sycom4n5evea4carab3uln4gabn3gelpre3vpre3rycot4ng5han3gibng1inn5gitn4glangov4ng5shabi5an4gumy4erf4n1h4a5bannhab3a5bal3n4iani3anni4apni3bani4bl_us5ani5dini4erni2fip3petn5igr_ure3_un3up3per_un5op3pennin4g_un5k5nis_p5pel_un1en4ithp4ped_un1ani3tr_to4pympa3_til4n3ketnk3inyn5ic_se2ny4o5gy4onsnmet44n1n2_ru4d5pounnni4vnob4lpo4tan5ocly4ped_ro4qyper5noge4pos1s_ri4gpo4ry1p4or_res2no4mono3my_ree2po4ninon5ipoin2y4poc5po4gpo5em5pod_4noscnos4enos5tno5tayp2ta3noun_ra4cnowl3_pi2tyra5m_pi4eyr5ia_out3_oth32n1s2ns5ab_or3t_or1d_or3cplu4mnsid1nsig4y3s2eys3ion4socns4pen5spiploi4_odd5nta4bpli4n_ni4cn5tib4plignti2fpli3a3plannti4p1p2l23ysis2p3k2ys3ta_mis1nu5enpi2tun3uinp3ithysur4nu1men5umi3nu4nyt3icnu3trz5a2b_li4t_li3o_li2n_li4g_lev1_lep5_len4pion4oard3oas4e3pi1ooat5ip4inoo5barobe4l_la4mo2binpind4_ju3rob3ul_is4i_ir5rp4in_ocif3o4cil_in3so4codpi3lopi3enocre33piec5pidipi3dep5ida_in2kod3icodi3oo2do4odor3pi4cypian4_ine2o5engze3rooe4ta_im3m_id4l_hov5_hi3b_het3_hes3_go4r_gi4bpho4ro5geoo4gero3gie3phobog3it_gi5azo5ol3phizo4groogu5i4z1z22ogyn_fes3ohab5_eye55phieph1icoiff4_en3sph4ero3ing_en3go5ism_to2qans3v_el5d_eer4bbi4to3kenok5iebio5mo4lanper1v4chs_old1eol3erpe5ruo3letol4fi_du4co3liaper3op4ernp4erio5lilpe5ono5liop4encpe4la_do4tpee4do5livcin2q3pediolo4rol5pld3tabol3ub3pedeol3uno5lusedg1le1loaom5ahoma5l2p2edom2beom4bl_de3o3fich3pe4ao4met_co4ro3mia_co3ek3shao5midom1inll1fll3teapa2teo4monom3pi3pare_ca4tlue1pon4aco3nanm2an_pa4pum2en_on5doo3nenng1hoon4guon1ico3nioon1iso5niupa3nypan4ao3nou_bri2pain4ra1oronsu4rk1hopac4tpa4ceon5umonva5_ber4ood5eood5i6rks_oop3io3ordoost5rz1scope5dop1erpa4ca_ba4g_awn4_av4i_au1down5io3pito5pon1sync_as1s_as1p_as3ctch1c_ar5so5ra_ow3elo3visov4enore5auea1mor3eioun2d_ant4orew4or4guou5etou3blo5rilor1ino1rio_ang4o3riuor2miorn2eo5rofoto5sor5pe3orrhor4seo3tisorst4o3tif_an5cor4tyo5rum_al3tos3al_af1tos4ceo4teso4tano5scros2taos4poos4paz2z3wosi4ue3pai");
            put(6, "os3ityos3itoz3ian_os4i4ey1stroos5tilos5titxquis3_am5atot3er_ot5erso3scopor3thyweek1noth3i4ot3ic_ot5icao3ticeor3thiors5enor3ougor3ityor3icaouch5i4o5ria_ani5mv1ativore5sho5realus2er__an3teover3sov4erttot3icoviti4o5v4olow3dero4r3agow5esto4posiop3ingo5phero5phanthy3sc3operaontif5on3t4ionten45paganp3agattele2gonspi4on3omyon4odipan3elpan4tyon3keyon5est3oncil_ar4tyswimm6par5diompro5par5elp4a4ripar4isomo4gepa5terst5scrpa5thy_atom5sta1tio5miniom3icaom3ic_ss3hatsky1scpear4lom3ena_ba5naol3umer1veilpedia4ped4icolli4er1treuo5liteol3ishpeli4epe4nano5lis_pen4thol3ingp4era_r1thoup4erago3li4f_bas4er1krauperme5ol5id_o3liceper3tio3lescolass4oi3terpe5tenpe5tiz_be5raoi5son_be3smphar5iphe3nooi5letph4es_oi3deroic3esph5ingr3ial_3ognizo5g2ly1o1gis3phone5phonio5geneo4gatora3mour2amenofit4tof5itera3chupi4ciepoly1eod5dedo5cureoc3ula1pole_5ocritpee2v1param4oc3raco4clamo3chetob5ingob3a3boast5eoke1st3nu3itpi5thanuf4fentu3meoerst2o3chasplas5tn3tinepli5ernti4ernter3sntre1pn4s3esplum4bnsati4npre4cns4moonon1eqnor5abpo3et5n5lessn5oniz5pointpoly5tnon4agnk3rup3nomicng1sprno5l4inois5i4n3o2dno3blenni3aln5keroppa5ran3itor3nitionis4ta5nine_ni3miznd3thrmu2dron3geripray4e5precipre5copre3emm3ma1bpre4lan5gerep3rese3press_can5cmedi2c5pri4e_ce4la3neticpris3op3rocal3chain4er5ipros3en4erarnera5bnel5iz_cit5rne4gatn5d2ifpt5a4bjanu3aign4itn3chisn5chiln5cheon4ces_nau3seid4iosna3talnas5tinan4itnanci4na5mitna5liahnau3zput3er2n1a2bhex2a3hatch1multi3hair1sm4pousg1utanmpo3rim4p1inmp5iesmphas4rach4empar5iraf5figriev1mpara5mo5seyram3et4mora_rane5oran4gemo3ny_monol4rap3er3raphymo3nizgno5morar5ef4raril1g2nacg1leadmoni3ara5vairav3elra5ziemon5gemon5etght1wemoi5sege3o1dmma5ryr5bine3fluoren1dixmis4ti_de3ra_de3rie3chasrch4err4ci4bm4inglm5ineedu2al_3miliame3tryrdi4er_des4crd3ingdi2rerme5thimet3alre5arr3mestim5ersadi2rende2ticdes3icre4cremen4temensu5re3disred5itre4facmen4dede2mosmen5acmem1o3reg3ismel5onm5e5dyme3died2d5ibren4te5mediare5pindd5a5bdata1bmba4t5cle4arma3tisma5scemar4lyre4spichs3huma5riz_dumb5re3strre4terbrus4qre3tribio1rhre5utiman3izre4valrev3elbi1orbbe2vie_eas3ire5vilba1thyman5is5maniamal4tymal4lima5linma3ligmag5inav3ioul5vet4rg3inglus3teanti1dl5umn_ltur3a_el3emltera4ltane5lp5ingloun5dans5gra2cabllos5etlor5ouric5aslo5rie_enam35ricidri4cie5lope_rid5erri3encri3ent_semi5lom3errig5an3logicril3iz5rimanlob5allm3ingrim4pell5out5rina__er4ril5linal2lin4l3le4tl3le4nriph5eliv3er_ge5og_han5k_hi3er_hon3olin3ea1l4inel4im4p_idol3_in3ci_la4cy_lath5rit3iclim4blrit5urriv5elriv3et4l4i4lli4gra_leg5elif3errk4linlid5er4lict_li4cor5licioli4atorl5ish_lig5a_mal5o_man5a_mer3c5less_rm5ersrm3ingy3thinle5sco3l4erilera5b5lene__mon3ele4matld4erild4erela4v4ar1nis44lativ_mo3rola5tanlan4telan5etlan4dllab3ic_mu5takin4dek3est_ro5filk3en4dro5ker5role__of5te4jestyys3icaron4al5izont_os4tlron4tai4v3ot_pe5tero3pelrop3ici5voreiv5il__pio5n_pre3mro4the_ran4tiv3en_rov5eliv3ellit3uati4tramr5pentrp5er__rit5ui4tismrp3ingit5ill_ros5tit3ica4i2tici5terirre4stit3era4ita5mita4bi_row5dist4lyis4ta_is4sesrsa5tiissen4is4sal_sci3erse4crrs5er_islan4rse5v2yo5netish5opis3honr4si4bis5han5iron_ir4minrtach4_self5iri3turten4diri5dei4rel4ire4de_sell5r4tieriq3uidrtil3irtil4lr4tilyr4tistiq5uefip4re4_sing4_ting4yn3chrru3e4lion3at2in4th_tin5krum3pli4no4cin3ityrun4ty_ton4aruti5nymbol5rvel4i_top5irv5er_r5vestin5geni5ness_tou5s_un3cein3cerincel45ryngei4n3auim3ulai5miniimi5lesac3riim5ida_ve5rasalar4ima5ryim3ageill5abil4istsan4deila5rai2l5am_wil5ii4ladeil3a4bsa5voright3iig3eraab5erd4ific_iff5enif5eroi3entiien5a45ie5gaidi5ou3s4cieab5latidi4arid5ianide3al4scopyab5rogid5ancic3ulaac5ardi2c5ocic3ipaic5inase2c3oi4carai4car_se4d4ei2b5riib5iteib5it_ib5ertib3eraac5aroi4ativ4ian4tse4molsen5ata5ceouh4warts5enedhus3t4s5enin4sentd4sentlsep3a34s1er_hun5kehu4min4servohro3poa5chethov5el5se5umhouse3sev3enho5senhort3eho5rishor5at3hol4ehol5arh5odizhlo3riac5robhis3elhion4ehimer4het4edsh5oldhe2s5ph5eroushort5here5aher4bahera3p3side_5sideshen5atsi5diz4signahel4lyact5ifhe3l4ihe5do55sine_h5ecathe4canad4dinsion5aad5er_har4lehard3e3sitioha5rasha3ranhan4tead3icahang5oadi4ersk5inesk5ing5hand_han4cyhan4cislith5hala3mh3ab4lsmall32g5y3n5gui5t3guard5smithad5ranaeri4eag5ellag3onia5guerso4labsol3d2so3licain5in4grada3s4on_gor5ougo5rizgondo5xpan4dait5ens5ophyal3end3g4o4ggnet4tglad5i5g4insgin5ge3g4in_spen4d2s5peog3imen5gies_3spher5giciagh5outsp5ingge5nizge4natge5lizge5lisgel4inxi5miz4gativgar5n4a5le5oga3nizgan5isga5mets5sengs4ses_fu4minfres5cfort5assi4erss5ilyfore5tfor5ayfo5ratal4ia_fon4dessur5aflo3ref5lessfis4tif1in3gstam4i5stands4ta4p5stat_fin2d5al5levs5tero4allicstew5afight5fi5del5ficie5ficiafi3cer5stickf3icena5log_st3ingf3icanama5ra5stockstom3a5stone2f3ic_3storef2f5iss4tradam5ascs4trays4tridf5fin_fend5efeath3fault5fa3thefar5thfam5is4fa4mafall5eew3inge5verbeven4ie5vengevel3oev3ellev5asteva2p5euti5let5roset3roget5rifsy5rinet3ricet5onaam5eraam5ilyami4noamor5ieti4noe5tidetai5loethod3eten4dtal5enes5urramp5enan3ageta5loge5strotan4detanta3ta5pere3ston4es2toes5times3tigta3rizestan43analy4taticta4tures4prean3arces3pertax4ises5onaes3olue5skintch5etanar4ies4i4ntead4ie2s5ima3natiande4sesh5enan3disan4dowang5iete5geres5ences5ecres5cana4n1icte2ma2tem3at3tenanwrita45erwau4tenesert3era3nieser3set5erniz4erniter4nis5ter3de4rivaan3i3fter3isan4imewo5vener3ineeri4ere3rient3ess_teth5e5ericke1ria4er3ester5esser3ent4erenea5nimier5enaer3emoth3easthe5atthe3iser5el_th5ic_th5icaere3in5thinkere5coth5odea5ninee3realan3ishan4klier4che5anniz4erandti4atoanoth5equi3lep5utat4ic1uan4scoe4probep3rehe4predans3poe4precan4surantal4e3penttim5ulep5anceo5rol3tine_eop3aran4tiewin4deap5eroen3ishen5icsen3etren5esten5esien5eroa3pheren3dicap3itae4nanten5amoem5ulaa3pituti3zen5emnize5missem5ishap5olaem5ine3tles_t5let_em1in2apor5iem3icaem5anael3op_el4labapos3te3liv3el5ishaps5esweath3e3lierel3icaar3actwa5verto3nate3libee4l1erel3egato3rietor5iza5radeelaxa4aran4gto3warelan4dej5udie5insttra5chtraci4ar5av4wa5gere5git5arbal4ar5easeg5ing4voteetrem5iar3enta5ressar5ial4tricsvor5abe3finetro5mitron5i4tronyar3iantro3sp5eficia3rieted5uloed3icae4d1erec3ulaec4tane4cremeco5roec3orae4concar5o5de4comme4cluse4clame5citeec5ifya5ronias3anta5sia_tu4nis2t3up_ecan5ce4belstur3ise4bel_eav3ene4a3tue5atifeath3ieat5eneart3eear4ilear4icear5eseam3ereal3oueal5erea5geread5iedum4be4ducts4duct_duc5eras3tenasur5adrea5rat3abl4d5outdo3natdom5izdo5lor4dlessu4bero3dles_at3alou3ble_d4is3tdirt5idi5niz3dine_at5ech5di3endi4cam1d4i3ad3ge4tud5estdev3ilde3strud3iedud3iesdes3tide2s5oat3egovis3itde4nardemor5at3en_uen4teuer4ilde5milat3eraugh3en3demicater5nuil5izdeli4ede5comde4cildecan4de4bonv3io4rdeb5it4dativ2d3a4bat3estu5laticu4tie5ulcheul3dercuss4icu5riaath5em3cultua5thenul3ingul5ishul4lar4vi4naul4liscu5ityctim3ic4ticuuls5esc5tantultra3ct5angcros4ecrop5ocro4pl5critiath5omum4blycre3at5vilitumor5oat5i5b5crat_cras5tcoro3ncop3iccom5ercol3orun5ishco3inc5clareat3ituunt3abat5ropun4tescit3iz4cisti4cista4cipicc5ing_cin3em3cinatuper5s5videsup3ingci2a5b5chini5videdupt5ib5vide_at4tag4ch1inch3ersch3er_ch5ene3chemiche5loure5atur4fercheap3vi5aliat3uravet3er4ch3abc5e4taau5sib3cessives4tece5ram2cen4e4cedenccou3turs5erur5tesur3theaut5enur4tiecav5al4cativave4nover3thcar5omca5percan4tycan3izcan5iscan4icus4lin3versecal4laver3ieca3latca5dencab3in3butiobuss4ebus5iebunt4iv4eresuten4i4u1t2iv3erenu3tineut3ingv4erelbroth35u5tizbound34b1orabon5at5vere_bom4bibol3icblun4t5blespblath5av3erav5enuebi3ogrbi5netven3om2v1a4bvac5ilbi3lizbet5izbe5strva5liebe5nigbbi4nabas4siva5nizbari4aav5ernbarbi5av5eryvel3liazi4eravi4er");
            put(7, "_dri5v4ban5dagvar5iedbina5r43bi3tio3bit5ua_ad4derution5auti5lizver5encbuf4ferus5terevermi4ncall5incast5ercas5tigccompa5z3o1phros5itiv5chanicuri4fico5stati5chine_y5che3dupport54v3iden5cific_un4ter_at5omiz4oscopiotele4g5craticu4m3ingv3i3liz4c3retaul4li4bcul4tiscur5a4b4c5utiva5ternauiv4er_del5i5qdem5ic_de4monsdenti5fdern5izdi4latou4b5ingdrag5on5drupliuar5ant5a5si4tec5essawo4k1enec5ifiee4compear5inate4f3eretro5phewide5sp5triciatri5cesefor5ese4fuse_oth5esiar5dinear4chantra5ventrac4tetrac4itar5ativa5ratioel5ativor5est_ar5adisel5ebraton4alie4l5ic_wea5rieel5igibe4l3ingto5cratem5igraem3i3niemoni5oench4erwave1g4a4pillavoice1ption5eewill5inent5age4enthesvaude3vtill5inep5recaep5ti5bva6guer4erati_tho5rizthor5it5thodicer5ence5ternitteri5zater5iesten4tage4sage_e4sagese4sert_an5est_e4sertse4servaes5idenes5ignaesis4tees5piraes4si4btal4lisestruc5e5titioounc5erxe4cutota5bleset5itiva4m5atoa4matis5stratu4f3ical5a5lyst4ficatefill5instern5isspend4gani5zasqual4la4lenti4g3o3nas5ophiz5sophicxpecto55graph_or5angeuri4al_4graphy4gress_smol5d4hang5erh5a5nizharp5enhar5terhel4lishith5erhro5niziam5eteia4tricic4t3uascour5au2r1al_5scin4dover4nescan4t55sa3tiou5do3ny_ven4de_under5ty2p5al_anti5sylla5bliner4arturn3ari5nite_5initioinsur5aion4eryiphras4_tim5o5_ten5an_sta5blrtroph4_se5rieiq3ui3t5i5r2izis5itiviso5mer4istral5i5ticki2t5o5mtsch3ie_re5mittro3fiti4v3er_i4vers_ros5per_pe5titiv3o3ro_ped5alro5n4is_or5ato4jestierom5ete_muta5bk5iness4latelitr4ial__mist5i_me5terr4ming_lev4er__mar5tilev4eralev4ers_mag5a5liar5iz5ligaterit5ers_lat5errit5er_r5ited__im5pinri3ta3blink5er_hon5ey5litica_hero5ior5aliz_hand5irip5lic_gen3t4tolo2gylloqui5_con5grt1li2erbad5ger4operag_eu4lertho3donter2ic__ar4tie_ge4ome_ge5ot1_he3mo1_he3p6a_he3roe_in5u2tpara5bl5tar2rht1a1mintalk1a5ta3gon_par5age_aster5_ne6o3f_noe1thstyl1is_poly1s5pathic_pre1ampa4tricl3o3niz_sem4ic_semid6_semip4_semir45ommend_semiv4lea4s1a_spin1oom5etryspher1o_to6poglo4ratospe3cio3s2paceso2lute_we2b1l_re1e4ca5bolicom5erseaf6fishside5swanal6ysano5a2cside5stl5ties_5lumniasid2ed_anti1reshoe1stscy4th1s4chitzsales5wsales3cat6tes_augh4tlau5li5fom5atizol5ogizo5litiorev5olure5vertre5versbi5d2ifbil2lab_earth5pera5blro1tronro3meshblan2d1blin2d1blon2d2bor1no5ro1bot1re4ti4zr5le5quperi5stper4malbut2ed_but4tedcad5e1moist5enre5stalress5ibchie5vocig3a3roint5er4matizariv1o1lcous2ticri3tie5phisti_be5stoog5ativo2g5a5rr3a3digm4b3ingre4posir4en4tade4als_od5uctsquasis6quasir6re5fer_p5trol3rec5olldic1aiddif5fra3pseu2dr5ebrat5metric2d1lead2d1li2epro2g1epre1neuod5uct_octor5apoin3came5triem5i5liepli5narpara3memin5glim5inglypi4grappal6matmis4er_m5istryeo3graporth1riop1ism__but4tio3normaonom1icfeb1ruafermi1o_de4moio5a5lesodit1icodel3lirb5ing_gen2cy_n4t3ingmo5lestration4get2ic_4g1lishobli2g1mon4ismnsta5blmon4istg2n1or_nov3el3ns5ceivno1vembmpa5rabno4rarymula5r4nom1a6lput4tinput4tedn5o5miz_cam4penag5er_nge5nesh2t1eoun1dieck2ne1skiifac1etncour5ane3backmono1s6mono3chmol1e5cpref5ac3militapre5tenith5i2lnge4n4end5est__capa5bje1re1mma1la1ply5styr1kovian_car5olprin4t3lo2ges_l2l3ishprof5it1s2tamp");
            put(8, "lead6er_url5ing_ces5si5bch5a5nis1le1noidlith1o5g_chill5ilar5ce1nym5e5trych5inessation5arload4ed_load6er_la4c3i5elth5i2lyneg5ativ1lunk3erwrit6er_wrap3arotrav5es51ke6linga5rameteman3u1scmar1gin1ap5illar5tisticamedio6c1me3gran3i1tesima3mi3da5bves1titemil2l1agv1er1eigmi6n3is_1verely_e4q3ui3s5tabolizg5rapher5graphicmo5e2lasinfra1s2mon4ey1lim3ped3amo4no1enab5o5liz_cor5nermoth4et2m1ou3sinm5shack2ppo5sitemul2ti5uab5it5abimenta5rignit1ernato5mizhypo1thani5ficatuad1ratu4n5i4an_ho6r1ic_ua3drati5nologishite3sidin5dling_trib5utin5glingnom5e1non1o1mistmpos5itenon1i4so_re5stattro1p2istrof4ic_g2norespgnet1ism5glo5binlem5aticflow2er_fla1g6elntrol5lifit5ted_treach1etra1versl5i5ticso3mecha6_for5mer_de5rivati2n3o1me3spac6i2t3i4an_thy4l1antho1k2er_eq5ui5to4s3phertha4l1amt3ess2es3ter1geiou3ba3dotele1r6ooxi6d1iceli2t1isonspir5apar4a1leed1ulingea4n3iesoc5ratiztch3i1er_kil2n3ipi2c1a3dpli2c1abt6ap6athdrom3e5d_le6icesdrif2t1a_me4ga1l1prema3cdren1a5lpres2plipro2cess_met4ala3do5word1syth3i2_non1e2m_post1ampto3mat4rec5ompepu5bes5cstrib5utqu6a3si31stor1ab_sem6is4star3tliqui3v4arr1abolic_sph6in1de5clar12d3aloneradi1o6gs3qui3tosports3wsports3cra5n2hascro5e2cor3bin1gespokes5wspi2c1il_te3legrcroc1o1d_un3at5t_dictio5cat1a1s2buss4ingbus6i2esbus6i2erbo2t1u1lro5e2las1s2pacinb1i3tivema5rine_r3pau5li_un5err5r5ev5er__vi2c3arback2er_ma5chinesi5resid5losophyan3ti1n2sca6p1ersca2t1olar2rangesep3temb1sci2uttse3mes1tar3che5tsem1a1ph");
            put(9, "re4t1ribuuto5maticl3chil6d1a4pe5able1lec3ta6bas5ymptotyes5ter1yl5mo3nell5losophizlo1bot1o1c5laratioba6r1onierse1rad1iro5epide1co6ph1o3nscrap4er_rec5t6angre2c3i1prlai6n3ess1lum5bia_3lyg1a1miec5ificatef5i5nites2s3i4an_1ki5neticjapan1e2smed3i3cinirre6v3ocde2c5linao3les3termil5li5listrat1a1gquain2t1eep5etitiostu1pi4d1v1oir5du1su2per1e6_mi1s4ers3di1methy_mim5i2c1i5nitely_5maph1ro15moc1ra1tmoro6n5isdu1op1o1l_ko6r1te1n3ar4chs_phi2l3ant_ga4s1om1teach4er_parag6ra4o6v3i4an_oth3e1o1sn3ch2es1to5tes3toro5test1eror5tively5nop5o5liha2p3ar5rttrib1ut1_eth1y6l1e2r3i4an_5nop1oly_graph5er_5eu2clid1o1lo3n4omtrai3tor1_ratio5na5mocratiz_rav5en1o");
            put(10, "se1mi6t5ic3tro1le1um5sa3par5iloli3gop1o1am1en3ta5bath3er1o1s3slova1kia3s2og1a1myo3no2t1o3nc2tro3me6c1cu2r1ance5noc3er1osth1o5gen1ih3i5pel1a4nfi6n3ites_ever5si5bs2s1a3chu1d1ri3pleg5_ta5pes1trproc3i3ty_s5sign5a3b3rab1o1loiitin5er5arwaste3w6a2mi1n2ut1erde3fin3itiquin5tes5svi1vip3a3r");
            put(11, "pseu3d6o3f2s2t1ant5shimi1n2ut1estpseu3d6o3d25tab1o1lismpo3lyph1onophi5lat1e3ltravers3a3bschro1ding12g1o4n3i1zat1ro1pol3it3trop1o5lis3trop1o5lesle3g6en2dreeth1y6l1eneor4tho3ni4t");
            put(12, "3ra4m5e1triz1e6p3i3neph1");
        }
    }), es("es", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "1b1c1d1f1g1j1k1l1m1n1ñ1p1q1r1s1t1v1w1x1y1z");
            put(3, "_a22bb2bc2bd2bf2bg2bj2bkb2l2bm2bn2bp2bqb2r2bs2bt2bv2bw2bx2by2bz2cb2cc2cd2cf2cgc4h2cjc2kc2l2cm2cn2cp2cqc2r2cs2ct2cv2cw2cx2cy2cz2db2dc2dd2df2dg2dj2dk2dl2dm2dn2dp2dqd2r2ds2dt2dv2dw2dx2dy2dz4e_4é_4és2fb2fc2fd2ff2fg2fj2fkf2l2fm2fn2fp2fqf2r2fs2ft2fv2fw2fx2fy2fz2gb2gc2gd2gf2gg2gj2gkg2l2gm2gn2gp2gqg2r2gs2gt2gv2gw2gx2gy2gz2hb2hc2hd2hf2hg2hj2hk2hl2hm2hn2hp2hq2hr2hs2ht2hv2hw2hx2hy2hz4í_2jb2jc2jd2jf2jg2jj2jk2jl2jm2jn2jp2jq2jr2js2jt2jv2jw2jx2jy2jz2kb2kc2kd2kf2kg2kj2kkk2l2km2kn2kp2kqk2r2ks2kt2kv2kw2kx2ky2kz2lb2lc2ld2lf2lg2lj2lkl4l2lm2ln2lp2lq2lr2ls2lt2lv2lw2lx2ly2lz2mb2mc2md2mf2mg2mj2mk2ml2mm2mn2mp2mq2mr2ms2mt2mv2mw2mx2my2mz2nb2nc2nd2nf2ng2nj2nk2nl2nm2nn2np2nq2nr2ns2nt2nv2nw2nx2ny2nz2o_2pb2pc2pd2pf2pg2pj2pkp2l2pm2pn2pp2pqp2r2ps2pt2pv2pw2px2py2pz2qb2qc2qd2qf2qg2qj2qk2ql2qm2qn2qp2qq2qr2qs2qt2qv2qw2qx2qy2qz2rb2rc2rd2rf2rg2rj2rk2rl2rm2rn2rp2rqr2r2rs2rt2rv2rw2rx2ry2rz2sb2sc2sd2sf2sg2sj2sk2sl2sm2sn2sp2sq2sr2ss2st2sv2sw2sx2sy2sz2tb2tc2td2tf2tg2tj2tk2tm2tn2tp2tqt2r2ts2tt2tv2twt2x2ty2tz2vb2vc2vd2vf2vg2vj2vkv2l2vm2vn2vp2vqv2r2vs2vt2vv2vw2vx2vy2vz2wb2wc2wd2wf2wg2wj2wkw2l2wm2wn2wp2wqw2r2ws2wt2wv2ww2wx2wy2wz2xb2xc2xd2xf2xg2xj2xk2xl2xm2xn2xp2xq2xr2xs2xt2xv2xw2xx2xy2xz2yb2yc2yd2yf2yg2yj2yk2yl2ym2yn2yp2yq2yr2ys2yt2yv2yw2yx2yy2yz2zb2zc2zd2zf2zg2zj2zk2zl2zm2zn2zp2zq2zr2zs2zt2zv2zw2zx2zy2zz");
            put(4, "4ad_2al_4an_4ar_4as_4ás_2b1h2bl_2br_2ch_2cl_4cn_2cr_4ct_4cz_2d1h2dr_4ed_4en_4er_4es_2f1h2fl_2fr_4ft_2g2h2gl_4gn_2gr_2h1hi2a_4ía_i2o_2j1h2k2h2kl_2kr_2l1h2ll_mal22m1h4mn_2n1h2no_4ón_2os_4pc_2p1h2pl_4pn_2pr_4pt_2q1h2r1h2rr_3sa_2s1h2t1h2t2l2tr_4ts_4tz_2v1h2vl_2vr_2w1h2wl_2wr_2x1h2y1h2z1h");
            put(5, "_an3h4áis_4ando4aos_bien2bio1heco1h4éis_4eos_geo1h4ían_i2as_4ías_i2os_iso1hmal3bmal3cmal3dmal3fmal3gmal3mmal3pmal3qmal3smal3tmal3v4meo_neo1ho2os_2ótic3sas_s3te_");
            put(6, "_an2a2_an2á2_an2e2_an2é2_an2i2_an2í2_ani3m_aniña_ani3q_an2o2_an2ó2_an2u2_anu3l_bi1ox_bi1un_co2a2_co2á2_co2e2_co2é2_co2i2_co2í2_co3o4_co2ó2_co2u2_co2ú2_en2a2_en2á2_en2e2_en2é2_en1ej_en2i2_en2í2_en2o2_en2ó2_en2u2_en2ú2_in2a2_in2á2_in2e2_in2é2_in2i2_in2í2_in2o2_in2ó2_in2u2_in2ú2_re2a2_re2á2_re3e4_re2é2_re2i2_re2í2_re2o2_re2ó2_re1oc_re1oj_re2u2_re2ú24a3ba_acto1h4a3da_4adle_4adlo_4adme_4a3do_4adte_aero1hafro1haí5so_2ales_ana3líanfi1hante1h4a3ra_4a3rá_4a3re_4a3ré_a3rio_4a3se_4aste_asu3b24ates_auto1h2b3c2n2b3c2t2b3c2z2b3f2t2b3g2nbien3hbien3mbien3qbien3tbien3vbio1a2bio1á2bio1e2bio1é2bio1i2bio1í2bio1o2bio1ó2bio1u2bio1ú22b3m2n2b3p2n2b3p2s2b3p2t2b3t2s2b3t2z4caca44caga44cago42c3c2n2c3c2t2c3c2z2c3f2t2c3g2ncito1h2c3m2nco4artco4ártco4ercco4erzco4optco4ord2c3p2n2c3p2s2c3p2t2c3t2s2c3t2z4culo42d3c2n2d3c2t2d3c2zdeca1hde3seo2d3f2t2d3g2n2d3m2n2d3p2n2d3p2s2d3p2t2d3t2s2d3t2zeco1a2eco1á2eco1e2eco1é2eco1i2eco1í2eco1o2eco1ó2eco1u2eco1ú24edle_4edlo_4edme_4edte_emi2o2endo1hento1h4e3rá_4e3ré_4erla_4erle_4erlo_4erme_4erse_4erte_euco1heuro1hfono1hfoto1hgeo1a2geo1á2geo1e2geo1é2geo1i2geo1í2geo1o2geo1ó2geo1u2geo1ú2hemi1hhemo1hhexa1hhomo1h4íais_2i3ca_2i3co_4í3da_4í3do_4i4er_4i3ga_4i3go_4ísmo_iso1a2iso1á2iso1e2iso1é2iso1i2iso1í2iso1o2iso1ó2iso1u2iso1ú24ísta_kilo1h2l3c2n2l3c2t2l3c2z2l3f2t2l3g2n2l3m2n2l3p2n2l3p2s2l3p2t2l3t2s2l3t2zma4l3hmaxi1h2m3c2n2m3c2t2m3c2zmega1h2m3f2t2m3g2nmili1hmini1h2m3m2nmono1h2m3p2n2m3p2s2m3p2t2m3t2s2m3t2znamo1h2n3c2n2n3c2t2n3c2zneo1a2neo1á2neo1e2neo1é2neo1i2neo1í2neo1o2neo1ó2neo1u2neo1ú2neto1h2n3f2t2n3g2n2n3m2n2n3p2n2n3p2s2n3p2t2n3t2s2n3t2zocta1hocto1homni1h4ones_2o3sa_2o3so_para1h4pedo4poli1h3p2sic3p2siq4puta44puto42r3c2n2r3c2t2r3c2z2r3f2t2r3g2n2r3m2nromo1h2r3p2n2r3p2s2r3p2t2r3t2s2r3t2z2s3c2n2s3c2t2s3c2zsemi1h2s3f2t2s3g2n2s3m2n2s3p2n2s3p2s2s3p2ts3tal_s3tes_s3tor_2s3t2s2s3t2zsup6ra2t3c2n2t3c2t2t3c2ztele1h4teta_2t3f2t2t3g2n2t3m2ntopo1h2t3p2n2t3p2s2t3p2t2t3t2s2t3t2zu4teriwa3s4h2x3c2n2x3c2t2x3c2zxeno1h2x3f2t2x3g2n2x3m2n2x3p2n2x3p2s2x3p2t2x3t2s2x3t2z2y3c2n2y3c2t2y3c2z2y3f2t2y3g2n2y3m2n2y3p2n2y3p2s2y3p2t2y3t2s2y3t2z");
            put(7, "_ana3li_aná3li_ane3xa_ane3xá_ane3xe_ane3xé_ani3ll_ano5ta_ano3tá_anti1h_an2ú2__anua3l_anu3bl_anu3da_bi1aur_bi1ó2x_en1apa_en1arb_en1art_he4mee_hu4mea_hu4meo_mala1e_pre2a2_pre2á2_pre2e2_pre2é2_pre2h2_pre2i2_pre2í2_pre2o2_pre2ó2_pre2u2_pre2ú2_pro2a2_pro2á2_pro2e2_pro2é2_pro2h2_pro2i2_pro2í2_pro2o2_pro2ó2_pro2u2_pro2ú2_re3abr_re3ábr_re3a2q_re3a2z_re3i2m_re3inc_re3ing_re3ins_re3int_re3o2b_re1unt_so3a4s4a3ban_4a3bas_acante2acto1a2acto1á2acto1e2acto1é2acto1i2acto1í2acto1o2acto1ó2acto1u2acto1ú24a3das_4adlas_4adles_4adlos_4adnos_4a3dor_4a3dos_aero1a2aero1á2aero1e2aero1é2aero1i2aero1í2aero1o2aero1ó2aero1u2aero1ú2afro1a2afro1á2afro1e2afro1é2afro1i2afro1í2afro1o2afro1ó2afro1u2afro1ú2aí5sos_4a3mos_anfi1a2anfi1á2anfi1e2anfi1é2anfi1i2anfi1í2anfi1o2anfi1ó2anfi1u2anfi1ú2anglo1hante1a2ante1á2ante1e2ante1é2ante1i2ante1í2ante1o2ante1ó2ante1u2ante1ú24áosla_4áosle_4áoslo_4a3ran_4a3rán_4a3ras_4a3rás_archi1h4a3ren_4a3res_4a3rés_4a3ría_a3rios_4a3rís_4a4rme_4a3ron_4a3ros_4a3sen_4a3ses_4astes_auto1a2auto1á2auto1e2auto1é2auto1i2auto1í2auto1o2auto1ó2auto1u2auto1ú2bi1u2ní4cagas_centi1hciclo1hcito1a2cito1á2cito1e2cito1é2cito1i2cito1í2cito1o2cito1ó2cito1u2cito1ú23c2neorcnico1hco4accico4actico4adjuco4adyuco3agenco4e3táco3exisco4imbrco4incico4i3tocon1urbcrono1hdeca1a2deca1á2deca1e2deca1é2deca1i2deca1í2deca1o2deca1ó2deca1u2deca1ú2decimo1desa3fidesa3fídesa3güde4s3eqde3signde3sollea3cia_ea3cio_4eadla_ecano1hectro1h4edlas_4edles_4edlos_4ednos_4e3dro_4eedla_4emboca4e3mos_endo1a2endo1á2endo1e2endo1é2endo1i2endo1í2endo1o2endo1ó2endo1u2endo1ú2ento1a2ento1á2ento1e2ento1é2ento1i2ento1í2ento1o2ento1ó2ento1u2ento1ú2entre1h4éosla_4éosle_4éoslo_e5r4ad_e5r4an_4e3rán_e5r4as_4e3rás_4e3rés_4e3ría_4e3rís_4erlas_4erles_4erlos_4ernos_4e3ros_euco1a2euco1á2euco1e2euco1é2euco1i2euco1í2euco1o2euco1ó2euco1u2euco1ú2euro1a2euro1á2euro1e2euro1é2euro1i2euro1í2euro1o2euro1ó2euro1u2euro1ú2expoli4extra1hfono1a2fono1á2fono1e2fono1é2fono1i2fono1í2fono1o2fono1ó2fono1u2fono1ú2foto1a2foto1á2foto1e2foto1é2foto1i2foto1í2foto1o2foto1ó2foto1u2foto1ú2gluco1hhecto1hhelio1hhemi1a2hemi1á2hemi1e2hemi1é2hemi1i2hemi1í2hemi1o2hemi1ó2hemi1u2hemi1ú2hemo1a2hemo1á2hemo1e2hemo1é2hemo1i2hemo1í2hemo1o2hemo1ó2hemo1u2hemo1ú2hexa1a2hexa1á2hexa1e2hexa1é2hexa1i2hexa1í2hexa1o2hexa1ó2hexa1u2hexa1ú2hidro1hhisto1hhomo1a2homo1á2homo1e2homo1é2homo1i2homo1í2homo1o2homo1ó2homo1u2homo1ú2ia5res_2i3cas_icono1h2i3cos_4i2dal_4í3das_4i3deo_4í3dos_4i3gas_4i3gás_4í3mos_infra1hintra1h4ísmos_4ístas_4í3tes_kilo1a2kilo1á2kilo1e2kilo1é2kilo1i2kilo1í2kilo1o2kilo1ó2kilo1u2kilo1ú2li5áreamacro1hmante4amaxi1a2maxi1á2maxi1e2maxi1é2maxi1i2maxi1í2maxi1o2maxi1ó2maxi1u2maxi1ú2mega1a2mega1á2mega1e2mega1é2mega1i2mega1í2mega1o2mega1ó2mega1u2mega1ú23mente_micro1hmili1a2mili1á2mili4armili1e2mili1é2mili1i2mili1í2mili1o2mili1ó2mili1u2mili1ú2mini1a2mini1á2mini1e2mini1é2mini1i2mini1í2mini1o2mini1ó2mini1u2mini1ú2miria1hmono1a2mono1á2mono1e2mono1é2mono1i2mono1í2mono1o2mono1ó2mono1u2mono1ú2multi1hnamo1a2namo1á2namo1e2namo1é2namo1i2namo1í2namo1o2namo1ó2namo1u2namo1ú2necro1hneto1a2neto1á2neto1e2neto1é2neto1i2neto1í2neto1o2neto1ó2neto1u2neto1ú2norte1hocta1a2octa1á2octa1e2octa1é2octa1i2octa1í2octa1o2octa1ó2octa1u2octa1ú2octo1a2octo1á2octo1e2octo1é2octo1i2octo1í2octo1o2octo1ó2octo1u2octo1ú24o2ica_4o2ico_oligo1homni1a2omni1á2omni1e2omni1é2omni1i2omni1í2omni1o2omni1ó2omni1u2omni1ú22o3sas_2o3sos_4ósteo_paleo1hpara1a2para1á2para1e2para1é2para1i2para1í2para1o2para1ó2para1u2para1ú2penta1hpiezo1hpluri1hpoi3de_poli1a2poli1á2poli1e2poli1é2poli1i2poli1í2poli1o2poli1ó2poli1u2poli1ú2pos3ta_pre3olíproto1hradio1hranco1hretro1hrmano1hromo1a2romo1á2romo1e2romo1é2romo1i2romo1í2romo1o2romo1ó2romo1u2romo1ú2san4c5tsemi1a2semi1á2semi1e2semi1é2semi1i2semi1í2semi1o2semi1ó2semi1u2semi1ú2seudo1hsobre1hsocio1hs3tora_supra1htalmo1htele1a2tele1á2tele1e2tele1é2tele1i2tele1í2tele1o2tele1ó2tele1u2tele1ú2termo1h4tetas_tetra1hti2o3coti2o3qutopo1a2topo1á2topo1e2topo1é2topo1i2topo1í2topo1o2topo1ó2topo1u2topo1ú2tropo1hultra1hxeno1a2xeno1á2xeno1e2xeno1é2xeno1i2xeno1í2xeno1o2xeno1ó2xeno1u2xeno1ú2");
            put(8, "_an3aero_ane3xio_ane3xió_ani3dar_ani3mad_ani3mád_an3i2so_an3i2só_ani3vel_ano5che_ano5din_ano5mal_anó5mal_ano5nad_ano5nim_anó3nim_anti1a2_anti1á2_anti1e2_anti1é2_anti1i2_anti1í2_anti1o2_anti1ó2_anti1u2_anti1ú2_anua4lm_de2s2a2_de2s2á2_de2s2e2_de2s2é2_de2s2i2_de2s2í2_de2s2o2_de2s2ó2_de2s2u2_de2s2ú2_en1aciy_en1anch_en2artr_eno3jar_hepta1e_ina3nic_in3anim_iná3nim_in3apel_iné3dit_in3efic_ini3cia_ini3ciá_ini3cie_ino3cua_ino3cuo_intra1o_intra1u_inú3til_mal1est_mal1int_pos3tin_pos3tín_re3a2eg_re3alim_re3anim_re3aním_re3orga_retro1a_re3unir_re3unír_re3usar_re3usár_su2b2a2_su2b2á2_sub3arr_su2b2e2_su2b2é2_su2b2i2_su2b2í2_sub3ími_sub3índ_su2b2o2_su2b2ó2_su2b2u2_su2b2ú2_sur1est_sur1oes_tra2s1a_tra2s1o_tri1ó2x4a3bais_4a3ción_4ádmele_4ádmelo_4a3dora_4ádsela_4ádsele_4ádselo_4ádtele_4ádtelo_4ándola_4ándole_4ándolo_4ándome_4ándoos_4ándose_4ándote_anglo1a2anglo1á2anglo1e2anglo1é2anglo1i2anglo1í2anglo1o2anglo1ó2anglo1u2anglo1ú24áoslas_4áosles_4áoslos_4a3rais_archi1a2archi1á2archi1e2archi1é2archi1i2archi1í2archi1o2archi1ó2archi1u2archi1ú24a3reis_4a3réis_4a3ríais4a3rían_4a3rías_4a4r3la_4a4r3le_4a4r3lo_4árosla_4árosle_4ároslo_4a4r3se_4a4r3te_4a3seis_4asteis_biblio1hcardio1hcefalo1hcenti1a2centi1á2centi1e2centi1é2centi1i2centi1í2centi1o2centi1ó2centi1u2centi1ú2ciclo1a2ciclo1á2ciclo1e2ciclo1é2ciclo1i2ciclo1í2ciclo1o2ciclo1ó2ciclo1u2ciclo1ú2cnico1a2cnico1á2cnico1e2cnico1é2cnico1i2cnico1í2cnico1o2cnico1ó2cnico1u2cnico1ú2co4a3dunco4a3gulco4á3gulco4a3licco4aptacco4e3ficcon1imbrcontra1hco4o3perco4o3pércripto1hcrono1a2crono1á2crono1e2crono1é2crono1i2crono1í2crono1o2crono1ó2crono1u2crono1ú2de4s3abrde4s3agudesa3lindesa3livde4s3almdesa3lojde4s3anddesa3pañdesa3pegde4s3armdes4armede4s3asndesa3tindesa3yundesa3zondesa3zónde3semejde4s3endde4s3enjde4s3enmde4s3enrde4s3ensde3s4ertde3s4értde3siderde3sidiade3sidiode3siertde3socupde3solacde3soladde3soncede4s3ovade4s3ovide4s3oxide4s3oyede4s3oyéde3suelldodeca1hea3cias_ea3cios_ecano1a2ecano1á2ecano1e2ecano1é2ecano1i2ecano1í2ecano1o2ecano1ó2ecano1u2ecano1ú2ectro1a2ectro1á2ectro1e2ectro1é2ectro1i2ectro1í2ectro1o2ectro1ó2ectro1u2ectro1ú24édmele_4édmelo_4e3dros_4édsela_4édsele_4édselo_4édtele_4édtelo_entre1a2entre1á2entre1e2entre1é2entre1i2entre1í2entre1o2entre1ó2entre1u2entre1ú24éoslas_4éosles_4éoslos_e5r4áis_4e3réis_4e3rían_4e3rías_4e3rior_4érmele_4érmelo_4érsela_4érsele_4érselo_4értele_4értelo_extra1a2extra1á2extra1e2extra1é2extra1i2extra1í2extra1o2extra1ó2extra1u2extra1ú2gastro1hgluco1a2gluco1á2gluco1e2gluco1é2gluco1i2gluco1í2gluco1o2gluco1ó2gluco1u2gluco1ú2hecto1a2hecto1á2hecto1e2hecto1é2hecto1i2hecto1í2hecto1o2hecto1ó2hecto1u2hecto1ú2helio1a2helio1á2helio1e2helio1é2helio1i2helio1í2helio1o2helio1ó2helio1u2helio1ú2hemato1hhidro1a2hidro1á2hidro1e2hidro1é2hidro1i2hidro1í2hidro1o2hidro1ó2hidro1u2hidro1ú2hipe2r3rhisto1a2histo1á2histo1e2histo1é2histo1i2histo1í2histo1o2histo1ó2histo1u2histo1ú24ía3mos_icono1a2icono1á2icono1e2icono1é2icono1i2icono1í2icono1o2icono1ó2icono1u2icono1ú24i3deos_4i3gáis_infra1a2infra1á2infra1e2infra1é2infra1i2infra1í2infra1o2infra1ó2infra1u2infra1ú2inter4ésinter4inintra1a2intra1á2intra1e2intra1é2intra1i2intra1í2intra1o2intra1ó2intra1u2intra1ú24í4s3te_4ística_4ístico_macro1a2macro1á2macro1e2macro1é2macro1i2macro1í2macro1o2macro1ó2macro1u2macro1ú24meable_megalo1hmelano1hmicro1a2micro1á2micro1e2micro1é2micro1i2micro1í2micro1o2micro1ó2micro1u2micro1ú2miria1a2miria1á2miria1e2miria1é2miria1i2miria1í2miria1o2miria1ó2miria1u2miria1ú2multi1a2multi1á2multi1e2multi1é2multi1i2multi1í2multi1o2multi1ó2multi1u2multi1ú2necro1a2necro1á2necro1e2necro1é2necro1i2necro1í2necro1o2necro1ó2necro1u2necro1ú2norte1a2norte1á2norte1e2norte1é2norte1i2norte1í2norte1o2norte1ó2norte1u2norte1ú24o2icas_4o2icos_o4i3dal_4o2i3de_o4i3dea_oligo1a2oligo1á2oligo1e2oligo1é2oligo1i2oligo1í2oligo1o2oligo1ó2oligo1u2oligo1ú24ó3loga_4ó3logo_4ósteos_paleo1a2paleo1á2paleo1e2paleo1é2paleo1i2paleo1í2paleo1o2paleo1ó2paleo1u2paleo1ú2para2is_para4ísopenta1a2penta1á2penta1e2penta1é2penta1i2penta1í2penta1o2penta1ó2penta1u2penta1ú2piezo1a2piezo1á2piezo1e2piezo1é2piezo1i2piezo1í2piezo1o2piezo1ó2piezo1u2piezo1ú2plan4c5tpluri1a2pluri1á2pluri1e2pluri1é2pluri1i2pluri1í2pluri1o2pluri1ó2pluri1u2pluri1ú2poi3des_poli4arqpoli4árqpoli4u3rpos3tas_pre3eligpre3elijpre3eminpre3exispreo3cuppreo2cúppre3opinproto1a2proto1á2proto1e2proto1é2proto1i2proto1í2proto1o2proto1ó2proto1u2proto1ú2radio1a2radio1á2radio1e2radio1é2radio1i2radio1í2radio1o2radio1ó2radio1u2radio1ú2ranco1a2ranco1á2ranco1e2ranco1é2ranco1i2ranco1í2ranco1o2ranco1ó2ranco1u2ranco1ú2retro1a2retro1á2retro1e2retro1é2retro1i2retro1í2retro1o2retro1ó2retro1u2retro1ú2rmano1a2rmano1á2rmano1e2rmano1é2rmano1i2rmano1í2rmano1o2rmano1ó2rmano1u2rmano1ú2seudo1a2seudo1á2seudo1e2seudo1é2seudo1i2seudo1í2seudo1o2seudo1ó2seudo1u2seudo1ú2sobre1a2sobre1á2sobre1e2sobre1é2sobre1i2sobre1í2sobre1o2sobre1ó2sobre1u2sobre1ú2socio1a2socio1á2socio1e2socio1é2socio1i2socio1í2socio1o2socio1ó2socio1u2socio1ú2s3toras_s3tores_su4d3oessupe2r3rsupra1a2supra1á2supra1e2supra1é2supra1i2supra1í2supra1o2supra1ó2supra1u2supra1ú2talmo1a2talmo1á2talmo1e2talmo1é2talmo1i2talmo1í2talmo1o2talmo1ó2talmo1u2talmo1ú23te3ri3ntermo1a2termo1á2termo1e2termo1é2termo1i2termo1í2termo1o2termo1ó2termo1u2termo1ú2tetra1a2tetra1á2tetra1e2tetra1é2tetra1i2tetra1í2tetra1o2tetra1ó2tetra1u2tetra1ú2trans4artrans4ittropo1a2tropo1á2tropo1e2tropo1é2tropo1i2tropo1í2tropo1o2tropo1ó2tropo1u2tropo1ú2ultra1a2ultra1á2ultra1e2ultra1é2ultra1i2ultra1í2ultra1o2ultra1ó2ultra1u2ultra1ú2");
            put(9, "_bi1anual_bien1and_bien1apa_bien1ave_bien1est_bien1int_dieci1o2_en1aceit_en1aguaz_enu3mera_enu3merá_enu3mere_in3abarc_in3abord_in3acent_in3adapt_in3aplic_in3arrug_in3asist_in3efici_in3eludi_ine3narr_ino3cula_ino3culá_ino3cule_inte2r3r_mal1acon_mal1acos_pos2t2a2_pos2t2á2_pos2t2e2_pos2t2é2_pos3terg_pos2t2i2_pos2t2í2_post3ind_pos2t2o2_pos2t2ó2_post3ope_post3rev_pos2t2u2_pos2t2ú2_re3afirm_re3afírm_re3ajust_rea3júst_rea3lism_rea3list_rea3liza_rea3lizá_rea3líza_re3ubica_re3ubíca_reu3mati_reu3máti_su3b4ien_sub2i3ll_su4b3ray_sub3urba_su2d1est_sur1a2me_tele1imp_tele1obj_tra2s2oñ4á3bamos_4ád3mela_4ádmeles_4ádmelos_4ádnosla_4ádnosle_4ádnoslo_4a3doras_4a3dores_4ádselas_4ádseles_4ádselos_4ád3tela_4ádteles_4ádtelos_4a4i3gan_4ándolas_4ándoles_4ándolos_4ándonos_4á3ramos_4a3remos_4á3remos_4a4r3las_4a4r3les_4a4r3los_4á4rmele_4á4rmelo_4a4r3nos_4ároslas_4árosles_4ároslos_4á3semos_biblio1a2biblio1á2biblio1e2biblio1é2biblio1i2biblio1í2biblio1o2biblio1ó2biblio1u2biblio1ú2b4ien3do_cardio1a2cardio1á2cardio1e2cardio1é2cardio1i2cardio1í2cardio1o2cardio1ó2cardio1u2cardio1ú2cefalo1a2cefalo1á2cefalo1e2cefalo1é2cefalo1i2cefalo1í2cefalo1o2cefalo1ó2cefalo1u2cefalo1ú2contra1a2contra1á2contra1e2contra1é2contra1i2contra1í2contra1o2contra1ó2contra1u2contra1ú2cripto1a2cripto1á2cripto1e2cripto1é2cripto1i2cripto1í2cripto1o2cripto1ó2cripto1u2cripto1ú2desa3briddesa3certde4s3acotde4s3aficde4s3afilde4s3afinde4s3afordesa3garrde4s3ahijde4s3aliñdesa3marrdesa3moblde4s3anidde4s3animde4s3anímde4s3anudde4s3apoyde4s3arende4s3avisde4s3empéde4s3enamde4s3enchde4s3enclde4s3encode4s3encrde4s3encude3senfadde3senfádde4s3enfide4s3enfode4s3enfóde3sengañde3sengáñde4s3enlode4s3entade4s3entode4s3entrde4s3entude3s4ercide4s3espade3sesperde3sigualde3siluside4s3imande3sinencde3sinfecde4s3inflde3sistende4s3odorde4s3ordede4s3órdede4s3orejde3s4osegde3su3dande3su3darde3su3dasde4s3unimde4s3unirdodeca1a2dodeca1á2dodeca1e2dodeca1é2dodeca1i2dodeca1í2dodeca1o2dodeca1ó2dodeca1u2dodeca1ú24éd3mela_4édmeles_4édmelos_4édnosla_4édnosle_4édnoslo_4é3drica_4é3drico_4édselas_4édseles_4édselos_4éd3tela_4édteles_4édtelos_e5r4a3ba_e5r4a3da_e5r4a3do_e5r4a3ra_e5r4a3rá_e5r4a3re_e5r4a3ré_e5r4a3se_e5r4aste_e5r4ates_4e3ríais_4e3riora_4ér3mela_4érmeles_4érmelos_4érnosla_4érnosle_4érnoslo_4é3rosla_4é3rosle_4é3roslo_4érselas_4érseles_4érselos_4ér3tela_4érteles_4értelos_gastro1a2gastro1á2gastro1e2gastro1é2gastro1i2gastro1í2gastro1o2gastro1ó2gastro1u2gastro1ú2hemato1a2hemato1á2hemato1e2hemato1é2hemato1i2hemato1í2hemato1o2hemato1ó2hemato1u2hemato1ú2hipe2r1a2hipe2r1á2hipe2r1e2hipe2r1é2hipe2r1i2hipe2r1í2hipe2r1o2hipe2r1ó2hipe2r1u2hipe2r1ú24i2dales_4i3gamos_inter4inointer4ior4ís3teis_4í4s3tes_4ísticas_4ísticos_4meables_megalo1a2megalo1á2megalo1e2megalo1é2megalo1i2megalo1í2megalo1o2megalo1ó2megalo1u2megalo1ú2melano1a2melano1á2melano1e2melano1é2melano1i2melano1í2melano1o2melano1ó2melano1u2melano1ú2mili4arioo4i3deas_4o2i3des_4ó3logas_4o3logía_4ó3logos_pe5r4antepoli4andrpoli4éstes3ta3les_s3ti3lla_supe2r1a2supe2r1á2supe2r1e2supe2r1é2supe2r1i2supe2r1í2super4iorsupe2r1o2supe2r1ó2supe2r1u2supe2r1ú2t4eo3nes_tran4sacctrans4ido");
            put(10, "_an3e2pigr_ante2o3je_en1aguach_in3aguant_ina3movib_in3analiz_in3apreci_in3aprens_inte2r1a2_inte2r1á2_inte2r1e2_inte2r1é2_inte2r1i2_inte2r1í2_inte2r1o2_inte2r1ó2_inte2r1u2_inte2r1ú2_inu3tiliz_ma4l3e4du_pa4n1afri_pa4n1ópti_post3elec_pos3te3ri_pos3ti3go_pos3ti3la_post3impr_pos3ti3ne_pos3ti3za_pos3ti3zo_pos3tó3ni_pos3tu3la_pos3tu3lá_pos3tu3le_pos3tu3lé_pos3tu3ra_re3a2grup_re3aparec_re3utiliz_re3utilíz_sub3aflue_sub3enten_sub3estim_sub3estím_sub3ofici_su2d1a2fr_su2d1a2me_tran2s1ur4a3ciones_4ád3melas_4ádnoslas_4ádnosles_4ádnoslos_4ád3telas_4ándomela_4ándomele_4ándomelo_4ándosela_4ándosele_4ándoselo_4ándoseme_4ándotela_4ándotele_4ándotelo_4ándoteme_4a3ríamos_4á4r3mela_4á4r3sela_4á4r3sele_4á4r3selo_4á4r3tela_4á4r3tele_4á4r3telo_b4ien3das_centi5áreaco3n4imbride4s3abastde4s3abollde4s3abotode4s3aceitdesa3ciertde4s3acompde4s3aconsde4s3acoplde4s3acorrde4s3activde4s3adeudde4s3adornde4s3aferrde4s3agradde4s3agregde4s3agrupde4s3aherrde4s3ajustde4s3alentde4s3alfomde4s3alforde4s3aliende4s3alinede4s3almidde4s3alterde4s3amoldde4s3amortde4s3angeldesa3pacibde4s3apadrde4s3aparedesa3parecdesa3paricde4s3aplicde4s3apretde4s3aprobde4s3arbolde4s3arrimdesa3rrollde4s3arropde4s3arrugde4s3asentde4s3asistdesa3sosegde4s3atencde4s3atendde4s3atentde4s3atornde4s3autorde4s3embalde4s3embálde4s3embarde4s3embárde4s3embotde4s3empacde4s3empañde4s3empáñde4s3empatde4s3empegde4s3emplede4s3empozde4s3encabde4s3encadde4s3encajde4s3encájde4s3encamde3sencantde4s3encapde4s3encarde4s3encárde3senfrende4s3enfurde4s3engarde4s3engasde4s3engomde4s3engozde4s3engrade4s3enladde4s3enlazde3sentendde4s3enterde3sentiende3sentiénde4s3estimde4s3imponde4s3inhibde3s4interde4s3intoxde4s3inverde4s3obligde4s3obstrde4s3ub4icde4s3unierde3s4ustane4a3miento4éd3melas_4édnoslas_4édnosles_4édnoslos_4é3dricas_4é3dricos_4éd3telas_e5r4a3ban_e5r4a3bas_4e3ra3ble_e5r4a3das_e5r4a3dor_e5r4a3dos_e5r4a3mos_e5r4a3ran_e5r4a3rán_e5r4a3ras_e5r4a3rás_e5r4a3ren_e5r4a3res_e5r4a3rés_e5r4a3ría_e5r4a3rís_e5r4a3ron_e5r4a3sen_e5r4a3ses_e5r4astes_4e3re3mos_4e3ríamos_4e3rioras_4e3riores_4ér3melas_4érnoslas_4érnosles_4érnoslos_4é3roslas_4é3rosles_4é3roslos_4ér3telas_familia3riinter4esarmini4a5turo4i3dales_4o3logías_4o3lógica_4o3lógico_para4ulatape3r4e3miaperpon5d6rpoli4anteapoli4o5mies3ti3llas_s3ti3llón_super4ablesupe4r4a3rsupe4r4á3rtrans4ibertrans4igentrans4igirtrans4itabultra4ísmo");
            put(11, "_mal1andant_mal1andanz_pa4n1europ_sub2i3mien_tran2s1alp_tran2s1and_tran2s1atl_tran2s1oce4ándomelas_4ándomeles_4ándomelos_4ándoselas_4ándoseles_4ándoselos_4ándosenos_4ándotelas_4ándoteles_4ándotelos_4ándotenos_4á4r3melas_4á4r3meles_4á4r3melos_4á4r3nosla_4á4r3nosle_4á4r3noslo_4á4r3selas_4á4r3seles_4á4r3selos_4á4r3telas_4á4r3teles_4á4r3telos_de4s3abrochde4s3acelerde4s3acobarde4s3acomoddesa3cralizde4s3acuartde4s3aderezde4s3adorarde4s3advertde4s3agracide4s3agravide4s3alagarde4s3alquilde4s3alumbrde4s3amuebldesa3percibde4s3aprenddesa3prenside4s3aprietde4s3apropide4s3arraigde4s3arreglde4s3arrenddesa3sosiegde4s3atiendde4s3atrancde4s3embargde4s3embolsde4s3emborrde4s3emboscde4s3embragde4s3embrágde4s3embrujde4s3embrújde4s3empedrde4s3empeorde4s3empernde4s3empolvde4s3empotrde4s3encallde4s3encállde4s3enfundde4s3enhebrde4s3entierde4s3entiérde4s3envainde3sesperacde4s3imaginde4s3impresde4s3incentde4s3inclinde4s3incorpde4s3inflamde4s3informde4s3insectde4s3instalde3s4integrde4s3obedecde3s4ubstane5r4a3bais_4e3ra3bles_e5r4a3dora_e5r4a3rais_e5r4a3reis_e5r4a3réis_e5r4a3ríaise5r4a3rían_e5r4a3rías_e5r4a3seis_e5r4asteis_4i3gá3moos_4o3lógicas_4o3lógicos_2o3samente_super4ación4te4r5i4nsutrans4eúntetrans4icióntrans4istortrans4ubsta");
            put(12, "_in3ter2e3sa_in3ter2e3sá_in3ter2e3se_in3ter2e3sé_in3ter2e3so_in3ter2e3só_in3te3r4rog_pa4n1a4meri4á4r3noslas_4á4r3nosles_4á4r3noslos_deca2i3mientde4s3acostumde4s3acreditde4s3adormecdesa3guisadode4s3apolillde4s3articulde4s3embravede4s3embrávede4s3embrollde4s3embróllde4s3emparejde4s3emparéjde4s3emperezde4s3enganchde3senvolvimde4s3estabilde4s3impresXde4s3incruste5r4á3bamos_e5r4a3doras_e5r4a3dores_e5r4á3ramos_e5r4a3remos_e5r4á3remos_e5r4á3semos_4e3rioridad_4i3gá3monos_4i3gá3mosla_4i3gá3mosle_4i3gá3moslo_4i3gá3mosme_4i3gá3moste_s3ti3llones_trans4itorio");
            put(13, "_in3te3r4rump_in3te3r4rupc_in3te3r4ruptde4s3aprovechde4s3empaquetde4s3empaquétde4s3emparentde4s3esperanze5r4a3ríamos_4e3riormente_4i3gá3moosla_4i3gá3moosle_4i3gá3mooslo_4i3gá3mosela_4i3gá3mosele_4i3gá3moselo_4i3gá3moslas_4i3gá3mosles_4i3gá3moslos_supe3r4á3vit_");
            put(14, "4e3rioridades_4i3gá3monosla_4i3gá3monosle_4i3gá3monoslo_4i3gá3mooslas_4i3gá3moosles_4i3gá3mooslos_4i3gá3moselas_4i3gá3moseles_4i3gá3moselos_4i3gá3mosmele_4i3gá3mosmelo_4i3gá3mostele_4i3gá3mostelo_supe3r4á3vits_");
            put(15, "4e3ra3blemente_4i3gá3monoslas_4i3gá3monosles_4i3gá3monoslos_4i3gá3mos3mela_4i3gá3mosmeles_4i3gá3mosmelos_4i3gá3mos3tela_4i3gá3mosteles_4i3gá3mostelos_4o3lógicamente_");
            put(16, "4i3gá3mos3melas_4i3gá3mos3telas_");
            put(17, "_de3s4in3ter2e3sa_de3s4in3ter2e3sá_de3s4in3ter2e3se_de3s4in3ter2e3sé_de3s4in3ter2e3so_de3s4in3ter2e3só");
        }
    }), da("da", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "a3ca1ea3ha3ja5oa5z1ba4bd1be1bib1j1bo4bsb5t3bub5w1by1ce3chck35cy3dad1b1ded1fd1gd3h1did3jd1kd1ld1m3dod1p1dud1v3dye3ee1he5x1faf1bf1d1fef1ff1gf1h1fif1k3fl1fof1p4ft1fuf1v3fy1gag1bg1d1geg3fg1gg1h1gi5gjg3kg1lg1m3gog3p1grg3v1gyi1ai3bi1ci3hi5ii5ji1uj5kj3rk5bk3hk1kk1tl1bl1fl3hl3jl1ll3r4ls1mam1bm3d1mem3fm1gm3h1mim3km1lm1mm1n3mom1r3my3nan1bn1c4nd1nen1f1nin1mn1n1non5pn3r4ns3nyn3zo3ao1co1eo5ho1jo3t3pap3dp3fp3mp3np1t1pup5vqu4r1br1fr1hr1lr1nr3pr1rs1d1ses1fs1msp44tbt1ht1mt1n4tsu1au1eu3iu5qv5hv5jv5kvl41vov5pv5t3vuy3ay3ey5o5bæ3dæ3døe3æe5å3fæ3fø3gæ3gåi3ø3kø3kå1mæ3mø3må3næ5nøo5åpå31sæ1sø5våæ3cæ3eæ5iæ5oø3eå1då1eå5hå3lå3t");
            put(4, "_ae3_om1_po15adg5afgaf3r5afsa4gia4gya5kaa3kea5kraku5a3laa1lea1lial3ka1loa3lua1lya3nu3anva5pea3pia5poa1ra1arba1re5arga1ria3roa3saa3sca1sia3ska3soa1tea1tia1toa5tra1tua5vaa1vebe1k4b1n1br4bs5kb3sob1stby5s4c1c4ch_ci4oda4sd1d4de5ddi1edi5l4d1n4dopd5ovd5rud4smd4sud3tad1tedt5od5trdt5udub5e5ade3afe5age3ake1ale3ane5ape3ate3blebs3e1cie4do3effe3fr3efte3gue3inei5se3jee1kae3kee3kle5kre3kue1kve5kye3lee1lie3loe5lue3lyem1s4enne4noe5nue5ole3ope1ore3ovepi3e1pre3rae1ree1rier1ker3se5rye1tae1tee1tie3tje1toe3tre3tue1tye3ume3un3eure1vae3vee1vifej4f1s4f3taf1tef1tif5toge3sgi4bg5ovgs1ag4segs1pgs1vg3tag1teg1tig5tog3trgt4sg3udgun5g5yd4ha_he5s4hethi4ehi3s4h3thun4hvo4i3dri1eli1eni3erif3ri3gui1kai1keik1li5koi3kuik3vi3liil3ki1loil5ui3mu5infin3si3nui3odi3ogi5oki3olion4i3oti5pii5pri3rei3riir5ti3sci3sii4smis3pi1tai1tei1tii3toi3tri1tui3tyi1vai1vei1vij3agjds1j3lej3lijre5ju3s5kapk5au5kavki3ek1le3kluk4ny5kod1konko3v1kra5kryk1siks3kks1pks5vkt5s3kur1kus3kutk4vok4vu5lab5lam1latl3dr1le_5led3len1ler1les4leuli5ol1kel1kol3kyl5mul3op3lov4l3pl4psl5sjl1tal1tel3tilt3ol3trl3tulu5ll3vel3vimi3kmi4o4mopm1pem3pim3plm1pom3prm5skms3pms5vm3tam3tem3tim3trm1ud1mul4nak1naln3drne5aneo4n4go4n1h4nimni5on1ken1kon3krn3kun5kv4n1ln3sin1tan1ten1tin3ton1trn3tun3ty4n1vo4asod5sof5ro5ino3kao1keo3kuo3lao3leo1lio1loo3luo5ly1omron3kook5o3oro5ovo3piop3lop3rop3s4or_o3rior3kor5oo3sio3soo1teo5unov4s4pec3pen1perpe5spe3u4p5h1pla5pok3potp4rop3skp5sops4pp3stpu5b5py34rafr3dr1relr1guri1er3kar1ker1kir3kurmo4r5muro1bro3pr3orr1sar1sirs4nr3spr5sur3svr1ter1tir3tort3sr5tyr3ud5rutr3var1ver3viry4ss3af1sams3aps1ar1sat4s1bsdy4s4ed4s3h1sig5sis5sit5sius5ju4sk_1skes3kl5skys1les1lislo35slus5lys4myso5k5sol3sons1pls5r4s1s44st_5stj3sto1strs1ud3suls3un3surs3ve3s4y5ta_1tag3tegteo14t1f6t3g3tid4t3k4t1l4t3pt4ra1tryt3sit3st4t1t5turt5ve1typ5udlud5rud3s3udvugs3u5guu5klu1lau1leu5lyu5peup5lu3rau3reu3rous5au3siu5sous5vu1teu1tiu1tout5r5u5vva5d1vedve3s5vet1visv3lev5livls1v5rev3stv5suy5dry3key5kiy3koy3kvy5liy5loy5muyns5y1pey3piy3rey3riy3siy3tiy5vezi5o_så3a3tøa5væe3læe3løe3røe5tæe5tøe1vægiø4g4søg5så3gø1i5tæl3væ5løsm5tån3kæn5tæo5læor3ø5præ5pædr5kær5tær5tør3vær5æl4røn5rør3rådr5års4kå3slås4næ5stø1stås5økti4øt4søt5såt3væu3læy5vææb3læg5aægs5æ5kvæ1reæ3riær5sæ5siæ3soæ3veøde5ø1jeø3keø3leøms5ø1reø3riør5oø1veå3reå5sk");
            put(5, "_an3k_an1s_be1t_her3_ove4_til3_yd5rab5le3abstaf4ria4gefag5inag5si3agtiais5t4alkval5siam4paar5af3a3spa3stea3stia1ta1ato5vba4tibe3robe5rube1s4be1trbi5skbo4grbo3rabo5rece5ro4d3afde5sk3drif3drivd5rosds5ands5ind1skidsu5lds5viea4laed5aredde4ed5raed3re4e1koek5sa3ekspe3ladel3akel3are1lase4lek3elem5elimel5sae4maden5ake4nanen3soer3afe4rage4rake4ref5erhve4ribero5der5over5tre3rumer5unfa4cefags3fejl1fo4rif5tvig3artgi3st4g5omgsha4g5slags3org4strheds3hi4n5ho5koho5vehund3i4bleids5ki3et_ik3reik5riiks5tik4tui3lagil3egil5ejil5elind3tings1in4svions1i5o5ri3plii3stii5suakel5ske3skke5stki3stk5lakko3ra3kortks3ank3stek5stuk4tarkti4ekt5relad3r5lagdld3st4lelele4molfin4l1go1li4galo4du4l5orlses1ls5inl4taf4m5ejm5ingmmen5mo4da4m5ovmse5sms5inm3stemu1lind5sind5sknd5spne4dan3erkn5erlne5slne5stni3stn3ordn1skuns3pon1stan5stint4suob3lio4dinod5riod5uno4geko4gelo4g5oog5reog5sk3optaor1an3ordnord5so3re_o3rego3reko3rero3retor5imor3slor3stpa5ghp5anlpe1rap4lan4ple_4pler4ples4p5p41procp5ulera5is4rarbrd4s34reksre5la5rese4ressre3st5rettri5la4rimor4ing4rinp4rintrk3sorre5sr5skrr5stur5talrt3rer5trir5trosa4ma5s4erse4se4s1g4si4bls5int1skabsk5s44snins4nit5som_3somms5oms5somt4s1op3spec4sper3s4pi1stanst5as3stat1stav1ste_1sted3stel1sten5step3stes5stetst5om1sy1s4tanvteds55tekn5termte5roti4enti3stto5rato1reto1ritor4m4trestro5vts4pats5prts5ult5udsue4t5uk4tauk4tru1reru5skaut5s43varm4v5omyk3liyk4s5yr3eky5t3r_ær5i_øv3rbrød35drøvdstå4er5øn4n5æb4s5ænså4r53værd1værkæ4gekæ4g5rælle4æn1drær4maær4moæ3steøn3støn4t3ørne3års5t");
            put(6, "_be5la_bi4tr_der3i_ne4t5ade5la5a4f1l3analyan4k5ra4t5ind5antade4rig4dretteddel5ed3rined4stre4j5el3eksemer5egeetek4sfor1enger3ini4l5idinter1i1sterit5re_jek4to4j5en_ke4t5ak4terhla4g3rlfind54l5ins4l3intmi5stynemen4nta4lent4s5toi6s5eo3re3so4r5in4po3rer4d5arr5enssre5spore5s4urro4n5r4sk5vr4telir4t5orrt5ratrun4da5s4tam5stemo3ster_tands3tede4ltli4s5uge4riu4r3egve4l5eve4reg3træk_ær4g5r");
            put(7, "_hoved3bu4s5tr4de4lemder5eri5d4reveem4p5lee4v3erfjde4rerjlmeld5l4t5erfntiali43orientringse43sprog_vi4l3infø4r5en");
            put(8, "_diagno54g5endengsde4leng5s4tidejlmel4dinement5eringso4rtialis5t");
            put(9, "ldiagnos5lingeniø4");
        }
    }), ga("ga", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "2ce2ge2nga1haf1ap1b1cb1fb1tc1pc1ác2hc2od1bd1cd1gd1md1nd1sd2he1ce1de1fe1ge1ten1er1f1nf2tg1ag1bg1dg1ág1íg2hh1bh1ch1dh1gh1phn2ht1i1hic1if1ip1ir1iv1l1fl1ml1nl1rl1tl1vm1cm1dm1em1gm1lm1rm1tm1ám1ím1ón1an1bn1cn1fn1in1ln1mn1pn1rn1top1oí1p1cp1fp1np1sp1tr1fr1ls1as1bs1ds1fs1gs1ls1ps1rs1át1bt1ct1gt1mt1ít2hts2ud1uf1up1v1av1áád1ál1án1áp1ár1é1bé1cé1fé1gé1ré1sé1tí1fí1hín1ód1óg1ól1ón1ór1ú1fú1áúb1úd1úl1úp1úr1");
            put(4, "1bho1bhu1chu1dhá1fh21gio1gum1lál1méa1p2h1sh21tei2alr2asl2c1f2c1t2clo2cn22cí_2d1f2eá_2g1f2g1t2img2m1f2mh_2nag2nap2nio2nn_2ocf2oct2roí2t1f2t1l2ír12óp13acm3ché3cip3cír3cón3cúr3dho3dhu3dor3dó_3gho3gru3lúb3nom3pís3tá_3tól3tóp4adc4amb4amt4bhs4ch_4cht4clu4dib4din4eid4eil4eip4eám4fri4fás4gh_4gri4gú_4ilc4ios4its4iúd4lóv4lúd4móf4ná_4oc_4pe_4rap4rih4róc4róm4rúd4th_4ths4ísh4óda4ódó4óia4úid5cos5dip5mul5tír6amp6anb6aod6bh_6cóp6dh_6ghd6iút6mál6ois6olt6onr6pu_6píl6sc_6sif6st_6ti_6urn6us_6áip6íop6ógt6óiv6úlr6únl_ar2_aí4_bh4_ca4_ch4_ci6_cí6_da6_dh2_ei6_fa6_gh2_ha4_há6_hí2_hó6_id2_il3_ir4_is4_it6_la4_li6_lú2_mh2_nd6_ng4_od6_ra4_rá6_sc6_si4_sm4_st4_ta6_th2_ti6_íl3_ío6_óp6_úd2_úm5a1bra1dóa1moa3foa3goa3lía5bia5bua5roa5vóa6lla6ltab1aab1lab1áab1úab3dabh1ac1aac1lac1nac1óac5éac5úad1rad1úad3iad3uadh1ae1áae3aaf6úag1lag3eag3iag3éag3úagh1ah6aal1aal1áal1óal3ial3úal5oamh1an1áan1óan1úan3ean3uan3éang1ann5ar1aar1ear1par1áar1óar3iar3uas1oas1uas1óas1úas3ias3éas3íasc1at1aat1uat1úath1até3aí2cb1aíb1eáb1idb1líb1lób1ríb1s2b1álb1ínb1ítb1ógb3dhb3ghb3níb4hab4heb5dab5déb5pobc4ábh1óbin4bl6iblá4bn6ibp6ibp6ábré6bth6bun1bur2bár4bí3cbúm3c1acc1adc1aíc1eác1m2c1ímc2rec2átc3dhc3ghc4eic4únc6húc6óccas1ch1fchá6ci5vcla4cna6co4mcod3cof5crí6cs3ócs3úcth4cul3cus3cá6icéi6cíl5cít6cór5cú6icúl5d1acd1add1aid1and1aíd1eod1igd1imd1itd1lad1léd1rád1ríd1t2d1áld1ímd1ítd1ófd2ísd3lód3ved6emd6ádda6bdae5dar1deá4dh2bdh5fdic4dm6idmh2dn4ido3tdob4dr4úds4ads6rdta6dur1dár5dí2odív3e3bhe3lue3láe3mhe5seeg6íei4cei4sel1ael3óeor1eá1teá5geó5df2ísf3chf3ghf4epf4hef4luf4oif4orf5téf6huf6úlfa4bfea6fg4afha6fl6ifn4ifo1dfo3bft3ift5áfí4ofús4g1c2g1eog1eág1idg1igg1img1isg1itg1iúg1líg1m2g1róg1s2g1ógg2abg2aeg2nág3irg3ucg3álg3ódg4ecg4ólg5wag6esg6logb6agc6úgca4gcí6gd6agh1fght4gip4gl6úgmh2gth4gó1ch1aíh1idh1igh1líh1mhh1neh1nih1níh1nóh1s2h1ófh2bah2tóh2óth3vóh4dth4gíh4mth4nrh4ogh4omh4onh4árh6céh6esh6píha4chc4ahd2ahd4óhdh4hg6nhgh2hi4mhi6bhl6úhla6hma6hn5thr6úhsc2ht6iháí6hó6si1toi5éai6fei6scib1eib1iib1lib1rib1íibh1ich1id1eid1lid1rid1éig1eig1lig1rig1éigh1il1eil1iil1éil1íil3aim5aimh1in1éin1íin3ein3iin3oin3áing1io6tiod1iof1ip3íir3íis1eis1iis1éis1íis3oit1iit1rith1l1arl1d2l1idl1irl1s2l1ísl1únl2l1l2mal2mel3bál3cll3gél3hal3pél3pól4ecl4efl4eil4eml4fcl4fgl4msl4tml5hel6lól6tblb3nlc1alc3íldú3lg1elg3ilg3llg3rlig3lis1llt4lm6álm6ílmh2ln4aln4ilod5lp1alp1elp3álré5lt2elt2ilár5ló1slúg4lús3m1acm1adm1aim1amm1asm1aím1b2m1icm1igm1ilm1imm1itm1iúm1oim1pem1pim1pom1prm1púm1s2m1uam2ónm3abm3aem3agm3iam3pím3úlm3úsm4blm4pfm4átm4ósm5nam6bdm6esm6ptmb4ómch2mh1fmh1lmh1nmhd6mor2msc4mth6mur5muí6már5mí3bmó5mmór5mút5n1d2n1s2n1uin1áln1árn1ógn1óln1ónn1órn1úln1únn1úsn2can2cán2n1n3iln3ran3trn3ven3írn4edn4egn4emn4men4tmn5dén5hán5inn5lín5rin5sén5áín6bín6cbn6mcn6min6mín6tsnaf5nal3nan2nb6anc3eneo6ng2ángt4ni3fnis1nm4ónmh4nol6nr6únst4ná6inéa6nú5ínút6o1lio1loo1roo3hóo3léo3líob1aob1lob1rob1áob1óob3úobh1oc1loc3áoc5úod1áod3úod5eoen6of5óog1log1rog1óog1úog3eog3oog3uogh1oif3ol1aol1bol1áol1óom1pom3úom5óomh1on1oon1áon1óon1úon3eon3éon5aor1éor1óor1úor3eor3ior5aor5uor5áos1óos1úos3uot1rot1áot1óot1úot3aot3uot5ioth1oí2coíl4p1álp3imp4eip6léph4iph6aph6lpla4pn6apot3ps4apth4pun4pás5pí6tpós3pót3r1brr1chr1grr1s2r1úlr2gir2gír2mer2mír2r1r2ter2tír3búr3gúr3har3nor3wir4ber4cmr4dtr4gdr4gsr4lgr4mlr4mor4msr4nfr4olr4sfr4tcr4tor4udr6dnr6dsr6tsraf3rb3lrc1arc1erc1lrc3nrc3src5úrd1ard1órd3lrd3urd3érd3úrin2rir4rm3úrn1órn2irn3úro4crof5roi4rp1rrr5drrc4rrt4rt1art1rrt1árt1órt3urí2crír2ró6frób4rói6rót1s1ias1ics1ids1igs1ims1iús1m2s1n2s1trs1tés1ófs1ógs1úns3fes3fis3nós4úfs6údsb6asbh6sc1nsis3sla4sm6ismh4sod3sr6úst6usv4asíl3sú5csús5t1eot1igt1sít1óft2art3dht3sit3sut3sút3vit4het4rut5net5nít5sat6hat6hét6áttbh6teá6th1fth1ltis3tm4atm6etm6itof5tr6útíg5ub1aub5áubh1uc1auc3ruc3suc5luc5úug3lui4mui6suid1ul1aul3ául3óum1aumh1ump1un1óun3oun3áun3úun5aun5eung1ur3iur3pur3áur3óur3úur5uut3eut3óut5auth1uz3auí1guí1muí3buí3duí3óv3eov3lav4adv6ícvar5vir5x3acx5aix5aíá1faá3fáá3góá5boá5háá5úláb1láb1ááb3aáb3óáb3úábh1ác1aác3lác3rác3úáf1ráf3lág3rág5uái6máid1álc6ámh1ánt4ás1óás3aás3uás3íás3úás5eásc3át1áát1óát3aát3ráth1é3dhé3héé3láé3líé5leé5mhé5úlé6goé6iné6rbéal1éch4éid1í1chí1dhí1luí1láí1lóí1mhí1ocí1thí1trí3tií3úlí5baí5loí5ráí6nní6úiíb1líb1ríb3oíc1eíc1iíd1eíd1iíg3eígh4íl3aíl3éíof1íp3eíp3ríp3éíp5iís1eís1íís3iít4eít5éó1bhó3áló3úló5yóób3aób5róc1aóc1úóc3ióc3róc5óóf3róf5áóg3aóir3óng2órg4ós3óós5uós5úóst1ót1áót3óú1ghú1mhú5anú5úiú5úlú6dóú6fóúb4húc1aúc1lúc1rúc1óúd5rúd5úúg1rúl5úúlc4últ4ún1óún3oún3áún5aúr4úúr5óúrt4ús2áús3óús3úúsc1út1rút3aúth1");
            put(5, "1chro1scrí1scóp1tós42c1ín2che_2d1óg2g1n22m1n22n2ót2oc1a2oc1r2sc1í2t1n22t1ál2íor12ó1nn3beab3béit3búid3c4ho3chót3cint3cion3cirt3d2ro3d4at3d4lú3d4ru3d4uc3d4ul3d4óc3d6hé3dict3dróc3dróm3dáid3dónn3f4ób3g2ao3g4ár3gine3giní3glif3grád3leáf3m4íl3miúd3món_3nóia3s4ón3scia3t4at3t4ás3t4íp3teab3thon3thur3tiún3tróp3tóip3tús33v4at3v4ei3vol43éa3p4ad3l4aisp4aivi4amál4as3e4ascr4aíní4bacá4bhe_4bhíg4bhío4bhít4c1óf4dann4deor4drog4easm4easú4eáib4fean4iail4ilia4isic4iúid4lacá4maim4mh5r4néas4oc1ó4oc3u4ochb4pall4peir4raob4raol4riat4roid4róit4steo4téig4uire4ur1a4árn24éann4ís3é4ú1nn5b4ei5c6ác5caod5ceá_5chár5chó_5chóc5céas5d6lá5doir5dóiv5eáis5lóp_5n6ób5p6ór5péin5seai5siút5tanb5tata5tíop5tíor6al5e6alám6andu6anná6b1ir6bis36cead6d5ós6deam6eagm6eamá6eanú6eash6eimh6feol6gaig6gáis6iomá6isis6nnac6oc3n6ochn6oinn6oir_6p6us6pias6píol6rasn6seag6seo_6siúd6sti_6thab6theá6toid6uaid6uig36uirs6ócar6óras6úile6úili_ab5r_ae5n_ag4ó_ag5r_ais3_am6á_an2a_an2á_an6i_an6ó_anc6_ard5_art4_aró5_as2t_as4ú_as6ó_at6á_ata6_ba6d_blí3_cha4_chí6_cil6_cli6_cnó5_dó5f_ead1_fí5g_fí5m_góf5_haí4_hir4_his4_hod6_hom2_híl3_húd4_iat6_ib6é_ibh5_ios3_ist6_lim5_lip5_lí5d_lí5g_lí6t_ma6r_ma6t_mam5_mhú6_nar5_naí3_neá6_nit6_nom6_ní5d_ní5m_oc4r_ogh6_om6a_ort4_rai6_ró5c_rúm5_sa6l_sca6_sim3_sí4o_só5f_tap5_ua4f_ua6i_ur5b_ál6t_ár2a_ár6m_éa6b_éar5_íos5_ór4áa2dófa3dhia3f6la3lára4stóa5bó_a5bóna5cróa5dhúa5ghia5rúta5tára6imha6masa6troa6tógabac6abh2tac1raac3réac5uaacae6ach1aach1rach1áach1úach3íacár5ad1alad1amad5ásadag6adhb1aeil3af6ráag2alag3riag3rúag3uaaic5raid1iailt2ain5íal1cóal3aíal3góal3uial6túala3balas3alt3eam1alam1anam3úiam4pram5utam5úrama3bamp1aamp1áan3dran3oian4maan5aían5oían5áran6agan6eaan6tuanac4anat6anc1aand3oandí6ang3aang3áanin5anód4ao4l1ao6r1aoch3aon3uaorg4aort4aos3tar1crar3úpar5ónar5ópar5úlarc1óarch6arm4óas1taas3coas3tias3túas5aías5toas5téasú5masúd6at1ráat3asat4uiat5ódata3matac6ats5aatá5tatá6iaí5óib3aigb3aimb3óidb4arrb4áltb6eárbamb6bar3bbar3úbat5abea6cbeif6beo3cbeo5mbh3imbh3ínbh4uabh5tíbhc6ábhlá6bhár6bhúm5bi3nébia3lbid5ibin5ibins3bint3bios5bist4bit5sblas3blim6bláf3bod3óbol4sbord3burd3burl1bust5bá5í6bó6s5bóth5búir5búis5c1idíc1igíc2áidc3bh6c3ighc3iú_c3iúlc3ra_c3s4mc3st4c4arlc4arsc4ratc4sicc4sigc4óipc5reác5rilc6arac6se_c6te_c6ánnc6éitca3dácal4mcar3úcard3cast6cat3ócat5ace3r4cea6bceo3mch1adch1m2ch1álch1ánch3núch3úscheá6chia6chil6cho4mchri6chua6chul5chus3chíl5chó1mchú6ichúl5ci3mécid5icin4dclim5clé6iclód4cnag5comh3con3ccon5gcorb3corn3cosc3crag5cri5bcri6tcros3cs4imcs5iscsi5dct4eoct4íoct6iúcua6mcuil3culc4cá4f3céal5cí6thcó4macóis3d1uitd3a3gd3arsd3idíd3inéd3land3oifd3reád4arád4áitd4éimd5idhd5áisda3stdab5adai5pdar6ddarg4darn4deat3dh4aodh4cidh4cádh5nudh5núdh6tedhas5dheá6dhip5dhob4dhor2dhur1dhí4odhó3fdhú3sdi5lédic5edist5dlí3bdman4do3brdo3dhdo5ledo5ridor2cdord3doth4dt6i6dtap5dua3mdual5duch6durd2dá3thdárt6déam5dí1ghdí3ledí3rédít6idó5m6dóth3dú3bhdú3scdú5rúe3s4ae3s4pe5n6iea5coea6dhead1áeaft5eag3óeain5earn3eas3aeib3éeid1ieilp5eips6eipt4eir2meirg3eist3eit3éeits3emhá6eo1gheo3lueo3steoi3feorn4eró3beá1imeá3ideá3iteáth2f4illf4óibf4óinf6an_f6éitfab3rfas4tfeo5mfhid5fho5bfhí4ofhí5gfhí5mfi3téfid5ifios3fir6mfisc3flít5fo3lefoil5foin6fol3ufost3fri3dfuad3fáir5fómh1fúst3g1eacg1racg1raíg1ó6fg1óimg3al_g3ra_g3uirg3óidg3óigg4ilig4láng5rasg6andg6eafg6lisgabh5gana3gaof3gard3gc6i6gcil6gcli6gcnó5gea4dgeit5gh2digh2lugh5c6ghd3ághis5gild5gios3gip5sgipt5giúm5giús3gl4i6glae1goin5gra6mgrá3mgrá4ngrú6igual5gáir5góin4h1aimh1laíh1na6h1ra_h1raíh1t2eh2p1eh2táih3ch2h3re_h3tarh4argh4c3íh4eath4ineh4rioh4rísh4rúph4íosh5bhah5bheh5th6h6amsh6arrh6nó_h6p5ih6úishab3rhag5rhai6chal5aham5óhamb6han4áhaof3har3úhat5úhc4ánhd3anhd3iúhea6chea6ghea6rheá1cheá6thfí5ghfí5mhibh5hid4éhil3bhim3éhip4ehir6nhit5shiúm5hiúr5hl6i6hlin4hlip5hm3anhm4adhnag5ho5leho5nuhod3ahod3óhof3ahoi4mhol3uhra6mhré6ihrí2ohrí3rhur5bhá5íohách1hí1ghhíol5hóp6ahós5ahóth1húst5hút5ói3ceii3chri3físi3mhai3seii5pléia3gria5fáia6táiag5óian5aiar3biarc6ib3éaib5iaib5iribh5éic4riic4sticim4id1iaid1inid1iúid1ínid1íoid3ídid3ígid4réidh1lidh1ridh3eidh3iidhc3if3írif6réig1ilig1ipig3iaigi3bil2scil5eáil5íoil6frilí6fim3ioim3éiimar6imb3limig6in5eain5icin5igindí6indó1iní6tior3dip5isir4trir5chir5idir5ipir5scir6tairt3oirír3is1tais5píisc1éist4rit1eait5aiit6réiuch3iú5imiúst4l1b4al1bhrl1bhál1ch2l1gh6l3b6íl3bhél3c4ál3ceil3oidl3úl6l4aihl4amol4asbl4b3ól4e5ll4eavl4ibhl4áibl4úpal5angl5cú5l5peil5pítl5s4el5s6ll5scll6aghl6mial6mí_l6áiml6éivla3l4la5múlae6clain4lais1lamp1lao3flat3álat3ólat5rlba5tlbh1ílbh3flc3eolc3imlc3itlc5idlc5inldúd4leif5lf5rélg6ráli3l6li3télias5liat6lin4slip4slist4lla3gllab6llam6lm4óglon5clp5iúlsc3elsc4ált4arltor6lus5tluí3olách5láin3lárt6ló3l4ló5mhlót3alóth3lú4f3lúca3lúm3alút3óm1ardm1in2m1isim1p2lm2ealm3arsm3artm3c4ím3idím3irím3éarm3ú6cm4alám5al_m5pé_m5éamm5éism6fe_ma3dáma3grmabh6mac5amam5ómant3mast4mba6dmblí3meá5cmh1t4mh4agmhis3mhur5mhuí6mhár5mhí3bmhúd6mi3némid5imilí6mint1mior5mirt3misc3mit6emodh5mor5dmor5nmorf1mors5mpar5mpis6muis5murd6mus3tmách1márt6mé5icmí3ghmí3rémí5grmí6namíbh6míos5mít6imúch3múin5n1gh6n1áidn1áiln3aern3g4én3ordn3tinn4b3en4c3én4c3ún4deán4ginn4óitn5cein5ch2n5cúnn5dean5gúsn5h6an5igín5sínn5tian5tisn5tá_n5uarn6b5in6cign6disn6fa_n6ró_na3crna3dána3grna3tóna5cónag3ónant1nata6nava5naít6nc1lonc3lunc5anncar5nd3ógnd6rónda6gndic5neat5neod5ng3ánng6iang6líng6órni3ténib6énin4snir4inir5bnist6nm5annn3t2no5lanoch6ns3eánsab6nsc6insc6rnsc6ánsú5mnsúd6nt3icnta3pntil4nua5tnuan6ná4f3néal5nío3to3daso3nóto3thoo3thío5dhio5dhío5dhóo5scéo5smáo6d5robht4oca3tocan4och1aoch1loch1roch1áoch1óoch3ioch5íocó5cod3alod3amodh1aodh1rodh3úodh6lof5raog5alogh2eoi6p5oid1ioift4oil5eoisc1oit1éol1úiol3eool3m2ol3úrolbh4olc3óom1anom3aoom3atomp6áon5grong3long3áonsc2ont2óont6eont6íopad6or1bhor3báor3neor4caor5cóor5nios3tios5amosa3tosar5osc1aosc1lost1óost3úotam4ots5óp4acap4acrp4te_p4éidp5c6íp5sisp6irtp6sa_past4peam6pear3phós3pi3dépi3lepid5ipios5pit3splim4poch5poin4pt3ispt4igpuin2punt3pít5ipóst4púin4púit6r1barr1dh4r1gh6r1mh6r1tarr1th2r1túnr2c1ir2d1er2d3rr2miúr2scnr2t1ir3bhrr3manr3mósr3nádr3násr3pánr3túir4c3ér4dí_r4dímr4dítr4g1lr4g3ér4m3ur4migr4mimr4mitr4p3er4p3ir4t5lr5gótr5pa_r5paír5sanr5tá_r5túmr6éasra3bóra3trra3tára5térag5oragh4rain4rb3amrb3asrb3earb4rírb5isrc3rárch4árch6irch6nreo1mri3néri3tari3téri5ríri5trrid3iridh4rinc1rlin6rm3alrm4ilrn3g4rn3iúrn5idrp3arrra3lrran4rrbh4rs3imrsc2árt3úcrua5bruad6ruai6réig3ríbh3rót5arú1ims1ch4s1crés1tags1tals2amhs3có_s3cóls3cóss3cúns3tógs4arls4cors4eats4ilfs4ilts4imés4ints4úits5cats6amss6at_s6atss6cigs6cí_s6cóis6eics6láns6tios6úigsa3bása3dása3fósa5frsa5tásalt3san2ásant4sar3bsar5csat5asc1eosc1imsc1rósc3itsc3úcsc6aosca6bseod3shar5ship5shor4shí4oshí6tshó5fshú5cshús5si5besib5ésidh6sin6ísis6csist4siúr5slí6tsmeá6snit4snua5so5ghso5nusobh6sof3asor4csorb5spi6dspor5spór6st1aíst1imst3asstai6sua6iséar3sí3bhsíol5só5mhsóin4súch6t1eáit1eált1ib2t1id4t1iú_t1áilt2eart3annt3eadt3ilít3init3inít3iúlt3rart3seot3áivt4allt4rátt4éitt5iltt5úidt6rúst6sait6áitta1góta3crta5notae5ntagh4tat5úteám5th5nóth6ísthós4ti1biti3diti3déti3f4ti5tétia5gtib5étir4itod5ótoin6tom6ator2ctor3ptrac6tros6trá5btrí1rtsa6ltuar5tuis3tur3btuío3tá6d5téal2tí4f3tóch5tú3m6u6t5áua1f2ua3luuad3áuais1uart4uch1auch3ruch3áuch3óui6p5uifé5uil3puim3puin5cuir3tuirn6uis5tuit3suit3éul3g4ul3m4ul4trul5p6un5gáunc1aunúd4ur3m4ur3t4ur6agurch4us3crus3tóus5tuusc3luí1oduí5tíuíth6uó3t6vach6vais5vard6vean6vear3vios5virg6volt3vuít5véar6véis5á1imiá3igíá3im_á3mará3nnaá3rolá4fa_á5r6éá5íreá6imháb4alábht6ácar5ách3lách5eách5iách5rách5áádh3aádh5úáib5éáil5báim5éáins4áirt3áisc1áit3sáit3éál4s3ám3anám3atán6gaár4taár5amár6caárt6rás3túé5ifíé5n6áé6amhé6im_éa1gréa1guéa2d1éalt3éast4éat3aéi6seéil5géint3éip4séisc1éit1séit3éí1bhaí1lití1n2aí1r2aí1s2pí1scaí1scrí3beaí3ceií3n4oí3n4áí3n4óí3reií3scéí4m3éí5bhrí5chaí5céií5gréí5r6uí5r6úí5stuí5ógaí6fe_í6le_íb3eoíbh1iíc3éaích6níd1íoíd3ídíd3ígíd3íníg5riíl1eaíl3igíl3imíl3isíl5iníl5iúími3tín3t4ín5aiío6cóíomh3íorg4íorn6íort6íot6rís3taísc5eíst5eó1faió3cheó3dheó3dhíó3fadó3l4eó3l4ió3l4íó3maró3n4oó5dhóó5gó_ó5l6éó5p6éó5íníó6ighóc5s6óch1aóch3úóch5róch5áói3péóib5éóid3ióin3tóisc3óist1óit3éóits3óm3atómh3áón2asóp6alór4maór4táórt2aórós5ós5amós6trósar5ósc3aót1aíótar3óth3áú3cheú3chíú3igíú3imiú3l4iú3r6uú3s4mú3stoú3thoú4mhnú5chrú5l6eú5p6rú5rúiú6p5aú6t1áúbh5aúc4ráúca3búch1aúch5lúint4úirt3úisc3úlú5lún3t2úng5uúng5áúra3búran6ús5ánúst3óút5óg");
            put(6, "1g4raf2bh1eá2níomh3bh4id3c4ít_3c4ó1m3ceana3ceasm3ch4lo3ch4re3chrap3chrio3chóip3d4acs3d4eir3dh4ro3g4id_3ghrú63ginnt3graif3m4ít_3mharg3mhuir3p4at33s4an_3s4féa3s4íle3scior3scóip3stéig3t2íl13t4aga3v4ini4a3d4o4ach1l4adamh4adhro4aidhl4aitei4bh3ím4bhuit4d3ead4deann4deoir4liona4méar_4n3imi4righn4ta3to4tilít4traip4óireo5c6eai5c6ót35ceanó5champ5chóda5d6óic5f6ram5g6irt5g6lic5g6éas5galm65l6óip5m6ac_5m6óró5míre_5n6eot5n6óma5s6ao_5s6ing5salám5seáib5stáit5stát35t4eoc5t6ige5t6íol5teanú5tharr5thuig5thógt5uanla5v6ial6a3che6achri6achár6aigis6aisei6bh3iú6bhre_6deag36draim6g5ánt6gear_6ghrú_6innis6iseas6itean6loine6n5im_6n5ásc6parag6peann6raicn6t5iam6t5íti6talún6áinia6óf5ag6órais_ab4ai_ab6ar_ac6ad_ad6am_ag6ar_ag6úi_agh4a_ai6c5_aist4_al5g6_alm4ó_am6ac_an2ta_an6dr_an6fa_an6sa_ana5c_ang4l_aral4_aróc6_as6am_as6tú_ast3ó_bad3á_bal6b_beo5f_beo5g_bhlí3_brí3o_cach5_cad5á_caí5d_caí5m_caí5o_chnó5_clip5_cló5f_cnaí3_dlí5d_dlí5g_dlí5m_dlí5o_dó5im_ea6g3_earb5_fach3_feo5f_fí5dí_geat5_hag4ó_han2a_han6ó_hanc6_har2a_har6á_hart6_hat6á_head3_hib6é_hios5_hist3_hit6r_hoc4r_hogh6_hor5m_hort4_hua4f_hál6t_hár4a_hár6m_ia5it_in4ío_in6id_in6ín_in6ír_int6e_iosc6_iost4_lad5a_lag5á_lait5_lan5c_lao5n_lea6m_leas5_leo3c_lib5é_lint6_lí5mi_lí5od_lít5i_mad5a_man2t_mar5ú_mat3á_maí5d_mí5st_mí6oc_nair5_nais5_ndó5f_neád5_ngóf5_ní5gí_ní5od_ní5om_ní5on_ní6oc_oilt6_oir5t_ol6ac_or6ai_ost5a_pist6_rad5a_rad5ó_rat5á_reas5_reo5f_rí5dí_rí5gí_rí5mi_rí5od_rób5a_róch6_róst5_sal5a_scar5_siún4_sní5d_sní5g_sní5m_só5im_tan5g_tróf5_tsí6o_uaf5a_uil2e_uir6t_un6s5_ur3n4_áir6s_éart6_éim5í_íoch5_úr6áia1f2óna3b4ala3bh6ea3cáida3d4úra3fóiba3fóina3grama3láiba3mhasa3s4aea3s4óla4cha_a4d3óda6chlia6g5reab3óigab4artaba5caaba5dáabh6reabh6órac4adúac4aoiac4rasac6ardaca1s4ach3ógach5órachar5acra3fad3araad3arlad3rogad5artad5áilaeilg4af5airaf5artafa3dáafhol6afáil3ag5ruiag5áisagad3áagh5anai3filai3ginai5ciúaich6taidít5ailp3iain5téair4déairb4íairf3íaits3eal2annal4tófalabh4alait4alan4aalan5dalasc6am3araam4ánaam5allam5ónaama5sóamh5adan2d3áan3aitan4sanan5cé5an5gó_an5áisan6sinana3caandíb5anuas6anó3dóao3imiao5darao5im_ao5maraocht6aoin6sapa5dáar2f1óar3bhear3úilar4p3óar5as_ar6ac_ar6staara3búara3p4ara3tóara5cóara5sóarbh3aas5tuaas5tóras6arbas6tasas6óilasain4asal2tascar5ast3alasú3itat3óidat3óigat3óimat4agrat5arnat5rapat6sarata3p4ata5cáatam4áath6usatáth6atéad6b3aidíb5adarb6aitíba3dáiba5casbac6s5baist3bait3éban3d4bar1n2beil6tbeir5fbeoch4bh3aigbh5eambh6ricbh6réabhal6bbhar3bbhat5abheif6bheo3cbheo5gbhios5bhláf5bhual5bhust5bhéal5bhí5otbhí6thbhúir5bhúis5biosc6bla3grblad5ablead5bol4tábos5t6bpist6brad5ábrat5óbua3imbua5dabuair3buin6tbá5innbá5itíbárth5bí6th5bí6tigc2aisnc3eadác3iam_c3úla_c4illic4s3ítc6artac6s5ilc6teáica3máncab5alcae4d3caib5écain6dcair6bcait3écal5ancan3t2can5c6can5s6carbh4carn5ácas5tócea3súcear3bceas6tceil4tceit6sceá3n4ceá6f5ch1as1ch3arfch3áirch3ódhch3óg_ch3óigch4lárch4rí6ch5al_ch5obach6ritchal4mchar3bcharn5chast4chat5achat5ócheáf5chin5tchlé6ichlód6chomh3chon3cchon5gchorb5chorn5chros3chulc6ci3p4lci6p5écia6f5clad3óclad5ácloch5cló3dócneá5ccoirn4cona3mcona6ccor3t4cor6p1coran4crais4crea6bcrit5écriú5icroch3crost4créal3cuil6tcuilc6cur6l5céa3tácéalt6cóist4d4l3add5eagód6eanddair4ndalbh5dar5t4dbhin4deal5adeáth3dh2s3ádh4n3edh6c5adhasc6dhia5fdhint5dho5dhdho5rédhorn5dhua5mdhual5dhurd4dhí3rédhó3imdhó5indhú5lédhú5rúdia3mhdia5f6din6t5do3ghldo3mhido5chedo5lagdo5mhodo5mhúdo5r6édo5s6mdor6n3dorch3dosc4adró3l4dtan5gdtróf5duamh4duar5tducht5dun6s5dára5sdí4leadí6thedó5im_dú3l4ée3m4ace5m6aíe5ólace5ólaíea3matea3rúiea4g3aea4tá_ea5carea5có_each3óeal6p5ealt3áeamar4ean3d4ear1m2ear3f4earb3áei6bh5eic4sieilít6eimin3eini3ceir4bíeir6p5eir6steirm5éeitim6eo3dareo3fadeo3faieo3im_eo3itíeo3nnaeo5mareod5óreol3c4eol5g6eomh2aera3s4era5d6ethan5eá3inneáit4eeáit6if4e3l4f6ain_f6eadhfacht2faist3fal3c4faois3far3n4far6amfar6atfead5afhach3fhas6tfheo5ffhios5fho3dhfhoil5fhoin6fháil2fháir5fhí5dífhí5omfhómh3fiach5fiosc4fo3scrfo6d5afoirn4for3b6for3n6forch4frai3dféach5féalt6fíod3ófóint6fúith6g3inn_g3raigg3raitg3óinng3óra_g6a5p6ga3daoga3stága5b6agabht6gai3spgai3tégar1n2gar6túgcach5gcad5ágcaí5dgcaí5mgcaí5ogcin5tgclip5gcló5fgcnaí3gea3stgead3ógeal5ageal5bgeat5agh4de_gh4s3ágh6am_ghabh3ghd3acgheit5ghoin5ghrá3mghual5gháir5ghó6f5giost4gnó3l4grámh4gust5agéa5b6góint3h1t2úrh3eacnh3t4aeh4eangh4láirh4éadrh5dineh6eánaha3dáihac6s5hach5óhae5nnhagá5lhaic5íhain2thait3éhal5g6ham5athan3d4haral4hard3áhat5rahaí6tihbhuí6hd3aimhd5eamhd5innhd6eogheag5rheana6heat5áheat5óheift5heo3mhheod5óheáth5hfach3hfeo5fhfí5díhfí5omhghin5hin6ínhin6írhint4ehip6idhirim5hiús5thlac5áhlad3áhlad5ahlad5óhlas5thlim6phlé5amhm4ainhmad5óhn6eánhniú3chnua5chnó5l6ho3bróho5mhúhoilt6horan6hord3áhos6táhrad5áhrat5óhroch3hruac6hscar5hta5p6hur3n4háin4théim5íhí3leáhí5stihíod5óhíoll6híos5thó5im_hó6ma_hó6maíhóin4shóint6hóist6húd5aíhúin5ti3c4ídi3péidi3sinti5ch6ai6tínnia1t6ria3chlia3f4aia3igíia3imiia3iteia3lania3latia5daria5im_ia5innia5mariach3óiam4b3ian3g4iar3d2iar3t4iar5m6iarbh6iast5rib3éilib4eabib5éidibhin4ibhit4ibia5nic6iú_iceap4icé5anid3icíidh3bhidi3f4idí5ocif5in_ifin6tifini5igea5tileac2ili5béilia5nilé5anim3ideim3ireim3irnim3irtim5iscim5íríimi5géin2tí_in4scnin5íocin6girind3eáind3ibindíl5ineam6ioc5s6iol5g6iom3arion3c6iopa5diot6asipea3gipist6iream6irt6s5isear3iséal5it3eánitil4tiucht4iú5inniúir6siúiré5iúité5iúr4s3iús5tál1g2aml4agaml4aitél4ar3nl5bhanl5scidl6óiníla1g2ála3f4ála3f6óla3rúila5baslach5ólaghd6lai3l4lainc4laisc3laist6lan2d3las5tólasar3lbh3eolbh5adlbhin4lc3eanlca3l4ld5eanlea5gúlearb3leat5óleisc3leo6d5leomh3leách3lf5eanlga3dáli3bheli3mhili3tiúli5bí_li5m6éli5n6éliast6lic6s5lim5irlimp3ílint3eliost3liú3stliú5malla5balla5mállai3sllait4lm6óigloit5elorai5lsc5inlt3eoflt6airlt6racltra3llua3imlá5innláint4lé1if4lé3adhlé3itíléint6léit6slí3bhélí3sé5líth6ilúit5ém2aitim2eascm3a3f4m3a3rúm3a3tóm3ar6bm4óin_m5adarm5adh4m5péarm5péirm6óiníma3tagma5dasma5g6lmadhm5mai3témal5g6mam5ú5mar3m6mar6f5marbh3mat5ógmaí6timbad3ámbal6bmbeo5fmbeo5gmbrí3ombí5tímeal6tmeas5tmeo3nómh3asfmh4ad_mh4illmh4éalmh4úinmh6am_mh6at_mh6atsmhadh4mhais3mhar6bmhat3ámhat5ómhist6mhor5nmhor6cmhuis5mhus3tmhárt6mhí3rémhí6lemhíbh6mhó5mhmi3l4émi3t4imilít5min5semin5símir4c3mleat6mol5t6mon5c6mon6t5mong5ómorch5mp3allmp5éidmpi5semroch5muilc5muisc6mé5ighméin6tmí3lítmóint6múcht6n2s3áln2t1eán3abaín3c4ásn3ceasn3g4iln4aisen4c4s3n4diain4t3íln5cisín5céadn5céidn5d6ánn5g6únn5seacn5tearn5teá_n5áiscn6trasn6uas_na3bh4na3chlna3mhéna3stána5chrna5matna5tamnae5m6nail6tnalbh4namh5anao5nnnarb5anarbh6nbhan6nc5aigncarn6nchró5nd5is_nd5isendlí3ondlí5dndlí5gndlí5mnfair6ng4alóng6ealng6íneng6íocnga3dángeat5ni6m5énia5itnin6d5ninít5nlia5nnlé5amnlé5annna3b4nocht5noich4nroch5ns3annns4eánnsa5banseir5nsin6tnsá3itnt3eagnt4eadnt4eolnt4ín_nt4ínínt4íocnt5artnt5oidnt6eognt6íninta5móntai3bntra5bnua5danua5imnéalt4ní4th5ní6t5rnílim5nó1th2o1mh2eo3bh4eo3igí_o3mh6ío3s4páo3scrio3th4eo5bhréo5l6abo5lagho5láimo5mhilo5r6iao5scaoo6f3acoba3dáobhar3och3eooch3uaod3artodh5eooim3iroimp3éoint3éoir3d4oirn3íois1t4ol4g3aola1g6ola3dáola3f4olan5dom3aráoma5táomant4on5gabon5gúiona3b4ona3l4onam4aondu5song3óiong5ónontar3opa3laopa5dáor3mónor3oidor5póior5tasor6maíora3tóorb5adorch3óos4t3éosarn6osc3óiosc3úiosc5raosc5órost3aiost5adot4asaoth6asoth6rioth6usothar3oí4te_oíche5p4i3tép5s6imp6asamp6iteipa3p4ópaisi3par2s3par3d4par3n4par6tapea5stpeal5apearn6peil3bpein6tpeir5tphast6phat3rphoin2phonc5phuin4phóst6phúit6pic6s5piost6pirim5pis3tipist3eplé5amplé5anpló3m6pocht6point5poist5pol2agpol5c6pon4c3praoi5pré5ampré5idpróis5ps5eanpsain6pt3eanpéin6tpéir6spúins5r1m2adr2bh1lr2d1i6r3bairr3caisr3d4rér3g4asr3geadr3gintr3n4apr3t4alr3t4ilr3tanar4b3iar4d3íor4g3rur5baitr5bhiar5cisir5d4únr5d6aor5d6arr5góitr5n6ónr5pógar5s6ánr5úiner6alanr6cra_r6d5ídr6d5ígr6n5iar6t5úlr6áinir6éithra3g4ára3l4úra3matra3p4órad5ónraghs5raimh4raimp3rainc3rait3érait5srant4óras1t4rat3ógrata6mrb3ac4rb3adhrb3annrba3cárbh3asrbh3inrbh3ánrbh3ígrbh3íorbh3ítrbh5ídrbh6atrc4intrca3s4rch3acrch3rard5oidrd6airrdin5érea3táreag3rreas2treo3dóreá3irrf5eolrg3easrg5eamrga5dárghin5ri3ch4ri5ginri5leiriach3ribh6irint3érip4teris1t4rit5éarleat6rlé5anrm6airrn3eálrn4ínern6íniroim3érost3árs6ainrs6áinrt3eacrt3eamrt3eanrt4agárt5aíort5eagrt5úilrt6asórtha3trti3s4rua3darus4t5rusc3ará3íntrách5aré5adhré5iferé5igíréal2tréal5arí5chírí6therí6thiróist5rós6tárú3idírú3innrú3marrúst3as3c4aes3cears3t4irs3t4ícs3t4íss3tices4láins4téins5eagás5i5frs5ímeas6aisís6ileas6áilis6óines6óinísa3g4ása3lansa3r4ósail5bsal5atsat5rasc3raísc3um4sc4éimscach6scoir5seal5aseal6bsealt6sean5mseana6seas5tseic6tseift5seil6fseit5sshant6shib5éshiún4shnua5shní5dshní5gshní5msho5ghsho5thshorb5shua6ishí5bhshí6l5shó5imshó5mhshú5inshúch6si3f4ési5g6ésia5itsiach6simea5slac5áslag3áslag3ósma5lasmead5smear5so3mh4so5láiso5th6sorch5spad5aspad5ásport6sprae5spuir6st3aigst3ithst5amast6isesta5dástrae5stáin6sua3l4sáin6tséalt6sí4th5síoll6só5itísó5tacsú5im_sú5innsú5mart1s4eat3adh_t3eal_t3ealat3ealót3ileot3ineat3ist6t4eamot5aitít5ealtt6ráist6seanta3g4áta3mánta3s4lta3s4tta4chata4l5ata5dáita5p6ltaghd3tai3tétair2btal6c5tam4altan3gótan4t3tar1c2tar3g4tar5d6tart4atas5trtea3grtea5fath5am_th5eánth5in_tha6p5thagh4than3gtharc6thin6ithit3ethor4cthost5thros6thrá5bthu5sathuar5tháin5thé3ifthéal2thí6f5thío5tthóch5ti3tiútin5t4tin6d5tit5eatit5eátorch3tort5atos6t3tra6bótream4trost5truac4tsal5atsi6m5tsiún6tua5datur3n4tá6im_táir5tté6ightéa3latéach6tío5t6ua3chlua3idíua3marua3mhéua5nósua6fa_uabh6ruains6uairn6uaist2uait5sual3g4uala5tuar3g4uga5dáuin3t4uint5íuir5b4uirbh6uirs3tuirt4íuis3crun6sa_ur3d6úur5gónurach3urg5óiusc5aiust5acust5únuí3omauí3onnuí5l6euí5teáuío3dóvac3s4vaisc6veant5vearn6veil5bvéist6á3d4ará3idísá3th4eá6f3acácarn6ách4t3áf5airáf5araága5dááil3c6áilt3iáin3teáist3eáist3iár5aimárach3árt6aiárt6anás1t4aás5c6áé3if2ié3iteáé6ite_éab5róéag3óiéalbh6éam3atéar5g6éars5aébhrí3éi3ghnéi5deiéi5g6ééic4s3éil4t3éim5iréin4tééir2n3éist3eéist3iéit6irí1r2iaí3líthí3teasí4mhidí4tearí5bheoí6f5irí6f5isíbh3eiíbhuí4ícea3síf5eanío3c4áío4mheír2éirísc3iríst5inít5eaníth5isó3d4aró3igí_ó5mhaoó6b5aiócht6aódai5dóf5airóf5aitóga3l4ói4m5éóillí4óin5sióin5síóis6téóla5dáómh3asómh4aíón3as_ór4áidósarn6ót3airót5a3mót5aigóta1c4ú1ch2áú3idísú3l4agú3l4uaú3s4péú4mh3úú4sh3lú4áil_ú6itínúba5dáúbail4úcas4túch5ógúcht4óúil4t3úir2téúl6éimúmh3acúpa5t6úr6anaúra3dáúrabh4ús4airús6t3r");
            put(7, "2d3óirs3bh4ear3bh4irt3bh4las3c4ar1b3c4eána3c4íte_3ch6rao3d4aing3d4airi3d4reor3m4íte_3s4féir3s4óin_4ai3mia4airisc4al4ath4g5amar4l1i1f44p3lag34t3éirs4tanna_4áir4g35chórai5chóras5d6aine5d6óigh5m6an5c5s6iúit5t6aig_5t6aige5thoin66aidear6anaige6d5iam_6da3l4ú6earta_6g5eadh6m5é5ac6t5iteo6tra5cá6ói1mh2_ach6ar_ad6aim_ail6te_ain3g4_air6ní_al2t5a_al6t5á_ala5m6_allag6_an6dór_an6lan_an6rai_anach6_ara5m6_ara5s6_aralt3_as6ail_as6al__as6pa__asc6ar_ast5ai_ast5aí_at5ar__beo5id_beo5im_bheo5f_bhrí3o_bhí5tí_breo5f_cacht6_caí5gí_chach5_chad5á_chan5á_chaí5d_chaí5m_chaí5o_chló5f_chnaí3_chóis5_cló5id_cló5im_dhlí3o_dhlí5d_dhlí5g_dhlí5m_dreo5f_dó5idí_dó5ití_eal4t3_eas3tó_eis4il_eisc3e_feo5im_fí5odh_fí5onn_ghlae3_ghrá6n_hab6ai_hab6ar_hac6ad_hag6ar_hain3g_hain3t_halm4ó_han4ta_han6fa_hana5c_hang4l_har6ó5_haróc6_has4ta_has6ai_has6am_hiosc6_hit6eo_hol6ac_huaf5a_huil4e_háir6s_héid4e_híoch5_im6ire_leab3ó_leoch4_lá5ití_lé5igí_lí5onn_mar5ta_mar6l5_maí5gí_maí5mi_maí5od_maí5on_maí5tí_mead5a_meat5á_mhad5a_mhaí5d_mhí6oc_mhúch5_ndó5im_ndó5in_neach6_och6t5_oir6ní_or6thu_os6ló__raf6t5_reo5id_reo5im_reo5in_réim5i_rí5oma_rí5onn_scad5á_scart6_siúnt3_slios5_sní5od_sní5on_steam5_sá5ití_só5idí_só5inn_tar5ta_thróf5_tua5im_téit5e_áir5ge_áir5gí_éa3g6ó_éad6ar_éi5d6r_íocht6a2d3óida2d3óima3graima3p4aita3t4anta4d3óigab3rad6ab4airtabra3daac4astóaca3t4úach4arfacharn6achart6ada5n6óafholt5afáilt6agh4aidai5s6ílai5t6ilail5bhíailc3eaailp3ínaim3iseains5eoair4b5rair4fínair5nínair5níoairis6tal6t5ódalú3ch4ama3d4úama3raíana5l6óana5m6óana5r6aanaist4anga3rúao5idísaoin3t2aplais6ar4s3álar5ú5s6ara3c6áara3g4aara5l4áaraic6íaróc6aras3tán_as5caraasa5c6aascart6ast4aí_at5a1l2atad5ánathrí5dathrí5mathrí5oaí3o3dóaí3onnaba5s6árbain5t4baisc5ebalbh5ábanais3bea5bh6beal5t6bear3bóbeir5tíbh3uithbha3g4ábha6d3ábhaist3bhalbh5bhar3t4bheil6tbheir5fbheoch4bhin6síbhlead5bhol6tábhrí3ocbhua5dabhua5imbhur2l3bhurd5ábhá5innbhárth5bhé5annbhéalt6bhói5s6bia5ta_bion5góbol6ta_bran3g4bran6d5bá5ite_bá5iteábít5eacbó5l6acc3eab5ac4t3eacc6s5ealc6s5tarc6t5eanc6t5eárcai5m4écain2t3cairbh5cais3t6calbh3acart6accea3stácead5ascean4tácearbh4ceast5aceast5óceir5m4ch4antóch4lasachacht6chaint3chan5c6charbh6chear3bchloch5choirn6chona5mchor5t6chor6p3chrost6chuil5cchuil6tchur6l5cis5teáclas6p5cleat5aclocht6cló5im_cló5itícoil4t3corant3crai3l4craist5crea5sccreab5acreach5crocht4crua5imcrá5inncrá5itícréalt4críoch5crú5itícsea5g6cuacht6cáin6ticár5ta_da3r4aoda5c6acda5c6aídai3ghndairbh5dear5badear5t6dearbh5deilbh5dhar3t4dhearb6dho5chedho5ghldho5s6mdho5thrdho5thudhosc6adhró5l6dhuamh6dhó5idídi3n4éidlío3dódo6th5adoch6tádoilbh3doir4n3dos3caídra5n6ódreo5itdtaist5dtua5imea3g4álea3s2trea5c6lóea5táireabh5t6eagh2d3eais6t3eal6táieal6táneam5aiteama3raearai5ceic6s5íeidh5n6eidh5t6eig4eaceil4t3ieil5teáein2t3eeir6figeirbh6ieirm5iseis5cireis5in4eithin6eiti5míeo3iteáf6raim5facht5afaisti3feis5c6fhacht4fhair5tfhal5c6fhead5afheo5imfheo5infhiosc6fhor5b6fhor5n6fhraim5fháilt3fhéach5fhí5odafhí5odhfhí5onnfiacht6fol6ta_frioch3fua5im_fuir2s3fáil2t3féacht6gar5ma_garbh5ágas3c4rgcacht6gcar6tágcaí5gígcaí5tígcló5idgcló5imgea3namgead5asghabht4gheal5aghin5tíghint6ighrámh4gin5t6ígrá5itíh3t2úirh3t4aicha3dán_ha5s6árhach6arhad6amhhag6úishaint5íhalbh3ahallag6halt5arhan3t4áhan6lanhan6raihan6sa_han6sachar3n4óhar5ma_hara5b6haralt3hart4achas6pa_has6tú_hasam6ahasc6arhat5ar_hbhain6hbheo5fhd3eannhd6eoighdeá5nnheanad5hear5bóhfair5thfeo5imhfeo5inhfhuad5hfhuaf6hfí5odahfí5odhhfí5onnhiat6achin4íonhin5teáhios3t4hiosc6áhipi5c6hir6im_hir6imehis5teáhit6eorhiúnt3óhleat5ahleá5d6hlé5igíhlé5imihléach6hló5im_hló5itíhm4aid_hm5ainnhniúch6hoch6táhol4agáhomai3ghon4c3óhorant5horch3ahost5achost5ánhramad6hrocht6hrua5cáhrú3itíhscart6ht4anachthor6thuil5cehí6th5ehó5l6anhú5ite_húch3t6i5n6éagi5s6ít_ia3idísia4mhaiiai3t4rialach3iceapt5icí5teaifinid6igea3s4igi3l4iil4bh5rilbh5inilea3cailea3cáilea5cóili3c4éimeach6imhead6ind3iaiind5ia_inea3móiniúch3int3eaniogad3áiosc6acirea5b6irea5máirea5móirscar5is3céimisc3eadisc3innisc5ealisc5eamit3eartithin6tithé5anits5eaniú5t6aciúch3t6l3c4aill4ai3nél5bhainl5ma5n6l6bh5idl6c5ántl6sc3aila3c4ánlach6táladh2m5lai3m4élai3tínlai5d6élain5cilao5innlao5irílao5itílao5nnalas6pa_lasarn4lbh3aitlbh5acálbh5eadlbh5eanlbh5ir_lbh5ithlea3tralea5m6áleir5c6li5b6illi5b6íoli5g6éaliant3alion4t5lla3c4állag6acllag6arloraic6lsc6eadluch6t5lá5iteálá5ití_lé3idíslé3itealé5imislí6ocháló5d6órló5dóirlú4mh3álú4mh5alúch3t4lúma5n6m1ar6c5m3i3r4ém3is3t6m3p4arnma3l6anma3r4adma5n6ammaint6imair6nemair6nímaist6emar6sa_maí5te_mbeo5idmbeo5immbeo5inmbreo5fmbí5dísmbí5mismbí5teámear5c6meat5ánmeir6f5mh4aid_mhais6cmhaist4mhar3m6mhar4f3mhar6camharbh5mhluad5mhon5c6mhon6t5mhong5ómhor6s5mhrí5ocmhuisc6mlua5damp3eannmrocht6mí3teacn3g4antn4s3áiln4t3iúrn5c6ar_n5eoirin5t6eánn6bh5aon6traisna3g4amna3l4ógna5maranai3l4inaist3enbhand5ndreo5fndó5itínea3g4ánea5ma_neá5chanfairt5ng4aintng6óid_ng6óidengair5tni5cínenlé3iminlé5igínrocht6nsá5innnsú5itínt5iúirnti3lítntrabh6nua3chónuais6lo3bh6rio3thaiso3tháiro5mharaobhard4och3t4íodhear6oim4p3íoimead5oir4bhíoir4nímoir4níooir4nítoir4p3íoir6niúoir6nídoir6nígoirn6eáol6aiméolai3téoma3l4óon6t5alona3g4óona5maiona6craontarn4or6s5aíora3dáiora3dánorthé3aos5t6únosai5l6oscó3l4ospair3pai5g6epana3m4para5b6pea3s4ópea5maipeacht6peilbh6phar5d6phar6s5pheil3bphis5t6phlé5anphoint3phol5c6phróis5phun4t3pháint5phéin6tphéir6spin6se_pion6t5plé5igíplé5imipol4aimpor3t4rpost5acpré5ad6pré5imipré5itípréach5páin4t5pór4t3ar2bh3eor3meascr3n4acar3t4earr3t4eá_r3tair_r4bh3itr4neálfr5c6isír5d6úinr5m6ainr5m6isir5t6ailr6bh5isr6d5ínnr6n5eamr6p5óg_r6s3eadra3n4amra5n6ómrabh5t6rai3mhírain5tírais3t4ran4t3árb5a5trrb5ais_rbh5uisrch5la_rcha3d6reast5areic5t6rg5ean4rghair5riacht4rias4t5rins3iúrion2t3rios3t4ris3c4érit5éirrlé5amarlé5igírlé5imirom4p3arost3acrost5alrost6órrra3chórshlua5rt6ainírthé5idrthéad6rua3imirus3c4árá3iteáré5ann_réi5mírrí3ochtrí6ch5eró5l6anrómh5airómh5arrú3itearú5ití_rúch6t5s3c4eogs3t6úins4tralas5ticigs5tile_s6a5mats6iligís6p5annsa5c6assair5d6saist3esbheir5sc3iúilsca5cháscor3b4scáin5tsealbh5seanad5seir4f3sfhear5shail5bsheal5ashean5msheas5tsheic4tsheil6fsheit5sshiúnt3shlios5shlíod5shní5odshní5onsho3mh6shua3l6shá5itíshéir6sshó5idíshó5innshó5itíshú5im_shú5marsiacht5sint5iúsios5t6sleá5d6sléach6slíod5ósmeach5smeart6soch6t5soir6bhspeach5st5eannstaist5sá5inn_sá5ite_séir4s5só5l6ansó5t6aísú5d6arsú5ite_sú5ití_t6annact6annaita5m6áitach6tátag5á5ltain4t3tair2n3tair6g3tairbh3tais5títaisc5etar5ta_tea3g4átea3lantea3m4áteas2t5thaghd3thair4bthair4nthair6gthaist5than2t3thar3n4thar5g6thea3lathor5páthrí3octhua5dathua5imtháir5tthéa3lathéach6ti5míneti5mínitib6éartipi5c6toir2n3trai6m5trea3matri3ghntriach6trua3cátrá5inntsal6v5tsiúnt5táir4s3téacht5téar5t6tóir6setóir6síua3igí_ua3imidua3imisua3inn_ua3iteáua3ití_uai5g6éuain5t4uair5tíualath6uamh6aruana5l6uar5taiuar5tanuic6i5suin6tínuins3iúuir3c4íul6t5asun3g4arun5ga3lun6s5aíur6l3álurca3m4urscar6us4t3alust5ailuthan5tá3itearáilt6eááin4teoéal5taréi3g4iléi3g4ríéi5g6iaéif4earéig3in_éilips3éin6teaéir4g3ií3onna_í4l5ithíghnaí6íleá5icíoga3dáír4eascó3itearó3iteá_óin6se_óis5teoóma3s4óómh5artós6aiseú3iteá_ú4l5agáú5itearúis3c4éúithi5súits3eá");
            put(8, "3d4air4b3m4an3d63mh4ac5a3t4ainia4t3i1m4é5ch6aite5ch6raic5d6earb65g6eart_5mhol5t66ch5acha6g5eadar6t5íteas6traláib_ain6te__ais6te__an6lain_as6aim5_asa5m6a_bheo5id_bheo5im_bheo5in_bhreo5f_bhá5ití_bhí5dís_bhí5mis_bhí5oda_bhí5teá_breo5id_breo5im_char6tá_chaí5gí_chaí5tí_chló5id_chló5im_dhreo5f_dhó5ití_dreach5_dreo5id_dreo5im_dó5ite__feo5idí_ghair5t_hail6te_hair6ní_hais5ce_haist6i_hal4t3a_hal6t5á_hala5m6_has6al__heal4t3_heis6il_him6ire_háir5ge_háir5gí_héa3g6ó_héad6ar_héi5dea_híocht6_in6d5ia_in6ste__iomáin5_lach6t5_leat6aí_lé5ann__lí5omar_maí5oma_maí5teá_mhan4t3_mhar6l5_mhaí5gí_mhaí5mi_mhaí5od_mhaí5on_mhaí5tí_naío5l6_ndó5idí_neacht5_oir4n3e_oir6n5i_rua5im__rí6ocha_searbh5_sní5oma_tach6t5_uas6ala_uirthi5_áil6te__éi5geara4d3óinna5n6áisea5t6aintabh6aileacha6d5áaeilí5teagair5n6ain6teanair6bh3rairf5eanais5teogais6ti5saisi3n4éal4ainneal4f3airal6t5óidal6t5óimal6t5óinamhais6tanc4airearach6t5as6alaitas6t5aisasa5maitasta5r6óathrí5gíaío5l6anba5s6áirbascarn5beo5iteabhain3t4bheir5tíbhia5ta_bhia5tacbhin6s3ebhin6t5ebhion5góbhol6ta_bhran6d5bhá5iteábhó5l6acbia5t6acbia5t6aíbol6t5aíbrío3mh4bua5ite_caidh5necair6d5ícair6t5echair6d5chais5t6chearbh6cheas6t5cheir5m6chlas6p5chlocht6chreach5chrua5imchrá5innchrá5itíchríoch5chuacht6cineach5cis3t6incis5tearcreacht6cruacht6cul6t5aidagas5c6deil6te_dh6l5eandhear5badhear5t6dhearbh5dheilbh5dhlío5dódhoir4n5dhos5caídlam5pa_do5chaiddoch6t5adtach6t5dtrá5itídtéit5eadéidlia5ea3s4áirea4d3óineal4t3acealbh5aceam4p3lóean6táileil5tearein3t4eáeir5m6íteis6ean_eis6ilideisc5eaceo5iteareog4achtfaistic4fear5t6afeil6te_feo5iteafheis5c6fheo5idífhol6ta_fhuir4s3fhéacht6friocht4fua5iteafua6fairgair4n3egais5teagais5teágas5c6argcar6t5agcaí5teágcló5inngeal6ta_gharbh5ághrá5itígrama5d6grá5inn_ha5s6áirhad6aimhhaidh5nehain6tínhais5tichan6lainhar6s5achas6p5aíhast5aithaít5eachbheo5idhbheo5imhbheo5inheal6ta_heo5iteahfeo5idíhghair5thiach5t6hin4t5iúhin6d5iahin6ste_hineach5his3t6inhis5tearhléacht5hoch6t5ahost5áinhran5g6óhruacht6hrá3th4óhthorth5huil5c6ihéi5gearhéidlia5hó5l6aini5s6íte_ia3l4ainiacht5aíialacht4imeacht5inea5maíirscart6isc5eannisearbh6l4t3eannl6bh5án_lao5ire_lao5itealao5iteáleach6táleicead5lian4tacling6te_liú5d6arliú5ití_lámhach5lé3ad4arlé5imid_léalaim5mai3n4idmai5l6ítmain6t5ímaini3c4mais5teomaít5eacmbreo5idmbreo5immbreo5inmhain5temhain5timhar3t4amhar6c5rmhea5daimhea5dasmhead5armhear5c6mheas3t6mheir6f5mion4t5ana3ch4annach6ainnai5l6ínnais5teondreach5ndreo5idndreo5imndreo5inndó5ite_nea5s6árngear3t4noscail4nua5iteanór6t5asodhearm5oghair5toir6bhigoir6n5itois4t5ínois5c4eáomhair5ton6t5ailospairt4pair4n3epais3t6ipan6t5alparai3s4phana5m6pheilbh6phin6se_phion6t5phréach5phór6t5apléacht6pré5iteapréacht6r5n6óin_r6bh5easr6d5achtra3l4aíora5l6aícrais4eolrama5dacrama5daírbhá5charchar5t6rdhó5itíreo5ite_rla5m6ánrn5eoirern5eáiltrthé5igírthé5imirthé5itíruch3t4órábh4ailrío5mharrú3d4ar_s3c4airds5c6eoigs5eanna_sa3l4ainsaigh6d5sain6t5esc3ar3n4scréach5sghair5tshair5d6shearbh5sheir6f3shní5omashá5ite_shú5d6arshú5ití_sléacht5smeacht6so5chaidspair4n5sá5iteá_só5l6aint3ear3n4tais5teátaist5iltea5lainthach6t5thairbh5thairn5ethar5t6athead5astheas4t5thlua5dathoir4n3thrá5innthéacht5thóir6sethóir6sítsearbh5tua5iteatá5th6aruair3c4íuar5taí_urscart5á6im5iseéi3g4ealéi5d6reoéir6s5eáí4ch3ealí6th5oiníleá5chaór6t5air");
            put(9, "5d6eannai5d6eannas_ain6t5ín_bhreo5id_bhreo5im_bhreo5in_bhá5ite__bhí5omar_car6t5ar_chaí5teá_chló5inn_chár5ta__dhreach5_dhreo5id_dhreo5im_dhreo5in_dhó5ite__fhrioch5_fhua5im__hain6te__hais5tea_hais5tig_hoir6n5i_háil6te__mair5tí__mar6s5ac_mar6s5ai_mhar6sa__mhaí5oma_mhaí5te__mhaí5teá_phor5t6r_shá5inn__spléach5_thrá5ití_théit5ea_áil6t5eaair4t5éisair6f5in_ais5t6ín_bas5c6ar6bhol6t5aíbhrío5mh4bhua5ite_bia5t6aigbua5itearchreacht6cim6p5ínícineacht6cleach6t5crua5iteacuach5taídheil6te_dho5chaideal6t5aigeil6t5eaceil6t5eanfhear5t6afheil6te_fhriocht6fhua5iteafua6f5araghair4n5eghais5teaghais5teághrá5inn_har6s5aigharai5s6íhia5t6aighia5t6aí_hineacht6hleach6t5hrua5iteahul6t5aisháint5eacioch5t4ógl4bh5áin_ldeighil6lua5itearlámhacht6mais5t6ínmear5t6aimhaini5c4mhion6ta_mlua5iteandreacht6nt5a5l6únnua5ch4anphais5t6iphréacht6rthé5itearua5itearscréacht6seach6t5ashaigh6d5sho5chaidshá5iteá_tais5tearthair6is_thua5iteauaith6i5sáis5t6íní");
            put(10, "6t5a5l6úin_char6t5ar_cheil6te__dhreacht6_fhua6fair_fhua6fara_geal6t5aí_hais5t6eo_háil6t5ea_mhais6te__mhais6tí__mhion6t5a_séa5l6aincáin6t5eachais5t6eorhas5car6n5hrioch5t6áioch5t6óigmhion6t5aísheach6t5ashéa5l6ain");
        }
    }), hy("hy", 1, 2, new HashMap<Integer, String>() {
        {
            put(3, "և1աև1եև1էև1ըև1իև1ոև1օ");
            put(4, "ա1բաա1բեա1բէա1բըա1բիա1բոա1բօա1գաա1գեա1գէա1գըա1գիա1գոա1գօա1դաա1դեա1դէա1դըա1դիա1դոա1դօա1զաա1զեա1զէա1զըա1զիա1զոա1զօա1թաա1թեա1թէա1թըա1թիա1թոա1թօա1ժաա1ժեա1ժէա1ժըա1ժիա1ժոա1ժօա1լաա1լեա1լէա1լըա1լիա1լոա1լօա1խաա1խեա1խէա1խըա1խիա1խոա1խօա1ծաա1ծեա1ծէա1ծըա1ծիա1ծոա1ծօա1կաա1կեա1կէա1կըա1կիա1կոա1կօա1հաա1հեա1հէա1հըա1հիա1հոա1հօա1ձաա1ձեա1ձէա1ձըա1ձիա1ձոա1ձօա1ղաա1ղեա1ղէա1ղըա1ղիա1ղոա1ղօա1ճաա1ճեա1ճէա1ճըա1ճիա1ճոա1ճօա1մաա1մեա1մէա1մըա1միա1մոա1մօա1յաա1յեա1յէա1յըա1յիա1յոա1յօա1նաա1նեա1նէա1նըա1նիա1նոա1նօա1շաա1շեա1շէա1շըա1շիա1շոա1շօա1չաա1չեա1չէա1չըա1չիա1չոա1չօա1պաա1պեա1պէա1պըա1պիա1պոա1պօա1ջաա1ջեա1ջէա1ջըա1ջիա1ջոա1ջօա1ռաա1ռեա1ռէա1ռըա1ռիա1ռոա1ռօա1սաա1սեա1սէա1սըա1սիա1սոա1սօա1վաա1վեա1վէա1վըա1վիա1վոա1վօա1տաա1տեա1տէա1տըա1տիա1տոա1տօա1րաա1րեա1րէա1րըա1րիա1րոա1րօա1ցաա1ցեա1ցէա1ցըա1ցիա1ցոա1ցօա1փաա1փեա1փէա1փըա1փիա1փոա1փօա1քաա1քեա1քէա1քըա1քիա1քոա1քօե1բաե1բեե1բէե1բըե1բիե1բոե1բօե1գաե1գեե1գէե1գըե1գիե1գոե1գօե1դաե1դեե1դէե1դըե1դիե1դոե1դօե1զաե1զեե1զէե1զըե1զիե1զոե1զօե1թաե1թեե1թէե1թըե1թիե1թոե1թօե1ժաե1ժեե1ժէե1ժըե1ժիե1ժոե1ժօե1լաե1լեե1լէե1լըե1լիե1լոե1լօե1խաե1խեե1խէե1խըե1խիե1խոե1խօե1ծաե1ծեե1ծէե1ծըե1ծիե1ծոե1ծօե1կաե1կեե1կէե1կըե1կիե1կոե1կօե1հաե1հեե1հէե1հըե1հիե1հոե1հօե1ձաե1ձեե1ձէե1ձըե1ձիե1ձոե1ձօե1ղաե1ղեե1ղէե1ղըե1ղիե1ղոե1ղօե1ճաե1ճեե1ճէե1ճըե1ճիե1ճոե1ճօե1մաե1մեե1մէե1մըե1միե1մոե1մօե1յաե1յեե1յէե1յըե1յիե1յոե1յօե1նաե1նեե1նէե1նըե1նիե1նոե1նօե1շաե1շեե1շէե1շըե1շիե1շոե1շօե1չաե1չեե1չէե1չըե1չիե1չոե1չօե1պաե1պեե1պէե1պըե1պիե1պոե1պօե1ջաե1ջեե1ջէե1ջըե1ջիե1ջոե1ջօե1ռաե1ռեե1ռէե1ռըե1ռիե1ռոե1ռօե1սաե1սեե1սէե1սըե1սիե1սոե1սօե1վաե1վեե1վէե1վըե1վիե1վոե1վօե1տաե1տեե1տէե1տըե1տիե1տոե1տօե1րաե1րեե1րէե1րըե1րիե1րոե1րօե1ցաե1ցեե1ցէե1ցըե1ցիե1ցոե1ցօե1փաե1փեե1փէե1փըե1փիե1փոե1փօե1քաե1քեե1քէե1քըե1քիե1քոե1քօէ1բաէ1բեէ1բէէ1բըէ1բիէ1բոէ1բօէ1գաէ1գեէ1գէէ1գըէ1գիէ1գոէ1գօէ1դաէ1դեէ1դէէ1դըէ1դիէ1դոէ1դօէ1զաէ1զեէ1զէէ1զըէ1զիէ1զոէ1զօէ1թաէ1թեէ1թէէ1թըէ1թիէ1թոէ1թօէ1ժաէ1ժեէ1ժէէ1ժըէ1ժիէ1ժոէ1ժօէ1լաէ1լեէ1լէէ1լըէ1լիէ1լոէ1լօէ1խաէ1խեէ1խէէ1խըէ1խիէ1խոէ1խօէ1ծաէ1ծեէ1ծէէ1ծըէ1ծիէ1ծոէ1ծօէ1կաէ1կեէ1կէէ1կըէ1կիէ1կոէ1կօէ1հաէ1հեէ1հէէ1հըէ1հիէ1հոէ1հօէ1ձաէ1ձեէ1ձէէ1ձըէ1ձիէ1ձոէ1ձօէ1ղաէ1ղեէ1ղէէ1ղըէ1ղիէ1ղոէ1ղօէ1ճաէ1ճեէ1ճէէ1ճըէ1ճիէ1ճոէ1ճօէ1մաէ1մեէ1մէէ1մըէ1միէ1մոէ1մօէ1յաէ1յեէ1յէէ1յըէ1յիէ1յոէ1յօէ1նաէ1նեէ1նէէ1նըէ1նիէ1նոէ1նօէ1շաէ1շեէ1շէէ1շըէ1շիէ1շոէ1շօէ1չաէ1չեէ1չէէ1չըէ1չիէ1չոէ1չօէ1պաէ1պեէ1պէէ1պըէ1պիէ1պոէ1պօէ1ջաէ1ջեէ1ջէէ1ջըէ1ջիէ1ջոէ1ջօէ1ռաէ1ռեէ1ռէէ1ռըէ1ռիէ1ռոէ1ռօէ1սաէ1սեէ1սէէ1սըէ1սիէ1սոէ1սօէ1վաէ1վեէ1վէէ1վըէ1վիէ1վոէ1վօէ1տաէ1տեէ1տէէ1տըէ1տիէ1տոէ1տօէ1րաէ1րեէ1րէէ1րըէ1րիէ1րոէ1րօէ1ցաէ1ցեէ1ցէէ1ցըէ1ցիէ1ցոէ1ցօէ1փաէ1փեէ1փէէ1փըէ1փիէ1փոէ1փօէ1քաէ1քեէ1քէէ1քըէ1քիէ1քոէ1քօը1բաը1բեը1բէը1բըը1բիը1բոը1բօը1գաը1գեը1գէը1գըը1գիը1գոը1գօը1դաը1դեը1դէը1դըը1դիը1դոը1դօը1զաը1զեը1զէը1զըը1զիը1զոը1զօը1թաը1թեը1թէը1թըը1թիը1թոը1թօը1ժաը1ժեը1ժէը1ժըը1ժիը1ժոը1ժօը1լաը1լեը1լէը1լըը1լիը1լոը1լօը1խաը1խեը1խէը1խըը1խիը1խոը1խօը1ծաը1ծեը1ծէը1ծըը1ծիը1ծոը1ծօը1կաը1կեը1կէը1կըը1կիը1կոը1կօը1հաը1հեը1հէը1հըը1հիը1հոը1հօը1ձաը1ձեը1ձէը1ձըը1ձիը1ձոը1ձօը1ղաը1ղեը1ղէը1ղըը1ղիը1ղոը1ղօը1ճաը1ճեը1ճէը1ճըը1ճիը1ճոը1ճօը1մաը1մեը1մէը1մըը1միը1մոը1մօը1յաը1յեը1յէը1յըը1յիը1յոը1յօը1նաը1նեը1նէը1նըը1նիը1նոը1նօը1շաը1շեը1շէը1շըը1շիը1շոը1շօը1չաը1չեը1չէը1չըը1չիը1չոը1չօը1պաը1պեը1պէը1պըը1պիը1պոը1պօը1ջաը1ջեը1ջէը1ջըը1ջիը1ջոը1ջօը1ռաը1ռեը1ռէը1ռըը1ռիը1ռոը1ռօը1սաը1սեը1սէը1սըը1սիը1սոը1սօը1վաը1վեը1վէը1վըը1վիը1վոը1վօը1տաը1տեը1տէը1տըը1տիը1տոը1տօը1րաը1րեը1րէը1րըը1րիը1րոը1րօը1ցաը1ցեը1ցէը1ցըը1ցիը1ցոը1ցօը1փաը1փեը1փէը1փըը1փիը1փոը1փօը1քաը1քեը1քէը1քըը1քիը1քոը1քօի1բաի1բեի1բէի1բըի1բիի1բոի1բօի1գաի1գեի1գէի1գըի1գիի1գոի1գօի1դաի1դեի1դէի1դըի1դիի1դոի1դօի1զաի1զեի1զէի1զըի1զիի1զոի1զօի1թաի1թեի1թէի1թըի1թիի1թոի1թօի1ժաի1ժեի1ժէի1ժըի1ժիի1ժոի1ժօի1լաի1լեի1լէի1լըի1լիի1լոի1լօի1խաի1խեի1խէի1խըի1խիի1խոի1խօի1ծաի1ծեի1ծէի1ծըի1ծիի1ծոի1ծօի1կաի1կեի1կէի1կըի1կիի1կոի1կօի1հաի1հեի1հէի1հըի1հիի1հոի1հօի1ձաի1ձեի1ձէի1ձըի1ձիի1ձոի1ձօի1ղաի1ղեի1ղէի1ղըի1ղիի1ղոի1ղօի1ճաի1ճեի1ճէի1ճըի1ճիի1ճոի1ճօի1մաի1մեի1մէի1մըի1միի1մոի1մօի1յաի1յեի1յէի1յըի1յիի1յոի1յօի1նաի1նեի1նէի1նըի1նիի1նոի1նօի1շաի1շեի1շէի1շըի1շիի1շոի1շօի1չաի1չեի1չէի1չըի1չիի1չոի1չօի1պաի1պեի1պէի1պըի1պիի1պոի1պօի1ջաի1ջեի1ջէի1ջըի1ջիի1ջոի1ջօի1ռաի1ռեի1ռէի1ռըի1ռիի1ռոի1ռօի1սաի1սեի1սէի1սըի1սիի1սոի1սօի1վաի1վեի1վէի1վըի1վիի1վոի1վօի1տաի1տեի1տէի1տըի1տիի1տոի1տօի1րաի1րեի1րէի1րըի1րիի1րոի1րօի1ցաի1ցեի1ցէի1ցըի1ցիի1ցոի1ցօի1փաի1փեի1փէի1փըի1փիի1փոի1փօի1քաի1քեի1քէի1քըի1քիի1քոի1քօո1բաո1բեո1բէո1բըո1բիո1բոո1բօո1գաո1գեո1գէո1գըո1գիո1գոո1գօո1դաո1դեո1դէո1դըո1դիո1դոո1դօո1զաո1զեո1զէո1զըո1զիո1զոո1զօո1թաո1թեո1թէո1թըո1թիո1թոո1թօո1ժաո1ժեո1ժէո1ժըո1ժիո1ժոո1ժօո1լաո1լեո1լէո1լըո1լիո1լոո1լօո1խաո1խեո1խէո1խըո1խիո1խոո1խօո1ծաո1ծեո1ծէո1ծըո1ծիո1ծոո1ծօո1կաո1կեո1կէո1կըո1կիո1կոո1կօո1հաո1հեո1հէո1հըո1հիո1հոո1հօո1ձաո1ձեո1ձէո1ձըո1ձիո1ձոո1ձօո1ղաո1ղեո1ղէո1ղըո1ղիո1ղոո1ղօո1ճաո1ճեո1ճէո1ճըո1ճիո1ճոո1ճօո1մաո1մեո1մէո1մըո1միո1մոո1մօո1յաո1յեո1յէո1յըո1յիո1յոո1յօո1նաո1նեո1նէո1նըո1նիո1նոո1նօո1շաո1շեո1շէո1շըո1շիո1շոո1շօո1չաո1չեո1չէո1չըո1չիո1չոո1չօո1պաո1պեո1պէո1պըո1պիո1պոո1պօո1ջաո1ջեո1ջէո1ջըո1ջիո1ջոո1ջօո1ռաո1ռեո1ռէո1ռըո1ռիո1ռոո1ռօո1սաո1սեո1սէո1սըո1սիո1սոո1սօո1վաո1վեո1վէո1վըո1վիո1վոո1վօո1տաո1տեո1տէո1տըո1տիո1տոո1տօո1րաո1րեո1րէո1րըո1րիո1րոո1րօո1ցաո1ցեո1ցէո1ցըո1ցիո1ցոո1ցօո1փաո1փեո1փէո1փըո1փիո1փոո1փօո1քաո1քեո1քէո1քըո1քիո1քոո1քօօ1բաօ1բեօ1բէօ1բըօ1բիօ1բոօ1բօօ1գաօ1գեօ1գէօ1գըօ1գիօ1գոօ1գօօ1դաօ1դեօ1դէօ1դըօ1դիօ1դոօ1դօօ1զաօ1զեօ1զէօ1զըօ1զիօ1զոօ1զօօ1թաօ1թեօ1թէօ1թըօ1թիօ1թոօ1թօօ1ժաօ1ժեօ1ժէօ1ժըօ1ժիօ1ժոօ1ժօօ1լաօ1լեօ1լէօ1լըօ1լիօ1լոօ1լօօ1խաօ1խեօ1խէօ1խըօ1խիօ1խոօ1խօօ1ծաօ1ծեօ1ծէօ1ծըօ1ծիօ1ծոօ1ծօօ1կաօ1կեօ1կէօ1կըօ1կիօ1կոօ1կօօ1հաօ1հեօ1հէօ1հըօ1հիօ1հոօ1հօօ1ձաօ1ձեօ1ձէօ1ձըօ1ձիօ1ձոօ1ձօօ1ղաօ1ղեօ1ղէօ1ղըօ1ղիօ1ղոօ1ղօօ1ճաօ1ճեօ1ճէօ1ճըօ1ճիօ1ճոօ1ճօօ1մաօ1մեօ1մէօ1մըօ1միօ1մոօ1մօօ1յաօ1յեօ1յէօ1յըօ1յիօ1յոօ1յօօ1նաօ1նեօ1նէօ1նըօ1նիօ1նոօ1նօօ1շաօ1շեօ1շէօ1շըօ1շիօ1շոօ1շօօ1չաօ1չեօ1չէօ1չըօ1չիօ1չոօ1չօօ1պաօ1պեօ1պէօ1պըօ1պիօ1պոօ1պօօ1ջաօ1ջեօ1ջէօ1ջըօ1ջիօ1ջոօ1ջօօ1ռաօ1ռեօ1ռէօ1ռըօ1ռիօ1ռոօ1ռօօ1սաօ1սեօ1սէօ1սըօ1սիօ1սոօ1սօօ1վաօ1վեօ1վէօ1վըօ1վիօ1վոօ1վօօ1տաօ1տեօ1տէօ1տըօ1տիօ1տոօ1տօօ1րաօ1րեօ1րէօ1րըօ1րիօ1րոօ1րօօ1ցաօ1ցեօ1ցէօ1ցըօ1ցիօ1ցոօ1ցօօ1փաօ1փեօ1փէօ1փըօ1փիօ1փոօ1փօօ1քաօ1քեօ1քէօ1քըօ1քիօ1քոօ1քօ");
        }
    }), gu("gu", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "અ1આ1ઇ1ઈ1ઉ1ઊ1ઋ1એ1ઐ1ઔ1િ1ા1ી1ુ1ૂ1ૃ1ે1ો1ૌ1્2ઃ1ં11ક1ગ1ખ1ઘ1ઙ1ચ1છ1જ1ઝ1ઞ1ટ1ઠ1ડ1ઢ1ણ1ત1થ1દ1ધ1ન1પ1ફ1બ1ભ1મ1ય1ર1લ1વ1શ1ષ1સ1હ1ળ");
        }
    }), uk("uk", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "6’6ь");
            put(3, "2а1а3аа3еа3іа3оа3уа3юа3яа3єа3ї2е1е3ае3ее3іе3ое3уе3юе3яе3єе3ї2и1и3аи3еи3іи3ои3уи3юи3яи3єи3ї2і1і3аі3еі3иі3оі3уі3юі3яі3єі3ї2о1о3ао3ео3іо3оо3уо3юо3яо3єо3ї2у1у3ау3еу3іу3оу3уу3юу3яу3єу3ї2ю1ю3аю3ею3ію3ою3ую3юю3яю3єю3ї2я1я3ая3ея3оя3уя3юя3яя3єя3ї2є1є3ує3ює3єє3ї2ї1ї3еї3ої3юд4жд4за2йе2йи2йі2йо2йу2йю2йя2йє2йї2йь6о");
            put(4, "2б1к2б1п2б1с2б1т2б1ф2б1х2б1ц2б1ч2б1ш2б1щ2в1б2в1г2в1д2в1ж2в1з2в1к2в1л2в1м2в1н2в1п2в1р2в1с2в1т2в1ф2в1х2в1ц2в1ч2в1ш2в1щ2в1й2в’32г1к2г1п2г1с2г1т2г1ф2г1ц2г1ч2г1ш2д1к2д1п2д1с2д1т2д1ф2д1х2д1ц2д1ч2д1ш2д1щ2ж1к2ж1п2ж1с2ж1т2ж1ф2ж1х2ж1ц2ж1ч2ж1ш2з1к2з1п2з1с2з1т2з1ф2з1х2з1ц2з1ч2з1ш2з1щ2к1б2к1г2к1д2к1з2л1б2л1в2л1г2л1ґ2л1д2л1ж2л1з2л1к2л1м2л1н2л1п2л1р2л1с2л1т2л1ф2л1х2л1ц2л1ч2м1б2м1в2м1г2м1д2м1ж2м1з2м1к2м1л2м1н2м1п2м1р2м1с2м1т2м1ф2м1х2м1ц2м1ч2м1ш2м1щ2м’32н1б2н1в2н1г2н1д2н1ж2н1з2н1к2н1л2н1м2н1п2н1р2н1с2н1т2н1ф2н1х2н1ц2н1ч2н1ш2н1щ2н’32п1б2п1д2п1з2р1б2р1в2р1г2р1ґ2р1д2р1ж2р1з2р1к2р1л2р1м2р1н2р1п2р1с2р1т2р1ф2р1х2р1ц2р1ч2р1ш2р1щ2р1й2р’32с1б2с1г2с1д2т1б2т1г2т1д2т1ж2т1з2ф1б2ф1г2ф1з2х1г2х1д2ц1б2ц1г2ц1д2ц1з2ч1б2ч1д2ч1ж2ш1б2ш1г2й1б2й1в2й1г2й1д2й1ж2й1з2й1к2й1л2й1м2й1н2й1п2й1р2й1с2й1т2й1ф2й1х2й1ц2й1ч2й1ш2й1щ2б1б2в1в2г1г2ґ1ґ2д1д2ж1ж2з1з2к1к2л1л2м1м2н1н2п1п2р1р2с1с2т1т2ф1ф2х1х2ц1ц2ч1ч2ш1ш2щ1щ2й1й3ння3ття3ттю3лля3ллє3ллю3ддя3й6о_б’8_в’8_д’8_з’8_м’8_н’8_п’8_р’8_т’8_ф’8_ш’8_бд6_бр6_вб6_вг6_вд6_вж6_вз6_вк6_вл6_вм6_вп6_вс6_вт6_дж6_дз6_дл6_дс6_зб6_зг6_зд6_зл6_зс6_зч6_зш6_зґ6_йш6_кл6_кп6_кс6_кх6_кш6_лс6_ль6_мс6_мф6_нб6_пр6_пс6_пх6_рт6_ск6_сл6_сп6_ст6_сх6_тк6_тр6_тх6_ть6_фл6_хл6_ць6_чх6_шк6_шл6_шп6_шт66бв_6бз_6бй_6бл_6бн_6бр_6бс_6вб_6вв_6вд_6вж_6вз_6вй_6вк_6вл_6вм_6вн_6вп_6вр_6вс_6вт_6вх_6вч_6вш_6вщ_6гв_6гг_6гд_6гл_6гм_6гн_6гр_6гс_6гт_6дж_6дз_6дл_6дм_6дн_6др_6дт_6дь_6жб_6жв_6зв_6зг_6зд_6зк_6зл_6зм_6зн_6зр_6зь_6йб_6йв_6йг_6йд_6йз_6йк_6йл_6йм_6йн_6йп_6йр_6йс_6йт_6йф_6йх_6йц_6йч_6йш_6кв_6кк_6кл_6кр_6кс_6кт_6кх_6кш_6лб_6лг_6лд_6лк_6лл_6лм_6лн_6лп_6лс_6лт_6ль_6мб_6мг_6мж_6мк_6мл_6мм_6мн_6мп_6мр_6мс_6мт_6мф_6мх_6мш_6нв_6нг_6нд_6нж_6нз_6нк_6нм_6нн_6нр_6нс_6нт_6нф_6нх_6нц_6нч_6нш_6нь_6пд_6пл_6пр_6пс_6пт_6пф_6пц_6рб_6рв_6рг_6рд_6рж_6рз_6рк_6рл_6рм_6рн_6рп_6рр_6рс_6рт_6рф_6рх_6рц_6рч_6рш_6рщ_6рь_6ск_6сл_6см_6сн_6сп_6сс_6ст_6сь_6тв_6тл_6тм_6тр_6тс_6тт_6тц_6тч_6ть_6фм_6фр_6фт_6фф_6фь_6хв_6хм_6хн_6хр_6хт_6хш_6ць_6чб_6чм_6чн_6чт_6шв_6шм_6шн_6шт_виї4оо4боб’3од’3’ї4в’ї4з’ї4д’ї4ж’ї4л’ї4м’ї4с’ї4хге4ооо4куя4вді4омі4оі4онзо6ооу4с");
            put(5, "2дь1к2дь1с2дь1т2дь1ц2зь1к2зь1с2зь1т2ль1б2ль1в2ль1г2ль1д2ль1ж2ль1з2ль1к2ль1м2ль1н2ль1п2ль1р2ль1с2ль1т2ль1ф2ль1х2ль1ц2ль1ч2ль1ш2ль1щ2ль1й2нь1б2нь1г2нь1з2нь1к2нь1л2нь1м2нь1с2нь1т2нь1х2нь1ц2нь1ч2нь1ш2нь1й2рь1к2рь1ц2сь1б2сь1д2ть1б2к1сп2к1ст2п1сп2п1ст2с1пк2с1пп2с1пс2с1пт2с1пх2с1пч2с1тк2с1тп2с1тс2с1тт2с1тф2с1тц2с1шт2т1ск2т1сп2т1ст2т1шк2ф1сп2ф1ст2ф1шт2х1ст2ц1ст2ц1шк2ш1тк3п4ре3п4риприї43п4ро3п4ріооб’3ооб3мнао4рнеу4к3блаж3ближ3близ3блок3бран3бруд3глад3глиб3глин3глоб3глуз3глуш3гляд3глян3гнан3гнил3гноз3грав3град3грай3грам3гран3граф3граш3граю3грає3грес3гроб3грож3гроз3груп3грів3гріт3гріш3д4ан3двиг3двою3двоє3двій3двір3драж3дром3друж3друк3дряп3дріб3жвав3зваж3зван3звед3звел3звич3звищ3звук3звуч3звіт3змін3зйом3зміш3знав3знай3знак3знал3знан3знат3знач3знаю3знає3зниж3знім3зрюв3зрів3зріл3зрін3й4ма3с4пі3х4то3ї4зд3ї4ставі4абі4о3дої4ддої4мдої4хдої4жзаї4дзаї4жзаї4ззаї4лзаї4мзаї4хзо4казо4кезо4кизо4кузо4кіий4тиій4тинаї4жнаї4знаї4лнаї4мнаї4снаї4хпоя4в_пої4пої4дпрої4сеї4ду4к4рвия4вз’я4взая4вная4веті4одея4као4хаео4ханія4кдоу4кдоу4мнею4ннея4кое4копоя4соа4ктеа4ктий4няпій4мвий4мзай4моа4на");
            put(6, "2к1ськ2п1ськ2с1ськ2с1тсь2сь1кк2сь1кс2сь1кт2т1ськ2ф1ськ2х1ськ2ш1тсь_вб6’6_вв6’6_вз6д6_вм6’6_вп6’6_вп6х6_вс6т6_вш6к6_зв6’6_зд6з6_зм6’6_зс6к6_зс6т6_зш6к6_лк6с6_ск6л6_сп6’6_сп6л6_сп6х6_сх6л66б6ль_6б6ст_6б6ць_6в6др_6в6дь_6в6зь_6в6ль_6в6сь_6в6ць_6г6ль_6г6сь_6д6зь_6ж6дь_6ж6сь_6з6дв_6з6дн_6з6дь_6з6нь_6з6сь_6з6ьб_6з6ьк_6й6кл_6й6ль_6й6мс_6й6нс_6й6ст_6й6сь_6й6тс_6к6ль_6к6ст_6к6сь_6к6тр_6л6ль_6л6мс_6л6хв_6л6ьб_6л6ьв_6л6ьг_6л6ьд_6л6ьз_6л6ьк_6л6ьм_6л6ьн_6л6ьп_6л6ьс_6л6ьт_6л6ьф_6л6ьх_6л6ьц_6л6ьч_6л6ьш_6л6ьщ_6м6бр_6м6ль_6м6сь_6н6гл_6н6гр_6н6гс_6н6дж_6н6дз_6н6дп_6н6др_6н6кс_6н6кт_6н6ск_6н6ст_6н6тк_6н6тр_6н6ть_6н6ць_6н6ьб_6н6ьг_6н6ьк_6п6сь_6п6тр_6р6дв_6р6дж_6р6дь_6р6зн_6р6зь_6р6кс_6р6кт_6р6ль_6р6нс_6р6нь_6р6ср_6р6ст_6р6сь_6р6тв_6р6тр_6р6ть_6р6ць_6с6дп_6с6ль_6с6тв_6с6тй_6с6тм_6с6тр_6с6ть_6с6ць_6с6ьб_6с6ьк_6с6ьм_6т6вт_6т6зт_6т6ль_6т6мр_6ф6ть_6ц6тв_6ц6ьк_6ш6ль_6ш6нл_6ш6сь_6ш6тв_6щ6сь__бе4з3_безу4віду4ч_ві4д3_від’3_мі4ж3ові4д3_пере3_під’3_пі4д3_пі4в3_ро4з3ооб3рона4д’3за5о4рдо5о4рпо5о4рз3в’4яза3ю4шу3в’4яз3м’4яу3м’4яв3м’4язу4рочприо4р3й4ш4л3блиск3блоці3брати3брест3бризк3в4бив3в4дал3в4лад3в4лов3в4сюд3в4тіл3гнучк3грати3грець3грунт3д4бав3д4бал3д4бан3д4бат3д4бає3двічі3дріма3жміть3жріть3з4був3з4бут3звест3звись3з4год3з4дат3з4чеп3й4мищ3й4му_3й4шов3м4нож3м4щен3п4сов3п4сон3п4сув3р4вав3с4кид3с4кок3с4коп3с4кор3с4коч3с4пад3с4пин3с4піш3с4тав3с4тад3с4таз3с4тал3с4тан3с4тар3с4тат3с4тач3с4тає3с4теп3с4тиг3с4тиж3с4той3с4тою3с4туп3с4тяг3с4тіб3с4тій3с4тір3с4фер3с4хил3с4хов3с4хід3т4кан3ш4код3ш4кол3ш4кіл3ш4кір3ш4таб3ш4туч3ґрунт3е4тап3о4бід3о4біц3о4дяг3о4соб3о4хоч3о4чищ3у4ваг3у4важ3у4гав3у4мит3у4міл3у4ряд3я4зик3я4кіс3я4рус3є4д3н3є4дин3є4рей3ї4ждж3ї4хав3ї4хат_заї4к_заї4ц_заї4ч_наї4давої4дае4тилахої4дауді4обе5конб’4єтьбран4дви3й4дви3й4т3в’4яз4д7земді3й4тді3й4д_дої4в_дої4лдої4стеу4стрео4свіек2с1кек2с1пек2с1тек2с1цигої4діе4тилйо4свіквої4д3м’4ятна3з4внаї4вснаї4вшна4й3ана4й3енедої4неї4стоної4доо4палео4палонаї4доо4свіоу4строа4томпоч4непоч4нипоч4нупої4здраді4оз’4єднрмої4дсор4тнцук3роубої4дясої4дви3у4чза3у4чна3у4чне3у4чгелі4ополі4осоці4офізі4охімі4огоме4оао4пікка5налоі4золмете4оабия4квия4сннея4снпоя4сннеа4биео4ціноо4цінео4бурео4зорпіво4спале4оао4хотео4хотео4щадао4щадоо4чищоо4бігоу4суноу4комз3а4ктеу4богзай4нянай4няприй4мдій4манай4маобой4мпрой4мобій4моу4годау4годеу4годео4писоо4писао4пис_ом4рі_ум4ри_ум4рі_ум4ру_ум4ревиу4ди");
            put(7, "_бе4з’3_ві5д4а_ві5д4іневі4д3_пі5д4о_пі5д4і_пі5д4е_пі5д4и_пі5д4у_спі4в3_ро5з4і_ро5з4е_ро5з4а_ро4з’3до3в’4єза3в’4єзі3в’4єпо3в’4єуі3в’4єпо3в’4яза3в’4язі3в’4яна3в’4яоб3в’4язі3м’4яно3м’4яза3м’4яна3м’4яоб3м’4япо3м’4ясу3м’4ядо3в’4юза3в’4юзі3в’4юна3в’4юпо3в’4юуі3в’4юза3я4локоу4рочпоу4роч3м4к4не3м4к4ну3м4к4ні3с4к4ле3с4к4ло3британ3в4довз3в4ласн3в4лашт3в4певн3громад3груван3г4ідро3з4бага3зворуш3з4довж3знаход3зрозум3й4менн3й4муть3й4міть3м4ріть3р4вати3р4віть3с4кіль3с4кіпл3с4пект3с4перм3с4піть3с4тайн3с4тара3с4тисл3с4титу3с4товб3с4тосо3с4тосу3с4тоян3с4тіль3ш4кідл3а4гент3а4грес3а4зарт3а4ктив3а4куст3а4кциз3а4птеч3а4соці3а4тлет3а4халі3е4моці3е4мігр3е4нерг3е4стет3о4бира3о4даль3о4збро3о4крем3о4плат3о4птим3о4пуст3о4пуше3о4пуще3о4ренд3о4сяжн3о4холо3о4чисн3у4згод3у4клад3у4рбан3у4спіш3у4твор3я4дерн3є4писк3і4снув_бе5зе_бйор4нсвер4х3нвід7знаві5д4енві5д4омво4с5ко_дої5ль3з’4ясозна3й4дзна3й4ткорої4д3м’4якшна3в4чанео4палобі3й4добі3й4тпереї4дпереї4жпереї4зпереї4лпереї4спереї4хпре4й4спо3д4вопри3й4тпро4ф3спор4т3нпри3й4дроз5винроз5витро5з4умспе4цпрспе4ц3ссь4квугтран4с3під3у4чво4єводво4єначді4алогді4огенпроя4снрозо4рарозо4рерозо4рннапоу4мне4олітне4ологне4онацне4офітнея4рок_пе4ом_д3у4сімроз’я4рте4ологте4ософа3у4даро3у4дарз3у4дарв3у4дареі4стотоі4стотоо4чистнайа4ктпіва4ктао4бразео4бразоо4бразиа4варіяа4варіоа4варіеа4варіаа4дресеа4дресоа4дресіа4дресае4фектее4фектое4фектое4місіие4місіяе4місіее4місій3у4богздій4няобій4няд4о3й4мперей4мбезу4глоа4каціоо4держбіблі4о_на3в4ч_ви3в4ч_до3в4ч_за3в4ч_по3в4чана3в4чена3в4чови3в4чеви3в4чедо3в4чоза3в4чпо3в4чае3м4рій_ви3м4р_за3м4р_зі3м4р_на3м4р_по3м4рие4стетое4стетее4стетоо4ктаніо4ктано3в4казе3в4каз");
            put(8, "6б6с6тв_6б6с6тр_6б6с6ьк_6в6с6тв_6в6с6ть_6в6с6ьк_6г6с6тв_6д6с6тв_6д6с6ьк_6д6ь6сь_6й6с6тв_6й6с6тр_6й6с6ьк_6л6ь6дс_6л6ь6сь_6л6ь6тр_6м6б6ль_6м6с6тв_6м6с6ьк_6н6г6ль_6н6с6тв_6н6с6тр_6н6с6ьк_6н6ь6сь_6п6с6тв_6р6л6ьз_6р6н6ст_6р6с6тв_6р6с6ть_6р6с6ьк_6р6щ6сь_6с6д6рп_6с6т6рь_6т6с6тв_6т6с6ьк_6т6ь6сь_6ф6с6тв__ві5д4ом_ві5д4ун_ві5д4ербезві4д3неві4д’3_пона4д3_напі4в3ро5з4йом_чере4з3пере5о4рпі6д5о4робі3в’4євід3в’4япри3в’4япід3в’4япри3м’4янаду4рочприу4роч3в4б4лаг3в4к4лад3в4п4лив3в4т4рут3в4т4руч3з4б4рой3з4б4рою3з4б4роє3з4в4’яз3п4с4ков3с4к4лад3с4к4лит3с4п4лав3с4п4лат3с4п4лач3с4п4рав3с4т4вор3с4т4рах3с4т4риб3с4т4риж3с4т4рой3с4т4рок3с4т4ром3с4т4роф3с4т4роч3с4т4рою3с4т4роя3с4т4роє3с4т4рої3с4т4рій3с4т4ріл3с4т4річ3т4к4нен3т4ь4мар3у4п4рав3в4веден3в4довол3в4живан3в4поряд3в4рожай3з4доров3з4дійсн3с4короч3с4повід3с4пожив3с4табіл3с4тереж3с4теріг3с4торон3с4торін3а4дитив3а4ктуал3а4курат3а4кцепт3а4лергі3а4матор3а4наліз3а4натом3а4парат3а4пеляц3а4ромат3а4спект3е4колог3е4коном3е4лектр3о4б’єдн3о4б’єкт3о4береж3о4борон3о4перат3о4хорон3у4компл3у4крупн3у4перед3у4рядов3у4стпіш3у4тробн3я4скрав3і4зотоп3і4люстр3і4мовір3і4нтенс3і4нформальбі5онбей4сболбо4г3данбо4є3голбо4є3готбо4є3запбори4с5пвина3й4двина3й4тві5д4е4оджен4тльди4с3локди4с3пледи4с3путди4с3тилд4ні3п4рдо3з4волдо3з4вілкон4трремо4к5рийна3б4лизна3в4рядна4д7з4вна3в4ченне3в4томне3д4банна3д4банне3з4вичне3з4важна5п4ливні4т5ратоб5у4мовпере3й4дпере3й4тпі5в4еньпо3в4торпо3в4ченпо3д4робпо3д4разпо5з4бавпри4нципрай3в4нороз5вантро4з5ділро4з5горро4з5верро4з5чепро4з3ливсан4к4т3серцеї4дстат5упрукр3а4втукр3а4грукр3е4кснедо3у4чпед3у4чипере3у4чсамо3у4чсво4єчассво4єрідоо4динокміжу4собнай3я4снроз’я4снро5з4ориро5з4ороро5з4оруро5з4оряро5з4орюро5з4орірозо4решео4голошбальне4оне4окласпі5в4оніп4о5берео3о4кисли3о4кисле3о4кислх3о4кисли3і4сторо3і4сторі3і4стора3і4сторя3і4сторе3і4сторар4т3мінар4т3підар4т3ринар4т3хімперей4няпідій4нябезу4пин_при3в4чмона3в4чжона3в4чіона3в4ч_зав3м4р_при3м4р_роз3м4рй3е4стет");
            put(9, "6л6ь6ств_6л6ь6ськ_6н6с6ькй_6н6т6ств__бе5з4о3д_безві4д3_ві5д4озвді4єві4д3за4вві4д3співві4д3_пере4д3г_пере4д3д_пере4д3м_пере4д3р_пере4д3ч_пере4д’3_пона5д4і_пона5д4и_пона5д4я_чере4з’3непо3в’4япере3м’4япіді3м’4япозау4роч3в4п4равн3с4к4рипт3с4п4ритн3с4п4рият3с4п4ромо3с4т4ражд3с4т4рукт3с4т4рукц3т4ь4мяні3в4разлив3з4баланс3й4мовірн3с4постер3а4вторит3а4декват3а4постол3а4ргумен3е4легант3е4лемент3е4стакад3о4рдинац3у4люблен3у4разлив3у4рочист3у4станов3у4сувати3і4ніціатай4с3бергбактері4оба4с3енербез5і4менбо4є3здатбо4є3компбо4є3постбо4є3прип4в3антрацге2ть3мандер4ж5виддер4ж5думдер4ж5комдер4ж3бездер4ж5стрдисбалансди4с3гармди4с3квалди4с3комфди4с3контди4с3кредди4с3кретди4с3крецди4с3кримди4с3кусіди4с3кутуди4с3персди4с3петчди4с3плейди4с3позиди4с3пропди4с3трибди4с3трофєв4р3атомєпі4с5копєпи4с5копза4п3часті4л3е4тилкиї4венермі4н5е4кона4й3маслна4й3сприна4й3якісна3в4чітьобі3д4раноб4лдер4жперег4нійпере4д5смпід5о4динпо3б4лизупо3в4чітьпо5ж4нітьпос4т3каппос4т3компос4т3натпос4т3соцпор4т3ретпор4т3фелпро4ект3нпро3б4лемпро4м3майпр4о5платро4з5д4вороз5у4ченроз5і4менро4з’5єднро4з3громспе4ц3курспе4ц3мон3с4проможтур4к3менро5з4ора_ро5з4орахне4омальтне4окомунне4оландшне4оліберно4к3а4утте4одолітпів3о4валнаді4сторар4т3афішар4т3кафеар4т3майсар4т3мейсар4т3фактнаді4стотнайі4стотау4т3еколбеза4варібезе4місіо3а4налізц3а4налізз3а4налізм3а4налізпів3у4годроз3у4год_віді3м4р_пере3м4рво4станнєоо4плачувео4плачув");
            put(10, "_без5о4соб_без3ро4з3те4х3ві4д3_пере4д3св_пере4д3фрбе4з5і4дейінтер3в’4юна4й3у4бог3в4р4одливба4с3антравід5о4бражвід5о4бразводо5с4токводо5з4бірго4с4п5роздер4ж5а4дмдер4ж5бюдждер4ж5нафтдер4ж5реєсдер4ж5служдвох4а5томди4с3паритди4с3функцкон4тр3аргмі4н5е4нерна4й7о4берна4й7о4гидна4й7о4голна4й7о4пукна4й7о4хайпере5п4ливпере3в4томпів5о4с4трпос4т3процпос4т3фіксспор4т3вирспор4т3залспор4т3комспор4т3майтор4г3предсво4єкорисро5з4о5рамро6з5о4ри_ень7о4кислнай3і4сторпів3і4сторар4т3взводар4т3медіаар4т3о4динар4т3о4збрар4т3центргіпер3а4ктнай3о4бразар4т3мейстго4ф3мейстдо4к3мейстхо4р3мейстміж3а4варінад3а4варібез3а4дреснай3е4фектбло4к3пост_блі4ц3ана_блі4ц3турнт3а4налізре3а4налізбо4р4т3мехбо4р4т3пробо4р4т3радпан3е4стетпар3е4стет");
            put(11, "про4ф3ві4д3спе4ц3ві4д3_пере4д3бач_пере4д3виб_пере4д3ост_пере4д3пла_пере4д3пок_пере4д3усібрі4дж3портволь4т3метргі4д5ро5метдер4ж5а4томдер4ж5замовзе4кономитиказа4х3станквар4т3платжко4м5а4томкому4ненергна4й3обережна4й7о4грядоб4л3а4дмінперед5о4бідперед5у4мовпо4с4т5комупо4с4т3декрпо4с4т3радіпо4с4т5соціпро3с4тирадполі4т5еконро4з5міннийруко5с4тискспор4т3клубспор4т4с3мечорно3б4ривхво4є3г4ризпа4н3о4тецьконтр3у4дарпост3і4сторар4т3десантар4т3о4бстрар4т3у4станграф3о4бразгро4с3мейсткра4н3мейстшта4л3мейстєге4р3мейстпост3а4варі_блі4ц3криг_блі4ц3опит_блі4ц3торгбак3а4налізген3а4налізміж3а4налізгос4п3у4годбо4р4т3і4нжнай3о4станнперед3о4пла");
            put(12, "_пере4д3умовволь4т3ампердер4ж3резервдорого5в4казінфор4м3агенпо4с4т5радянпо4с4тприватукр3і4н4банкперед3і4сторсупер3о4бразбаге4р3мейстбале4т3мейстбран4д3мейстполі4ц3мейстпо4ш4т3мейстшапі4т3мейстнапів3а4варіперед3а4варісупер3а4варісупер3е4фектгіпер3е4місіполі3а4налізбо4р4т3о4пер");
            put(13, "по4с4т3контрацен4т4р3енергва4ль4д3мействе4ль4т3мейстдекре4т3мейсткапе4ль3мейст_блі4ц3і4спитперед3о4станн");
            put(14, "енерго3з4береженерго3з4берігкварти4р3мейстфо4р4с4т3мейст");
            put(15, "по4с4т3менопаузконце4р4т3мейст");
        }
    }), bn("bn", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "অ1আ1ই1ঈ1উ1ঊ1ঋ1এ1ঐ1ঔ1ি1া1ী1ু1ৃ1ে1ো1ৌ1ৗ1্2ঃ1ং11ক1গ1খ1ঘ1ঙ1চ1ছ1জ1ঝ1ঞ1ট1ঠ1ড1ঢ1ণ1ত1থ1দ1ধ1ন1প1ফ1ব1ভ1ম1য1র1ল1শ1ষ1স1হ");
            put(3, "2ঃ12ং1");
        }
    }), hi("hi", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "अ1आ1इ1ई1उ1ऊ1ऋ1ऎ1ए1ऐ1ऒ1औ1ि1ा1ी1ु1ू1ृ1ॆ1े1ॊ1ो1ौ1्2ः1ं11क1ग1ख1घ1ङ1च1छ1ज1झ1ञ1ट1ठ1ड1ढ1ण1त1थ1द1ध1न1प1फ1ब1भ1म1य1र1ल1व1श1ष1स1ह1ळ1ऴ1ऱ");
        }
    }), sl("sl", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "_č8_š8_ž81fa1hu1kn1sc1sp1wa1ye1zi1zn1zo1zu1čj1čl2cc2ck2ew2ft2jh2nč2vč8č_8š_8ž_a1aa1ba1ca1da1fa1ga1ha1ia1ja1ka1la1ma1na1oa1pa1sa1ta1va1ča1ša1žb1hb1mb1zb1žbe1bi1bo1d2ed2oe1ae1be1ce1de1ee1fe1ge1he1ie1je1ke1le1me1ne1pe1se1te1ve1ze1če1še1žfe1fu1go1gu1i1ai1bi1ci1di1fi1gi1hi1ii1ji1ki1li1mi1ni1pi1ri1si1ti1ui1vi1xi1zi1ši1žju1ki1ko1le1lo1na1ne1nu1o1ao1bo1co1do1eo1fo1go1ho1io1jo1ko1lo1mo1no1oo1po1so1to1uo1vo1yo1zo1čo1šo1žpe1po1qu2r1fr1rr1žre1ri1ro1si1su1t1ftu1u1bu1cu1du1eu1fu1gu1hu1iu1ju1lu1mu1nu1pu1su1tu1vu1zu1ču1šu1žv1fv1gvz2wo2x1fy1jy1ly1wz1cz1gz1tz1šz1žči1š2č");
            put(4, "_is1_iz1_od1_st41ind1inp1inš1kre1liz1loč1naj1nas1naz1neh1peč1str1usp1viv1z1r1z2a1zlj2b1c2b1d2b1k2b1n2b1s2b1t2b1v2b1č2b1š2c1n2c1t2ch_2d1b2d1c2d1d2d1g2d1h2d1j2d1k2d1p2d1s2d1t2d1v2d1č2d1š2d3m2f1n2f1s2g1d2g1t2h1k2h1n2h1t2h1č2h1š2ine2iss2j1b2j1c2j1d2j1g2j1k2j1l2j1m2j1n2j1p2j1r2j1s2j1t2j1v2j1z2j1č2j1š2jos2jus2juč2k1c2k1d2k1m2k1t2ks_2l1b2l1c2l1d2l1f2l1g2l1h2l1k2l1l2l1m2l1n2l1p2l1s2l1t2l1v2l1z2l1č2l1š2l1ž2lj_2ljk2ljn2ljs2ljč2ljš2m1b2m1c2m1d2m1f2m1k2m1m2m1p2m1s2m1t2m1v2m1č2m1š2m1ž2n1b2n1c2n1f2n1g2n1h2n1k2n1l2n1n2n1p2n1s2n1t2n1v2n1z2n1š2n1ž2nj_2njc2njk2njs2njš2p1c2p1k2p1s2p1t2p1š2r1b2r1c2r1d2r1g2r1h2r1j2r1k2r1l2r1m2r1n2r1p2r1s2r1t2r1v2r1z2r1č2r1š2rae2s1b2s1f2s1j2s1s2sk_2st_2stk2stm2t1b2t1c2t1d2t1k2t1m2t1s2t1t2u1a2v1b2v1c2v1d2v1j2v1k2v1m2v1n2v1p2v1t2vzo2y1f2z1b2z1h2z1j2z1k2z1m2z1p2z1s2z1č2č1b2č1g2č1k2č1n2č1p2č1s2š1j2šč_2ščk2ščn2ž1b2ž1c2ž1j2ž1k2ž1č3ktr3ste4bmi4eth4hl_4igh4ile4ilo4ire4job4jož4ljc4njv4ogl4opy4phs4sc_4stf4tz_4urg4vjo4všk4zri4zru4čop4čup4žmia1e1a1raa1rea1ria1roa1rua1u1a1zea2uka4hma4jfa4mza4nma4pha4sša4tfa4ufa4ula4vžad2laf1tak4sat4ib1jaba4ube4vc1kack1sd1lod2lid4urdis1e1o1e1rae1ree1rie1roe1rue1u1e4dfe4epe4ffe4rfe4rre4wte4ywe4zte4zže4čde4čte4špeb4jed2lei2zez2gez4lh4loha4uhe4ii1e1i1o1i1čai1čei1čii1čui2zri4csi4kči4mhis4aiz1liz1uj1hijra1kok4ks1cks1pks1tl2i1le4en1čan1čen1čin1čun4dmn4ghn4gvn4tgn4tvnz4io1rao1reo1rio1roo1ruo2olo4aso4bzo4cro4kbo4kto4lro4omo4pmoiz2oz2noz2ooz2roz2voz4boz4gr4inr4thrz2ls2cis2kns4ids4onsis1taz4u1kau1keu1kou1rau1reu1riu4bpu4thub4jv1čav1čev1čiv2zav2zuv3zpve4ivt4kz1igz1liz1luz1obz1ogz1v2z2olz3dvz3kuz3vnz4omz4ujše2s");
            put(5, "_av5r_ek3s_ek5v_si4s2d1z22j1od2n3d22p3č22v3zk2z1d22z1is2z1od2z1up2z1uz2z1z23inse3intr3razl3raču3real3rodi3v2pa3v2zg3zbir3zlil3zlog3zlož4d3vi4dind4dnas4dobč4idor4inšk4jime4kst_4ktra4mind4minp4minš4ploz4skre4tind4tinp4tnaj4zrez4zreš4zrež5dlet5obla5obro5oseb5redč5stim5tema5zlit5zliva4ksta4ziga4zoba4zraa5ju_ab5baac5ciad5uraf5gaah5miah5moai2n1aj3osaj3ugaj3učaj5fiaj5foaj5haaj5heaj5imaj5žnan5mian5ziao2b1ar5xaar5xoar5xuas5ščav5šiav5žaay5toaz3laaz3leaz5foaz5vpaž5mib3jemb3lepb3rabb3rašb3rezb3robb4ja_b5jelb5jetb5lilb5litb5livb5ordb5rasbo5vpbu5kibu5kubu5kvbu5ryc5ko_ch5mack1o2ck5weckov3d3repd4revd5litd5livd5nivd5razde4mndi5ckdo5rddo5včdu5rodu5ume2č1ve4zobe5stae5zije5zised5iged5obed5včed5zbef5feef5taeiz5eeo4dleob4jeob4res5daev5haew5leew5toez4moez4reez5djez5glez5izeč3leeč5deeč5dieč5doeč5opeč5tieč5toeč5treč5upeš5poff5mafre4uft5vego5vzh5reni4skvii2n1ik5čaim5hiisis4it5priv5joiz4laiz5meiz5moiz5poič5raič5vrj5aktjod4ljraz4ju2ž1ju5dmk5satk5vipke5tiko5kdks4poks5teku5rola4irle5melg5čalu5kilu5kum5nivm5urnme4drmy5hin4ostnad5rnaj3ond5gand5hine3d2ne3zmnez4vng5hang5vino5rdnsis4nt5gant5gent5viny5quo2d1žo2v1zo5vzaob5glob5jooc5keoc5kiod5dvod5zdoele4ok5baok5beol5reood4lop5meou5kiou5kuov3zdov5škoz5loozd5jož5mipe4ktpet3lph5sopi5zoprez4pč5kar3v2jrav5zre5jore5kmre5čvriz4griz4lriz4nro5zort5haru5klrv5jory5anrž5das4lavs4tens4tirs4tičse5mase5vpsoni5su4bosve5tta5witch5ote5xatrt5uub5pouth5oux5emuše3sv4pijv4pilv4červ5sknv5šekve4člve4čmvi5dvvo5rdz4gniz4venz4vokz5gotz5lasz5lomza1z2za3vpza5ukza5zdzd5juzliz5č5mes");
            put(6, "_ob5it_obi4d_voz5l_voz5n_zliz62d3o2f3z4voj4d3nac4d3nar4d3nož4d5nap4d5nač4d5neb4d5niz4d5obd4j5int4l5izd4t3int4tinos4tinse4z5išč4zredč4č3let5načela4j5eka4z3oča6doblab6rodad6rl_ad6rlaad6robaj6imoaj6stban6dgaan6dhiar6dwaaz4lilaz4litaz4livaz4redaz5oraaz5orob5letab5režeba6bbaban3č4bo6chmbr6ždabre4zgbre4zibre4zrd4i5nodd6vojde4minde4z3idi4skrdi6sprdo5v4zdre6pndteks6e3z4dre4d3oče4dobse4tinše4z5ore5sti_e5stihe5stileb6lized6obeed6obrei6pziek6malek6treeo4z5nep5nikev5stvev6preev6steew6indez5imnez6ijoez6istez6lomez6maneč6vrsfe6ljtfi6zljfo6urige6igege6njčgel5č4gi6tprhu6ffmil5č4kis6ertiz6odeiz6ureizli4zje4ks4jsis6tjz6vesko6všekoz6loks6tazla6vz_le6ipzli6dž_me4d5nme6dosmi6th_mo6vš_mo6št_na4drena4j3una4v3zna6drana6durna6jakna6jočnavze6naz6ornteks4o6drepob5ideod5nalol6gčaor4dečose4m5ov5semoz5nicoz5nišoz6ložpe4tlepe4v5spev5t4po4d3lpo4dnapo6dfapo6lobpo6stdpz6ig_ra6jžnra6vzare6chtre6digre6ibare6sdare6zusre6zverev6skri5n4orob6ids4plods4tra_sek5sisi6gn_sonič4spod4ltek6stto6vž_tr6turud6mi_up6čkave4tinvi6žg_vid6vavoz5lez6ane_");
            put(7, "_di6spo_po4d5n_po4v5s_se4k5s3i4n3os4d5njač6d5elem6tletnoera5z4rera5z4vera6z5leve6t5llju5d6jna4d5njna4j5ennje4v5so6l5avtpo4d5očra4z5idra4z5orre6dnjure6značse4k5savetle6t");
            put(8, "_pre6d7ne4z5u4m5");
        }
    }), pl("pl", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "a1ą1e1ę1i1o1ó1u1y1");
            put(3, "_a1_b8_c8_ć8_d8_e1_f8_g8_h8_i1_j8_k8_l8_ł8_m8_n8_ń8_o1_p8_r8_s8_ś8_t8_u1_v8_w8_x8_z8_ź8_ż8ś1cc4hc4zd4zd4źd4żr4zs4z8b_8c_8ć_8d_8f_8g_8h_8j_8k_8l_8ł_8m_8n_8ń_8p_8r_8s_8ś_8t_8v_8w_8x_8z_8ź_8ż_ae2ai2ao2be1bi1bo1bu1ca1cu1de1du1ea2ei2eo2fi1fo1ga1go1hi1hu1ja1ka1ki1ko1le1lu1ly1ma1mi1mo1mu1na1oa2oe2oi2ou2pa1po1ro1se1so1sy1to1tu1ty1ua2ue2ui2uo2vo1we1ya2ye2yi2yo2yu2ze1");
            put(4, "_ae2_be1_bh8_bj8_bl8_bł8_br8_bv8_bw8_bx8_ca1_ci1_cj8_cł8_cr8_cv8_cw8_cx8_ćh8_ćj8_ćl8_ćł8_ćr8_ćv8_ćw8_ćx8_da1_de1_dh8_dj8_dl8_dł8_do1_dr8_dv8_dw8_dx8_dy1_fb8_fć8_fd8_fg8_fh8_fj8_fl8_fł8_fń8_fp8_fr8_fs8_fś8_ft8_fv8_fw8_fx8_fz8_fź8_fż8_ge1_gh8_gj8_gl8_gł8_gn8_go1_gr8_gv8_gw8_gx8_hi1_hv8_hx8_ja1_jv8_jx8_kh8_ki1_kj8_kl8_kł8_ko1_kr8_kv8_kw8_kx8_lu1_lv8_lx8_łv8_łx8_mi1_mo1_mv8_mx8_na1_ne1_ni1_nv8_nx8_ńv8_ńx8_ot2_oa2_oc2_oć2_of2_og2_oh2_ok2_om2_op2_os2_oś2_ow2_oz2_oź2_oż2_pe1_ph8_pi1_pj8_pl8_pł8_po1_pó1_pr8_pv8_pw8_px8_re1_ro1_rv8_rx8_sa1_sc8_sć8_sh8_si1_sj8_sk8_sl8_sł8_sm8_sn8_sń8_so1_sp8_sr8_sś8_st8_su1_sv8_sw8_sx8_ść8_śh8_śj8_śl8_śł8_śm8_śn8_śń8_śr8_śv8_św8_śx8_ta1_te1_th8_tj8_tl8_tł8_to1_tr8_tv8_tw8_tx8_ty1_uć2_uś2_vb8_vc8_vć8_vd8_vf8_vg8_vh8_vj8_vk8_vl8_vł8_vm8_vn8_vń8_vp8_vr8_vs8_vś8_vt8_vv8_vw8_vx8_vz8_vź8_vż8_we1_wh8_wi1_wo1_wv8_wx8_wy1_xb8_xc8_xć8_xd8_xf8_xg8_xh8_xj8_xk8_xl8_xł8_xm8_xn8_xń8_xp8_xr8_xs8_xś8_xt8_xv8_xw8_xx8_xz8_xź8_xż8_za1_zb8_ze1_zg8_zh8_zi1_zj8_zl8_zł8_zm8_zn8_zń8_zo1_zr8_zv8_zw8_zx8_zź8_zż8_źh8_źj8_źł8_źń8_źr8_źv8_źx8_żh8_żv8_żx82b1c2b1ć2b1d2b1f2b1g2b1k2b1m2b1n2b1ń2b1p2b1s2b1ś2b1t2b1z2b1ź2b1ż2c1b2c1ć2c1d2c1f2c1g2c1k2c1l2c1m2c1n2c1ń2c1p2c1s2c1ś2c1t2c1ź2c1ż2ć1b2ć1c2ć1d2ć1f2ć1g2ć1k2ć1m2ć1n2ć1ń2ć1p2ć1s2ć1ś2ć1t2ć1z2ć1ź2ć1ż2d1b2d1c2d1ć2d1f2d1g2d1k2d1m2d1n2d1ń2d1p2d1s2d1ś2d1t2f1c2f1k2f1m2f1n2g1b2g1c2g1ć2g1d2g1f2g1k2g1m2g1ń2g1p2g1s2g1ś2g1t2g1z2g1ź2g1ż2h1b2h1c2h1ć2h1d2h1f2h1g2h1j2h1k2h1l2h1ł2h1m2h1n2h1ń2h1p2h1r2h1s2h1ś2h1t2h1w2h1z2h1ź2h1ż2j1b2j1c2j1ć2j1d2j1f2j1g2j1h2j1k2j1l2j1ł2j1m2j1n2j1ń2j1p2j1r2j1s2j1ś2j1t2j1w2j1z2j1ź2j1ż2k1b2k1c2k1ć2k1d2k1f2k1g2k1m2k1n2k1ń2k1p2k1s2k1ś2k1t2k1z2k1ź2k1ż2l1b2l1c2l1ć2l1d2l1f2l1g2l1h2l1j2l1k2l1ł2l1m2l1n2l1ń2l1p2l1r2l1s2l1ś2l1t2l1w2l1z2l1ź2l1ż2ł1b2ł1c2ł1ć2ł1d2ł1f2ł1g2ł1h2ł1j2ł1k2ł1l2ł1m2ł1n2ł1ń2ł1p2ł1r2ł1s2ł1ś2ł1t2ł1w2ł1z2ł1ź2ł1ż2m1b2m1c2m1ć2m1d2m1f2m1g2m1h2m1j2m1k2m1l2m1ł2m1n2m1ń2m1p2m1r2m1s2m1ś2m1t2m1w2m1z2m1ź2m1ż2n1b2n1c2n1ć2n1d2n1f2n1g2n1h2n1j2n1k2n1l2n1ł2n1m2n1ń2n1p2n1r2n1s2n1ś2n1t2n1w2n1z2n1ź2n1ż2ń1b2ń1c2ń1ć2ń1d2ń1f2ń1g2ń1h2ń1j2ń1k2ń1l2ń1ł2ń1m2ń1n2ń1ń2ń1p2ń1r2ń1s2ń1ś2ń1t2ń1w2ń1z2ń1ź2ń1ż2p1b2p1c2p1ć2p1d2p1f2p1g2p1k2p1m2p1n2p1ń2p1s2p1ś2p1t2p1z2p1ź2p1ż2r1b2r1c2r1ć2r1d2r1f2r1g2r1h2r1j2r1k2r1l2r1ł2r1m2r1n2r1ń2r1p2r1s2r1ś2r1t2r1w2r1ź2r1ż2s1b2s1d2s1f2s1g2s1s2s1ź2s1ż2ś1b2ś1d2ś1f2ś1g2ś1k2ś1p2ś1s2ś1ś2ś1t2ś1z2ś1ź2ś1ż2t1b2t1c2t1ć2t1d2t1f2t1g2t1k2t1m2t1n2t1ń2t1p2t1s2t1ś2t1z2t1ź2t1żtr4z2w1b2w1c2w1ć2w1d2w1f2w1g2w1j2w1k2w1l2w1ł2w1m2w1n2w1ń2w1p2w1r2w1s2w1ś2w1t2w1z2w1ź2w1ż2z1c2z1ć2z1d2z1f2z1k2z1p2z1s2z1ś2z1t2ź1b2ź1c2ź1ć2ź1d2ź1f2ź1g2ź1k2ź1l2ź1m2ź1n2ź1p2ź1s2ź1ś2ź1t2ź1w2ź1z2ź1ż2ż1b2ż1c2ż1ć2ż1d2ż1f2ż1g2ż1j2ż1k2ż1l2ż1ł2ż1m2ż1n2ż1ń2ż1p2ż1r2ż1s2ż1ś2ż1t2ż1w2ż1z2ż1źdni1mne1pne1wc4zwła1wło14b3b4c3c4ć3ć4d3d4f3f4g3g4h3h4j3j4k3k4l3l4ł3ł4m3m4n3n4p3p4r3r4t3t4w3w4z3z4ź3ź4ż3żbr4zdr4zpr4zrs4zsc4ha2u1a2y1a1a2blo1bro1chu1dże1er4ze2u1e2y1e1e2gra1gro1i2a1i2ą1i2e1i2ę1i2i1i2o1i2ó1i2u1i2y1o2y1oc4ho1o2pre1roe2sko1sza1sze1szy1u2y1u1u2_by1");
            put(5, "_a2d3_a2u1_c4h8_c4z8_cza1_ćwi1_dłu1_dro1_dwó1_d4z8_dzi1_d4ź8_d4ż8_ego1_gru1_i2n3_izo1_kro1_kró1_na2j_o2b2_o2d2_ob3r_oa3z_obu1_oda1_odu1_ogó1_oka1_okr2_ole1_osi1_pła1_poe2_pra1_pre1_r4z8_ską1_skl8_skr8_spo1_spó1_ste1_s4z8_sze1_ś1c8_śró1_świ1_toa3_tra1_tró1_u3b2_u3c2_u3d2_u3f2_u3g2_u3h2_u3k2_u3l2_u3ł2_u3m2_u3n2_u3p2_u3r2_u3s2_u3t2_u3w2_u3z2_u3ź2_u3ż2_ube1_ubr2_ukr2_upo1_uro1_utr2_uze1_wni1_ws4z_wyo2_wye2_wyi2_zao2_zai2_zde1_zdy1_zło1_zma1_zni1_zro12cz1b2cz1g2cz1l2cz1m2cz1n2cz1ń2cz1ź2cz1żd2ł1s2dz1b2dz1g2dz1l2dz1m2dz1n2dz1ń2dz1ź2dz1ż2dź1ń2rz1b2rz1g2rz1h2rz1j2rz1l2rz1ł2rz1m2rz1n2rz1ń2rz1r2rz1w2rz1ź2rz1żs2t1s2sz1l2sz1m2sz1n2sz1wwcza18b8b_8b8c_8b8ć_8b8d_8b8f_8b8g_8b8h_8b8j_8b8k_8b8l_8b8ł_8b8m_8b8n_8b8ń_8b8p_8b8r_8b8s_8b8ś_8b8t_8b8v_8b8w_8b8x_8b8z_8b8ź_8b8ż_8c8b_8c8c_8c8ć_8c8d_8c8f_8c8g_8c8h_c2h2łc2h2rchr4zc2h2w8c8j_8c8k_8c8l_8c8ł_8c8m_8c8n_8c8ń_8c8p_8c8r_8c8s_8c8ś_8c8t_8c8v_8c8w_8c8x_8c8z_8c8ź_8c8ż_8ć8b_8ć8c_8ć8ć_8ć8d_8ć8f_8ć8g_8ć8h_8ć8j_8ć8k_8ć8l_8ć8ł_8ć8m_8ć8n_8ć8ń_8ć8p_8ć8r_8ć8s_8ć8ś_8ć8t_8ć8v_8ć8w_8ć8x_8ć8z_8ć8ź_8ć8ż_8d8b_8d8c_8d8ć_8d8d_8d8f_8d8g_8d8h_8d8j_8d8k_8d8l_8d8ł_8d8m_8d8n_8d8ń_8d8p_8d8r_8d8s_8d8ś_8d8t_8d8v_8d8w_8d8x_8d8z_8d8ź_8d8ż_8f8b_8f8c_8f8ć_8f8d_8f8f_8f8g_8f8h_8f8j_8f8k_8f8l_8f8ł_8f8m_8f8n_8f8ń_8f8p_8f8r_8f8s_8f8ś_8f8t_8f8v_8f8w_8f8x_8f8z_8f8ź_8f8ż_8g8b_8g8c_8g8ć_8g8d_8g8f_8g8g_8g8h_8g8j_8g8k_8g8l_8g8ł_8g8m_8g8n_8g8ń_8g8p_8g8r_8g8s_8g8ś_8g8t_8g8v_8g8w_8g8x_8g8z_8g8ź_8g8ż_8h8b_8h8c_8h8ć_8h8d_8h8f_8h8g_8h8h_8h8j_8h8k_8h8l_8h8ł_8h8m_8h8n_8h8ń_8h8p_8h8r_8h8s_8h8ś_8h8t_8h8v_8h8w_8h8x_8h8z_8h8ź_8h8ż_8j8b_8j8c_8j8ć_8j8d_8j8f_8j8g_8j8h_8j8j_8j8k_8j8l_8j8ł_8j8m_8j8n_8j8ń_8j8p_8j8r_8j8s_8j8ś_8j8t_8j8v_8j8w_8j8x_8j8z_8j8ź_8j8ż_8k8b_8k8c_8k8ć_8k8d_8k8f_8k8g_8k8h_8k8j_8k8k_8k8l_8k8ł_8k8m_8k8n_8k8ń_8k8p_8k8r_8k8s_8k8ś_8k8t_8k8v_8k8w_8k8x_8k8z_8k8ź_8k8ż_8l8b_8l8c_8l8ć_8l8d_8l8f_8l8g_8l8h_8l8j_8l8k_8l8l_8l8ł_8l8m_8l8n_8l8ń_8l8p_8l8r_8l8s_8l8ś_8l8t_8l8v_8l8w_8l8x_8l8z_8l8ź_8l8ż_8ł8b_8ł8c_8ł8ć_8ł8d_8ł8f_8ł8g_8ł8h_8ł8j_8ł8k_8ł8l_8ł8ł_8ł8m_8ł8n_8ł8ń_8ł8p_8ł8r_8ł8s_8ł8ś_8ł8t_8ł8v_8ł8w_8ł8x_8ł8z_8ł8ź_8ł8ż_8m8b_8m8c_8m8ć_8m8d_8m8f_8m8g_8m8h_8m8j_8m8k_8m8l_8m8ł_8m8m_8m8n_8m8ń_8m8p_8m8r_8m8s_8m8ś_8m8t_8m8v_8m8w_8m8x_8m8z_8m8ź_8m8ż_8n8b_8n8c_8n8ć_8n8d_8n8f_8n8g_8n8h_8n8j_8n8k_8n8l_8n8ł_8n8m_8n8n_8n8ń_8n8p_8n8r_8n8s_8n8ś_8n8t_8n8v_8n8w_8n8x_8n8z_8n8ź_8n8ż_8ń8b_8ń8c_8ń8ć_8ń8d_8ń8f_8ń8g_8ń8h_8ń8j_8ń8k_8ń8l_8ń8ł_8ń8m_8ń8n_8ń8ń_8ń8p_8ń8r_8ń8s_8ń8ś_8ń8t_8ń8v_8ń8w_8ń8x_8ń8z_8ń8ź_8ń8ż_8p8b_8p8c_8p8ć_8p8d_8p8f_8p8g_8p8h_8p8j_8p8k_8p8l_8p8ł_8p8m_8p8n_8p8ń_8p8p_8p8r_8p8s_8p8ś_8p8t_8p8v_8p8w_8p8x_8p8z_8p8ź_8p8ż_8r8b_8r8c_8r8ć_8r8d_8r8f_8r8g_8r8h_8r8j_8r8k_8r8l_8r8ł_8r8m_8r8n_8r8ń_8r8p_8r8r_8r8s_8r8ś_8r8t_8r8v_8r8w_8r8x_8r8z_8r8ź_8r8ż_8s8b_8s8c_8s8ć_8s8d_8s8f_8s8g_8s8h_8s8j_8s8k_skr4z8s8l_8s8ł_8s8m_8s8n_8s8ń_8s8p_8s8r_8s8s_8s8ś_8s8t_str4z8s8v_8s8w_8s8x_8s8z_szc4z8s8ź_8s8ż_8ś8b_8ś8c_8ś8ć_8ś8d_8ś8f_8ś8g_8ś8h_8ś8j_8ś8k_8ś8l_8ś8ł_8ś8m_8ś8n_8ś8ń_8ś8p_8ś8r_8ś8s_8ś8ś_8ś8t_8ś8v_8ś8w_8ś8x_8ś8z_8ś8ź_8ś8ż_8t8b_8t8c_8t8ć_8t8d_8t8f_8t8g_8t8h_8t8j_8t8k_8t8l_8t8ł_8t8m_8t8n_8t8ń_8t8p_8t8r_8t8s_8t8ś_8t8t_8t8v_8t8w_8t8x_8t8z_8t8ź_8t8ż_8v8b_8v8c_8v8ć_8v8d_8v8f_8v8g_8v8h_8v8j_8v8k_8v8l_8v8ł_8v8m_8v8n_8v8ń_8v8p_8v8r_8v8s_8v8ś_8v8t_8v8v_8v8w_8v8x_8v8z_8v8ź_8v8ż_8w8b_8w8c_8w8ć_8w8d_8w8f_8w8g_8w8h_8w8j_8w8k_8w8l_8w8ł_8w8m_8w8n_8w8ń_8w8p_8w8r_8w8s_8w8ś_8w8t_8w8v_8w8w_8w8x_8w8z_8w8ź_8w8ż_8x8b_8x8c_8x8ć_8x8d_8x8f_8x8g_8x8h_8x8j_8x8k_8x8l_8x8ł_8x8m_8x8n_8x8ń_8x8p_8x8r_8x8s_8x8ś_8x8t_8x8v_8x8w_8x8x_8x8z_8x8ź_8x8ż_8z8b_8z8c_8z8ć_8z8d_zdr4z8z8f_8z8g_8z8h_8z8j_8z8k_8z8l_8z8ł_8z8m_8z8n_8z8ń_8z8p_8z8r_8z8s_8z8ś_8z8t_8z8v_8z8w_8z8x_8z8z_8z8ź_8z8ż_8ź8b_8ź8c_8ź8ć_8ź8d_8ź8f_8ź8g_8ź8h_8ź8j_8ź8k_8ź8l_8ź8ł_8ź8m_8ź8n_8ź8ń_8ź8p_8ź8r_8ź8s_8ź8ś_8ź8t_8ź8v_8ź8w_8ź8x_8ź8z_8ź8ź_8ź8ż_8ż8b_8ż8c_8ż8ć_8ż8d_8ż8f_8ż8g_8ż8h_8ż8j_8ż8k_8ż8l_8ż8ł_8ż8m_8ż8n_8ż8ń_8ż8p_8ż8r_8ż8s_8ż8ś_8ż8t_8ż8v_8ż8w_8ż8x_8ż8z_8ż8ź_8ż8ż_be1e2bino1bis4zb2r2dbroa2bus4zbusi1c2h2jc2h2lcur4zde2u1dus4zd2ż2jd2ż2ld2ż2łd2ż2rd2ż2werza1fis4zfor4zgado1his4zhuc4zi4n3ni2n1sj2t1łj2t1rled1wly2o2mar4zmis4zmi2e1moza1mur4zo4f3fó2w1cpoli1połu1p2r1cprc4hs2m2rsowi1syno1szto1to2y1tygo1we1e2ź2d4ź_gd4z_ina1");
            put(6, "_a2b1s_ad4e1_ad4i1_ad4o1_ad4u1_ad4y1_ad5op_ad5or_a2n1t_anty1_a2r1c_arcy1_au3g2_au3k2_au3t2_auto1_4b3b8_2b1c8_2b1ć8_2b1d8_be2z3_beza1_bezi1_bezm2_bezo2_bezw2_2b1f8_2b1g8_2b1k8_2b1m8_2b1n8_2b1ń8_2b1p8_br4z8_2b1s8_2b1ś8_2b1t8_2b1z8_2b1ź8_2b1ż8_cało1_2c1b8_4c3c8_2c1ć8_2c1d8_2c1f8_2c1g8_c2h2r_ci2e1_2c1k8_2c1l8_2c1m8_2c1n8_2c1ń8_2c1p8_2c1s8_2c1ś8_2c1t8_czte1_czwó1_2c1ź8_2c1ż8_2ć1b8_2ć1c8_4ć3ć8_2ć1d8_2ć1f8_2ć1g8_2ć1k8_2ć1m8_2ć1n8_2ć1ń8_2ć1p8_2ć1s8_2ć1ś8_2ć1t8_2ć1z8_2ć1ź8_2ć1ż8_dale1_2d1b8_2d1c8_2d1ć8_4d3d8_de2z3_deza2_dezo2_2d1f8_2d1g8_2d1k8_2d1m8_2d1n8_2d1ń8_do3b2_do3c2_do3ć2_do3d2_do3f2_do3g2_do3h2_do3k2_do3l2_do3ł2_do3m2_do3p2_do3r2_do3s2_do3ś2_do3t2_do3w2_do3z2_do3ź2_do3ż2_dobr2_dosm2_dotr2_2d1p8_dr4z8_2d1s8_2d1ś8_2d1t8_dy2s3_dy2z3_dyzu2_e1me1_e1se1_e2s1t_egoa2_egoi2_egou2_e1le1_2f1c8_4f3f8_2f1k8_2f1m8_2f1n8_2g1b8_2g1c8_2g1ć8_2g1d8_ge2o3_2g1f8_4g3g8_2g1k8_2g1m8_2g1ń8_go2u3_2g1p8_gr4z8_2g1s8_2g1ś8_2g1t8_2g1z8_2g1ź8_2g1ż8_2h1b8_2h1c8_2h1ć8_2h1d8_2h1f8_2h1g8_4h3h8_hipe1_2h1j8_2h1k8_2h1l8_2h1ł8_2h1m8_2h1n8_2h1ń8_2h1p8_2h1r8_2h1s8_2h1ś8_2h1t8_2h1w8_2h1z8_2h1ź8_2h1ż8_i2s3l_i1ni1_i2n1f_izoa2_izoe2_izou2_2j1b8_2j1c8_2j1ć8_2j1d8_2j1f8_2j1g8_2j1h8_4j3j8_2j1k8_2j1l8_2j1ł8_2j1m8_2j1n8_2j1ń8_2j1p8_2j1r8_2j1s8_2j1ś8_2j1t8_2j1w8_2j1z8_2j1ź8_2j1ż8_2k1b8_2k1c8_2k1ć8_2k1d8_2k1f8_2k1g8_4k3k8_2k1m8_2k1n8_2k1ń8_2k1p8_kr4z8_2k1s8_2k1ś8_2k1t8_2k1z8_2k1ź8_2k1ż8_2l1b8_2l1c8_2l1ć8_2l1d8_2l1f8_2l1g8_2l1h8_2l1j8_2l1k8_4l3l8_2l1ł8_2l1m8_2l1n8_2l1ń8_2l1p8_2l1r8_2l1s8_2l1ś8_2l1t8_ludo1_2l1w8_2l1z8_2l1ź8_2l1ż8_2ł1b8_2ł1c8_2ł1ć8_2ł1d8_2ł1f8_2ł1g8_2ł1h8_2ł1j8_2ł1k8_2ł1l8_4ł3ł8_2ł1m8_2ł1n8_2ł1ń8_2ł1p8_2ł1r8_2ł1s8_2ł1ś8_2ł1t8_2ł1w8_2ł1z8_2ł1ź8_2ł1ż8_2m1b8_2m1c8_2m1ć8_2m1d8_2m1f8_2m1g8_2m1h8_2m1j8_2m1k8_2m1l8_2m1ł8_4m3m8_2m1n8_2m1ń8_2m1p8_2m1r8_2m1s8_2m1ś8_2m1t8_2m1w8_2m1z8_2m1ź8_2m1ż8_na2d2_na3b2_na3c2_na3ć2_na3f2_na3g2_na3h2_na3k2_na3l2_na3ł2_na3m2_na3p2_na3r2_na3s2_na3ś2_na3t2_na3u2_na3w2_na3z2_na3ź2_na3ż2_nakr2_napo1_naro1_nasm2_nazw2_2n1b8_2n1c8_2n1ć8_2n1d8_ne2o3_2n1f8_2n1g8_2n1h8_ni2e1_nieo2_2n1j8_2n1k8_2n1l8_2n1ł8_2n1m8_4n3n8_2n1ń8_2n1p8_2n1r8_2n1s8_2n1ś8_2n1t8_2n1w8_2n1z8_2n1ź8_2n1ż8_2ń1b8_2ń1c8_2ń1ć8_2ń1d8_2ń1f8_2ń1g8_2ń1h8_2ń1j8_2ń1k8_2ń1l8_2ń1ł8_2ń1m8_2ń1n8_2ń1ń8_2ń1p8_2ń1r8_2ń1s8_2ń1ś8_2ń1t8_2ń1w8_2ń1z8_2ń1ź8_2ń1ż8_o2t1c_otc4h_ob3l2_oblu1_ob3ł2_obra1_obry1_o3be1_o3bi1_od3i2_od3r2_odra1_odrę1_odru1_od5z2_odzi1_o3de1_o2l1ś_ob3h2_ob3j2_o1bo1_ob3w2_oc4h2_oc4z2_od3h2_od3j2_od3l2_o1do1_od3w2_od5ż2_odbe1_od4ź2_ogni1_o2p1c_o2r1t_or4z2_os4z2_ośmi1_2p1b8_2p1c8_pc4h8_2p1ć8_2p1d8_pe2r3_pe1e2_2p1f8_2p1g8_pi2e1_pi2ę1_pi2o1_2p1k8_2p1m8_2p1n8_2p1ń8_po2d2_po3b2_po3c2_po3ć2_podi1_po3f2_po3g2_po3h2_po3k2_po3l2_po3ł2_po3m2_po3p2_po3r2_po3s2_po3ś2_po3t2_po3w2_po3z2_po3ź2_po3ż2_podó1_pobr2_pokl2_pokr2_pona1_poni1_posm2_potr2_poza1_pozw2_pó2ł3_półe1_póło2_4p3p8_pr4z8_prze1_przy1_2p1s8_2p1ś8_2p1t8_2p1z8_2p1ź8_2p1ż8_2r1b8_2r1c8_2r1ć8_2r1d8_2r1f8_2r1g8_2r1h8_2r1j8_2r1k8_2r1l8_2r1ł8_2r1m8_2r1n8_2r1ń8_ro2z3_rozi2_rozm2_rozw2_2r1p8_4r3r8_2r1s8_2r1ś8_2r1t8_2r1w8_2r1ź8_2r1ż8_samo1_2s1b8_sc4h8_2s1d8_2s1f8_2s1g8_si2e1_2s1s8_su2b3_subi1_subo1_supe1_2s1ź8_2s1ż8_2ś1b8_2ś1d8_2ś1f8_2ś1g8_2ś1k8_2ś1p8_2ś1s8_2ś1ś8_2ś1t8_2ś1z8_2ś1ź8_2ś1ż8_ta2o3_tar4z_2t1b8_2t1c8_tc4h8_2t1ć8_2t1d8_te2o3_2t1f8_2t1g8_2t1k8_2t1m8_2t1n8_2t1ń8_2t1p8_tr4z8_trze1_2t1s8_2t1ś8_4t3t8_tysi1_2t1z8_2t1ź8_2t1ż8_u4d3k_u4f3n_ukle1_u4l3s_u4l3t_u2m1b_u4n3c_u4n3d_u4p3p_u4r3s_uc4h2_uc4z2_ud4z2_ud4ź2_ud4ż2_u2p1c_ur4z2_us4z2_2w1b8_2w1c8_2w1ć8_2w1d8_we3b2_we3c2_we3ć2_we3d2_we3f2_we3g2_we3h2_we3k2_we3l2_we3ł2_we3m2_we3n2_we3p2_we3r2_we3s2_we3ś2_we3t2_we3w2_we3z2_we3ż2_2w1f8_2w1g8_wi2e1_2w1j8_2w1k8_2w1l8_2w1ł8_2w1m8_2w1n8_2w1ń8_2w1p8_2w1r8_2w1s8_wspó1_wsze1_2w1ś8_2w1t8_4w3w8_wy3b2_wy3c2_wy3ć2_wy3d2_wy3f2_wy3g2_wy3h2_wy3k2_wy3l2_wy3ł2_wy3m2_wy3p2_wy3r2_wy3s2_wy3ś2_wy3t2_wy3w2_wy3z2_wy3ź2_wy3ż2_wybr2_wydr2_wykl2_wykr2_wysm2_wytr2_2w1z8_2w1ź8_2w1ż8_za3b2_za3c2_za3ć2_za3d2_za3f2_za3g2_za3h2_za3k2_za3l2_za3ł2_za3m2_za3p2_za3r2_za3s2_za3ś2_za3t2_za3u2_za3w2_za3z2_za3ź2_za3ż2_zabr2_zado1_zadr2_zady1_zakl2_zakr2_zani1_zasm2_zatr2_2z1c8_2z1ć8_2z1d8_ze3b2_ze3c2_ze3ć2_ze3d2_ze3f2_ze3g2_ze3h2_ze3k2_ze3l2_ze3ł2_ze3m2_ze3p2_ze3r2_ze3s2_ze3ś2_ze3t2_ze3w2_ze3z2_ze3ź2_ze3ż2_zekl2_zesm4_2z1f8_2z1k8_zo2o3_2z1p8_2z1s8_2z1ś8_2z1t8_4z3z8_2ź1b8_2ź1c8_2ź1ć8_2ź1d8_2ź1f8_2ź1g8_2ź1k8_2ź1l8_2ź1m8_2ź1n8_2ź1p8_2ź1s8_2ź1ś8_2ź1t8_2ź1w8_2ź1z8_4ź3ź8_2ź1ż8_2ż1b8_2ż1c8_2ż1ć8_2ż1d8_2ż1f8_2ż1g8_2ż1j8_2ż1k8_2ż1l8_2ż1ł8_2ż1m8_2ż1n8_2ż1ń8_2ż1p8_2ż1r8_2ż1s8_2ż1ś8_2ż1t8_2ż1w8_2ż1z8_2ż1ź8_4ż3ż81ś2ci12b2ł1k2b2r1n2c2h1b2c2h1c2c2h1ć2c2h1d2c2h1f2c2h1g2c2h1k2c2h1m2c2h1n2c2h1ń2c2h1p2c2h1s2c2h1ś2c2h1t2c2h1z2c2h1ź2c2h1ż2c2z1c2c2z1ć2c2z1d2c2z1f2c2z1k2c2z1p2c2z1s2c2z1ś2c2z1t2c4z3z2d2ł1b2dłs4z2d2r1n2d2z1c2d2z1ć2d2z1d2d2z1f2d2z1k2d2z1p2d2z1s2d2z1ś2d2z1t2d4z3z2d2ź1b2d2ź1c2d2ź1ć2d2ź1d2d2ź1f2d2ź1g2d2ź1k2d2ź1m2d2ź1n2d2ź1p2d2ź1s2d2ź1ś2d2ź1t2d2ź1z2d4ź3ź2d2ź1ż2d2ż1b2d2ż1c2d2ż1ć2d2ż1d2d2ż1f2d2ż1g2d2ż1k2d2ż1m2d2ż1n2d2ż1ń2d2ż1p2d2ż1s2d2ż1ś2d2ż1t2d2ż1z2d2ż1ź2d4ż3ż2g2ł1b2k1s4z2k2ł1b2n2t1n2p1s4z2p2l1n2r2z1c2r2z1ć2r2z1d2r2z1f2r2z1k2r2z1p2r2z1s2r2z1ś2r2z1t2s2ł1b2s2n1k2s2t1k2s2t1n2sts4z2s2z1c2s2z1ć2s2z1f2s2z1k2s2z1p2s2z1s2s2z1ś2s2z1t2s4z3z2ś2ć1c2ś2l1m2ś2l1n2t2l1n2t2r1k2z2d1k2z2d1ndni2o13m2k2n3w2ład3w2łosbe2ethbizne1bi2r1mbu2k1sca2l1dchus1tcurzo1d2rz2wfisha1fo2k1sforza1fo2l1kfo2s1ffosfa1ga2d1ggadge1go2l1fhuxle1in2n1sin2s1bja4z3zka2r1lki2r1ckirc4hko2n1glu2k1smier4zmo2n1tmozai2murza1na2ł1knałko1na4r3vochmi1offse1pa1na1po2d1npodni1po2m1npo2r1tpo2w1spows4zprcha1pres4zskor4zsyste1sze4śćto1yo2tu2r1bturbo1vo2l1kze4p3p_byna1_gdzi1_o2w1s_ows4z_póła1");
            put(7, "_a1d4a1_ae3ro1_aeroi2_aerou2_antye2_antyi2_antyo2_antyu2_arcye2_arcyi2_arcyo2_arcyu2_autoe2_autoi2_be1ze1_be2z1c_be4z3z_bezzw2_chr4z8_2c2z1t_ćwi2e1_de1ze1_długo1_do4k3t_do4l3n_do4ł3k_do4m3k_do4r3s_do4w3c_doc4h2_doc4z2_dod4z2_dod4ź2_dod4ż2_do2p1c_dor4z2_dos4z2_dwó2j3_dy3s4z_dzi2e1_e2k2s3_emes4z_e1goe2_ego1o2_eks4y1_grubo1_i3n4ic_i3n4o1_i3n4u1_infla1_ino3w2_i1zoi2_izo1o2_jadło1_ki2l1k_kilku1_ko1ło1_ko2n1t_kro2ć3_mi1li1_mo2ż1n_nad3i2_nad3ł2_nadłu1_nadmu1_nad3r2_nadre1_nadrę1_nadru1_nad3w2_nadwo1_na1da1_na3daj_na3dą1_na3de1_na3dę1_na3do1_na3dy1_nad4z2_na1ja1_na3ją1_na3je1_na3ję1_na4f3c_na4f3t_na4r3c_na4r3d_na4r3k_na4r3r_na4r3t_nac4h2_nac4z2_nad3h2_nad3j2_nad3l2_nad3u2_nad5ż2_nadtr2_naj3i2_naj3o2_najro1_naj3u2_najbe1_najdo1_najkr2_najsm2_najzw2_nar4z2_nas4z2_na2t1c_naz3m2_nie3b2_nie3c2_nie3ć2_nie3d2_nie3f2_nie3g2_nie3h2_nie3k2_nie3l2_nie3ł2_nie3m2_nie3p2_nie3r2_nie3s2_nie3ś2_nie3t2_nie3u2_nie3w2_nie3z2_nie3ź2_nie3ż2_niedo1_nieob2_nieoc2_nieoć2_nieod2_nieof2_nieog2_nieoh2_nieok2_nieol2_nieoł2_nieom2_nieop2_nieor2_nieos2_nieoś2_nieot2_nieow2_nieoz2_nieoź2_nieoż2_niepo1_niero1_niesu1_nietr2_nieuw2_niewy1_niezw2_o1bło1_o1bro1_o1dro1_od2r1w_odr4z2_odrze1_o3l2śn_obrze1_obrzę1_obrzu1_obrzy1_o2b3c2_o2b3ć2_o2b3d2_o2b3f2_o2b3g2_o2b3k2_o2b3m2_o2b3n2_o2b3p2_o2b3s2_o2b3ś2_o2b3t2_o2b3ź2_o2b3ż2_obc4h2_obc4z2_obd4z2_obd4ź2_obd4ż2_obe3b2_obe3c2_obe3ć2_obe3d2_obe3f2_obe3g2_obe3h2_obe3k2_obe3l2_obe3ł2_obe3m2_obe3p2_obe3r2_obe3s2_obe3ś2_obe3t2_obe3w2_obe3z2_obe3ź2_obe3ż2_obi3b2_obs4z2_oc2h2r_o2d3b2_o2d3c2_o2d3ć2_o4d3d2_o2d3f2_o2d3g2_o2d3k2_o2d3m2_o2d3n2_od3o2s_o2d3p2_o2d3s2_o2d3ś2_o2d3t2_odc4h2_odc4z2_odd4z2_odd4ź2_odd4ż2_ode3b2_ode3c2_ode3ć2_ode3d2_ode3f2_ode3g2_ode3h2_ode3k2_ode3l2_ode3ł2_ode3m2_ode3p2_ode3r2_ode3s2_ode3ś2_ode3t2_ode3w2_ode3z2_ode3ź2_ode3ż2_ods4z2_oka3m2_opc4h2_or2tę1_o2r2ż2_osi2e1_pe3c2k_pe2ł1n_pełno1_pe1pe1_pe1ze1_pię2ć3_pod3ł2_podmu1_podna1_pod3r2_podra1_podre1_podrę1_podró1_podru1_podry1_podr4z_pod3w2_podwa1_podwó1_po3da1_po3dą1_po3de1_po3dej_po3dę1_po3do1_po3du1_po3dy1_po3r1ż_poc4z2_podza1_podzi1_po4l3s_po4m3p_po4ń3c_po4r3c_po4r3f_po4r3n_po4r3t_poc4h2_pod3h2_pod3j2_pod3l2_pod5ż2_podsm2_po2p1c_po1po1_po1ro1_por4z2_pos4z2_poz4m2_półkr2_pó2ł1p_pra3s2_predy1_przyo2_retra1_ro1zo2_ro2z1p_roztr2_skąd4ż_so1bo1_spo2d2_spo3b2_spo3c2_spo3ć2_spo3f2_spo3g2_spo3h2_spo3k2_spo3l2_spo3ł2_spo3m2_spo3p2_spo3r2_spo3s2_spo3ś2_spo3t2_spo3w2_spo3z2_spo3ź2_spo3ż2_spó2ł3_sze2s3_sześ1c_śró2d5_śródr2_świ2a1_tró2j3_tróje1_u4m3br_ube2z3_ubezw2_u2m1k2_upc4h2_upo2d2_upo3b2_upo3c2_upo3ć2_upo3f2_upo3g2_upo3h2_upo3k2_upo3l2_upo3ł2_upo3m2_upo3p2_upo3r2_upo3s2_upo3ś2_upo3t2_upo3w2_upo3z2_upo3ź2_upo3ż2_uro2z3_u2r1ż2_usc4h2_u2t1k2_uze3w2_we4k3t_we4l3w_we4ł3n_we4n3d_we4n3t_we4r3b_we4r3d_we4r3n_we4r3s_we4r3t_wec4h2_wec4z2_wed4z2_wed4ź2_wed4ż2_we2p1c_wer4z2_wes4z2_we2w1n_wewną1_wielo1_wielu1_wi2l1c_wilc4z_wni2e1_wo1do1_wyc4z2_wy2ż1s_wyc4h2_wyd4z2_wyd4ź2_wyd4ż2_wy2p1c_wyr4z2_wys4z2_wy2t1c_za4k3t_za4l3g_za4l3k_za4l3t_za4m3k_za2r1c_zac4h2_zac4z2_zad4z2_zad4ź2_zad4ż2_zai2n3_zar4z2_zas4z2_zde2z3_zdeza1_ze4r3k_ze1te1_zetha1_zec4h2_zec4z2_zed4z2_zed4ź2_zed4ż2_ze2p1c_zer4z2_zes4z2_zi2m1n_zimno1_zło3w2_zni2e1_zro2z3_ź2d4ź82sz2l1n2t2rz1n3d2niow3m2nest3m2nezj3w2czas8b8r8z_8c8h8ł_8c8h8w_8c8z8t_8d8r8z_8k8s8t_8m8s8t_8p8r8z_8r8s8z_8r8z8ł_8s8c8h_8s8t8r_8s8t8w_sz2cz1b8s8z8k_8s8z8n_8s8z8t_8t8r8z_8z8d8r_be1khe1biszko1bi1rmi1blokha1bu2sz1mbusine1caldwe1deu2t1sduszpa1dże4z3bdże4z3me2r5zace3u2s4zgol2f3sgra2n1dgrandi1gro4t3rhu2cz1winn2s1binsbru1kar2l1skongre1luftwa1luk2s1fluksfe1mi2sz1mmiszma1montre1o2c2h1mó4w3c4zpaname1pa1sca1por2t1sportla1poli2e1poli2u1powsze1pr2chalroe2n1tro1kro1ro1sto1sowi3z2s4zas4zszezlo1szy2n1k_inac4z_ni2g1d_nigdy1_nigd4z_owsze1_skądi1_trója1");
            put(8, "_a2b2s3t_ad5i2u1_a1eroa2_ae1roe2_aero1o2_a1ntya2_arcy3b2_arcy3k2_arcy3ł2_arcy3m2_a1rcya2_a1utoa2_auto1o2_au1tou2_be3z4an_be3z4ec_be3z4ik_bezc4h2_cało3k2_cało3ś2_cie2n1k_cienko1_ciepło1_cza2r1n_czarno1_2c2z1k8_cztero1_czwó2r3_daleko1_dezabi1_de3z4el_de3z4er_de3z4y1_dobr4z2_dogr4z2_dopc4h2_dopr4z2_do2r1ż2_dosc4h2_do2t1k2_dro1go1_dy3s4e1_dy3s4o1_dy3s4y1_dy3z4e1_e2s1ha1_ele2k1t_hipe2r3_hipera2_i4n5o2k_koło3w2_kontru2_kró2t1k_krótko1_ludo3w2_mili2a1_mo1żno1_na3d4ir_na2d3m2_na3dzi1_na3d4ź2_nadoki1_nadrze1_nabr4z2_na2d3b2_na2d3c2_na2d3ć2_na4d3d2_nade3t2_na2d3f2_na2d3g2_na2d3k2_na2d3n2_na2d3p2_na2d3s2_na2d3ś2_na2d3t2_na2dz1m_nadzmy1_nad5zo1_nad5zó1_nadzwy1_nadc4h2_nadc4z2_nadd4ź2_nade3b2_nade3c2_nade3ć2_nade3d2_nade3f2_nade3g2_nade3h2_nade3k2_nade3l2_nade3ł2_nade3m2_nade3p2_nade3r2_nade3s2_nade3ś2_nade3w2_nade3z2_nade3ź2_nade3ż2_nads4z2_nadśro1_nagr4z2_na2j3b2_na2j3c2_na2j3ć2_na2j3d2_na2j3f2_na2j3g2_na2j3h2_na2j3k2_na2j3l2_na2j3ł2_na2j3m2_na2j3p2_na2j3r2_na2j3s2_na2j3ś2_na2j3t2_na2j3w2_na2j3z2_na2j3ź2_na2j3ż2_najc4h2_najc4z2_najd4z2_najd4ź2_najd4ż2_najr4z2_najs4z2_napo2d2_napo3b2_napo3c2_napo3ć2_napo3f2_napo3g2_napo3h2_napo3k2_napo3l2_napo3ł2_napo3m2_napo3p2_napo3r2_napo3s2_napo3ś2_napo3t2_napo3w2_napo3z2_napo3ź2_napo3ż2_napr4z2_naro2z3_na2r1ż2_natc4h2_na2t1k2_nie4c3c_nie4c3k_nie4m3c_nie4m3k_niec4h2_niec4z2_nied4z2_nied4ż2_nieodw2_niepr4z_nier4z2_nies4z2_o3b4łą1_o3b4łę1_o3b4łoc_o3b4rać_o3b4ron_o3b4roń_o3b4ryz_o3b4ryź_o3d4rap_o3d4ręt_odrobi1_o3d4rut_ob3u2m2_obe3r3t_obe4c3n_obe4z3w_obec4h2_obec4z2_obed4z2_obed4ź2_obed4ż2_obe2r3m_ober4z2_obes4z2_ochr4z2_od3a2u1_od3u2m2_odbe2z3_odec4h2_odec4z2_oded4z2_oded4ź2_oded4ż2_ode2p1c_oder4z2_odes4z2_ode2t1c_odkr4z2_ogó2l1n_o1le2o3_osie2m3_pe3r4e1_pe3r4i1_pe3r4o1_pe3r4u1_pe3r4y1_pepee2r_pepee2s_pie2r1w_pierwo1_pi1ęci1_pię2ć1s_pięćse1_pio1no1_płasko1_po2d3m2_po2d3n2_pod2r1w_po1dro1_po1dwo1_po3d4z2_po3d4ź2_pode3k2_podobi1_podobó1_podoc4h_podoki1_podopi1_podory1_podosi1_po4d3ów_podura1_podus4z_po2dz1b_po4st3h_po4st3l_pobr4z2_poc2h2r_po2d3b2_po2d3c2_po2d3ć2_po4d3d2_po2d3f2_po2d3g2_pod3i2n_po2d3k2_po2d3p2_po2d3s2_po2d3ś2_podśró1_po2d3t2_podc4h2_podc4z2_podd4ź2_podd4ż2_pode3b2_pode3c2_pode3ć2_pode3d2_pode3f2_pode3g2_pode3h2_pode3l2_pode3ł2_pode3m2_pode3p2_pode3r2_pode3s2_pode3ś2_pode3t2_pode3w2_pode3z2_pode3ź2_pode3ż2_pods4z2_pogr4z2_po2ł1k2_pom4p1k_po2m1k2_pona2d2_pona3b2_pona3c2_pona3ć2_pona3f2_pona3g2_pona3h2_pona3k2_pona3l2_pona3ł2_pona3m2_pona3p2_pona3r2_pona3s2_pona3ś2_pona3t2_pona3w2_pona3z2_pona3ź2_pona3ż2_ponasm2_ponazw2_poni2e1_popc4h2_popo3w2_popr4z2_por4t1w_por4t1f_por4t1m_poro2z3_posc4h2_po2t1k2_poza3u2_pó3ł4ą1_pó3ł4ę1_pó3ł4y1_pó2ł1k2_pó2ł1m2_półob3r_półpr4z_pra2w1n_pra3w2z_prze2d2_prze3b2_prze3c2_prze3ć2_prze1e2_prze3f2_prze3g2_prze3h2_prze3k2_prze3l2_prze3ł2_prze3m2_prze3n2_prze3p2_prze3r2_prze3s2_prze3ś2_prze3t2_prze3u2_prze3w2_prze3z2_prze3ź2_prze3ż2_przebr2_przeci1_przeda1_przekl2_przekr2_przesm2_przetr2_przy3b2_przy3c2_przy3ć2_przy3d2_przy3f2_przy3g2_przy3h2_przy3k2_przy3l2_przy3ł2_przy3m2_przy3p2_przy3r2_przy3s2_przy3ś2_przy3t2_przy3w2_przy3z2_przy3ź2_przy3ż2_przybr2_przyoz2_ro3z4a1_ro3z4e1_ro3z4ej_ro3z4u1_rozani1_ro2z1d2_ro1zpo1_ro2z1ś2_ro2z1t2_samo3k2_samo3p2_samo3w2_sie1de1_sie2d1m_sobo3w2_spo4r3n_spo4r3t_spoc4h2_spoc4z2_spo4d3d_spod4ź2_spod4ż2_spor4z2_spos4z2_ste1re1_supe2r3_supera1_superi1_super4z_supero1_ta1rza1_transi1_transo2_tysi2ą1_u4k3lej_u4p3p2s_u4s2t3n_u4s2t1c_u4s2t1k_u4z3be1_upo3da1_upoc4h2_upoc4z2_upo4d3d_upod4ź2_upod4ż2_upor4z2_upos4z2_wes2t1c_we4z3br_we4z3gł_we2m1k2_wepc4h2_we2t1k2_wilczo1_wniebo1_wodo3w2_wspó2ł3_współi2_współo1_współu2_wybr4z2_wygr4z2_wyi2zo1_wykr4z2_wy2m1k2_wypc4h2_wypr4z2_wy2r1ż2_wysc4h2_wytc4h2_wy2t1k2_za4uto1_zabr4z2_zagr4z2_zai2zo1_zai1ni1_zain4ic_zakr4z2_zani2e1_za2r1ż2_zasc4h2_za2t1k2_zde1ze1_zdysko1_ze3t1k2_zepc4h2_ze2r1ż2_zesc4h2_zma2r1t_znie3b2_znie3c2_znie3ć2_znie3d2_znie3f2_znie3g2_znie3h2_znie3k2_znie3l2_znie3ł2_znie3m2_znie3n2_znie3ń2_znie3p2_znie3r2_znie3s2_znie3ś2_znie3t2_znie3w2_znie3z2_znie3ź2_znie3ż23k2s2z2t3m2s2k2n3p2ne2u18ch8r8z_8sk8r8z_8sz8c8z_8sz8t8r_bi2s2z1kbi2z3nesbo2s3ma1bu2k1s4zbukszpa1cu2r7zondeutsc4hdu2s2z1pfi1szbi1fo2k2s3tfo2r5zacfo1lklo1ga3d2getgado2p1tgolfs4z2hi2s2z3pinnsbru1in4sbrucja4z4z3bja4z4z3mkarlsru1kirc4h3hkirchho1ma2r5z1lma2r5z1łma2r5z1nmontrea2moza2i3kmurzasi1of2f3setpa2s3calpa2s3c4hpodni2e1po3m2ną1po3m2nę1po3m2ni1poli3e2tpołu2d1nroen2t1gse2t3le1sko1rzo1sy2s1temszynkwa1to3y2o3tturbo1o2tygo2d1nwe1e1ke1we4s2t3fwe4s2t3m_bezac4h_bezami1_gdzi2e1_inacze1_półac4h_półami1_przyna1");
            put(9, "_ad5a2p1t_bezo2b1j_czte1re1_długo3w2_do5m4k2n_drogo3w2_dwó3j4a1_dwó3j4ą1_dwó3j4e1_dwó3j4ę1_dwó3j4o1_dy3s4ta1_dzi1esi1_dzi1ewi1_elektro1_grubo3w2_hipe1re2_in4f3lan_jadło3w2_kilkuse1_kon2t2r3_ko1ntro2_możno3w2_na3d4łub_na3d4r2w_na3d4ruk_na3d4r4z_nado1bo1_nado2l1b_nadzi2e1_na4j3e2f_na4j3e2g_na4j3e2n_na4j3e2r_na4j3e2s_na4j3e2w_na1deta1_nade4p3c_nade4p3n_nade4p3t_nadec4h2_nadec4z2_naded4z2_naded4ź2_naded4ż2_nader4z2_nades4z2_naj3a2u1_naj3o2b2_naj3o2c2_naj3o2ć2_naj3o2d2_naj3o2f2_naj3o2g2_naj3o2h2_naj3o2k2_naj3o2l2_naj3o2ł2_naj3o2m2_naj3o2p2_naj3o2r2_naj3o2s2_naj3o2ś2_naj3o2t2_naj3o2w2_naj3o2z2_naj3o2ź2_naj3o2ż2_najbe2z3_najbezw2_najdo3b2_najdo3c2_najdo3ć2_najdo3d2_najdo3f2_najdo3g2_najdo3h2_najdo3k2_najdo3l2_najdo3ł2_najdo3m2_najdo3p2_najdo3r2_najdo3s2_najdo3ś2_najdo3t2_najdo3w2_najdo3z2_najdo3ź2_najdo3ż2_najob3h2_najob3j2_najob3l2_najob3ł2_najob3w2_najoc4h2_najoc4z2_najod3h2_najod3j2_najod3l2_najod3w2_najod5ż2_najod4z2_najod4ź2_najor4z2_najos4z2_naj2t1k2_naj2t1r2_najuc4z2_napo4m3p_napoc4h2_napoc4z2_napo4d3d_napod4ź2_napod4ż2_napor4z2_napos4z2_nie4d4ź3_niedo3b2_niedo3c2_niedo3ć2_niedo3d2_niedo3f2_niedo3g2_niedo3h2_niedo3k2_niedo3l2_niedo3ł2_niedo3m2_niedo3p2_niedo3r2_niedo3s2_niedo3ś2_niedo3t2_niedo3w2_niedo3z2_niedo3ź2_niedo3ż2_niedokr2_nieob3h2_nieob3j2_nieob3w2_nieoc4h2_nieoc4z2_nieod3h2_nieod3j2_nieod3l2_nieod3ł2_nieod5ż2_nieod4z2_nieod4ź2_nieor4z2_nieos4z2_niepo2d2_niepo3b2_niepo3c2_niepo3ć2_niepo3f2_niepo3g2_niepo3h2_niepo3k2_niepo3l2_niepo3ł2_niepo3m2_niepo3p2_niepo3r2_niepo3s2_niepo3ś2_niepo3t2_niepo3w2_niepo3z2_niepo3ź2_niepo3ż2_niepod5ż_nieposm2_niero2z3_nierozm2_niesu2b3_nie2t1k2_nieuc4z2_niewy3b2_niewy3c2_niewy3ć2_niewy3d2_niewy3f2_niewy3g2_niewy3h2_niewy3k2_niewy3l2_niewy3ł2_niewy3m2_niewy3p2_niewy3r2_niewy3s2_niewy3ś2_niewy3t2_niewy3w2_niewy3z2_niewy3ź2_niewy3ż2_niewytr2_o3b4luzg_o3b4r4z2_o3d4i2u1_o3d4rwi1_o3d4rzeć_o3d4rz2w_o4b5rzą1_o4b5rzez_o4b5rzęd_o4b5rzuc_o4b5rzut_o4b5rzyn_o4d7ziar_o4d7ziem_obe2r1ż2_obesc4h2_obe2t1k2_od3u2c4z_ode3m1k2_odepc4h2_ode2r1ż2_odetc4h2_ode2t1k2_o1gni2o1_o1gólno1_osie2m1s_o1śmi2o1_ośmio3ś2_pe4r5i2n_pe1e1se1_pee2se2l_pe1pe1e2_peze2t1p_pięci2o1_piono3w2_po3d4łu1_po3d4naw_po3d4rap_po3d4raż_po3d4roż_po3d4róż_po3d4ryg_po3d4waj_po3d4woj_po3d4wór_po3di2u1_po4c2z3d_po4c2z3t_podobra1_po4d3o2f_po4d3o2g_podokre1_podokrę1_podo2b1s_podo2l1b_po4d5zam_po4d5ze1_podzi2e1_po4s2t3d_po4s2t3f_po4s2t3g_po4st3i2_po4s2t3k_po4s2t3m_po4s2t3p_po1stro1_po4s2t3s_po5r4tę1_pochr4z2_podec4h2_podec4z2_poded4z2_poded4ź2_poded4ż2_pode2p1c_poder4z2_podes4z2_podro2z3_pona4f3t_ponac4h2_pona4d3d_ponad3h2_ponad3j2_ponad3l2_ponad4z2_ponar4z2_ponas4z2_ponaz3m2_ponie3k2_ponie3w2_póło2m2d_półprzy1_pra1pra1_przed3ł2_przedłu1_przedmu1_przed3o2_przed3r2_przedra1_przedru1_przedry1_przed3u2_prze3dą1_prze3dę1_prze3dy1_przedzi1_przec4h2_przec4z2_prze1de1_przed3h2_przed3i2_przed3j2_przed3l2_przedsi1_przed3w2_prze2p1c_przes4z2_przetra1_przyc4h2_przyc4z2_przyd4z2_przyd4ź2_przyd4ż2_przy2p1c_przys4z2_rozbr4z2_rozec4h2_rozec4z2_rozed4z2_rozed4ź2_rozed4ż2_roze2p1c_rozer4z2_rozes4z2_rozpo3w2_samo1ro1_siede2m3_si1edmi1_spo3d4z2_stere2o3_stereoa2_stereoi2_stereou2_supe1re2_sze4ś2ć3_sześ2ć1s_światło1_ta2r7zan_tra2n2s3_tran3s4z_tra1nsa2_tró3j4ą1_tró3j4ę1_tysią2c3_wielo3d2_wielo3k2_wielo3ś2_wszecho2_wy3o2d3r_wy4ż3s4z_wye2k2s3_za3o2b3r_za3o2b3s_za4r3c4h_za5m4k2n_zado2ść3_zadośću4_zanie3d2_zde3z4el_zde3z4er_zde3z4y1_zdyskre1_zdyskwa1_ze4t3hap_zmartwy1_znie4m3c_zniec4h2_zniec4z2_znied4z2_znied4ż2_znier4z2_znies4z2_zro3z4u18s8t8r8z_8szc8z8b_8z8d8r8z_be2f3s4z2bi2sz3kopbirmi2n1gblokha2u1broa1dwa1bu2sz3me1buk2s2z1pfi2sz3binfol2k1lorfo1sfazo1karlskro1lu2ks1fermie2r5z1łpo1rtsmo1portsmou2pre2s2z1proe1ntge1skorzone1szto1kho1vo2l2k2s3_byna2j1m_n8i9gdy__ni1gdzi1_niechby1_trójac4h_trójami1_podó2w1c");
            put(10, "_arcy3b1z2_auto3c4h2_a1utotra1_cienko3w2_czarno3k2_cztero3ś2_czwó3r4a1_czwó3r4ą1_czwó3r4e1_czwó3r4ę1_czwó3r4o1_ćwie2r2ć3_daleko3w2_długo3tr2_dziesi2ę1_dziewi2ę1_e1me1sze1_elektroa2_elektroi2_elektrou2_hipe3r4o1_kon3tr4a1_kon3tr4e1_kon3tr4y1_krótko3w2_nadre2p1c_na3ja2z1d_nado1bro1_nadoki2e1_na4d5rzą1_na4d5rzę1_na4d5rzy1_na4d5ziem_na4j3e2u1_nad3e2tat_nad5z2mys_nade2r1ż2_nadśrod4z_naj3a2k1t_naj3ro2z3_najdoc4h2_najdoc4z2_najdod4z2_najdod4ź2_najdod4ż2_najdor4z2_najdos4z2_najo2b3c2_najo2b3ć2_najo2b3d2_najo2b3f2_najo2b3g2_najo2b3k2_najo2b3m2_najo2b3n2_najo2b3p2_najo2b3s2_najo2b3ś2_najo2b3t2_najo2b3ź2_najo2b3ż2_najobc4h2_najobc4z2_najobd4z2_najobd4ź2_najobd4ż2_najobr4z2_najobs4z2_najo2d3c2_najo2d3ć2_najo4d3d2_najo2d3f2_najo2d3g2_najo2d3k2_najo2d3m2_najo2d3n2_najo2d3p2_najo2d3s2_najo2d3ś2_najo2d3t2_najodc4h2_najodc4z2_najodd4z2_najodd4ź2_najodd4ż2_najods4z2_napo2m1k2_niedoc4h2_niedoc4z2_niedod4z2_niedod4ź2_niedod4ż2_niedo2p1c_niedor4z2_niedos4z2_nieo2b3c2_nieo2b3ć2_nieo2b3d2_nieo2b3f2_nieo2b3g2_nieo2b3k2_nieo2b3m2_nieo2b3p2_nieo2b3s2_nieo2b3ś2_nieo2b3ź2_nieo2b3ż2_nieobc4h2_nieobc4z2_nieobd4z2_nieobd4ź2_nieobd4ż2_nieobs4z2_nieo2d3c2_nieo2d3ć2_nieo4d3d2_nieo2d3f2_nieo2d3g2_nieo2d3k2_nieo2d3n2_nieo2d3p2_nieo2d3s2_nieo2d3ś2_nieo2d3t2_nieod3w1r_nieodc4h2_nieodc4z2_nieodd4z2_nieodd4ź2_nieodd4ż2_nieods4z2_niepod3ł2_niepodmu1_niepod3r2_niepodra1_niepodrę1_niepod3w2_niepodwa1_niepo3do1_niepo3du1_niepoc4h2_niepoc4z2_niepod3h2_niepod3j2_niepod3l2_niepodsm2_niepor4z2_niepos4z2_nie1prze1_niero2z1t_nieroztr2_ni1esubi1_niewyc4h2_niewyc4z2_niewyd4z2_niewyd4ź2_niewyd4ż2_niewyr4z2_niewys4z2_o2t3c2h2ł_o3b4raso1_o3d4robin_o3d6zi2a1_o3d6zi2e1_o4b5łoc4z_o1d3i2zo1_ognio3tr2_ogólno3k2_osie1mse1_pełno3kr2_pierwo3w2_pięcio3ś2_pięćse2t3_płasko3w2_podre2p1c_po3d4rętw_po3d4ruzg_po3d4rze1_po3d4woi2_po3e2k2s3_podobi2a1_po1do1bo1_podoki2e1_podopi2e1_po4d5zakr_po4d5zast_po4d5zbi1_po4d5ziem_po1dzi2o1_po4d5ziom_po4st3rom_pod3a2l1p_pode3t1k2_podepc4h2_pode2r1ż2_podesc4h2_pona3c4z2_po1na3do1_pona3d4ź2_ponabr4z2_pona2d3c2_pona2d3ć2_pona2d3f2_pona2d3g2_pona2d3k2_pona2d3p2_pona2d3s2_pona2d3ś2_pona2d3t2_poro3z4u1_pó3ł4ec4z_pra3w2nu1_prze2d3m2_prze3d4um_prze3d4z2_prze3d4ź2_prze4d5zj_przedzwo1_prze4d5ż2_przec2h2r_przeci2w3_przeciwa2_przedago1_prze2d3b2_prze2d3c2_prze2d3ć2_prze4d3d2_prze2d3f2_prze2d3g2_prze2d3k2_prze2d3n2_prze2d3p2_prze2d3s2_prze2d3ś2_prze2d3t2_przedc4h2_przedc4z2_przedd4z2_przedd4ź2_przedd4ż2_prze2ł1k2_prze2m1k2_przepc4h2_pr4zer4z2_prze2r1ż2_przesc4h2_prze2t1k2_przy2m1k2_przypc4h2_pr4zyr4z2_przy2r1ż2_przysc4h2_przy2t1k2_ro3z4e3b2_ro3z4e3c2_ro3z4e3ć2_ro3z4e3d2_ro3z4e3f2_ro3z4e3g2_ro3z4e3h2_ro3z4e3k2_ro3z4e3l2_ro3z4e3ł2_ro3z4e3m2_ro3z4e3p2_ro3z4e3r2_ro3z4e3s2_ro3z4e3ś2_ro3z4e3t2_ro3z4e3w2_ro3z4e3z2_ro3z4e3ź2_ro3z4e3ż2_rozepc4h2_roze2r1ż2_rozesc4h2_samo3c4h2_samoro2z3_siede2m1s_siedmi2o1_ską2d5że1_stereo1o2_su3b4i2e1_supe3r4at_sze1ś2ci1_sześci2o1_sze1śćse1_tran3s4e1_tran3s4y1_trze2c4h3_tysią3c4z_we4s3pr4z_wie1luse1_wilczo3m2_wniebo3w2_wspó2ł1w2_wsze2c4h3_wy4cz3ha1_ze1te1me1_ze1te1se1_zimno3kr2_znie4d4ź3bi2n3o2ku1birmingha1blo2k1hauzbuk2sz3panbusine2s2sdeutsc2h2ldeutschla1du2sz3pasthu2x3le2y1kongre2s3mluftwa4f3fmi1e2r5zi1mon2t3realmurzasic4hpa2n3a2merpoli3u2re1połu3d2ni1powsze2d1npre2sz3pa1ro2k3roc4zsy2n3o2p1tsza2sz1ły1szyn2k1wasturboodr4ztygo3d2ni1_bynaj2m1n_bynajmni1_be9z8ami__gdzi1eni1_n8a9da8l__nigdzi2e1_nie2c2h1ż_nie1chże1_nie2c2h1b_ow9sze8m__pó9ł8ami__pó9ł8e8k__ską1diną1_podówcza1");
            put(11, "_ciepło3kr2_de3z4a3bil_de3z4a3wu1_dziewię2ć3_elektro1o2_kilkuse2t3_kilkuseto2_kon3tr4o3l_kon3tr4o3w_krótko3tr2_mili3a2m1p_na3d4muc4h_na3d4ręc4z_na4d3o2b2ł_nadobo2j1c_na4j3e2k2s_na4j3e2ko1_na4j3e2m1f_nad5zwyc4z_nadśrodzi1_najdo2t1k2_najro3z4u1_niedobr4z2_niedo2m1k2_niedopc4h2_niedo2t1k2_niepo2d3m2_nie1podre1_niepo1dwo1_niepo3d4z2_niepo3d4ź2_niepodoc4h_niepo2d3b2_niepo2d3c2_niepo2d3ć2_niepo4d3d2_niepo2d3f2_niepo2d3g2_niepo2d3k2_niepo2d3n2_niepo2d3p2_niepo2d3s2_niepo2d3ś2_niepo2d3t2_niepodc4h2_niepodc4z2_niepodd4ź2_niepodd4ż2_niepods4z2_nieprze2d2_nieprze3b2_nieprze3c2_nieprze3ć2_nieprze3f2_nieprze3g2_nieprze3h2_nieprze3k2_nieprze3l2_nieprze3ł2_nieprze3m2_nieprze3n2_nieprze3p2_nieprze3r2_nieprze3s2_nieprze3ś2_nieprze3t2_nieprze3w2_nieprze3z2_nieprze3ź2_nieprze3ż2_nieprzekl2_nieprzekr2_nieprzesm2_nieprzetr2_niero3z4u1_nieroze3r2_niero2z1ś2_niewybr4z2_niewy2t1k2_ob3o2str4z_osiemse2t3_pe1ze1tpe1_po3d4muc4h_po3d4r2wi1_po3d4ręc4z_po3d4roba1_po3d4robó1_po3d4roby1_po3d4roc4z_po3d4wor4z_podobo2j1c_po4d3o2bóz_po1do1cho1_po4d3o2d1m_po4d3o2k1n_po4d3o2ryw_podosi1ni1_po4d3obs4z_po4d3o4d3d_po4d3u2c4z_po4d3u2d4z_po4d3u2pa1_po4d3u2ral_podu2s2z1c_podzie1le1_po4d5z2w2r_poduszczy1_pod3śró2d5_ponad3c4h2_ponad3c4z2_ponad3d4ź2_prapra2w1n_prze3d4łuż_prze3d4ruk_prze3d4ryl_przedłuży1_przedosta1_prze4d5za1_prze4d5zim_prze4d5z1l_pr4zebr4z2_przeci1wi1_przedsi2ę1_przed3s4z2_pr4zegr4z2_pr4zygr4z2_retra2n2s3_ro4z5a2gi1_ro4z5e2mo1_ro4z5e4g3z_ro4z5e4n3t_siedmio3ś2_ste1re1oe2_su3b4o2t1n_supe2r5z2b_superodr4z_sześcio3ś2_sześćse2t3_światło3w2_tró3j4ec4z_trze2c2h1s_trze1chse1_tysią3c4a1_tysią3c4e1_tysią4c5zł_we4s3tc4h2_wieluse2t3_współo2b3w_wszec2h2w2_zady2s3po1_zde3z4awu1_zdy2s3kred_zdy2s3kwal_ze4t3e2m1pbe2k1he2n1dbi2z3ne2s3mbusine2ss3mfi2s3ha2r1mfos2f1a2zotga1do3p2ta1gran2d1ilo1karl2s1kronna4ł3ko2w1soch3mistr4zro2e3nt2genro2s3to3c2ksko2r5zoner_n8i9gdzie__nie8ch9że__nie8ch9by__przyna2j1m_tró9j8ami__tró9j8e8k__podó4w3c4z");
            put(12, "_cztere2c4h3_dziewię2ć1s_e2s1e2s1ma1_e1le1ktroe2_na3d4repc4z_na3d4re2p1t_na3d4wo2r1n_na4d3o2brot_na4d3o2dr4z_na4d3o2kien_na4d3olbr4z_na4d5rzec4z_niepo3d4łu1_niepo3d4rap_niepo3d4raż_niepo3d4waj_niepo3d4woj_nieprzed3ł2_nieprzedłu1_nieprzedmu1_nieprzed3r2_nieprzedra1_nieprzedru1_nieprzedry1_nieprzed3u2_nieprze3dy1_nie1prze1e2_nieprzec4h2_nieprzec4z2_nieprzed3h2_nieprzed3j2_nieprzed3l2_nieprzed3w2_nieprze2p1c_nieprzes4z2_nie1ro3z4e1_nierozbr4z2_po3d4repc4z_po3d4re2p1t_po3d4ro1bo1_po3d4wó2j1n_po4d3e4k2s3_po4d3o2biad_po4d3o2braz_po4d3o2choc_po4d3o2kien_po4d3o2kres_po4d3o2kręg_podosini2a1_po4d3olbr4z_po4d3u2sta1_półprzy3m2k_predy2s3po1_prze3d4o3br_prze3d4o3st_przedra1ma1_prze3e2k2s3_prze4d5z1g2_prze4d5zwoj_pr4zechr4z2_przeci4w3w2_przed3a2gon_przed3a2k1c_przed3a2l1p_przed3e2g1z_prze1de1me1_przed3e2mer_pr4zedgr4z2_sie1de1mse1_siedemse2t3_supe3r4i2o1_supe4r5a2tr_tran3s4i2e1_tran4s5e2u1_trzechse2t3_wewną2tr4z3birmin2g1hamcal2d1we4l3lin4nsbru2c1kkarl2s1ruhe1kir2chho4f3flu2ft3waffe1mi2s4z1mas4zpo3d4niepr4zpo4rt3la2n1dpowsze3d2ni1sze2z1lo2n1gtu1rboodrzu1we2e2k1e2n1d_bynajmni2e1_be9z8a8c8h__in8a9cze8j__pó9ł8a8c8h__przynaj2m1n_przynajmni1_podó3w2czas");
            put(13, "_autotra2n2s3_cztere2c2h1s_dzi1esi1ęci1_dziesięci2o1_dzi1ewi1ęci1_dziewięci2o1_dzie1więćse1_e2m3e2s5ze2t_kon4tr5a2gi1_kon4tr5a2se1_kon4tr5a2sy1_kon4tr5a2ta1_kon4tr5a2d1m_kon4tr5a2k1c_kon4tr5a2l1t_kon4tr5a2r1g_na4d3o2bowi1_nadśrodzi2e1_nadśrod5ziem_niepodre2p1c_nieprze2d3m2_nieprze3d4um_nieprze3d4z2_nieprze3d4ź2_ni1eprzedzi1_nieprze4d5zj_nieprzedzwo1_nieprze4d5ż2_nieprze2d3c2_nieprze2d3ć2_nieprze4d3d2_nieprze2d3f2_nieprze2d3g2_ni1eprzed3i2_nieprze2d3k2_nieprze2d3n2_nieprze2d3p2_nieprze2d3s2_nieprze2d3ś2_nieprze2d3t2_nieprzedc4h2_nieprzedc4z2_nieprzedd4z2_nieprzedd4ź2_nieprzedd4ż2_nieprze2ł1k2_nieprzepc4h2_niepr4zer4z2_nieprze2r1ż2_nieprzesc4h2_nieprze2t1k2_pe1ze1tpe1e2_peze2t1pee2r_po4d3o2str4z_po4d3u2szc4z_po4d5rę2cz1n_podzi1eleni1_po5d4uszczyn_prapra3w2nu1_prze3d4muc4h_prze3d4o3zo1_prze3d4ramat_pr4ze3d4r4z2_prze4d5łużyc_prze4d5z2w2r_przed3się3w2_przedy2s3ku1_przetra2n2s3_ro4z5a2ni2e1_su1perodrzu1_zdy2s3ko2n1t_ze4t3e2m1e2s_ze4t3e2s1e2l_zmartwy2c4h3bro2a2d3wa2y1szto2k1ho2l1mturboo2d3rzut_gdzi2e1ni2e1_skąd9i8ną8d__tró9j8a8c8h_");
            put(14, "_czte1re1chse1_czterechse2t3_dziesięcio3ś2_dziewięcio3ś2_dziewięćse2t3_na4d3o2bojc4z_niepo3d4muc4h_niepo3d4ręc4z_niepo1do1cho1_nieprze3d4łuż_nieprze3d4ruk_nieprze3d4ryl_nieprzedłuży1_nieprze4d5zim_nieprze4d5z1l_nieprzed3s4z2_niepr4zegr4z2_po4d3o2bojc4z_po4d3o2piec4z_po4d3o2siniak_po4d5zielenic_po4d5zielenić_po4d5zielenil_po4d5zielenił_po4d5zielenim_po4d5zielenis_prze4d5o4stat_supero2d1rzut_zmartwyc2h2w2mu2r7zasic2h3lpo4rt2s3mo2uth_gd4zieniegd4z_przynajmni2e1");
            put(15, "_niepo3d4repc4z_niepo3d4re2p1t_niepo4d3o2choc_niepr4ze3br4z2_nieprzedra1ma1_nieprze3e2k2s3_nieprze4d5z2a1_nieprze4d5z1g2_nieprze4d5zwoj_ni2e1su3b4i2e1_po4d5zielenien_prze1ci3w4i2e1deut4sch3la2n1d_2g1dzienie2g1d");
            put(16, "_niepo4d3o2str4z_nieprze3d4muc4h_nieprze3d4ramat_niepr4ze3d4r4z2_nieprze4d5łużyc_nieprze4d5z2w2r_po4d5zieleni2ą1_po4d5zieleni2ę1_po4d5zieleni2o1_by9naj9m8nie8j__gdzi1eni1egdzi1");
            put(17, "_podzi2e1le1ni2e1_gdzienie9g8dzie__po8d9ó8w9cza8s_");
            put(18, "_przy9naj9m8nie8j_");
            put(20, "_gdzi2e1ni2e1gdzi2e1");
        }
    }), eo("eo", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "a1e1i1o1u1");
            put(3, "4ŭ1a3aa3ea3ia3oa3ue3ae3ee3ie3oe3uen_f1tg1dg1mg1ng1vi3ai3ei3ii3oi3uis_k1vn1mo3ao3eo3io3oo3up1fp1kp1mp1np1sp1tp1ŝs1bs1cs1fs1gs1ks1ps1rs1ts1vu3au3eu3iu3ou3uŝ1mŝ1nŝ1pŝ1tŝ1v");
            put(4, "_bl4_br4_dl4_dr4_fl4_fr4_gl4_gn4_gr4_kl4_kn4_kr4_kv4_pl4_pr4_ps4_pt4_sf4_sk4_sl4_sm4_sn4_sp4_st4_sv4_tr4_vr4_ŝl4_ŝm4_ŝn4_ŝp4_ŝr4_ŝt4_ŝv42aj_2an_2as_2fik2jn_2lp_2lt_2nk_2ns_2nt_2oj_2on_2os_2st_2us_4b1c4b1d4b1f4b1g4b1k4b1m4b1n4b1p4b1s4b1t4b1v4b1z4b1ĉ4b1ĝ4b1ĵ4b1ŝ4c1b4c1d4c1f4c1g4c1k4c1l4c1m4c1n4c1p4c1r4c1s4c1t4c1v4c1z4c1ĉ4c1ĝ4c1ĵ4c1ŝ4d1b4d1c4d1f4d1g4d1k4d1l4d1m4d1n4d1p4d1s4d1t4d1v4d1z4d1ĉ4d1ĝ4d1ĵ4d1ŝ4f1b4f1c4f1d4f1g4f1k4f1m4f1n4f1p4f1s4f1v4f1z4f1ĉ4f1ĝ4f1ĵ4f1ŝ4g1b4g1c4g1f4g1k4g1p4g1s4g1t4g1z4g1ĉ4g1ĝ4g1ĵ4g1ŝ4h1ĉ4h1ĝ4h1ĵ4h1ŝ4j1b4j1c4j1d4j1f4j1g4j1k4j1l4j1m4j1n4j1p4j1r4j1s4j1t4j1v4j1z4j1ĉ4j1ĝ4j1ĵ4j1ŝ4k1b4k1c4k1d4k1f4k1g4k1m4k1n4k1p4k1s4k1t4k1z4k1ĉ4k1ĝ4k1ĵ4k1ŝ4l1b4l1c4l1d4l1f4l1g4l1k4l1m4l1n4l1p4l1r4l1t4l1v4l1z4l1ĉ4l1ĝ4l1ĵ4m1b4m1c4m1d4m1f4m1g4m1k4m1l4m1n4m1p4m1r4m1s4m1t4m1v4m1z4m1ĉ4m1ĝ4m1ĵ4m1ŝ4n1b4n1c4n1d4n1f4n1g4n1j4n1k4n1l4n1n4n1p4n1r4n1s4n1t4n1z4n1ĉ4n1ĝ4n1ĵ4n1ŝ4p1b4p1c4p1d4p1g4p1v4p1z4p1ĉ4p1ĝ4p1ĵ4r1b4r1c4r1d4r1f4r1g4r1k4r1l4r1m4r1n4r1p4r1s4r1t4r1v4r1z4r1ĉ4r1ĝ4r1ĵ4r1ŝ4s1d4s1l4s1m4s1n4s1s4s1z4s1ĉ4s1ĝ4s1ĵ4s1ŝ4t1b4t1c4t1d4t1f4t1g4t1k4t1m4t1n4t1p4t1s4t1t4t1v4t1z4t1ĉ4t1ĝ4t1ĵ4t1ŝ4v1b4v1c4v1d4v1f4v1g4v1k4v1l4v1m4v1n4v1p4v1s4v1t4v1v4v1z4v1ĉ4v1ĝ4v1ĵ4v1ŝ4z1b4z1c4z1d4z1f4z1g4z1k4z1l4z1m4z1n4z1p4z1r4z1s4z1t4z1v4z1ĉ4z1ĝ4z1ĵ4z1ŝ4ĉ1b4ĉ1c4ĉ1d4ĉ1f4ĉ1g4ĉ1k4ĉ1l4ĉ1m4ĉ1n4ĉ1p4ĉ1s4ĉ1t4ĉ1v4ĉ1z4ĉ1ĉ4ĉ1ĝ4ĉ1ĵ4ĉ1ŝ4ĝ1b4ĝ1c4ĝ1d4ĝ1f4ĝ1g4ĝ1k4ĝ1l4ĝ1m4ĝ1n4ĝ1p4ĝ1s4ĝ1t4ĝ1v4ĝ1z4ĝ1ĉ4ĝ1ĝ4ĝ1ĵ4ĝ1ŝ4ĥ1b4ĥ1c4ĥ1d4ĥ1f4ĥ1g4ĥ1k4ĥ1m4ĥ1n4ĥ1p4ĥ1s4ĥ1t4ĥ1v4ĥ1z4ĥ1ĉ4ĥ1ĝ4ĥ1ĵ4ĥ1ŝ4ĵ1b4ĵ1c4ĵ1d4ĵ1f4ĵ1g4ĵ1k4ĵ1l4ĵ1m4ĵ1n4ĵ1p4ĵ1s4ĵ1t4ĵ1v4ĵ1z4ĵ1ĉ4ĵ1ĝ4ĵ1ĵ4ĵ1ŝ4ŝ1b4ŝ1c4ŝ1d4ŝ1f4ŝ1g4ŝ1k4ŝ1s4ŝ1z4ŝ1ĉ4ŝ1ĝ4ŝ1ĵ4ŝ1ŝn2kvp1j2");
            put(5, "_al2t_ba3t_be3j_be3t_bi3d_bi3l_bi3t_bo3t_bu3l_bu3m_ci3t_de3c_di3g_do3t_fi3d_fi3g_fi3l_fo3t_fu3l_fu3m_go3t_gu3m_hu3m_ji3d_jo3t_ju3l_ka3n_ki3l_ko3t_ku3l_le3m_li3d_li3g_li3t_li4a_lo3t_lu3l_lu3m_ma3n_me3t_mi3l_mi3t_mi4a_mo3t_mu3l_ne3t_ni4a_no2v_no3t_nu3l_pa3n_pe3c_pi3g_po2r_po3t_pu3l_pu3m_ra3n_ri3d_ri3g_ri3t_ro3t_ru3l_ru3m_sa2m_sa3n_si3d_si4a_skl4_skr4_skv4_spl4_spr4_str4_su3m_te3m_ti3g_tu3l_va3n_ve3t_vi3d_vi3l_vi3t_vi4a_vo3t_zu3m_ĉi3l_ĉi4a_ĉi4e_ĉi4o_ĉi4u_ĥa3n_ĥe3t_ĵu3l_ŝi4a_ŝo3t_ŝpr4_ŝtr41a2kr1o2be2ajn_2ojn_3nja_3nje_3njo_3ĉ2jo4b1b24b1h44b1j24c1c24c1h44c1j24d1d24d1h44d1j24f1f24f1h44f1j24g1g24g1h44g1j24j1h44k1h44k1j24l1h44l1j24l1l24l1s24l5ŝ24m1h44m1j24m1m24n1h44n1v24p1h44r1h44r1j24s1h44s1j24t1h44t1j24v1h44v1j24z1h44z1j24ĉ1h44ĉ1j24ĝ1h44ĝ1j24ĥ1h44ĥ1j24ĵ1h44ĵ1j24ŝ1h44ŝ1j2kla3rli5anli5asmi5aŭn1s2cn1s2tn2k1cn2s1fz2lotĵ2e3tŭ2s1k");
            put(6, "_ban3t_bin3d_bru3l_di2s1_din3g_du2m1_ek2s1_el1uz_f2a3r_fin3t_fo2r1_fon3t_gla3t_gru3m_ha3r2_hin3d_hon3t_kan3t_kel2k_kon3t_ku2n1_lin3d_ma2l1_me2m1_me2z1_men3d_mez2o_mi2s1_mon3t_no3bl_pen3d_pin3d_pin3t_pl2ej_plu3m_pon3t_rin3g_ris3m_se2n1_sen3d_sis3m_su2b1_ten3d_tin3t_tru3l_tru3m_tu2t1_ven3d_vi2c1_vi2r1_vin3d_vo3bl_ĉe2f1_ĉie4s_ĉio4m_ĝi2s1_ŝin3d1a2da_1a2de_1a2di_1a2do_1a2du_1a2gra1a2na_1a2ne_1a2ni_1a2no_1a2nu_1a2per1a2ra_1a2re_1a2rig1a2riĝ1a2ro_1a2ta_1a2te_1a2to_1a2ĉa_1a2ĉe_1a2ĉo_1a2ĵa_1a2ĵe_1a2ĵo_1e2ben1e2ca_1e2ce_1e2co_1e2d2z1e2ga_1e2gal1e2ge_1e2gi_1e2go_1e2gu_1e2ja_1e2je_1e2jo_1e2ma_1e2me_1e2mi_1e2mo_1e2mu_1e2ta_1e2te_1e2to_1es2tr1i2da_1i2de_1i2do_1i2ga_1i2gat1i2ge_1i2gi_1i2git1i2go_1i2got1i2gu_1i2la_1i2le_1i2lo_1i2ta_1i2te_1i2to_1i2ĝa_1i2ĝe_1i2ĝi_1i2ĝo_1i2ĝu_1o2kup1o2ta_1o2te_1o2to_1u2ja_1u2je_1u2jo_1u2la_1u2le_1u2lo_1u2ma_1u2me_1u2mi_1u2mo_1u2mu_1ŝ2tel3njaj_3njan_3njoj_3njon_3s2lab3s2lav3s2led3s2lip3s2lup3s2mut3s2nob3s2nuf4b1s2k4ologial3teram2a3re2sperel2a3ner2a3rir2a3nkrom2omi5asmmul2t1mul3tamul3tomult2enaŭo4pof2i3lol2i3tom2a3rsam2arsen2atsen2ilsp2e3cvi5andvir2usvrin3gĉi3el1");
            put(7, "_ab2a3t_ac2i3d_ag2a3t_ag2i3t_apu2d1_ar2i3d_av2i3d_az2i3l_az2o3t_bl2a3t_br2i3d_br2i3g_br2i3l_br2i3t_br2i3ĝ_ci3s3t_di3s3t_dr2i3l_du2on1_ed2e3m_ed2i3l_eg2i3d_ek1i2r_ek1rid_el1i2r_el2i3t_en1ir2_er2o3t_et2a3t_et2i3l_ev2i3t_fe3b1l_fl2e3g_fl2o3t_fr2a3t_fr2i3d_fr2i3t_fr2o3t_gi3s3t_gl2i3t_gr2i3l_gr2o3t_gv2i3d_hi3s3t_im2i3t_ki3s3t_klin3g_krin3g_kro2m1_kv2i3t_kv2o3t_kvin3t_li3s3t_me3b1l_naŭo4n_ok2u3l_om2e3g_on2a3n_pi3s3t_pl2e3t_pl2o3t_plan3t_po2e3m_po2e3t_pos2t1_pr2e3m_ps2i3l_re2tro_sk2e3m_sk2i3t_sk2o3t_sp2a3t_sp2i3t_sp2o3t_st2a3r_st2i3l_stru3m_svin3g_tr2e3m_tr2o3t_tran2s_trio2n_trio2p_tu3ta__tu3te__tu3to__ul2u3l_ut2i3l_uv2u3l_vi3ca__vi3ce__vi3co__vi3s3t_ĉia4m1_ŝv2i3t1a2daj_1a2dan_1a2das_1a2dis_1a2doj_1a2don_1a2dos_1a2dus_1a2fabl1a2naj_1a2nan_1a2nas_1a2nis_1a2nism1a2noj_1a2non_1a2nos_1a2nus_1a2raj_1a2ran_1a2roj_1a2ron_1a2t1ec1a2taj_1a2tan_1a2toj_1a2ton_1a2va1r1a2ĉaj_1a2ĉan_1a2ĉoj_1a2ĉon_1a2ĵaj_1a2ĵan_1a2ĵoj_1a2ĵon_1an2ta_1an2te_1an2to_1e2bla_1e2ble_1e2bli_1e2blo_1e2blu_1e2caj_1e2can_1e2coj_1e2con_1e2gaj_1e2gan_1e2gas_1e2gis_1e2goj_1e2gon_1e2gos_1e2gus_1e2j1ig1e2j1iĝ1e2jaj_1e2jan_1e2joj_1e2jon_1e2kzem1e2m1ec1e2maj_1e2man_1e2mas_1e2mis_1e2moj_1e2mon_1e2mos_1e2mus_1e2tai_1e2taj_1e2tan_1e2tau_1e2toj_1e2ton_1en2da_1en2de_1en2di_1en2do_1en2du_1i2d1ar1i2daj_1i2dan_1i2dent1i2doj_1i2don_1i2gaj_1i2gan_1i2gant1i2gas_1i2gebl1i2gint1i2gis_1i2goj_1i2gon_1i2gont1i2gos_1i2gus_1i2l1ar1i2laj_1i2lan_1i2loj_1i2lon_1i2t3ec1i2taj_1i2tan_1i2toj_1i2ton_1i2ĝaj_1i2ĝan_1i2ĝant1i2ĝas_1i2ĝint1i2ĝis_1i2ĝoj_1i2ĝon_1i2ĝont1i2ĝos_1i2ĝus_1in2da_1in2de_1in2di_1in2do_1in2du_1in2ga_1in2ge_1in2gig1in2go_1in2ta_1in2te_1in2to_1is2ma_1is2me_1is2mo_1o2bla_1o2ble_1o2blo_1o2taj_1o2tan_1o2toj_1o2ton_1on2ta_1on2te_1on2to_1s2tu1d1u2j1ig1u2j1iĝ1u2jaj_1u2jan_1u2joj_1u2jon_1u2l1ar1u2l3ec1u2l3ej1u2laj_1u2lan_1u2loj_1u2lon_1u2m3ec1u2maj_1u2man_1u2mas_1u2mis_1u2moj_1u2mon_1u2mos_1u2mus_3njajn_3njojn_3s2lang3s2lojd3s2malt3s2mirg4ografia2ĉ2e3tafg2a3nal3tablal3truiarg2a3nark2a3nban2a3nbaz2a3rbil2e3tbiz2a3rboj2a3rbut2a3ncig2a3ncig2a3rdek2a3ndin2a3rdog2a3ndol2a3rdu3ona_du3one_du3ono_duo2pa_duo2pe_duo2po_faz2a3ngit2a3rhum2i3dinf2a3njap2a3nk1s2t2rkol2e3gkor2a3nma3l2icme3m2orme3z2urmet2a3nmi3s2ilmil2i3tmob2i3lmul3te_org2a3nrad2a3rrap2i3drez2i3drig2i3drip2a3rrum2a3nsc2en3dsep3o2pses3o2psim2i3ltal2a3rtat2a3rtir2a3nvi5atikvol2u3mĉik2a3nĵab2o3tŝam2a3n");
            put(8, "_abs2i3d_akr2i3d_alb2u3m_am2en3d_and2u3j_ang2i3l_ang2u3l_apr2e3c_apr2i3l_aps2i3d_arg2i3l_ask2e3t_asp2i3d_at2en3d_at2in3g_atl2e3t_bab2i3l_bac2i3l_bal2a3d_bal2o3t_baz2i3l_ber2i3l_bet2u3l_bit2u3m_bl4in3d_boh2e3m_bol2e3t_bol2i3d_buĝ2e3t_ced2i3l_civ2i3l_civ2i3t_dav2i3d_deb2a3t_deb2e3t_deb2i3l_deb2i3t_dec2i3d_def2i3l_del2e3g_dem2e3t_dep2o3t_dev2o3t_di3s2a__di3s2e__di3s2ip_dil2e3m_duk2a3t_efr2i3t_ek3s2ci_ek3s2id_ekz2e3m_ekz2i3l_ekz2o3t_el1aĉet_enk2e3t_eps2i3l_erg2o3t_erm2i3t_et2en3d_fac2i3l_fag2o3t_fas2a3d_fo3r2a__fo3r2e__fo3r2en_fo3r2i__fo3r2o__fo3r2u__fr2in3g_fr2on3t_fus2i3l_gav2o3t_gaz2e3t_gor2i3l_har2e3m_hep2a3t_hez2i3t_hum2i3l_inc2i3d_inc2i3t_ins2i3d_ins2u3l_inte2r1_inv2a3d_inv2i3t_jub2i3l_kab2u3l_kad2e3t_kan2a3d_kan2o3t_kap2o3t_kar2a3t_kar2o3t_kin2e3t_koj2o3t_kom2a3t_kom2e3t_kop2u3l_kro3ma__kro3me__kuk2u3m_kul2o3t_kum2u3l_kv2an3t_lib2i3d_lit2o3t_liv2i3d_luc2i3d_luk2u3m_mak2u3l_malno2v_mar2o3t_med2i3t_mer2i3t_met2i3l_mi3s2al_mi3s2ia_mi3s2ie_mi3s2ii_mi3s2io_mi3s2iu_mod2u3l_mol2a3r_mon2a3t_mot2e3t_muc2i3d_mul2a3t_mut2i3l_nav2i3g_neb2u3l_of2en3d_oml2e3t_orb2i3t_osc2i3l_pal2a3t_paĉ2u3l_pil2o3t_pir2a3t_pir2i3t_piv2o3t_pl2en3d_pl2in3t_pol2a3r_pom2a3d_pr2is3m_pup2i3l_rab2a3t_rab2o3t_rak2e3t_reg2u3l_rem2e3t_ren2a3t_res2u3m_ril2a3t_rip2e3t_rob2o3t_ruk2u3l_sab2a3t_sab2o3t_sal2a3t_se3n2aa_se3n2ao_sen2a3t_sep3o2n_ser2u3m_ses3o2n_sim2u3l_sk2is3m_skr2o3t_sol2i3d_son2a3t_son2e3t_sov2e3t_sp2on3t_spl2i3t_spr2i3t_str2i3d_str2i3g_su2d1af_su2d1am_supe2r1_tab2u3l_tib2e3t_tim2i3d_tok2a3t_tom2a3t_tot2e3m_tu3taj__tu3tan__tu3toj__tu3ton__val2i3d_van2i3l_veg2e3t_vel2a3r_vi3c2ia_vi3c2io_vi3caj__vi3can__vi3coj__vi3con__vig2i3l_viz2i3t_zel2o3t_zen2i3t_ĵak2e3t1a2dajn_1a2dojn_1a2n1i2n1a2najn_1a2nojn_1a2rajn_1a2rojn_1a2tajn_1a2tojn_1a2ĉajn_1a2ĉojn_1a2ĵajn_1a2ĵojn_1an2t1ec1an2t1ig1an2t3ar1an2taj_1an2tan_1an2toj_1an2ton_1e2bl1aĵ1e2bl1ec1e2blaj_1e2blan_1e2blas_1e2blis_1e2bloj_1e2blon_1e2blos_1e2blus_1e2cajn_1e2cojn_1e2gajn_1e2gojn_1e2jajn_1e2jojn_1e2m1u2l1e2majn_1e2mojn_1e2taas_1e2tais_1e2tajn_1e2taos_1e2taus_1e2tojn_1en2daj_1en2dan_1en2das_1en2dis_1en2don_1en2dos_1en2dus_1i2d1i2n1i2dajn_1i2dojn_1i2g1a2d1i2g1e2m1i2g1i2l1i2gajn_1i2gojn_1i2lajn_1i2lojn_1i2s2ta_1i2s2te_1i2s2to_1i2tajn_1i2tojn_1i2ĝ1a2d1i2ĝ1e2m1i2ĝajn_1i2ĝojn_1in2d3ec1in2d3ig1in2d3iĝ1in2daj_1in2dan_1in2das_1in2dis_1in2don_1in2dos_1in2dus_1in2gaj_1in2gan_1in2goj_1in2gon_1in2t3ar1in2t3ec1in2t3us1in2taj_1in2tan_1in2toj_1in2ton_1is2maj_1is2man_1is2moj_1is2mon_1o2bl1ec1o2blaj_1o2blan_1o2bloj_1o2blon_1o2tajn_1o2tojn_1on2taj_1on2tan_1on2toj_1on2ton_1u2jajn_1u2jojn_1u2lajn_1u2lojn_1u2majn_1u2mojn_2u3l2ard2u3l2ari3s2lalom3s2lovak3s2loven3s2milakabut2i3lacet2i3lal3t2a3ralop2a3talum2e3tamul2e3tarom2a3tbarb2a3rbojk2o3tbrev2e3tbulg2a3rdiab2e3tdiad2e3mdom2in3gdorl2o3tdu3onaj_du3onan_du3onoj_du3onon_duo2paj_duo2pan_duo2poj_duo2pon_e3m2u3lsek4s3citek4s3cizembl2e3mepit2e3tfanf2a3rfont2a3nform2u3lfrig2i3dgalv2a3ngarg2a3rgerm2a3nhibr2i3dhipn2o3thisp2a3nhung2a3rizob2a3rkalk2a3nkalk2u3lkank2a3nkaps2u3lkard2a3nkloz2e3tkoag2u3lkomp2a3rkons2u3mkors2e3tkorv2e3tkotl2e3tku3n2iklkvar3o2pkvin3o2plikv2i3dmagn2e3tmalno3blmalpl2ejmarm2o3tmen2in3gmom2an3tmorb2i3dmul2t3egnajb4a1rnark2o3tnaŭt2i3lnirv2a3nnor2d1afnor2d1amnor2d1aznor2d1eŭopos2u3mpalp2i3tparf2u3mparg2e3tperf2i3dpfen2i3gprep2a3rprim2a3rprof2a3nprof2i3tremp2a3rsekr2e3tsist2e3mskal2a3rskel2e3tsopr2a3nspag2e3tspeg2u3lspin2e3tstaf2e3tstef2a3nstr2in3gsubt2i3lsult2a3nsvah2i3ltal2an3ttran3sittual2e3tturb2a3nturb2u3lvinj2e3tvol2on3tvulg2a3rvulk2a3nĉamp2a3nĉinĉ2i3lĥlam2i3dŝevj2o3tŝil2in3g");
            put(9, "_abs2in3t_akum2u3l_akur2a3t_alpr2e3m_anat2e3m_apar2a3t_apet2i3t_ar2i3s3t_atl2an3t_avok2a3d_band2i3t_bi3g2o3t_bisk2o3t_braz2i3l_brok2a3t_ci3d2a3r_dakt2i3l_def2en3d_desp2o3t_di3g2i3t_di3s2aj__di3s2an__di3s2en__di3s2ert_di3s2erv_di3s2oci_dist2i3l_ejak2u3l_ekpr2e3m_eksc2i3t_ekste2r1_ektr2e3m_emer2i3t_erud2i3t_est2in3g_eŭkl2i3d_fakt2o3t_far2in3g_fist2u3l_flor2i3d_fo3r2aj__fo3r2an__fo3r2as__fo3r2is__fo3r2oj__fo3r2on__fo3r2os__fo3r2u3m_fo3r2us__form2e3t_gal2an3t_gamb2i3t_gefr2a3t_gig2an3t_golg2o3t_graf2i3t_gran2a3t_gran2i3t_gran2u3l_grat2u3l_grav2i3t_har2in3g_herk2u3l_herm2e3t_in3d2i3g_in3d2ign_inok2u3l_inst2i3g_inte3ra__inte3re__inte3ri__inte3ro__inte3ru__intr2i3g_jac2in3t_ka3n2i3n_kal2en3d_kaml2o3t_klim2a3t_komp2a3t_komp2i3l_komp2o3t_konf2e3t_konf2i3d_konf2i3t_kons2i3l_kons2u3l_kost2u3m_kr2i3s3t_krav2a3t_kred2i3t_krik2e3t_kro3maj__kro3man__krok2e3t_kval2i3t_kvar3o2n_kvin3o2n_kviv2i3t_kvor2u3m_lar2in3g_madr2i3d_magn2a3t_mals2a3t_mand2a3t_mant2i3l_mark2o3t_marm2i3t_me3z2ere_mer2in3g_mioz2o3t_mit2in3g_mosk2i3t_musk2a3t_negl2i3ĝ_neof2i3t_norv2e3g_ok3o2na__ok3o2ne__ok3o2no__ok3o2pa__ok3o2pe__ok3o2po__okt2an3t_opid2u3m_ped2an3t_pier2o3t_prel2a3t_prel2e3g_prete2r1_prez2i3d_prim2a3t_priv2a3t_prod2i3g_prof2e3t_prol2e3t_pud2in3g_pust2u3l_rak2on3t_re2spond_rem2on3t_rodr2i3g_sa3m2u3m_sir2in3g_sk2i3s3t_sold2a3t_spek2u3l_spir2i3t_stab2i3l_stil2e3t_stil2i3t_stim2u3l_su2d1azi_su2d1eŭr_su2d1rus_su3b2i3t_su3b2ute_supe3ra__supe3re__supe3ri__supe3ro__supe3ru__ta3n2i3n_tand2e3m_teor2e3m_term2i3t_trik2o3t_tu3tajn__tu3tojn__vend2e3t_vert2i3ĝ_vest2i3ĝ_vi3cajn__vi3cojn__vik2in3g_vist2u3l_vulg2a3t_ĝent2i3l1an2tajn_1an2tojn_1e2blajn_1e2blojn_1en2dajn_1i2s2m3ec1i2s2t3ar1i2s2t3ec1i2s2taj_1i2s2tan_1i2s2toj_1i2s2ton_1in2dajn_1in2gajn_1in2gojn_1in2tajn_1in2tojn_1is2majn_1is2mojn_1o2blajn_1o2blojn_1on2tajn_1on2tojn_3s2lofoks3s2meraldabrik2o3tadiab2a3tadvok2a3tafrik2a3tagreg2a3takomp2a3nakred2i3takrob2a3talfab2e3tan3t2arktanekd2o3tantid2o3taor2i3s3tapost2a3taŭtom2a3tbajon2e3tbankr2o3tbiskv2i3tblasf2e3mdefic2i3tdek3o2na_dek3o2ne_dek3o2no_dek3o2pa_dek3o2pe_dek3o2po_delik2a3tdinam2i3tdisk2an3tdisk2on3tdu3onajn_du3onojn_dump2in3gduo2pajn_duo2pojn_ekstr2e3mekz2i3s3telef2an3temfiz2e3mfre2m2d3lgalin2u3lgenoc2i3dgren2o3blhiac2in3tin3d2iĝeninf2a4n3tinfin2i3tins2i3s3tinst2an3tinval2i3dkabin2e3tkalik2o3tkamar2a3dkamom2i3lkapac2i3tkapit2a3nkapit2u3lkarav2a3nklarn2e3tkoinc2i3dkompl2e3tkompl2o3tkreoz2o3tkro3m2a3tkulin2a3rlimon2a3dmalak2i3tmalgl2a3tmanip2u3lmegal2i3tmembr2a3nmil3o2na_mil3o2ne_mil3o2no_mil3o2pa_mil3o2pe_mil3o2po_molek2u3lmul4t3oblnor2d1rusokcip2i3tordin2a3rordin2a3tp2i3t4ecipamfl2e3tpaskv2i3lpelik2a3npersv2a3dpiram2i3dpos3t2u3lpret2en3dretik2u3lsa3m2urajsalp2in3gsanit2a3rsen2eskalseren2a3dsibar2i3tskrup2u3lstenc2i3lstigm2a3tstrob2i3lsurog2a3tteher2a3ntelev2i3dtran3septvatik2a3nveter2a3nvodev2i3lvolat2i3lĉokol2a3dŝibol2e3t");
            put(10, "_adekv2a3t_alikv2o3t_arog2an3t_askar2i3d_bal2i3s3t_bat2i3s3t_behem2o3t_brok2an3t_cenob2i3t_cirkv2i3t_di3s2ajn__diam2an3t_dist2in3g_domic2i3l_ekste3ra__ekste3re__ekste3ri__ekste3ro__ekste3ru__fo3r2ajn__fo3r2in3t_fo3r2ojn__gen2i3s3t_halel2u3j_herod2o3t_inte3r2es_inte3r2ez_inte3raj__inte3ran__inte3ras__inte3ren__inte3ris__inte3roj__inte3ron__inte3ros__inte3rus__kamar2i3l_kazem2a3t_kaĉal2o3t_komit2a3t_konst2a3t_kro3majn__kvadr2a3t_kvadr2i3g_mecen2a3t_ok3o2naj__ok3o2nan__ok3o2noj__ok3o2non__ok3o2paj__ok3o2pan__ok3o2poj__ok3o2pon__paraz2i3t_prest2i3ĝ_probl2e3m_re2f3l2ig_renk2on3t_rez2i3s3t_satel2i3t_skarl2a3t_skler2o3t_stern2u3m_strat2e3g_supe3raj__supe3ran__supe3ras__supe3ris__supe3roj__supe3ron__supe3ros__supe3rus__terak2o3t_trans2i3t_ultim2a3t1i2s2tajn_1i2s2tojn_1o2por1tun1u2l1i2na_1u2l1i2ne_1u2l1i2no_3s2log2a3nadjut2an3tantrac2i3tasimil3i4tasimpt2o3tb2i3l2a3rdbatal3an4tbergam2o3tbr2i3g2a3dbracel2e3tcent3o2na_cent3o2ne_cent3o2no_cent3o2pa_cent3o2pe_cent3o2po_dek3o2naj_dek3o2nan_dek3o2noj_dek3o2non_dek3o2paj_dek3o2pan_dek3o2poj_dek3o2pon_dilet2an3tdiplom2a3telizab2e3tf2i3l2a3rbf2i3l2a3rifakult2a3tfokstr2o3tformul2a3rhierod2u3lhipokr2i3thomunk2u3lhoriz2on3thotent2o3tinkogn2i3tins2ul2i3ninterm2i3tinvent2a3rkalend2a3rkalend2u3lkan3t2arelkandid2a3tkonfr2on3tkons2i3s3tkonst2an3tkresĉ2en3dkrizal2i3dkrokod2i3lkvadr2an3tlabir2in3tmarcip2a3nmarion2e3tmatrik2u3lme3z2embrime3z2entermez2aliancmil3o2naj_mil3o2nan_mil3o2noj_mil3o2non_mil3o2paj_mil3o2pan_mil3o2poj_mil3o2pon_nor2d1germpartik2u3lpartiz2a3nperlam2o3tpers2i3s3tpoligl2o3tporcel2a3nprecip2i3tpreter2i3tprozel2i3treding2o3trekom2en3drozal4in3dsacerd2o3tsanskr2i3tsek2u3l2arsekund2a3rsindik2a3tsterl2in3gsubstr2a3tsufrag2a3ntamar4in3dtarant2u3ltereb2in3ttran3s2pirtran3scendtrankv2i3ltuberk2u3lvi1r2ulentĉambel2a3nĉarlat2a3n");
            put(11, "_amet2i3s3t_ekste3raj__ekste3ran__ekste3ras__ekste3ris__ekste3roj__ekste3ron__ekste3ros__ekste3rus__inte3r2upt_inte3rajn__inte3rojn__liverp2u3l_margar2i3t_melol2on3t_ok3o2najn__ok3o2nojn__ok3o2pajn__ok3o2pojn__pir2i3d2in_re2spublik_re2storaci_rekviz2i3t_supe3rajn__supe3rojn_1an2t1i2na_1an2t1i2ne_1an2t1i2no_1u2l1i2naj_1u2l1i2nan_1u2l1i2noj_1u2l1i2non_3s2mok2in3ga4n3t2i3nomaŭtorit2a3tcent3o2naj_cent3o2nan_cent3o2noj_cent3o2non_cent3o2paj_cent3o2pan_cent3o2poj_cent3o2pon_cirkumc2i3dd2is3t2ingodek3o2najn_dek3o2nojn_dek3o2pajn_dek3o2pojn_eksplic2i3tjerusal2e3mjug2u3l2a3rkap2i3l2a3rkastanj2e3tkomprom2i3tkonkord2a3tkonson2an3tkorpusk2u3lkrizant2e3mkvatern2a3rkvodlib2e3tlap2i3d2a3rleŭten2an3tmagistr2a3tmajorit2a3tmastod2on3tmil3o2najn_mil3o2nojn_mil3o2pajn_mil3o2pojn_minorit2a3tpl2i3l2a3rĝplebisc2i3tpop2u3l2a3rpos3t2amentpos3t2iljonpriorit2a3trehabil2i3tsa3m2ov2a3rsing2u3l2arsol2i3d2a3rsomnamb2u3lstalagm2i3tstalakt2i3ttran3sistortroglod2i3tĝentlem2a3n");
            put(12, "_ekste3rajn__ekste3rojn__instanb2u3l_k2a4n3t2i3n1an2t1i2naj_1an2t1i2nan_1an2t1i2noj_1an2t1i2non_1e2le1g2an3t1e2str1i2na_1e2str1i2ne_1e2str1i2no_1i2s2t1i2na_1i2s2t1i2ne_1i2s2t1i2no_1u2l1i2najn_1u2l1i2nojn_al2i3g2a3torantikr2i3s3tcent3o2najn_cent3o2nojn_cent3o2pajn_cent3o2pojn_kan3t2ar2i3dl2i3g2a3turoreferend2u3msafr2a3n2i3n");
            put(13, "_pedik2u3l2ar1an2t1i2najn_1an2t1i2nojn_1e2str1i2naj_1e2str1i2nan_1e2str1i2noj_1e2str1i2non_1i2s2t1i2naj_1i2s2t1i2nan_1i2s2t1i2noj_1i2s2t1i2non_dakt2i3l2a3rbfrit2i3l2a3rigal2a4n3t2i3nhermafrod2i3tpterodakt2i3luniversit2a3t");
            put(14, "1e2str1i2najn_1e2str1i2nojn_1i2s2t1i2najn_1i2s2t1i2nojn_adam2a4n3t2i3nbrig2a4n3t2i3npartik2u3l2a3r");
            put(15, "prestid2i3g2i3tstrof2a4n3t2i3n");
        }
    }), et("et", 3, 3, new HashMap<Integer, String>() {
        {
            put(3, "o1v1ma5šo4šk1še3ša2žž5žü5žö4žt4žp3žo4žn4žm4žl4žk4žj1ži4žf1že4žb1žaü4üü1vü1jü2hü1gü1bä1vä3jä1gä1dä1bäa4öü4ö3õö1vöo2ö1mö1lö1kö1jö1hö1dö1böa24õsõ2põ1jõ1gõ1dõ1b3zo3vä3võ3vi2vf3ve4vbuä2u1va1bu1ta1du1pu1ku1ju1gu1fu1ba1fa1g1tü1tä1tö1tõ3tua1ja1k3ti1ta4sž1sü1sä1söa1m1sõ1su1so1sia1p1se1sa4rš4rž1rü1rä3rö1rõ1ru2rt2rs1ro1ri1re1ra4pš4pž3pü1päa1t5pö3põ3pu1pia1v2phpg41pe4pd4pb1paoü24št4bb2bd4bf4bho1jo1go1f2bm2bn2bpo1b2bsoa24nš4nž1da1nü1nä1nö1nõ1nu2nt2ns1no2dd1de2nk1ni1ne2df1di1na4mž3mü3mä3mö1do1mu2mp1mo1du1mi2dõ4dä4dž1me1lü1lä1lö1lõe1be1d1lu2lt1lo1lie1fe1gl1g1le1la4kš1kü1kä1kö1kõe3j1ku2kt1ko1ki4kg1ka5jä5jõ3joj4ai1že1mi1v2iti1pi1ni1mi1ki1ji1gi1fie2i1di1be1pe1r4ia3hü1hä3hö1hõ1hu4ht1hoh1nh1l4hkh1je1t1hi1he3ha4gä3gue1ve1š2ff1fi4fj4fk1fo4gg4gf2fs3fu");
            put(4, "3ter3tee1t2e4aks2td23tav3tamt2al3ta__ää4_õõ43süü3süs2sük2süh5süga3li5süd4süa_öö44säm4säkü2le2sönals44altsö2k4södök4v5sõr3sõn_ür24am_sõ2l_üü42s1vsu5eam4osua2ül2d4amü2an_stä4stt42s1tss2tss2p2anessk4a3ni2s1s4anj2s1r2s1p3soo4ano3son3soi3soeük3l2s1nao4d4s1m2s1lao4jsk2l4skaao2m2s1k2s1jsie43sia4aabao2r2s1h3sep3sei2sehöi4s5segöi4g3sats4ada3piöi4aa3poa1ae5žer4rüm4rükö1g4öep4a3pä4ara4rökaa2h4rõr5žee2r1v2arir4ujrud44arkaa1irt2r3š4irs4ors4l_oa3r3ri2r1r2r1p4rožroa4õõ5prnk42r1nrms4rmp42r1m2r1lrkt42r1k2r1j4riö5riv5riu3rip3rim2rig5rid3riaaa2j2r1h2r1grf4r2r1f5regreb25rea5re_õ1v4r4dü4r1d2r1bõs4a_oo4õ3pa_aa44päsõl2düaa4a3taõi4bp4õiõi4a2p1vpua4ääo42p1tps4a2p1s2prap2r44atuau2ap4püp4põ4audpps4a3uipp3l4p1p3poo3pon1p4o2p1n2p1m4plõp3lup3li2p1k2p1jõeu4õet2av4aõea4_ee42pf4a1õ2a1ö2a1ä2a1ü2p4em4a1š5baape4fpe2aõbe3bab4bae4bag4äu4däs4ppa4eä4rõ4võmo3õ44aanou4nou4b4osõ4oss4osoä4ro2v1v4oslbeb2bef4beg44osf4oseo2sa1orgo3paoo1a2o2oo4läolõ4v3tr2v1sbha44oljo3laok3r2v1r2v5pof5r2v1no4eooe2l2b1j2b1k2b1lbl4eod4š4o1d2v1m2v1l1obj2v1k2b1r2v1jo1aevip4b3so2bt4oa4avid43bumvia2äok44nül2b3v2v1hdaa22vg4ä4kõä2kedae4daf4nõ4l2v1d2n1v_sk45damntt4n4trdao4vav4n3sons4ev4ar2n1rn4ornod44nobvag4nnk4už4l4aatdea22n1n2n1mded4nk3ru1ü22n1jnig4u3är2n1hn2güng3r2n1g2n1fn4esnea25ne_4šaun4dü4n1du1õ22d5g2d1häi2s4nb4did4dig4n4asnad4n4aa4uuta1au4müh4uud4mäk_sp44mök_st44mõpmõ4d2d1j2m1v5mus2d1lmup4mue42d1mmud4mua42d1na5bedo4hu2sü2dosm5tsms4pms4o2m1s2m1rmp3rmp3lu2sõ4moh5absmm4e2m1m2m1l4šakdu4bdue42m1jmi2smip4u2so2m1h2d1vus5gdõ4läe1o2dül4mg42m1f5düüa3di2d2šm4eteaa23meeu2orea2b2md4e1ae2m1be1aiea2j3mal3maalü3huo4h4läna4dö4löeu1o2lõ4leao44lõde1arae2dea2s2l1v3luu2lune3auea2vlue4umf42aeeed4alud43lua4u1meei4ae4fls4o2l1s2l1r2l1p5loilof4u3lu2l1nlmp42l1ml3lullt4lls4llp42l1ll3krlkk42l1k2l1j3lidul4a2l1hl2goüs4ou5jaürd4lf4t4l1f4eha3lete2hile2sleo23lej3lee4aei4ehäl4düei4e4l1d2l1b3lau4aekui4h2kž42ael4käm2käku4gü4köd_ts44kõp2kõiüp3rue4re3ka2k1ve3ke4kužek2l3kusueo44aen4k1s2k2rk4olüp3l2k1n2k1mk2lok2lakks4e3kü4k1k2k1jkio4kie4ae2sua2v2kf4keo21k2e2kd42k3be3likag4u1auöö3oua2sjue4öö5ijag4jad4e2lujab43jaau1anua2li1ü2i1ä4i1õ2i4vüa3gou1aei3uuiu2jiu4bua2bi3sui2souaa4io2pio4jio4h2inet2že2t1žil4ai3ku4ai_eo5aai2aiie3ii4aöö3a4tämiei4üot44tök4töei1auia2sia2hü5nee3plia2gi1ae4tõpiaa2tõ4l2tõi5tõb_uu42t1vh4vo2h1vhup4hue4hu3aerp4ö4räh4täh4töh4trh4toh2ta2t1thrs44hp4tsp42t1sh4mü4h1mt2reh4käh4kõhkt4hks4hk3rhk3l2t1rör4ehio25him4est5hile3suhia2to4otog64h1h3t2o5har2t1ngü4l2t1m2g1vgup4gu3ogu5igue4gub44etu4ajog3trg2ru2g1r4goh2g1neu4peu4s2g1me3uutlu42g1le1õ2e3ö4e1ä2e1ü4ült45faa2g1k2g1jt3krt3klgi3k2t1jti3e2f1lf2lo2g1h2f1na3kitia2ülp42f1rf2regek42t1h2f1tgea42t1f3gaa2gd42g3b4gabgau4gag42gahg4asga3pga3o5gam3šu4");
            put(5, "ga3k4gai4g4gart4garvga2hi_al4a5gatagat4r4gaedšis4k_ap3l_ap3rgaa4rftat4_au3a_eba3ge5kl_ek3l_ek5r_gu4a_hie5ge3luge4lä_idi4geok4ge4or4geos4gerg_is4ofo4rofolk5_ja4egi2ajgii4sfii4t4ginf4gintgio4rgi3pl_ja4t_ka4egi4sögit4r_ka2o4fa4dfaa4ne3v4ag4lüte5uske5u2nüü4peüü4loe3u2lgo4lego4mago4po2g1p4e3u2jg2ranüü4leüt4rueu4de3grup4g1s42g1t2e4tümü4t3ret4tüet4täüta4rüs4pr1ette_le4eürik4gu4säguu4jet4sü2g3õ4üpsu4üp5p4et2raüni4shaa4s_ma4a_ma5jhasa4hat4rülo4rhee4mhee4shei4shek4v2hel_hels4het4re2tenhhe4le3t4aesup4hii4ses4tüül5laül5klü4liõülii4ü4lih1üleshi4sü5hitses2pohjaa4es4orh4kalh4kash4kisü5lelh4ko43ülek_mo4eesk3r_nek3ükan4esk3l_ni4peske4hle4nü3hith4mo41ühene5sil_noa3e5senhom4oe5sekävee4es1ane4rudhta2jh5takhta4lht5ar_re4ah4teghte4nhte4rh4tid_re2oät4riht5s4äs4soers4ker2präs4koär2vahui4dhuk4lär4tahu3saerih4hvad4ärii4hve4läret4ä4rarhvu4serek4erei2e4raoänet4ä4nahe3raaiaa4l5ämbläl4koäli2sia4boep4lue4pliä5ker3äke_i1a2jia4kri3akt_se4ai5albäi4sõäisa4ia2meäi4luia2naäi4loäike3ia4neähe5aia2p4äe3a4ia5pria2rei3armia4rui1arveos4fäbut4äbus5i3asu_toa3iat4rööt4riau4l_tus2öö3e4_um2bi4badi4bauö4tü4ö4to4idii4idlu4ö4rülö4ro4i1eeleo5pli1eksör4dai1elui3eosie4riiers4i3esiie5soi5essie4stö4rauö4raaeoo4peo2maöp4lui5garöli2si4gavö2konih4leih4teaaa5leo2lua1aasa4aeraa4feii4esöet4r3öeldii4haiika4ödi4kaai4gaa4isiikt4õõ4taõõre4a5aitaa2laõude3õ4tü4õr4goõr4daii4lüõra4s4õp3rõp2paõpi5e3õmblõ4liti5infii3niõ4limõk4kõiink4iino4õise4õi4koii4nõii4pr3õigu3õieliirs4ii4rüõie5kaalg4õh4vuaal3kii2taõe3luiito4aa4lüzoos4zook4ii4tõii4tüaa4mö4võigii2voeo4jaen4tüvu4sa2v1t2aa5niaant4vir4kvi3plaa4röaa4rüves4pveot4ikop4ikos4i4kovi3kreik3rove4oliks4k4vehivee3kvee3aiku3aaa4soila4svau4dilia4vat4rvas4kil4kõ2vartillo4var4p4varmvap4rvane2ilp3lil4tii5lunva4lüvak4vilü4henk4r4vaiaimi4gva5hevae4r4vabienk5lva4asaa4süu4vauaa4tõuu3sauu4püi4nehaaši5uu5ali2nimutü4hutu4sutt4rut4sout4ruutot4utos2ut4kl1insp1inst4a3baio4deus3ühi3ohti5ohv3abiea4bijio2leusui4io2luus3p4io4lüio2mauso4ra4dadus3krusi4ge5nema4deoi5orki1osaios4fios4pios4tus4fäio4suu5sevuseg4io4tüu3seai3plaip4luip4rou4saeipse4usad4u5sa_u2sa2uro4rurea4ir4nõi2ruiiruu4urde33urb_u4rapu4raguppe4up3lei3semu3plaisi4ga2deru3orgadu4ru4ni_iso4ri3sotun4dois3plunaa4is3spumit4umia43aed_umet4u4mauumaf4a3eesuluo4i4sõm1aeg_isü4remp4ritaa2ul4kruldi4uk4viu5kroits3kit4soitte1itt4semos4iu2daiu4giemne3i3ujuiu4laukop4ukki5iu2moiu4niiu4puiu5saae4giiu2suiuti4e5matu4jumi4vadu4juj3aegnui4voi4vaui4vehive4lui4toel4ühui4siuina25uim_u3ilmu3ihae5lubja1ajjaa4ljaa4rjaa4s1elu_el4tüja5eljae4relt2rja3i2a3eks5jama5jamejao4hja3p4ui2gauidu5jat4rug2rajau4bjau4lje3luels4tjoo4kelo4p5jumaae2leae4lo4ae2mue2mau3eksu3eelu5ealka5ajka4aludo4rudeo4u4dehae4pi4kaed4kaega3esie4liduau4d4kaia2kain4aettu3asta4feku5artua2reka4plka2pr4karmua4nuk5asjkat4ru3allagia4u3aktke4elua2ja2kehi4keksu3ainuai4kua4he4kemb2ken_5keneu5abikes2kagud43tžem5tžek5ahnutü3hi2k1h4el4an5aiankik4r4kinfe2lamki4prkis4aai4hutä5keai4kekit4rkiu4dtöö3ptöö5kai4klk3kraa3ilmai4lu2k1l44tõ4nk3la_aimp4k3lai4ain_k3lana5inf4ainsk3lat4tuudkle4ak4leek2leitusü4k3lemk4libtu5suklig4k2liitus3stu2sik3likk3lintus1a4tuimttes2ttee2k2lubt4tadai4prai2sak4lutt4sort2sooknaa4k4niptsig42koksts4aat3s2a4trüü3t2rüt3rig3trepko4va2k3p44eks_t4reit2rant2raf3krabt4radk3raiai4va4krank3rau2t3p4tost44kregtos4pk5ret4kripa3ja_k4rohtoen4tmis3k3rut3kruuajut44k3rü2t1l4k5saek4saiksek4ksi2k2t1k2ksit4ksk4lks5kõak4asks2prkst3rks4tüek3rekt2rae3k4okui4s4tinf5tima4tilm4kukskul2d2kulptik4otii2kek4loak4krkut4rthõl44t1g4tes4ktes4ak4vanters44tergterd45ter_ei4tõk5õis2tepptep4ltek4vtek4rkäi5ste3klte3hiei2lu2kühe4külete4ete3ilmei4heei4ha5laagla4ajlaa2rte5aste3an2laavtea4h4ladj5ladulae4r3laev4lahvtea4gte4aaak3ro2t1b4a2ku_lak4v2taut4laldta4sü4lals2tart3lama3lamp4lams4tarm2lanilap4lta4pr4larüta4ot4lasb5tamata3lu4taisl2asi2tabial4et5laudlau4nsü4ra4lavhei2gal4baulb4lo4sülosü4las3üksl4dons3ühial2lüle1a2a4lob4alu_a4lud1alunle3hi2s3õu5lehtsõsa44lekkalü4h2s1õpa4lüt4lele3sõlma5ma_3sõit4sõie3sõidle3oh4s3õhle4ple3hinsõ4dele3sõe2he_5sõdae4goilfoo44suugegaa4l4gael4gaisut4üsut4r5sus_4surbsu4prsupe4ee4tä5sulg4suksee4süamit4li5amlia4vsu4dusud4rs4tüh4liialiie45liigs4tär5lik_stu2sst4sos4tot4lilms4tops4toh4linfstet44lins4stam4linvlio4ks2taasst5rss4tiss4kea4nehssin4li4sölit4rli5tu2ližess2fälja1aan4krs5per3ankul4klilk4lu2s1os3sortl5lers3orjl2lor5sor_so4prsoo5oanos4so2mal4lää5solo2so2llmat4l4maus1ohteent4ee4no4anstlod4r3sobisne4p4loha4lohvao4helok4r2lo2ll1olea3oht3loloskuk45loogao2le4lord4lorn2losaski4gs5kenao2lulp4lel4puka3omalrih4ao4nuls4kalske4ee2lalste4eek4rl4taulti4ll4tok5sisusis2pl4tukl4tõml4tääl4tütee4fee3eeslu3alsi3se5siru3lug44luhk4luim4sirr4luk_3lukk4sinssikt4sii4gluo3r5signaoo4psia4hao2pelu4sö3lutalut4r2s1g2e4asslvel4ea4reea2pa4lõie5lõik4lõis4lõitea4nulõ3pelõp2pe5ann2s1f2ea2me3sestses4ka1osaseo4rea2lalü4maseo4peak4vse5omseo4kse5ohmaa3pma4bima1e2mag4l5mahl4mahv4sens2seluma3klmak4veak4s3selt5selima4omma3pl4mart4marvma5sese3klma4st3sekama4sä4mautea2himbat4sei4dmblu4mbo4jao4sue3abie1aasme1a4me4anea3aj5sehämee4sme3hi4mekvmers4mert45sehu3dšem4met_4metl2metn3seho4mettme5u44dü4rdü4lidusk43sehamia4mmia4r4midea1otsa2par4minfmi3ni3seerd4u2s3seadmi3si2s3d22s3b24satlsase4sa2prs4anus4ant4sank4samp3s4am2m3k42d3t2dsar45salvmma4s2d1s4mme4r3salt5saksm4mor2m1n4s1aind2renmo4ham3oks4morg4mornmo3sad4relmpa4lm4pap4saiadrao43sai_mruu42d1r42d3p45dosk2m1t2d3osadoi4rdmi4kmu5ahdmee44sahvmui4m4mulsdle4vdkop4sa4gu2d3k4dit4r4mõigs4agesae4l2s1ae4sade5sada4sabodi2os4dini4dilm3sabasa4anna5ahsaa5j3s2aaa3plana5einag4l4rü4rnai4dap3ri4rä4ra4prur5õli2rõ2lr4vokr4vohna3o4nap4l4ruur4narvdii4g4nasbnass4rut4rnau4bdia4vderu45rus_n4dabn4dae4rumpnda4ln4daundif4ndip42rummn4duj4rumb5dero3rumaru3krdere42rua4r4trirt4ranei4vr4tosr4tah1arstneo4dne4pl2nerg3arua1arvu4rosade4pr2romin4gai4rombrok4kn4gaung4lüro3e2r4nehngud4r4nada4sau5del_dek4sni3apnia4vdek3lnii4grmo4sr4mig4nilm5nimar4kekr4kad3nimias4fä4niml4nintrio4r4rilm4nisl4dehe5riie2riib2dee_nk4senkst42n1l4de5av2deaanna3enna5irig4r3rigennio42d5b2asip4ri3amaskõ44noksr4geh2darv2n3p44darurg3ahr4gaea4soknsk5r4darbnso4rnste4aso4pret5sre4trnst3rns4tunsu4sret4kre3ten4tehnte4lntig4re2pr4repp5relvnt3rant3re4reksrek3l2rehi3reetnt5sü4dannn4tühn4tük3reernu4danui4gnur2knus4pas3plas2pod5ain4nõlida4doass5tda5abr4dujrd4rebuse5bu4lõ4buksbros4o5akurde3ao5apaoau4b3brigoba4s4bortb2lonodaa4r2daro4dehr4daeblet4oe5a4oe4febis4ko3eleoe4mioe4mubi4si4astioe4rõoe4sioet4rbis4ar4bae4binõog4laog4li5ravioh5to4rauroi2taoiu5abi4enoju2s4raumokku5ok3la2raukrau2d2bi1eok4reok4riraua3ok4rubia4vo4laeolag42rarv4rarsol4do4rarb4raptra4plolig4o3lii4rapara3omo3lis3rameral4t2rainol4lüraie34o3lo5raaš4raav1olu_a4sudpü3hebet4rasui4a5suua4tažpõli4o4mokona4ao4najpõi4so4nehpõhi3pus4p4purtoniu4puk4kpui4to4nuube4stbe4sipuha4ook4rpu4dap4tak3p2süp4sorats4p5pruuoo4lõoo4lü4prump4roop4rog2priioonk4oono44priboons4p4repp5rau3prag3praaoo3saat4süoo4tõatt4saua3lop4luop3raop3rip4pudp2p3r4au2jppee45oravppe3abero4org4roria43orjup4pas3ornappa4kau4keort3roru4sor4võberk4aulu35po4ep4neua5urgaus4oau2suo2si_4osinp3lombe3a4bat4ro4sokos1olos4pa3plok1autoos4süplek2p3lam4ostop4lakp4laa4pla_oto5aotok4ga5is2p2l43otsao5tsöot4tapiu4gpip3rotü4lpin2dba4rõbap4rpik5rovio4ovol4pii4vbap4lbak4vbak4saut4ra3vara4veh5perdpe4olpans4pa4praž4ni3parkpel4tpa4sppela4ba4hebaa4sbaa4kpea5jpeas4pe4aupea3vbaa4got2ra");
            put(6, "4pektrga4va_4partape4lü45paraspa4lusba3k4rpe4tappeti4kga4vanpa3a2ma4vanspaa4kao4vu4novaa4lbasa4s4gaast_art5rpis5taot4teoauto5sautoo4o3tranbas4ko5osutige4du_3plaatost4ruos4tem3frees3plasm_eela44gekse3plekk4p3lemos4saj5pliiapliig4bas4pe3oskusa3usul3pluusbe4lü4o4seksbe2ra24o3sauau4pü43osakoaulus4o4sakepoo4lage4lahpordi5or4talor4nelgela4s3ordero4ranage4leho4ralgau4de_o2r3aiau4ba_ge4nanbe4rõ4oo4seloo4reeoo4rat3prakto5optioon5t4p4resioo4noh_ise5ep5riitoo4nauoo4nar4p4ros3p4rotoo4nahoo4logge4rusat4soooo4ligoo4leeat4rusoo4lauat4ros5atroooo4kääoo4kalont4reonsoo4pul4tionit4ron4gosatmi4katii4vo4nelegi4sanona4koom4banom4baj3omadupär4gua4sussgi4silo4luksgi4vaja4su4b_ke5hiraal3a4raale_kip5rraa4lu_ku4pl_ku5sa4raattraa4tuol4tarol4tamol4maiollis4r3ainerai4signe4taol4laera4lusbi4ala_la4pl3g2ravolii4go4lend3olek_ole4anra4renola4sue4tõ4dra4sal4rasenra4sisrast4rra4sukra4sulra4sut5ratas5ütlevütee4lo5krisokoos4raud5oet4truokast4üs4tasrau4te3ohaka5astmebi4plaoe4rahodu4sõodaal3o3analbu4si4bus4krdaala4as4sana3sporda4lehda4lumree4leüs4talgu4nelda4lusnt4saras4petnt4sanrei4sent4salnt4sabre4laiet4tajda4numre4mään4totsn4tisorep3rere4sinntaa4rdarat4nstis4ns4temns4teeas3oledar4den4salp4da4rerga4renoo4nargi4mer5g2ragu4senas4kõld3arv_4dasenri5ast5asjanda4sumri4ga_n4ne4fnnak4rn4ka4ndee4le4riinuri4kisri3k4rnis4kea4sindri5oksni4sidasi3anrip4li4rip2p_le5hiri4sahri4sarri4ses4risolri4tolri3t2ret4soo1a2si_ni4miget4sina4sett5nimetrk5ainrka4senima4sa4sesea4seos1a2senr4mald_le5se_lõpp3rmo4ranii4tuhaa4riase4made4laungus4tümi4koa4sameüma4ruar4vään4go4rn4gaserol4larol4len4gall4deluvro4noproo4gane4tõmros4po_maa5arost4rne4tanetii4srp5ret3arvamül4meie3sporrsaa4lne4leka4ro4lr5s2pors4takhi4san4nelasne4lah3ülikonee3lunee4lert5roort4saiar4kelnee3laari4apari4alde4relde4repndu4sõn4do4rnda4kon4daasru4setru4sinru4sulnat4raruum5ana4ret3arhitrva4larva4lur4vannrvas5krvis4khi4sarhise4l3aretuna4miiül4geerõn4gu5arenga4rasearak4kröö4perööp5l2nal4üna4kruap3ronnai4siap4pisnah4keap4pinap4paldiina4ül4gavnaa4lusaa4ludii4sa4s3aasdii4susa4bi_ülesä4a3parvdi4plodis4ais5aderdi4sardi4sas5sa5gadis4prmut4radlust4hi4st43dreen3drenas4ajansa4ju_sak4roes3ole4saku_sa4kääes4laa4salass4alat_mi5sasa4lev4salla4sallummika4sa4lumm4maat2d5uksmitte3mis3ts4s5annmist4r4santiüld5a2sa4nummis3k4sa4riss4arv_sar4vami4sil3sasties2k5ösa4suksa4suma5parth4kuskük4kasmi4sihmi4siges5kelmis1a2se3alas5ealieska4sse4du_4seelasee4les5eelnsee4ma4seepidu4s1asee4si3ühik_4se4femi4nahsega5ami4kajdu4seemet4seme5s4omee5lamb5usambe2r3sei4sieska4jma5sinühe5i4se4laj4selekmal4ma4selluma4la__nisu54majammaa3lama3abimaa2b4hnika5e3ala_lääne5sepat44serem4sese_se4si_üdame5s5esitlän4gie1a4lu_pap4pse3t2r4settee5amete5astea5oras_pea3alu4sumää4kinlu4seelu4rausig4ra1e2se_lu4niosii4sasii4se4siitssii4tusi4ketsiko4dsiks4plu4ninsik4vi4sinimhta4sue5asutsio4lesi4prolu4juke3ava_er4tese3ealier4taklt4sississe3er4taalt4sel3eelarsja5aräs4sanl3plaa_rep3rska4noäs4nais4kelae4ro4reel5uul3osa__re5sos5klas5sklerlo4man3skulpsku4sil3olijee4naisma4saer4naulo4gal3antenee4nalee4naml4meks3ansams5oks_lmaa4vs3oleks3olijee4paiso3luteri4uu5eeposan4nahee4ral4so4peeer5apl4lotslli3tree4rosee4rot4sotsuee4sin5ärritlja5osa4nisossel4l_rü5hili4sõls4sinfli4suj4lisolan4dogs5sporan4deos5statli4sikli4sahs4sussan4dasli3p4l3staad5staašs4tainlin4teär4kar3starts4tatiäri4kls4teno5stepp4linimlimi4shvast4lik4roärge4l5strekh4vinili3kla5ergutlikai4ära3o43stuud3analülii4nali4ga_ä4ra5aam4palsu4barli4dan_sak5rli4alasu4julee4tõms5uks_l4gu4jsul4gaän4to4su4nisl4gi4dsupe5s5eraldlgas4kl4gasesus4aasu4sess5uss_sus4tisu4sunl4gannl4gallegas4tsuu4rasuusa33ametnsvus4ta4maad4lette4lese_le5olu5ehistlenaa42s1õig2s5õisle4mor5lema_2s3õlile4lekän4deo4lektr5leks_1e4hit4lehitleep5rlee4leleek5l5ehitieh4ta4al4luji3aasti5a4bi_sap3re3ots_al4ged5algatei4dulalet4tl5distl4dalasül5disü3lemeie5rilau5sue3iga_ale4lea4laühi3aine3alald3taat_i1a2la4t3aedt3aine4lasen4ta4ko_skaa5äi4tarta4levi3allila4semta4lusi1a2lula4sei4tandala4sasta4pla4l1arv_so5lila4nesla4lusi5andjta4sesta4setta4sisla4lesla4la_la3k4rta4vajla4javi5andmla4japlai4gaäidi4s5laavalaa4salaar5aa3kriitee5lu4küll_ei4memtehi4s5eine_ei4rooi5anneba4ju_te4lokte3lu_4tepiväga4riei4taua5kliikõ4de_te5r4aei4va__teoo43kvarte4kahite4sinek4kapak4laukuuse5a3klaskuu4niku4sivak4kis3aken_kummi5tii4matii4satii4ve_tet3rti3k4rtik4vikuk3la4kujum4kujujtin4gati4saitisa4vti4siktitee4ksp5loksika4a4kaatakaa4se3krii3kruvi1a2jamtmika4k4rooka4jalu5ajalo4to4da3krohva4jale4toks_i3aparto4lekto4lu_to4lumtonis4_tina5too4notoo4peto4rau5k4resias4keia4tel3kramp3k4rae3kraav3trafot4rahh5trall_tsi4s3transt4rate5traumaist4r3treenk4raan5treimk5osa_4korpi5triib5triipe5osavtri4plt4ross3trumm5t4rup3t2ruu3öölankoo4sa_tu3sako4len_ul4gatsa5ist4saju_ulu4k3tsehhtse3lae3osak5ideaa4tsenaös4tii3ekseme3osa_t4sink_vaa3lts4laaeksi3k3ekskaklu4sõt4sussklu4sak3lus_3klotsk3loomt5tsema3inseeksp3rtu4rajk4linki3ealiö4ri4l3kliim_vask3tus3t25klibutu4sä43kleit4tutopi3etentuule5ietu4si4ga4g3klappö2p3au3klaas5ekstrai4me_2t5õunkku4roek4tülelaa4ve4lagrkiu3su4kiste_vere3ki4sikki4san3elamutü5he__õppe5eleis4ah4karölis5aket5ra1a2hi_u3aast_ühi4se4leks5agregke4lokke4lakke4lajkee3lu_üle3e3eleme3ökonou3ametig4ram4kasetu5aparih4tinua5reeka4ju_ka4javii4deoka5istkahe5ikae3luaa4bi_4kaderu4dalukaa4taii4du_kaa4rakaa3dekaa4daelii4tel4kuse4l4obae4lu_juse4lju4seiu4gi4djat4suu5graae3o4leuh4temuh4teruh4tinuh4tisii4gaajas4keja5kraelu5i41e4lune3lus_e4lussuinas5aa4gan3uisutuite4hiviil5ii4kisui4veli4vant2a1e2h5ö2deei4vaktaa4has3ujumii5uss_ukaa4sukii4giu4me4iu4maru3kraait2ru4uku4sait4rasiik4roul4dehit4rakitee4lul4lenul4luiultra5i2sü4l5emulsiiks4tii4labist4seõõ4relist4ru5istmeii4ladii4laeum5p4rii4lehunaal5un4dakun4danun4dasii4lelis5omaa5ealiadu3sei5soli3isolaendus3iset4si4seloi4sarhup4pisuraa4lisa4reura4juu4ralai4sanaur5aukura4vaisa4jaisaa4vir4disu4reosures4ku4retturgas45urge_aa4laeu4riniuris4kurka4vi4raseu4rului4ra4bip4susip4sepip4sasu4saluaala4rii4lesi3otsiõr4garu4settu3setui3ots_iost4ri3operu4si4diooni3u4si4hus5indusi4vaioo4neioo4daus5o2hus3olei5omani5olukõr4gaai3olek3usuliu4sussi5oks_3energe4nese3inven3insenii2lõ4inna5ai4nini5inimlii4maii4nimeiimat4ini4küi4neksuu4du_uu4kakuuk5riuu4maluu4misinee4suu4ranuu4rasuu4rauuu4rave4nesluusa3kuus4keu3uss_uu4sulaa4tühuu4tasuu4tisuu4tühu5uuriind4reinde4r5aatomaa4tehaa4tasaa4taaii4metii4naiind3al5imperi4mo4laa4sutimisu4i4melu4v3ainaa4lasva4la_va4lai4valdiaa4lehilu3savana5iilo5g24vankuvan4tavan4te3ilmutõnet4sil4mot5ilme_ille5s4varuh4varveva4sasil4kanvast4ri4lisi4vatudi4lasiii4nauen4salaa2se4aa4saren4tosik3t2rvee5lavee3spiks4povei4saik4sari5klubve4rahik4leraa4saiaa4sabi3klasi3klaaaa2r3õõl4mad4videaaara4like4sii5indevi4sakaa4lekaa4rajaa4rafiinit4aa4penaa4pekvoo5lui4kauti4karkaa4lelõi4su4a5andmi4kaluvu4su4aa4nataa4namii4vet4võ4liii4vesvõr4k5ii4nolii4nosvää4ruaa4meeiit5reii4tosaa4manaa4madii4tomaa2l3õõe4lanii4tehaal3t4ii4ranii4rauii4sevii4saniise4ltel4ke");
            put(7, "aali4kea5allikvää4re4a5ameeri4ka4reaan4duuaa4ra4b_ahe4li4ga4suki4k5elua5arter3aas5taa5a4sulval4ga45ilustuvaa4re45indeksini4masõranda5_al4gasinni4siu3s4porus5elek5enelasus5aste4pe4levi3s4peki3s4porii4last5istandpaa4tel5umbrohi5stsee5istutuae4ga4j5emand_pin4gisui4valaii4ga4sel5uss_jas4tiia5elanikaa4sisaadio5a5aadel_u5avaldkaitse5k5a4lus3a4gentotus4tap5laasikesk3a45igatsuket4te45elaniktäh4t3a3k4lamba5inime5klassi5klaveri5elaniör4dell4t5uss_p5lane_tu4s5ee5tsisteos5taas5tsensu5tsemen5tsellue5osalitsa4lan5eksam_i5avald5aistin4ko4riei5a4vajpoola4v_turba55kraana5krediii5aste_3k4reemora4miitoksi5k_inim5a5kviituei4siste5i4sa_lai5ek5ak4te4lta4se4ri5amet_4ta4retaku4maptal4las4ta4laja5kvali4la4sutala4masali4sana4liste5allee_al4le4hoon4dee5erakonlektri5l4ge4lesun4de45eeskir5amper_stu4s5aoo4listii4sik_5floora5streik4li4lus5statisäri4selä4ristebes4tis5olukore5esinee5e4pit5antiloloo4ram5skelet5skeem_ast4rake5elekts5istujs5i4sik4si4sa_s5inimes5i4ha_lus4tii5raalneää4rase5ääris_a5opera4s5eten4se4sin_aasta54ma4ju_4s5eksp4ma4sulsee4ta4se5aval5aparaah4ku4sus5avald4mi4siksas4tiimis4tii5salat_raa4ta4mmi4kalüle4masr5a4la_mär4gelnaa4r5a4na4mern5amiidnants5a5armast5armee_5artikkes4sistgne4te45granaaüü2l3a2_kusee4üma4rakasa4las4de4lekhal4laias5ema_nikkel5r4me4le3a4seturan4demasi4ala4ri4sa_a5slaavre4liitree4manree4ma_5ohvitsok5liinrat4seno4li4luola4lasäre4lis");
            put(8, "ratiiv5avis4ko4di5inimen5inimeneu4ri4met5draama_4s3a4la_raamatu5_raadio55skaa5laee4s5ist_antiik55ateljee5struktu5anatoomia5alane_lemmik5op5last_5kristal5orkeste5trikoo_5tsiitsi5plastik5kliiste5elektroi5s4tiili4va4luskumi4su4");
            put(9, "5elevaato5standarddep5ressi5etendus_5arvestusro5staati");
        }
    }), it("it", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "1b1c1d1f1g1h1j1k1l1m1n1p1q1r1t1v1w1x1z");
            put(3, "2’2e2w2bb2bc2bd2bf2bm2bn2bp2bs2bt2bvb2lb2r2b_2b’2cb2cc2cd2cf2ck2cm2cn2cq2cs2ct2czc2hc2lc2r2c_2c’_c22db2dd2dg2dl2dm2dn2dpd2r2ds2dt2dv2dw2d_2d’_d22fb2fg2ff2fnf2lf2r2fs2ft2f_2f’2gb2gd2gf2ggg2hg2l2gmg2n2gpg2r2gs2gt2gv2gw2gz2g_2g’2hb2hd2hhh2l2hm2hn2hr2hv2h_2h’2j_2j’2kg2kfk2h2kkk2l2kmk2r2ks2kt2k_2k’2lb2lc2ld2lgl2h2lk2ll2lm2ln2lp2lq2lr2ls2lt2lv2lw2lz2l_2mb2mc2mf2ml2mm2mn2mp2mq2mr2ms2mt2mv2mw2m_2m’2nb2nc2nd2nf2ng2nk2nl2nm2nn2np2nq2nr2ns2nt2nv2nz2n_2n’2pdp2hp2l2pn2ppp2r2ps2pt2pz2p_2p’2qq2q_2q’2rb2rc2rd2rfr2h2rg2rk2rl2rm2rn2rp2rq2rr2rs2rt2rv2rx2rw2rz2r_2r’1s22sz4s_2tb2tc2td2tf2tgt2ht2l2tm2tn2tpt2rt2s2tt2tv2twt2z2t_2vcv2lv2r2vv2v_w2h2w_2w’2xb2xc2xf2xh2xm2xp2xt2xw2x_2x’y1i2zb2zd2zl2zn2zp2zt2zs2zv2zz2z_");
            put(4, "_p2sa1iaa1iea1ioa1iua1uoa1ya2at_e1iuo1iao1ieo1ioo1iu2chh2chbch2r2chn2l’_2l’’2shm2sh_2sh’2s3s2stb2stc2std2stf2stg2stm2stn2stp2sts2stt2stv4s’_4s’’2tzktz2s2t’_2t’’2v’_2v’’wa2r2w1yy1ou2z’_2z’’_z2");
            put(5, "_bio1_pre12gh2t2l3f2n2g3n3p2nes4s3mt2t3s");
            put(6, "_a3p2n_anti1_free3_opto1_para1hi3p2n2nheit3p2sicr2t2s32s3p2n3t2sch");
            put(7, "_ca4p3s_e2x1eu_narco1_su2b3r_wa2g3n_wel2t1n2s3fer");
            put(8, "_contro1_fran2k3_li3p2sa_orto3p2_poli3p2_sha2re3_su2b3lu");
            put(9, "_anti3m2n_circu2m1_re1i2scr_tran2s3c_tran2s3d_tran2s3l_tran2s3n_tran2s3p_tran2s3r_tran2s3t");
            put(10, "_di2s3cine");
        }
    }), cs("cs", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "a11f1g1k1n1pu11vy11zé11ňó11š1ť1ú1ž");
            put(3, "_a2_b2_c2_d2_e2_g2_h2_i2_j2_k2_l2_m2_o2_p2_r2_s2_t2_u2_v2_z2_č2_é2_í2_ó2_š2_ú2_ž22a_a2da2ga2ia2ka2ra2sa2ta2u2av2aya2ča2ňa2ť2b_b1db1h1bib1j2bkb1m2bn1bob2z1bá1bí2bň2c_1ca2cc1ce1ci2cl2cn1coc2p2ctcy21cá1cí2cň1ců2d_1dad1bd1d1de1did1j2dkd1m2dn1dod1t1dud2v1dy1dá1dé1dě1dí2dň1dů1dý2e_e1ae1be1ee1ie2ke1o2ere1se1te1ue1áe2ňe1ře2šeú12f_f2l2fn2fr2fs2ft2féf2ú2g_2gngo12h_h2bh2c2hd2hkh2mh2rh1č2hňhř2h2ž2i_i1ai1bi1di1hi1ji1li1mi2ni1oi1ri1ti1xi1ái2ďi1éi1ói1ři2ši2ž2j_j2d1jij1j2jkj2m2jn2jp2jz2jď1jí2jž2k_k2dk2e2kf2kkk2l2kn2ks2kčk2ň2l_2lf2lg2lh1li2lj2lk2ll2ln2lp2lv2lz2lň1lů1lý2m_1ma1me2mf1mim2l2mn1mo2mp1mu2mv2mz2mčm2ž2n_2nb2nf2ngn1j2nk2nn2nz2nď2nónů22nž2o_o1ao1cog2o1ho1io1jo1lo1mo2no1oo1to2uo1xo2zo1čo2ňo1ř2p_2pkp2l2pn2pp2ptpá12pč2pš2pťqu22r_r1br1cr1d2rkr1l2rn2rrr1x2rzr1č2ró2rš2s_s2cs2d1se2sf1sis2js2k2sn1sos2p1sr2ss1sus2v1sé1sí2sň2sť1sůs2ž2t_1te2tf2tg1ti2tl2tm2tn1to2tpt2vt2č1té1tě2tř2tš1tů2u_u2b2ufu2ku2mu2nu2pu2ru2su2vu2zu2ču2ďu2ňu2šu2ž2v_2vkv2l2vm2vnv2p2vňwe22x_2xf2xnx1ty2ay2ey2sy2ňy2šyž22z_2zbz2ez2j2zl2ztz2v2zzzá12zč2zňz2řá1bá1dá1já1sá2ňá1řá2š2č_1ča2čb1če1či2čk2čn1čoč2p2čs1ču1čá1čí1čů2ď_1ďa1ďoé2dé2fé2lé2mé2sé2té2šé2žě1cě1lě2vě2zě1řě2šě2ťě2ží1bí1hí1jí1lí1rí1tí2ňí1ří2š2ň_2ňa2ňk2ňmň1só2z2ř_2řc2řdři12řk2řn1řoř2v2řz2řš2š_2šl2šnš2p2štš2vš2ň2ť_2ťk2ťm2ťtú2dú2kú2lú2nú2pú2tú2vú2zú2čú2žů1bů1cůt2ů2vů2zů2žý1bý1dý1hý1jý1lý2ný1rý1tý1uý1ř2ž_2žk2žl2žnž2v2žď2žň2žš");
            put(4, "_ch2_ná1_st2_us2_ut2_vy3_vý1_za3_zd2a3daa3dea3dia3doa3dua3dya3dáa3déa3děa3día3důa3dýa3gaa3goa3gua3gáah3va3ina3iva2jda2jmaj2oa3kea3kia3kla3koa3kra3kua3kya3káa3kéa3kóa3kůa3kýap3ta3raa3rea3ria3roa3rua3rya3ráa3róa3růa3rýa3saa3sea3sha3soa3sua3sva3sya3sáa3séa3sía3sůa3taa3tea3tia3toa3tra3tua3tva3tya3táa3téa3těa3tía3tóat1řa3tůa3týa3uja3učav3dav3taz3ka3zpa3čaa3čea3čia3čla3čoa3čua3čáa3čía3čůa3ňoa3ňua3říaú3t3ba_2b1cbe3pbis33bl_3blk2brib2ru2b1tbu2c3by_bys32b1č1bě_3bínb3řab1ří2bš2ce2u2ch_1cha3che2chl2cht1chu1chy1chá2chř2ck2c3lac3léc2tict2nc3tvc2těcuk11c2vda3dd2bad2bá2d1cde1xde2z2d1hd3kv3dl_d1lad3li1dlnd2lud1léd2lů1dmddo1ddo3hdo3pdo1sdo3tdo3čd1red3réd3rýd3tld3třdu3p2durd3ved3vld3vrd3vyd3vád3věd3víd3zbd3zdd3zn2d1č3dějd1řad1ří2dš2d3škd3št3dů_dů3sd2ž2e2are2břed1led3ve1hae1hee1hoe1hre1hue1hye1háe1hýe1jeej1mej1oej1uej3ve3kae3kee3koe3kre3kue3kye3káe3kée3kóe3kře3kůe1lae1lee1loe1lue1lye1láe1lée1líe1mle1mre1mye3máe1měe1míe3mře3můe1mýeo1seo3ze2plepy3e1rae1ree1rie1roer3se1rue1rye1ráe1rée1růe1rýe2ske2sles2me2stet1řeu3beu3deu3keu3meu3neu3peu3reu3teu3veu3zeu3že3vdevy3e3xue3zeez2te3zíe3zře1čte3ňoe3ňue3ňáe3óne3říe3šee3šie3šle3šoe3šíeú3neú3peú3teú3čf3líf1rige2s3gic3gin2g1mgu3mgu3vhe2she2uhe3x2hli2hlý2h2nh3ne2h1th2tě2h2vhyd1hys3ia3dib2li1chid2li1emi1eni1etif1ri2hlih3ni3imi2klik3milu3i3nai3nei3nii3noi3nui3nyi3nái3néi3něi3níi3nůi3nýi2psi1sais3cis1ti1syi3sáit1ri2tvi1umiv3di3zpiz1ri1člič3ti1íci1ími3šei3šiiš3ki3šoi3šui3šái3šíi3žai3žei3žii3žoi3žui3žája3dja3gj1b22j1cj3drj3dáj3důj3efj3ex2j1hj3kv2j1lj3maj3mi2jmíjne3j1obj1odj1ohj1opj1osj2ov2j1rj3sn2j1tj3tlju3pj1usju3tju3vju3zj1už2jv2j3vdj3vnj3zbj3zdj3zkj3znj3zp2j1čj3štj3šť2jú1jú3njú3čjú3ž3kaj3kat3kav3kač3kař2k1c3ket3kl_k3lék3lók3lý2k2mk3mě3kof3kovkr2s2k1tkt2r3kujku3v2k2v3kyn3kác3kár3kářk2ř23ků_1la_2l1b2l1c2l1dle2i1lej1lel3lio2ližl2kl2l1m1loslo3zl2pěls3n2l1t1lá_2l1č1lé_1lík1líř2lš2l3štlý2t2l2ž2m1b2m1cm2dl3me_me3x2mk22mleml3h2mlim3nam3nám3ném3nýmo2kmo2smoú3m2psmp2tmr2s2m1tmu3n2muš3má_má2sm2čemí1c2m2šmš3ť3mů_3mý_3na_na3hnat2na3zna3š2n1c2n1dne1dne1hne2jne3pne3zn3frng1l3nio2n1lno3z2nožn2sa2n1t2nub3ny_3nák2n1č2nív2níž2nš2n3što1bao1beob1lob1ro1buob3zo3béocy3od3bod1lod3vod1řo1e2oe3go2flo3gnoj2o2okaom2no3nao3neo3nio3noo3nuo3nyo3náo3něo3nío3nůo3nýo2pso1rao1reo1rio1roo1ruo1ryo1ráo3réo1růo3rýo1sao1sko1slo1syo3tío3třou3mou3vo3zaoz1bo3zeoz1ho3zioz3joz3koz1loz3mo3zooz3poz3to3zuo3zío3zůoč2ko3ňao3ňoo3ško3šlo3žl2p1c3pečp2kl3pl_pl3hp2nu3podpo3hpo3ppoč2pr2cpro1pr2sprů3p3tupá2c2př_při31ra_2rakr2blrca3r1harh3nr1hor3hur1há1ricr2kl2r1mro3h2r1sr2st2r1tr2thrtu31ru_1ry_ryd2rz3drz3l1rák1rářrč3t3ré_3rý_s2b2s3casch2s3cis3císe3h3sel3semset2se3zs3fo3sfés3fú3sic3sif3sik3sits3jus3ků3sl_3slns2lys1lís2mas2mos2nas2nes2ná2st_2stns2tvs2tás1tísy3csá2d3sáh2s2čs3čis3ťo1ta_1tajt1ao2t1b2t1c3te_2tihtiú32tiž2tk2t2klt2ká3tl_t1le3tlmtlu3t1lyt1lét2mat3níto3b2toj2trč2trý2t1sts2t2t1t1tu_1tuj2tup2tve1ty_3tá_t3či2tčí3tém2těh2těp1tíc1tím2tín2tírt1řut2řát3št1tý_1tým1týř3týšu2atu3bau3beu3biu3bou3buu3báu3bů2u2du3deu3diu3dou3duu3dyu3díu2hlu2inu2jmu3keu3kou3kuu3kyu3kůul1hu3mau3meu3miu3muu3má3umřu3neu3nou3nuu3něu3níu3nůu3pau3peu3piu3puu3pyu3páu3pěu3píu3půu3rau3reu3riu3ruu3rá1urču3růus1lu3sou3syu3sáu3síu3sůu3viu3vuu3zeu3ziuz1lu3zou3zuu3zíu3čau3čeu3čiu3čouč3tu3čuu3čáu3číu3šeu3šiu3šou3šuu3šáu3šíu3žeu3žou3žuu3žáu3ží2v1b2v1cv2ch2v2dv3di3venve2pv2kr2vlovo3bvo2svou3vr2cv1ro2vs2v1sk2v2tvy3cvyp2vy3tvy3čvyš2v2z22v2čv3čáv3čí3vín2vřív2š23výsvý3tv2ž23war3xovy2bly2chy2dry2gry3hny2kly3niy2přyr2vy3say3sey3siy3smy3soy3spys2ty3suy3svy3syy3sáy3séy3síyu3žy3vsy3zby3zdy3zky3zny3zpyč2kyř3by3říy3šey3šiy3škyš1ly3šoy3špy3šuy3šíy3ždza3hza3iza3jza3kzat2za3zza3šz2by2z1c2z2dz3dize3hzet2zev2ze3z2z2fz1ház3jí2z2kz3kyz3kéz3kůz3ký3zl_z2m22zmez3mnz3my2z2nz3noz3nuz3nyz3néz3něz3níz3ný2z2pz3ptz3tř3zu_zu3šz3vi3zy_záh23zápzá3zzáš2z3čl2zš2z3škz3štzú3čzú3žzů3sá2blá2dlád1řá1haá3heáh1láh3ná1hoá1hrá1háá1laá1leá1loá1luá1lyá3léá1líá3myá3méá1měá3míá3mýá1raá1reár2má1roá1ruá3růá2scá2smá2stát3kát1rá1tuá1tyá1tíá3týáz3ká3šeá3ší2č1c3če_če1cč3koč3kuč3ky2č1mč2neč1sk2č2t3čtvč3tí2ď1t3ďujé3dié3doé3foéf1ré2klé3maé3meé3mié3moé3mué3můé3taé3toé3táěd3rě3haě3heěh3ně1hoě3huě3hůě3jaě1jeě1joě3jůě1raě1reě1roěr3sě1ruě1ryě1růěs3kěs3nět1lě1trět3vě1tíě3vaě3veě3vlě3voě3vuě3váěv3čě3zeě3ziěz3ně3zoě3zíě3šeě3šiě3šoě3šuě3šáě3šíěš3ťě3ťoě3žeě3žiě3žoě3žuě3žííb3říd1lí2hlíh3ní2krí1máí3méí1měí1saít3kíz3kí3šeí3šií3šoí3šíňa3d3ňov2ň1tó3zaó3zió3zoó3zy2ř2bře1h2řesřia3ři3hřis2ři3zři3řř2kl2ř1l2ř1m2řou2ř2p2ř1s2ř1t2ř1č2řídří1sř3štšab32š1c2š2kš3kaš3ke3škrš3kyš2laš2liš2lošlá2š2léš2lý2š1m2š1sší3dš3ší2š2ťš3ťoš3ťuš3ťá3ťalú2c2úz3k3účeů1hlů3jdů1leů1myů1měů1raů1s2ů2stů3vaů3voů3věů3zoů3žeů3žiů3žoý1mlý1měý3noý1s2ý2ský3zký3znýš3lža3d3žač2ž1b2ž1c2ž1d3žil3žlo2ž1mžon22ž1t");
            put(5, "_a4da_a4de_a4di_a4do_a4dé_a4kl_a4ko_a4kr_a4ku_a4ra_a4re_a4ri_a4ro_a4ry_a4rá_a4sa_a4se_a4so_a4sy_a4ta_a4te_at3l_a4to_a4tr_a4ty_a4ve_cyk3_dez3_d4na_dne4_d4ny_dos4_d4ve_d4vě_d4ví_e4ch_e4ko_es3k_es3t_e4ve_f4ri_h4le_h4ne_i4na_i4ni_i4no_is3l_j4ak_j4se_j4zd_jád4_k4li_k4ly_ne3c_neč4_ne3š_ni2t_n4vp_o4bé_ode3_od3l_o4ka_o4ko_o4na_o4ne_o4ni_o4no_o4nu_o4ny_o4ně_o4ní_o4pe_o4po_o4se_o4sl_ot3v_o4tí_o4tř_o4za_o4zi_o4zo_o4zu_o4šk_o4šl_o4ži_p4ro_p4rý_p4se_pu3b_rej4_re3s_ro4k_s4ch_s4ci_sem4_s4ke_sk4l_s4ká_s4le_s4na_s4ny_s4pe_s4po_s4tá_s4ži_u4ba_u4be_u4bi_u4bo_u4de_u4di_u4do_u4du_u4dí_uh4n_uj4m_u4ko_u4ku_ul4h_u4ma_u4me_u4mi_u4mu_u4ne_u4ni_u4pa_u4pe_u4pi_up4n_u4po_u4pu_u4pá_u4pě_u4pí_u4ra_u4ro_u4rá_u4so_u4st_u4sy_u4sí_u4vi_u4ze_u4če_u4či_u4čí_u4še_u4ši_u4šk_uš4t_u4ší_u4ži_už4n_u4žo_u4ží_v4po_v4zá_v4ži_y4or_y4ve_zar2_zač2_z4di_z4dr_z4ky_z4mn_z4no_z4nu_z4ně_z4ní_z4pe_z4po_z4tř_z4ve_z4vi_č4te_še3t_š4ka_š4ke_š4ky_š4ťo_š4ťá_ú4důaa3t2ab4lýab3riab4sbab2stac4ciad2laa4dlia4dláa4dléad4mead4muado4sad3ria3drža4dužad3voad4úzad4úřae4viafi2aag4faag3roah4liai4reaj4meak4nial4fbal4klal4tzal3žíam4bdam4klam4nuamo3sam4žia4naean4dtaneu4an4scan4sgan4slan4sman2span4svan4tčan4žhao4edao4hmao4tčap4r_a4psoa4př_ar4dwa4rerar4glar4kha4roxar3star2vaar3š2ar4šrarůs3a3sinas3náas3pia4stkas4tmas3tvat4cha4tioat4klat3loat3rea4truat4ráat4thau4gsauj4maus3tav4d_av3loa4vlua4vlíav4tiay4onaz3laaz4léaz3niač4máaře4ka4špla4špyba4brba3kaba4sebe4efbe4etbej4mbeu4rbe2z3beze3bi2b3bist4bi4trbl4blb2lemb2lesb4lánb2lémbo4etbo4jmbo4okbo4trbou3sbo4škb2ralb2ranb4roubroz4b3ru_b3rubb2rán2b1s2bs3trbtáh4bu4enby4smby4tčby4znbé4rcbě3tabí4rcb3ře_bře4scad4lca4escech4ced4lcelo3ce4nsce4ovce4pscer4v4che_ch4lych4mb2ch3n4chtech4u_cik4lc4ketco4atco4mmco4žpctis4ct4lací4plda4jšda4klda4trdch4ldd4hade3hnde3jdde3klde3kvde2nade2ozde3slde4smde4sode2spdes4tde4xtde3zndez3ode3čtde4žpdi4gg4dinddis3kdi4sodj4usd4labd4lakd2loud3lučd4láž2d1lídmýš44dobldo3bydo3bědo3býdod4ndoj4m4dokn4dolydo3mndo4pcdop4ndor2vdos4pdo3ukdo3učdo3z2doz4ndoč4tdo4žp4drand4rapd4rend3rosd3roud3rošdr4scd3rušd4rýv2d1s2ds4kůds4podum3řdu3nadu4pndu3sidu4í_d4vacdy4sudře4kd4řepd4řevd2řítea3dreb4erebez2eb4lie4ch_e4chme3choe2chre3chve4chťed4beed4kved2mae3dmned4říee4thee3xieg4giehno4eh4něej3age3jase3jede3jezej3ine3jisej3moe3jmue4klye4lauel4dvel4zee4mlíemo3kem3žeen4dven4scen4sient3reo3byeod3leo4due4oleeo2steo4třeo4zbeo4zdeoše3epa3te4pniep2noe4pnýep4tlep4tmep4tne4ptuer4a_er4s_er4sne4sage2scee4sinesi4ses4k_es3kyes3kée4slye4sp_es4pee4st_e4stee4tkie4tkre4tlie4tlyet3riet3roet3růet4úneu3cteu4m_eu4r_e4uraeu4rgeu3s2eu4tseve4še3v2ke4vskex4taey4orey4ovez4apez4boez3deez3duez4děez4ejez4elez4erez4esez4ezez4ešezis4ez4itez4leez4náez4něez4pyez4ácez4áhez4čeez4řeeč4tee4čtie4čtíeře4keř4kue4škaeš4láeš4toeúmy4ežíš4fe4infene4fe4uefi4emfi4flfló4rfm4nof4ranf4ras3frekfs4tefu4chga4učghou4gi4ímg4lomg4noig4nosgo4hm3grafgu4elgu4itgu4m_gus4tha4agha4arha4blha4brha3dlha4kehas3tha4ydhe4brhe4idhej4shi4anhi3erhi4ghhi4re4hla_h4ledh3lenh3lobh3loph3lovh3luj2h1ly4hlá_h4lásh3lí_4hlíkh4nedh3nivh4noj3hněd4hovehra4ph4tinh4títhu4chhu3mohu4tňhy4dohy4pshy4zdhř4byhý4blia3g2i4al_ias4tia4tri2b1ri4chžid4gei4dlýig4nei3hl_i4hliih4naijed4ij4meij4miik3leik4ryi4kveik4úřil4bai4lnui4mlai4mlyi4munina3din4cmin4dl3infein4ghin4gpin4gsin4gtin4špio4skiro4sis4chis4k_is3kais3keis3kris3kuis3kvis3kyis3lois3léis3plis3pois4thist3vis3tíit4rhit4rpit4seit4suix4tdič4tlič4toiř4kliř4čeiš4kriš4kviš4toja2b2jac4kja4cqj3aktj3dobj3dokj3dosjd4říjech4jg4raji4chjih3lji4mžj4inajis3kji2zvjod2řj4orajo3svj3ovljpor42j1s2j4semj4si_j4sk_js4kojs4kájs4poju4anju3naju3spju4t_ju4xtju3žijád2rjš4tika4blka4chka3dlka3ka3kami3kaněka2pska4pvka2přkas3tka4učkaš3lka4špke4blke3joke4prke4psk3lejk4libk3lic4klo_k3los2k3lyk3lá_kna4sko3byko4jmko2přko4skko3zá4kroak3robk3rofkr4ú_kuch4ku4fřku4hrku3seku3siku3suku4thk4vrňky2prkyp3řky4znká4plk3řejkš4tila4brlab4sla3kala4nqla4psla4všla4y_la2zmld4nele4adle4auleh3nle3jole4prle4psle4scle4smle4svlet3mle2trle4tčle4ukle4vhle4vkle3xilez3n3lhanli4azli4blli4bvli4dmlind4li4tňli4vrl4katlk4nul4nullo3brlo4idlo4islo3splo3svlo2trlo4třlo4u_loz4dlo4šk2l1s2l4slalst4nl4stílt4ralt4rult4rylu4idlu4j_lu4k_lu4lklu4m_lu4mnlu3prlu3valu3vllu3vylu3vílá4jšlá4všlí4pllí4znl4štýmaj4sma4klma4kr4maldmas3kmat3rma4všmaz3l2m1d2me4gome4ismh4lemid3lmik3rmi4xt3m2klmk4lamk4li4mla_ml4h_ml4scml4sk4mlu_mna4sm4nohm3nosm4noz3množm4nézm3nějmod3rmo2hlmo4s_mot3ř4moutmoza4mo3zřm4plompo4smp4se2m1s2m4stlmu4flmu4n_mu4ndmu4nnmu4nsmu4nšmy4škmálo3mí4rňmš4čina3chna4dona4emna4h_na3jdna3kana3p2na3s2na4s_na3tlna3třnaz4kna4zšna4č_naž4nn4chcnd4hindo4tnd2rend4rind4říne4glnej3tnej3une3klne3kvne4m_ne3s2ne4s_ne4ssne3tlnet4rne3udne3v2ne4v_nez4nne3škne3šťng4lang4leng4lín4grong4vinik4tni4mrni4mž3nisk2nitřno3b2no4bsno3hnno4hsno4irno4mžno3smnot4rno4zdno4šk2n1s2ns3akns4kon4socns3pont4r_nt3runt3ránu4ggná3s2ná4s_nš4ťooang4obe3jobe3sobe3zob4rňobys4o4chlo2chroc4keoc4koo4ct_oct3noc4únode3pode3so4docodos4od3raod3růo3držoe3tioh4neoi4ceo4into4jaro4jmio4jmuo4jmůo4juzok2teol4glol4toom4klona4soo4hřoote2o4ptuopá4to4př_o4raeor4dmor3stor4váorůs3o4saiose4sosi4do4skuosk3vo4skáo4skýos4laos4lios4lýos3moos4muo4st_o4stgo4stmo4stéo4stšo4stýot4klo4tlýoto3sot3root3víot3řiou3běou3děou4flou4ilou4isou4k_ou3kao4uklou3krou3káoup3noupo4ou4s_ou3saou3seou4skou3smou4tvou4vlou4vnouz3do4učkou3žio4vskovy2po2vštoz4d_oz3dáoz3děoz3díozer4oz4koo4zn_oz4pyoz4pěoz4píoz3rooz3ruoz3růo4zutoz3vroz3váozů4soč4kaoři2so4škuo4škyoš4láoš4mooš4tioš4ťuož4mopa4edpa4espa4klpa3sipa4t_pe4alpede4pe4igpe4npperi3pi4krpi4plpl4h_4plo_po1b2po3c2poly3po3m2po4mppo4olpo4p_po4pmpo1s2pos4ppo3t2po4t_po4tnpo3ukpo3učpo3už3po3vpo3z2po4zdpo3čkpo3řípo4šv4pra_prob2pro3ppro3z4pránpse4s2p1skp4sutp4tejp4terp4tevpt4rip4tá_pu4dlpu4trpyt3lpád3lpá4nvpá4slpé4rhpře3hpře3jpře3zpřih4pš4tira4brra4emra4esra4ffra4hlra4hmra4jgra4jšra4nhra3sira4vvra4wlra4y_ra4yora4ďm4ražir3char3chorc4kir4dlardo2sre4adre4aured4rre4etre3klre4mrre2sbres3lret4rre4umr3hl_ri4bbri4dgri4drri4flri4ghri4zmr4miorn4drro4adro3byrod2l3rofyro4h_ro4jbro4kšrom3nro2sbro3svro3tiro3tlro4tčro3vd3rovýroz3droz3nro4zoroz3vro3záro4čprpa3drr4harr4hor4stur4trárt4smr2t3vrt4zuru3seru3sirus3kru3žirych3rys3try4zkry4znry4í_ry4škrád4lrá4džrá3rirš4nírů4m_rů4v_rý4znsa4pfsa4prsas3ks3ce_sch4lsch4nsci4ese4ause4igse4ilsej4mse4kuse3lhse3s2ses4kse4ssse3tkse3třse4urse3čtsi4fl4skacs4kak4skams4kok2skonskos44skotsk4rask4rusk4ry4skvesk4vos3káns4lavs3le_s4leds3lems3lens3lets4libs3ly_s4meks3nats3ne_sn4tls3ná_s4nídsob4lso3brso4skso4tvsou3hsou3ssouz4so4šks4polss4sr4sta_s3tajs2tanst4at4stecs4tepst4er2stil4stičst3lo4sto_4str_4strnst4ve3ství4sty_s4tyl3styš4stá_s3tář4stě_s4těd3stěhs2těrs2těž2stí_su4basu4bosuma4su3vesá2klta2blt2a3dta4jfta4jg4talt4tand3taně2tarktast4ta4čkte4akte4flte4inteob4tep3lters4te4trte4ucte4urte4utti4grti3kltin4gti4plti3slti4tr2titutiz4r4tizít4kalt4kattk4latk4li4tkně4tla_tles3t3lo_t4loutlu4sto4astob4lto3drto4hmto4irtol4sto4ol4top_4topt4topu2torn2toupt4reat4reftre4ttrip4t4ritt4rogt3rolt4rou4trunt4rus4trášt3růmt3růvts4kott4chtt4ritu4fftu4lktu4r_tu3rytu4s_tu4ť_tu3ži2t3vit4višt4výcty4gřty2laty4řety4řhty4řjty4řoty4řrty4řútá4flté2bl2těnn4tíc_4tícet4řebt2řelt2řict3řiltř4ti3třábtří4stš4tiubs4tu3bí_uc4tíu3druue4fauh3láuh3nou3ka_uk4ajuk4aluk4atuk3lauk3leuk4á_ul4faul4píum4plum4ruun4dlun4žru3pln2u3rou3ry_us3kyus3káus3kéus3kýus2lou4steu4styu4stéu4stěu3střu4stšu4stýu3su_u4trou4tráuš4kluš3tíva3dlva4jťva4klv4dalv4děkv4děčve3jdve3psvep3řves3lve4smves4pvi4chvide2vi4drvi4etvi4krvi2tr4vle_4vlemv4nadvo4icvo4javo4jbvo4jdvo4jjvo4jmvo4jřvo4třvous2vr2dl4vrnyvr4stv3stvvy3d2vy3s2vy4snvys4tvyč4kvy4š_vy4šmvy4ššvy4žlvz4novz4névz4něvz4nívá3riv4čírvě4cmvíce3v3řínvše3s3vý3zwa4fdwa4rexand4xisk4xt4raxy4smyb3riy4chry2d1lyd4láyd4y_yh4neyj4mayj4meyk3layk4lyym4klyna4sype4ryp4siyp4táys3luys3teyst4ryt4meyvě4tyz4něyz4níyz4poyřk4nyř4čezab2lza4bsza4dkza3dlza4dnza4jkza4ktzal4kzam4nza3p2za3s2za3tlzat4rza4utzaz4nza4zšza4č_zaš4kza4šszban4zbys4zd4rezd4víze3p2ze3s2zes4pze3vnze4z_z4inez3ka_zlik3z3ly_z4měn3znakz4nalz3ne_z3nicz4nělz4nítz4nívzo4trzo4škz4pát3zrak2z1s2z4trázu3mozu3mězu3mízva4dz3vařzvik4zv4něz3vodz3vojz4vonzv4roz4vánz4věsz3víjzá3s2zřej3z3řezz3řešzš4ka2z2ú1áb4ryá4bř_á3choádo4sá3hl_á4jmuáj4můá4kliák4niáne4vá2s3kás4k_ás4klás4kná2slaás4lyás4poáv4siáv4síáz3niáz4viář4keář4kůča4brčes3kč3ka_čs4lačs4srčt4la4čtěnčís3lďs4te4ére_ě3hl_ěh3loě4kléě3k2těra3děrs4tět1a3ět4acět3raět3říěš4ťsí3choích4tíjed4íj4můí2s3kís4klís4knís4l_ís3leís4lnísáh2íz3daíz3deí3znařa4plřa4ďmře3chře3jdře3klře3kvřeo4rře3p2ře4p_ře4pkře4pčřer4vře2spře4srře3tlřet4řře3zdře3zk4řezlře3čtři4h_ři4hnři4jďři4l_ři4lbřil2n4řineři4v_ři4vkři4vnřič4tři4š_řk4lařk4liřk4lyřk4nořs4tořá4plřá2slří4křřš4tiša4vlšej4dšep3tši4mr4škovšk4roš3ku_š3livšmi4dš4tipšt4kašt4klš4těkš2těsš4těvš4típťáč4kúj4maút4koúře4zúš4tiůr4vaůr4vyůs3teů3tklý3choýd4laýt4kuýt4kyý4vliý4zvuýč4něža4tvže2b3žeh3nže4mlže4zgži4dlži4jmži2vlžk4niž4lic2ž1s2žá4bržá4nrží4znžš4tižš4tě");
            put(6, "_ale3x_as3t3_je4dl_kří3d_le4gr_li3kv_moud3_na3č4_nář4k_od3rá_os4to_os4tě_ot3rá_ově4t_oz3do_pa4re_pa3tř_po3č4_roze3_roz3r_ru4dl_se3pn_va4dl_zao3sab3lona3d3ra3a3dvaa4nameane4skao4střas4tatat3ronat3rova4tří_ba4chr4chalgcien4c4dbat_3dch4nde4bredej4mode3strd3lou_4doboj4do4dd4do4djdomoh44do4čn3drobndře4pne3chl_eilus3ej3eleeju3steoch3repoč3te4s4knes3ku_e4s3lies3tižes4toles3táneu4rase4u4t_eu4traevy4čkevě4trezaos3ez3dovez4ed2eč4kateštíh4ha4dlahatos44h3lo_3hodinho3strhos4tě4hovna4hovny4hovná4hovněhy2t3rid4lo_ik3lo_ilič4nis3ko_i3slavis4talis4tatié4re_jbyst3jez3díjit4rojmou3dj1o3z2jpo4zvjpříz4j4s4kůj4s4mej4sou_j4soucj4s4teka2p3lka2p3rkast3r4k3la_4k3li_ko2t3vkous3k4la3silech3t4lejšk4lenchlepa3dlepo4slet4lilo3střma4tramet3remezi3smys3lonam4nene3h4nne4krones4le4nestino4skyno3strnst4rant4lemob3řezodej4modo4tkod4ranofrek4oje4dlo4jmovont4raopoč3topro4sopřej4o4s3keos4toros3trůoze3d2pat4ripes3t3pe4tra4p3la_4p3li_po3drupo3drápost4rpoč3tepra3stpro3t4pře3t4pře3č2rast4rre3kviretis4ric4kurna4všro3d4rromy4sropát4ro4skvro4skyrově4trs3tvěrs3tvý3rvanírys3kyrůs3ta3schopser4vase4střsig4nosi3ste4s3la_s4liči4s3lo_spro4ss4teros4tichs4tink4stit_s4tona4stou_4strams4trik4strács3třejsych3rsy4nesta3str4tenémtes3tatis4tr4t2kant3rant4tric_tro4sk4trouh4troň_4t4ružt3rálnt4vinntě3d4ltřeh3nupe2r3ve3dleve3stave3t4řve2z3m2v3la_vrst3vvy4dravě3t4aví4hatv3ští_y3klopymané4z4doba4zerotzlhos4ztros3zá4kl_ác3ti3ázni4cč4tenýě4trají3t3řeí3z3nií3zněnře4dobře4kříře3skaře3skořes3poře3staře3stuře3stáře3stř3ři4t_š3k3li4š3kouůs3tánýpo3č4");
            put(7, "_dneš4k_mi3st4_no4s3t_os3t3r_polk4la4stru_b4roditckte4rýdob4ratdos4tivenitos4epro4zře4strouevyjad4evypá4t4kličkamš4ťan_nte4r3aonář4kaopře4jmovi4dlapodbě4hpod4nes4rčitý_se4strase4stru4stupnitac4tvovrs4tvězdně4níz4dobnýádos4tič4tené_č4tový_ů4jmový");
        }
    }), fr("fr", 3, 3, new HashMap<Integer, String>() {
        {
            put(2, "1ç1j1q");
            put(3, "1gè’â41zu1zo1zi1zè1zé1ze1za’y4_y41wu1wo1wi1we1wa1vy1vû1vu1vô1vo1vî1vi1vê1vè1vé1ve1vâ1va’û4_û4’u4_u41ba1bâ1ty1be1bé1bè1bê1tû1tu1tô1bi1bî1to1tî1ti1tê1tè1té1te1tà1tâ1ta1bo1bô1sy1sû1su1sœ1bu1bû1by2’21ca1câ1sô1ce1cé1cè1cê1so1sî1si1sê1sè1sé1se1sâ1sa1ry1rû1ru1rô1ro1rî1ri1rê1rè1ré1re1râ1ra’a41py1pû1pu1pô1po1pî1pi1pê1pè1pé1pe1pâ1pa_ô41ci1cî’ô4’o4_o41nyn1x1nû1nu1nœ1nô1no1nî1ni1nê1nè1né1ne1nâ1co1cô1na1my1mû1mu1mœ1mô1mo1mî1mi1cœ1mê1mè1mé1me1mâ1ma1ly1lû1lu1lô1lo1lî1li1lê1lè1cu1cû1cy1lé1d’1da1dâ1le1là1de1dé1dè1dê1lâ1la1ky1kû1ku1kô1ko1kî1ki1kê1kè1ké1ke1kâ1ka2jk_a4’î4_î4’i4_i41hy1hû1hu1hô1ho1hî1hi1hê1hè1hé1he1hâ1ha1gy1gû1gu1gô1go1gî1gi1gê_â41gé1ge1gâ1ga1fy1di1dî1fû1fu1fô1fo’e41fî1fi1fê1fè1do1dô1fé1fe1fâ1fa’è41du1dû1dy_è4’é4_é4’ê4_ê4_e41zy");
            put(4, "1f2lab2h2ckg2ckp2cksd1s22ckb4ck_1c2k2chw4ze_4ne_2ckt1c2lad2hm1s22cht2chsch2r2chp4pe_1t2r1p2h_ph44ph_ph2l2phnph2r2phs1d2r2pht2chn4fe_2chm1p2l1p2r4me_1w2rch2l2chg1c2r2chb4ch_1f2r4le_4re_4de_f1s21k2r4we_1r2h_kh44kh_1k2h4ke_1c2h_ch44ge_4je_4se_1v2r_sh41s2h4ve_4sh_2shm2shr2shs4ce_il2l1b2r4be_1b2l4he_4te__th41t2h4th_g1s21g2r2thl1g2l2thm2thnth2r1g2n2ths2ckf");
            put(5, "2ck3h4rhe_4kes_4wes_4res_4cke_éd2hi4vre_4jes_4tre_4zes_4ges_4des_i1oxy4gle_d1d2h_cul44gne_4fre_o1d2l_sch44nes_4les_4gre_1s2ch_réu24sch_4the_1g2hy4gue_2schs4cle_1g2ho1g2hi1g2he4ses_4tes_1g2ha4ves_4she_4che_4cre_4ces_t1t2l4hes_l1s2t4bes_4ble__con4xil3lco1ap4que_vil3l4fle_co1arco1exco1enco1auco1axco1ef4pes_co1é2per3h4mes__pe4r4bre_4pre_4phe_1p2né4ple__dé2smil3llil3lhil3l4dre_cil3lgil3l4fes_");
            put(6, "’in1o2rcil4l4phre_4dres_l3lioni1algi2fent_émil4l4phle_rmil4l4ples_4phes_1p2neuextra14pres_y1asthpé2nul2xent__mé2sa2pent_y1algi4chre_1m2nès4bres_1p2tèr1p2tér4chle_’en1o24fles_oxy1a2avil4l_en1o24ques_uvil4lco1a2d4bles__in1a2’in1a21s2por_cons4_bi1u2’as2ta_in1e2’in1e2_in1é2’in1é21s2lov1s2lavco1acq2cent__as2ta_co1o24ches_hémi1é_in2er’in2er2s3homo1ioni_in1i2’in1i22went_4shes__ré1a2_ré1é2_ré1e2_ré2el_in1o2ucil4lco1accu2s3tr_ré2er_ré2èr4cles_2vent__ré1i22sent_2tent_2gent__ré1o24gues__re1s24sche_4thes_’en1a2e2s3ch4gres_1s2cop2lent__en1a22nent__in1u2’in1u24gnes_4cres_wa2g3n4fres_4tres_4gles_1octet_dé1o2_dé1io4thre__bi1au2jent__dé1a22zent_4vres_2dent_4ckes_4rhes__dy2s3sub1s22kent_2rent_2bent_3d2hal");
            put(7, "a2g3nos3d2houdé3rent__dé3s2t_dé3s2pé3dent_2r3heur2r3hydri1s2tat2frent_io1a2ctla2w3re’in2u3l_in2u3l2crent_’in2uit_in2uit1s2caph1s2clér_ré2ussi2s3ché_re2s3t_re2s3s4sches_é3cent__seu2le’in2ond_in2ond’in2i3t_in2i3t’in2i3q_ré2aux_in2i3q2shent__di1alduni1a2x’in2ept2flent__in2eptuni1o2v2brent_co2nurb2chent_2quent_1s2perm1s2phèr_ma2c3kuevil4l1s2phér1s2piel1s2tein1s2tigm4chles_1s2tock1s2tyle1p2sych_pro1é2_ma2r1x_stil3lpusil3libril3lcyril3l_pré1s2thril3l_mé3san_pré1u2_mé2s1i_pré1o2_pré1i2piril3lpupil3lâ2ment__pré1e2_pré1é2_pré2au_pré1a22prent_2vrent_supero2_di1e2npoly1u2è2ment_poly1s2poly1o2poly1i2poly1è2poly1é2poly1e2poly1a2supe4r1capil3l2plent_armil5lsemil4lmil4letvacil4l_di2s3h3ph2tis2dlent_a2s3tro4phres_l2ment_i1è2drei1arthr2drent_4phles_supers2ô2ment_extra2i2phent_su3r2ah_su2r3hextra2chypo1u21alcool_per1u2_per1o2_per1i2_per1é2hypo1s2_per1a2hypo1o2hypo1i2hypo1é2_pen2tahypo1e2hypo1a2y1s2tome2s3cophyperu2hype4r1hypers2hypero21m2némohyperi21m2nési4chres_a1è2drehyperé2hypere2hypera2’oua1ou_oua1ouo1s2tomo1s2timo1s2tato1s2tasomni1s2tung2s3_dé3s2c2blent__bio1a2télé1e2télé1i22clent_télé1s22guent_1é2nerg2grent_2trent__dé2s1œ2t3heuro1è2dre2gnent_2glent_4thres__bi1a2t1é2drie_bi1a2c_i2g3nin3s2at_’i2g3ni2ckent__i2g3né’ab3réa’i2g3né_ab3réa_per1e2");
            put(8, "_ma2l1ap_dy2s1u2_dy2s1o2_dy2s1i2n3s2ats__dy2s1a2distil3l1é2lectrinstil3l1s2trophe2n1i2vro2b3long1s2tomos_ae3s4ch’ae3s4ch_eu2r1a2ombud2s3’eu2r1a2_mono1s2_mono1u2o1s2téro_mono1o2eu1s2tato1s2tradfritil3la2l1algi_mono1i2_mono1é2_ovi1s2c’ovi1s2c_mono1e2_mono1a2co1assocpaléo1é2boutil3l1s2piros_ré2i3fi_pa2n1ischevil4l1s2patiaca3ou3t2_di1a2cé_para1s2_pa2r3héco1assur_su2b1é2tu2ment_su2ment__su2b1in_su2b3lupapil3lire3pent_’inte4r3_su2b1urab3sent__su2b1a2di2s3cophu2ment_fu2ment__intera2au2ment_as2ment_or2ment_’intera2_intere2pé1r2é2q_péri1os_péri1s2ja3cent__anti1a2_péri1u2’anti1a2er2ment__anti1e2ac3cent_ar2ment_to2ment_’intere2ré3gent_papil3leom2ment_’anti1e2photo1s2_anti1é2_interé2’anti1é2_anti1s2’anti1s23ph2talé’interé2ri2ment__interi2’interi2mi2ment_apo2s3tri2s3chio_pluri1ai2s3chia_intero2’intero2_inte4r3po1astre_interu2’interu2_inters2ai2ment_’inters2papil3la_tri1o2n_su2r1a2_pon2tet_pos2t3h_dés2a3mes3cent__pos2t3r_post1s2_tri1a2tta2ment__tri1a2nra2ment_is3cent__su2r1e2_tri1a2cfa2ment_da2ment__su3r2et_su2r1é2_mé2s1es_mé2g1oh_su2r1of_su2r1ox_re3s4ty_re3s4tu_ma2l1oc’a2g3nat_dé2s1é2_ma2l1entachy1a2_pud1d2ltchin3t2_re3s4trtran2s3p_bi2s1a2tran2s3hhémo1p2té3quent__a2g3nat_dé2s1i2télé1o2bo2g3nosiradio1a2télé1o2ppu2g3nacru3lent__sta2g3nre3lent__ré2a3le_di1a2mi");
            put(9, "_ré2a3lit_dé3s2o3lthermo1s2_dé3s2ist_dé3s2i3rmit3tent_éni3tent__do3lent__ré2a3lisopu3lent__pa3tent__re2s3cap_la3tent__co2o3lie_re2s3cou_re2s3cri_ma2g3num_re2s3pir_dé3s2i3dco2g3nititran2s1a2tran2s1o2_dé3s2exu_re3s4tab_re3s4tag_dé3s2ert_re3s4tat_re3s4tén_re3s4tér_re3s4tim_re3s4tip_re3s4toc_re3s4toptran2s1u2_no2n1obs_ma2l1a2v_ma2l1int_prou3d2hpro2s3tativa3lent__ta3lent__rétro1a2_pro1s2cé_ma2l1o2dcci3dent__pa3rent__su2r1int_su2r1inf_su2r1i2mtor3rent_cur3rent__mé2s1u2stri3dent__dé3s2orm_su3r2ell_ar3dent__su3r2eaupru3dent__pré2a3lacla2ment__su3r2a3t_pos2t1o2_pos2t1inqua2ment_ter3gent_ser3gent_rai3ment_abî2ment_éci2ment_’ar3gent__ar3gent_rin3gent_tan3gent_éli2ment_ani2ment_’apo2s3ta_apo2s3tavélo1s2kivol2t1amp_dé3s2orp_dé2s1u2n_péri2s3ssesqui1a2’ana3s4trfir2ment_écu2ment_ser3pent_pré3sent_’ar3pent__ar3pent_’in1s2tab_in1s2tab’in2o3cul_in2o3culplu2ment_bou2ment_’in2exora_in2exora_su2b3linbru2ment__su3b2é3r_milli1am’in2effab_in2effab’in2augur_di1a2cid_in2augur_pa2n1opt’in2a3nit_in2a3nit1informat_ana3s4trvanil3lis_di1a2tom_su3b2altvanil3linstéréo1s2_pa2n1a2fo1s2tratuépi2s3cop_ci2s1alp1s2tructu1é2lément1é2driquepapil3lomllu2ment_");
            put(10, "1s2tandardimmi3nent__émi3nent_imma3nent_réma3nent_épi3s4cope_in2i3miti’in2i3miti_res3sent_moye2n1â2gréti3cent__dé3s2a3crmon2t3réalinno3cent__mono1ï2dé_pa2n1a2méimpu3dent__pa2n1a2ra_amino1a2c’amino1a2c_pa2n1o2phinci3dent__ser3ment_appa3rent_déca3dent__dacryo1a2_dé3s2astr_re4s5trin_dé3s2é3gr_péri2s3ta_sar3ment__dé3s2oufr_re3s4tandchro2ment__com3ment__re2s3quil_re2s3pons_gem2ment__re2s3pect_re2s3ciso_dé3s2i3gn_dé3s2i3ligram2ment__dé3s2invo_re2s3cisitran3s2act’anti2enneindo3lent__sou3vent_indi3gent_dili3gent_flam2ment_impo3tent_inso3lent_esti2ment_’on3guent__on3guent_inti2ment__dé3s2o3défécu3lent_veni2ment_reli2ment_vidi2ment_chlo2r3é2tpu2g3nablechlo2r3a2cryth2ment_o2g3nomonicarê2ment__méta1s2ta_ma2l1aisé_macro1s2célo3quent_tran3s2ats_anti2enne");
            put(11, "_contre1s2cperti3nent_conti3nent__ma2l1a2dro_in2é3lucta_psycho1a2n_dé3s2o3pil’in2é3luctaperma3nent__in2é3narratesta3ment__su2b3liminrésur3gent_’in2é3narraimmis4cent__pro2g3nathchien3dent_sporu4lent_dissi3dent_corpu3lent_archi1é2pissubli2ment_indul3gent_confi3dent__syn2g3nathtrucu3lent_détri3ment_nutri3ment_succu3lent_turbu3lent__pa2r1a2che_pa2r1a2chèfichu3ment_entre3gent_conni3vent_mécon3tent_compé3tent__re4s5trict_dé3s2i3nen_re2s3plend1a2nesthésislalo2ment__dé3s2ensib_re4s5trein_phalan3s2tabsti3nent_");
            put(12, "polyva3lent_équiva4lent_monova3lent_amalga2ment_omnipo3tent__ma2l1a2dreséquipo3tent__dé3s2a3tellproémi3nent_contin3gent_munifi3cent__ma2g3nicideo1s2trictionsurémi3nent_préémi3nent__bai2se3main");
            put(13, "acquies4cent_intelli3gent_tempéra3ment_transpa3rent__ma2g3nificatantifer3ment_");
            put(14, "privatdo3cent_diaphrag2ment_privatdo3zent_ventripo3tent__contre3maître");
            put(15, "grandilo3quent_");
            put(16, "_chè2vre3feuille");
        }
    }), pt("pt", 2, 4, new HashMap<Integer, String>() {
        {
            put(2, "1-");
            put(3, "1ba1be1bi1bo1bu1bá1bâ1bã1bé1bí1bó1bú1bê1bõ1ca1ce1ci1co1cu1cá1câ1cã1cé1cí1có1cú1cê1cõ1ça1çe1çi1ço1çu1çá1çâ1çã1çé1çí1çó1çú1çê1çõ1da1de1di1do1du1dá1dâ1dã1dé1dí1dó1dú1dê1dõ1fa1fe1fi1fo1fu1fá1fâ1fã1fé1fí1fó1fú1fê1fõ1ga1ge1gi1go1gu1gá1gâ1gã1gé1gí1gó1gú1gê1gõ1ja1je1ji1jo1ju1já1jâ1jã1jé1jí1jó1jú1jê1jõ1ka1ke1ki1ko1ku1ká1kâ1kã1ké1kí1kó1kú1kê1kõ1la1le1li1lo1lu1lá1lâ1lã1lé1lí1ló1lú1lê1lõ1ma1me1mi1mo1mu1má1mâ1mã1mé1mí1mó1mú1mê1mõ1na1ne1ni1no1nu1ná1nâ1nã1né1ní1nó1nú1nê1nõ1pa1pe1pi1po1pu1pá1pâ1pã1pé1pí1pó1pú1pê1põ1ra1re1ri1ro1ru1rá1râ1rã1ré1rí1ró1rú1rê1rõ1sa1se1si1so1su1sá1sâ1sã1sé1sí1só1sú1sê1sõ1ta1te1ti1to1tu1tá1tâ1tã1té1tí1tó1tú1tê1tõ1va1ve1vi1vo1vu1vá1vâ1vã1vé1ví1vó1vú1vê1võ1xa1xe1xi1xo1xu1xá1xâ1xã1xé1xí1xó1xú1xê1xõ1za1ze1zi1zo1zu1zá1zâ1zã1zé1zí1zó1zú1zê1zõa3aa3ea3oc3ce3ae3ee3oi3ai3ei3ii3oi3âi3êi3ôo3ao3eo3or3rs3su3au3eu3ou3u");
            put(4, "1b2l1b2r1c2h1c2l1c2r1d2l1d2r1f2l1f2r1g2l1g2r1k2l1k2r1l2h1n2h1p2l1p2r1t2l1t2r1v2l1v2r1w2l1w2r");
            put(5, "1gu4a1gu4e1gu4i1gu4o1qu4a1qu4e1qu4i1qu4o");
        }
    }), lt("lt", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "a1ba1ca1da1ea1fa1ha1ja1ka1la1ma1na2oa1pa1ra1sa1ta4ua1va1wa1ya1za1ąa1ęa1įa1ša1ųa1žb1jcu4d4zd4že1ce1ee1fe1ge1he1je1ke1le1me2oe3pe1re1se1te1ve1we1ye1ze1ąe1če1ęe1ėe1še1ųe1ūe1ž3gui2ai1ci1di2ei1fi1ji1ki1li1mi2oi1pi1ri2ui1vi1wi1yi1zi2ąi1či1ęi1įi1ši2ųi2ūi3ž1ju1jū3kek4i3ko3ku5ką3lą3lųm2am2one15noo1ao1bo1co1do1eo1fo1go1ho1io1jo1ko1lo1mo1no1po1ro1so1vo1wo1yo1zo1ąo1čo1ęo1ėo1įo1šo1ųo1ūo1žpa3p2ep2i3pop2yp2ėr2ar2ir2or2u3rą5rųs2esu1są35sėt2at2it2o3tęu1bu1cu1du1fu1gu1hu1ju1ku1lu1mu1nu2ou3pu1ru1su1uu1vu1wu1yu1zu1ąu1ču1ęu1įu1šu1ųu1žv2e3vą3vėy1ay1by1cy1dy1ey1fy1gy1hy1iy1jy1ky1ly1my1ny1oy1py3ry1sy1ty1uy1vy1wy1yy1zy1ąy1čy1ęy1ėy1įy1šy1ųy1ūy1žą1aą1bą1cą1dą1eą1fą1gą1hą1ią1ją1ką1lą1mą1ną1oą1pą1rą1są1tą1uą1vą1wą1yą1zą1ąą1čą1ęą1ėą1įą1šą1ųą1ūą1žę1aę1bę1cę1dę1eę1fę1gę1hę1ię1ję1kę1lę1mę1nę1oę1pę1rę1sę1tę1uę1vę1wę1yę1zę1ąę1čę1ęę1ėę1įę1šę1ųę1ūę1žė1aė1bė1cė1dė1eė1fė1gė1hė1iė1jė1kė1mė1nė1oė1pė1rė1uė1vė1wė1yė1zė1ąė1čė1ęė1ėė1įė1šė1ųė1ūė1žį1aį1bį1cį2eį1fį4gį1hį1iį1jį2lį2mį1nį1oį4pį2rį1sį1uį2vį1wį1yį1zį1ąį1čį1ęį1įį1šį1ųį1ūį1žų1aų1bų1cų1dų1eų1fų1gų1hų1ių1jų1kų1lų1mų1nų1oų1pų1rų1sų1tų1uų1vų1wų1yų1zų1ąų1čų1ęų1ėų1įų1šų1ųų1ūų1žū1aū1bū1cū1dū1eū1fū1gū1hū1iū1jū1kū1lū1mū1nū1oū1pū1rū1sū1tū1uū1vū1wū1yū1zū1ąū1čū1ęū1ėū1įū1šū1ųū1ūū1žž1jž2u");
            put(4, "_ap1_at1_nu1_sk4_st4_uk3_už1_įs4a1a2a2chae2l2a1ga4grak2la3lia3lya3lėa3lūap3la3pra4rgasi1a4ska3slato1atp42a1ča1ė2a3šnaš2va1ū2až2lba3c2b1b2b1c4b3dbep42b1f2b1g2b1h2b1k2b1lb2lab2lu2b1m2b1n2b1p2b2rb3ri2b1s2b3tbu4k2b1v2b1w2b1z2b1č2b1š2b1žcar42c1b2c1c2c1d2c1f2c1g3chi2c1k2c1l2c1m2c1n2c1p2c1r2c1s2c1tcuk52c1v2c1w2c1z2c1č2c1š2c1ž2d1b2d1c2d1dde4k2d1f2d1g2d1hdi4pdi4s2d1j2d3k4d3l2d1m2d1n2d1p2d1rdro1d2rė4drų2d1s2d1tdu2adu4k2d1vd3va2d1w2d1č2d1še1a2eat1e1b2ebe1e3bleb3re2che3d2e1ie1eine3kr2e1neno1ens4enu1e3orep4rero1erė2es4ke1u4euž3e3vie1į4eįp3e3šneš2vešė32f1b2f1c2f1d2f1f2f1g2f1h2f1k2f1l2f1m2f1n2f1p2f1rfri12f1s2f1t2f1v2f1w2f1z2f1č2f1š2f1žgaš32g1b2g1c2g1d2g1f2g1g2g1h2g1k2g1lg2leg2lo2g1m2g1n3g2rg3rig4rą5grį4grų2g1s4g1t2g1v2g1w2g1z2g1č2g1š2g1ž2h1b2h1c2h1d2h1f2h1g2h1hhi4b2h1k2h2l2h1mh2me2h1n2h1p2h1r2h1s2h1t2h1v2h1w2h1z2h1č2h1š2h1žia3kiap4i3ari3b2ice1id2rie3gi3ei2i1g2i1hi1i2ik3rilo11imd4i1n5inviok2i3ori3ri4i1si5sai5siis4ki3sli1ė2i3šniš5ti4švišė21išš3ja_2j1b2j1c2j1d2j1f2j1g2j1h2j1j2j1k2j1l2j1m2j1njot32j1p2j1r2j1s2j1t2j1v2j1w2j1z2j1č2j1š2j1ž3ka_kak33kar3kas5kav2k1b2k1c2k1d2k1f2k1g2k1h5ki_5kia3kib3kil5kit2k1k2k1lk2ly4klą4klų2k1m2k1n2k1p2k2rk3rok4ryk5rą2k1sk4skks3l4k1tk3ta4kubku4k2k1vk2vak3vok2vė2k1w3kyt2k1z2k1č2k1škšė32k1ž3la_2l1blb3r2l1c2l1d3le_le3c4leč2l1f2l1g2l1h3li_li4a3lių2l1j2l1klko12l1l2l1m2l1n3lo_log44lop4l1p2l1r4l1sl4sk4l3t3lu_2lup4l1v2l1w3lyč2l1z2l1č3lęs3lėm3lės2lėč3lį44l1š2l1ž3mas2m1bmb3r2m1c2m1dme3c2m1f2m1g2m1h2m1k2m1l2m1m2m1n2mod2m1pm4plm3pr2m1r4m1s2m1tm3ta3muo2m1v2m1w2m1z2m1č2m1š2m1ž2n1b2n1c2n1dneg42n1f4n1gng3lng4r2n1hni4s2n1j2n1knk3r2n1l2n1m2n1n2n1p2n1r4n1sns3l4n1tn3tanua4nu3gnu1inuk22n1v2n1w2n1z4n1č2n1š2n1žo3dro2eto3krono1o1o2o2ręo3slo3t2oto1oš2vpad23panpap4p2arpas22p1b4p1cper12p1f2p1g2p1h3p2lp3lep3lip3lop4lup4ly2p1m4p1npo4g2p1p2p2rp3rip3ry4prąp3rėp3rū4p1spsi13p4u2p1v2p1w2p1z2p1č4p3ž3ra_ra3b3rac3ral3ram3rav2r1brbo12r1c4r1d2reb3rel5res3ret2r1f2r1g2r1h3ri_ri3d3rij2ril3riori3p3rią3rių2riū4r1k4r1l2r1m4r1n3roj3rok3ron3rop5ros2r1p2r1r4r1srs4p4r1t2ruk3rul4run2rup3rus4r1v2r1w2r1z4rąs4r1č4r1š2r1ž2s3b2s1c2s3d2s1f2s1g2s1hsi3d4sk_4ske5ski5sky4ską5skę2s2l3sles3lis3lo2s1m4smę4s3n3s2ps3pe4spn4spu4s1rs3ri2s1s2s1tst2v4stę4stųs2tūsuž42s1vs2ve2s1w2s1z4s3č2s1š2s1ž2tabta5s2tat2tač2t1b2t1c2t1d2teb3temte4o2t1f4t3g2t1h3tin2tip4t3j4t3kt4kl4t3l4t3m2t1n2tow2t3pt4pjtp4r2t1r4tro4trą4trųtsi14t1ttua43tur2t1vt2vo2t1w3tyd2t1z2t1čt2ėm2t3žu1a2u3aiu2bju1e2ug4ru5inui2ru3klu3kru3kvu5kųu3orup4lurk2u3slu3t2uto12utru1ė2uš2vu1ū2u3žluž3v3va_vap4va3t2v1b2v1c2v1d2vep3ves2v1f2v1g2v1h2v1j2v1k2v1l2v1m2v1n2v1p2v1r2v4s2v1t2v1v2v1w2v1z2v1č4vėp2v1š2v1ž2w1b2w1c2w1d2w1f2w1g2w1h2w1k2w1l2w1m2w1n2w1p2w1r2w1s2w1t2w1v2w1w2w1z2w1č2w1š2w1žy4sk2z1b2z1c2z1d2z1f2z1g2z1h2z1k2z1l2z1m2z1n2z1p2z1r2z1s2z1t2z1v2z1w2z1z2z1č2z1š2z1ž2č1b2č1c2č1d2č1f2č1g2č1hčin12č1k2č1l2č1m2č1n2č1p2č1r2č1s2č1t2č1v2č1w2č1z2č1č2č1š2č1ž2ė3lė3me2ė1sės3l2ė3tė4trį1d2į2k4įsi1įs3lįs2mįs2rįst2į2t2į1ė22š1cš1eiše2v2š1f2š1h2š1lš2lu3šly2š1m2š1nš2nešno1šo2r2š1ršsi1šu4š3š1vš2vi2š1w2š1z4š3čšė2j2š1š2š1žūs3lūs3t2ž1cžen12ž3g2ž1hžio32ž1lž2lu4ž1m2ž1n2ž3p2ž1r2ž1sžsi1ž4skžs3t3ž2vž4viž3vo2ž1w2ž1z2ž1čžįs32ž1š2ž1ž");
            put(5, "_api1_ap3r_as3p_ata1_at3r_aš3v_ek3r_i2š3_iši2_sam1_u2š3a4draag3raa5groa5infai4skai4trak2via2kėta5lo1an4skan4trap3eiap3s2ari4sasi5sas3klas2mias2mua5s4na4stua4truat1ė2atū2žau4klau4skau4slaš4trba4slbe3s2besi1be3t2b2liz3b2loda3b4dema1de4prde4spdis5kdo3ridro2bdu5kadu4sldvi3adžio1e2a3leapi1ed3rie4droed3rėeg3raei4skei4slei2š14entae3o2šep4liepra1epri1eri4sesi5seska1e5skoe3s2veįs3keįt3rfi4s5ge4o13g2nų2g1p2grai2g3ran5g3reg4reig3ro_gyva1ia5g4i3aišid3rėi2dėmie3kli3entie4ski3g2lig3rui3k2nin4klio4pli2p1jip3ruis4lii5s4ni4steisto12i3t2jo4tv5ka3dka4klka4pr3katika3z2ke4b33k2lak4lan4kle_k2lel4klo_4klu_k4raukris2k4rov4k3ru5krunk4s3pku4prkš2lyle4gr5li4olpna1l4s3pmeis1mi4glmi4grmin4smi4trna3s2na3t2ncen1n3drėnei2mne4o3neor2nerė3nesi1ne3slne3t2nk3lan3kryns4kun4s3pnst3rnt4pln3trunu3b2nu4o3nuos2nu5s4olen1om4pro2rieori4sor4tros3leos4loo3s2vpai2lpai2mpai2rpa5srp2at24p3d2pe2reper3spe2rėp3ieš2p3k24pliop4liup4lojpoli1p3raip3rašpris2p5ro_p3romp5s4kp3s2v4p3t2pu4skpu4slpu4tr4p3š2ra1imra3krras4lra3smr3b4r4rein4reitre4p5res3lri3krrisi1ri3strk3lyr3k4r3rod2ro4grr3p4rr3t2rr3t2v3ruosru4sk4rutor3š2lr3š2msala1san5tse4krsi3k4si3p4si3s23s2k2s5ka_5sk4r5skubsk3vask3vi4s3lu4s3lū4sme_so4drs2tals2ten4stins2tods2toj4s3tėsu3blsu3d2su3g2suk2lsu3s2susi13s2vyta3krte3t2ti4gr3toje2tolįto3s2tp3lū4triot2riš4t3s44tvėjt3ėmut3ėmęt3ėmė2t3š2u1i2muk2leuo4slup3rour3klu5ro1ur3s2us3laus3leusva1us3veu3š2lu3š2nuži2muž1ė2ygia1y4k3lčeko1ė4k3l2š1b22š3d22š1g4šiuk12š1k2š2lij2š1p42š3s44š3t2š4vydū4k3lū4s3kžant42ž3b22ž3d22ž3f4ži3mu2ž3k2ž4s5l4ž3t2žu3s2");
            put(6, "_arbi1_arti1_dina1_nusi1_pie2č_sida1_su5kr_te3s2_šven1a5grioan3k2lap1a4kap3i2mar1eitat3augat3i2mau4t3rbalta1ei4k3l2eis3tema5s4en3k2lenk4laere3a44g4rioi3antęi3antėie4d3rie4p5rio4g3rira3s2jauna1kavar1keren1kri5stlg3s2t2m3aidmas3kine3s2tneįs3tnt2ruoparsi1p4s3tyrai4tįri2ma_2r3imtrivin12r3orgrs4ko_rti5k4rti3s22s1amžsarka1senat4si3auksi3a2vsi3a2šsi5š2v5s4ken5s4kle3s2tovst2raitaura1ti4k3ltskri1ug5riou2s1alvi4s5kvi4t3r2vydau2š5istžants5");
            put(7, "_kirti1ate5isteist2rapa4r1ė2pe2r3imprau2sipusiau1rau4ka_viesia1šsikap1");
            put(8, "lap4s3to");
        }
    }), el("el", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "α1ε1η1ι1ο1υ1ω1ϊ1ϋ1ἀ1ἁ1ἂ1ἃ1ἄ1ἅ1ἆ1ἇ1ἐ1ἑ1ἒ1ἓ1ἔ1ἕ1ἠ1ἡ1ἢ1ἣ1ἤ1ἥ1ἦ1ἧ1ἰ1ἱ1ἲ1ἳ1ἴ1ἵ1ἶ1ἷ1ὀ1ὁ1ὂ1ὃ1ὄ1ὅ1ὐ1ὑ1ὒ1ὓ1ὔ1ὕ1ὖ1ὗ1ὠ1ὡ1ὢ1ὣ1ὤ1ὥ1ὦ1ὧ1ὰ1ὲ1ὴ1ὶ1ὸ1ὺ1ὼ1ᾀ1ᾁ1ᾂ1ᾃ1ᾄ1ᾅ1ᾆ1ᾇ1ᾐ1ᾑ1ᾒ1ᾓ1ᾔ1ᾕ1ᾖ1ᾗ1ᾠ1ᾡ1ᾢ1ᾣ1ᾤ1ᾥ1ᾦ1ᾧ1ᾲ1ᾳ1ᾴ1ᾶ1ᾷ1ῂ1ῃ1ῄ1ῆ1ῇ1ῒ1ῖ1ῗ1ῢ1ῦ1ῧ1ῲ1ῳ1ῴ1ῶ1ῷ1ά1έ1ή1ί1ό1ύ1ώ1ΐ1ΰ1ά1έ1ή1ί1ό1ύ1ώ1ΐ1ΰ16'6ʼ6᾿");
            put(3, "α2ια2ία2ία2ὶα2ῖα2ἰα2ἴα2ἲα2ἶα2ἱα2ἵα2ἳα2ἷά2ιά2ιά2ϊά2ϊα2υα2ύα2ύα2ὺα2ῦα2ὐα2ὔα2ὒα2ὖα2ὑα2ὕα2ὓα2ὗά3υά3υε2ιε2ίε2ίε2ὶε2ῖε2ἰε2ἴε2ἲε2ἶε2ἱε2ἵε2ἳε2ἷέ2ιέ2ιέ2ϊέ2ϊε2υε2ύε2ύε2ὺε2ῦε2ὐε2ὔε2ὒε2ὖε2ὑε2ὕε2ὓε2ὗέ3υέ3υη2υη2ύη2ύη2ὺη2ῦη2ὐη2ὔη2ὒη2ὖη2ὑη2ὕη2ὓη2ὗο2ιο2ίο2ίο2ὶο2ῖο2ἰο2ἴο2ἲο2ἶο2ἱο2ἵο2ἳο2ἷό2ιό2ιό2ϊό2ϊο2υο2ύο2ύο2ὺο2ῦο2ὐο2ὔο2ὒο2ὖο2ὑο2ὕο2ὓο2ὗό3υό3υυ2ιυ2ίυ2ίυ2ὶυ2ῖυ2ἰυ2ἴυ2ἲυ2ἶυ2ἱυ2ἵυ2ἳυ2ἷα2ηα2ϊα2ϋά3ϋά3ϋε2ηέ2ηέ2ηε2ϊε2ϋό2ηό2ηο2ϊω2ιὠ2ιι2αι2άι2άι2ὰι2ᾶι2ει2έι2έι2ὲι2οι2όι2όι2ὸι2ωι2ώι2ώι2ὼι2ῶ_ί3_ί3_ῖ3_ἰ3_ἱ3η2αῃ2αη2άη2άη2ὰη2ᾶῃ2άῃ2άῃ2ὰῃ2ᾶη2εῃ2εη2έη2έη2ὲῃ2έῃ2έῃ2ὲη2οῃ2οη2όη2όη2ὸῃ2όῃ2όῃ2ὸη2ωῃ2ωη2ώη2ώη2ὼη2ῶῃ2ώῃ2ώῃ2ὼῃ2ῶ_ή3_ή3_ῆ3_ἠ3_ἡ3υ2αυ2άυ2άυ2ὰυ2ᾶυ2ευ2έυ2έυ2ὲυ2ου2όυ2όυ2ὸυ2ωυ2ώυ2ώυ2ὼυ2ῶ_ύ3_ύ3_ῦ3_ὑ36β_6γ_6δ_6ζ_6θ_6κ_6λ_6μ_6ν_6ξ_6π_6ρ_6σ_6ϲ_6ς_6τ_6φ_6χ_6ψ_6β'6βʼ6β᾿6γ'6γʼ6γ᾿6δ'6δʼ6δ᾿6ζ'6ζʼ6ζ᾿6θ'6θʼ6θ᾿6κ'6κʼ6κ᾿6λ'6λʼ6λ᾿6μ'6μʼ6μ᾿6ν'6νʼ6ν᾿6ξ'6ξʼ6ξ᾿6π'6πʼ6π᾿6ρ'6ρʼ6ρ᾿6σ'6σʼ6σ᾿6ϲ'6ϲʼ6ϲ᾿6τ'6τʼ6τ᾿6φ'6φʼ6φ᾿6χ'6χʼ6χ᾿6ψ'6ψʼ6ψ᾿_β6_γ6_δ6_ζ6_θ6_κ6_λ6_μ6_ν6_ξ6_π6_ρ6_σ6_ϲ6_τ6_φ6_χ6_ψ6");
            put(4, "ά3η_ά3η_ά3ι_ά3ι_ά3ϊ_ά3ϊ_ό2ειό2ειό3η_ό3η_ό3ι_ό3ι_ό3ϊ_ό3ϊ_6γκ_6μπ_6ντ_6τζ_6τσ_6τϲ_6τς_6μπ'6μπʼ6μπ᾿6ντ'6ντ’6ντ᾿6τζ'6τζʼ6τζ᾿6τσ'6τσʼ6τσ᾽6τϲ'6τϲʼ6τϲ᾿4β1β4γ1γ4δ1δ4ζ1ζ4θ1θ4κ1κ4λ1λ4μ1μ4ν1ν4π1π4ρ1ρ4ῤ1ῥ4σ1σ4ϲ1ϲ4τ1τ4φ1φ4χ1χ4ψ1ψ4β1ζ4β1θ4β1κ4β1μ4β1ν4β1ξ4β1π4β1σ4β1ϲ4β1τ4β1φ4β1χ4β1ψ4γ1β4γ1ζ4γ1θ4γ1κ4γ1μ4γ1ξ4γ1π4γ1σ4γ1ϲ4γ1τ4γ1φ4γ1χ4γ1ψ4δ1β4δ1γ4δ1ζ4δ1θ4δ1κ4δ1λ4δ1ξ4δ1π4δ1σ4δ1ϲ4δ1τ4δ1φ4δ1χ4δ1ψ4ζ1β4ζ1γ4ζ1δ4ζ1θ4ζ1κ4ζ1λ4ζ1μτζ2μ4ζ1ν4ζ1ξ4ζ1π4ζ1ρ4ζ1σ4ζ1ϲ4ζ1τ4ζ1φ4ζ1χ4ζ1ψ4θ1β4θ1γ4θ1δ4θ1ζ4θ1κ4θ1μσθ2μϲθ2μ4θ1ξ4θ1π4θ1σ4θ1ϲ4θ1τ4θ1φ4θ1χ4θ1ψ4κ1β4κ1γ4κ1δ4κ1ζ4κ1θ4κ1ξ4κ1π4κ1σ4κ1ϲ4κ1φ4κ1χ4κ1ψ4λ1β4λ1γ4λ1δ4λ1ζ4λ1θ4λ1κ4λ1μ4λ1ν4λ1ξ4λ1π4λ1ρ4λ1σ4λ1ϲ4λ1τ4λ1φ4λ1χ4λ1ψ4μ1β4μ1γ4μ1δ4μ1ζ4μ1θ4μ1κ4μ1λ4μ1ξ4μ1π4μ1ρ4μ1σ4μ1ϲ4μ1τ4μ1φ4μ1χ4μ1ψ4ν1β4ν1γ4ν1δ4ν1ζ4ν1θ4ν1κ4ν1λ4ν1μ4ν1ξ4ν1π4ν1ρ4ν1σ4ν1ϲ4ν1τ4ν1φ4ν1χ4ν1ψ4ξ1β4ξ1γ4ξ1δ4ξ1ζ4ξ1θ4ξ1κ4ξ1λ4ξ1μ4ξ1ν4ξ1π4ξ1ρ4ξ1σ4ξ1ϲ4ξ1τ4ξ1φ4ξ1χ4ξ1ψ4π1β4π1γ4π1δ4π1ζ4π1θ4π1κ4π1μ4π1ξ4π1σ4π1ϲ4π1φ4π1χ4π1ψ4ρ1β4ρ1γ4ρ1δ4ρ1ζ4ρ1θ4ρ1κ4ρ1λ4ρ1μ4ρ1ν4ρ1ξ4ρ1π4ρ1σ4ρ1ϲ4ρ1τ4ρ1φ4ρ1χ4ρ1ψ4σ1δ4ϲ1δ4σ1ζ4ϲ1ζ4σ1ν4ϲ1ν4σ1ξ4ϲ1ξ4σ1ρ4ϲ1ρ4σ1ψ4ϲ1ψ4τ1β4τ1γ4τ1δ4τ1θ4τ1ν4τ1ξ4τ1π4τ1φστ2φϲτ2φ4τ1χ4τ1ψ4φ1β4φ1γ4φ1δ4φ1ζ4φ1κ4φ1ν4φ1ξ4φ1π4φ1σ4φ1ϲ4φ1χ4φ1ψ4χ1β4χ1γ4χ1δ4χ1ζ4χ1κ4χ1μ4χ1ξ4χ1π4χ1σ4χ1ϲ4χ1φ4χ1ψ4ψ1β4ψ1γ4ψ1δ4ψ1ζ4ψ1θ4ψ1κ4ψ1λ4ψ1μ4ψ1ν4ψ1ξ4ψ1π4ψ1ρ4ψ1σ4ψ1ϲ4ψ1τ4ψ1φ4ψ1χβγ2κσγ2κϲγ2κσμ2πϲμ2πμν2τσν2τϲν2τ6βρ_6γλ_6κλ_6κτ_6κς_6κϲ_6κσ_6λς_6λϲ_6λσ_6μς_6μϲ_6μσ_6νς_6νϲ_6νσ_6ρς_6ρϲ_6ρσ_6σκ_6ϲκ_6στ_6ϲτ_6τλ_6τρ_6φτ_6χτ_");
            put(5, "ο3ϊ3όο3ϊ3όο3ϊ3ὸβ5ν2τζ5ν2τλ5ν2τρ5ν2τ");
            put(6, "4ρ5γ2μ4ρ5θ2μ4λ5κ2μ4ρ5κ2μ4γ5κ2φ4ν5κ2φ4γ5ξ2τ4ρ5ξ2τ4ρ5φ2ν4ρ5χ2μ4μ5ψ2τ4λ5γ2κ4ν5γ2κ4ρ5γ2κ4τ5γ2κ4ζ5μ2π4λ5μ2π4ν5μ2π4ρ5μ2πἄ5μ2ακἀ5μ2πρὄ5μ2ποὀ5μ2ποὀ5ν2τάὀ5ν2τάὀ5ν2τὰὀ5ν2τᾶ6μ2πλ_6μ2πν_6μ2πρ_");
            put(7, "ἰ5γ2κου_ξε5γ2κ_ξέ5γ2κ_ξέ5γ2κ_σι5γ2κ_ϲι5γ2κἀ5μ2πάκἀ5μ2πάκἀ5μ2πανἀ5μ2πάρἀ5μ2πάρἀ5μ2πᾶρἀ5μ2παρἀρα5μ2πἰ5μ2πρα_κε5μ2π_λό5μ2π_λό5μ2π5μ2πέη_5μ2πέη_5μ2πεη_5μ2πογι_ξε5μ2π_ξέ5μ2π_ξέ5μ2π_ρε5μ2π_ρέ5μ2π_ρέ5μ2π_ρο5μ2πρό5μ2παρό5μ2παρό5μ2περό5μ2περό5μ2πωρό5μ2πωρο5μ2πῶρο5μ2παρο5μ2περο5μ2πωσό5μ2πασό5μ2παϲό5μ2παϲό5μ2πασό5μ2πεσό5μ2πεϲό5μ2πεϲό5μ2πεσο5μ2πῶϲο5μ2πῶσό5μ2πωσό5μ2πωϲό5μ2πωϲό5μ2πωσο5μ2παϲο5μ2πασο5μ2πεϲο5μ2πεσο5μ2πωϲο5μ2πω_τα5μ2π_χα5μ2π_χό5μ2π_χό5μ2π_ξε5ν2τ_ξέ5ν2τ_ξέ5ν2τ6γ2κ1τζ6γ2κ1τσ6γ2κ1τϲ6μ2π1τζ6μ2π1τσ6μ2π1τϲ6τσ5γ2κ6τϲ5γ2κ6τσ5μ2π6τϲ5μ2π6τσ5ν2τ6τϲ5ν2τ");
            put(8, "ἐμι5γ2κρ_μπα5γ2κ_μπι5γ2κ_σπά5γ2κ_σπά5γ2κ_ϲπά5γ2κ_ϲπά5γ2κ_σπα5γ2κ_ϲπα5γ2κ_φιό5γ2κ_φιό5γ2κ_φιο5γ2κἀ6μ3πάριἀ6μ3πάριἀ6μ3παρι_γά5μ2πι_γά5μ2πι_γα5μ2πι_ζεϊ5μ2π_κό5μ2πρ_κό5μ2πρ_κο5μ2πρ_λι5μ2πρ5μ2πέης_5μ2πέης_5μ2πέηϲ_5μ2πέηϲ_5μ2πεης_5μ2πεηϲ_5μ2πέησ_5μ2πέησ_5μ2πεησ__μπι5μ2π_τρο6μ3π_τρό6μ3π_τρό6μ3π_ρου5μ2π_σέ5μ2πρ_σέ5μ2πρ_ϲέ5μ2πρ_ϲέ5μ2πρ_σνο5μ2π_ϲνο5μ2π_σού5μ2π_σού5μ2π_ϲού5μ2π_ϲού5μ2π_σου5μ2π_ϲου5μ2π_τζά5μ2π_τζά5μ2π_τζα5μ2π_τζι5μ2π_τό5μ2πρ_τό5μ2πρ_το5μ2πρ_φρα5μ2πἀ5ν2τάτζἀ5ν2τάτζ_βί5ν2τε_βί5ν2τε_βι5ν2τε_κα5ν2τρ_μαϊ5ν2τ_μπε5ν2τ_μπι5ν2τ_ντα5ν2τ5ν2τίβαν5ν2τίβαν_ρε5ν2τί_ρε5ν2τί_ρε5ν2τι_ροῦ5ν2τ_ρού5ν2τ_ρού5ν2τ_χα5ν2το_χα5ν2τρ_χά5ν2τρ_χά5ν2τρ6γ2κ5μ2π6γ2κ5ν2τ6μ2π5ν2τ6ν2τ5μ2π");
            put(9, "5γ2κραντ_ἴντρι5γ2κἰντρι5γ2κ_μα5γ2κιό_μα5γ2κιό_ντά5γ2κλ_ντά5γ2κλ_ντα5γ2κλἀλα5μ2πουἀρλού5μ2πἀρλού5μ2πἀρλοῦ5μ2πἀρλου5μ2π_βό5μ2πιρ_βό5μ2πιρ_βο5μ2πιρ_κα5μ2πάδ_κα5μ2πάδ_κα5μ2πίν_κα5μ2πίν_κα5μ2πῖν_κα5μ2πιν_κά5μ2ποτ_κά5μ2ποτ_κα5μ2πότ_κα5μ2πότ_κα5μ2ποτ_καου5μ2π_καρα5μ2π5μ2πα5μ2π5μ2πά5μ2π5μ2πά5μ2π5μ2πέ5μ2π5μ2πέ5μ2π5μ2πε5μ2π_νό5μ2πελ_νό5μ2πελ_νο5μ2πελ_ντό5μ2πρ_ντό5μ2πρ_ντο5μ2πρ_σα2μ5ποτ_ϲα2μ5ποτ_τε5μ2πεσ_τε5μ2πεϲ_τζου5μ2π_τσά5μ2πα_τσά5μ2πα_τϲά5μ2πα_τϲά5μ2πα_τσα5μ2πα_τϲα5μ2παἀτρα5ν2τέἀτρα5ν2τέἀτρα5ν2τὲ_γιβε5ν2τ_γκάι5ν2τ_γκάι5ν2τ_γκάϊ5ν2τ_γκάϊ5ν2τ_γκαϊ5ν2τ_κα5ν2ταΐ_κα5ν2ταΐ_κα5ν2ταϊ_μα5ν2τάμ_μα5ν2τάμ_μα5ν2τὰμ_μα5ν2ταμ_μα5ν2τέμ_μα5ν2τέμ_μα5ν2τεμ_μεϊ5ν2τά_μεϊ5ν2τά_μεϊ5ν2τα_μο5ν2τέλ_μο5ν2τέλ_μο5ν2τελμο5ν2τέρνμο5ν2τέρνμο5ν2τερν_νισα5ν2τ_νιϲα5ν2τ_ρεζε5ν2τ_σε5ν2τέφ_σε5ν2τέφ_ϲε5ν2τέφ_ϲε5ν2τέφ_σε5ν2τεφ_ϲε5ν2τεφ_σε5ν2τοῦ_ϲε5ν2τοῦ_σε5ν2τού_σε5ν2τού_ϲε5ν2τού_ϲε5ν2τού_σε5ν2του_ϲε5ν2του_τσα5ν2τί_τσα5ν2τί_τϲα5ν2τί_τϲα5ν2τί_τσα5ν2τι_τϲα5ν2τι");
            put(10, "_γιου5γ2κο_καρα5γ2κι_χούλι5γ2κ_χούλι5γ2κ_χουλι5γ2κ_γιαρα5μ2π_καλα5μ2πα_καλί5μ2πρ_καλί5μ2πρ_καλι5μ2πρ_κα5μ2παρέ_κα5μ2παρέ_κα5μ2παρὲ_κα5μ2παρε_καρνα5μ2π_κολι5μ2πρ_κου5μ2πού_κου5μ2πού_κου5μ2ποῦ_κου5μ2που5μ2πέηδες_5μ2πέηδες_5μ2πέηδεϲ_5μ2πέηδεϲ_5μ2πέηδεσ_5μ2πέηδεσ_5μ2πέηδων_5μ2πέηδων__μπό5μ2πιρ_μπό5μ2πιρ_μπο5μ2πιρ_μπο5μ2πότ_μπο5μ2πότ_μπο5μ2ποτ_σκα5μ2παβ_ϲκα5μ2παβ_ταβλα5μ2π_τζανα5μ2π_τρα5μ2πάλ_τρα5μ2πάλ_τρα5μ2παλ_φά5μ2πρικ_φά5μ2πρικ_φα5μ2πρικ_μπαλά5ν2τ_μπαλά5ν2τ_μπαλα5ν2τ_μπα5ν2ταν_μπου5ν2τα_μπου5ν2τρ");
            put(11, "_καρα6μ3πόλ_καρα6μ3πόλ_καρα6μ3πολ_κολού5μ2πρ_κολού5μ2πρ_κολοῦ5μ2πρ_κολου5μ2πρ_κο6μ3πρέσσ_κο6μ3πρέσσ_κο6μ3πρέϲϲ_κο6μ3πρέϲϲ_κο6μ3πρεσσ_κο6μ3πρεϲϲ_κοντρα5μ2π_κωλού5μ2πρ_κωλού5μ2πρ_κωλοῦ5μ2πρ_κωλου5μ2πρ_μανιτό5μ2π_μανιτό5μ2π_μπα6μ3πάκι_μπα6μ3πάκι_μπα6μ3πακι_ρεπού5μ2πλ_ρεπού5μ2πλ_ρεπου5μ2πλ_τα6μ3περαμ_τα6μ3ποῦρλ_τα6μ3πούρλ_τα6μ3πούρλ_τρα5μ2ποῦκ_τρα5μ2πούκ_τρα5μ2πούκ_τρα5μ2πουκ_τσι5μ2πούκ_τσι5μ2πούκ_τϲι5μ2πούκ_τϲι5μ2πούκ_τσι5μ2πουκ_τϲι5μ2πουκ_τσι5μ2πούσ_τσι5μ2πούσ_τϲι5μ2πούϲ_τϲι5μ2πούϲ_τσι5μ2πουσ_τϲι5μ2πουϲ_γιαχου5ν2τ");
            put(12, "_σαλτιπά5γ2κ_σαλτιπά5γ2κ_ϲαλτιπά5γ2κ_ϲαλτιπά5γ2κ_κουλού5μ2πρ_κουλού5μ2πρ_κουλοῦ5μ2πρ_κουλου5μ2πρ_μπου5μ2πούν_μπου5μ2πούν_μπου5μ2ποῦν_μπου5μ2πουν_χοντρο5μ2πα_λικβι5ν2ταρ_ντερμπε5ν2τ_ντου5ν2τούκ_ντου5ν2τούκ_ντου5ν2τοῦκ_ντου5ν2τουκ_φαστφου5ν2τ_φαϲτφου5ν2τ");
            put(13, "_μπασκε2τ5μ2π_μπαϲκε2τ5μ2π_μπασι5μ2πουζ_μπαϲι5μ2πουζ");
        }
    }), ca("ca", 3, 3, new HashMap<Integer, String>() {
        {
            put(3, "u1í1ba1bi1bo1bu1ca1ce1ci1co1cu1da1de1di1do3du1fa1fe1fi1fo1fu1ga1ge1gi1go1gu1ha1he1hi1ho1hu1ja1je1ji1jo1ju1la1le1li1lo1lu1ma1me1mi1mo1mu1na1ne3ni1no1nu1pa3pe3pi3po1pu1qu1ra1re1ri1ro1ru1sa1se1si1so1su1ta1te1ti1to1tu1va1ve1vi1vo1vu1xa1xe1xi1xo1xu1za1ze1zi1zo1zu1bé1bí1bó1bú1bà1bè1bò1cé1cí1có1cú1cà1cè1cò1ço1ça1çu1çó1çú1çà1çò1dé1dí1dó1dú1dà1dè1dò1fé1fí1fó1fú1fà1fè1fò1gé1gí1gó1gú1gà1gè1gò1gü1hé1hí1hó1hú1hà1hè1hò1jé1jí1jó1jú1jà1jè1jò1lé1lí1ló1lú1là1lè1lò1mé1mí1mó1mú1mà1mè1mò1né1ní1nó1nú1nà1nè1nò1pé1pí1pó1pú1pà1pè1pò1qü1ré1rí1ró1rú1rà1rè1rò1sé1sí1só1sú1sà1sè1sò1té1tí1tó1tú1tà1tè1tò1vé1ví1vó1vú1và1vè1vò1xé1xí1xó1xú1xà1xè1xò1zé1zí1zó1zú1zà1zè1zò3prü1òü1èü1àü1úü1óü1íü1éü1oü1eü1aï1iï1òï1èï1àï1úï1óï1íï1éï1oï1eï1aò1üò1ïò1oò1eò1aè1üè1ïè1oè1eè1aà1üà1ïà1oà1eà1aú1üú1ïú1oú1eú1aó1üó1ïó1oó1eó1aí1üí1ïí1oí1eí1aé1üé1ïé1oé1eé1au1üu1ïu1òu1èu1àu1úu1ó1beu1éo1üo1ïo1òo1èo1ào1úo1óo1ío1éi1üi1ïi1òi1èi1ài1úi1ói1íi1ée1üe1ïe1òe1èe1àe1úe1óe1íe1éa1üa1ïa1òa1èa1àa1úa1óa1ía1éu1ou1eu1ao1oo1eo1ai1oi1ei1ae1oe1ee1aa1oa1ea1a");
            put(4, "gü2ép2se_i2ò_u2è_u2ògu2agu2egu2igu2oqu2aqu2equ2iqu2ogu2égu2ígu2ógu2àgu2ègu2òqu2équ2íqu2óqu2àqu2èqu2ògü2e_i2ègü2ígü2ègü2iqü2eqü2éqü2íqü2èqü2io3ron3siig3ne3lea3ria3ne3ser3nei3nef3exp_th2_ch2p2síg2nòg2nop2si");
            put(5, "u1i2í1f2lú1f2ló1f2lí1f2lé1d2rò1d2rè1d2rà1d2rú1d2ró1d2rí1d2ré1c2rò1c2rè1c2rà1c2rú1c2ró1c2rí1c2ré1c2lò1c2lè1c2là1c2lú1c2ló1c2lí1c2lé1b2rò1b2rè1b2rà1b2rú1b2ró1b2rí1b2ré1b2lò1b2lè1b2là1b2lú1b2ló1b2lí1b2lé1l2lò1l2lè1l2là1l2lú1l2ló1l2lí1l2lé1n2yu1n2yo1n2yi1n2ye1n2ya1t2ru1t2ro1t2ri1t2re1t2ra1p2ru1p2ro1p2ri1p2re1p2ra1p2lu1p2lo1p2li1p2le1p2la1g2ru1g2ro1g2ri1g2re1g2ra1g2lu1g2lo1g2li1g2le1g2la1f2ru1f2ro1f2ri1f2re1f2ra1f2lu1f2lo1f2li1f2le1f2la1d2ru1d2ro1d2ri1d2re1d2ra1c2ru1c2ro1c2ri1c2re1c2ra1c2lu1c2lo1c2li1c2le1c2la1b2ru1b2ro1b2ri1b2re1b2ra1b2lu1b2lo1b2li1b2le1b2la1l2lu3l2lo1l2li1l2lea1i2aa1i2ea1i2oa1i2ua1u2aa1u2ea1u2ia1u2oa1u2ue1i2ae1i2ee1i2oe1i2ue1u2ae1u2ee1u2ie1u2oe1u2ui1i2ai1i2ei1i2oi1i2ui1u2ai1u2ei1u2ii1u2oi1u2uo1i2ao1i2eo1i2oo1i2uo1u2ao1u2eo1u2oo1u2io1u2uu1i2au1i2eu1i2ou1i2uu1u2au1u2eu1u2iu1u2ou1u2ua1i2éa1i2ía1i2óa1i2úa1i2àa1i2èa1i2òa1u2éa1u2ía1u2óa1u2úa1u2àa1u2èa1u2òe1i2ée1i2íe1i2óe1i2úe1i2àe1i2èe1i2òe1u2ée1u2íe1u2óe1u2úe1u2àe1u2èe1u2òi1i2éi1i2íi1i2ói1i2úi1i2ài1i2èi1i2òi1u2éi1u2íi1u2ói1u2úi1u2ài1u2èi1u2òo1i2éo1i2ío1i2óo1i2úo1i2ào1i2èo1i2òo1u2éo1u2ío1u2óo1u2úo1u2ào1u2èo1u2òu1i2é1f2lòu1i2óu1i2úu1i2àu1i2èu1i2òu1u2éu1u2íu1u2óu1u2úu1u2àu1u2èu1u2òé1i2aé1i2eé1i2oé1i2ué1u2aé1u2eé1u2oé1u2ié1u2uí1i2aí1i2eí1i2oí1i2uí1u2aí1u2eí1u2oí1u2ií1u2uó1i2aó1i2eó1i2oó1i2uó1u2aó1u2eó1u2oó1u2ió1u2uú1i2aú1i2eú1i2oú1i2uú1u2aú1u2eú1u2oú1u2iú1u2uà1i2aà1i2eà1i2oà1i2uà1u2aà1u2eà1u2oà1u2ià1u2uè1i2aè1i2eè1i2oè1i2uè1u2aè1u2eè1u2oè1u2iè1u2uò1i2aò1i2eò1i2oò1i2uò1u2aò1u2eò1u2oò1u2iò1u2uï1i2aï1i2eï1i2oï1i2éï1i2íï1i2óï1i2úï1i2àï1i2èï1i2òï1i2uï1u2aï1u2eï1u2oï1u2éï1u2íï1u2óï1u2úï1u2àï1u2èï1u2òï1u2iï1u2uü1i2aü1i2eü1i2oü1i2éü1i2íü1i2óü1i2úü1i2àü1i2èü1i2òü1i2uü1u2aü1u2eü1u2oü1u2éü1u2íü1u2óü1u2úü1u2àü1u2èü1u2òü1u2iü1u2u_hi2a_hi2e_hi2o_hi2u_hu2a_hu2e_hu2i_hu2o1f2lè1f2ré1f2rí1f2ró_hi2é_hi2ó_hi2ú_hi2à_hi2è_hi2ò_hu2é_hu2í_hu2ó_hu2à_hu2è_hu2ò1f2rú1f2rà1f2rè1f2rò1g2lé1g2lí1g2ló1g2lú1g2là1g2lè1g2lò1g2ré1g2rí1g2ró1g2rú1g2rà1g2rè1g2rò1p2lé1p2lí1p2ló1p2lú1p2là1p2lè1p2lò1p2ré1p2rí1p2ró1p2rú1p2ràui3etsub3as3esps3empqui3e1p2rè1p2ròin3ex1t2rées3asa1um_e1um_i1um_o1um_u1um_es3ap_be2n_be2s_bi2s_ca2p_ce2les3afe3ris_co2n_co2r_de2s_di2s_en3ae3rio1t2ríe3ismbi3se1t2ró1t2rú_in3o1t2rà_ma2l3l2la_pa2n_pe2r1t2rè1t2rò1n2yé1n2yí_re2d_su2b1n2yó1n2yú1n2yàp2neu1n2yè1n2yò1f2lào3gnò");
            put(6, "_in3aces3int_sub3oes3arr_cla2res3aco_co2ll_psa2l_pos2t_pe3rides3avdes3ar_in3es_in3ap_in3addes3ag");
            put(7, "u1ista__inte2rdes3enc_supe2ra1isme__hipe2re1isme_i1isme_o1isme_u1isme__rebe2sa1ista_e1ista_o1ista_i1ista__tran2s");
            put(8, "_subde2s_antihi2");
            put(9, "_hiperm2n");
            put(10, "_mal1t2husein1s2tein");
            put(12, "ru1t2herfordni2etz1sc2he");
        }
    }), kn("kn", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "ಅ1ಆ1ಇ1ಈ1ಉ1ಊ1ಋ1ಎ1ಏ1ಐ1ಒ1ಔ1ೀ1ು1ೂ1ೃ1ೆ1ೇ1ೊ1ೋ1ೌ1್2ಃ1ಂ11ಕ1ಗ1ಖ1ಘ1ಙ1ಚ1ಛ1ಜ1ಝ1ಞ1ಟ1ಠ1ಡ1ಢ1ಣ1ತ1ಥ1ದ1ಧ1ನ1ಪ1ಫ1ಬ1ಭ1ಮ1ಯ1ರ1ಲ1ವ1ಶ1ಷ1ಸ1ಹ1ಳ1ಱ");
            put(3, "2ಃ12ಂ1");
        }
    }), ml("ml", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "ാ1ി1ീ1ു1ൂ1ൃ1െ1േ1ൈ1ൊ1ോ1ൌ1ൗ11ക1ഖ1ഗ1ഘ1ങ1ച1ഛ1ജ1ഝ1ഞ1ട1ഠ1ഡ1ഢ1ണ1ത1ഥ1ദ1ധ1ന1പ1ഫ1ബ1ഭ1മ1യ1ര1റ1ല1ള1ഴ1വ1ശ1ഷ1സ1ഹ2ൺ2ൻ2ർ2ൽ2ൾ2ൿ");
            put(3, "1അ11ആ11ഇ11ഈ11ഉ11ഊ11ഋ11ൠ11ഌ11ൡ11എ11ഏ11ഐ11ഒ11ഓ11ഔ12ഃ12ം12്2ന്2ര്2ള്2ല്2ക്2ണ്2");
            put(4, "2ന്%u200D2ര്%u200D2ല്%u200D2ള്%u200D2ണ്%u200D2ക്%u200D");
        }
    }), tr("tr", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "2a12â12e12ı12i12î12o12ö12u12ü12û11b11c11ç11d11f11g11ğ11h11j11k11l11m11n11p11r11s11ş11t11v11y11z12bb2bc2bç2bd2bf2bg2bğ2bh2bj2bk2bl2bm2bn2bp2br2bs2bş2bt2bv2by2bz2cb2cc2cç2cd2cf2cg2cğ2ch2cj2ck2cl2cm2cn2cp2cr2cs2cş2ct2cv2cy2cz2çb2çc2çç2çd2çf2çg2çğ2çh2çj2çk2çl2çm2çn2çp2çr2çs2çş2çt2çv2çy2çz2db2dc2dç2dd2df2dg2dğ2dh2dj2dk2dl2dm2dn2dp2dr2ds2dş2dt2dv2dy2dz2fb2fc2fç2fd2ff2fg2fğ2fh2fj2fk2fl2fm2fn2fp2fr2fs2fş2ft2fv2fy2fz2gb2gc2gç2gd2gf2gg2gğ2gh2gj2gk2gl2gm2gn2gp2gr2gs2gş2gt2gv2gy2gz2ğb2ğc2ğç2ğd2ğf2ğg2ğğ2ğh2ğj2ğk2ğl2ğm2ğn2ğp2ğr2ğs2ğş2ğt2ğv2ğy2ğz2hb2hc2hç2hd2hf2hg2hğ2hh2hj2hk2hl2hm2hn2hp2hr2hs2hş2ht2hv2hy2hz2jb2jc2jç2jd2jf2jg2jğ2jh2jj2jk2jl2jm2jn2jp2jr2js2jş2jt2jv2jy2jz2kb2kc2kç2kd2kf2kg2kğ2kh2kj2kk2kl2km2kn2kp2kr2ks2kş2kt2kv2ky2kz2lb2lc2lç2ld2lf2lg2lğ2lh2lj2lk2ll2lm2ln2lp2lr2ls2lş2lt2lv2ly2lz2mb2mc2mç2md2mf2mg2mğ2mh2mj2mk2ml2mm2mn2mp2mr2ms2mş2mt2mv2my2mz2nb2nc2nç2nd2nf2ng2nğ2nh2nj2nk2nl2nm2nn2np2nr2ns2nş2nt2nv2ny2nz2pb2pc2pç2pd2pf2pg2pğ2ph2pj2pk2pl2pm2pn2pp2pr2ps2pş2pt2pv2py2pz2rb2rc2rç2rd2rf2rg2rğ2rh2rj2rk2rl2rm2rn2rp2rr2rs2rş2rt2rv2ry2rz2sb2sc2sç2sd2sf2sg2sğ2sh2sj2sk2sl2sm2sn2sp2sr2ss2sş2st2sv2sy2sz2şb2şc2şç2şd2şf2şg2şğ2şh2şj2şk2şl2şm2şn2şp2şr2şs2şş2şt2şv2şy2şz2tb2tc2tç2td2tf2tg2tğ2th2tj2tk2tl2tm2tn2tp2tr2ts2tş2tt2tv2ty2tz2vb2vc2vç2vd2vf2vg2vğ2vh2vj2vk2vl2vm2vn2vp2vr2vs2vş2vt2vv2vy2vz2yb2yc2yç2yd2yf2yg2yğ2yh2yj2yk2yl2ym2yn2yp2yr2ys2yş2yt2yv2yy2yz2zb2zc2zç2zd2zf2zg2zğ2zh2zj2zk2zl2zm2zn2zp2zr2zs2zş2zt2zv2zy2zz");
            put(4, "a3a2a3â2a3e2a3ı2a3i2a3î2a3o2a3ö2a3u2a3ü2a3û2â3a2â3â2â3e2â3ı2â3i2â3î2â3o2â3ö2â3u2â3ü2â3û2e3a2e3â2e3e2e3ı2e3i2e3î2e3o2e3ö2e3u2e3ü2e3û2ı3a2ı3â2ı3e2ı3ı2ı3i2ı3î2ı3o2ı3ö2ı3u2ı3ü2ı3û2i3a2i3â2i3e2i3ı2i3i2i3î2i3o2i3ö2i3u2i3ü2i3û2î3a2î3â2î3e2î3ı2î3i2î3î2î3o2î3ö2î3u2î3ü2î3û2o3a2o3â2o3e2o3ı2o3i2o3î2o3o2o3ö2o3u2o3ü2o3û2ö3a2ö3â2ö3e2ö3ı2ö3i2ö3î2ö3o2ö3ö2ö3u2ö3ü2ö3û2u3a2u3â2u3e2u3ı2u3i2u3î2u3o2u3ö2u3u2u3ü2u3û2ü3a2ü3â2ü3e2ü3ı2ü3i2ü3î2ü3o2ü3ö2ü3u2ü3ü2ü3û2û3a2û3â2û3e2û3ı2û3i2û3î2û3o2û3ö2û3u2û3ü2û3û2");
            put(6, "tu4r4k");
            put(7, "2e2cek_m1t4rak");
        }
    }), fi("fi", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "1ba1be1bi1bo1bu1by1da1de1di1do1du1dy1dä1dö1fa1fe1fi1fo1fu1fy1ga1ge1gi1go1gu1gy1gä1gö1ha1he1hi1ho1hu1hy1hä1hö1ja1je1ji1jo1ju1jy1jä1jö1ka1ke1ki1ko1ku1ky1kä1kö1la1le1li1lo1lu1ly1lä1lö1ma1me1mi1mo1mu1my1mä1mö1na1ne1ni1no1nu1ny1nä1nö1pa1pe1pi1po1pu1py1pä1pö1ra1re1ri1ro1ru1ry1rä1rö1sa1se1si1so1su1sy1sä1sö1ta1te1ti1to1tu1ty1tä1tö1va1ve1vi1vo1vu1vy1vä1vöä2yo1yö2ya1äa1öo1äo1öä2äö2öä2öö2ä_ä2u2sb2lb2rd2rf2lf2rg2lg2rk2lp2lp2rc2lq2v");
            put(4, "y1a2y1o2u1y2y1u2ö3a2ö3o2ä3a2ä3o2ä1u2ö1u2u1ä2u1ö2e1aai1aao1aau1aau1eea1uui1uue1uuo1uuää1iää1eää3yi1ääe1ääy1ääi1ööa1eia1oie1aii1auy1eiai1aai1eai1oai1uau1aau1eeu1aie1aie1oie1yiu1aiu1eiu1ooi1aoi1eoi1ooi1uo1uiou1eou1oue1aui1euo1auo1ue1ö2ö1e2r2asl2as1k2vsc2hts2h");
            put(5, "1st2raa1i2aa1e2aa1o2aa1u2ee1a2ee1i2ee1u2ee1y2ii1a2ii1e2ii1o2uu1a2uu1e2uu1o2uu1i2io1a2io1e2keus11b2lo1b2ri1b2ro1b2ru1d2ra1f2la1f2ra1f2re1g2lo1g2ra1k2ra1k2re1k2ri1k2va1p2ro1q2vich2r");
            put(6, "1sp2lialous1rtaus1perus12s1ase2s1apuulo2s1bib3li");
            put(7, "yli1o2pali1a2v2s1ohje1a2sian1a2siat1a2sioi2s1o2sa2n1o2sa_ydi2n12n1otto2n1oton2n1anto2n1anno2n1aika2n1a2jo2s1a2jo");
            put(8, "2s1a2sia2n1o2pet2s1a2loialkei2s12n1e2dus2s1ajatu2s1y2rit2s1y2hti2n1a2jan2n1o2mai2n1y2lit2s1a2len2n1a2len");
            put(9, "2s1o2pisk2n1o2pist2s1o2pist2s1i2dea_2s1i2dean2s1e2sity_suu2r1a2");
            put(11, "1a2siaka2s1");
        }
    }), ta("ta", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "ா1ி1ீ1ு1ூ1ெ1ே1ை1ொ1ோ1ௌ11க1ங1ச1ஜ1ஞ1ட1ண1த1ந1ப1ம1ய1ர1ற1ல1ள1ழ1வ1ஷ1ஸ1ஹ");
            put(3, "1அ11ஆ11இ11ஈ11உ11ஊ11எ11ஏ11ஐ11ஒ11ஓ11ஔ12ஂ12ஃ12ௗ12்1");
            put(4, "2க்12ங்12ச்12ஞ்12ட்12ண்12த்12ன்12ந்12ப்12ம்12ய்12ர்12ற்12ல்12ள்12ழ்12வ்12ஷ்12ஸ்12ஹ்1");
        }
    }), sk("sk", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "a1á1ä1e1é1i1í1o1ó1ô1u1ú1y1ý1");
            put(3, "i2ai2ái2ei2uo2uc2hd2zd2ž");
            put(4, "2b1b2b1c2b1č2b1d2b1ď2b1f2b1g2b1h2b1j2b1k2b1l2b1ľ2b1m2b1n2b1ň2b1p2b1r2b1s2b1š2b1t2b1ť2b1v2b1w2b1x2b1z2b1ž2c1b2c1c2c1č2c1d2c1ď2c1f2c1g2c1j2c1k2c1l2c1ľ2c1m2c1n2c1ň2c1p2c1r2c1s2c1š2c1t2c1ť2c1v2c1w2c1x2c1z2c1ž2č1b2č1c2č1č2č1d2č1ď2č1f2č1g2č1h2č1j2č1k2č1l2č1ľ2č1m2č1n2č1ň2č1p2č1r2č1s2č1š2č1t2č1ť2č1v2č1w2č1x2č1z2č1ž2d1b2d1c2d1č2d1d2d1ď2d1f2d1g2d1h2d1j2d1k2d1l2d1ľ2d1m2d1n2d1ň2d1p2d1r2d1s2d1š2d1t2d1ť2d1v2ď1b2ď1c2ď1č2ď1d2ď1ď2ď1f2ď1g2ď1h2ď1j2ď1k2ď1l2ď1ľ2ď1m2ď1n2ď1ň2ď1p2ď1r2ď1s2ď1š2ď1t2ď1ť2ď1v2ď1z2ď1ž2f1b2f1c2f1č2f1d2f1ď2f1f2f1g2f1h2f1j2f1k2f1l2f1ľ2f1m2f1n2f1ň2f1p2f1r2f1s2f1š2f1t2f1ť2f1v2f1z2f1ž2g1b2g1c2g1č2g1d2g1ď2g1f2g1g2g1h2g1j2g1k2g1l2g1ľ2g1m2g1n2g1ň2g1p2g1r2g1s2g1š2g1t2g1ť2g1v2g1z2g1ž2h1b2h1c2h1č2h1d2h1ď2h1f2h1g2h1h2h1j2h1k2h1l2h1ľ2h1m2h1n2h1ň2h1p2h1r2h1s2h1š2h1t2h1ť2h1v2h1z2h1ž2j1b2j1c2j1č2j1d2j1ď2j1f2j1g2j1h2j1j2j1k2j1l2j1ľ2j1m2j1n2j1ň2j1p2j1r2j1s2j1š2j1t2j1ť2j1v2j1w2j1x2j1z2j1ž2k1b2k1c2k1č2k1d2k1ď2k1f2k1g2k1h2k1j2k1k2k1l2k1ľ2k1m2k1n2k1ň2k1p2k1r2k1s2k1š2k1t2k1ť2k1v2k1w2k1x2k1z2k1ž2l1b2l1c2l1č2l1d2l1ď2l1f2l1g2l1h2l1j2l1k2l1l2l1ľ2l1m2l1n2l1ň2l1p2l1r2l1s2l1š2l1t2l1ť2l1v2l1z2l1ž2ľ1b2ľ1c2ľ1č2ľ1d2ľ1ď2ľ1f2ľ1g2ľ1h2ľ1j2ľ1k2ľ1l2ľ1ľ2ľ1m2ľ1n2ľ1ň2ľ1p2ľ1r2ľ1s2ľ1š2ľ1t2ľ1ť2ľ1v2ľ1z2ľ1ž2m1b2m1c2m1č2m1d2m1ď2m1f2m1g2m1h2m1j2m1k2m1l2m1ľ2m1m2m1n2m1ň2m1p2m1r2m1s2m1š2m1t2m1ť2m1v2m1z2m1ž2n1b2n1c2n1č2n1d2n1ď2n1f2n1g2n1h2n1j2n1k2n1l2n1ľ2n1m2n1n2n1ň2n1p2n1r2n1s2n1š2n1t2n1ť2n1v2n1w2n1x2n1z2n1ž2ň1b2ň1c2ň1č2ň1d2ň1ď2ň1f2ň1g2ň1h2ň1j2ň1k2ň1l2ň1ľ2ň1m2ň1n2ň1ň2ň1p2ň1r2ň1s2ň1š2ň1t2ň1ť2ň1v2ň1z2ň1ž2p1b2p1c2p1č2p1d2p1ď2p1f2p1g2p1h2p1j2p1k2p1l2p1ľ2p1m2p1n2p1ň2p1p2p1r2p1s2p1š2p1t2p1ť2p1v2p1w2p1x2p1z2p1ž2r1b2r1c2r1č2r1d2r1ď2r1f2r1g2r1h2r1j2r1k2r1l2r1ľ2r1m2r1n2r1ň2r1p2r1r2r1s2r1š2r1t2r1ť2r1v2r1w2r1x2r1z2r1ž2s1b2s1c2s1č2s1d2s1ď2s1f2s1g2s1h2s1j2s1k2s1l2s1ľ2s1m2s1n2s1ň2s1p2s1r2s1s2s1š2s1t2s1ť2s1v2s1z2s1ž2š1b2š1c2š1č2š1d2š1ď2š1f2š1g2š1h2š1j2š1k2š1l2š1ľ2š1m2š1n2š1ň2š1p2š1r2š1s2š1š2š1t2š1ť2š1v2š1w2š1x2š1z2š1ž2t1b2t1c2t1č2t1d2t1ď2t1f2t1g2t1h2t1j2t1k2t1l2t1ľ2t1m2t1n2t1ň2t1p2t1r2t1s2t1š2t1t2t1ť2t1v2t1w2t1x2t1z2t1ž2ť1b2ť1c2ť1č2ť1d2ť1ď2ť1f2ť1g2ť1h2ť1j2ť1k2ť1l2ť1ľ2ť1m2ť1n2ť1ň2ť1p2ť1r2ť1s2ť1š2ť1t2ť1ť2ť1v2ť1w2ť1x2ť1z2ť1ž2v1b2v1c2v1č2v1d2v1ď2v1f2v1g2v1h2v1j2v1k2v1l2v1ľ2v1m2v1n2v1ň2v1p2v1r2v1s2v1š2v1t2v1ť2v1v2v1w2v1x2v1z2v1ž2z1b2z1c2z1č2z1d2z1ď2z1f2z1g2z1h2z1j2z1k2z1l2z1ľ2z1m2z1n2z1ň2z1p2z1r2z1s2z1š2z1t2z1ť2z1v2z1z2z1ž2ž1b2ž1c2ž1č2ž1d2ž1ď2ž1f2ž1g2ž1h2ž1j2ž1k2ž1l2ž1ľ2ž1m2ž1n2ž1ň2ž1p2ž1r2ž1s2ž1š2ž1t2ž1ť2ž1v2ž1z2ž1ž2x1t2x1n2b1ŕ2ŕ1ba1í2a1o2e1á2e1í2e1o2e1ó2e1u2i1o2o1a2o1e2o1i2o1o2u1a2u1á2u1i2u1í2u1o2u1u2y1a2y1e2y1ó2y1u2a2u1a2i1_vy5_vý5_cv6_ch6_sp6_st6_šk6_šp6_št6_tk6_uh6_uk6_um6_up6_us6_ús6_úš6_ut6_uv6_uz6_vd6_vh6_vk6_vp6_vs6_vš6_vt6_vz6_vž6_zb6_zg6_zh6_zm6_zr6_zv64lt_4rd_4st_4sť_");
            put(5, "b2l3bb2l3šb2ľ3šb2r3db2r3zb3s2cb3s2tc3k2tc3t2vč2r3pd2l3nd2r3ld2r3nd3s2vd3s2td3v2rj3s2tj3t2mj3t2rk2r3bk3s2ľk2s3nk3t2rl3d2rľ3k2nl3t2rm3b2lm3b2ľm3b2rm3f2lm3f2rm3k2nm3p2lm3p2ľm3p2rm3p2sm2r3lm2r3šm2r3tm3s2tm3š2tn3dľan3d2rn3f2ln3f2rn3g2hn3g2ln3g2ľn2g3nn3g2rn3g2vn3k2cn3k2hn3k2nn3k2rn3k2vn3s2cn3š2pn3š2tn3t2gn3t2ln3t2nn3t2rn2ž3mp3š2ťp3t2rr2b3nr3g2ľr3g2rr3g2sr3k2dr2k3nr3k2tr3k2vr3p2cr3p2čr3p2rr3s2pr3š2čr3š2lr3š2rr2t3mr3t2nr2t3ňr3t2rr3t2vs2k3ls2k3ms2k3ns3k2rs3k2vs3p2rs3t2ks2t3ls3t2ms2t3ns3t2rs3t2vs2ť3hs2ť3ms2ť3pš3k2lš3k2rš3t2rt3k2lt3k2nt3h2lz3d2nz3g2nž2d3n3ž2ľtž3s2tx3p2lx3p2rx3t2rb3s4kd3s4kj3s4kl3s4kľ3s4kn3s4kp3s4kr3s4kš3s4kt3s4kv3s4kz3s4kž3s4kn2d3č_bez5_do5o_do5u_ge4o_o5p4_po5u5päť5_usk6_úsl6_usm6_úsm6_vzh6_vzk6_vzl6_vzp6_zd6n_zd6r_zd6v8c4h_8d4z_8d4ž_");
            put(6, "2b1c2h2b1d2z2b1d2ž2c1c2h2c1d2z2c1d2ž2č1c2h2č1d2z2č1d2ž2d1c2h2d1d2z2d1d2ž2ď1c2h_atmo32ď1d2z2ď1d2ž2f1c2h2f1d2z2f1d2ž2g1c2h2g1d2z2g1d2ž2h1c2h2h1d2z2h1d2ž2c2h1b2c2h1c2c2h1č2c2h1d2c2h1ď2c2h1f2c2h1g2c2h1h2c2h1j2c2h1k2c2h1l2c2h1ľ2c2h1m2c2h1n2c2h1ň2c2h1p2c2h1r2c2h1s2c2h1š2c2h1t2c2h1ť2c2h1v2c2h1w2c2h1ž2j1c2h2j1d2z2j1d2ž2k1c2h2k1d2z2k1d2ž2l1c2h2l1d2z2l1d2ž2ľ1c2h2ľ1d2z2ľ1d2ž2m1c2h2m1d2z2m1d2ž2n1c2h2n1d2z2n1d2ž2ň1c2h2ň1d2z2ň1d2ž2p1c2h2p1d2z2p1d2ž2r1c2h2r1d2z2r1d2ž2s1c2h2s1d2z2s1d2ž2š1c2h2š1d2z2š1d2ž2t1c2h2t1d2z2t1d2ž2ť1c2h2ť1d2z2ť1d2ž2v1c2h2v1d2z2v1d2ž2z1c2h2z1d2z2z1d2ž2ž1c2h2ž1d2z2ž1d2ž2d2z1k2d2z1n2d2z1r2d2z1s2d2ž1š2d2z1ŕ2ŕ1d2z2d2z1ľ2ŕ1d2ž2d2ž1ľ3b2l3č3b2l3k3b2ľ3k3b2l3ň3b2r3b3b2r3k3b2ŕ3k3b2r3l3b2ŕ3ľ3b2r3n3b2r3ň3b2r3v3c2r3č3c2ŕ3č3c2r3k3c2ŕ3k3č2l3n3č2r3č3č2r3t3č2r3v3d2l3b3d2l3h3d2l3ž3d2ľ3ž3d2r3d3d2r3g3d2r3k3d2r3m3d2r3v3d2r3z3d2r3ž3d2ŕ3ž3f2r3č3f2r3f3f2r3k3f2ŕ3k3f2r3m3f2r3n3g2l3g3g2r3c3g2r3g3h2l3b3h2ľ3b3h2l3t3h2m2l3h2r3b3h2ŕ3b3h2r3č3h2r3d3h2r3k3h2r3m3h2r3n3h2r3ň3h2r3t3h2r3vj3š2le3k2l3b3k2ľ3b3k2l3č3k2l3z3k2ľ3z3k2r3č3k2ŕ3č3k2ŕ3d3k2r3k3k2ŕ3k3k2ŕ3m3k2r3p3k2r3s3k2r3t3k2r3v3m2l3č3m2l3k3m2r3h3m2r3k3m2r3v3m2r3z3m2ŕ3z3p2l3n3p2l3ň3p2ľ3ň3p2l3z3p2ľ3z3p2ľ3ž3p2ŕ3c3p2r3č3p2r3d3p2r3s3p2r3š3s2l3n3s2l3ň3s2l3z3s2r3d3s4ŕ3k3s4r3š3š4t4v3t2l3č3t2l3k3t4r3č3t4r3h3t2r3l3t2r3k3t2r3m3t2r3n3t2ŕ3n3t2ŕ3ň3t4r3p3t2r3v3t2ŕ3ž3v2l3č3v2ľ3č3v2l3h3v2l3k3v2l3n3v2r3h3v2r3l3v2ŕ3š3v2ŕ3t3v2r3z3v2ŕ3z3v4z4d3v4z4h3v4z4n3v3z2ť3z4d4r3z4d4v3z4h4r3z2r3k3z2r3n3z4v4l3ž2l3č3ž2l3t3ž2r3ď4m3s4kz3š2t2_belo5_bi2o5_biok4_biop4_bios4_bože5_b2z2d_c4t4n_čo5s4_de5f4_de5g4_dek4l_do5d4_do5f4_do5h4_do5i4_do5k4_do5p4_do5s4_do5v4_do5z4_do5ž4_ex5k4_foto5_ľ4s4t_m4z4d_na5a4_na5b4_na5c4_na5h4_na5i4_na5k4_na5m4_na5o4_na5p4_ná5p4_na5s4_ná5s4_na5š4_na5t4_na5u4_na5ú4_ná5u4_ná5ú4_na5ž4_ne5a4_ne5e4_ne5i4_ne5m4_ne5p4_ne5s4_ne5š4_ne5t4_ne5u2_ne5ú2_ne5v4_ni5k4_ob5k4_ob5s4_ob5t4_ob5z4_od5b4_od5c4_od5d4_od5f4_od5h4_od5i4_od5í4_od5k4_od5p4_od5s4_od5š4_od5t4_od5v4_od5z4_t4v4r_o5h4l_o5h4ľ_o5h4r_o5k4l_o5k4ľ_o5m4l_o5m4n_o5m4r_o5v4r_o5z4n_po5b4_po5č4_po5h4_po5i4_po5k4_po5m4_po5o4_po5s4_po5š4_po5t4_po5v4_po5z4_re5g4_re5k4_re5p4_re5š4_re5t4_sú5h4_sú5s4_sú5v4_sú5z4_troj5_vo5t4_vo5v4_vy5b4_vy5c4_vý5c4_vy5č4_vý5č4_vy5d4_vý5d4_vy5h4_vý5h4_vy5k4_vý5k4_vy5m4_vy5p4_vý5p4_vy5s4_vý5s4_vy5š4_vy5t4_vý5t4_vy5v4_vy5z4_vý5z4_za5b4_zá5b4_za5c4_za5č4_za5d4_za5h4_za5k4_za5m4_za5p4_za5r4_za5s4_za5š4_za5t4_za5v4_za5z4_za5ž4_zá5k4_zá5z4_zo5b4_zo5h4_zo5s4_zo5š4_zo5t4_zo5v4_zo5z4_zo5ž45b4lah5b4lok5b4lúd5b4rať5b4ruč5b4rús5c4muk5c4nie5c4vak5c4vič5c4vik5č4len5č4lov5d4ňov5d4rať5d4vih5d4viž5d4voj5d4vor5f4ľak5f4ráz5g4raf5g4ram5g4réč5g4rob5h4lad5h4las5h4lav5h4ľad5h4mat5h4mot5h4nať5h4ned5h4nev5h4noj5h4nut5h4núť5h4nút5h4rab5h4ran5h4rať5h4rob5h4rom5h4roz5h4rub5h4ryz5k4lad5k4laď5k4ľak5k4lam5k4lep5k4les5k4ľúč5k4ruh5k4rúž5k4ryt5k4vet5m4nož5m4rav5m4ráz5p4lán5p4lat5p4lav5p4rávs6práv5s4fér5s4koč5s4kok5s4kop5s4kor5s4kôr5s4lav5s4láv5s4led5s4lep5s4luh5s4lúž5s4ľub5s4maž5s4mel5s4mer5s4pev5s4por5s4tav5s4tup5s4ved5š4ľah5š4pin5š4tát5š4tep5š4tít5t4lač5t4lak5t4ras5t4rub5uhoľn5v4lád5v4las5v4rás5v4rav5v4rat5v4rát5v4ták5v4tip5z4lom5z4luč5z4nak5z4nám5z4rak5z4väz5z4vod5z4vuk5z4vuč5ž4ráč5ž4reb5ž4rút_uc6h6_úsc6h_ús7ti_ust6l_ust6rr4p4t_r4š4č_r4t4z_");
            put(7, "b2l3c2hd3c4h4nj2c2h3nm2r3c4ha4t2r3nnoz5d4rb3s2t2rd4ľ4ž3kd4l4ž3nd4ľ4ž3nh2r4d3lj3s4t4rj3s4t4vm3p4r3pm3p4r3vn4g3s4tn3š4t4rn3t4l3mp2ŕ4c3nr2s3k4dr2s3k4ts3t4r3bs4t4r3vš4t4r3nt2r4č3kk4č3ný_k4č3né_k4č3ná_k4č3nú_k4č3ní_k4t3ný_k4t3né_k4t3ná_k4t3nú_k4t3ní_n4č3ný_n4č3né_n4č3ná_n4č3nú_n4č3ní_n4k4č3nn4t3ný_n4t3né_n4t3ná_n4t3nú_n4t3ní_r4d3ný_r4d3né_r4d3ná_r4d3nú_r4d3ní_r4m3ný_r4m3né_r4m3ná_r4m3nú_r4m3ní_r4p4č3nr4t3ný_r4t3né_r4t3ná_r4t3nú_r4t3ní_s4t3ný_s4t3né_s4t3ná_s4t3nú_s4t3ní_z4d3ny_z4d3ne_z4d3na_z4d3nu_z4d3ni_z4d3ný_z4d3né_z4d3ná_z4d3nú_z4d3ní_b2l4š3kn2k2t3kl4p3s4kl4t3s4kn4d3s4kn4t3s4kp4t3s4kr4t3s4kr4z5s4kb3s4t4vč3s4t4vd3s4t4vď3s4t4vľ3s4t4vm3s4t4vn3s4t4vp3s4t4vr3s4t4vš3s4t4vt3s4t4vv3s4t4vž3s4t4v_a2e2ro_ap4rio_ap4rió_bez5b4_bez5d4_bez5h4_bez5k4_bez5m4_bez5p4_bez5s4_bez5t4_bez5v4_bez5z4_bielo5_blaho5_bledo5_čo5ch4_da3k2d_desať5_dez5i2_dez5o2_do5č2m_do5š4p_do5t4l_do5t4m_do5t4r_do5t4v_dvoj5u_fol2k5_hydro5_juho5a_koso5u_lesos4_malo5o_mimo5ú_nad5h4_nad5p4_na5st4_ná5st4_na5šk4_na5v4l_na5z4r_na5z4v_náz5v4_ne6t5t_ne5z4l_ne5z4m_ne5z4n_ne5z4r_ne5z4v_nie5k4_obi5d4_obo5s4_obo5z4_od6i5ó_odo5b4_odo5h4_odo5k4_odo5p4_odo5s4_o5h4na_o5h4nú_o5c4h4_o5k4ra_o5k4rá_o5k4ri_o5k4rí_o5k4ru_o5k4rú_o5s4lo_o5s4p4_o5š4k4_o5š4ľ4_o5š4m4_o5š4p4_o5š4v4_o5v4p4_o5z4l4_o5z4re_plno5a_pod5h4_pod5k4_pod5p4_pod5re_pod5v4_pod3ža_pod3žu_pol5d4_polo5a_polo5i_po6š5v_po5t4ľ_po5t4r_pra5o4_pra5p4_pre5b4_pre5c4_pred5i_pre5č4_pre5e2_pre5f2_pre5h4_pre5i4_pre5k4_pre5m4_pre5o4_pre5p4_pre5s4_pre5š4_pre5t4_pre5v4_pre5z4_pre5ž4_pri5b4_pri5č4_pri5d4_pri5h4_pri5k4_prí5k4_pri5m4_pri5p4_pri5s4_prí5s4_pri5š4_pri5t4_pri5v4_pri5z4_pri5ž4_re6k5v_re6p5n_štáto5_sú5k4r_sú5m4r_vo5p4r_vo5s4p_vy6h5ň_vy6š5š_vý6š5k_zo6d5p_zo5d4r_zo5d4v_zo5m4l_zo5m4rauto4rkauto4rs5b4ledn5b4lesk5b4lysk5b4lysn5boh3z45b4rázd5b4ronz5b4rýzg5č4lánk5f4lias5h4liad5h4luch5c6hran5k4lásť5k4liat5k4liať5k4resb5k4resť5k4rídl5k4rôch5k4vadr5p4leta5p4letú5p4riam5s4ladk5s4lovn5s4love5s4lova5s4lovk5s4piev5s4tati5šes4ť55s4t4la5š4liap5š4kola5š4tart5š4tude5š4tudo5š4tyli5š4ťast5štiep45t4resk5t4ried5v4čera5v4šimn5v4z4du5z4mysl5z4náša5z4vest5zv4esť5ž4rane_usc6h6_ús7ta__ús7toč_úst7ny_ús6t6r4b4s4ť_4c4ht4_4j4s4ť_4m4p4r_4m4p4s_4m4š4t_4n4k4t_4p4r4v_5k4rát_akci3a2");
            put(8, "_a2u1to32c2h1c2h2c2h1d2z2c2h1d2ž3h2r3d2z3c2h2l3p3c2h2r3b3c2h2r3č3c2h2r3l3c2h2r3t3s4c4h4n3v2r3c2h3b2l4č3n3b2ľ4č3k3b2l4n3k3b2ľ3k2n3b2r4b3l3b2r4b3t3b2r4č3k3b2r4d3c3b2ŕ4d3n3b2r3h2l3b4ŕ4k3n3b4r4m3b3b4r4n3č3b4r4n3k3b4r4š3l3b4r4t3l3b4r4t3n3b4r4v3n3b4r4z3d3b4r4z3l3b4r4z3n3c4ŕ4č3k3c4r4k3n3c4v4r3č3c4v4r3k3c4v4ŕ3k3c4v4r3l3č4l4n3k3č4r3č4r3č4r4p3k3č4r4p3n3č4r4t3n3č4v4r3k3č4v4r3l3d4l4b3n3d4r4c3n3d4r4g3ľ3d4r4g3n3d4r4h3n3d4r4n3č3d4r4n3k3d4r4s3n3d4r4ž3b3d4r4ž3k3f4r4c3k3f4r4c3n3f4r4č3k3f4r4f3l3f4r4k3n3f4r4n3d3f4r4n3g3f4r4n3k3g4l4g3n3g2r4c3k3h2ľ4b3k3h2l3t4n3h2r4b3č3h2r4č3k3h2r4g3ľ3h2r4k3ľ3h2r4k3n3h2ŕ4k3n3h2r4n3č3h2r4s3t3h2r4s3ť3k4l4b3č3k4l4b3k3k4l4z3k3k4l4z3n3k4r4č3m3k4r4č3n3k4r4k3v3k4r4m3n3k4ŕ4m3n3k4r4p3č3k4r4s3t3k4r4š3t3k4r4t3k3k4r4v3n3m2l4č3k3m2ľ4k3n3m2ľ4k3v3m2l4s3n3m4r4k3n3m4r4k3v3m4r4m3l3m4r4n3č3m4r4n3k3m4ŕ4š3t3m4ŕ4t3v3m4r4z3l3m4r4z3k3m4r4z3n3p2l4z3l3p2ľ4z3n3p2r4č3k3p4r4d3n3p4r4s3k3p4r4t3k3s4l4n3k3s4k4r3z3s4m4r3c3s4m4r3č3s4m4r3d3s4m4r3k3s4m4r3t3s4r4d3c3s4r4k3n3s4r4s3t3s4t4ľ3k3s4t4r3č3s4t4ŕ3h3s4t4r3k3š4k4l3b3š4k4r3k3š4k4ŕ3k3š4k4r3t3š4p4l3h3š4t4r3b3t2ľ4c3ť3t2r4b3l3t2r4d3l3t2r4h3l3t2r4h3n3t2r4k3n3t2r4k3v3t2r4m3n3t4ŕ4p3n3t2r4ž3k3t2r4ž3n3t2v4r3d3v2l4h3č3v2l4h3k3v2l4h3n3v2l4n3k3v2l4n3n3v4r4h3n3v4r4k3n3v4ŕ4z3g3v4r4z3g3v4r4z3n3v4r4ž3l3z4h4ŕ3ň3z4r4n3n3ž4l4č3n3ž4l4t3n3ž4r4d3kk4č3nom_k4č3ným_k4č3nej_k4č3nou_k4t3nom_k4t3ným_k4t3nej_k4t3nou_n4č3nom_n4č3ným_n4č3nej_n4č3nou_n4t3nom_n4t3ným_n4t3nej_n4t3nou_r4d3nom_r4d3ným_r4d3nej_r4d3nou_r4m3nom_r4m3ným_r4m3nej_r4m3nou_r4t3nom_r4t3ným_r4t3nej_r4t3nou_s4t3nom_s4t3ným_s4t3nej_s4t3nou_z4d3nom_z4d3nym_z4d3nej_z4d3nou_z4d3ným_l2t3k2a_l2t3k2y_l2t3k2e_l2t3k2u_n2t3k2a_n2t3k2y_n2t3k2e_n2t3k2u_p2t3k2a_p2t3k2y_p2t3k2e_p2t3k2u_s2t3k2a_s2t3k2y_s2t3k2e_s2t3k2u_5p4r4s3t4m4p3s4kr4z3š2t2_arci5k4_belo5h4_bielob4_bieloh4_bielov4_blahop4_blahos4_boha5p4_boho5s4_bože5d4_celo5d4_celo5k4_celo5p4_celo5s4_celo5u4_ceno5t4_cyto5p4_čaro5k4_čaro5s4_čaro5v4_čaro5z4_čudo5t4_de5š4t2_divo5t4_dlho5h4_dlho5p4_do5c4h4_do5š4tí_drevo5o_dvoj5al_dvoj5č4_dvoj5d4_dvoj5h4_dvoj5i4_dvoj5k4_dvoj5p4_dvoj5s4_dvoj5t4_dvoj5v4_dvoj5z4_gala5p4_gama5g4_hnedo5o_hnedo5u_holo5b4_holo5h4_holo5k4_hore5z4_jasno5o_juho5s4_kata5k4_koso5d4_koso5š4_krvi5p4_krvi5s4_krvi5t4_málo5k4_málo5v4_melo5d4_meru5ô2_mikro5o_mimo5š4_mimo5v4_mnoho5u_mnoho5v_mnoho5z_modro5o_mravo5u_na6š5sk_na5v4na_na5v4r4_ná5v4r4_na5v4z4_novo5u2_novo5z2_od5c4h4_okolo5i_o6p5lan_o6p5rat_o5s4lab_o5s4lad_o5s4lav_o5s4láv_o5s4lep_o5s4tar_o5s4tať_o5s4tan_o5s4taň_o5s4táv_o5s6to5_ostro5u_o5s4ved_o5s4vit_o5s4voj_o5t4ras_o5t4rav_o5t4ráv_o5t4rep_o5t4ria_o5v4dov_o5v4lád_o5v4laž_o5z4v4l_plno5p4_plno5š4_poda5k4_pod5b4r_pod5c4h_po5d4rh_po5d4rm_po5d4rv_pod3zem_pod3zol_po5c4h4_pol5i4z_polo5b4_polo5d4_polo5k4_polo5m4_polo5o4_polo5p4_polo5s4_polo5t4_polo5u4_polo5ú4_polo5v4_polo5z4_pol5s4t_po5ob4h_po5ob4l_po6š5ta_po6s5ti_po4v5ra_povy5h4_povy5k4_povy5p4_povy5s4_povy5v4_povy5z4_pra5v4l_pred5c4_pred5h4_pred5k4_pred5m4_pred5op_pred5p4_pred5s4_pred5v4_pred5z4_pre6s5n_prí6s5p_pri6s5p_ro4z5i4_ro6z5í4_rozo5b4_rozo5d4_rozo5m4_rozo5p4_rozo5r4_rozo5s4_rozo5š4_rozo5z4_rozo5ž4_ro6z5u4_ro6z5v43s4polu5_šikmo5o_široko5_št4vor5_su4b5s4_viac5k4_viac5v4_vide2o5_vo5p4ch_vy6h5ne_vy5c4h4_za5c4h45alkohol5b4rec2hčí6s5lov5č4lánok5d4ramat5e2u2róp5f4rancú5h4niezd5h4r3mot5h4viezd5c6h4lap5c6h4leb5c6h4rán5c6h4ráň5c6h4vál5c6h4vát5c6h4vat5k4ritic5k4valif5k4valit5p4letie5p4liesť5p4rirod5p2risám5p4roduk5s4k4lad5s4k4lon5s4k4rot5s4k4rúc5s4k4rýv5s4kúsen5s4kutoč5s4k4vúc5s4tatic5s4t4ran5s4t4rán5s4t4raš5s4t2rat5s4t2red5s4t2rek5s4t4rel5s4t4reľ5s4t4rih5s4t4riž5s4t4rom5s4t4rúh5s4t4run5s4t4ruž5š4k4rab5š4k4rie5š4print5t4retin5t4r4vaj5t4r4val5t4r4van5uholník5viac5h45v4z4ťah5v4z4ťaž5z4mysel_ús7tretkli3e2nt");
            put(9, "_as4t4ro3c2h2r3c4h3ch4ľ4p3kčer4s3t4vmaš3k4r3tb3d4ľ4ž3nh2ŕ4s3t4ks3t4r4n3kk4č3ného_k4č3nému_k4č3ných_k4č3nými_k4t3ného_k4t3nému_k4t3ných_k4t3nými_n4č3ného_n4č3nému_n4č3ných_n4č3nými_n4t3ného_n4t3nému_n4t3ných_n4t3nými_r4d3ného_r4d3nému_r4d3ných_r4d3nými_r4m3ného_r4m3nému_r4m3ných_r4m3nými_r4t3ného_r4t3nému_r4t3ných_r4t3nými_s4t3ného_s4t3nému_s4t3ných_s4t3nými_z4d3neho_z4d3nemu_z4d3nych_z4d3nymi_z4d3ného_z4d3nému_z4d3ných_z4d3nými_l2t3k2ou_l2t3k2ám_n2t3k2ou_n2t3k2ám_p2t3k2ou_p2t3k2ám_s2t3k2ou_s2t3k2ám_n4k4t3s4kn4t3s4t4vr4v5s4t4v_aero3g2r_aero3p2l_aero3s2k_aero3s2t_aero3t2r_anti5k4l_anti5k4r_apo5p4le_as3k2lep_balne2o3_božec2h4_cudzo5k4_cudzo5o4_cudzo5s4_cudzo5t4_cudzo5v4_černo5b4_černo5h4_černo5k4_černo5o4_dis2k3d4_dobro5d4_dobro5p4_dobro5s4_do5š4tie_drevo5p4_drevo5v4_druho5s4_elektro5_horno5u4_hrôzo5v4_hrôzy5p4_hrubo5s4_jasno5z4_jedno5h4_jedno5i4_jedno5p4_jedno5s4_jedno5u4_jedno5z4_južno5s4_kmeňo5t4_krivo5p4_kruto5v4_lásky5p4_ľudovo5u_makro5k4_makro5o4_makro5s4_márno5t4_medzi5h4_medzi5i4_medzi5p4_medzi5š4_medzi5t4_mikro5e4_mikro5k4_mikro5p4_mnoho5s4_mnoho5t4_mrako5d4_mucho5t4_na5d4p4__na5d4ŕ4__na6z5vyš_ne5na5h4_ne5na5i4_ne5na5k4_ne5na5m4_ne5na5p4_ne5na5s4_ne5na5t4_ne6s5tor_ne5z4d4r_ne5z4d4v_ni6k5toš_nízko5k4_odo5m4k4_okolo5s4_o6s5tatn_o5s4tatk_o5s4vetl_o5s4viet_o5s4viež_päť5izbo_plno5kr4_po5d4ráž_po5d4rep_po5d4rie_po5d4r4ž_po6h5reb_polo5h4l_po6m5ník_po6s5tul_po6š5tov_po5t4k4n_poroz5p4_poroz5s4_poroz5v4_po5v4z4b_pra5v4nu_pra5v4nú_pred5ch4_predo5h4_pre5d4ri_pre5d4rž_pre5c4h4_pri5c4h4_pri5s4pô5f4rekvenpro6g5ram5g4vardej5c6h4vostna5d4ž4gana5d4ž4gánav3š4tevnáv3š4tevnav3š4tív5p4lastik5s4c2hopn5s4k4rutk5s4potreb5s4p4rávn5s4p4ravo5s4tarost5s4t4rach5s4t4ráda5s4t4riel5s4t4rieľ5päť5s4to5š4t4vera5t4ran4s5_ús7tami__us7t4ric5t4ľ4c4ť_t2ri3u2mf");
            put(10, "3č4r4c4h3n3f4r4n3d4ž3c2h2r4b3t3c4h4r4s3t3p4ŕ4c2h3n3s4p4r3c4hko4s3t4r3č4s4ť5k4rát3š4t4v4r3t3š4t4v4r3ť3t2v4r3d4z3t2v4ŕ3d4z3b4r4n3k4n3c4v4r4č3k3c4v4r4n3k3č4ŕ4s3t4v3č4r4t4t3n3č4v4r4k3n3d4r4ž3g4r3f4r4n4g3n3k4r4s4t3n3k4r4s4t3ň3s4m4r4š3ť3s4m4r4t3k3š4k4l4b3n3š4k4r4t3n3š4k4v4r3č3š4k4v4r3k3š4k4v4ŕ3k3š4k4v4r3n3š4m4r4d3k3š4m4r4n3c3š4p4l4h3n3š4t4r4k3n3š3t4r4n3g3t4v4r4d3n3v4r4s3t4v3v4r4z3g4nl2t3k2ách_n2t3k2ách_p2t3k2ách_s2t3k2ách_5s4r4b3s4k_ane3s2téz_aristo5k4_austro5s4_brato5v4r_cáro5v4ra_ces2t5maj_cirkevno5_čierno5b4_čierno5h4_čierno5o4_drobno5z4_kata5s4t4_ktovie5a2_miesto5d4_miesto5p4_na5d4nes__národno5o_ne5do3u2k_o5k4resať_o5s4tatok_o5s6t4rap_plocho5d4_pod5s4koč_pol5o4blú_po6st5g4r_prá5vo5p4_pra5vo5s4_pre5d4rah_pre5d4rap_pre5d4rať_pre5d4raž_pre6k5vap_pri6š5la__pri6š5li__pri6š5lo__rozo5c4h43s4polu5h43s4polu5p43s4polu5v4_široko5p4_t4v4r4do5_vnútro5s4_vnútro5š45boles4t5n5p4ne2umat5s4k4romne5s4p4ravod5s4p4raved5d2ve5s4to5t2ri5s4to5osem5s4to5š4p4liech5š4t4vorecakvári3u2mgymnázi3umle2u3kémia");
            put(11, "maš3k4r4t3nl2t3k2a1mi_n2t3k2a1mi_p2t3k2a1mi_s2t3k2a1mi__a2e2ro3d2r_a2e2ro3k2l_ane3s2teti_bac2k3hand_červeno5a4_červeno5b4_červeno5h4_červeno5k4_červeno5o4_červeno5p4_hrôzo5s4t4_chorobo5p45d4vanás4ť55jedenás4ť55šes4ť5s4to5sedem5s4to5deväť5s4to5š4t4ruktúr");
            put(12, "3c2h2r4c4h3l3c2h2r4c4h3ľ3c4h4r4s4t3n3c4v4r4n3g4n3š4k4v4r4k3n3š4k4v4ŕ4k3n_akcie3s2c2h_cirkevno5p4_ďatelino5t4_na5d4robno__o5k4resávať_pravicovo5o_pred5ostatn5jedenás4t5k5m4ladis4t3v5š4tyri5s4to5vy5s4t4rája5s4to5k4rát_");
            put(13, "5boh3vi4e3a2k5š4t4v4r4ť5k45š4t4v4r4ť5l45š4t4v4r4ť5r45š4t4v4r4ť5s4");
            put(15, "ôs4t3k2ár3s4t4v_po6s4t5s4k4rip5boh3vi4e3o2d3k");
        }
    }), te("te", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "అ1ఆ1ఇ1ఈ1ఉ1ఊ1ఋ1ఎ1ఏ1ఐ1ఒ1ఔ1ి1ా1ీ1ు1ూ1ృ1ె1ే1ొ1ో1ౌ1్2ః1ం11క1గ1ఖ1ఘ1ఙ1చ1ఛ1జ1ఝ1ఞ1ట1ఠ1డ1ఢ1ణ1త1థ1ద1ధ1న1ప1ఫ1బ1భ1మ1య1ర1ల1వ1శ1ష1స1హ1ళ1ఱ");
        }
    }), de("de", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "2aaa1äa1ba1da1ga1j2aoa1öa1p2aqa1ßa2ua1xä1aä1bä1dä1gä1jä1k1äqä1ß1äxä1z1bibl21cacä3c1dc4h1cic1jc4k3co2cp2cs3cu1cy1de1did1ö1due1be1d4eee1fe1ge1ke1m2eoe1pe1qe1ße1te3üe1wey1e1z1fa1fä1fe1fi1fo1fö1fu1fü1fy2gd1geg1n1guh1j2hl2hnh1q2hr4hsh2ü2hwh1zi1a2iä2ici1d2ifi1ji1ßi1üj2u1ka1käkl21ko1kök1q2ks1kü1le1li4ln1lo1lö1ly1ma3mä1me1mi1mo1mö1mu1mü1my1na1nä1ne1nin1j1noo1b2oco1d2oi2ol2omo1qo2uo1vo1xö1bö1dö1e1öf2önöo1ö1ßö1vö1wö1zp2a1päp2e1php1j1puqu42rc1re1ri4rnr1q1ru1rü1ry1sa1sä1sc1se1si1so1sös1t1su1sü1ße1ßiß1j1ßu1ta1tä1tet1h1ti1to2tö2ts1tu2tü2ua2ucu1h2uiu1ju1lun12uou1q2usu1w1üb2üc2üdü1gü1k2ünü1ß2ütü1vü1zve2v2r2vsw2aw2ä2wnw2rw2ux1a1xe1xix1jx1q1xu2xyx1zy1by1ey1gy1hy1jy1ly1py1ry1vy1wy1yzä2zu1zw2");
            put(4, "_ax4_äm3_ch2_en1_eu1_fs4_gd2_gs4_he2_ia4_in1_ks2_oa3_öd2_pf4_ph4_ps2_st4_th4_ts2_um3_ur1_xe3a1abaa1ca3au2abaab1ä1abd1abf1abg1abh2abi1abkab1l1abnab3r1abs2abu2abü1abw2aby1abz2aca2acc2acu1add2adf2adh5adj2ado2adp2adq2adu2a1eae2bae2cae2da2ekae2pa2eta2ewae2xaf1a2afe2afia2fö2agaag2n2agt2ah_2ahsa1huah1wa1hyaif2a2il2aisaje22ak_2akb2akc2akd4ako2aks1akza1laa1lä2ale2ali2aloa1lu4aly2am_2amä2amf2amk2amla2mö2amu1anb2ane1anf1anh2anj1anl2anna1nö1anra1nü1anwao1ia1opa1or2ap_2apa2apea2pfap2n2apr2ar_a1raa1rä1arb2are2arf2arh2ari2arr2arua2rü2arv2ary4asha2söa2süaße22a1tata1at2cat2eat2h3atmat1ö4atra3tü2au_2aub4auc2aue2aug2auj4aum4aunau1o2auu2auw2aux2auz2a1ü2a1v4avia2vr2a1wax2eays4ay3t2a1zaz2aaz2oaz2uäb2sä1ckä2daä2dräd2s2ä1eäf3läf3räf2säg2näh1aä3hi2ähm2ähsä1huäh1wä1imä1la2äleä1lu2ämläm2s2än_2äne2änsä1onä1paär1äär1c4äreä1röä2rü1ärzä3suä3teät2häu1cä2uf1äug4äul2äumä2un2äur1äuß4ä1v3bah3basb2ärb2äs4b1bb3bebb2sbbu12b1c3be_3bea3beb3bek3bel1bembe1o3bet1bezbge3bib23bilbiz24b1j2bl_b2leb2lo3blü2b1mbni2bo4abo2cboe1b1op2böfb1öl2b1qb2r42br_3brä3brü4b1sb3säb3scb4slb2söbss2bs2t4b3tb5teb4thbt4rbtü1bu2fbü1c2b1v2b1w3by1by3pbys2ca1h3camc4an3carcäs22c1ccch22cec2cefce1i2cek1cen1cer1cetce1u2c1f4ch_2chb2chc2chd2chf2chg2chh2chj2chk2chp4chs2cht4chü2chv4chw1chy2chzci1cci2s4ck_ck1ack1ä2ckb2ckc2ckd1cke2ckf2ckg2ckh1cki2ckk2ckm2ckp4cks2ckt1cku2ckv2ckw1cky2ckzclo1co2ccoi22c1qcre2cry2cs2ac2si4c1tcti22c1z3da_da1ad1afd1agda1sdä2u2d1cd3dhd5dodeg2d1eides1det2dga2d3gl3di_3dicdi2edi1p2d1j4d1ld3ladni2d1obdo2o2d1qd2r4d3rid3rö2d1s4dsb4dsld2södss4dst42d1td2thdto2d3tödt3rd3tüdu2fdu1idu1odur22düb3düf3dün2d1wdwa2dy2s2d1z2e1aea2ceak1eam3e2ase1ä22eba2ebl2ebre3bue1ce2ecle3cr2ected2eed2öee1eeeg2e1eie1en2ef_2efa2efe2efi2eflefs22efu2efüegd4e3gee2gn2egue1hee1hi2ehme1hoehs22ehte1hue1hüeh1we1hy4eibe2idei1ee4ilei1p2eire2it2eiu2e1jek2a1ekdek4nek2oek4r2ektek2ue1la2eli2eln2eloe1lü2elz2ema2emm2emüen3fe4nre4nten1ue1nüe1nye1ofe1ohe4ole1ore1ove1ö2e3pae3puer1ae1räer1cer3h2erie1roer1ö2eru2esbes2c2esf4eshes3l2esmes2ö2esp2esres3we3syes3ze3teet2he3tie3tö2etre3tü2etz2euf1euke1um2euneu1p2eut2eux2e1ve3vo2ewae3wä2eweew2s2ex_3exp2exuey4neys4e3ziez2wfab43facf4ahf2alf2arf3atfä1cf1äu2f1cfe2c3fewf1ex3fez2f1fff2efff4ff3lff2s3fi_fid2fi2ofi2r3fis3fiz2f1jf2l22fl_1fläf3löf4lü2föf2f1qf2r2f3ruf3rü4f1sf3scf3sifs2tf2süf3sy4f1tf2thf3töf3tü3fugf1umf2ur3fut2fübfü2r2f1v2f1w2f1zfz2afz2öfzu33ga_ga1c5gaiga1kgäs5gä4ugbi22g1cg1dag1dog1dögdt4gd1uge1cged4gef4g2el4g1gg3gegg4r2g1h4gh_gh2egh1lg2hugh1w2g1j4gl_2gls3glüg2ly2gn_gn2e2gng2gnp2gns2gnt2gnug2nüg2ny2gnzgo4a2goggo1igo1y2g1qg2r4gse2g4slgso2gsp4g4swg3sy2g1tg3tegt2sg3tügu1cgu2egu2t2gübgür1güs32g1v2g1w3haah1ahh1aph2as2h1c2heahe3x2hi_2hiahi2ehi2n2hio2hiuhlb4hld4hlg4hll2hlm2h2lo2h1mh2moh3möhm2sh2muh2nah2nähn2eh1nu2hodhoe42hoih2on2hoo2hop3hov1h2öhö2ch4örhr1chr3dhrf2hrg2h2rihrr4h3rüh2ryhrz2hss24h1th2thhto2h4tshtt4h3tühu1chu2n2hurhüs32h1vhvi23hyg3hyphz2o2ia_i4aai2ab2iaci2afi2ahi3aii2aji2ak2iali2am2iani2apia1q2iasi3au2iavi1ämiär22i1bib2oi2böice1idt4i2dyie1ci1eii1exif3lif3rif2s2i1gi2gli3go4i1hi3heih3mih3nih3rihs2ih1wi3i2ii4s2i1k4ikei2kni1la6ilbil2cilf22iloilv42im_2ime2imo2imt2imu2inein3f2inoi1nö2inp2inrin1ui1ny2i1oio1cio2dion2i2ori2oui2ovio2xi3ön2ip_i1pai1peiph2ip4li1pr2ips2ipu2i1qi1räir1cir2eir2i2irki1roi1rö2isb2iseis3ti2sü4itäi6tli3töi3tü2itzium12i1v2i1w2i1xi2xai3xi2i1zi2zöja1c2jatje2aje1cje2gje2pje3wji2ajit3ji2vjoa3jo2iju2kjus32j1v3ka_ka1ck2adk2agka2o3kask1ähk1änkär2kby42k3cki1c3kir2kiz2k3j4kl_k2lek1lu2kly2k1mk2n2k3nek3nu3knü3komk2onk2os3kowkö2fk1ölk2r4kst44k1tk2thktt2k3tükt3zku1ckuh12kübkü1c2k1v2k1w3la_1lad2laf1lai3lao1lawlay1lä1c1läd2läf4lät2l1blb2slb2u2l1c4l1dld3rldt43le_2lec3ledle2e3lehl2ek2leple2u3levl2ey2l1flf4u2l1glgd4l3go3li_3liali1cl2ie3ligli3l2limli2o3liu4l1j2l1klk2l4l1lllb4llg4llk4ll5mlln22l1mlm3plm3tlnd2l3nil1nul1nü3loklo2o2lox2löd4lög4löß2l1plp2fl3pu2l1q4l1s4l1tl2thl6tsltt2l3tü1luf4luo2lur3lux2lüb5lüd2l1v2l3wly3c3lynly1oly3u2l1zl2zölz1wm1abmae2ma1f3mas3maßm4aymb4lmby42m3c2m1dmd1ameb43mehme1o2meö3mesmeu13mi_mi1c3mig3mil3mit2m1jm3ka4m1lm3li4m1mmmd2mmm2mm3pmm2smoa33moh3mom3mos3motmo1ymö2c4mökm1öl2m1pm2pfm3pim3pu2m1q4m1sm3säm3scm3sem2süm3sy4m1tm2thm3tömtt2m3tümt3zmu1a3munm4us2müb3mün3müt2m1vmwa2my4s2m1z3na_n1af3nain1ar3nas3natn1au3näe3näs2näunby42n1cn2ck2n1dn2döndy33ne_2nec3nedn1efneg4ne2l3nenne2un2ew3nez2n1fnf2änff4n3finf4lnf2onf4rnf3s4n1gng3mn2gnn3hän3hen3hu3nian1idn4ie3niknin1n2ip2nitni3v3nix2n1k4n1nnn3fnng4n3ni3no_no1cn1of3nov3now3noz2nödn2ör2n1q6n1snsp4n3sy2n1tn3ton3tön4tsn3tun3tü1nu_1nud3nuenuf21nug1nuinu2n1nuo2nup2nur1nut1nuu1nux1nuz3nü_3nüs1nüt4n1w1ny_1nyhn1yo1nyr1nys1nyw2n1znz3so4aco4ado4aho2aro2aso4ato5au2obbob2e1objob1lo3cao1ceo1ck2odrodt4o2ecoen12ofa2ofiof3l2ofo2oft2o1go3ghogs2o1hao1häo1heo1hio1hooh1soh3to1huoh1wo3ieo1imo1inoi2r2o1j2o1kok4n4okrokt4o1lao1läol2io3loo1lu3olyoms2omy12ona2onä2onc2oneono1o1nuon3v1onyon3zoof2o1opo1oro1pao1pi2or_or1ao3räor1c4ore2orf2orh2orm2orq2orro3ru2osh2osio3sk2oso2o1to3tüoub4oug2o3uho3um2our2ouv2o1ü2ovi2ovo2o1wo3wiox2aox2eo2xu1oxyo1yo2o1zoz2eo3ziöb2l2ö1cödi3öf3lög3lög3rö1heö1huö1keök3r3öl_öls2öm2sön2eö3niön2sö1nuö1peör1cöru4ö2saö2spö2stö3su2ö1töt2höts2öze31pa_1paa1pacpag41pak1pap2paß1pat1pau3päd3pär3päs2p1b2p3cpda41pe_pe2a1pedpef4pei13pel1pem1pep3pet4pf_1pfäpff4pf3r2p1g4ph_ph2a2phä2phb4phd2phf4phg4phkph2l2phm2phn2phöph4r2phs2phz3pik1pilpi2o3pip3pispku22pl_3pläp4lo2p1n1p2opo1c3podpo2i3pokpo2wpo3xpö2c2p1ppp3lppt2p2r2p4rä2p1s4ps_p3sep2söp2st2p1tpt1ap3tep2thptt2ptü4pt3zpu1apub42puc2pur3put1püf2pülpün22p1v2p1w3py1pys4py3t2p1z1ra_r1abr2ad1raer2afr2air2alr2apr1arr2as2raß1rat1raür2ax4räf4räg2räh2rämrä2u2r1brbb2rb2orb2srb2ur1ce2r1dr2dördt43re_2reä3reg3rekre2u2reür1ew3rez2r1frf2u4r1gr1h42rh_2rha2rhä2rhö2rhsrid2r2ie3rigr2isr2itrix12r1j2r1krk4n4r1lrl2erl3t4r1mrm2urnd4r3nern3frng2r3nirn1ör1nur1nür1nyro1c2rof3roir2onr1or4roß2rox2röf4rögr1ök4röpr1örrp4erpf4r3porp3tr3pu2r1rrrb2rr1crr2or3ru4r1sr3sirs3lr3sor3sy4r1tr3tör4tsrtt4r3türt3zru1a3ruf4rug2rum3rut4ruz2rüb2r1v2r1w4r1xry2c2r1zrz2ö3sa_3saa3sams1an3sat3säl2sc_s2ci2scj4scl2scos2cr2scs2scusd4r3see3seh3seq3set2s1hsh2as3häsh3ns3hösh4rsib43sio2s1j4sk_4skbsk4lsk4n4skö4skss3läsl3bs3les3li4sna4snö3so_so4aso1c3sog3sol3somso3o3sos3sov3sow3sozsö2csö2fs1ös1sp22sp_s2pä2spls3pn4spy2s1q6s1sss3l6st_s2ta2stb2stdst2e2stf2stg4sth2stj2stk4stl4stm2stns2to1stö2stp2stqs2trst2u1stü2stv2stwsu2n3suv3süc3sün4s3v2s1ws3was3we1s4ysyl12s1zsz2os3zü2ß1c2ß1d2ß1f2ß1h2ß1l2ß1mß1o2ßos2ßst22ß1t2ß1ü2ß1v2ß1w2ß1z3ta_4taatah2t2ai2tam3tas3tav3tax4täbtä1c4täd3täe3täg2täh4tämt1äptä2st2ät2täx4t1ct4ckt3cr3te_2teh3ten3tes4th_th2e1thi2thk2thp2ths2thü2thvt2hy3tig3tik3tio3tip3tis3tiv2t1j4t3ltl4e3to_to1c3tod3tok3ton3too4toß3tow4töftö4l3tön4töß3töttpf42t1q2tr_3tritry14ts_ts1ot2söt3sy4t1tt3tit3tot3töttt4t3tut3tü2tub3tuc2tud3tue4tuf2tuh2tuk4tüb3tüf3tüm4t3v4t3wtwa21ty13typtys44t1ztz1ätz2öu1amu3auu1ayu1ämu1äu2u1bub2lub1ru1ce2u1d2u1eu2edu2eguen1u2ep2uffuf3luf3r2u1gugo3u2göu2gü2uh_uh1wu1ieu3iguk2au1keu1kiuk4nuk2öu1kuulb4ulg4u2lü1umf1umg1umk1uml4umm1umr1umz4un_u3ne2unk1unruns21unt1unw2unzu3ofuos2u1pau3piu1pr2ur_u1raurd22ure2urfu1röur3purt2u3ruurü2u2sü2u1ß2u1tu3teuto1u3töu3tüu1ü22u1xux2eux2oux3tu1ya2u1z2übc2übdübe2üb3lüb3rüd3rüf3lü2gnüg3süh1aü1heüh1iüh1süh3tü1huüh1wül1aül2cül4eü1luün2sünt2ü1nuü1peü1piür1aürr2ür2süs2aü2stva1cva1sv4at2v1b2v1dve3bve3cve3dve3gve3hve4ive3over1ves12veüve3v2v1g2v1hvi2cvig22v1k2v1m2v1n3vol3voyvö2c2v1pv3revs2e2v3t2v1v2v1w2v1z1waa1wag1wah1walwa2p1was1wäh1wäl1wäswbu22w1c2w1dwe2a1weg1wehwe2i1wet2w1g2w3h1widwi2ewik21wil2w1k2w1l2w1mwn3s1wohwot21wöc2w1pw3ro2w1sws2t2w1twti21wucwul2wus21wühwül2wün32w1w1xa_1xae2x1b2x1c4x1d2xekxe2lx1emx2en3xes2x1f2x1g2x1hxib4xi1cxi3gxil12x1l2x1m2x1nx1or4x1p2x1r4x1txt1äxt1uxu1axu2s2x1v2x1w3xy_3xys1yacy1äty1c2y1d4y2efy1f2ygi2yg2lyhr2y1i4y1k2yl3cynt2y1nuy1ofyom2y1osy1ouypa2ype2y2pfy3phypo3y3riyrr2yse1y1t2yu2ry1z2za1c3zahz1anz1as2z3czdä1ze1e2z1h2z1j3zolzo2oz1orz1öl2zön2z1qz3saz3shz3skz3sz2z1tz3töz3tüzu3azub4zud4zu3kzuz22züb2z1v4z1zzz2ö");
            put(5, "_ab1a_abi4_ab3l_abo2_ack2_ag4n_ag4r_ag2u_ai2s_ang2_an3s_apo1_aps2_as3t_at4h_au3d_ät2s_by4t_dab4_de1i_de1s_dü1b_dys1_ei3k_eke2_enn2_er1e_erf4_er1i_es1p_et2s_eu3t_ext4_fe2i_fi2s_ga4t_ge3u_hi2s_im2a_im5m_in3e_ink4_inu1_ire3_is2a_jor3_ka2i_ki4e_kus2_li2f_ma3d_ma2i_me2e_ne4s_ni4e_nob4_nus2_ob1a_obe2_or2a_ort2_ozo4_pro1_ro4a_ro3m_rü1b_sch4_sha2_te2e_te2f_te2s_ti2a_tid1_ti2s_to2w_umo2_un3d_un3e_un3g_un3s_ur2i_ut2a_ut3r_übe4_vo4r_wa2s_wi4e_wor2_ya4l_za2s_zi2e_zwe2aa2beaa2gr4a2araart2aas5tab2äuab1ebabe1eabei12abela3ber2abet2abew3abfiab1irab1it2ableab3liab4loa2blua2bo_ab2of2abora3braa4brä2abrü2abs_abs2aab5scab3spabst4ab3szab1uraby4ta1cem2ach_ach1a2achba1che4achfa1chiach3lach3mach3na1choach3öach3ra4chta1chuach3ü2achvac1in2ada_ad2agada2m4adav1a2dä2ade_2aden4a3diad2obad3ru2ads2ad3stad3szad2t1ad4tead4tra2elaa2eleae2o3aes5ta2faka2fana3faraf4ata2faua2fexaf2fl2af3lafo1saf3raaf3räaf3reaf3röaf2spag1abag1arag1auag2diag2drag2duage1iag2er2agesag3gl1aggr2a2glag4laa4glöag4nuag4roagsa2ags3pag2th2a1haah4at2a1heahe1sa1h2iahin3ah2löahnt21ahorah1osa2h3öahr1aah3riaht3saian3aid2sai1e2aien3ai3g4a3ik_ai3keai3kuai2loa1indain4ea1ingai2saaiso2a3iv_aive3a3ivla3ivs2akal2akarak4at4a1kea2kefa2keu2a1ki2ak3lak4li2a1kr4akra3akroak3sh2akta2aktb2a1kua2kun4a3kü2ala_al1abal1afala2ga3lalal1ama2larala4s2alatal1aual1ämal2bralb3sal2däal2dral3dualen1ale2pale4talf4r3algi3almba2l1öal3öfal2ös1alphal2ufa2lumal1ural2zw2am2aamab4amad2ama3g2am4e4ame_a2meba3meta2mewa3miea3mis2ammlammu2am3pr2am2sam3sa1amt_am4töam2tu2ana_2anabana3ca3nak2anam2ananan1äs2anbuan3ch2and_2andua3nee2anfi4ang_2angf2anghang1l2angoang1r2a3ni2ank_an3klank1rankt42anmu3annäan1oda3nola3nos2anpr1ansä1ansc2ansk2ant_2anto1antr1antw2a1nuanu3s2anzb2anzg2anzs1anzü2anzwa1os3ao3t2a3ot_a2pefap2faa3pfla3phäa2pht2ap3la2pot3applap3pu2a3pua3ra_ar2ab2arb_4arba2arbiar2bl2arbr2arbt2arbu1ar1ca2reaa4rega2reha4reka3renare3uar2ewarf1rar2glar2gnar2iaar1ima3riuarm2äarn2e2a1roar1oba2rorar2rh2arsaarse32arsiar2st2arto2artsar1ufar1uhar1umarwa2ar2zä2arze1arztas3aua2s1äa2sca4as2ea2seba3ses2asisas1ora2s1pas2phas2pias2poa3spuas2stas3teas3tias3to2astraßen3at1abat2afat4agata3la3tama2tatat1aua2t1ä4ate_a2teb4atena2tep4atesat3ha3athl4a3ti4atorat3räat3reat2saat2seat2siat2soat3taatt3sa3tubatu2nat2zoau2draue2baue2sau2faauff43aufn4au1iau2isau3lüaun2eau1nua4unz2aup22ausc1ausd3ausf1ausg1auslau2so1ausr1ausü1ausz2aut_2aute1autoauz2wa3v4aawi3eax4am2a1yaa1yeuaysi1ä2b3lä1cheä1chiäch3lä2chrä1chuäck2eäf2fläge1iäge3sä2g3lä2g3räg4ra1ä2gy2ä3heähl1aähl2eäh3neäh3riä1is_ä1iskä2k3lä2k3rälbe2äl2bläl2p3ämt2eän5deän2dräne1sän2f52ängeän2glän2gr2ä3niänk2eän2kränk2säp2pläp2präp4stär4afäre2när2grärk2särm2sär1o2ärse2är4siär2stärt4eär2thär2zwä5s4eäse3tä2s1päss2eäs2stäs4träte2nät1obä2t3rät2saät2sääts3lät4trät2zwäu2bräude3äu3eläuf2eäug3läu2maäun2eäu1nuäu3seä3usgä3uskä3usnäu2späu2trba2bl2babs2b1afbais2ba2kabak1lbak1rbal2a2b1amban2ab1ang2banlban3tb1anzbar3bbar3nba2scba2stbau3gbau1sba1yobben3bbe4pbb2lö2b3d4bde1sbe3anbe3arbe3asb2ebe1be1cbedi4be1eh3bef4be3g2beil2b2einbe3li1ben_ben3nbe1ra3be1sbes2abe1ur3b2ew2b1ex2b5f4bfal22b1g2bges42b5h2bhut2bi3akbibe2bie2sbik2abil2abi2lubin2ebi2o1bio3dbi3onbiri1bi3seb1isobi2spb2it_b2itebi2tu2b1k4b3lad3blatb3leb3blemb4letb3leub2lie2bligb4lisb2litb4locb3los2blun3blut4b3n2bnis1bo5asb1ob3bo2blbo2brbo3d22b1ofbo3febo1is3bon_bond1bo2ne3bonsbo4räbor2sb1ortbo2scbo3thbo2xibö2b32b1p2bpa2gb4ra_b4rahbrä4u2bre_3brea2breg3bremb4rer2brigb4riob3rohb4ronb4rucbru4sbs3arbsat2b4särbs2äubs2cabs4cub3se_bse2bbsi4tbs2kubso2rbs2plb3stob3stöb3stübtal3btil4b4ts2bu2e3bu3libung4b2urgbu2sa2b3z22c1abca2chca2e3ca3g4cal3tca2pecar3ncas3tca1y2ceco4ce2drcen3gcere3ce3sh2ceta2chab2chaf1chaoch1äs1chef4chei2chic2chl2ch2lech2lu4ch2m2chn42chobcho2fch1ohch2r44chrech3rh2chuf2chuh2chum1cka_2ckac1ckag2ckalcka4r2ckau2ckeh2ckexck1imck1in3ckis2ck3l2ck3nck1o22ck3rckt2e3c4l2clet4co3chco2d2co3dicoff4co1itco2keco2lecol2oco2peco1racor3dco3recos3tco4te1c4r2cte3ecti4octur6cu2p32d1ab2d1acd2ac_dagi2dah3lda1ho3d4aida1inda1isdal2ada3löd1altdamo3d4ampd2an_d1ang2danw2d1apd2aph4dapp3darlda2rod3arrdar3sd1artda2rudas4tdat2a4datmdau3e2dauk2d1äh2d1äp2därzdä3us2d1b4dbu2cdco4r2d1d2ddar2de2adde3asde3b43de1cde1e4de3gldehe2de3hod2eicde2löd2en_dend2den3gd2enhde2nide1nude1ondepi2d4er_de3rude2sade2spde2sude1unde3us2dexp2d1f42d1g2dga3gd2ge_2d1h2d2hisdi4abdi2addi4amdi1cediet3dik2adin2adi2obdi2spdist2di2tadi2thdit3sdi2tu3di5vdi3z22d1k4d3l2edli2f2d3m24d5n2dnis1d2obadob4ld2obrdole4doll22doped2opp2dorc2dordd2orp2dortd2os_dos3sdost1dot6hdo3undö2l13d2ör2d3p2drag4d3rai2drädd4räh4dre_2dreg4drem2d3rhd4ri_d4ridd4ried4rifd4rikd4rild3robd3rocd4roid3roud5rubdrü1bd2sands1änd3seidse4td3shodso2rd2späds2pods2pud2steds2tids2tud2sundta2dd5teadt3hodt5s2du1ardub3l2d1uh2dumd2dumf2dumg2dumld2ump2dumrd1umsdung42dunrdun2s2duntdus3t2d1v2e3a2beab3lea2drea2g4ea3gaea3gleakt2ea2laeam1oea2nae2anoe3ar_ea2rae3arre3arveas3se3athea5tre3aug2ebedebe2i2ebeleb2en2ebeteb3loeb2lö2eb2oebot2ebö2seb4rueb2s1ebse22e3caech1äe1chiech3lech3mech3ne1chuech1weci6a2eckteco3dec1s4e3d2aed2dre3deiede2re3d2oeds2äed2suedu2se3dy3ee3a2eeb2lee2ceee1chee2ckeede3e1effeef4leef3see1imeel2ee1empeena2e2enäe2encee3nie2enoeen3see1rae1erde1erkee1röeert2e1erzee3s2ees3kee3taee2thee1u2e1e2xef1are2fate2fäue3fe_ef1emef2er2eff_1effief2flefi2s1efkue3fraef4rüef3soef3spe2fumege1ue2gloeg3nieg2thegus32e1ha2e1häeh2eceh2ele3hereh1läehle2eh3loeh3mue3holehr1äeh3rieh3sheh3übei2blei3de2eidn1eifrei3gl2eigt2eigu2eil_2eilbeil3d2eilne1impei4näein3kei3o2eip2fei3ree1irre2is_2eitäei3teei2theitt4e3ke_e3kene3kese3keye3k2lekt2oe3k2wela2cel1afela2h2elaoela4s2e1läel2da2ele_elea2ele2c2eleh2elei1eleke3lepel2ete3leu2elevele2x1elf_el3feelf4l1elfm1elfte3lieel3klel3leelm2ael5nae2lofe2lolelon2elö2selto22e1luel1ure2lyaelz2eema2keme2se2mop3empfem2saem2stem3t21emule2n1a4ena_2enace3nade4naf4enahe4nak4enam4enaten1äu2ene_2enem2enen2enesenf2aenf2uen3geen2gl1engpe3ni_e3nice2nide3niee3nio2enise3nit2enive2nofen1ohe3nolen1one3noteno2w2e1nöen3sp1entd1entn2entü1entw1entz2enut4enwüeo2fee1on_e1onde1onfe1onhe1onle1onre1onse1opee1opfeop4te3or_e3orbe3orse3orweo1s2e3os_eo3ulepa2gep3leep2paep4plep2prept2aepu2se3ra_era2ge1raie2rake1rale1rape2rare1rasera2ße1rawe1razer1äher1ämerb2eer3brer3da1erdber3de4ere_er1ebere2l2erer2ereserf2eerf4rerg3s2erhüe3ribe3rio2erk_erk3te3ro_er3oaer1ofer1ohe3rone3rose3rowerö2d2eröker3p4er3rä2errüers2aer3seers2ier3sker3sner3sper3sz4ertier3uzerü4bes3abes3ake3sceesch2es2eles2hues2ide2siles2ire4skees3kles3kue4skye3sote3spies3sces3se2essoe1stre1stues4tüeße2setab4et1am3etapet4atet1ähet2enete2oet3hüeti2m2e3toeto2bets2pet3suett1aet2thet2zäet2zweu1a2eu2gaeugs4euil4eu1ineu2käe3um_e3umbe3umleun2eeu1o2eur2eeu3speust4eut2heu2zw4everewä2se2we_e3wirewi2se3witex3atex1er1exis2ext_ex2tu2e3xye3z2aezi2sf1abefab5sfa2drfaib4fa2ke2fanb2fanf2fanlf1anp2fanrfan3s2fanw2f1ap3farifa3shf3aug3f4avfa2xa2f1b22f3d4fdie2f2echfe2drfe2eife1emfef4lf4eief1eisfel3tf2em_fem4m2fempfe2näfen3gfe2nof1entf2er_fe1raf2eref2ertf1erwfe2st3fete2fexpff3arff1auffe2eff3eiffe2mff4enf2fexff4laff4läff4lof3fluf3flüff3roff3röffs3t4f3g2fge3s2f1h2fi3atfien3fi3klfi2krfil3dfilg4fi3lif2inafi3nifin2sfi3olfi3rafis2afis2pfi3tu4f1k4f3ladf3lapf3länf4leef3lerflo2wf4luc2f3m2fma2d2f3n2fni2sfob2l2f1offoli3fo2nafon2efo2nu2f1opfo1ra3form2f1ök2f1ölför2s4f1p2f4racf5radfra4mf5rap2fre_f3recf3red2fregf3repf4reufri3dfri2e2frig1frisf3rocfro2sf3rotf2sanfs3arf4scefs4cofse4tf2sphfs1prfs3s4fs3thf4ta_f2tabft1afft1anft1arf3tatft3hoft1opft2s1ftsa2ftse4ft3stf2tumftwa4ft3z23f2uhfung42funt2gabfgab4r2gabz2gadlga1flga2kagal2ag4amo2ganbgan3d2ganh2ganl2ganwga1ny2garb2garc3gardg2arsga3ruga2saga2siga3spgas3sgat2a2gatmgat4rgau1cg2aukg1aus2g1äp2gärz2g1b2gber2gby4tgd1ing1d3rgd3s2ge3a2geb2ageb4rge1e2ge3ecge2esge1imge1irge2isge3lege3lügelz2ge3migem2uge3nagen3ggen3ngeo2rge1ouge3p4ge1ragerm4ge3sigest2ge5trge1ulge1ur2g1ex2g1f4gga4tg2g3lgg4log2g3n3gh2rgie3ggi2elgi2gugi3negi3tugi4us4g3k2g1labg1lac3glad3glätg2l4e2gle_3gleag3lecg3leg2glehg3len2glesg4lia2glib2glif2gligg2lik4gling2lio2glisg2lizglo3gg2lom2g1luglu2t2g1m2g2n2ag4na_2gnacg4nat3g2näg3neh2gneug2nieg2nifg4nin3g2nogno1r2g1of2g1ohgol2a2gord2gorggo2s1go3stgo3th2g1p2g4rebg4remg4rerg3retg3revgri2e3grif2grig2groc2grohgron4g4rosgro4ug4ruf2grut4g2s1gsa2gg3salgs3angs3arg3s2cg4scagsch4g4scogs2ehgsen1gs3ergse4tgsi2dg3silg3spigs3plgsrü2gs5s4gs3tag3stog3stögs3trg3stugs3tügti2mg5t4rgu3amgu1as2guedguet42g1uhgu1is3gummgu4stgut1agut3h2g3z2hab2ahab2eh2absha1kl2haleh1alph1amth2an_h2andh4ann2hanr2hantha2plha2pr2harbh2ardhasi1h1äff2h3b22h3d4hdan2he2adhe3behe2blhe3brhed2ghee4she2fä2heffhe2frhe2fuhe3guh1eieh1eifh1eighe2im4heioh1eiwhe3lihe3lohe2lö3hemdhe3mi3hemmh2en_he2näheng22henihe2nohen3z4he2ohe3onhe3ophe3phherg22hermhe3roh1eröhert2he3thhet2ih2e2uheu3ghe1y22h3f4hfi2s2h3g2hget42h1h2hi2achi1ce2hi3dh2idehi2krh1infh1inhhi3nohi4onhi3or2hip1hi2phhi2pih2i2rhi3rahi3rihirn1hi3rohir2shis2ahi2sehi2sthi1thhi3ti2h1k4h4lachla2nh1lash1lath3lädh1läsh1läuh3lebhle3eh3lerh3lesh3lexh2lieh2lifh2liph2lish2lith3lochl1ofhl1oph4lorh3löch2löshl3t2h3lufh3lukh1lüfh2mabh3magh3manh3marh4mäch4mähh4mälh4mäuh3me_hme1eh3menh4monhm3p4hm3sahms1phn1adh3namhn1anhn3d4h2nelhn3exh2nich2nidh2niehn1imhn1inh2niphn3k4h2norhnts2h2nuch2nulho2blho2efho4fa3hole4holo3holzhom2ehono3ho1rahor3dh1orgho3slho2spho4st2hot_ho3thh1o2xho1y2hö3ckhö2s1h3öst2h3p2hr1achr3adh1raih3räuh2rech3redh3refh3relh3rephre2th3revh3richri4eh3rinh2robh3rohh3rolh4ronh2rorh3rouhrs3khr2suhr4swhr2thh3ruhh4rübh2sanh2sauh2späh2sphh1stah1stoh2s1uh2t1ahta4nht2ash2tärht1ehhte2sh4thohtod1h3töpht4riht3röht2soht2sphtti2ht3z2hu2buhuko3hu2lähu2loh1umsh1unah1up_h1upshurg2hu3sahu2sohu2tihut2th4übsh3übuhvil4hwe1c2hy2thzug4iab4liaf4li3ak_i3akti5al_ia2läial3bial3dialk2i3allia2lui3am_i4amoian2ei3anni2anoi3anti3anzi3ar_ia2rai2ascia3shi2asiias3siast4i3at_i4ate1iatri3atsia3uni1är_i1ärsi1ät_i1ätaib1eiibe4nibi2ki3blai3blei4bräich1aich1äi1chei1chiich3lich3mi1choi1chuich1wi3damid2ani2deiidni3i2dol2i2drie3a2ie2bäie2blie2ckie2drie1e2iel3di1ell2i1eni3en_i3enai3endi2enei3enfi3enhi3enji3enki3enmi3enni3enöi3enpi3enrien2sie1nui3envi3enwi3enzie1o2i2erei4erii1ernie2röie3sui1ettieu2eie1unif1arif4atif1aui2fecife2iif2enif2flif4läi1flüif4rai1freif3seif3spif2taiga3iig1läig4nai4gnäig4noig4raig3säig4seig3soi2harihe1eihe4ni4is_i4i3ti2käri3ki_ik1ini2k3lik3noiko3si2kölik3räik3reik1s2ik3soik3szikt2eikt3ri2kuni3kusi1lä1il2daild1oil2drile2hil1el2ill_2illsil3öfi1lu2i2lumi3lusim4ati2megi2meji2meki2mew1immo1impoimp4s1impuim2stin2afin3ami3napina4sin1äsin3do2indrin3eii3nelin1euine2x2ingain2gl4inhei3nie2inigin2ir2inis2inn_2innlin1odin1orino3tin3suint2hin3zwi2odaio3e4iof4li2o3hio3k4i3ol_i3om_i3omsi3on_ion3di2onyi2o1pio4pfi3opsi3opti3or_i3orci3orpi3orsi3ortio3s2i2osti3ot_i3otsi3oz_i1ö2ki1ös_ipen3i3perip3fa2i1piipi2sip2plip3pui1r2ai3radirat2ir2bli3ree2irekir2glirg4sir2he2irigir4mäir2no1ironiro2sirr2hir3seir3shir2sti3sacis2api2saui2scaise3eisi2ais1opis1pais1peis3sais2stis4töis4tüit1amit1ani3tatit1auit2ärität22itelite4ni2texi5thr1itiii5tocit3rei3truit2sait2soit1uhitut4it2zä2i3u2i2vebive4niwur2ix2emiz1apiz1auize2niz4erizo2bi2z1wja3nejani1ja1stje3najet3tjo2b1job3rjoni1jo1rajord2jo2scjou4lju2blju3nijur2ok3a2aka3ar2kabh2kabska1frka1inka3kak1allkalo5k3amakand4kan2ekank42kanlk1anska3nu2kanw3kara2karbk2ardk2argk2arkk2arskar3tkaru2k2arwka3sekasi1kas3s2kattk1auskäse32k3b4kbo4nkbu2s2k3d2k1effkefi4kege2ke2glk1einkei1skeit2ke2lake2läkel1ek4eltk2en_ke2no2keo2ke2plk2er_k2erck2erlkerz2k6es_ket3ske1up2k3f42k1g22k1h4kho3mki3a4ki3drki2elki3k4ki3liki3lok2imik2in_k2ing2kinhk2inik2innkin3ski3orkio4skis2pkist2ki3zi2k1k44kla_k4lar4kle_4kleh2klic2kligk2link3lipk2lir4klizk4lopklö2sk2lötkluf23knabk4neiko2al2kobjkoff4ko1i2kol4ako3leko4muko3nu2kop_ko1pe2kops2kopzko3riko2spko2stko3ta2k1ouko2wek1o2x2k1p2k4rawk4raz2kre_2kreg2k3rh2krib2krip3kris2krufkrü1bk2sanks3ark2sauks2änksch4ks3hak3sofks1pak3speks2puks3s2k1stak1stek1stok1strk1stuk2s1uk3talkt1amkt1anktä3skte3ekt1eik2texkt3hokt1imk3topkt4rokt3s4kul2a4kulpkung42kuntku2roku2spkus3tku2sukür4s2k3z2kze3lla3ba2labb2labf2labg2labhlab2ol2abrl1abt3labu2labwla1celad2il1adl2ladm3ladul1advla2falaf3slaf3tla2gala2gnlago2l2akk2l1al4lall4lalpl2amil2amp2lanb2lanf2lanll1anp2lanslar3sla2ru4lasdla3se2lash2lasila2so2laspla2stlat2ala3telat2s1lauglawa41länd2läub2läuc2läue1läufl3bacl3blälb3lel2blil3blolb3salb3selb4sklb3splbs6tl3chel3chilch3llch3rlch3ülch1wlda2gld1all3daml3dasl3datld1auld1ärl2deil2dexldo2rld2osld2ö2l2dreld4rüld3sald3stld3thle2adle2bl4leddle3dele3eilef2ale2gäle2glleg4r4lehs4lehtl2eicl2eidl2eitlel3s4lemplem3sl2en_le2näl2enfle3nil2enkle1os3lepa3lepf3leprl2er_lerb4lerk2ler3tl1erzles2ele3shlesi1le3skles2t4lesw2lesy2leto4leud3leut2lexe2lexzl3fahlfe1elf3lolf2trlfur1lga3tlg3rel3gro2l1h23lhi_li3acli3akli3amli3arlia1sli3b4libi34lickli4ds3lie_lig4nli3keli2krlil2a3limol1inv2linzli4om3lis_li2spliss2lit2ali3telit2hli3tu2lixili2zalk3lolk4nelk4ralk2s1lk3sälks3tl3k2ülla2nl3lapll1aullch4ll3d4ll2emll2esl2lexll3l2ll1obl3lowll3shll5t4llu2fll1urll3z2lme2el2möllmpf4lms2tlna4rl3n4e2lobjl2obrlo1fllof4rloi4rlol2a2lopf2loptlo1ralo4rä2lorcl1ordlo3ro3lorq3los_lo4sa3loselo2talot4h2l1ovlo2velö2b3l2ö2fl1öhrlpi4plp3t42l3r2lre1slrut4lrü1bl3sacl2saul3sexl4shalsho2ls2pols3s2lst2al2stels4trls2tuls1uml2sunlsu3sl2tabltag4lt1aklt1ehlt2enlt3hol3thul2toblt1oplto2wlt1öll3törlt1ösl3trält3relt3sclt2solt1uhlu1anluba2lubs2lu2drlu2es2lufflu2golu2gu2l1uhlume22lumf2lumll2umpl1umsl1umw1lu2n2lunt2lunwl1urnl1urt2luselu2splu4stlu2tälüh1lly1ar2lymply3nolzo2flz3t2m2abe2mabk2mabs2mabtma2cima3damal3dmalu4mam3m2manbm2anfm2anh2manlm4ann2manzma2orm2app2marb4marrm1arzmat4cma3unma1yom1ähnmä1i2m1ärg2m1b2mbe2em3b4rm2d1äm2deimds2em2e1cmedi32medyme1efmega1m2eil3meldmell2m2en_m2ens2meou3mer_me1rame2ro3mersmes1ame4sä4mesume3th2m1ex2m1f4mfi4l4m1g22m1h4mi2admi3akmibi1mi3damie3lmi2ermi4etmi2kimi2ku4milzmi3nimi1nu3mir_mi3ra3miri3mirs3mirwmi2samise1mi2tami2th4mitz4m1k4m2mabmm1eimm3simm3spm2mummm2unmmül22m3n22mobj3m2odmo2dr4mog_mo2i32mol_mom2e3m2onmo3ne3mo2o2moptmo1ramork4m1o2xmp2flm3ponmp3ta2m3r2m2sanm4sapms1asm2saumsch2m4scom4sexmso2rm2späms2poms2pums3s2m3stoms4trms4tüms1ummt1abmt1akm3tammt1armt3homti2smt1ösm4ts1mt2samt2semt1um2m3uhmu3la2mulsmu3nim4unkmunt24munzmu3ra3musimu2spmus3tmu2sumuts32m1w2mwa4rmwel42n1abna2bä4nabg4nabhna2bln2abona2br4nabt3n2ac4naddn2ade3n2ag3n2ahn3ahnnai2en1aig2n1akna2ka3nakon2al_na2län4alena2lu2nalyn4am_3name3namon1an_4nanb2nanh2nani4nank2nanl3nannna3non1anp2nanr2nanw5nar_2narcn2ard4narg3narin2ark2narmn2arpn2as_4naspn4ata4natmnats14natt4naufn3aug5naui3n2äcn1ähn2n1ännä2scn2äss2n3b4nbe3nnbes4nbu2snch3mnd2agndat2nd1aun2dein2dobndo1cnd1opnd1orn2drönd3thndt4rn2dü4ne2apne3asne3atne2bl3necane1ckne2de2nee33nehm2n1ein2eid4neifne2ke3nelanel3bne3lin2em_n4en_n2enbn2encn2enhne2nin2enjnen3kne2non2ensn2envn2enwne2obne1os2nepfn2er_ne1ranere2n1erfn1erh3nerin1erkne2ron2erpn2erv3n2esn4es_nes4cnes1one2thneu1cneu3gneur22n1exnf1aknfo1snft2on2f1ung1adng3d4n3gefn3gerng3g4ng3hun2glon2glöng3neng1orngs3cng3tsn2gum2n1h4n3hann3harn3haunhe2rnib4lni2deni3drnie3bni1elnig2anig3rni3klni2kr3n2ilnim2o2ninfni2obni3okni3olni3ra3n2isni2tinit4sni3tunk2amn2kähnke2cnk2lonk2lunk4nan2knenk2öfn2köl2n3l22n1m4n2naunne2snn2exn2nofnn3scnn3senn2thnn1ur3nobl2no2dno3drn3olen2on_3nor_nor2a2norc3norh3norm3norsn1ortno3shno2täno2tr2nö2f2n3p4npa2gnpro1npsy32n3r2n3savns2cans1ebnse2tn3sexn3siln4sphn2sponsrü2ns3s2ns2tins2tunst2ün2styns2umnta3mnt4atnt1ämnte2bnte1ent1ehnt2enn3ternteu3nte3vn3thrnti3cntmo2nt3sants2onts2pnts2tntum4nt3z21nu1anu3arnubi11nu1cnu2esnu2fe2n1uhnu3k4n2um_2numf2numg3numm2numr2nuna2nunt3nu2snu3scnu3senu3slnu2ta2nü4bnür1c2n1v2n3ver2nymun2zadn2zann2zärnz1ecn2zornz2öln2zwö2o3a2o4abioa3deo4a3ioa3ke2obano3bar2obe_2obea2obewobi4t2o3boo3briob3skobs2pob3sz2o3buobu2s2o3bü2oby4och1ao1cheoch3loch3moch1ooch3roch1socht2o1chuoch1wo3ckeo3ckio2ckoo3d2aod2dro3debo3dexo3diro2donodo4so2dre2o3du2o1e2o4e3so2e3to3et_o3etsof1amof1auof2eno3feroffs2of2fuof1laof4läof4löof3raof3räof4rüofs1aof3thoga3dog2loo3g4nog3spohl1aoh3looh2lu3ohngoh2ni1ohnmo2h3öohr1aoh1ro2o1hyo1i2do2isco1ismoiss2oi1thoki2ook1läo2labol2arol4drole3eoler2ole3sol1exol2faol2flolf1rol2glol2grol2klolk3rol2of1olymol2zwo2mabo2mebome3co2melo2mepom2esom3maom3pfomtu3ona2bo2naeo3nalon1apon2auonbe3one2ion3f2ong4rong3s4o3nion3k2onli4o3nodono3sons1aonsi2ons3lons1pont2hont3s2onukoor3foo4skoo2tr2o1ö2opab4o3panopa5so1peco1pei2opf_op2fäo2pfeopf1l4oph2o3pheopin2op3li2o3poop4plop2pr2o1pr1opsiop3szo1rad2orak2oral3oramo1rasor1ätorb2l2orcaor2ce4orda1ordnor2do2ordr2ords2ordwore2hor1eror3gaor2glor2gn4oril2oritork2aork2s2o1ro2o1röorr4aor3rh2ors2or3shor3szor4töor2ufo2r3üo2ryaos3ados4anosa1sos4co2o3seose3eose2no3shoo4skaos3keo4skios2lo2os1pos2peos2saos4säos3to2osu42o3syo2tebote2s4ot2hot4heo2throt2inotli2ot4olot2oroto1so3traot2saot3scots1pot2thou2ceou2geou3glouri4outu4ove3so3wecoy1s4o3z2aozon1ö2bleö2b3röb2s3öch1lö2chröch2söcht4öd2stöf2flöh3riö3ig_ö2ko3öl1a2öl1eiöl1emöl4enöl1imöl1inöl3laöl1o2öl3saöl3szö2l1uölz2wönn2eön3scön3spöpf3lör3a2ör2drör2glör2klör1o2örs2eört2eör2trös2stös3teös2thös3trö2t3aöt2scöt2trözes4pa3dapa2drpa3ghpa1ho3pala1paläpa3li2paltpank42panl2pannpant2panz4papi23para1parc2parg1paro2parppa4stpat4cp3auf3pä2cpä2to2p1d2pea4rpech1pe2en2peicpe1im2pekupel3dpena41pennpe1rapere21perl3pero5perspe3sape2stp2fabp2fadp2fafpf1aip2feipf3lopf3lup2forpf1ra2pfs2pf3slpf3sz2pf3tpgra2p3hopph3t2phu4s2p1hüpi2a3pias4p4id2pi2el3pierpi3lepin2epi3oipi2pepi3ri4pisopi1thpit2s2pitz2p1k2pkur11p2l43p4lap5la_p5lad2ple_ple1cp4legp4lem2pligp4likp4liz2p3lu2p1m2po3b42p3ohpo3id3poin3p4olpo3li2pondpo1pepo2plpo3pt2pornpor3spos2epo3ta3potepö2blp2p1hpp1läp2plep2pripp3sa1prak1prax1präd1präg3präm3präs2pre_2prec1pred1preipri4e2prig1p4ro3prob2proc3prod3prog3proj3prot1prüf2prünps4anp3s2hps1idps2pop3staps2tup3stü3p2syps2zept2abpt3atpte4lp4tospto2wp2t3rpt3s2pt1um3p2typu2dr2p1uh2pundpun2s2puntput2spwa4r1queura2abr3aalra3ar2rabd2rabf2rabgra2br2rabs2rabt1rabyra1cer2ackr4ad_3radf3radlrad5tra2gn4raht2raic1rake3rakür4al_ral3bra3le2ralgr4aliralk2r4alsra2lu3ralyr2ammr2an_4ranc2ranf2ranl2ranr2rapfr2ara2rarbr2arkr2arpr4as_ras2ar4at_r3atlrat4r4rau_4raud2rauf2raug3raum3r2äd3rän_3räni3räns2r1ärr2är_rä3raräu2s4räutr2bakr3blärb2lörb4rirb3serbs1orb3sprby4tr1chirch3lrch3mrch3rrch1wr2ck1r2dafrd2amr4dapr2deir3denrd1itr2dobr3donrd1osrd4rird3tard3thrdwa4re2amre3asreb1rre2bür2ech3red_4reddre1elre1er3refe4reff3refl3refo5reg_rehl4r2ei_r2eie2reigr1einre3larel2ere3lorelu2r4em_r2emi4remur4en_r2enare2näre2nir2enzre3or3repe3repo4reppr1erfr1ergr1erkr1erlrer2nr2eror1erör1ertre2sa3rese3reso2ress3rest3resu2reulre2wi4rezirf2äurf2esrf4lör3flür3forrf4rurf4rürf2sarf2targ2abrg2anr2gnorg3spr2ha_r3herr2hoe2rholrhu2sri3amria1sri3atri1ceri1elri1euri2frrif3s5rig_5rigjrig1l4rigrrik1lr2imb2rimprim2s2rink3rinn2rint4r1irris2ari3so3rissri2strit4r5riturk2amr2kährk4lork2lur3krirk2sprk1strk2tark1uhrk2umrku2nr3l2arle2ar3lecrle2ir3letr3l2irli2sr3l2orm2ärrm3d2r3me_r2meorm2esrmo1srm3sarmt2arna2brna4nr2naurn3drr4nefrn2eirne2nr5nesrn2etr4nexr3nodr1nötrn1ur2robj2robsro3e4roh1lro1irro3lerol3s2roly4rom_4romm4romt3ronnrons2ro1pero3phr2oraro3shro2ßu3routrö2du1r2öh1r2öl3römir2ös_r2öse2r1p2r3p4ar2plirpro1rps3trr2abrr2arrr1ämr3r2er4rewrr2herrik2rro3mrr2strr2thr3r2ürrü1brs3abrs2anrs3arr3shors2klr4skor4skrr4skurs4nor4sobrs2p4rs3s2rs2thrs2tir3stor3störs2tur3swirtal2rt1amrt1ärrten1r2thirto1prt1orr5trirt2sorube2ru2drru2fa3ruinru1is4rumfru2mi4ruml4rumz2rund4runn2runwru3pr4r3urru2ra5ruroru2siru2strut3hru2zwrü1ch4rümmrz2anr2zarr2zasrz1idrz1oprz3terz2thr3zwä2s1absa2besa2blsa2br4sabss1adm3safasa2fe3safi3sagasag4nsa2gr3s2aisail22s1aksa2ka3saki3sakr4sakt3salo5samms1amps2an_s3anbs2and3sani2s1apsa2po3sapr2s1ar3saris3arrs1aspsat2a4satmsa2trsa3tss1a4u3sau_3sauc3saue3saum3saur2s3avsa2vos3ähns1ält2s1äm2s1är3s2ät3säul2säuß4s3b4sba4n2scams2cans2cap2scar2s1ce4sch_s4chä4schb4schc2schd2schf2schg2schh2schks4chls4chö2schp2schq4schss4chu3schü2schv2schz4s3d2sde1sseb4rse1ecse2glseg4rse3heseh1lseh1sseh3ts1ein3s2eks2el_s2elsse2nä3senkse2noseo2rs4er_3seraser3gs1erh3seriseru25ses_se3su2s1exse2xe4sexpsex3t4s3f4sflo44s3g2sha2k1shass3h2e3shi_3shidshi4rs3hoc4shof3shop3showsi2ad2siat5si1cs2ido3s4iesien3sie2ssi1f43s4igsig4nsi2kisik1lsi2krsik3ssi2ku3silosin1ision43s2issi2sasis3s3s2itsit3rsi3tusiv1asive3si2vr2s1k24skams3kar4skasskel1s4keps2kifs2kig4skirski1s3skiz4skom4skor4skow4sk3t2s1l23slal4slans2laws3lo_s3loe2s3m22s3n4snab4so3baso3et3softso3la3s2onsone22sopf3sor_s1orc3sorsso4rus4os_2s1ox2s1ök2spaa4spak4spap3spaß4spaus2paz3späh2spärs3pe_2spel4spet4s3pf2sphas4phäs3phespi2k4spil3spio4spis4spla4splä4sple2spod2spogs2poi2spok4spol4spr_3spru2s3ps2s4pt2spun2spup3spur4sput4s3r4sret3srü2ds5safs3sagss1ajs3sals3s2äs4sces4scoss1ecssoi4ss2poss3s4sst2ass2thss2tis3stü4sta_3staast2ac2stag3stah2stak2stax3s2tä4stäg2st3c2steas2ted4stee2stem4stens2tep2ster4stes2stetst3ev4stexs4thäs4this2thu2stia2stibs2ticsti2e2stig2stiks2til2stio2stis2stiv2sto_s3tob1stof4ston4stoo1stoß4stou2stow2stoz2stöt1stru1stub4stuc2stue3stuf3stuhstu2n3stüt4st3zsu1ansuba24subi3su1c2s1uhsu1issul2asul2isult23summ3sun_su4nes1unf4sunt3s2upsup3psu2ras1urtsu2s1su3sasu3shsu3sisus3s2sü4bsü2d1sweh24swie4swilsy4n34s3zas2zess2zis4s3zu4s3zw2ß1a22ß1b22ß1ec2ß1eißen3gße2niße2noße2roßer3t2ß3g2ßig4s2ß1in2ß1k4ßler32ß1n22ß1p22ß3r22ß1s22ß1um5taan4tab_2tabf2tabg2tabh2tabkta2br4tabsta2bü2tabw2tabz2t1ac3tacut1adatadi33taf_4tafft1afg3t2agt3agotai2ltai4r2takzta2latal3d3talo2talt3tameta2mit1amt3tan_2tanbta3ne4tanf2tang3tanit2ank4tanlt2anot1ansta2nuta3or2tapfta2pl2tarb4tark2taro2tartta2ruta3sata2tht3atlt4atmt1auk3taum4tägyt1ämt3tänzt2är_tä2ru4tätt2täuß4t3b2t3chat3chetch2itch3lt2chutch1w4t3d4tdun2te2a22teakte3alte3an3tebat2ech2teckte1emte2es2teff3teha3tehä3tei_teik43teiltekt25tel_3telatelb43telg3telk5teln3telp5tels3tem_tem3st6en_ten3ate2nät4enbten3gt4enhte2nit4enjt4enmten3n3terct4erit4erot3erötert2teru2t2estte2su3tet2t2et_4teth4tetl3teuf3teumte1unte2vite1xa4texp3text4t1f4tfi2l4t1g2tger22th4at2hagt3hait2hak2t3hä3thea2thebt2hect2hekt2hem1then3theot2hest2heut2hik4th3l4th3m2th3n1t2hot3hoft3horthou24t3hö2thub4thunti2ad3tib4ti1cetieg42tiehti1elti1etti1eu3tif_ti1fr4tift3tilgti2lötil3stilt4ti2lut2imiti3nat1inbt1infti1nuti3orti3plti1rhti2sptium2tive3ti2za4t3k45tlem6t5li4t3m24t5n4tnes2to4asto5at4tobjtob2ltode2toi4rto3la3tole4tolz2tomg3topo2topt3tor_to1ra4torct1ord3toret1orgto2rö3torsto2rut2orwto3sc3toseto4sktos2p4toss3totrtots23t4outo3un3töch4t1ökt1öst4t3p21t2r45tra_3trac3trag3trak3tral4traß5träc3träg4träs4träß4treb4trec3tref4treg2trekt4remt4rert4rett4reut3rev2trez2t3rh4trict4riptri2x3tro_3troe3tront4rop3troyt3röc2tröh3trös3trua4truktrum2t4rübt4rügts1adts1alt2sants1ast2sauts1emts3krtso2rt3sout2spät2spht2spots3s4t1st4ts2tut2s1u1tsubtt1abtt2actt1aktt2altta1st3telttes1tto1st3trott3rutt3rütts1ptt2untu3antuf2etuff3tu2istul2at2um_3tun_3tune3tungt1up_tu2rätur1c3turntu2rotu4rutu2satu2sotu3ta3tüch3tür_tür1c3türe3türg4tütztwi4ety2pat2za2tz1agtz1altz1artz1aut3ze_t2zortz2thtz1wätz1witz1wuu1a2bu1a2cuad4ru1al_u1albu1alfu1alru1alsu1altua2luu1ansu3ar_u1arsua3saua2thuat2iubau1u3b4iu2bopub3räu2bübuch1auch1äu1cheu1chiuch3luch3much3nu1chuuch3üuch1wu2ckiu3d2au2donud3rau3druue2ckue2enu2elaue2leueli4ue2miue2näue2niue2nou2ereu3errue2tau3fahuf1akuf3aru3fasuf1au2ufe_uff4luffs4u2fobufo2ruf3säuf4sou2fumug1afug1akuga4sug1auug3d2ug3huu2g1lug3lou4gluu2g3nug1orug3roug3seug3siuh1lauh1läuh2liuhme4uhr1auh3riuhrt4uh2ruuh4rüui2chui1emu4igeu1in_u1is_u3käuu1k2lu1k4ruk2tauku2sul1abul1amula2sul1ämul2drule4nule2tu2lexul3f4uli2kul3kaul2knull2aull3sulo2iul1orul2sauls3z2ultaul3thult3sul2vrulz2wuma4rum2enum1irumm2aum2suum3t2um2un2una_1unabun3acun4alun3at1unda1undd1undf2undg1undn1undv1undzune2bune2hung5hun2idunik4un2imuni2r2unisunks23unkuunna2uno4run2os2uns_un3se1unsiun3skun3spun3taun3trunt3s2untuu1o2bu3or_u3orsu1os_uote2u1pe2uper1up2faup2plup2prupt1oup4tru2rabu2rar2u1räur1änurch1ur3diure4nurf3turi2cur1imurk2s4u1rou3roluro1sur4swur2zaur2zäur2ziur2zou4safu3sepus3klu4skous3ocu3sohus1ouus1peu2spou2spuus2thus3tru1stuus2uru2tärut1egute2lut2esut2etu4tevutfi4ut2heu2thiu2thuuto3cut4orutos4ut3rüut3teutts2ut2zo2u1u2uufe22u1v4u2ve_uz1weuz3z4übe3cüber3ü1cheüch3lüd3a4üd1o4üd3s2üdsa1üd3t4ü2f1aüfer2üf2flü2f1iüf2toü2g3lüg4stühla2ühl2eüh3moüh3neühn2süh1roühs2püh4thül2laül2loül2löü2n1aün2daün2dründ3sünen3ün2faün2frünn2sün3scün3seün3spün2zaüp2plür2flür2frür3scür3seür3spürt2hüse3hüse3lüse1süss2eüs2stü2t3rüt2s1üt2tr2v1abval2s2vang2varb2v1auve3arveit4ve3lave3leve3live3love3maven2cve3neve3nive3növer3averd2vere2verf4verg4ve3river3kvert2ver3uve3tavete1ve3trve3x22v1f4vi3arvi2elvi2ervima2vi4navin2svi3savise4vi2spvis2u2v1l22v1obvo3gavo2gu2v1opvo2r1vor3avor3dvor3evor3gvo3ri2v3rav4ree2v3rov1stav3s2zvu2et2vumfwa5gewa3gowai2b2walb2walmwa3nawa3sawa3sewa3sh2wängwäs2c2w1b2we2bawe2blweb3swe2e4weed3we2fl2weiewe3niwerd2we2röwer2s1wesewe4stwet2s2w1eywie3lwin2e2wing1wi4rwi2sp1wisswi3th1wo1c1wolfwor3aw3s2kwun2s4wur_wur2s2xa2b1x2adxa1fl1x2agx3a2mx2anz1x2asx1e4gx2er_x2erexers22x3euxich2xide2xie3lxil2axi2loxi2lux2is1xis2cxi2sexis3sxi2su2x1k22x3s2x2t1axt2asx2tänxtfi4xt3s2x3turx1u2n2y1aby1al_y1a2myan2gy1anky2chiych3nyen4ny2erey2es_yes2pye2thygie5yke3nyk3s2y4le_yli4nyl3s2y2l1uyma4tym3p4ympi1y2n1oyno4dyon4iy1ontyp3any4p3sy3r2eyri2ayri1ey3r4oys2any3s2cy3s2hy4s3lysme3ys2poys1prys3t4y3s2zy2te_y2tesy3to1yure3zab3lz1a2dza3de2z1afza3grzale32z1amza2na3zani2zarb2zarcz1arm3zaubz3aug3zaun2z1äc3z2äh2z1ämz1ärgz1ärm4z3b4zbü1b2z3d2zdan2zeik4zelu25zen_zen3nze2no3zentz2er_zerk2z2ernzers2ze2säze3sczes1ezes1ize2spze2tr2z1ex2z1f42z1g2z2henzhir3zi3arzid3rzil2ezin2ezi2o3zi3opzirk22z3k42z1l22z1m2zme2e2z3n42z1ob2z1ofzo2gl2z1oh2zopezo2ri2z3ot2zö2f2z3p42z3r24z1s2zt3hozt3s2zu4chzudi4zu2elzu3f4zu3gl2zumf2zumg2zumlzun2ezung42zuntz1urkzu3s4zu5t2zür1cz1wac4zwahz1war2zwas4zwäl2zweg2zwet4zwirz2wit2z1woz1wörz1wur2z1wüz3z4az3z2o");
            put(6, "_ab3ol_ab1or_akt2a_al3br_alt3s_ampe4_an3d2_angs4_ans2p_ans2t_an3th_ari1e_ark2a_ar2sc_as4ta_au2f3_au4s3_be3ra_boge2_da2r1_darm1_de2al_de1o2_des2e_de3sk_des2t_do2mo_do1pe_dorf1_ehe1i_ei3e2_ei4na_ei2sp_ei4st_ei4tr_el2bi_elb3s_em3m2_end3s_enns3_en2t3_en4tr_er2da_ere3c_es3ta_est2h_es3to_es5tr_eu3g4_eve4r_flug1_for2t_fu2sc_ge3ne_guss1_he3fe_he3ri_inn2e_kamp2_kle2i_kni4e_kopf1_le4ar_li4tu_ma3la_ma2st_mel2a_mi4t1_näs1c_no4th_oper4_oste2_ost3r_poka2_ram3s_reli1_ri2as_rom2a_rö2s1_se3ck_sen3s_ser2u_se2t1_si4te_ski1e_tal2e_ta2to_te3no_te4st_ti5ta_tite4_to4pl_tro2s_tu3ri_uf2e2_ufer1_un3a2_uni4t_uns4t_uro2p_ur3s2_wah4l4a1a2naa2r1aaar3f4aat4s3ab1aufab1eilabe2laab1erkab1erzab1ins1a2blaab5lag1a2bläab4le_3a2blö1a2bon2absarab3s2i2abst_ab3ste1abteia1chalach3auach1eia3cho_ach1orach3su4ach1wa1ckarack2ena2ckinack2seack3slacon4na3d2abad3amaa2d1an3a4dapade2aladefi4a2deina2deri4ade1sades4sadi3enad4resa2f1eca2fentaf1erlaf4fluaf3s2aaf3s2haf2t1aaf2teiaf2t3raf2tura2f3urag1a2da3gen_age4naage2saage4si3a2gitag4ne_a2g3rea2g3riag4samag4setag4spoag3staag3stea2gundahl3a2ahl3szah4n1aah3r2eahrta2ain3spai3s2e2a3kam1a2kazaken2nak3rauak5tan2aktikak2t3r2aktstal1ageal3amealami5al3ampal1anaal1ansal1anza3lar_a3lareal2armal3arral1asial1assal3augal2b1lalb3lial2bohalb3rualds2ta4l1eha2l1eia2l1ela2lengal1epoal1erl3alermal1etaal1etha2l1eua4leur3a2lexal2glial1insa2linvalk1ar1alkohalk3s2alks4tal2labal2laual3les1allgäal2lobalo2gaal1opeal1orc3alpe_al3sklal3sunal4takal3tamal2treal2trial2troalt2seal1umbame2n1amer2aa2meriame3rua4mesh2a3mirami3taami3ti2ammalam2meiam2minam3stram2t1aam2t1äam4tel2amtemam2t3ram4treanadi3an1algan3dacande2san2dexand2suand1uran3e2can2ei_an3eifan1e4kan1ethanft5san3f2uang1ar3angeb2angiean2gla4angs_an2i3d3a4nima4ninsan2keian4klöank3ra3an3naann2aban3n2ea2n1orans2enan2seuan3skrans1pa1anspran3s2z1antei1anthran2tro2anwet1anzeian2zwiar3abtara3d2a2r3al2a2rara2r1auar2bauar2bec2arbenar2bre2arbs2ar2droar1effar1ehra2reinar2erfa2reria2rerlar1intar2kalar2knear2korar4kriark1s4ark3saark3shar2lesar2nana2r1oparr3hear3s2har3staar3t2ear2thear3t2iartin2art3rear2z1was1alaa3schea3schia2schma3schua3s2hiasin2gaska3sa3skopas3s2aas3s2eas3s2ias2s1pass3tias3stras3stu2as3taas4tauas4tofast3räaswa2s3a2sylat1apfa2tausat3eiga2teliate2ru4athe1atil4sati2st4atmusatra4tat3romat4setat2s1pat4takat4tauat2teiatz1eratz3t2at2z1w2au1a2au2bliau2bloauf1an2aufe_2aufehauf1er2aufs_2auft_4augehaule2sau2malau2m1oaum3p2aum3s6au3n4aau2nio2au3r2au2sauau2spraus3s22auts4ava3t4äche1eäch2späch4stä2d1iaäft4s3äg3str2äh3t4äl2l1aämi3enäne2n1äng3seän2k3län2s1cänse3häp2s1cä2r3a2ä2r1eiär1intär2k3lärt2s3äse3g2äser2iäskop2ä3s2kräs6s1cä4s3t2äß1erkä4t1a2ät2e1iätein2ät2s1iät2s1pät2s3täum4s52ä3us_backs4b1a2drbah2nuba2k1iba2krabal3th3b2andban2drba3n2eban4klban2kr2b1ansbar3deba2reibar2enbar3zwba3s2abau3sp3b2ä1cbbens2bb3lerbbru2cbe2delbe2erkbe1erlbe1etabei1f4bei3k4bei3labe1indbei3scbeis2ebei1stbeit2sbe3lasbe3lecbe3leibe2letbel3label3szbel3t4ben3arbe3nei3ben3gbe3n2iben2sebenst4ben2su2bentbb2entib1ents2bentwben3unben3z2ber3ambe2ranbere4sber3nab1erntbe2robbe3ropbe3rumbe3slobes2pobess4ebes3szbe2tapbe3thabien3sbi2ke_bi2kes2b1inb2b1infbin3gl2b1intbi2solbi2s5tb2it2abla3b4b2lancb2latt2b3law3ble2a2b3legb3lein3ble4nb3leseble3sz2blich3blickbling43blitzbo3ch2bo2e3ibon2debo1r2abo2reibo4rigbo4s3pbot2st2b3radb4ra3k2b3refb3reif2b3repbri2er2b3rolbrust3bru2thb2s1adb3sandb3sel_bse2n1b3s2esb2s1ofb3s2pubst3acbst1akbs3tätbst3erb2stipb4stodbs4trib4stübb2s1unbu2chibul2la2b3umkbu3r4ibus1erbu2sinbu2s1pbu2s1ubzeit1carri1ca3t4hcha2ck2ch1akch2anb3chancch1ang4chanz4char_1characha2sc3chato4chatuch1ärm3chef_3chefi3chefsch1eimcher3ach1ess2cheta1ch1iachi3na4chind2chinf2chinhch1insch1int1chiruch1offch1orcchre3s1chron2chunt2ck3an4ckeffck1ehe4ck1eick1entcke2rack2ereck1erhck2ern2ckero2ck1id2ckunt2ck1upcon2nec1s4trcussi43d2abäda2ben3d2ablda2bredab4rüdach3ada2chodach1sdal3b2d1amma2d1amt2d1ana2dangedan4kldan2kr2d1ans2dantwd2anz_4danzida2r3a2darb2dar2mada3s2hdat4e2da3teidate4n4d3atl4daush2d1ämt2d1änd2d1ängde3a2tde4ca_de2cka2d1eff2d1ehrdein2ddein2sdel1ändel1ec2delek2delem2delfmdelle2de2lopde3lordel5scdel2sodel3t4dem2ar2d1empden3th2dentwdera2bde1radde2rapder2bl2derdbderer33derieder3m2de4ruhde4rumde3sacdesa2gde4samdes2äcde2sebde4sehde2seide4setde2sinde2sordes3s2de2sto2d1etwde1urlde2xisdha1s4di3e2ddi3enidie2thdige4sdil2s52d1imb2d1ind2d1inf2d1inh2d1ins2d1intdion3sdi4re_di2rendi2ris2d1irl2d1isrdi4t3rdle2ra2d1o2fdo2mardo5n4adoni1e2d1opfdor2fädor2fldor2fr2d1orgdo2riedor2tadö2s1c3d4ra_2d3rad2drahm3d4ramd3rand2d3rät2d3räud4rea_d4reas3d4rehd4reiv4d3ren2d3rep4d3rer4dres_d4resc3d4ria2d5ricd5riegd4rin_3d4rit4dritu2d3rod2d3rot2d3rovdrö2s13d4ruc2d3ruh2d5rutd2sau2d2s1efds2eigd2serhds1errd3s2had2s1imds2infd3skuld2s1opds1orids1pasd2sprods3tabd4stagd4stead3steid4stemds4tilds4tipds1umsds2zend4theidtran2du1alvdu2bli2d1ufe2d1umb2d3umkd2ums_2d1umvdund2a2d1unfdun3kedun2kl2d1url2dursadwest3ea3dereadli4e3aleiealti2eat4e2eater1eat3s2e3au2feau1ste3b2akebert4eb3lereb4leue3blieeb3reiebs3paeb3staeb3strebu2t12e3cheech1eie2cho_e2ch3rech3taech1uheck3seede2aledens1edi4aled2s1oed2s1pee2choeed3s2ee2lekee3lenee4nage1e2pie1erbtee3r2eeere2see4reteer2öse1ertree3r2uee4tateewa4re2f1adef1anae2fente3f4lu2e3f2oef3reaef3rolef3romef2tanege2raeg4saleg4stoegung4eh1ache3h2aleh2auseh1eff1e2hepehe1raeh1inteh1lameh2linehl2seehr1a2eh2reiehre3seh1ro2ehr1obehr1ofeh1stee2hunt2ei3a2ei2bareibu4tei2choei2d1aei3danei3dra4eien33eifrüeig2er2eigew2eigrueik2arei3kauei2lareilen1eil3f41eilzuei2moreim2plei2n1aei4nasein3dr2einduei4nelei2neu2einfoein3g2e1initein4szei2sa4eis2peeis4thei1stoei2sumei2tabei2tanei2tarei2troeit3umek1s4tek5triel3abiel2abte2l1akel4amiel4ampel1ansel1anze2l1apel3ariel1asiel1aspel2ast3elbiseld3s22e3lebe2l1el1e2leme3lem_el1empel1erdel1erfel1erkel1erl2eles2el1esse2l1ideli2neel1itael3lanel5le_el3linell3spel1opee2l1orelo2riel2sumelte2kel2t3re2l1umel3useel2zwae2m1ad3emanze3m2ene2m1imemi5naem1intemi3tiemma3uem2meiem3pflem2spren4amee4nanden3angen3areen2ascen3atte3nauee2n1ären4ce_en2dalend3siend3szend2umen1e2ce2neffe4neine2n1elene4lee2nerfe4nerhe4nerk4enerne4nerz1engad3engagen3g2ien3gloeng3see2n1inen3k2üeno2mae2n1openost3en1ö2den3sacen2sauen2sebens2el1ensemensen1en3skaens2po2enstoent4agen2teb1entfa3entgaen2thi3entlaenü1ste1o2b1e3p2f41episo1e2pocep2tale3rad_er3admeraf4aera1frer3aicer3alleran3de3raneer3anfe2ranher3anmer3apfe3rarie2rathe3ratie2ratme1rauber3aueerau2fer3augerb4sper3chl2erdece3recher1effer1eige2reiner1ele2e3reme3renae3renz4erer_e4rerl4ererne3reroer1errer1erse2rerter1erwer1esser1eul4erfür1ergolergs4t1erhabe2riat4e3ric4e3rieer1inber1inker1inter1ita1erklä2erkreern1oser1o2ber3onye4ro2rer3smoert2aker2thoerts2eeruf4ser1u4mer1underung4er1unses2aches3anze3s2ases3cape3schaes3evaes2haresi1eres3intes2kates4loges2ortes2sau4essemessi2aes2sofes2spues3stres3stuest1ake1stare1state3stele1stile2stipes4trie2s1umes3umse4teinet3haleti2tae4t1ofetons4e2treset4riget2tabet2teiet2t3ret4troett3szetwa4retze4seu2esceu4glae3um2seum4sceums1peum3steu4neie3un2geu2nioeun3ka3eu3roeu1staeu1stoeu1stre2velae2vent1e2xeme2x1inex2tinfa2benfa2chof1aderfa3l2afal2klfal3tefalt2sfan2gr2f1ankf1an3zfar2br2f3arcfarr3s3f4art2f3arzfa3s4afa2to32f1auff1ausb2f1ärmfä2ßerfeatu42f1eckfe1inifek2tafe2l1afel2drfe2lesfe2l1ofen3safer2anfe2rauferde3fer2erf1erfaf2erl_f4erpaf2ers_fest1afest3r2f1etafe4tagfeu4ruf2f3efffe1inf3f4räff3shoffs4trfi2kinfik1o2fi2kobfi2lesfi4linfil2ipfin3sp2f1intfi2s5tfit1o2fi2tor3f4läc2f5läd2f3läu2f3leb3f6limfli4ne2f5lon1f4lop1f4lot1f4lug4f3orgfo3rinfor4stfor2thfor3tu2f1o2xf3rand1f4ränfreik2frein42f3ricf4risc1f4ronfro2nafs1allfs4ammf2s1asf2sauff2sausf2sautfs1e2bf2s1emf2s1erf2si2df2s1o2f3spanfs1penf3s2plf2sprefs2prif2sprofs2pruf2stasf3steif2stipf3st4rf2s1unf2t1alft1e2hft1eigft1eisf4theif2t3rof2t3röf3t4ruft4samft3s2cft4sehfts3elfts2tift1url2f1unffun2klfun2ko2f1unmfu4re_fus2safus2stfzu4gaga2b5l2ga2dr2g1amtgan2gagan2grg3anla3g2ano2g1armga3r2og1arti2g1arzgas3eiga2sorga4spega4sprgas4taga4ste2g1auf2g1autg2d1aug2d1erge3g2l2g1eifge2in_gein2sge2intgein2vgei3shgelb1rge5lehgell2age3lorgels2tgel3szge3lumge4namge4nargen1ebge3necgen3szgen3th2gentwge2rabger2erger3noge1r2öge3r2ug1erwag2e1s23ge3scges4pige3steges3thge3t2a2getapge3t4ugge2ne3g2het3g2hiegi3alogi2e1igie1stgi2me_gi4mesgi2met2g1indgin2ga2g1insgi3t2ag2lade2g1lag3glanz2gläuf2g3leb4g5lerg3lese3g2lid3g2lie3g2lit3g2loa3g2lobg3loch3g4lok3g2lop3g2lotgne2tr4g3notgoa3li2gonis2g1ope2g1opfg2o1ragra2bigra2bl2gradl2g3rah2g3rak2g3räu2g5re_2g3recg4re2eg3reit2g3ric2g3röh2g3rui2g3rum3g4rup2g3rüc3g4rüng3s2ahg4saltgs3amags3augg4s3cegs4chig4s3crg3sel_gs3elig3selngs5erkg4setags4pieg4spingsrat4g3stang3starg4s3täg5stämg3stelg1steugst2heg3stirgs3tocg4stolgs3topgst4rig4sturgs4tücgu1an_gu1antgu4d3r2g1u2fgu1ins2g1unfg2ung_gunge2g2un4s2gunt22g1urlgurt3sgu2s3agus2spgus2stha2choha2delha4dinh1adle2h2al_ha2lauhal2bahalb3rhal2lahal2sthand3shan2krh4a3rah1arm_h2armehar2thh1arti2ha3sahat5t2h1aukthau2sahau2sc2hautohau2trhä3usphe1choh1echthe3ckehe2e3lhe2fanhe2f3lhe3friheim3phei4muheine2h1einkhe1ismhe1isthel1eche3lenhe4lof4h1emphend2she2nethenst2hen5trh1entshe2ral2heraphe3rasherb4she2relh1erfüh1erkeher3thher2zwhe1stahe2tapheter2he3t4she1x4ahfell1hi2angh1i4dihi3enshier1ihiers2hil2frh1induhin2enhi3n2ihin3n2hin3s22hi3rehl1anzh1lauth5len_hlen3ghl2ennhle2rahl1erghl1erwh4lerzh4lesihl1indh3listhlo2reh3losihl2sanhl2serhl3skuhl3slohme1inhmen2shme2rahn3eighn3einhne4n1hne4pfh3nerlh3nerzhn3s2khn1unfho2ch3ho2ckahock3tho2f3rhol1au4holdyhol3g4ho4lor3hol3sh1o2lyho2mecho2medho4seihotli42ho2w1h1raneh3rechh4rei_h3reich3r2enhr2erghr2erkhr2ermhr2erzh4rickh4rineh4rinhh4risth4romeh4romihr2sauhr2serhr4sethr2tabhr2tanhr2torhrt3rihr2trohrt2sahrt2sehr1umsh2s1ech3s2exh2s1ofhs2porh2spräh2sprohst2anh1stechst2heh1s2tih2storh1s4trhst3rih1stunhs2ungh3t2alht3aneh3tankh4tasyht3a2tht1e2ch2t1efhte2heh2teifh2temph2t1euh2t1exh4theihthe3uh2t1inh2tolyh2torgh4trefh2t3ruh2t3rühts2tihu2b1ahu2b3lhu4b3rhu2h1ahu2h1ihuk3t4hu2l3ahu2lerhu2lethu3m2ahung4shu3ni1hus4sahus2sphu2tabhu3t2hhühne4h2wallh1weibhy2pe_i4a3g2ia2l1ai3aleiial3laia2lorial3t4ial3z2ia2nali3and2ia3p2fi2a3spi3a4tai3at4hib2blii2beigi2beisibela2iben3aib3renib4stei2bunki2buntibu2s1ich1eii2chini3chloi2ch3ri3ck2eid2ab4i2d1au1i2deeidel2äide3soide3sp1i2dio1idol_i3d2scid2s1pie2breie2choie2fauief3f4ie2f3lie2froie4g5lie3g4nie2g3riegs3cie3lasiel3auiel1ecielo4biel3sziel3taiena2bi3e2näien1ebie3neri3en3gi3e2noien3scien3siiens2kien3szier3a2ie2rapie3resi3ereuierin3ier3k2i3ern_iers2tier3teies2spie1staie2t1aie4t1oie2triiet2seiet3zwifens2if1ergif1erhi1f4lai1frauif4reii1f4rüif2topift3szig2absig1artiga1s4ige4naig1erzi2g1imig3reiig4salig3sprig4stoig4stöig3strig3stüigung4i2h1ami2h1umi4i3a4ik1amtik1anzik1artik3atti2k1aui2k1eiike2l1ik1erfi2kindi3k4läi2k3raik2trei2l3abi2l1acil1a2di2l1akil1ansil1aspi2l1auil3ausild2eril2doril1e2cil1eheil1einil2f3lilf4s3ilie4ni2l1ipi3lip_i3lipsil3l2ail3l2iil2makil2mauil2mini2l1oril3t2hilung4i2manwima2tri2melei2melfi4meshi2metiim2meiim1orgim3pseim3staimt3s2in3a2ci4nacki2n1adin2arain2arsin4arti2n3auin2dalin2dan1indexind4riin3drü1indusin1ehein2erhi4neskine3un1info_1infosing1af1inhab2inhar2inhauin2i3dini3krini3sei3nitzin2nor1inntain3olsino1s4in1ö2dins2aminsch2in2seb2insenin3skr1insta1insufin3s2z1integin3t4rin5trii3n2umin3unzinvil4io2i3dio2naui3ons3ion4stiore4nipi3elipi3en1i2rakir2k3lirli4nir2makir2mauir2mumir2narirpla4irt2stiru2s1isage2is3arei2s1äni2schmi2s3crise3haise3hiise2n1is2endisen3si2serhiser2uis2hasi2s1idi2s1of3i2soti2sparis1picis2pitis2pori2sprois4sauis3stais3stoiss3tris3stuis2sumis4tabis4tamist2anis4teliste4nistes3is4tocis5törist4raist3reisum3piß1ersit1ab_ital1ait1altit2an_it1arti3tauci4t1axi2t1äsi2t1eii4teigit2eili4teinite2lai4tepoi2t1idit2innitmen2i2t1ofit3rafit3rasit3rauit3räuit3ricit3romit4ronit3runit2stoit2tebit4triitt2spi2t1umi2tunsit1urgitzes4it2z1wi2v1akiv1angi2v1eiiv1elti2v1urizei3ci2z1irjahr4sja3l2ajean2sjek2trje4s3tje2t1aje2t3hje2t3rjet3s2jugen2jut2e1kab2blka2ben2kabla2kabläka3b4r2k1abt2k3adaka1f4lkaf3t2kaken42kala_ka2lanka3leikal2kakal2krkal4trkan2alka2nau2kanda2k1angk2ans_k2anz_2k1apfka3r2i2k1armk2arp3kar2pfk2artaka2s3tka3tanka3t4hka4t3r4kaufrkau3t22kautok1ä2mikä2s1ckdamp22k1e1cke2he_kehr2s2k1eic2k1eig2keinhkel1acke3lagkel3b4ke2lenke2lerkell4e2k1empken3au2kenläkens2kken3szk2enteken3thk2entrk2entu2kentwke1radk2erkok1e2rok2ers_ke2selke4t1ake2t3h2k1e2xki1f4lki1f4r2k1intkis4to4k1lack4leidk3lem_2k3lerkle2ra2k3leukle3usk2lisc2klistklit2s2k3locklo2i3klost4klung42k1lüc2k5nerkno4bl2k5norkoh3lukol2k5ko3n2ekon3s4ko1r2a2k1orckot3s22k3radk3rats2kraum2k3rät2k3rec2kred_2k3refk3reick3reih2k3rick3ries3k4ronks1e2bk2s1emk2sentks1erlk2s1idk2s1ink2s1o2ks2pork1s2tik2stork2sträk2stumks2zenk2t1adkt1aktkta4rek2t1auk2tempk2tentkte3ruk2t1idkt1insk2t1ofkt1opekt4rankt3rask4trefktro1skt3runk2tuns2k1uhrku3l2eku3l2i2k3umlkum2s1kun4s4kunst32k1up_kur2blku2reikuri2ekur2spkur2stlab4ralab4ri2l3absla2ce_la2gio2la1hola2kesla2k1ila1k4lla3min1lammf2l1amtlamt4sla4munl1analla2nau3l2andlan2gl2lanhäl2anhe4lanli2l3ann4lansä2lantrlan2zwlap4pll3artila2saulast1ola4tel2l3athl2auf_lau2fol2aufz2lausl2lausr2lauto2l1ähnlä2s1cl4betal2b1idlb2latl4bre_lb3ritlbst3elb4stol2b3uflbzei2l3d2acl2d1akld1amml2da2rld3arild1arml2delel3der_ld1erpl2d1idl2d1iml2dranl3d4rul2d1umle2chile2gau3l2ei_lei2br4l1eigl2ein_l2eindl2eine2leinkl2eintl4eistlei2talekt2a2lektr3l2ela3lemesle4nad2lendul2e2nolen3szl1ents4lentzlen2zil2e1rale2ragle2raul1erfol2erfrl2erfül2erkal2erkol2erlel4ers_lers2klers2tl2ert_l2ertel2erzales2amle3serleste3le1stole2tat2le3thlet4tule3u2f2leurole2xislfang3l2f1ecl4feisl3f4läl3f4lulf3ramlgen2alge3ral2getilian2gli3chili2ckali3d2ali2deo2l1idolid3scli3enelien3slie2stli2grelik2spli3m2ali3n2alin3alli2nefli2nehli2nepli2nes2l1inflings52l1inh2l1injlink2sli2noll2ins_l2insal2insc2linsp2linst2l1intli3os_li2p3ali3s2a2l1islli2tallit1s2lit3szlizei3lk1alpl3k2anl3kar_lken3tl3k4lul2k3rol2k3rulk4ställ1abbl2labtll1affll1aktl3l2alll3amall2anwll1anzll1armll3augl2lausl2l1ämll1echlle3enl2l1efll1eiml3len_llen3gl3ler_lle2ral2lerzll1imbll1impll1insl2lobel2l1ofll1opfl3lor_l3lorel2l1oul2l3öfll3s2kll2sprllti2mllt5s2l2marclm1auslm1indlm1inslm3stelm3s2zln3are3l2ob_lo2berlob4ril1o2felo2gaulo3h2e2l1ohrlo2k3rl1o2lylo2minlo2n1olo3renlo4skelo2speloss2elo4stelo3thalo3thiloti4o2l3öfelpe2n3l2p1holrat4sl3s2all2sannl3sarel2s1ecl2s1emls1erels1ergl2serhls1erlls2logl3s2pil2sprol3s2pulstab6ls4tafl3stecl3steil3stell4stemls2tiel2stitls2zenlt1a2mlt3andlt1angl3tarblt1artl2t1aultbau1lt3elil5ten_lter3alt2erglt4erölte2thl2t1eul4theiltimo4l2t1ofl4t3ötltra3llt3räult4rielt3roclt3rosl2t3röl2t1umltu2ri4lu4b32l1ufelu2g1alu4g3llu2g3rlug3salug3splu1id_2l1una2l1unf2l1unilu2s1ulu2t1alu4teglu2toplu4t3rl2z3acl3z2anlz2erklz1indlz2wecm2ab4rma2d4rma4d2sma2ge_ma2gebma2gefma2gegma2gekma2gepma2getma2gevma2gew2m1aggma3g4n2m1agomai4se2m1aktmal1akma2lanma2lauma3lermali1emal3lo2malltma2nauman3d2ma2net2mansa2mansä2mansc2mantwmar3g2maro3dma3r2uma2tanma2telma5trimat3semat3sp2mausg4m1ändmä3t4rm2d1ummedie4mee2n12m1eif2m1eig3meistme3lamme2laume2lekme2lermelet42melf_mel2semel5t4mena2bme3nalmen3armen3aumen3glme3normen4skmen2somen3ta2mentnmer2er3merinme2sal4meser2me3shmes2stmeste2me1stome3t2amie3drmi2e1imien3smie2romie4timi2karmi3l2amilch1mild4s2m1impmin2enmin2eumin2ga3min2omi2t1rmit3s2mit5sami5tsumi2t1umk5re_m2m1akm2m1almm1angmm1anzm2m1aumme4namme2samm1inbmm1infmm1inhmm1insmm1intmmi3scmm3stamm3strmmüll1m4nesimode3smo2galmo2k1lmon2s3mon3su2m1opemo2rar2m1orcmor2drmo2rermos4tampf3limpf1ormp3strms3andm4s1efms1erwms1inims1orim2spedm2spotm2sprom4stagm3stelm3s2tims5träm3s2tumt3aremt1eltm2t1eum2t1immtmen2m2t3romt2sprmt1urtmu3cke4m3unfmu4s1amu2s1omut1aumut2stmvoll14n3absna2ch1nach3s4na2drna1f4rna2gemna2h1a3n2aldna2letnal3lanalmo2na2lopnal2phn2als_nal3t4n4amenna3m4n2n1amtnamt4sn1and24n1ang2n1ans2nantrnap2sina2r1an2arle4n3artna3r2unasyl2na3t4hnat4sanat4sc3n2aul4nausb4nausgn2auso4nauss4nausw2n1ä2mnär4s53nä1umnbe2inn2d1akn2danlnd1annnde2sendi2a3ndo2ben2d3ren2drobnd3rolnd3rosn2druind2sornd2spr2n1ebnne3ein4n1ehr3neigtnek3t42n1ele5neleb4nelek4nelemne3lennel4la3ne3lu2n1embn1e2mi2n3emp2n1emsnen3a2n1endgnen3einenen14nengb4nengs4nengtnens4enen3skn1entb4nentn5nentrn1ents4nentzne2n3u2n1epone2posne2ranne2rapne2raun1erbine2reb2nerfü3nergrn2erlin1ermän2ern_ne1rösn2ert_n1ertrne2rup2n1erzne3sanne3skane2s1pne1stanes3tine2tadne2tapn1etatne2taunet3han1e2tunet2zi2n1eupnfalt4nf5linnft4s3ng2absn2g1acn2g1akng2anfng1anzn2g1äln3g2enngen2an3gläsn2glicngrab6ng3ratng3rocngs3panich1s3n2id_nie4n3ni3eneni1eronifes3ni2grenig4spni2kalni2karni3ker4n1imp3n2in_n2in4a4n3ind4n1inhni2nor2n1insn2ins_4ninse4n1int2n1invni2s1eni3se_ni2s1pni3spinis3s4ni2s1uni3t4rni3tscnitts1n2k3adn2k1akn3k2aln2kansn2kausn2k1ärnk4ergnk1inhnk3lennk3lesn2klienk3lunn2k3ronks2eink3s2znk2taknk2tannkt1itnk4topnk2trunmen2snna2ben2nadan2n1annnen3gnn2erhnn2erknne2rönner2znnes1enne4stnn1o2rnn3s2pn2n1ufno2blano2leu3n2opano2radno1rakno3ral3n2os_no2s3pn2ostenost1r2nostvno3tabno2telno3t3hno4thano4thi2n1o2x4n1ö4lnräu3snre3sznrö2s1n2sangn2santn2sausn2s1änns1e2dns1entn2s1epns1erfns1ergn2serhns1ersnsfi4lnsho2fn2simpnsi4tensi2trns2kaln2s1opn4spatn3s2pins4piens3ponn4sprän4spronst1akn3starn3statns4tornstü1bn2s1unns2ungns4unrns4unsn4s3zint3absn3t2alnt1angnt2arbnt1arknt2armn2t1äunte3aunt1ebente3g6n2teignt4enent4ernnt4ersnt4ertnt2hern2t3hon3t4hunti3kln2tinfntini1nt2insn3ti1tnt4lemntmen2nto3ment3recn5trepnt4rign5tropn2t3rünt4saunt2sto3n4tu_ntu2ra2n3umb2n1ums2n3umz3nung_n3ungl2n1uninu4t3rn2z1aun2z1ännzdi1snzi2ganzig4snz1inin2zurkn2z1wan2z1wän2z1wuoa3cheoa3chioa4k1lo4a3lao4a3mi3oa3seo3b2al2o3b2äob3ein2o3b2iob3iteo2b3li2o3bloo2b3reob3s2hob2staocha2boche4boch1eioch3ö2och3teochu2fo2ckarock2erock3szodein3ode2n1odene4ode3sp2o3diaof1a2co2f1eiof2f1a1offizof2f5lof2f3r2o1f1rof4samof2speof2sprof2s1uof2teio2g1abog1alaog1ango2g1eiogi2erog1steohen3sohl3auoh3lecohl1eioh3lemoh3lenoh3lepohls2eoh2n1ooho2laoh1o2poh4rinoimmu4oka2laokale43o2kelok2s1po2l1akolars2ol1aufol4damol1eieol1eisol2fraoli3k4ol2kreol2lakol2lelolo3p2ol1ortol2strol2z1aol2zinom2anwom1arto2m1auo2m1eio3men_o2meruom1erzomiet1om1ingom1orgo4munto2narbon3ausone2n3onens2on1erbon1ergon1eröo3netton3g2lon2i3do4nikro4n1imon3ingonlo2con3n2eo2nokeon1orconsa2gon4samon2sebonse2lonst2hon3t2aoo2k3lo2p3adop3aktopa2leo1pe4nop2f3aop3fahopf3laop1flüopi5a4op5lago2p3le1op3t4or3a2bor4altor2ando2ranhor3arbor3attor1ändor2baror2dauor2deuor2ditor2dumore4aso2r1efor1eigo2reino2rerfor1ethor2fleorf3s42orgetor3g2h2orgiaorgi1eor3gle2o3ric4orie_o3rier4orin1or5ne_or3s4aor2täror2tefor2theor2torort3reo4r3un2o3s2ao3scheo2s1eio3s2hi2os2kl2os2koos3peco3s2poos2seios2s3oos4sonos2s3pos2s3tost1auos4teios2t3hos3tilost3räost3reost3ufo3s2zeo2ß1elota2goo5tarko3tarto2t1auot3augotei4not4em3otemp2ot5helo2t3hiot3hosot1opfoto2rao2t3reot3rinot4spaots2peot2sprot2t3rot4triou1f4lou4le_o3undsou3s2ioviso3owe2r11o2xidöbe2laöbe4liöh3l2eöl2k3löl2naröl2ungönizi1öp4s3tö2r3ecö2r1eiör2ergö2rerlör2f3lö2r1imörner2ör3s2kö2schaö2schlö2schwö2s1eiös2s1cöte4n3pa1f4rpa1k4lpak2topala3tpa2narpa3neipa2neu1pa2nopan3slpa5regpa5rek1park_par2klpar2kr1partn1partypar3z2pa3s2ppat4e2pa5t4rpa3unipä3ckepä2t3hpät3s4pekt4spe2letpe2lexpell2apell4epen3dape4nenpe2n1o3pensi1pensupen3z2per2anper4nape2robperwa4pes3s2p2f1akpf1ansp2fa4rpf3arepf3armp2f1au4p3fe_pf1eimpf1einp3fen_p2fentp3fer_pf2erwp3f2esp2f3läpf3leipf3lie2p1heiphen3dphen3sphi2ka2phthepi3as_pi3chlpiela2ping3s3pinsepi3onupi4pel3pirinpi3t2aplan3gpo2laupo4lorpo1o2bpo1ralpo1raupo4stapo4stäpo2stopos6trpo2t1upp3anlppe2n1p2p1f4p3p2hopp5lanp2p3rap2p3repre2e13preis2p3rer3p4res1prinz2prosspro1stp3steap3stelp3s2tipt3albp4t3ecp4t1eip4telept1in1pto3mept1urspul2sppu2s3t2r3aacra2barrab2blr2aber1r4abi2r3abwra2chura2dam2radapraf3arra2ferra3gle3r2ahmrail4l2r3airra2krera2kro2raktira2la2ral3abr3alar3r4aldral3larall2e2rallgr3alp_2ralper3al3trama3srambi2ra2mer1r2ami2r1amtramt4sr4andar4anderand3sr4aner1rangirani1eran2kr2r1anm2r1anpr2ans_r2ansp2rantr2r3anw3rareirar3f42r3arz2rato_rat2st3raub_rau2mi3rausc2rausgrau2spraut5srä2s1c3rätser2b1abrbal3arba3rerb1artrb1aufrb1echr4belärb1entr3b2larbla2dr2ble_rb3lerrb2linrb4seirb3skarb4stärb3strr1che_r1chenrch1s2rch3sprch3tar3d2acr2d1akr2d1alrdani1rd1antrd1anzrd2ei_rden3drde3rerde3sprdi3a2rdia4lrdo2berd3ratre2altre3at_re3atsre2b1are2b1lreb3ra4rechs2reck_2recki2reditre2hacre2h1ire2h1orei4bl4reifrrei3gareim2p4reingr3eink4reinr4re2ke2r1elbre3lei2r1elf2r1elt4rempfrena2bre3nal3rendiren3drren4gl2rengp2rengsr1ense2rentw3r4er_2r1erbr2erbr2r1erdr2erenr2erki2rerlö2r1ermre2robr2erse2rerspr2erte2rertr2r1erzrer5zer2erzy3r4es_ress2ere1stare2thyreu3g2re3uni2r1eurrewa4rrf1ältr2fentrf3licrf3linrf2s1ärf2s3trf3t4rr2g1ahr2g1akrge4anrge2blr2getor2glanr2gleur2g1obr2gregr2gresr2gretrg3rinrgs4tr3r4he_3r4henrho2i3rib2blri1cha2ridolrie2frriene4rien3srie2nuri1er_ri4ereri2f1ari2ferri2f1orim4scr2i3na2r1indri3n4erine1i2r1infrin2foring3lrin2gr2r1inh2rinitr1innu2r1insrin4sorin2sp2r1inv3risikri4s1pri3t2irit2trr3klaur2klisrk5nebr2k5nurk3räurk3rinrk2s1erk3shirk2tinrk2t3rrk3trark4trirk1unirlös3srl2s1prl3ster3m2agrma2larm1ansrm1anzrm1a2pr2maphr2m1efr2mider2m1imrm3starm3umsrn2andrn3anirn2a2rrn3arern3arirn3eifr4nerfr4nerkr4n1inr2n1opr2n1orrn3s2ärn3s2prn3s2zrn3t2ero2bei3rock_r2o3deroh3na3r2ohrro2madro2mer4ro1nyror3alro2ratro2reiro2r1oror3thro3s2iro3smoro3starost1rro4tagrote3iro2thoro4trirots2orot2taro3t2uro3untrö2b3lrpe2rerrer4srre2strr2n3ar2r3obrr3stur4samprs3anprs3antrsch2lr3schur3schwr2seinrse2n1rs2endrse4ners1erers1erörs1ersrs1erzrs1etars2kalrs2kanrs2kiers2kisr4s1opr4sordr2s3phrs2tecr3stier2stinr2stiprs4tobr4stotr3s4trr3s4türtals1rt1angrt1annrt1antrt1anzr2t1arrte1e2rt4eifr2telfr2temort1ersrt3holrt2humr2t1idr2tinfrto2rirt3recrt3rosrtrü2crt2spart2sprru2ckurude2aruf2s32r1uhrru1insru2m3ar2ums_2r1unar2unde2r1unf2runglrun2kr2r1unl2r1unm4r3untru2r1erus4stru3staru4teiru2t3rrü1benrwun3srz1a2cr5zenerz1engr3z2ofrzug2u3sabetsa3blesach3t2s1ada2s3affsa1f4r3s2al_sal2se2s1alt3s2alz4s1amnsam2tos2an2cs4and_3sang_2s3anh2s3anl2s3anssan4sk2s3anw3s4ar_3s2ara4s3arb3s2ard3s2ars4sartisa4ru24s3ath4s3atlsauri1s3ausw2s1änd3sänge2schak2schao3sche_2schefsch2en3sches4schexschi4es4chim3schis2schmö2schn_2schoxschs2e4sch3tscht2ascht4rsch2up3s4cop3sco4rsda3mese3at_s1echtsee3igseein2se1er_se1erö2s1effse2galse4helse2hinseh3rese2hüb2s1ei_2s1eie2s1eig2seinb4seing2seinh4seink2seinl2seinn4seinr2seinw4s1eis3s2eitse2l1ase3ladsela2gse3lamsel1ec4selem2self_s3elixse2l3ösel3szsel3trs4e3ma2s1emp3s2en_se4nagsen3gl3s2enise4nob3s2enss2ent_s2enti2sentw2sentzse2n3use5refser2ers2erfrs3erfüs2ergr2serhöse2robs2ers_2sersas4ert_s2ertase3rum3s4ervse2selse1stase2tatse1u2n3s2ha_4s3hansho4resi2achsi3enesi1errsi3gnusi2g3rsig4stsi2k1äsik3t42s1immsi3n4a2s1ind2s1infsing1asin3ghsin2gr4s1inhsini1e2s1inq2s1ins2s1int4s1invsi2s1esi2s1osi2s1psi2tausi2tra3skala4skanz3s2ki_3s2kik3skulpsla2vesler3s3s4lipsli4tuslo3be4s5not2s1o2bs1o2he4sohng2s1ohr4so2lyson3auson3säso1ral2s3ordso2rei4s1ostso3unt2s1ö2l2spala2spara4sparo3sparuspe3p4s1peri2sperl2speros2perr4spers3s2pez4spi4p3s2plis3p4lu4s3poss2potts2pracs2pran4sprax2spräm4spräs2spred2spres2sprob4sprüfsrat2ssrö2s1ssa3bos2sanos4sansss2antss3attsse3hass1erös3s2essse3tass1offs2s1opss1oris2spros3stelss4tipss2turss1ums2stabb3s4tad3staff2stale2stalkst1almst1alpst1ami4stan_sta4na3stand2stani2stans2stanws4tar_4staris4tarsst1asis3tat_2stauf2staum3staur2staus4stälts4tänd5stätts3täus4s5te_3s2tegste2gr3s4tehs2te2i3steig4steil1s2tel2stel_2steln2stels4stem_s5ten_st4ens4stermste4sts4teti3s2teu1steue4steufs2t3ho2stie_s2tiegs2tiel2stien3s2tif3s4tims4tinfs3tinnst1ins1stitu2sto3d4stod_s4toffs4t3om2stopo2stor_2store2storg2storis3tort2stose4stote2stöch2strad2strag4strai4strak2stral5straß2strua2strug3struk2strup2st3t43s4tud2stumt2stun_4stunn2stuntstu3rest3url2sturn2s3tus2stüch2stür_2stüre2stürg2stürs3s2tyl3su2b3su2cha2s1u2fsu1it_su2marsu2mau3s2umesu2mels3umfesum1o2su2mors3umsas3umst2s1uni2s1urlsüden24s3zeis2zena4szent4s3zet2ß1e2gße2l1aß2ers_2ßerseßge2bl2t1abb3tabel2taben3table2t3abn2t3abtta3d2s3taf2et1af4rta2ga24ta3gltag4sttah3leta3i2kta1insta1ir_t1a2kata2krotak6ta3taktb3t2al_ta3lagta3lakt1alb_t1albk3t4aletal2löta2mert1amplt1a2na4t2andt3ankl2tanwa2tanwät2anz_t1anzat1anzuta2pe_ta2pes2t1armt1artitar2to2t1arz4t1aspta2tanta2tautat3eita2temtat3heta2tom4tatue2t1auf4taufg4taufnt1ausb3tausct2auset1ausk4tausltaxi1s2t1ältt1ängs3t4ebbte3cha3technteck2ete2ckite2en3te1erwteg3ret3eifr2t1ein4teinf4teinnt3eis_t3eisb3te3letel1eb2telemtel1ente4leute2littell2ete2l1ö3telt4tel3tatel3thte2min2temme2tempfte4m1utena2bte4naste4nauten3dat6endit6endote2nefte2nettens2et4entat3entb4tentdt4ente4tentnten3zwt3e2pi3t4er_tera2bte1rafter3am4terbs4terbtte2relt4erfrte3ria3termi2ternct4ers_terst4ter3zatesa2cte2santesä2cte2selte2sprtes3s2te2tat3teur_2t1exz3t4ha_3thal_4t3hau1t2he_2t3heit4heint4henet4heni2therr3these2t3hil2t3himth4mag2t3hoc2t3hoht4hol_2t3hot1th2r2ti3a2mtiden2ti2deo3tief_3ti2erti2kamti2karti2kinti2kräti2larti2leiti2lel4t1imp3t2in_4t1indti3n2eting3lting3s2t1inj2t1int4t1invti2seiti1sta2ti3tuti2vanti2velti2v1oti2v3rtlung4tnes4s3tochtto4d1utom1e2to2mento2nauto2nehto2pakto2patto2rauto4ränto2relt3orga3torint1ort_3tost4to1sta3to3teto2thotouil44tractt3rad_6trahm5t4rai2trand3trankt3rann3transt3raset3rasi3träne4t5re_tre2brt3recht4reck6t3red5t4ree4trefe4trefot4rei_4treic2treift3reigt3reint3reis6treitt3reiz6t3relt4ren_3trendt3rent2trepe2trepot4reprt4res_3treuh5trieb2triegtri4er5triggt3rind4tringtri3ni4trinn4tripttrizi13t4roitro2ke4trom_tro2mi4troml2t3roo3tropf2t3röttrums15t4ruptru2thtrü1betrü1bu2t3rüct4sa4bt3s2act2s1aht4s3art2s1änts4cort3seiltse2n1t2s1erts1init2s1irt1slalt3spalts1parts2pedt3spekt3s2pit4stagts3takts4talt2stipt4stitts3tocts3tort2strits3türtta2bet2t1adtt2anttt1arttt1ebett1eiftt1eistte2lattel1otte2satte2sätt2häut2t3hott4roctt2sentt2sortt2spett2sprtt2stitu1almtu2chitu3fent3u2kr3t2ume2t3umf2t3umg2t3umk2t3umrtum2situm2so2t3umt2t3umz2t1una2t1und2t3unft3unga2tunif2t3unttu2re_tu2reitu2resturin1tück2s3tür3s3tütentze4n1tz2enetz1erltze2rotz2erst3ze2stzgel2tz1indtz1inttz2tinua2lauu3aletual2mau3a2louara2bu2be2cub3licu2b3luub2sanub2s1oub2spau1cha_uch1eiu3chesuch1iluch1inu2ch3ruch2souchst4u2ckemuder2eudert4udi3enuditi4ue2neruenge4uen2zuue2r3aue2r1äu3erehu3ereru3erexuer3g2uer2neue2r3ouer3scuer3t2u3erumue4teku2f1äsu2f1eiu2f1emu3fen_u2fentuf2ernuf2frouf1oriuf4sinuf2spouft3s2u2g1apu2g1eiug3ladu3g2löug4serug3spaug4sprug4spuug5stäug3strug3stüuhe3s6uh2reruh4rinuisi4nui4s5tukle1iuk2t3ruld2seu2l1elul1erful1erhul1erwule2saul1etaul1insul2lesul2p1hul4samuls2thul4trium1allum1anzu2maut1um3d2umer2aum1ins3umsatum4serum2simu2m1uru3n2amu2n3an2un2asun4dabun4deiun2didun2dorun2d3r4unds_und3spund3stun2ei_un3einunen2tun4es41unget1ungew1unglüun2g1rung3raung3riung4saun3ide1u2nifun3islu3n2it3u2nivun2keiun3n2eunvol2u1or3cu2pf2eu2pf1iu3rabaura2beur2anbur2anhu2r1auur3b2aur1effu2releu4r1epur1erhur1erwur2griurg3s4ur1iniur3insur1int1urlauur3sacur2sanur2sauur2serur4sinurst4rur2z1wus4annu2s1ecu2s1eiu3seiduse1rau2serpu2s1opu2spatus1picus2porus4sezus2sofu1stalus3tauust2inu2stunu2sturut1altut3a2mu2t1apu2t1arute4geut1ei_ut1eieutel1eute2n1u2tentu4t1exu2t3hout1opfu2topsut3reaut3s2aut2s1äut2spaut5t4lutu4reutu5ruut2z1wuve3räüb2s3tücht4eü3ckenück1erü3den_üden4güdwes2ü2f1eiü2h1eiühl1acüh3r2eühr3taü2mentün2fliün2g3lün3strü2r1eiü3r2o1ü2schlüs2s1cü2t1alva2teiva2t3hvatik2va2t3rvat3s4va2t1uveits32ve3muve3nalve3radve3rasver3b2ve4rekve4rinver3stver5te2ve3scves3tivi4a3tvie2w1vi2l1avi4leh2v1i2m2v1intvi3s2ovoll1avol2livo5rigv1steuwab2blwa3chewaffe2wa2g3nwah2liwal4dawal2tawal2towang4s1war2eware1iwart4ewass4e4webebwe2g1awe2g3lwe2g3rweg3s4wei4blwei2gawei3k4wei4trwel2t1wel4trwen3a4we2r3awer2bl1werbu1werduwerer2wer2fl1werk_wer2ka1werkewer2klwer2kuwer2tawer2to1wertswe2s1pwest1awes2thwest3rwes4tuwett3swi3ckawien2ewie2stwim2mawin2drwi3s2e1witzlwo2chawoche4woh2lewo2r3iwo4r3uwört2hwul3sewur2fa1wurstwus3te1wu4t1xe3lei3x2em_xen3s2x1i2doxin3s2xi2so2xis4täx1i2tuxtblo4x2t1eix4tentx2t3evy3chisyloni1y2p1iny1s4tyy2s1u22z3a2b2z3a2k2z1all2z3anf2z3anlz1artizar2tr2z1arzza1st42z3at3z1au2fzbübe32zecho2z1eck2z1effzei3lazeile42z1einzei3s4zeist4zei2trze2lenzell2azel3sz2z1empzens2ezent3sze2r3a2zerhöz2erl_2zerlö2z1erq2z1erzze3skuzes2spzes2stze2s3tze3sta2zettszger2azi3alozi1erhziers1zi1es_2z1impzin4er2z1inf2z1inhzin1itzin2sa2z1invzirk6szi3s2zzi1t2hzor4ne2z1oszz2t1auz4tehezt1inszt3reczu3ckezug1un2z1uhr2z1um_zumen22z1umszup2fizu3r2a2z1url2z1urs2z1urtz2wangz2weigz1weis2z1wel2z1wen2z1werz2werg2z1weszzi1s4");
            put(7, "_al4tei_amt4s3_and4ri_an3gli_angst3_an4si__an4tag_ausch3_be3erb_be3r2e_berg3a_bo4s3k_bu4ser_da4rin_da4te__da4tes_de4in__dien4e_ebe2r1_en2d3r_en4tei_er4dan_er4dar_er4dei_er4der_es5t4e_fer4no_fi3est_fi4le__fi4len_ge5nar_ge3r2a_ge3r2e_ger4in_hau2t1_her3an_ho4met_ima4ge_ka2b5l_li4ve__lo3ver_lus4tr_men3t4_orts3e_pa4r1e_reb3s2_re3cha_rein4t_reli3e_res6tr_sali3e_sim3p4_sto4re_tage4s_ti4me__ti4mes_to4nin_tri3es_ul4mei_urin4s_ur3o2m_ve5n2e_wei4ta_wor4tu_zin4stab1er2raber4ziaber4zoab3essea4cherfa4cherka4cheröach1o2bach2t1oach1u2fa3d2ar3ade1r2aade3s2pade5str2ad3recaf4t5reage4neba4gentuage4ralage4selage2s3pag3esseags4toca2h1erhah4l1eiahner4eahre4s3ahr6tria3isch_ajekt4o1a2k4adak5t4riala5ch2a2l1angalb3einalb3eisal4berh3a2l1efa4l3einal3endsa2l1erfa2l1erha2l1ert3a2lerza2l1eskali4eneali4nalal3lenda2l1o2balt3eigalt3ricalt4stüalzer4zamen4seamp2fa2am4schlana4lin2ana1s4and4artandel4san2d3rüand4sasand3stean2f5laan2g1eian4gerwan2g3raan2k1anan2k3noan2k3rä3antennan3t4heant3rina3ra3lia2r1anga2r1ansa2r1anza2r3appar2b3unaren4seare3r2aa2r1erhar2f3raari3e4nari3erdari3ergarin3itark3amtar2k1arark3aueark3lagark4trear4merkar3m2ora2r1o2dar2r3adarre4n3ar4schla4schecasch3laa2s3e2ma2s1o2fas4s3eia1s4tasas6t3rea2t1aktater3s2ato4mana2t1ortat4schnatt3angat3t4häat2t3räat4zerkat4zerwat2z1inau2b1alauch3taau4ferkaup4terau2s1ahau4schmau4schoaus3erp3aussagaus4se_aus5triau2t1äuä3isch_äl4schlän3n4e2ä2r1eneär4mentäser4eiäse4renäskopf3ät4schlät4schräu4schmäus2s1cba2k1erban2k1aba2r1ambau3s2k2b1eierbei4ge_2b1eimebe1in2hbe2l1enben3dorben4spaben4sprben5t4rber4ei_be4rerkber4in_ber3issbe2s1erb3esst_be3s4ze4b1illubis2s1cb2i3tusbjek4to2b3leidbo2l1anbor2d1ibor2d3rbor2t3rbra1st42b3rat_2b3riemb4schanb6schefb4s1erfb4s1ersbst1a2bb2s3träbs3treubtast3rbu4schlbu4schmbu4schwbügel3eca3s2a3ch3a2bich3anst3chartache4fer4chelemche4ler4chents4chentwche3rei2ch1e4x3chines2ch1invch3leinch4sper2ch1unf4ckense4ckentw4ckerhö4ckerke2ck1err4ckerze2ck1eseck4stro2ck1um3com4te_comtes4cre4mes2d1alar2d1ammädan4ce_dan5kladan2k1odar2m1i2d1au2f2d1aus3delei4gde3leindel4lebdel4leide2l1obdel4sandel2s5edel2s1p4denergden4sende2re2bde4reckder3ediderer4tderin4f4derklä4derneuder3taudert4rades3eltde2sen1de4stredes4tumdeten4tdge4t1edie4nebdi3ens_die2s3cdi2s5tedi4tengd2o3r4ador2f1a2d3rast2d3rauc3d4reck2d3reic3d4riscdrunge3drü5cked4s1amtds3assid4schind2s1e2bd4seinsd2s1engd2s1entd2s1erfd2s1erkd2s1erzd4s1etad3s2kand2s1pard3stell2d1un3ddu4schndu4schrdu4schwe4aler_e3at5t4ebens3eebet2s3eb4scheeb4stätebs3temebs3t2hech1o2bede3n2eeden4seeden4speder3t2ed2s1esed2s3treein4see2f1e2be2f1i2de2f1insege4strehen6t3ehe3strehl3eineh4lenteh5l2erehr1e2cehr3erleienge44eigeno1ei2g3nei3k4laei4leineil3inseim3allei4nengein4fo_ein4fosein4hab3einkomei2n1o23einsate4inverekt4antekt3erfekt3ergela4bene2l3a2me2l1a2re2l1eine3leinee4leing2e3len_e4lensee2l1ente2l1erge2l1errell3ebeell3eiseller4nelt3eng3elternelt3s2kelt3s2pe2m3anfe2m1ansem2d3a2e2m1erw1e2metiem2p3leena3l2ien3d2acend4ortend3romend3s2pene4bene4n1enten4entr4e3ner_e2n1erd1e2nerge2n1erle2n1erre2n1erse2n1erte2n3erue2n1erwe4n3essenge3raeni3er_e2n1i4me2n1o2benob4lee2n1o2ren4terb3entspr4entwetenz3erte4ratemerd3erwer3echser1e2ckere4dite2r1e2h4e3rei_4e3ren_e4rensee4rentne2r3erfe2r1erher3e4tiere4vid3ergebn4ergehäe3ri3k44e3rin_e2r1ini3erlebnermen4serm3erse2r1o2pers4toder4tersert3ins3erweck6erweise4s3atoe2s3einese4lere3s2peke3s2pore3s4praess3erges2s1paestab4be4starb1e2stase1s2tecest3ories3tropeße3r2eeten3d2eter4höeter4tre4traume6t3recetsch3wet2t3auette4n1et4t1umeu3ereieu3g2ereve5r2iewinde3e2z1ennfa4chebfa2ch1ifäh2r1ufeh4lei2f1eing4f1einh2f1einw2fe2lekfe2l1erfel4sohfe4rangfer3erz4ferneufest3eifet2t3afeuer3effel2d1f2f3emifi1er2ffi2l1anfisch3o2f3leinflu4gerfor4teifor2t3r2f5raucf4schanf4scheff4s1ehrf2s1entf4s1etaf3s2kief2s1pasf3s2porf4stechf3s4telf3sternft1a2bef4t1entft4scheft4s3täft4stri2f1u2nifun2k3rfus2s1pfu2ß1er4gangeb2g3ankugas5tangebe4amge4lanzge4lessgel3stegel3t2agen4auggen2d1rgen3eidgen3erngen4samgen4ta_2g1entfge4renggerin4fgerin4tger4satger4stoges3aufges3eltge2s3erges3s2tgien2e12g3isel3g2laub2g1lauf4g3lein4g3lisc2gni2s13g2num_2g3rede2g3reic2g3rein2g3renng3riese2g3ringg4s3a2kg4schefg3s2eilg3s2pekg3s2porgst3entgst3errg4s3torgs4trat4gungew2g1unglguschi5gus4serhaf3f4lhalan4chal4beihal4t3rhar4mes2h1aufmhau4spahäu2s1chba2r3ahe4b1eihe5ch2ehe2f1eihef3ermheiler4heit4s3he2l3auh3e2lekhel3ershel4meihe4n3a2hen3endhen3erg2h3entwher3a2bhe4reck4hereighe4rerwh1er2foherin4fherin4sh3erlauhe2s5trhie4rinhif3f4rhi2l3a4hin4t1ahir4nerhlags4ohle3runhner3eih3nungeho2l1ei2hot3s2hrei4bah4r3eigh3re2s1h2r1etah3rieslhr2s1achr2s3anhr3schlhr2s1enhr4s1inhr4s1ofh2s1achh4schanhse4lerh2s1erlh2s1ingh2s1parhst3alth2s3tauh3steinh5stellhst3ranh3taktsh4t3alth4t3a2mh4t3assh2t1eimh2t1eish4tentfht3erfoht3erfüh2t1erhh4terklht3erscht3ersth2t1erzh4t1eseh4t1esshte3stah4t3rakht3randh2t3rath4t5rinh2t3rolh2t3rosh4t1rösht3spriht4stabhts4tieht4stürh2t1urshu2b3eihu2b1enhu2l3eihu4lenthu2l1inhut4zeni3alenti3alerfi3alerhi3a2leti3a4liai1ät3s4i2b1aufich4speich2t3rieb4stoieb4strie2f1akie2f1anie3g4rai2e2l1aien4erfienge4fien3s2eie3r2erie4rerfi2er5niier4sehier3staier3steies2s3tie2t3hoie4t1ö4i2f3armift3erkif4t3riift3s2pi2g1angi4gefari3g4neuig3steiig4strei2k1a4ki2k1anoi4kanzei2k1erhi2ker2li2k1etaik4leriik2o3p4ikt3erki2l3a2mi4lentsi2l1erfi2l1ergi2l1erril2f3reilig1a2ili4gabi2l1indil3l2eril4mangil2m3atil2z1arilz3erki2m1armimat5scima4turi2m1erfi2m1erzi2m1infi2m1insindes4ii2n1engin3erbei4nerbiiner4löing4sam3inkarninma4leinn4stains3ertin3skanin3stelin4s3umional3aion4spiir2m1eii4s1amtisch3ari3s2chei4schefi4schini2sch1lisch3leisch3obisch3reisch3rui4schwai4schwoisch3wuise3infi4seinti2s1ermi2s1essis4s1aci1s4tati1s4teui1s4tilit3a4reiten3s2iti4kaniti3k2ei2t1in1i2t3ranits1a2git2s1e4its3er1it2s1peit4stafi2v1enei2v1enti2z1enejek4terjektor4je2t1u2jugend3jung3s42k1a2bo2k3a2drka3len_ka4lenskal3eri2k1annakari3es2k1artikau2f1okauf4spke1in2d2k1eiseke4leim2ke2lek2ke3letkel3s2kk3enten2k1ents4kerfahk4erfamk3ergebk3er4hökerin4tker4kenker4neuker4zeu2k1i2dekie2l3o2ki3l2aki3n4o32k1inse4k1lastkle3ari4k3leit2k1o2fekop4fenkot4tak2k3räum2k3redekreier4k4s1amtk2s1ersk2s1erwk3stat4k2t3a2rk2t1erhk2t1ingkti4terk4torgakt3oriek2u3n2akuri4erku4schl4l3aben4l1a2bl2l1a2drla2g1oblan2d3rlang3s4l1a2po2la2r1anla2r1eila4rene3l2ar3glar3ini2l1ar3t3lasserla2t3ralat4tanlat2t3rlau2b3rlaub4se2l1ausslär2m1al2b1edel2b1insld3a2b1ld3a2ckl2d1a2dl2d3a2nld4arm_lecht4ele2g1asleh3r2elein4dulei4ßerleit3s22le2lekle2m1o24lendet4lenerg2l1ennilen4sem2l3entwlent4wäle2r3asler3engle4rers3lergehl3ergen2l1ergilerin4s2l1er2ö3l2erra2l1esellgeräu33lichem3licherliebe4slie2s3clik4ter2l1indulingst4lin2k1ali4schu2l1i4solkor2b1ll1a2bel2l1a2mlle4n3all3endul4lentsl4lerfol4lergoll3erntll3ertrl2l1indl2l1o2rll1ö4sellus5t6l2m3a2blm3einsl2m1e2pl2m1erz2l1o2bllos3t4r2l1ö4l3l2s1a2dl4s1ambl4schinl4schmül2s1e2bl2s1ersl2s1erwl2s1impls3ohnel4t3amel2t3atol2t1eislt4stablt4stocltu4ranluf2t1aluf2t1eluf2t5rlung4sclus4s3alus2s1cluss3erlus2s1olus2s1plus2s3tlus4stälus4t1alust3relut1o2fmach4trma4ges_ma4laktma4l3atma2l3ut2m1analman4ce_man3ers2m1angr4ma3r2oma3s2pa4m1aspemassen3mas4telma1s4trma2ta2b2m1au2fmäu2s1cmbast3emedien3mein4dame1i4so2m1e2miment4spme2r3apme4rensmerin4dmerin4tmerz4en4m1essames2s1omes2s1pme4t3römierer4mil4cheminde4sming3s4mi4schami4schnmi4schwmis2s1cmi2s5tem2m1ansmme4linm4mentwmme2ra2mme4recmmi1s4tmo4n1ermor2d3amoster4mpf3erpmpf3errms5trenm2t1erfm4t1ergm2t1erlm2t1ersm2t1ertm4t1etam2t1insmt3s2kamun2d1amül4lenmütter3na3chenna2l1a2na4lent4n1a2nana4schw4n1a2synauf4frn4austenbe3r2en3ce2n3n2d1anznde4al_nde4lännde4robn2d3ratn4d3runnd4stabnds3taune2e2i22ne2he_2nehen44n3eing4n3eink3ne3l2o4n1endb4n1endd4n1endf4n1endh4n1endk4n1endp4n1endt4n1endwne4nenenen4ge_nen4gen4n1entl4n3entwne2ra2bne3r4alne2r3am4nerbe_4nerben4n5erfonerfor42n3erhö2n1erlöner4mit4n1ernt3n2ers_2n3ersa4n3essine2t1akne2t1annett4scnfi4le_n2g3a2mn2g1andn2g1einnge4ramnge4zänn2g1i2dn3g2locngs5trinie3l2a3n2ing4ni4schwnitt4san4k3algn2k1insn2k1ortnk2s1aln4n1alln4nentsn2n1unfn2o3ble2n1ob2s2n3o2fenor2d5rno4t3eino2t3inno2t1opn2s1a2dn2s1alln2s1äusn6schefn4schronsen4spn2s1erkn2s1erön2s1erwn2s1erzn4s1etan2s1inin4sperin4stat_nst3eifn3stemmns4tentnst4erön4stracn4strien3t2a3cn4tanzan2t1eisn4t1essn2t1inhnton2s1nt3reifnt3riegntu4re_ntu4res1n2ung4n2z1a2gn4zensen4zentwn4zentznz3erwe2o3b4enoben3d4oben3seobe4riso2ch1ecocher4ko3d2e1iof2f1inoge2l1io2h1eiso2h1erto2h1erzoh4lergoh4lerwo3isch_ol2l3auoll1e2col2l1eiol4lerkoma4nero3m2eiso2m1indo2m1into2n1erdon3n2anont3antont3erwon4t3riop4ferdopi3er_o2r3almor2d3amor2d1irord3s2to4rientor2k3aror4mansor4mentor3n2o1oro3n2aor2t1akor4t1anor2t1auort3eigort3erfor2t3evort3insor4trauort3ricor2t1umo4sentsoss3andost1a2bos4t3amost3angos3tarros4ta4soster3eos4t1obost3ranost3roto2ß1enzo2ß1ereo2ß1erfo3t2e1iote2l1aote4leio2t1erwo2t1i2mot4terkoun4ge_our4ne_ozen4taöchs4tuögen2s1öl2f1eiö2r1e2lö3r2erzö2r1uneö2sch3mpa2r3afpar3akt2par2erpar4kampar4kaupe2l1a2pe3li4npe3n2alper2r1a2ph1erspil4zerpingen4pi2z1in3ple5n4po2p3akpo2p3arpor4tinpor4trepor6tripo2s3tepost3eipost3rap2p3a2bppe4lerp4t1entpt3ereip4t1erwp4t1erz2r1acetra4chebra4chinracht3rr3a2d3r3ra1k4l2r3alm_r4alt2hram4manram4m3uram2p3lran4dep4r3aneiran4spara2r1inra4schl2r3asph2r3attarau3e2nrau4man2raus5srbe3r2erchst4rr2d1elbrden4glrder4err2d1innre3alerrech3ar3reigewrei3l2arei3l2irei3necre1in2v2re2lek2r1entl2r1ents4r3entzr4ergen2r1ernä4r3erns4r3ernt3r2ers_2r1ersare2s2tu2r3evid2r3e2x1rfi4le_rfolg4srf4s1idrf2s3prr2g1a2drge4ralrge4taprgi4selr2g3ralrg5s2turi2d3anri3ers_ri3estiri2f1eirif4terri4generin4dexrin4diz4rinnta3r4ins_r4inspirin4tegrin4t5rri4schori4schwr3i2talr2k3reark4stecrkt3ersrk2t1o2rl2s3tor2m1aldr2n1anzr4n3eisr4n1enern3enser4n1ergrn4erhir4n1ertrol4lanro4nerbron4tanros2s1crre4aler2s1a2dr4s1amtr2s3angr3sch2er4stantrs4temprs4terbrst3ingrst3ranr2t1almrt3a4rer2t3attrtei3lartei1s4rten3s2rt3ereir4terfar4terfor4t3erhr2t1erkrter4rerte3s2kr2t1imar4t3rakr4treisrt4s1ehr2t1urtru3a2r3ruch3strun2d1arund3er2r1u2ni4r3uniorus2s1pru2t1o2rve4n1er2z1erfr2z1ergr2z1erkr2z1erwrz2t3ror3z2wecsa2cho22s1a2drsa4gentsa3i2k1sa2l1ids3ameri6s1amma2s3a2nasan4dri4s3antr4s3a2sy2s3aufb2s3ausb3s2ausesbe3r2es4ch2al4schanc4schangsch3ei_4schemp4schess4schiru4schle_sch6lit4schre_4schrinsch3rom4schrousch3s2k4schunt4schwetsch4wilsdien4e2s1echo2s1e2ckse2e1i4se2h1a2se4h1eise4herk5s4ein_sein4dusei3n2esein4fos4eins_4seinsp4seinstsel3ers2s1endl4s1entf2s3entg2s1entsser3a2dse2r3als3erbe_s3ereig2s1erfo4serfül4serken2s3ernt4s3eröf4sersehse4r1ufse3rund4se4tap4s1e2thsi3ach_siege4ssi2g1a2si2k1absik3erlsin3g4lsing3sasi4schuska4te_4skategska4tes4s3klassni3er_sni3ersso4l3eisol4lerson2s1o2s1orga5s2orgeso2r1o24s1o2ve4spensi3s2pi4e4spier43s4prec3sprosssrat4scss1a2cks4s1alas4s1albs4s3amts4s3angs4s3anzs3sa1s2s2s1egasse3infss3ersessquet4s3ta3li4s3tann3staus_st3a2ve4stechn3steilhstei4naste4mar6s5ter_3sterncs4t3ese3s4tett1s2ti2rst1i4sosto3s2t1s4trah4strans3s4tras4straum4s5träg4sträne4s5tref4streibst3renn2s4trig2s5trisst3rollstro4ma4st3run2s4t3s42stum2sstum4sc3s4tunds2t3uni2s3tuns2st3urtsuch4st3s4zene2ß1estrßi2g1a2ta2b1anta4bend2t1a2drta2g1eitahl3sk3t2aktuta4lensta2l1optan4gar2t1anme4t1anna3t2ans_4t3ansi4t3anspta4rens3t4a3rita2ta2bta2t3erta2t1um4t3ausg4t3auss4t1auswtbauer4tbe3r2e4teilhet3einget3einlate2l3abte2l1acte2l1autele4bete4l1ecte4l1ehte4leinte4lerd4t3elf_te2l1inte4losttel3s2kte2m1ei3temperte4na2dte4na2g4t3endf4t1endl4t3endpten3d4rten3eidten3ens4tenerg4t1eng_ten4glate4n3in4tensem4t3entw4t3entzte3ran_te2re2bter3endte4rengte4rerkterer4z4terfol4terfül3ter3g2t6ergru4terklä2t1erlöter4mert3erneuter4re_ter4sert4erst_t4erstit4erstute4r1ufter4wäh2t3erzbtes3tantest3eitestes4teu3ereteu3eriteu2r3a2t3e2xe2t1e2xi4thrin_4thrinsti4dendti3e4n3tie4recti4gerzti2ma2gtim2m1atin2g1at1in1ittin2k1l3t2ins_4t1inseti4que_ti4schatisch3w3ti3t2etle2r3atmen6t3tmo4desto2d1ertor3inttra3chatra4demtra4far2t3rams3t4ran_tre4ale3t4reib2t3reih4trenditre2t3r2t3rund3t4runkt3s2chat4schart3sch2et4schefts4chemtsch4lit4schrot2s1e2bt4seindt2s1engt2s1entt2s1i2dts4paret3s2pont3s2port4spreits3tätit2s3tepts3tradt4strants3traut2s3trät4streut4stropt2s3trütte4lebtte4lent3u2fertums5trtung4s5tu2r1ertu4schlt2z1e2ct2z1eiet2z1eistz3entsubal3l2ubi3os_u2b3rituch4spruch4toruch2t3ru4ckentu3ck2eruden3s2ue3reigue4rergue4rerku4erinnuer4neru3erunfu3eruntu2f1ä2ßu2f1erhu4ferleufs3temuf2t1ebu4gabteu2g1erfu2g1erlugge4stu2g3rüsu3isch_u3ischsuk2t1inulm3einu2m3a2ku2m1artu2m1ausument4su2m1ergu2m1erlu2m1erwumpf4lium2p3leum2s1peun2d1umun2k1a2unk4titunk2t3run2n3aduns4t1runte4riunvoll3up4t3a2upt3ergu2r3a2mu2r1anau2r1angurgros4ur3s2zeu2s1eseusi3er_us3partu2s1pasu3s2peku5s4pizust3abeu5strasus6trisute4leiuter4eruto4berut4schlut4schmut4schöutz3engut2z1inüch2s1cück3eriü4ckersück4speü3d2ensü2f1ergü2h1engü2h1erkü2h1erzühr3ei_ül2l1eiün2f1eiü2r1entüste3neva2t3a4va4t1inve4l1auvenen4dve3rand2ve3s2evid3s2tvie2h3avie4recvi2l1invollen4vormen4waffel3wah4lerwalt4stwar3stewa4schawä3schewe3cke_we3ckeswei3strwer4gelwe4r3iowest3eiwest1o2wim4m3uwolf4s3wol4lerwor2t3rxi2d1emx2t1e2dxtra3b4x2t3rany2l3a2myl4antezei2t1aze2l1a2ze2l1erze2l1inzel3t2hze4n3aczen4semzen4zerze2re2b2z1ergäz3erhalzerin4tzer4neb2z1ersazert1a2zert4anzer4tin4zerwei3z2erzazessen4zger4s1zin4ser4zinsufzon4terz3t2herzu2g1arzu4gentzwan2d1");
            put(8, "_al1e2r1_al5l4en_anden6k_ar4m3ac_ar4t3ei_ber6gab_ber4g3r_de3r4en_einen6g_en4d3er_en5der__er4zen4_ka4t3io_lo4g3in_mode6ra_ost5end_oste6re_par3t4h_richt6e_sucher6_tan4k3la2ch1e2ca4ch3erwacht5ergach6tritack3sta43a2er2o1af4t3erlage4s3tiah4l3erhal4b3erw3a2l1e2bal2l3a4rall5erfaalli5er_al4t3erfam4t3ernand6spas3a4n1erban4g3erfan4g3erlan4g3erzang4s3poani5ers_an2t3a4ran2z1i4nar4t3ramau5ereinau4s3erwauster6mau4ten4gau4t3erhäs4s3erkbach7t4ebal4l3ehbe4r3eiwber6gan_ber3st4abe6steinbe4s3tolbote3n4ebst5einbbu4s3chach3e4ben6chergebcher6zie6ckergeb4d3achse2d1an3d22d1e4ben3d2e1i2mde2l1a2gde4l3augdel5sterde4n3endden4k3li4den4semde4r3eisde3r4erbde3r4erfde4r3ero4d3erhöh4d3ersatdest5altdest5ratdienst5r2d1in1it4d3innerdi4t3erldi4t3ermdi4t3ersd4s3tätid3s4tern2d1u2m1edu4sch3le3a4reneech3t4eiege4n3a2eg4se4r1ehr6erleei4b3uteei4d3errei2m1a2gein6karnein6stalei6schwuei4s3erwek4t3erzeld5erstel4d3erwe4ler4fae4ler4lae4l3ernäe4l3e4taelgi5er_elgi5ersel4l3einemen4t3he6mentspen4d3esse4n3ermoeni5ers_en5sch4eenst5alten4s3täten4t3rolen4z3erfen4z3ergen4z3erke2r3a4sie4r3eis_e4r3entferi3e4n3er6tereier4t3erfess4e3rees4t3enges4t3erhes4t3essestmo6deet4z3enteue6reifeut6schnfacher5ffal6schafal6schmfe4r3anzfrach6trf4s3tätif4s3tresf4s3tütef4t1e4tift4s3tanfzeiten6gas4t3el2g1eise2gel4b3ragel4b3rogel6dersge4l3ers4g3ereigge4ren4sge4r3entge4s3terglei4t5rgrammen6gros6selg3s4tatigs4t3rosgu4t3erhhaft4s3phal6lerfhau3f4lihau5steihau6terkhe4f3inghel4l3auhe2n1e2bhe4r3eishe4r3o4bhfel6lerhich6terho6ckerlhol6zeneh6rerlebh3s4terbh3t4akt_h4teil4zh4t3elith4t3entsht5erkenh6terneuh4t3erreh6terstaht6ersteht6raumeht4s3turhu4l3enghut4z3eria4l3ermie4n3a2gie4n3ergienst5räie4r3erziesen3s4ie4t3erhie4t3ertiker6fahi3l4aufbim4m3enti2n1e2bei4ner4trin2g1a2gin4n3ermin4s3tätir4m3untir4sch3wi4sch3eii5schingi6schwiri4s3etatiso6nendis4s3cheit4z3ergjah4r3eika4n1a4s6kantennkehr4s3o4ken4gagken5steiker6gebnkerin6stk3er4lauk3er4lebk6erlebe2k1er2zikeu6schlkor6dergkre1i2e4k4s3tanzk4t3erfolan2d3a22lat2t1alat4t3inl2d1e2seleben4s3lei6nerble4n3end5lentwet4l3ereigle4r3eim3l4ergew6lerwerbli4g3ers2l1in1itl6lergebl6lergen2l1or3g2l4s3ort_l4s3tätils6ternels6ternsl4te4leml4t1e4skl2t1o2rilu2g1e2blus6serflus6serklus6serslu4t3ergl2z1u4femagi5er_magi5ersmar6schmmar6schrma4t3erdmen6tanz4m3entwi4m3ergänmes6sergmp4f3ergmp4f3erz4m3ungebmu4r1u2fnacht6ra4n3a2mernavi5er_navi5ersn4d3entsnder5stene2n1e2bn4g3erseng4s3e4h2n3i2gelni4k3ingn4k3erfanseh5eren4s3ort_n4s3prien4s3tatens6terbenst5opfenten6te_nt4s3parober3in4ode6rat_ode6rateoh4l3erholl5endsoll5erweol4z3ernonderer5on4t3endopf5erdeopi5ers_or4d3engo2r1e2ckorsch5lior4t3entor4t3ereor4t3offor4t3räuos4s3enzo2ß1en2kö4sch3eipargel6dpä4t1e2hpä4t3entpe4l3inkp2f1in3spos4t3agrach6trärali5er_rali5ersran4d3errau4m3agräu5scher2b1a2der4b3lastrch6terwrderin6sr4d3erntrege4l3äre4h3entreister6re4n3end4r3erken4r3erlaurge4l3errgen4z3w4r3innerrkstati6rk4t3engrk4t3erfrk6terscrk4t3erwr2m1o2rirn3e4benrol3l4enrpe4r3inr6scherlr4s3ort_r6strangr4t3erler4t3ernäru6ckerlrun6derlrun6dersrun6derwr4z3entssa4l3erbsat4z3en6schlein2s1e2bense4l3erl4s1e2pos6sereignse4r3eimse4r3enk2s1i2deoson5ende2s1o2riesrücker6sse3in4tstel4l3äs4t3endss4t3engls4t3entfste6rersstes6se_5st4reif1s4tri2ksun6derhtan6zerhta4r3eretau3f4litau6schrtau6schwtblock5e4t1e2bentein3e4cte2m1o2rte2n1e2bte3n4ei_ten4t3riten6zerh4t3erde_te4r3eif6tergreiter4n3art6erscha6terwerbtes6terkti4v3erlto6ckenttrücker6t4s1amt4t4s3esset3s4terotta6gess2t1u2niotu2r1a2gtu2r1e4tu2ch1e4cu3erin4tuern3s4tu4g3reisun4d3erfund5erhau2r1an5sur3a4renu6schentusch5werusi5ers_u4t3ersaüge6leiswach6stuwach4t4rwahl5entwandels6we5cken_wein4s3aweis4s3pwel6schlwel6schrwel4t3a2wen4k3ri5werdensxpor6terx2t1er2fx2t1il2l2z1e2benzeit5endzei4t3er4z3ergebzer4n3ei4z3erstezer4t3agzer6terezer6trau");
            put(9, "_char8me__er8stein_he6r5inn_men8schl_men8schw_os5t6alg_rü6cker6_wort5en6_wor8tendach8traumalli7ers_allkon8tral5s6terbausan8ne_äh4l3e4be6b5rechtebs3e4r3inchner8ei_dampf8erfden6s5taue6ch5erziee4r3en4ge6l5eier_erg3el4s3fal6l5erk6fel6ternfor4m3a4gforni7er_fzei8tendgot6t5erggrab8schegren6z5eihä6s5chenhe6rin6nuherin8terh6l3er4näh6t5erspaieler8gebi2k1e2r2eil4d3en4ti4sch3e4hkamp8ferfke6rin6nulan6d5erwlan6d5erzleis6s5erlepositi86mel6ternmorgen5s65n2en3t2aner8schlenich8tersn4n3er4wano6t5entrnsch7werdn5s6ternen5s6ternsos4s3en4kpapieren8ram6m5ersr8blasserres6s5erw6r5innenmris6t5ersr6st5eingrs4t3er4wr4t3er4lasfal6l5erspani7er_sse6r5atts4s3e4strsu6m5ents4t3a4genttblocken8tes6ter6gür4g3en4gvati8ons_vol6l5endwer6t5ermwin4d3e4czes6s5end");
            put(10, "_er8brecht_os8ten8deder6t5en6deren8z7endgram8m7endhrei6b5e6cos6t5er6werein8s7trewel6t5en6dwin8n7ersczge8rin8nu");
            put(11, "_er8stritt__spiege8leiach8träume_lei8t7er8scpapie8r7endpiegelei8en");
            put(12, "ach8träumen_7sprechende_");
            put(13, "_er8stritten_");
        }
    }), ro("ro", 2, 3, new HashMap<Integer, String>() {
        {
            put(2, "1k1ț1b1c1d1zî21ja11l1m1x1v1s2ș");
            put(3, "2lvă3v_n22b_2bc2bdb2lbo1z4m2bs2bt2bțbu3_p44c_2ccc4l2cm2cs2ct2cț2cv_s44d_2dc2dj2dm3du2ec2zbe3ee1he1î2ele2m2ene1r2eș2z_2ețe3ue2x2ez1f42f_3fa3fo2ft1g22g_g4l2h_2i14i__ș4i2î3xui2n3xo3xii2s_z2î3dî3eî3tî3țî3zu2s2j_2jd2jlj4ua3ea2m4l_3xe2lb2lc2ld2lf2lg2lm2lp2ls2lt2lț3lu_g4a2n2m_3ma3mă2mb3xă3me2mf3mi3mî3mo3xa2mp2mt2mț3mu2mv4n_3na3nă2nc2nd3ne2ng3ni3nîn3jn1n3non1r2nt2nț5nu2nz2odo3e2x_2au3vr2ono1oo3u1p22p_3pap4l4r_2rb2rc2rdr2e2v_2rf2rg2ă12rk2rl2rm2rp2rt2rț2rv2rză3i4s_5sa5să2sc3se3si3sî4sms1n3so2sp2st5suă3ș4ș_3șa3șe1și3șî3șoș2p3șu1t24t_u3șt4lă3u2ț_3ța3țățu32u16u_uă3u3eu2l");
            put(4, "li3eiz3v2ci_3ziici2oî3loîna3în5șî3riî3rîîr5șîș3tcis2î4tiao2gî4ți2atr2c5nco2ț2ața2ji_ji2ț2ață_ni2ju3t3culcu2ța3uaa3uda3ugda4mda2țle2aa3ul2zi_4li_li3a_a2zli3oa3un2l5na3ur2d1n2l3șa3use1ace1aje1ale1așe1atea2țe1ava3uz2z2gzu2țme2z3zonee2a4mi_mi2ț1efa2m1năi2ee3iie3ile3ime3inza2țmu2țe3ită2m2ănu3mon4_i2ae5nee1o14nefe3on_u4i4ni_2era2eră2erc2e2sno4șă2zins3fn4sîn3ș2n4șie3șin5ti_i2e_i3țnu3anu3ănu5mba2țo1ago2al2ocaeu5ș2acăo3i2_i3veză5bi2eom4n3biiafo32v1no1rao1răor2co1reo1rio1rîo1rovi2țo1ruo3și2vi_o5ti3făș2fi_fi3e2z1n2p3cve2zpe2ț2pi_pi2epi3opi2țpi2zb4lupo4șpo2ț2p3s2p3ș2p3t2p3țve2țpu4șf5tua3ila3iugă3ț2gi_2alt2g3m2g3n2r1h4ri_ri3ago5nu3umri3v3gu32g3v_î4m2r1nu3ui2hi_2r1r2rs2r3spr3st2r3șhi2ahi3chi4u2h1n2z2v3zili2aii2așsă4msă4șia2ț4sc_i3căse2ases2se4ș4s2f5sfîi2edsi3pi3ia3s4li3iei3iii3ilu2toi3ini3irsto3i3itsu2ț2an_an4s4ilașa2ț3șă2i3lei3lo4și_5șii5șil3șin2anu4ș5nșnu5că2can2zș2tice2a3invi3od2t3c2t3dte2au4știo2ț2t3f4ti_ti3ati3e3til3tinti2ț2tî_ipă52t3m3tol3tor2t3ttu3atu4ș4t3zce2țis3f4ispiș3tțe2ț2ți_3ția3ție3ții3țilți2ț3țiui5tițu5ixe2zi3uau2a_u2adu3aui3uluăs2i3um4uguu3inu3iru3isu3itu3izi3usu3lau3lău3leu3lîu3lour2zi3utu4st");
            put(5, "e3i2e3s2coiți2aa5t4use4e_2ghi_se3spachi5cu3imi3undi3unuopi3eopla2_u5nie3i2oărgi5_a3ice3i4uă4ș3to2rică2ti_ăti4eemon5a3i2aos5tia5n2ede4sc2m3s2ot3odzi2an3i2acia3g4di2anpăr3țca3utî5țiiani2e4n1adna3inpi3e_4ști_4ș3trpi3ezcătu53z2olta3utn2cisn2cizes3cote5nies5tine1abne1anne1apdo4ilp4ți_3tii_pu3b44n1egne3s24nevi4n1exa3i2eng3ăt_cre1to2to3tru_3trul3truo4t3s2re2bive5nitu3im4t3un2chi_re4șini3ezbănu5ai3s21evita3utelă2tiri3ețți3a_ri3ezri5milătu52n3s2bi2a_ci3spns3poezi3arna2țe2z1oebu5iin2găn5t4uciza2u2biau2b3lu2b1oub3s2eci2abi2atu3i2au3i2ei3oni3utora3u2țru3ilu3i2țru3spnu3s2_i4u3zi2arati4au3liio2bi_alie6umi5rocu5ie3i2aus2prodi2az3vă");
            put(6, "te3s2pso3ric_de2aj_de2z12ri3unri4ali_pre3șani3ș4puri2epecți2otați4or2te_3b4limbo3ricci3aleoi3s2pdez3india2tămblîn3e3i3s2etan4ținți4ii4n1edi3ți2o");
            put(7, "rtua2leedi4uluecla2re_a4n3isoiecti2larați2bți4ne_oplagi2recizi2re3s2criitu2ră");
            put(8, "copia2tăteri6alăimateri6rografi6vorbito2omedi2e_");
        }
    }), sr("sr", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "š2ćt2jt2vd2jd2ld2rd2vg2jg2lg2rg2vh2jh2lh2rh2vk2jk2lk2rk2vd2žn2jl2jt2lp2jp2lp2rv2jv2lv2rb2jb2lb2rf2jf2lf2rm2jm2lm2rs2cs2js2ks2ls2ms2ns2ps2rs2ts2vz2bz2dz2gz2jz2lz2mz2nz2rz2vš2cš2kš2lš2mš2nš2pš2tš2vt2rš2čž2bž2dž2gž2lž2mž2nž2vž2đc2jc2rc2vč2v_h2_j2_k2_l2_m2_n2_p2_r2_s2_t2_v2_z2_š2_đ2_ć2_č2_ž2_b2_c2_d2_f2_g2o3ao3eo3io3oo3uu3au3eu3iu3ou3ua3aa3ea3ia3oa3ue3ae3ee3ie3oe3ui3ai3ei3ii3oi3u2a12e12i12o12u1");
            put(4, "2hvs2gr_2gv_2hj_2hl_2hvp2hr_2hv_2hvn2kl_2hvm2kr_2kv_2tj_2tl_2hvk2tr_2tv_h2ljt2ljp2lj2d1b2d1c2d1dv2lj2d1f2d1g2d1hb2lj2d1k2d1m2d1nf2lj2d1p2d1s2d1tm2ljd2lj2b1ž2b1b2b1c2b1d2b1f2b1g2b1h2b1k2b1m2b1n2b1p2b1s2b1t2b1v2hvh2hvg2b1z2b1š2b1đ2b1ć2b1č2f1ž2f1b2f1c2f1d2f1f2f1g2f1h2f1k2f1m2f1n2f1p2f1s2f1t2f1v2hvf2hvd2f1z2f1š2f1đ2f1ć2f1č2m1ž2m1b2m1c2m1d2m1f2m1g2m1h2m1k2m1m2m1n2m1p2m1s2m1t2m1v2hvc2hvb2m1z2m1š2m1đ2m1ć2m1č2p1ž2p1b2p1c2p1d2p1f2p1g2p1h2p1k2p1m2p1n2p1p2p1s2p1t2p1v2ščž2ščč2p1z2p1š2p1đ2p1ć2p1č2v1ž2v1b2v1c2v1d2v1f2v1g2v1h2v1k2v1m2v1n2v1p2v1s2v1t2v1v2ščć2ščđ2v1z2v1š2v1đ2v1ć2v1č2bj_2bl_2ščš2br_2fj_2fl_2ščz2fr_2mj_2ml_2ščt2mr_2pj_2pl_2ščs2pr_2vj_2vl_2ščr2vr_2dž_2d1z2d1š2d1đ2d1ć2d1č2g1žs2lj2g1b2g1c2g1ds2nj2s1ž2s1b2s1d2s1f2s1g2s1h2s1s2ščp2s1z2s1š2s1đ2s1ć2s1č2sj_2sk_2sl_2sm_2sn_2sp_2ščn2sr_2st_2sv_2ščm2sc_2g1f2g1g2g1h2g1k2g1m2g1n2g1pz2lj2g1s2g1tz2nj2z1ž2z1c2z1f2z1h2z1k2z1p2z1s2z1t2ščl2z1z2z1š2z1đ2z1ć2z1č2zj_2zl_2zm_2zn_2ščk2zr_2zv_2ščj2zb_2zd_2zg_g2ljk2lj2g1z2g1š2g1đ2g1ćš2lj2g1č2h1žš2nj2h1b2h1c2š1ž2š1b2š1d2š1f2š1g2š1h2š1s2ščh2š1z2š1š2š1đ2š1j2š1r2šk_2šl_2šm_2šn_2šp_2ščg2št_2šv_2ščf2šć_2šč_2šc_2h1d2h1f2h1g2h1h2h1k2h1mž2lj2h1nž2nj2h1p2ž1ž2ž1c2ž1f2ž1h2ž1k2ž1p2ž1s2ž1t2ščd2ž1z2ž1š2ž1ć2ž1č2ž1j2ž1r2žl_2žm_2žn_2ščc2žv_2ščb2žđ_2žb_2žd_2žg_2h1s2h1t2hvž2c1ž2c1b2c1c2c1d2c1f2c1g2c1h2c1k2c1l2c1m2c1n2c1p2šcž2c1s2c1t2šcč2šcć2c1z2c1š2c1đ2c1ć2c1č2cj_2cr_2cv_2hvč2č1ž2č1b2č1c2č1d2č1f2č1g2č1h2č1j2č1k2č1l2č1m2č1n2č1p2šcđ2č1r2č1s2č1t2šcš2šcz2č1z2č1š2č1đ2č1ć2č1č2čv_2j1ž2j1b2j1c2j1d2j1f2j1g2j1h2j1j2j1k2j1l2j1m2j1n2j1p2šct2j1r2j1s2j1t2j1v2šcs2šcr2j1z2j1š2j1đ2j1ć2j1č2l1ž2l1b2l1c2l1d2l1f2l1g2l1h2l1k2l1l2l1m2l1n2l1p2šcp2l1r2l1s2l1t2l1v2šcn2šcm2l1z2l1š2l1đ2l1ć2l1č2n1ž2n1b2n1c2n1d2n1f2n1g2n1h2n1k2n1l2n1m2n1n2n1p2šcl2n1r2n1s2n1t2n1v2šck2šch2n1z2n1š2n1đ2n1ć2n1č2šcg2šcf2šcd2šcc2šcb2scž2scč2scć2scđ2scš2scz2sct2scs2scr2scp2scn2scm2scl2sck2sch2scg2scf2scd2scc2scb2r1ž2r1b2r1c2r1d2r1f2r1g2r1h2r1j2r1k2r1l2r1m2r1n2r1p2šmž2r1r2r1s2r1t2r1v2šmč2šmć2r1z2r1š2r1đ2r1ć2r1č2šmđ2šmš2šmz2šmv2šmt2šms2šmp2šmn2šmm2šmk2šmh2šmg2šmf2šmd2šmc2šmb2zmž2zmč2zmć2zmđ2zmš2zmz2zmv2zmt2zms2zmp2zmn2zmm2zmk2zmh2zmg2zmf2zmd2zmc2zmb2smž2smč2smć2smđ2smš2smz2smv2smt2sms2smp2smn2smm2smk2smh2smg2đ1ž2đ1b2đ1c2đ1d2đ1f2đ1g2đ1h2đ1j2đ1k2đ1l2đ1m2đ1n2đ1p2smf2đ1r2đ1s2đ1t2đ1v2smd2smc2đ1z2đ1š2đ1đ2đ1ć2đ1č2ć1ž2ć1b2ć1c2ć1d2ć1f2ć1g2ć1h2ć1j2ć1k2ć1l2ć1m2ć1n2ć1p2smb2ć1r2ć1s2ć1t2ć1v2žmž2žmč2ć1z2ć1š2ć1đ2ć1ć2ć1č2h1z2h1š2h1đ2h1ć2h1č2k1ž2k1b_lj22k1c2k1d2k1f2k1g_nj2_dž22k1h2k1k2k1m2k1n2k1p2k1s2k1t2hvć2hvđ2k1z2k1š2k1đ2k1ć2k1č2t1ž2t1b2t1c2t1d2t1f2t1g2t1h2t1k2t1m2t1n2t1p2t1s2t1t2hvš2hvz2t1z2t1š2t1đ2t1ć2t1č2dj_2dl_2hvt2dr_2dv_2gj_2gl_2skb2skc2skd2skf2skg2skh2skk2skm2skn2skp2sks2skt2žmć2žmđ2skz2skš2skđ2skć2skč2skž2stb2stc2std2stf2stg2sth2stk2stm2stn2stp2sts2stt2žmš2žmz2stz2stš2stđ2stć2stč2stž2škb2škc2škd2škf2škg2škh2škk2škm2škn2škp2šks2škt2žmv2žmt2škz2škš2škđ2škć2škč2škž2štb2štc2štd2štf2štg2šth2štk2štm2štn2štp2šts2štt2žms2žmp2štz2štš2štđ2štć2štč2štž2spb2spc2spd2spf2spg2sph2spk2spm2spn2spp2sps2spt2spv2žmn2žmm2spz2spš2spđ2spć2spč2spž2svb2svc2svd2svf2svg2svh2svk2svm2svn2svp2svs2svt2svv2žmk2žmh2svz2svš2svđ2svć2svč2svž2špb2špc2špd2špf2špg2šph2špk2špm2špn2špp2šps2špt2špv2žmg2žmf2špz2špš2špđ2špć2špč2špž2švb2švc2švd2švf2švg2švh2švk2švm2švn2švp2švs2švt2švv2žmd2žmc2švz2švš2švđ2švć2švč2švž2ždb2ždc2ždd2ždf2ždg2ždh2ždk2ždm2ždn2ždp2žds2ždt2žmb2zbž2ždz2ždš2ždđ2ždć2ždč2žgb2žgc2žgd2žgf2žgg2žgh2žgk2žgm2žgn2žgp2žgs2žgt2zbč2zbć2žgz2žgš2žgđ2žgć2žgč2žgž2zdb2zdc2zdd2zdf2zdg2zdh2zdk2zdm2zdn2zdp2zds2zdt2zbđ2zbš2zdz2zdš2zdđ2zdć2zdč2zgb2zgc2zgd2zgf2zgg2zgh2zgk2zgm2zgn2zgp2zgs2zgt2zbz2zbv2zgz2zgš2zgđ2zgć2zgč2zgž2žvb2žvc2žvd2žvf2žvg2žvh2žvk2žvm2žvn2žvp2žvs2žvt2žvv2zbt2zbs2žvz2žvš2žvđ2žvć2žvč2žvž2žbb2žbc2žbd2žbf2žbg2žbh2žbk2žbm2žbn2žbp2žbs2žbt2žbv2zbp2zbn2žbz2žbš2žbđ2žbć2žbč2žbž2zvb2zvc2zvd2zvf2zvg2zvh2zvk2zvm2zvn2zvp2zvs2zvt2zvv2zbm2zbk2zvz2zvš2zvđ2zvć2zvč2zvž2zbb2zbc2zbd2zbf2zbg2zbh");
            put(5, "2n1nj2zvdž2žbnj2žvdž2žvnj2zgdž2zbnj2zbdž2zgnj2zddž2zdnj2žgdž2žgnj2žddž2ždnj2švdž2švnj2špdž2špnj2svdž2svnj2spdž2spnj2štdž2štnj2škdž2šknj2žmnj2žmdž2stdž2stnj2skdž2sknj2ć1dž2ć1nj2ć1lj2đ1dž2đ1nj2đ1lj2dž1č2dž1ć2dž1đ2dž1š2dž1z2dž1v2dž1t2smnj2smdž2dž1s2dž1r2dž1p2dž1n2dž1m2dž1l2dž1k2dž1j2dž1h2dž1g2dž1f2dž1d2dž1c2dž1b2dž1ž2nj1č2nj1ć2nj1đ2zmnj2zmdž2nj1š2nj1z2nj1v2nj1t2nj1s2nj1r2nj1p2nj1n2nj1m2nj1l2nj1k2nj1j2nj1h2nj1g2nj1f2nj1d2šmnj2šmdž2nj1c2nj1b2nj1ž2r1dž2r1nj2r1lj2lj1č2lj1ć2lj1đ2lj1š2lj1z2lj1v2lj1t2lj1s2lj1r2sclj2lj1p2lj1n2scnj2scdž2lj1m2lj1l2lj1k2lj1j2lj1h2lj1g2lj1f2lj1d2lj1c2lj1b2lj1ž2n1dž2žbdž2n1lj2l1dž2l1nj2l1lj2šclj2j1dž2j1nj2j1lj2šcnj2šcdž2č1dž2č1nj2č1lj2c1dž2c1nj2c1lj2žnj_2žlj_2ž1dž2šnj_2šlj_2š1dž2znj_2zlj_2z1dž2snj_2slj_2s1dž2ščlj2vlj_2plj_2mlj_2ščnj2ščdž2flj_2blj_2v1dž2v1nj2p1dž2p1nj2m1dž2m1nj2f1dž2f1nj2b1dž2b1nj2tlj_2klj_2kj_2hlj_2glj_2dlj_2hvnj2hvdž2t1dž2t1nj2k1dž2k1nj2h1dž2h1nj2ž3vl2c3vl2z3vl2š3vl2č3vl2č3vj2d3vl2d3vr2k3vj2k3vl2t3vj2t3vl2g3vj2g3vl2g3vr2h3vj2h3vl2h3vr2ž3mj2ž3ml2ž3mr2z3ml2z3mr2š3mj2š3ml2š3cj2š3cv2š3čv2š3tj2š3tl2s3tl2s3kj2š3pj2š3pl2ž3dj2ž3dl2ž3dv2ž3gj2ž3gl2ž3gr2ž3gv2z3dl2z3dv2z3gj2g1dž2ž3bj2ž3bl2ž3br2d1nj_be4o_bi4o_ge4o2d1dž2g1nj2zvnj3r2je3r2đa");
            put(6, "2c3vlj2g3vlj2š3plj2lj1lj2z3vlj2ž3dlj2nj1dž2h3vlj2š3vlj2ž3glj2nj1nj2č3vlj2ž3mlj2z3dlj2lj1dž2s3vlj2lj1nj2d3vlj2z3glj2ž3blj2š3mlj2z3blj2dž1dž2dž1nj2k3vlj2dž1lj2ž3vlj2š3tlj_a2d3j_u2š3č_u2š3ć_u2s3p_u2s3k_u2s3c_izr2k_ist2k_nag2n_u2z3v_u2z3r_u2z3n_u2z3m_u2z3l_u2z3j_u2z3i_u2z3g_u2z3d_u2z3b_o2d3v_o2d3r_o2d3l_o2d3j2t3vlj_o2b3r_o2b3j_i2š3č_i2š3ć_i2ž3đ_i2s3t_i2s3p_i2s3k_i2s3c_i2z3u_i2z3o_i2z3i_i2z3v_i2z3r_i2z3n_i2z3m_i2z3l_i2z3j_i2z3g_i2z3d_i2z3b4r3je_4r3jem2nj1lj_u3g2n3č2lan3c2mok3c2mač3h2tel3h2tev3c2mak3c2miz3t2mur3t2muo3t2mul3s2fer2s3klj3p2suj3p2sov3p2sič3p2sik3m2naž3m2nog3m2nož3b2det3k2než3k2nez3g2nev3g2mil3g2naj3g2miz3g2nos3g2noz3g2noj");
            put(7, "3g2milj_u3s4rđ_u3s4rt3g2njev3g2njav3g2njes3g2njet3g2nječ3g2njil3g2njio_u3s4rp3g2njit3g2njur3b2djet3b2denj3k2njiž3k2njig_u3s4rn_u3s4rk_u3s4rž_u3s4ra_a4e2ro3t2mast_u3s4rd3t2mulj3h2tjev3h2tjel3h2tenj_u3s4re3h2teti3č2lanj_u3g2mi_za3g2n_be2z3j_be2z3l_be2z3m_be2z3n_u3s4ko_be2z3r_be2z3v_izd2no_be2z3b_be2z3d_be2z3g_be2z3i_be2z3o_be2z3u_izd2nu_izd2na_o2d3že_o2d3žv_o2d3ži_u3z4rn_u2z3nj_nag2nj_u2z3lj_be2s3c_be2s3k_be2s3p_be2s3t_ra2š3č_ra2š3ć_be2š3ć_be2š3č_iz3g2n_a2b3ju_i2z3lj_i2z3nj_a2b3la_a2b3lu_ra2s3t_ra2s3p_ra2s3k_ra2s3c_ra2z3v_ra2z3r_su2b3l_ra2z3n_ra2z3m_i3z4iđ_i3z4id_ra2z3l_su2b3a_ra2z3j_ra2z3i_ra2z3g_ra2z3e_ra2z3d_ra2z3b_ra2ž3đ_a2nart_po2d3j3g2nezd_a2neor_o2d3uč_o2d3um_o2d3ul_o2d3uk_o3d4rž_o3d4rt_o3d4rp_o3d4rn_o3d4rl_o2d3ok_od3g2n_od3m2n_o2b3ud_o2b3už_o2b3uz3g2nežđ_o3b4rč_o3b4rš_o3b4rt_o3b4rs_o3b4rn_o3b4rl_o3b4rk_o3b4rđ_o3b4rv_o2b3lj_po3g2n_na2j3u_i3z4un_na2j3o_po3r2đ_po3r2v_na2j3i_na2j3e_na2j3a_i2n3eg_i2n3ed_na2d3v_na2d3l_po3m2n_i3s4uš_i3s4ut_i3s4us_i3s4uk_i3s4rk_i3s4me");
            put(8, "_iz4omer_i3s4luž_i3s4pav_i3s4pon_i2n3unk_i3s4pur_i3s4red_i3s4luš_i3s4tam_i3s4tar_i3s4tas_i3s4tać_i3s4tin_i3s4tir_i3s4tic_i3s4tok_i3s4tup_i3s4lov_i3s4lin_i3s4lik_i3s4led_po3m2nj_i3s4leđ_i2nokor_i2nogen_i3s4lab_na2d3lj_i3s4lam_i2n3obl_i2n3epc_na2d3oč_i2n3eks_i2n3ekv_i3s4koč_nu2z3re_na2d3um_na2d3uč_i3s4kin_i3s4kat_i3s4kak_i3z4upč_nu2z3už_na3j4ah_na3j4aš_na3j4ec_iz4ohro_iz4ohor_obe2z3b_obe2z3d_obe2z3g_obe2z3j_obe2z3l_obe2z3m_obe2z3n_obe2z3o_obe2z3r_obe2z3u_obe2z3v_i2n3art_obe2s3c_obe2s3k_obe2s3p_obe2s3t_obe2š3ć_obe2š3č_o2b3igr_o3b4jek_o3b4jer_o3b4jet_o3b4ješ_o2b3laj_o2b3lam_o2b3lep_o2b3let_o2b3leć_o2b3lež_o2b3leg_di2s3lo_o2b3liv_a2n3org_a2n3oft_o2b3luk_o2b3luč_o2b3oru_o3b4ran_o3b4rat_o3b4rać_a2n3orh_iz4ohit_iz4ohim_o3b4rem_o3b4res_o3b4ređ_o3b4reč_o3b4rež_o3b4rec_o3b4red_o3b4rij_o3b4ris_o3b4rit_o3b4rič_o3b4ric_iz4ohij_iz4ohel_iz4ohaz_o3b4rlj_iz4ohal_iz4ofot_iz4ofon_iz4otro_o3b4rok_o3b4ron_o3b4roć_o3b4roč_o3b4ruk_o3b4run_iz4otop_o3b4ruš_o3b4ruč_iz4oton_iz4oter_iz4otal_o2b3umi_o2b3umj_o2b3umr_o2b3ume_o3t2kam_o3t2kah_o2d3lj_iz4otah_iz4oste_o2d3arg_o3d4vaj_o3d4važ_a2n3oks_o3d4vis_o3d4vić_o3d4voj_o2d3igr_o2d3isk_o3d4jel_o3d4jen_o3d4jev_o3d4jeć_o3d4laz_o3d4laž_o3d4lag_o3d4luk_o3d4luč_o2d3ozd_o2d3ozg_iz4osei_o2d3ono_o2d3onu_o2d3ond_o3d4raz_o3d4rać_o3d4raž_o3d4rem_o3d4ren_o3d4ret_o3d4ređ_o3d4red_iz4orah_iz4opol_iz4ople_o3d4rlj_iz4oper_iz4opat_o3d4rin_a2n3idr_o3d4riš_o3d4rič_o3d4rib_o3d4ric_o3d4ron_o3d4ruž_o3d4rug_o2d3uvi_o2d3uve_o2d3uzi_o2d3uzl_o2d3uzd_o2d3uze_iz4onom_iz4onef_i3s4mje_iz4odoz_a2n3erg_iz4odin_a2n3epi_iz4odim_iz4ogon_a2n3ekl_a2nahro_a2nahor_a2nafor_a2nakru_po2d3oš_po2d3oč_po2d3of_a2nakol_a2nafon_a2nafaz_a2natro_a2natri_a2natre_a2natoc_a2natom_pre2d3j_pre2d3v_a2natim_a2nasta_a2nasei_a2nasar_a2n3arh_iz4ogeo_a2napti_a2napro_a2napno_a2napne_a2naple_a2napla_a2n3ant_a2naneo_a2namne_a2nalit_a2nalis_a2naliz_a2nalep_a2n3ald_a2n3alg_a2nakoj_a2nakli_a2nakla_a2nakef_a2nakat_a2nakam_a2nakal_a2nadoz_a2nadem_a2nagra_a2n3ago_a2nagno_iz4ogam_iz4obat_i3z4noj_i3z4nim_i3z4log_i3z4lož_i3z4loz_i3z4imi_i3z4grt_i3z4grn_ra2z3lj_i3z4vor_su3b4aš_ra2z3nj_a2nagen_a2nabol_a2nabio_a2nabat_a2nabaz_a2nabap_a3g2noz_a3g2nos_a2d3rog_a2d3ren_ra3z4ev_ra3z4ij_ra3z4il_ra3z4in_ra3z4ir_ra3z4it_ra3z4iz_ra3z4iđ_ra3z4ić_ra3z4id_a2d3lat_ra2z3od_iza3g2n_ra2z3ot_i3z4vir_i3z4vin_i3z4bav_i2z3aka_a2b3rog_i2z3aba_a2b3lok_a2b3lep_a2b3leg_i2z3daj_pro3g2n_iza3t2k_ra3s4pn_raz3g2n_u2s3tuć_u2s3tur_ra3s4rđ_ra3s4rd_ra3s4re_u2s3tum_u2s3trč_u2s3trć_u2s3trp_u2s3trn_u2s3trk_a2n3jon_i2n3jek_oda3d2n_oda3g2n_be3z4ub_be3z4up_i2n3jur_u3z4bor_u3z4van_u3z4vat_u3z4viž_u3z4voj_u3z4dic_u2z3igr_u3z4lan_u3z4lat_u3z4lim_u3z4lit_u3z4lić_u3z4lic_u3z4lov_u2s3trg_u3z4nak_u3z4nač_u3z4nič_u3z4nic_u3z4noj_u2s3tov_u2z3oho_u3z4ret_u3z4rev_u2s3teg_u2s3teć_o2d3žal_u3z4rnj_u3z4roč_u3z4ruj_na2d3že_za3t2ka_be2z3nj_u3s4kak_be2z3lj_u4s5kom_u4s5kov_u4s5koš_u3s4kup_u3s4pav_u3s4peh_u3s4pel_u3s4pem_u3s4pet_u3s4pev_u3s4peš_u2s3ter_u3s4pon3h2tjeti3h2tjenj3g2dekak3g2dekadni3g2de_ne3g2de_3g2njilj_u3s4rlj3b2djenj_o3b4rus");
            put(9, "_o2b3ubož_su2b3inv_i3s4mije_i3z4vjed_i2n3just_inte2r3a_i3s4pira_i3s4plit_i3s4plić_inte2r3u_inte2r3o_i3z4vojc_inte2r3i_i2n3util3g2djekak_i2n3unda_o3d4vesn_o3d4vest_o3d4vesa_i2n3umbr_o3d4vikn_i2n3ofic_i3s4pupč3g2niježđ_i3z4gred_a2n3ovar_a2n3iridne3g2dje__o2d3isti_i3s4tavi_i2n3opse_i3s4taknni3g2dje__i3z4drav3g2nijezd_na2d3žup_o3d4laka_na2d3živ_na2d3žir_uza3t2ka_i2n3opor_tran2s3v_o2d3onl_i3s4tori_i3s4točn_i2n3oper_o3d4rani_o3d4rano_o3d4ranu_o3d4rana_o3d4rane_i3s4toča_i3s4trav_i3s4trad_o3d4rapi_a2n3izur_o3d4rapa_a2n3izom_o3d4rven_a2n3izog_o3d4rveč_i3s4tran_i3s4trić_i3s4triž_i3s4tric_i3s4trug_tran2s3u_nu2s3pro_tran2s3t_tran2s3p_iz4oanem_iz4oanom_be3s4tid_po3d2nev_i2n3okup_iz4obron_tran2s3o_tran2s3n_iz4oglos_o3d4ronj_tran2s3m_na3d4val_iz4ograf_i2n3efek_na3d4vij_na3d4vit_na3d4vla_tran2s3l_na3d4vor_na2d3igr_na2d3inž_na2d3ina_po2d3adm_a2n3este_po2d3vez_po2d3več_po2d3vež_po2d3vik_po2d3vil_po2d3vir_a2n3erit_na2d3isk_na2d3jah_po2d3voz_po2d3vođ_po2d3vož_po2d3vod_na2d3jač_a2n3ener_po2d3vrć_na2d3jek_po2d3vrg_a2n3elek_po2d3vrs_po2d3vuć_po2d3igr_po2d3izv_na2d3jez_po3d4jen_po3d4ječ_a2n3ekum_na2d3ječ_po2d3lep_po2d3let_po2d3leć_po2d3lež_po2d3leg_po2d3liz_a2n3eger_na2d3jun_na3d4lan_na3d4leš_a2n3alfa_na3d4lež_po2d3lok_po2d3lom_po2d3lup_po2d3luč_po2d3luž_a2nakron_po2d3okn_na2d3ora_na2d3oso_na2d3ose_i2n3elig_na2d3ofi_po2d3rad_a2nafila_a2n3afij_tran2s3k_po2d3ram_po2d3ran_po2d3ras_na2d3ran_po2d3rep_po2d3res_po2d3rez_po2d3rik_po2d3rit_po2d3ron_po2d3rov_po2d3rož_po2d3ruk_po2d3rub_na2d3rač_tran2s3e_iz4oklin_nu2s3pos_po2d3usm_po2d3usn_na2d3rep_na2d3ruk_na2d3ruč_a2nastom_a2nastig_na2d3rug_a2naspaz_i3z4olat_i3z4olac_i3z4olir_i3z4olov_a2n3apto_pre2d3id_iz4oleks_iz4oluks_na2d3žnj_iz4ometr_na3j4avi_i2n3evid_na3j4ava_na3j4ave_a2n3andr_na3j4adi_na3j4ada_na3j4ade_na3j4aži_na3j4azi_na3j4ako_na3j4aka_a2n3akuz_na3j4alo_na3j4ami_na3j4aml_na3j4amn_na3j4ari_na3j4arm_na3j4arc_na3j4ati_a2nadipl_na3j4auk_iz4omorf_na2d3ždr_na3j4edi_na3j4edn_na3j4edr_na3j4eda_na3j4eži_na3j4ežu_na3j4eže_na3j4ezn_na3j4ezd_i2n3afek_na3j4etk_va2n3evr_na3j4uri_i2n3aura_tran2s3c_be3z4bol_ra3z4ban_ra3z4bar_ra3z4bau_ra3z4bad_o3t2kast_ra3z4boj_ra3z4bor_ra3z4val_raza3g2n_pro3t2ka_iz4opsef_pro3t2ki_pre2d3že_iz4osint_ra3z4vit_ra3z4vić_ra3z4voj_ra3z4von_iz4osist_iz4oskel_ra3z4vrt_ra3z4vrć_ra3z4gađ_ra3z4grt_obe2z3lj_iz4oskop_iz4ostaz_tran2s3a_supe2r3e_i2n3apst_i2n3anic_i2n3amor_obe3z4ub_pre2d3ži_ra3z4laz_ra3z4lag_ra3z4lik_ra3z4lič_ra3z4loz_ra3z4lož_ra3z4log_ra3z4met_ra3z4meć_supe2r3a_ra3z4nat_ra2z3obl_ra2z3obr_ra2z3oba_supe2r3u3g2degod__a2d3verb_ra2z3ort_ra2z3oru_i2n3akce_ra3z4red_ra3z4rok_ra3z4roč_ra2z3uve_ra2z3udi_ra2z3uda_ra2z3udb_ra2z3uzi_ra2z3uzd_ra2z3uze_a2d3erac_ra2z3umr_i2n3akur_i2n3adek_pred3m2n_po3t2kav_ra3s4kak_a2b3uzus_ra3s4kin_po3t2kat_a2b3reak_a2b3orig_di2s3ton_di2s3pon_i2z3bija_i2z3biva_ra3s4koš_o3b4jesi_ra3s4paj_ra3s4pav_i2z3vedi_a2b3irit_a2b3erir_a2b3erac_a2b3evak_a2b3anac_a2b3alij_i2z3vedn_i2z3vedb_i2z3vede_ra3s4pon_ra3s4por_o2b3lakš_o2b3lask_iz4ohips_o2b3lizi_be3z4jak_ra3s4taj_ra3s4tan_ra3s4tat_ra3s4tav_i3z4rael_ra3s4til_ra3s4tir_ra3s4tis_ra3s4tit_be3z4jač_ra3s4toj_di2s3poz_i3z4rači_di2s3kur_ra3s4trt_ra3s4tup_ra3s4tur_ra3s4tuć_di2s3kri_di2s3kre_i2z3anal_u2s3treb_ra3š4čić3g2djekad_po3t2kam_u2s3tres_u2s3trep_na3t2kam_na3t2kah_na3d2nic_na3d2nič_o3t2kasm_na3d2nev_o2b3list_o2b3loka_po3t2kah_supe2r3o_o3b4ljan_o3b4ljut_u3z4vijo_u3z4viju_u3z4vija_u3z4vije_o3b4ljuz_supe2r3i_o3b4raže_u2z3inat_u2z3iskr_o3b4razi_o3b4razn_o3b4razo_o3b4razu_o3b4raza_o3b4razd_o3b4ramb_su2b3ord_o3b4ranj_i3z4bojk_u3z4neve_u2s3tral_i3s4kanj_nu2z3rje_o3b4rašč_u2s3traj_i3s4kvas_u2z3orat_u2z3orav_i3s4kvrč_i3z4vali_i3s4kita_i3z4valu_i3z4vala_i3s4kram_i3s4krit_u3z4roko_u3z4roku_u3z4roka_i3s4kriš_o3b4reti_u2z3ugar_o3b4retn_i3s4krič_i3s4kric_i3s4krat_u3s4klađ_u3s4klad_o3b4riv_i3s4kren_nu2z3bel_i3s4kroj_u4s5koko_u4s5kolu_u4s5kole_u4s5kopa_u4s5kora_u4s5kosi_u4s5kotr_i3s4krsn_i3s4krsa_u3s4palo_juri2s3p_i3z4vale_su2b3rog_i3z4vižd_su2b3rep_juri2s3k_u3s4pjeh_u3s4pjel_u3s4pjem_u3s4pjet_u3s4pjev_u3s4pješ_u3s4pent_u3s4pija_u3s4pije_inte2r3e_u2s3tvrd_o3b4ronj_u3s4pori_u3s4pora_u2s3tvrđ_u2s3tara_i3s4ljeđ_i3s4ljed_o3b4rova_a2n3opis_i3z4vija_su2b3oks_o2d3žalj_o3b4runj_raz3d2ni_i3z4vinj_po2d3vrž");
            put(10, "_u3s4prema_u3s4posob_u3s4poreč_u3s4rijed_u2s3talas3g2djegod__u3s4poren_u3s4pikuš_u3s4pijuš_u3z4rijev_u3z4rijet_raza3t2ka_u2z3obest_u3z4nevje_u3z4ludob_na3t2kasm_na3t2kast_ra3š4ćenj_ra4s5turč_ra3s4troj_ra3s4tret_ra3s4trel_ra3s4tinj_ra3s4tenj_ra3s4prem_ra3s4prav_be3z4bedn_be3z4beda_ra3s4plin_ra3s4pinj_ra3s4piku_ra3s4pete_ra3s4peta_ra3s4peto_ra3s4peti_ra3s4krop_na2d3žanj_be3z4beli_be3z4vučn_ra3s4klon_ra3s4klad_be3z4vuča_ra3s4klap_ra3s4kand_ra2z3ular_ra2z3orav_ra2z3orat_ra3z4mrsk_ra3z4vrać_ra3z4vrat_ra3z4vije_ra3z4vija_ra3z4viju_ra3z4vigo_ra3z4vest_ra3z4vede_be3z4lobn_ra2z3anal_be3z4loba_be3z4račn_proti2v3r_be3z4rača_tran3s4ud_tran3s4um_tran3s4ep_tran2s3nj_be3s4porn_be3s4pora_be3s4tvar_be3s4tija_be3s4tilu_be3s4tilj_be3s4tras_pre3t2kat_pre3t2kam_pre2d3ruč_pre2d3rad_pre2d3rač_pre2d3rat_a2n3amert_pre3t2kah_pre2d3ose_pre2d3osv_pred3m2nj_i3z4bojak_pre2d3obj_i3z4valji_i3z4vijen_su2b3junk_pre2d3izb_pre2d3igr_pre3d4jen_pre3d4vos_pre3d4vor_i3z4vitop_i3z4vojac_i3z4gomet_i3z4ježlj_pre3d4var_pre3d4vaj_po2d3upla_po2d3ruča_po2d3ručn_po2d3ruči_po2d3ranj_po2d3razu_po2d3razr_po2st3onk_po2st3lim_a2n3afrod_po2d3ravn_po2d3ljut_po2d3list_po2st3egz_i3z4lopać_iz4okolon_i3z4railj_i3s4konsk_po2d3lakt_nu2z3ljub_po2d3vris_po2d3vrać_po2d3vrat_po2d3vlaš_po2d3vlas_po2d3vinj_nu2z3bilj_o3d4rinj_o3d4rvenj_o3d4rači_o3d4raplj_i3s4krenj_o2d3i2z3v_o3d4vikav_o3b4rovc_u3s4premi_o2b3lizav_o2b3lizat_di2s3akor_di2s3junk_di2s3kval_di2s3kont_di2s3kord_o2b3leden_o2b3lijeg_o2b3lijež_o2b3lijet_di2s3orij_i3s4lijeđ_o2b3lijep_inte2r3je_di2s3prop_o2b3istin_di2s3trak_i2n3abrup_i3s4lijed_obe3s4tij_obe3s4tan_obe3z4nač_i3s4pokoj_i2n3aplik_obe3z4nan_obe3z4vij_i2n3augur_na3j4uren_na3j4esti_na3j4avlj_na2d3udar_na2d3real_na2d3rašć_na2d3rast_na2d3osje_na3d4voje_na3d4vest_na3d4vesi_i3s4polin_i3s4porav_i3s4pravi_i3s4točnj_i3s4tifan_i3s4tavlj_i3s4prava_i3s4pravk_i3s4pravn_o3b4rašn");
            put(11, "_i3s4pravlj_iz3be2z3um_u3s4porenj_obe3z4nanj_i3s4paljiv_obe3s4tran_inte3r4egn_inte3r4esi_inte3r4esn_inte3r4eso_inte3r4esu_inte3r4esa_inte3r4ese_ra3s4polož_inte3r4ije_o2b3istinj_ra3s4plinj_di2s3parit_i3s4kuplja_o2d3i2z3d_po2d3varij_po2d3lakat_po2d3lijep_i3s4kariot_po2d3lijet_po2d3lijeć_po2d3lijež_po2d3lijeg_po2st3indu_po2d3ravnj_ra3s4klopa_po2st3oper_pre3d4vest_pre3d4voji_pre3d4voja_pre3d4voje_pre2d3ispi_pre2d3isto_i3z4viiskr_pre2d3istr_pre2d3odre_be3z4bjedn_be3z4bjeda_pre2d3okus_pre2d3osje_pre2d3ubeđ_supe3r4ior_ra3s4klopi_va2n3ustav_bes4tseler_ra3s4klanj_be3s4trana_pre2d3uver_be3z4istan_be3z4isten_pre2d3ugov_pre2d3udar_pre2d3upis_ra3z4bašur_pre2d3uslo_a2n3a4e2ro_tran3s4kri_proti2v3ud_be3z4načaj_proti2v3us_proti2v3of");
            put(12, "_iz3be2z3obr_be3s4krupul_proti2v3otr_proti2v3akc_be3s4pokoja_pre2d3uvjet_pre2d3uvjer_pre2d3ubjeđ_iz3va2n3evr_ra3s4kloplj_be3s4pokojn_i3z4bleušan_po2d3ra2z3d_inte3r4ogat_inte3r4eždž_be2z3atomsk_u2z3obijest_i3z4bičkava");
            put(13, "_be2z3alkohol_pre2d3ubijeđ");
        }
    }), lv("lv", 2, 3, new HashMap<Integer, String>() {
        {
            put(3, "d4z");
            put(4, "dd4žda2ida2udi2ede2idu2idi2udo2ido2ude2uo1pīū1rēi1taū1gaē1žuū1toā1nii1rēi1čoā1buo1mīo1kāo1čiā1loe1čūo1ļāe1lai1šoo1biē1cēā1ruo1siu1noe1hāā1nēe1būi1ruo1sūa1čaā1čao1rēi1keo1rau1tei1zoi1giē1maū1ķeū1cao1dēa1nāā1gee1čiū1bēē1tāā1fii1zio1līe1šee1gāi1foa1ņou1toī1zēū1guā1šai1ķiū1nēī1maā1teē1kēū1māu1zuo1sāē1buī1gae1diī1tea1ļīe1tēi1žeo1foā1puo1huē1doo1duā1maū1mie1rei1hai1bee1luā1jaū1taa1šūa1daē1cīi1bua1pīu1ņāe1zuū1noe1nīi1noe1māē1ļaū1pāā1beā1moī1jae1jiī1ree1ceī1riī1tīū1niī1žīi1žia1fīa1bee1šāe1ķoe1pūe1ļīu1ģiē1tīa1cie1jēa1zīo1lēu1gaī1cia1kee1hoi1nūū1šīe1sie1boo1ģēu1ņiu1sēē1bāo1šaū1roē1cei1zīi1veo1ļui1dīo1kue1vēa1riu1sāi1pāi1dēo1pūī1vīa1meē1zeī1bēu1ķea1bēa1jaā1ļoa1jēe1feo1puo1toē1vēa1kio1māo1loa1loē1ķie1šēū1dīū1cāo1zoo1gūo1gāī1tēe1zēī1lee1gīī1nao1mee1poe1fua1ģeu1rūu1riū1joe1dēa1ļaa1žāī1ļaē1nea1zūā1vēe1soo1mio1šoē1sīē1ļue1gai1pēe1vuo1ruē1juu1čiā1vaa1huī1sēe1ķai1rāa1čāī1kii1tiu1cui1žuā1jou1kiu1muo1ķīe1maī1ļoē1deo1čoā1čui1ņau1ļau1māo1hei1līa1deo1faē1roo1sīā1riū1tio1bēa1jāū1zuā1vīe1ļeo1ņaī1deī1šea1kūū1jao1dīe1žie1riī1gāe1kiu1zeu1mai1vīē1pīu1lue1tio1čāa1ķiū1zēa1ļoi1čio1kea1ģui1vēu1čuu1cau1vuo1ļai1rio1ņou1coa1rāo1jāī1bie1čīē1rēe1kāi1pia1kaā1vuū1žae1mīe1vīo1gia1pēū1zāi1cēe1vao1nīī1rue1pāa1ceē1kāo1jaa1hēa1boū1muī1vei1nāi1fio1vau1žue1ģiē1nīi1lii1ņou1laī1ģee1caa1tāū1zia1būē1pēī1suī1pāī1zuū1die1loā1māe1cia1žaē1toe1rūā1lau1ķuo1ģīā1pae1lūe1sīe1bēi1coi1ķēa1šoū1kuu1šāo1dia1ņaī1pao1pia1žēa1sia1hau1šoē1māī1moā1žoū1lue1žūo1ķiā1vāa1žoi1zāa1kuo1zio1dāe1cuī1noe1zie1jūā1ņoi1ceū1lēa1žīo1mēi1bīo1ree1zūū1raa1gii1lēī1bāū1šue1bii1gūū1ķiē1vaā1tou1cea1pūā1gii1ķeā1kāe1ķīē1žau1veu1voē1noo1bua1tīe1fie1ļoū1žia1tūī1tiī1lai1hoē1gii1fūa1tēā1ķia1mie1rau1jae1meī1bui1puo1laa1ķīu1šuo1žaa1rūū1ļae1čuī1loo1nuā1jēa1dāu1rēu1rīē1žoi1māa1zoo1žuē1daī1coū1zīā1saē1šuū1poi1siu1zēū1riu1zīū1gāe1puā1due1cēē1jii1biē1rāi1ļiu1nui1kia1mūī1niā1feē1caā1ņiu1goa1nue1nēu1kuā1žiē1goe1čeē1zaā1čāi1ģeī1goa1goe1bīi1zee1šūo1kēo1pēi1naā1raā1jīo1zae1zāa1lāe1ņēa1jeē1siā1bou1gāi1sēu1šiu1bīa1vāe1koā1šuā1ģēi1moe1ļāi1tēu1ļāa1ņēu1naī1voū1mea1hīū1kaā1mīā1līū1tue1jeī1vāa1baī1dāū1koū1cēā1nīa1ļēu1juā1žāū1moi1geā1pāe1lāi1ķīa1sēe1nia1maa1tui1kūa1bii1jīī1ķue1fāu1taē1dēa1gāi1lāi1ņie1ļaē1tiā1bia1šia1līi1jae1muo1hēu1jāū1šai1sāu1poā1cāa1seo1ņeu1foā1sūā1būo1coo1ķēā1ļae1žeu1tīī1kuu1ķau1zie1doi1soo1fiē1sāi1pīī1šia1dīā1tiu1ņou1pao1kao1cīi1peī1māā1pēā1pīū1pēo1būe1ķēa1mēā1rūo1dei1ķao1šīī1guu1biā1kaā1nuu1žiu1soē1kaā1leē1peu1ļīī1meu1dīi1žāi1duē1rao1voo1fāo1soā1ļāe1dāā1guo1boe1hīā1ģiā1čoa1dēu1diī1seē1sēā1nāa1nīū1rāo1hio1šāi1lūē1lēi1teu1šeī1tuu1ģoe1šiū1bae1ņau1siē1zoū1kāi1guū1dai1sūo1bīa1moē1gāā1veu1bēe1ņoē1voī1mīu1ļuā1tui1cīu1faā1tāē1guo1gai1mii1fēi1ļeā1cou1žīi1zēi1vua1jui1caī1čuū1reē1bie1roi1fāa1heu1moi1joe1buī1roa1teī1ģiā1dii1būu1ļiu1lea1nae1tāe1bāo1tūū1zeā1fuī1bea1pāu1dei1dūe1veī1dia1vou1lāe1piu1dēē1dāo1joi1žoī1ķeo1nāe1mūā1zāa1roī1rāa1žeu1jea1tiū1cīi1tīī1viī1joe1coi1tūi1boū1pee1tūo1pāē1sea1ļāā1jia1čoe1zaā1mēa1žūe1šoī1ļuū1jāo1sue1jao1tae1līo1zeī1vēo1vāa1vīi1kīā1zīu1haī1pēi1deo1nēū1bīē1tua1žiā1žuo1ņāo1ļoi1ņēu1ciī1caū1sae1rīi1bēe1nea1šīu1giī1mua1zāi1loī1cēu1līe1čoa1bui1nīā1dāā1tēā1koī1šuo1ģia1tai1laa1vaa1šea1hia1cae1bee1žēa1suī1dīo1dae1ģoe1ņue1paī1jāe1sāa1ņiū1soī1nui1voū1loī1nēē1mīū1cuo1žēē1jāī1cāa1čuo1zūa1luā1luo1ņua1vui1tui1ķui1ķoi1koa1faī1pii1goi1mea1fie1sūī1juo1pea1sīa1nēū1žeē1vei1poo1zēa1nee1saa1lēē1šaū1giē1lāi1mūu1vāū1mīū1mēu1roā1poo1jui1fui1jēi1gaū1tāē1luū1sāa1gūā1bāa1lao1riē1šoū1ņao1fēe1liē1kou1vaī1šoa1zie1dīi1dai1šīi1hīi1nei1šuē1kue1ņāo1naī1žao1čaā1fao1tēī1dēo1tāi1hiē1muī1soe1cāā1ziī1cīu1šēo1noā1ņeu1buū1gēo1vea1ģīi1lui1pae1kaā1ciu1ķīo1sao1goi1nuī1žoi1sīo1fīa1pua1duī1ļio1bai1fae1mio1cuu1žaā1mia1ķāi1čuo1žūī1kāā1ķeu1ģēe1daē1dīī1čoū1paā1deo1mai1dāē1ņoū1žuo1koa1vēā1zēā1sāī1dou1cāī1ļāu1due1juā1sio1vēi1šau1feo1jiē1reū1ļīu1ņaā1caa1šuū1nuū1lee1ķiā1tīo1gei1vāū1zaē1nāū1maā1ķue1lēā1sēā1liī1nei1mīā1pia1māa1žui1juē1vuu1nāū1rue1via1pai1bāo1cēā1lēe1kuu1lēi1see1vāē1jēe1pīē1cio1šia1hāa1kāu1jiū1rīī1sāi1roo1rāū1kio1roe1ruo1kūē1sua1ņāū1tīā1bae1ņee1nuē1teā1voa1sae1nūū1žīo1žeū1doē1jīī1vuo1viu1baā1naī1mēa1jiu1tie1moa1rae1hio1teu1boe1sui1fīē1pii1ģiī1ņuū1līā1roo1zāa1vio1niī1zao1doī1zāo1gēu1zūu1liu1daa1čie1tai1raā1ķaa1jūī1baa1cēu1rai1kāi1zuē1nua1šāe1tou1gēū1pīa1hoā1jeī1ķaa1veo1šuu1čoī1miu1sīa1dūe1cūī1rīu1koā1ķīā1zuā1muī1saā1ņuu1kai1baū1viē1gaē1ģea1rīu1šau1cīa1coī1cuo1vui1jeu1doo1cāā1vii1jāa1zea1muo1ņie1žao1čīi1čai1mēā1cīē1lae1dūū1nīī1poē1ļiī1nāū1beu1seū1ciī1ņāī1keā1cēē1saē1lia1ģāu1peā1kua1bīu1puo1cau1neī1ļīu1mie1dui1ļuu1pāī1ņaī1puu1beo1čuo1šēū1šoē1mea1ķau1zoē1zāū1cee1tīo1ķuē1jou1tūā1cui1vie1žāa1joe1joū1biu1nīā1ļue1zoi1mau1vēo1jūo1haū1pue1šaa1rua1liu1mīū1veā1pei1cuū1nāī1sīe1peī1zīi1rīī1peo1poā1rēa1ņeī1gie1žīī1lui1suī1tāa1noī1žia1sūa1koi1žēu1joi1vaī1jia1feo1pae1rēe1šīē1cui1šāū1žāe1ģeē1cāa1poi1tāā1neī1vae1seī1rao1guū1deu1dāi1diu1rāē1nēa1toe1fīa1soe1zeē1leo1muī1tae1ļua1zēē1ķēo1ģee1naū1vēē1duu1žoi1nēī1sii1kaī1fee1noi1lee1pēe1ģēā1goi1nie1čaa1čīē1bea1šae1gii1muē1bēa1čūī1šāa1bāī1duo1ciē1boā1kio1moē1loo1lāo1lea1gīu1kāē1viī1lēu1čēē1moa1cīu1čaī1toa1fēu1ķie1faī1šao1bāa1ļiī1daa1mīi1gāa1ģēe1cīā1tai1reā1meū1dēa1reī1lia1gao1tuu1pīe1haā1ķēe1tui1ģēe1kēā1bēo1čūa1zuū1sēū1neā1gaū1voo1hoē1ļāo1rīū1juo1fuū1jio1lūā1doi1tou1bāu1geu1cēa1leu1ķēī1cea1ķuā1zee1šuē1jaa1vūi1ņāē1nao1neā1dēā1ģau1suu1saē1diū1sue1foē1niī1pīi1kuē1paē1poī1zii1ļai1šiē1līā1noa1jīā1gāo1zīā1dīo1ļiā1rāē1ziū1piē1geo1mūi1kēe1gūu1gui1zūa1gua1lūi1cāū1lāo1ķeo1seē1vāē1rua1foe1sēā1reā1lāe1ļia1ņue1jāā1žaē1zue1ņiu1piē1mēo1ņēo1tiu1pēe1zīu1fie1ķeā1jāu1vīī1ņiu1žāū1lie1deo1beē1zīe1hue1heī1lāu1tēe1nāa1sāā1seē1ļoa1ģiī1zeo1jeū1tee1kūo1liā1ceo1vīi1ciā1soe1gei1šea1nii1doā1lūo1žāo1šeo1zua1cue1mēe1guē1taa1doe1baē1ģie1žoā1gūa1zaū1laū1ķīa1piī1nīū1šāi1šēo1ļeē1miu1zāi1ķāī1koo1dūī1ķia1ķēā1suī1līe1čāē1ļeu1zao1žio1feū1tēo1kiā1zae1leē1bīa1dio1sēī1žuī1bou1mea1rēi1ļoū1siā1sīu1niī1kaā1ļio1tīā1šou1tue1žui1žao1luē1rīā1juu1šīa1ķeē1soā1daē1baē1rio1ceē1kii1ļāa1peo1šūu1ļoī1zoē1rūe1goe1tei1zae1vou1vii1fei1ņuā1zoē1zēo1jēu1reā1ņaē1pāo1žou1nēu1ņuū1dua1ļuu1mēē1puu1loi1jiā1rīī1rēe1rāu1rua1cāo1rūū1nau1ģeū1dāu1tāi1sa");
            put(5, "at1tueg1rūak1soit1deeb1lāet1vīor1bial1šaap1dūak1naum1ciaš1leēr1ķeen1kuil1kiēr1kuat1nāat1ģēus1pēos1vīos1cian1raen1paej1dēaž1vīas1buīs1gaiņ1dien1touj1meor1kiel1zoot1nēes1kouz1guak1tiīr1niiz1hiil1pues1maāt1viag1rēon1zēīb1tuap1doīt1vīul1sāīk1līur1sook1tēēb1tuīs1laet1veal1moop1šaen1ceim1nīuš1ķaek1tiiz1cīer1diur1faan1tāer1baas1peal1suip1soal1cīat1deaņ1raēk1šuīg1liom1nioņ1kaas1leat1ņiid1rīun1veal1kūin1daār1baīs1žual1kaup1jīur1guat1sīīg1māāl1tial1vauļ1kuok1rēer1giuz1ļoak1šēīm1reiz1teāt1vēēg1niīg1ruil1cēir1muar1kuot1ziub1naan1čeom1bīēg1siel1leav1ruil1nuēs1teur1kāik1roep1nuur1vēoņ1luit1mail1jaēj1tēan1gaeš1paāl1ceob1rīur1viup1riēz1tāiz1čoap1šauz1ruut1rēar1toež1nīaš1ļuaļ1ceal1neis1sīib1šouz1nuut1ņuul1deār1hoam1pūēl1guum1viik1toēr1zeož1vaez1nīam1līak1seel1koep1siāj1tuum1zāat1jaal1ķīaz1dāor1toec1heat1cīen1koūs1kiīg1saef1riār1saim1poīt1rīed1viid1sēā1džāup1laēc1tees1puuk1šoāp1niā1džiak1laen1naas1kaām1diag1liog1rāag1dāoz1vian1kuīk1nēus1mūer1maāb1šain1tuob1tiap1cues1vāac1tiur1puar1kīel1lait1taam1leik1seēk1tiar1sais1muut1ķeār1vīu1džiet1nāid1kaāl1seur1naār1zouz1liān1kaas1veab1laaņ1ķeēb1tāel1vāal1žuat1pūat1goēr1lae1dziiz1dēab1seat1žēir1caēr1suuļ1mael1peej1veap1veīg1rāel1poed1loit1moep1nāuk1tuat1šoap1šāār1čoak1sēek1tēom1peul1goum1dīec1siēd1vium1māiz1mook1zāāp1roāl1koāl1vēed1poīl1ziof1rēēj1loap1sūip1šois1puin1feep1raat1šaor1gaon1gāak1šuat1joes1pauz1šaār1suuz1beik1sīen1šaok1teok1buur1šaor1ģeīn1taap1ģiiz1zuim1tīap1teon1nāus1jūur1noab1tien1jūop1soeņ1nour1kaan1šool1leūs1moās1tāek1tīuz1sīiš1ķāum1pāis1poob1lēap1zaek1doez1mēēd1lauš1kaof1rien1hīāf1riuk1nuiz1doej1gaul1riiz1fiir1nais1kaār1doen1šoož1maēs1tīat1sāum1laoš1paeb1toez1ņiej1kaiv1žuuņ1ģuik1nail1kool1muim1siap1taos1tuus1tīat1koar1ciiļ1doun1čioš1sien1zāir1zoi1džāuz1baer1vēip1niil1zuin1pūor1hiiv1deos1mēuz1pūām1pios1tūaz1bēal1deon1deuz1ceem1baēr1ļuat1nēār1tūur1cuir1kuāv1daīp1riop1rāej1niam1dīak1vaek1piup1veūt1maun1tāaš1maāv1jaum1tiūz1māim1teev1rēon1tiig1zaiz1gūup1rāid1pūār1cīār1līel1lēus1gaez1daap1cēej1laag1dauz1vaop1sēāģ1veel1toēz1kūeš1viuz1vīī1dzeis1mēef1rīab1šaup1maār1nīaš1vaab1riob1tāik1sāis1mīag1šaūr1kaāņ1muev1nior1daem1zeāj1loat1rūal1reil1cīār1miet1maum1daob1leāp1tuel1pāiz1ķeez1tual1tīap1rūiz1taem1žaar1giēv1reas1kāaž1kāeg1taal1gāap1leap1roīv1niop1kaik1viil1tīur1pīir1kīiņ1neiz1daop1reēl1niis1nuar1cēed1sēul1kaās1maop1baos1fēak1leeļ1mūēb1šuaš1rauļ1puoķ1vāār1šoam1diār1žued1pued1veen1reūk1liuš1piep1taal1vead1maez1ceēg1tāud1rīim1biek1raiv1jūez1biiz1meuļ1tīif1rēap1kuid1niog1rēēj1deop1koiz1tīun1ciīt1kaēj1nīēr1pēoš1ļaat1zuīv1gaos1naog1gaes1luāt1koaz1vaem1zias1kean1siiz1mier1vāep1sēal1sāus1cūul1saen1taor1vēek1tāuz1žoan1mai1dzīij1kuid1laēp1taēļ1kour1tiap1nīot1reeš1ņuun1deār1vēuz1ģīer1mūo1džuoš1niij1kāal1loig1loer1rīem1puug1ļoūš1doip1šaūs1tāoš1baal1lēeš1dauļ1ļāār1sūin1deem1toās1tuol1fior1māiv1puaš1laec1hoār1zaar1kaub1sīap1ziēp1toāk1tuer1teur1zuīm1kaon1juap1gous1loor1naog1noam1dāār1taēl1neer1cāim1nauz1zāār1noaj1ciip1tāit1ļuag1riār1būos1poēņ1daan1kūom1bēār1veaļ1ģeim1tial1tiīņ1niin1naep1lauz1diiž1meal1tēin1sied1maor1tuem1taug1sier1beus1rail1muār1gaeb1loīr1rūīt1real1laet1viel1diār1žiiz1caad1daēn1mīut1saol1poez1rair1šāeg1šoud1puud1lēuk1sēon1vuem1pāēk1bēār1dēen1zūāj1reat1loez1niet1kaiv1jiin1kuor1bīok1tial1siur1zīūn1gaēr1paam1biat1roēr1buiz1ķēip1sēuz1čiir1duuh1tāer1bāik1gaīš1ķiiz1rūit1daok1ņuēg1tair1loan1kain1dīes1vīop1maum1sīon1paem1pīūk1koel1tīuz1meer1vīūz1naeg1ruit1gaus1duīt1ņuep1lāur1vaum1zīīd1līo1džiār1buak1tāer1taēr1noēr1pāum1bien1caoņ1cūēj1muat1pīēr1gāip1reār1viaļ1ķoet1niir1gūāp1neir1suāt1meeb1tuin1cēaš1ķeip1room1daep1tīef1raū1dzaēt1kuub1liaz1beūs1kaus1paar1suuf1liūr1vīīs1zaaf1rēuz1ņae1džaiz1bēūt1dien1nīeļ1ķēes1kuaz1daīg1raiz1gāar1ķīer1šuud1kaed1riop1raap1liap1dīed1laan1rīen1tīāb1šoan1cūēj1daes1tīer1koūg1tael1zuin1neer1biig1meež1niad1miaj1niel1liik1šuāl1puar1gaet1taīc1šeuz1zuom1būun1kuīb1niar1žaēt1niis1tuun1zeaš1diit1nien1zēen1ģeer1peuz1zūul1siur1caap1fais1noiz1ķīus1viin1hoog1ļuūs1nuer1gair1zeēl1reēs1liem1maif1raat1mēur1rāat1hoob1juop1roip1liec1māer1mīak1mues1saīk1lou1džēur1fiid1koār1ņuuņ1ģaīk1liiņ1ķeas1kēil1deār1kūul1boez1noen1mēab1rouz1gūek1ņuož1ņāat1kuuk1sauk1loar1doak1tuār1duik1cial1duen1peal1vīun1tiul1leos1cēec1saīk1tiār1dāēb1juap1čuub1rāiv1paos1maoš1ķeaš1puum1pēēp1tāek1siīk1ļuuļ1ķīūš1kaal1peīg1nāuz1pāāt1rāīg1nuik1luāb1tāum1jiab1soog1leir1teīb1tāil1doem1zēar1ģeot1veap1gūid1vāār1deāt1neēt1saad1doen1jaer1naēk1liiļ1ņauš1kiiz1nēoz1vaez1gous1bāut1riur1luib1reej1teok1hoen1zueb1rāem1tāed1māah1tiem1tium1sāaz1tuur1sīin1goār1diap1ņoīs1cīal1bias1niek1seal1liuk1naal1nēiz1mēer1ceūs1mual1tāul1fāēk1loaz1gaer1zāir1guig1rīen1dēeč1tuep1ļaēk1tauz1dēur1suīc1kuit1biāk1kāāp1tāeļ1ceed1rāib1rāer1miāb1rīiļ1ķior1mēem1pios1vāas1zoaf1rāež1pāūs1nēān1veeļ1ķioš1gail1žuen1vaīt1raak1riup1tuad1kaeļ1zīir1nēec1veor1muiz1mīīš1ļaab1veer1riū1dzeūz1niin1kaīķ1saud1peus1mēiz1rīon1rāaņ1kāat1zeāl1reem1jaim1sēīk1luek1vaat1bīis1lāos1pīār1jāas1māol1nīīg1tiem1poīg1tāed1vaar1daor1pous1nial1lāos1tieg1dauz1bāūt1rīag1niiņ1dēiz1zois1meat1biaz1tiog1raen1laat1doap1zīam1gaus1tioš1ķiis1tāat1laēj1tie1džāec1kaor1ķoiz1pūuļ1zier1deuk1ļueh1niēg1toēl1siēc1nāap1pāāl1noar1hāat1guob1ļaap1bouļ1ķiuk1lēes1biar1žoiv1coel1miēr1ciik1mēap1dauz1ķīim1puīk1laag1ruiz1dīer1ņaat1ņuor1piēp1niūt1ņueš1taar1taun1gaoš1ļieņ1ģian1tēat1sior1teiz1rāol1viiv1cīaš1koām1riāz1tuek1sīūk1tuēk1ļuir1sāel1kuek1suaš1ļiiļ1ņuiz1siir1giat1haar1tuem1buāt1saek1ļūen1tāiz1šuas1poir1taab1reit1leūk1piuņ1neaš1viām1paār1sēok1siog1paut1rīin1jiig1noiž1ļaēb1niuk1maēp1šuol1vēēz1taam1kāed1foāp1rair1ceul1lias1noēt1raon1taur1ņiur1biiz1cēus1kieb1šaož1mean1gīāv1jiip1siur1nēak1šaeņ1kuab1liil1vīis1kēom1pāir1mīip1līēn1māēr1šāāk1dael1nāul1peiš1ļoēj1puāl1līud1koer1viak1tēīs1kaag1tāī1dzīat1vuar1mēar1sēeb1lēod1kāūr1viot1ņuen1daaz1duāt1nāoņ1meāl1baeb1šouz1māan1zīag1līot1buil1poēr1ķaur1cāej1boaz1zeiz1žoop1ļāīg1šuēs1luat1māeg1loīt1riir1tuek1sāik1taeg1luur1vāun1bēuz1mūež1zieg1tāor1maob1gaav1koel1baā1dziat1ģiāg1neēr1zaed1rūiz1huaš1ņaāb1siuz1niet1piāz1vāu1dzien1tēāt1reūv1noum1suiz1ciat1rauz1rior1taāk1luik1poāš1ķiār1peap1ķīuz1būuz1pēuz1siir1žaan1gāap1šūi1dzeat1juat1fois1neez1rēas1gāal1guas1tiūš1koes1tāal1jēin1šaab1lei1džaēp1jaeb1ļaub1leab1tuād1miiņ1ķoā1džaek1liun1liek1mēok1līēr1piēr1puiļ1laep1kaem1liez1naid1maaž1neir1reēt1diam1zoūr1foež1gaim1toūp1nīat1duim1tāūg1šoen1sial1geal1dēeļ1ļaap1vīār1cuež1ģaiš1reār1neul1jear1mīoš1kaīn1vaēr1maok1nuom1raap1jāus1ceun1māek1šiob1lāēr1sāet1neuz1deil1boit1pāar1tēed1kool1vīot1rīus1seēt1tiiž1ļuīz1deen1sāis1laik1teob1toag1lāit1koep1ciāg1tiūs1leek1luus1māār1zeīs1tuar1kūir1deed1jūor1fīēt1liūs1māel1noid1ruij1koer1veec1laaš1moem1zouz1bēer1foeš1ķūak1līel1luib1liek1nuir1ņuaš1nāēl1gaem1nīiz1vius1teis1haon1joaz1kaās1taaš1taiz1vēer1nēuļ1vaab1lēan1žuoņ1veil1buem1paob1seem1joīv1suer1cour1toēg1vāin1ciak1ļūuz1šueņ1laūg1šuāg1tuūg1tiīt1vaer1kaol1šūiz1čuus1keur1bēāp1riak1ļaūs1kāos1vaer1zeēt1nīāj1kuen1žouļ1veis1ķeīg1siur1meur1bīon1hīan1diāj1māep1ļēaš1ņuor1viad1voaz1guuz1lūit1piak1šoap1siās1toin1team1saap1šoiz1vouz1veuļ1ņeuz1fouv1sauņ1ķauz1taug1ļuek1līok1seok1viaž1ņaoņ1saab1hāiņ1ciug1šāek1rūij1paok1veap1heut1boel1zāor1dian1goiņ1ziek1mīap1bēon1giaļ1meab1ruig1tiur1beu1džeek1viur1zeūm1vaum1muaļ1buāt1ņuom1reug1leez1taam1buat1cēēp1juez1saat1nian1meuz1noār1lēul1kāar1puiz1ruan1žieņ1ķēod1niis1naem1zāār1seat1riit1ruuš1čoil1veal1taoš1vīēr1poil1piap1pēis1ķēēr1saār1kuoļ1šeuz1piav1roog1rūīg1ņaī1dzāil1zeez1veūr1teon1dāup1daiz1nāim1diul1giaz1mēā1dzeas1lēok1ļaak1ceūn1veek1look1tāap1joēr1guil1nāiz1heuļ1ņēīt1ruīd1seak1rēāt1roat1daiz1žāol1tēūt1saas1kuīn1būīv1sior1noot1ceol1deab1paēr1peoņ1kook1naev1zeus1riip1tieķ1tuop1taīs1raer1zēof1rāur1dēot1kais1ziēk1mīiz1neag1rīon1siir1pēer1niās1vian1zaēl1gāap1duek1lāār1ņaum1paan1faār1pauļ1soar1peeš1ļaēr1vief1rāog1lait1pēin1jeut1maig1nuēr1teaz1gāāl1deār1zion1feon1maib1taat1žuit1līit1raok1beis1žēēz1maār1tier1ruaz1jaēg1lean1niaz1lēuk1niat1līeņ1maik1vīap1bear1neip1taap1žuaz1puak1raul1veis1pēež1saiv1maār1šuek1naos1laik1tēēs1laes1laat1kiiz1luur1leīd1niit1seej1maiņ1siār1lāus1vaus1ciif1teel1tauz1gaak1tūor1veiz1ceoš1kāēt1ruad1rēet1ņuik1šooz1mair1tiuz1daūm1deel1tēēz1tiit1rēaņ1veap1zāat1gaup1deās1naap1tuāp1ņuin1tēās1neap1reir1kauz1tīuz1goat1ļāad1rūir1ziīv1māer1sain1tiāb1juiv1siep1joe1dzēel1siij1žuan1duiz1tāil1lāul1bāis1cīag1viāj1rūos1loīk1lāāb1toal1nuāt1kieņ1ķīol1kūun1piec1reuz1čuul1dāen1roir1dien1čuul1joul1ceaz1vēap1jēāl1zīūš1ļoog1veag1sion1suog1caol1guār1zāig1liiš1saot1rual1vāam1tīās1teud1rāēt1kouz1jēāl1guet1meed1raat1cūol1zāuz1žāul1gāok1ļuīv1zeat1veen1guum1duo1dzīup1joap1diur1rūīv1mūūk1toiz1ņuuz1šāuļ1būez1piin1vāal1jain1veiz1buap1šuus1zeob1rāēk1meil1leēz1toīk1deēj1luar1zoec1mear1zaol1buēj1peul1teīd1paal1kien1zoiv1kaāl1teok1noa1dzeit1vaār1jūun1goiz1kou1džoup1tion1liiz1čāil1gāer1guiz1zain1giū1dzour1nium1bēed1muēk1tuār1soid1luar1meir1šiik1šaej1zaap1haīv1līas1gaeg1šuiz1bāev1juap1cear1diem1juam1boiņ1maet1siāk1tīis1daid1puiz1leet1noul1daur1tāem1gaēr1šaor1miak1kāiz1māab1vēok1piir1bēīg1tuir1sīeņ1ciiz1sāuz1heeļ1ķeeb1kāin1čear1moēp1šoeb1rūon1cūer1paīg1naus1taār1rūis1līēg1lieš1reuz1huak1reīn1dael1deum1jaak1nēob1tuek1toēr1bēir1ciih1tiov1nual1beaļ1daot1rāēr1ķēud1maāv1juik1liar1duuk1suak1sīus1leāt1būug1šaag1māēr1tāuz1nāuz1čīēs1tuiv1tūun1koer1mēor1ciun1kaīt1ciūk1niār1gāoz1tais1pief1koāš1ņaig1niur1cīaņ1ķīec1tiil1tuul1suan1joek1vāal1pouk1tīāj1niām1jaēr1liah1tuat1vēil1nēan1keas1cier1jees1nīid1guān1vaus1fiār1siēd1vaul1vāel1nieš1maun1laal1maun1duan1houl1šuel1mual1žīel1rūul1ciar1ģiat1voēr1biil1vēus1meat1liuz1muav1daēg1tuuz1ļueg1vīēb1toad1juir1moor1fēel1nīiž1ļiem1deap1paūg1šaul1buēr1muas1vieb1ļāas1piir1sūuz1vēās1nīur1zāir1boīk1dait1nīar1pael1doēr1leor1fiēt1laaļ1ļiam1bāāš1ņāus1joeļ1nieļ1nīus1jain1guig1nīed1ruuj1bios1teem1vaar1loig1luak1lāun1baiz1būam1zeis1tiit1neuz1sāep1lēiz1bīār1nēeg1laiz1duēg1dēān1zaes1loim1deat1hiar1ķiiņ1veēr1zēuz1lāir1viār1ruoš1ļuat1teat1žāun1suon1tāod1laār1ģeēs1loal1kāaš1paūz1neār1čāur1jeuļ1ķaak1ņāīr1faes1kūār1šiar1baār1šair1dīid1nīuk1dauz1žuār1vaot1raam1doiz1ģiep1līem1siāl1tain1suol1niub1ļuiz1ņeap1čael1zaob1jāuk1tēap1māal1riot1zair1dāav1niūr1muit1miog1ļūer1zaek1lēūg1teit1mēoš1ņaāk1leaļ1čūān1līe1dzāum1beet1rīek1saal1leuļ1kaiv1niēd1mēil1dīul1tiot1leat1gāiņ1sēat1caaļ1rāab1suīn1buip1rīuz1rauļ1deem1koat1čoop1vēa1džuuz1ķiir1maur1boiz1peem1tuāč1sūum1šoap1ķēāl1saas1faož1ņaem1dīūz1dael1piir1saāz1moed1roil1siīk1nauz1cuos1puag1šoiv1vaīd1viiņ1roār1čuid1neeg1puum1kouš1ķoār1kaīļ1bāak1veez1gior1laaš1pāīg1vair1šīiļ1liēr1sīum1šiīm1juub1jeep1liat1poāl1maam1bīiņ1ķiāj1raas1tūeš1tūen1teīv1maet1nīāb1puos1kuis1tēok1ļiiz1rēiz1žiel1nuiz1pāul1tāoļ1koēv1vāos1lāor1tīāb1tīaf1roēl1zīāl1ruan1šuus1tāor1doer1ciīs1riēd1raim1daar1beil1kuiz1mūit1rāup1šauz1sūus1ruir1dour1gaek1real1nāok1niek1šuob1rēir1žoār1dīeļ1maaš1ciil1paū1dzuek1šaār1moil1giuš1ņael1mūās1kaēk1šaor1ķiār1nuaz1ruās1tīim1šoum1zeīv1soūt1nīap1foag1šuil1maīc1gaēr1tues1miūs1mīīs1tiej1viuz1naon1naid1roel1mēos1peop1luēc1kaar1pāup1ciūs1maag1reūž1ņaol1gaan1taun1dial1koul1lāir1koī1dzoos1vies1lēus1maec1moiz1veaz1raāl1cuid1rāan1žaoņ1zīum1tāaf1raum1vāār1rāab1vīū1dzīi1džiēg1šuin1žaed1ņeec1tūor1neeg1maāp1jaār1šīep1reis1veol1feop1cias1teār1šūež1kuiņ1tūes1teek1taēl1cuār1naus1jēil1teāv1raāv1ceaļ1vaum1niak1niār1rēet1riu1dzīon1tuup1leam1bēin1toād1nīin1taol1maīk1buan1žāāb1maur1ķīak1viat1nuis1biol1veog1neīv1biok1luār1čīug1tiīn1raig1touļ1ģiār1maum1jīē1dzeap1rēis1nāūp1koun1siil1tāap1ņuol1beos1miig1laīl1nior1būip1ruak1cīeņ1ķaez1gīoņ1sāāz1niān1pāus1puād1neus1poīn1deāk1baā1džuur1sēat1baāp1tiūv1viah1tāut1nēem1beap1naul1paob1jeāk1ļaib1tios1veud1vien1pāāv1niiz1vāeg1roop1siap1puam1niat1taak1lies1neuv1juar1rīi1dzues1rēob1loes1liog1mauš1koan1zāig1tuan1beim1pēic1saeb1kauz1zīoš1maat1nīam1dēuļ1baār1muup1jāār1hees1mēer1haēl1diih1reop1jail1gouv1veul1puil1duaš1miāl1veār1luez1puat1soīs1caek1niēg1nāūt1roap1ķeab1puiz1nuiz1ņēēk1neež1joes1poās1noūv1niaļ1saaļ1ķīē1dzoip1noap1vāīk1tāār1čūuz1zeuz1nīon1duap1huez1nāuk1ļiul1biad1pēat1pēēr1zuuz1čāēs1toaš1gāāt1noen1vēis1beet1rūāk1tauk1tūij1niug1šuus1ķiij1veel1šuul1vēēt1rīag1ļēes1peēr1šoak1rāeļ1paec1rīez1loēk1luel1vaār1ķieļ1poam1paūt1niiš1ziid1mēuz1dūēk1laiņ1taol1tāīk1šaīt1nēiļ1jūit1tūis1paap1sāiz1soež1ģīud1rioņ1nāam1lūiz1pēak1vāal1tead1riak1gaār1bāap1rīor1bēaf1tiuz1duat1šiug1tuiv1zian1seeg1toūd1rāos1lēār1riel1gaēr1deir1tēem1ļaus1naim1doāt1veur1maur1ģiīg1niīd1koūd1raiz1vīed1rīat1jāil1moe1dzaēk1toār1ģēiļ1ņiiz1boas1roum1zoor1puar1kāik1koap1caīs1baas1vāat1mouz1puēn1gaam1bauk1šiag1toiz1ziuz1tuul1nier1līeš1ķēen1ziat1zoir1šaez1sius1soam1fīig1tāe1dzuap1kāār1roes1viag1lair1mēad1veit1dium1noap1lāin1gaop1šoa1džāer1pouz1bīun1rauk1taar1veīn1saap1viēr1ceog1lūaš1liaš1poe1džuap1muag1luor1beam1neol1diiņ1ģeit1naeļ1ņuuz1luās1meār1sīur1kuur1peep1naut1naac1dauz1leik1kaar1fiab1sier1zīār1ļuap1jaul1tuis1dian1gear1līug1tāon1soud1kāeļ1koiš1ķīum1poik1ļaūg1tuār1giēr1niet1vaap1loēr1ķīiz1tuīv1lais1juod1baaz1roūs1diup1tūūs1nīeļ1loap1bīum1taīs1tīeb1rīuš1ķēep1tūeb1līor1žeup1raēt1maak1roir1laat1čiog1luūs1kuut1rāil1noec1dean1bāaz1viān1gaēj1ceeļ1veer1ziel1saīk1taīt1rāār1feum1kair1siag1ļiip1kaak1šāar1kiek1ļāar1bāed1daos1leiv1jaiv1kāūk1šouļ1vēēk1tāoš1ņuog1deok1ļoul1dēik1saam1pēūs1noum1tous1čuod1kaas1loop1mīup1tooļ1tiū1dziīr1maos1kāal1dīok1vael1tuap1piis1caos1ceāl1viir1miuš1ķioz1tāis1teig1šaat1rāar1žuos1kūim1šaār1toum1boan1saaļ1ļaēk1diāj1kaak1tīar1tīos1tāeg1reim1saul1sīag1meil1lēon1ceiz1jāiž1cior1kuaz1noim1pāof1seop1ļēāl1kaēs1tioņ1deer1laār1ņēuz1kuab1piar1naem1šaer1kuim1pein1tīes1mīīv1douz1mouš1miak1lēaļ1laup1lāok1taūv1meem1žēāl1rūis1pāar1leeš1vaeņ1rāad1neon1kuīs1siab1dail1luar1vaan1koez1bēež1liil1gaat1tāiz1kūar1nuir1māad1jeik1raan1buop1riik1vāek1šēap1ruuz1ņiiz1beat1viit1rour1tēen1poap1jūiz1ģīol1rāar1goah1loim1paī1dzius1luir1žuat1cuam1viag1tiim1juep1ļāec1gaon1diān1kāis1fuat1ņēāņ1tiat1čūaz1paik1paov1boad1sier1lūir1bāum1tuuj1koež1vīab1loūk1laos1paul1toap1žēāv1maez1zoeg1māap1toiz1kuos1luor1vāok1rīos1toal1diis1luē1dziāt1liaļ1lian1čueb1laeņ1ķoak1rūen1riez1beēr1nēeļ1ņāab1rūun1saiz1zīaž1daūv1soaš1ķīit1kāap1buē1dzēa1džoīb1šuus1lāad1reej1leek1roat1suap1ļuež1cier1raez1vēaļ1koog1reur1jaer1zuār1meav1tīon1tēat1fiir1biob1liuz1jūaš1ļaāb1raur1bāap1nual1ģian1vīon1dēep1tēez1deum1deup1juīg1teod1deok1sāat1jēār1zuum1dieš1dieļ1moiz1dein1gāač1gāip1seiš1ķēūn1zeāk1toeš1vīēņ1veap1laoņ1niim1niut1roet1deep1paaš1reup1jaus1piuj1laāt1tiop1lean1nuēj1māas1lāam1miaz1dēam1poīk1piūk1tāār1goap1mauf1raīg1taad1caār1ķēek1voam1teiz1zāar1keēr1māen1dāeg1līat1ciur1ciāg1laaf1riīk1zeer1cuad1vael1ciep1noag1neār1zīeg1rāeš1ķīan1tiiļ1dāud1muāl1liub1veuz1peuš1ķueļ1tēor1čēog1pueg1nēop1laal1dūef1rēīt1niek1nāāz1beer1tier1noos1foēr1gaat1kaer1goor1ķeer1moun1daan1žoez1mief1paek1rīūp1lieļ1teār1tāot1riud1lius1zāas1tēiv1dais1koil1zaīg1touz1buer1tēap1sues1ziu1džuuk1liiz1lūit1tiīk1kāes1pīuz1vuūž1diūs1liāl1pook1reāk1ļiīž1meeš1ķaat1ķeāt1rīiņ1šiap1gaum1jāīm1jaez1roiz1jēes1sūeš1vāog1riār1loal1soiz1līis1kāep1tieg1biār1laar1voēp1siār1gūeļ1gauz1kūiļ1leo1dzean1sēat1nook1maal1saek1riep1leen1rīeš1deez1jūik1sēal1giep1roīv1ciid1pooņ1piod1raej1puir1goel1main1seet1saīb1šaaļ1ķaol1laat1rīat1dēīļ1siār1ņour1miep1loāg1šoec1toob1veup1tāāt1raos1koal1ziel1duiz1vuār1piat1šāul1tūil1dēap1mīar1lēer1tāus1muis1huoņ1siāz1veīp1neāz1toiš1maol1vāem1zīāl1beal1šous1koes1gain1faāj1viat1diat1žiap1bāah1taēr1nāel1meīs1leiz1jaēb1ties1kaul1beep1riež1zīot1vēas1laat1ruer1māed1reēj1maav1ciak1dous1nēeš1gaap1cīāt1zīas1paāk1šaes1taib1loer1ģiēr1mīeļ1diat1lāak1teaš1vīog1lial1gaaš1kīār1fies1toūt1paon1koār1ciām1juel1ceīs1tāec1nial1kuat1huer1feār1mēēr1mūul1dion1gaār1pēar1pēās1nāam1fiāt1pean1cooš1ņoeļ1ņiaš1noīr1naāk1šoet1koig1maan1tean1bae1dzīek1šoum1buir1gāom1leūm1veal1naiz1vaog1lāūk1tail1souz1mail1šaoš1ķūat1zīās1moēr1naūž1ņoum1nīeg1vial1tūon1seiz1žaek1teep1lūep1seos1tīas1taār1beiz1šaoš1ķoāg1riīv1kuāt1naaš1ķiēr1dēir1tāak1saas1toaz1jūun1meap1pūep1tour1veen1maēc1naeņ1ķuār1leum1ziuz1cēez1paos1kaab1rīer1ģēet1raīt1naap1čīok1rieš1peiž1mais1šaāz1ģeon1dīep1tāam1ziīg1loiv1reat1luāl1ciez1vāiz1tial1māug1liil1biiļ1ķuaš1ņāiv1baik1šiīk1meap1kūun1giuk1nāal1voup1looz1vēēj1kaap1rāad1liuz1juel1paen1liat1čuīk1būat1dāup1taiļ1ņoar1pīak1vēēc1gaeb1neaf1liol1kaez1foin1kian1giak1loup1siej1vaag1tuek1ļoiž1vīas1ziir1līen1duuz1tāif1loeļ1ļoob1līum1sūon1cian1dees1līēb1siib1tāil1dauķ1kouk1šaāj1peej1buūv1kaar1faoz1veīk1rāup1māūs1toir1nīag1looņ1raiz1sūīg1cean1dūiņ1vīe1džoār1daīn1māār1juer1voar1sei1dzēiļ1piit1puur1said1daiš1koeš1ķoār1poev1kāīk1rūos1riik1noār1tuur1kooz1tuom1piar1šēon1nuuņ1ģiur1šuab1rēīr1kūen1cēem1jeap1vaav1ļaaļ1biuz1hiin1čaon1fuār1sāoš1mīuz1rīil1kaun1tēas1miiz1gaār1māāk1tāik1loim1pior1paaš1roum1mēīn1teež1rūab1sauz1mēa1dzaas1saun1gāag1mīeš1mīeg1šaak1ruēt1rior1seus1noit1māuz1poin1čoiz1suis1touk1viir1toum1juuļ1sūin1dāum1tēar1šoīk1koer1meuk1siīv1piēr1mēas1tīin1kāen1zaal1buor1ģia1dzīen1saīs1taeļ1deū1dzēuk1tāec1viūk1leap1čoēd1niān1ceif1tuīk1diāl1vaap1guen1dear1deap1mūon1tees1daud1ciat1seūp1niin1haap1deal1ciir1puum1vaok1tuug1līaņ1daep1šael1suīk1sieņ1ģeaļ1fier1siop1juod1leīt1paak1nāap1nēar1dīek1zēat1ziāt1kaāl1mēem1zaum1puap1žoēj1sūen1leiz1lēer1zoum1dāur1žueh1noab1kaīs1vēīb1šoas1seul1lēir1kiat1čauļ1ķeāz1maip1nuar1nīīg1līad1raez1tiīk1raūr1ziap1vuib1laīt1kāiļ1daēl1koob1lao1dzaep1nīes1riup1jieļ1kuik1vees1vēer1loum1doik1lāem1žois1soom1juij1kaen1niāz1neīv1diif1toun1jeer1daen1kāūt1raen1geāp1jioņ1kāal1viēr1zāen1gaīr1kuar1teup1rīor1tiar1ķēel1līiš1laan1noec1piēk1šoan1daāp1šuiļ1ruež1līed1rēed1kaat1kūīb1siež1ņaam1vaun1dīār1nāal1meuļ1zees1tēāj1baāp1šoap1poen1zīer1sīig1roat1buum1sēel1cēās1niar1pūod1veoz1gain1douz1miun1mēuz1kaig1neet1paol1siab1raon1toos1kīaš1ķaiz1seīn1pieb1rues1nuūt1ruik1rias1luiz1lauz1ciat1tēon1daāp1šaēp1neor1ceep1rāūr1māež1vāup1jēeh1loīg1ņāus1liec1tēāt1māak1nuu1dzēez1near1dēēk1daet1nēež1roir1kūap1lūīs1tēus1baēj1zoī1dzuat1leēg1naep1tui1dzaaf1taep1deīļ1veod1roum1šāen1seeņ1raas1tuat1pueļ1daāb1baiš1ķaāg1šail1bāūš1tuud1saat1ģeum1šuaš1māen1soeg1baam1reud1roov1naik1reār1rīār1niež1rai1dzoīs1toan1šear1juiz1ģēaz1dūēr1meoņ1gaēr1tēid1moīs1fiat1mīal1seil1haep1jail1ceof1raum1piuz1rēaš1ņoel1žaap1ņēar1buiņ1reij1puer1žool1taez1vaaļ1ķiil1nīag1noul1līib1riāt1rium1pīūg1tāis1fēak1sual1toel1žuap1ģēiv1gaal1zaaļ1dēēr1siār1ņiet1rāaļ1ņium1zuūg1siaz1māin1koīg1riil1šuer1vauz1tūec1cīīs1lia1džiu1dzāam1žuuz1fiiz1nīir1dēev1gaiz1čaiz1puup1šuiz1guin1ceuz1dīāb1šuor1bai1dzāa1dzoes1tuāz1tiel1māap1voub1lēaš1ķēīs1vien1joas1kiik1tīok1leur1ķuin1gīek1ļuuz1touk1leir1buāg1touz1neas1koek1rēur1doob1taār1jouk1noot1līur1teuz1reat1maat1žoēd1neat1naus1kaal1vuib1šuiz1dūug1kouz1voat1zāeg1zīūš1gail1niuz1roel1puūg1toos1māul1maas1maal1niut1raug1šēat1sēin1foeļ1būuz1jāēt1vaēk1baik1diīg1leop1neur1vīār1dūir1cēēr1sēas1jaes1moil1ciaz1liem1šuap1luer1nāot1rūuz1čoas1dēos1moaļ1gaun1teat1neom1baok1raen1vāap1sēan1dēol1dēap1ļaek1sēad1soiz1pouz1līīk1neud1rauz1kour1taep1šoud1miār1kieļ1viūk1tiīg1roiņ1tiur1dueg1tuār1boes1muar1ceos1kiiz1tēev1māān1koer1geē1dzīen1baīv1baot1muēb1taīn1rūūk1ņaop1jois1loob1ruur1liēs1leur1lāēj1rāul1koāg1tāiv1kuām1gao1dzēī1dzēir1zaip1rāat1tūiv1viop1lūāp1siem1meap1žāār1mūik1šāil1baan1zeon1doil1heek1ļael1nēāk1reuk1seēr1soef1reūt1rāip1tuam1pāak1ņuat1meūr1maik1tāam1puaz1deen1kiiv1moar1geīb1tiuj1maos1taas1naēs1maom1boeb1rēer1žaāt1nuež1kouz1tēup1niig1nāan1naaz1kuon1tīar1sīek1tūeņ1meos1vēak1šīat1rēer1bueļ1ņaog1roīt1līij1roūk1siār1žāap1dāuz1paek1ļiiz1tūaš1ķoim1taik1nāat1jūēg1noā1dzēem1teer1ģeāš1ņieļ1taap1līul1lauz1biīt1diud1bāen1tuun1neuk1soīv1tiol1jeed1liiz1niēr1šueb1siēv1zeuz1zaer1neom1paec1kāin1sauz1žaūs1taap1ļāūv1gaiv1riaļ1baob1šair1zīaš1mēāt1ruaz1saiš1ķiok1nāor1moiļ1ļaiņ1ruuz1gāuz1vāit1riom1deis1cēis1miop1gaat1čīar1nēuz1hoat1bāir1žiel1fiir1near1dāuz1faap1kiur1dāāl1zeār1lior1buap1tium1gaek1ņaal1pius1faār1vouz1ģie1džiig1nēuz1teot1vaag1ļuos1pāīk1ņāīk1šue1dzeiš1jāek1veat1ļaāl1sior1zāul1loab1vaaņ1ķiār1ķeur1voap1zeem1nioš1ņāūž1zaēr1cēap1hiek1nīuz1ņein1tāun1cēib1lāīr1gais1kuuz1zoug1šiam1zāas1meun1dāak1sāit1ļaur1nīuz1ņēēz1tuab1tāār1šāus1saīg1šoeņ1caop1loāp1toel1mīeč1zieg1kual1pēik1rīal1vēit1ļoem1mēiz1bais1dāīd1mēen1veap1juol1koag1leap1tēāt1nīāv1vaet1soan1hieš1kāir1šues1lāos1meis1tīur1neet1nuap1miūz1maor1mīas1zaan1cēes1nial1faēr1bour1ģeāg1siis1deīs1saat1miēš1ļaūg1daūs1nāār1raun1kāok1liē1dzūēg1nual1boop1daet1ķīur1piār1puok1sīit1ļiap1saip1ciar1šaav1maec1vāiv1doūs1tiat1dīār1žēam1naak1ļāiņ1meuz1haar1mieļ1ļiēp1tuof1toag1rāil1zīēg1šoil1sēis1baap1koug1šoot1māiž1niār1tēat1šuep1šuuz1ģēag1lūup1luām1gāar1šīit1veak1mauž1puuk1teuz1loik1ceeļ1rīet1naāl1raoz1tiiz1zeap1zoir1nāad1leēt1hoad1moun1taa1dziaz1koāl1pauz1nēug1maen1diiz1šūag1rūīr1raas1pēok1ceen1cīil1māop1sual1šuof1liev1maab1ļāa1dzēud1ruir1zāod1biol1dāap1ciil1dāok1pean1kias1vīod1ruur1pāāj1gaēr1daep1juiz1reiņ1kaār1mīat1lēir1sēiš1ļaēg1šaāš1ņuar1gāav1laaļ1niiz1foil1laer1muup1šois1maāl1sāap1ļēur1dīas1tāul1tēes1cēud1līon1veuz1ģeek1meāš1ņoek1laāl1gaiz1dion1voer1tīon1jauļ1žoār1foak1rīev1biij1cieš1raum1joaz1meim1šuaš1daor1tēuz1rāār1vual1bain1geab1naan1ciīs1lāil1šāam1zaal1joek1leim1dāiņ1deoļ1vaiž1raam1mēok1rāer1leok1vēok1rūuz1ķēeb1tiāv1laa1džaiz1ļuon1kauz1doār1ķīē1dzāan1nāāģ1zouz1čaīt1biam1daat1kāēj1koul1duop1lāuk1šāik1nuoh1roat1tieļ1dāit1liuļ1ļaūs1miat1heat1toec1paaņ1paom1buig1tīap1meer1soan1tuon1fiaš1niīv1jaoņ1mail1rūap1peem1diār1pīer1žuit1rīal1tuiz1kāan1guim1tuan1vaīn1dāel1tiap1sīēr1beez1gaēt1kius1tēīn1koel1zeab1līar1tāaš1ķūen1viil1faik1tieg1riet1vāus1mium1teeb1joeļ1ģiar1haal1miig1lāek1vēis1leeg1rēel1tāap1ģeiz1rier1toug1toel1loār1lūel1sīel1fīoņ1dain1dueg1siub1ļoun1zēar1bīiz1juap1nāat1ceej1daam1vīeņ1ķioš1ļāij1meob1rae1džeap1pīam1piīķ1maop1teuz1cīoņ1teat1vāap1ņiuk1lāir1soak1meip1loik1caap1fioj1neiz1paok1took1cien1muip1nīol1zaār1ģiāk1ļuēr1toāl1šāef1leas1liar1soas1mīat1reīs1coar1nāug1tais1taeg1ļuām1niēg1tieļ1rio1dziop1lēip1nāoš1ķēap1būim1nāir1gēīg1vāēr1nuāk1siel1moiz1ņiap1mēal1paol1tiun1vēos1mīāk1lias1pāēr1ķuul1tīij1tiim1faūs1nium1baum1meal1dāus1toiž1ceit1cīor1ņaad1rīur1baus1vāu1dzeoš1daok1mīež1ģief1liir1kāuk1tiuz1dāēr1ģeīg1tēūs1teis1viil1tieš1ļāik1meor1deod1vaur1ziiz1čiuk1nīaz1mauz1jaāb1joat1faev1riiz1joīs1pau1džaod1koeb1rois1liat1muat1saub1riab1meēļ1niār1huik1tuok1saem1dēab1lāum1saog1lēāg1taez1liob1ļāad1paig1naor1sāir1daan1sīam1muul1doār1čiuz1viol1hoem1zuut1niel1šouļ1viīk1šois1lēuz1sair1gīež1vaīb1neīd1lait1viēk1veis1saem1peēj1said1raol1dail1cauv1reār1tīar1būap1moil1žaa1dzuap1seub1lāas1pīer1tuīc1niip1raog1loib1luel1nauļ1niak1sian1šiēr1zier1keam1kaon1zaār1bēud1niak1haus1moār1ņeat1dūiz1žuām1maaj1muuz1čūaņ1ģiiz1hoēj1niir1niek1tuās1kuel1žoiz1ģeēr1ķiēr1seīr1sēiz1naob1roal1goum1siop1ļaur1tuor1tāul1cēiš1ķoad1roit1čeil1viuz1seoh1lood1neiļ1raīg1noap1nioz1niil1meur1daāt1doar1hein1tūul1fīus1guul1cīal1bāib1rair1gaul1guān1riil1guab1peop1toil1ziis1ķiuv1cīap1tāaž1reiz1pīud1beek1neab1ļaiz1kiar1māiļ1ķeok1roig1šuat1boār1pūīb1tauz1kāiz1bium1maor1koan1vāes1leis1ciop1mēām1puir1baos1tēig1rēok1daīk1leel1teek1ruok1māob1jaar1guiz1ķior1gāij1jūis1māūk1nēal1ceēs1tāur1laīv1bēar1boaž1viiz1liom1fiar1niār1cēuņ1niir1pāuk1šuin1fuop1ļoon1mēēš1laūm1juon1meis1jaāl1daāj1puel1ziēr1koīs1tūāb1tait1reēr1taik1neaņ1ģēes1nauš1ķīēk1sūāp1joār1jaop1liib1rēoš1ķaag1taob1jook1lēul1kuip1tear1cīār1teīg1šauz1kiās1laet1roās1tiar1tiiz1saāk1ziuz1sēem1šook1soet1zear1žīoš1viap1riad1ruu1dzoāp1nēat1zaūr1liiv1laor1vaūv1beep1nieņ1sāūr1vēāz1tāēb1šoev1lūib1kāīt1daum1šaug1saik1daak1luēr1ļaos1muīņ1laif1rāoņ1tūeg1neis1mouz1šūon1tūob1šoin1vaeg1lūir1piu1dzaus1laūs1puib1toiz1sēap1čūok1lāuv1muīk1saāķ1veiz1muuz1mīuļ1ķoar1hīēl1meīg1meag1veur1vuār1haed1niāt1seat1ņaat1sūūk1šuol1meūz1mēip1toat1tīēs1taus1veiņ1puol1vain1šiāp1taar1koēk1siel1zīer1nuaz1piār1bīuk1laek1ņier1roēt1bial1dais1peīk1muēc1puin1dēūr1vees1tūēr1miez1koār1koāl1lēep1teār1rean1ceod1kuig1ruīk1tuēž1veap1noul1gael1veat1ņeār1pāop1buiv1tiiz1dāig1raij1vaēr1diiz1louz1boās1nuel1ņaus1neev1geab1diuz1joār1kāeb1reir1nuop1tāil1liuz1pīāj1doēg1tīul1reeļ1ķīej1nīav1ļuaļ1ņuūs1gaim1foab1taut1neiš1ķuez1nuor1sēep1ļuūt1siik1leis1gaoz1toop1tiur1šoil1kāim1duēr1baiz1noar1jeam1duul1luot1nieš1siat1paab1toip1zāūs1tīat1mūī1dzaim1boop1tuak1taes1veīk1maūk1šain1diuz1žiiz1čīad1viam1šāiņ1ņaār1ceēd1maik1niap1tīap1zuep1sīam1peuz1lēiņ1ģiuņ1ķiur1paeb1raeš1meāt1nior1meuč1kaar1vien1gāar1šiuz1laes1kāuk1ņīap1gāer1vues1nāir1šoiz1sīat1gūar1maef1roeš1ķion1nīap1hoez1zioņ1reur1nuam1beek1nois1jēāž1niag1lēek1ciel1daes1piož1vīoņ1māil1pāok1laas1līen1zeām1viir1beik1līe1dzouz1tiul1taār1guan1soik1sieņ1zeiv1juag1nāār1biib1šaor1foūr1zāap1ņaap1jiēr1līu1dzuen1rāiņ1paat1ķīār1vāap1ļoār1caek1šāēr1kaīz1daus1diīk1toop1saiv1koāb1tiil1joiz1rair1seuļ1paiz1ņaār1faos1liez1maar1sioš1taeh1roaž1dier1sāep1sael1jeāt1ceek1lūan1dāig1rāis1zaok1rueš1ļiāj1muot1rēel1kaur1čūeb1šuuz1žūeg1veuz1ņuob1riap1biiž1gaav1vaūs1naēj1raiņ1nieg1tīuš1paag1maur1ķēon1goēr1neīž1niir1ģeas1kūēr1cīel1šaēr1nīāk1ties1māap1dēīn1meig1šoes1kiot1neab1rāab1teib1rīir1poaz1doen1sīaz1nīer1boal1bīib1lēaš1haes1vaet1ruez1jēid1gail1tēon1kiil1naur1gooņ1paur1līod1piīb1toiņ1vaad1niev1kaar1laāb1tuat1vīer1suus1kuiv1vēiņ1zaor1nīan1doūt1neom1bian1toel1dēuļ1sēel1jēil1čaās1lēas1puuz1suuš1kuom1poul1bēēc1mēeņ1koīv1zāeg1leis1ceis1niod1rāom1naul1miāk1ļoig1muir1meeg1raeb1taal1muis1kiin1joīn1vief1lāēj1caar1hiul1baom1jaan1kāam1būop1tēol1loam1māat1ķiad1hēot1maem1līāl1leas1mēūr1gaik1laum1soan1dīus1līūr1tain1žeip1riej1seul1kieg1buil1šoat1peat1čāap1lēeg1lāīs1reēr1veek1caap1soēr1moāz1taor1tūāk1šuem1ciok1neēd1nīes1tiil1peip1naik1vaos1līiz1šāod1riob1rūun1vaeb1kuil1toir1tīuk1roiz1cuāž1raur1dieb1juul1soīs1loēj1čūin1fiur1zail1vaiz1faal1doib1siēr1bāos1nioš1reim1baig1siūr1fiec1puak1toel1soek1rāīs1vaaš1mīen1tien1pueb1riam1maes1meūn1viak1ciēp1šaeš1niel1viov1kaēz1doiz1lāen1tūen1suur1nāot1roob1reep1žoat1ķēēp1tien1ciat1bēuk1toāg1šuil1mēār1žois1vaēt1ceun1roeg1meon1būah1roād1reor1niuģ1niuz1souz1rūīs1kāīs1puar1šuar1sāel1buil1taur1ķiak1neap1vēār1čaav1veos1pēaļ1raeš1ķeur1zoas1vauk1čiar1piuk1raur1mēez1seal1pīum1zaīs1deaļ1ruuk1koeb1leul1juāt1zeat1būez1viat1šūag1raāt1kāīs1teiz1jūeš1ņour1coar1biūs1tuit1kaen1sēeš1ņaag1roaļ1siid1riit1noež1maos1piev1tiēk1piap1tūus1mīel1hiiz1haeš1ļuām1vāun1guā1dzīāl1nīeb1liod1reāk1laab1ziaf1niād1niig1riek1gauļ1muon1vaīv1koum1raat1pāub1ļaer1nīug1ļiaš1keēr1tīap1baod1jook1ļūus1tuuz1ķeih1taiņ1gaēp1joun1ceil1šiīt1neoš1ķīig1taol1līūk1gaes1pēet1boez1diap1ķiuz1caig1māor1ķaez1toāp1juēk1nīat1ļues1sēir1paap1raup1liul1dīē1dzaek1sool1zīēr1coor1kaad1jaen1raez1baiz1goen1hāez1kaet1reah1veil1pīep1lueg1tiim1fāih1nīēr1dīap1čāēj1vian1tīeņ1tuut1ruēj1tāur1buur1dees1noam1pīun1vāiž1kuuk1luun1būun1tuis1nīub1ļiap1čiūd1rien1līes1pāiz1čūob1jiez1tāem1žuop1līab1luod1rīāj1sauk1cian1žēūt1riun1dēeg1gāur1pūil1diiķ1veeņ1kaan1tūāv1viīt1roiz1roāl1dii1dziad1rāap1neat1vaiz1maūv1koūt1nēaž1vaān1sauz1zias1vēet1vēiļ1buaš1vāap1kaiz1pier1šaed1naim1dēag1nēāj1buād1veeb1tāus1pūīt1saap1žiūr1niog1ļaāt1nēel1vēet1laog1ruiz1kaal1sīir1zuom1foeļ1jūil1bīil1sauņ1ģīej1saor1nēam1taul1šoor1pēem1duur1loat1beur1siēr1tier1šoat1pior1loev1naec1riol1baiņ1kāār1hios1fāat1lūog1niaš1saeg1liij1deeļ1mā1portap1au");
            put(6, "il1nsair1ptiiz1šķoēl1mjuuz1glāap1slāop1skaek1špēal1truiz1smēēr1ktaus1kriil1bsiul1griap1skuat1frēis1pruat1frium1pjaār1brāos1tgaas1preār1sveūm1tveār1brīuz1fraiz1druēr1ptuun1dzāut1skaīk1šķoāb1stiiz1hloēr1šļoap1groat1šmīun1spues1troap1blēet1rkaus1griat1plāon1steap1šķīel1dzeab1sceat1kļaiz1prāug1šdeon1fliat1stuim1šteir1ktaar1bnīer1dzīen1drook1snīuk1šķaeš1bļoīt1ņmēet1rdeir1mbāaz1gruin1grāuk1skaap1spoāg1stiug1špaal1kvaez1tnean1gliudz1baūk1sliat1smaap1fraiķ1skāuz1smaīp1slail1stuiz1graos1krēam1stiuz1preez1glaīdz1jūus1trāiz1plaiļ1krāēr1zkaap1proir1snoir1smoir1mmeer1dzeān1prāap1bruēg1stoas1braek1šneēr1bšoedž1lias1truun1draāl1proār1grēēr1stāar1ptaīk1stuez1spēam1skāir1kļoon1gruiz1štaāļ1dziāl1štāīs1prour1dzuir1stīār1šļauz1gruel1pšual1frīek1šgair1mdīek1skuiz1spuuz1plūāk1slaiz1drein1ssūuz1gleom1preār1gtiudz1cīiš1brūuz1kruuz1sliuz1klāat1bleīdz1niiz1smīār1sniīs1spaiz1preīg1skoiz1žvair1gtiēr1btaīt1praat1glaas1dziap1skūuk1šķeat1dzīuz1štauk1lvaat1dzēār1šmaes1prāiz1bloal1stiat1zviin1dzouz1krēat1kvēan1brūur1ksiuz1stīop1stain1stion1stiuz1pliat1kveas1krēin1sdaan1smiap1stuus1tpuuz1kņuār1bloon1gliar1pliap1šļaus1kreāk1šķual1vjaiz1sniap1plauz1brāiz1brēeš1stūiz1svāēr1kšaug1staat1bloap1šviil1dnoiz1glūir1sdiim1proār1treiz1briāl1braat1briuk1stēiz1brūat1plēil1bšour1dzaik1lpaāt1rrauk1stiur1kšaen1džoār1svāap1krāīk1šķiat1rreiņ1zvaat1žvīār1blīēr1staār1smiiz1šmīug1šnaiz1skāuz1trīap1svīis1prāek1staat1slaat1trūāk1slīuz1knail1dviār1dziuz1šņuis1treiz1sviap1driel1dmēul1gtoan1tziis1kvīuz1kļūār1šņouz1frēib1stoig1stain1ktīir1snien1sneem1pjoēr1btuīn1skāēk1šņoik1smēes1trīat1šķūat1plain1gtoot1rdial1cvium1briuz1šviis1glīan1džūap1sleuz1pļēap1šķeiz1bleap1šņair1mreen1traār1traul1snēiz1spaep1stiūt1sgaāg1stoīb1staap1pļāat1kleil1gtuiz1spiam1traan1frauz1frāēr1nvauz1stūūk1stoat1šmaum1šziug1stāat1špail1ktiīp1sleiz1trios1troel1pšoav1staak1tdaik1snuiz1stūok1triap1gveop1spēiz1prael1ptāes1traiz1kniān1spēos1kvaol1steul1dzoek1šzouz1steuz1brīin1skāār1švīil1nvēūv1proiz1šļuev1skien1zdaāt1rdaēk1šķuig1stoēr1kšuēr1ktāiz1skūan1kreiz1proil1spial1ktook1zvēap1zvaār1zvēun1tniak1stias1triīb1spēos1mveen1sžuel1nruer1csauz1zvial1vtuat1dzium1krūot1frīap1klīan1skoel1dkoan1tkāap1glaīk1šņaār1gveil1dbaes1tmauz1stiat1drūul1ptouk1smias1trēer1troīb1stiid1spaat1trāar1pnaat1staek1trīat1šņoat1zveig1zdair1mpaak1tniir1kšoār1ploār1prāil1ntiom1svaēr1bjail1trāal1ktaiz1dzaiz1šmaat1dzaiz1kriol1skāen1tniet1stiat1truiz1špaur1kneīg1znaul1svaan1tzaār1tņuīn1krūuz1šņoek1tkāat1plūil1kniuz1žņaur1sliiz1treap1stīor1ddaur1graat1glāās1tniuz1žmiat1dzeāl1stiēr1slīel1nzeāk1steop1plaat1prāup1stoem1plāib1stīup1stiār1špaēj1plaār1hloap1frēil1ktoal1dzion1triar1gsēiz1frēap1broul1tneim1stīug1špēem1ptaat1grūas1tmaīk1steiņ1krūil1kšuek1skais1tviār1droiz1trous1smēel1ztaēr1psiāk1smeēs1tneār1grūok1griup1stēok1skoet1rroun1dzeap1trīuk1šķuin1srien1triāj1dzīap1friet1rpauz1kluik1smeār1draiz1kviēr1ptoat1plīod1praat1gluap1fliuz1griat1krīīk1stēoš1prāan1frēap1svail1btaek1smēār1šruus1tmāīk1smīal1dķios1trīin1ssēal1tgair1mkāap1zviūg1stoem1pliuz1bleon1speat1spāār1skoap1trāek1šliāl1skāiv1proar1krēiz1trauz1triuk1steir1klīap1knaer1spēik1šķaak1šķour1gšoal1dgaap1klaap1svēin1triim1tgain1šķiēr1bkaēr1stiat1skaāb1sleap1slīiz1slāan1gļuir1msāēr1pšaor1tlīiz1driun1ktael1dzīem1ztuen1ksiār1knaun1ktoap1kluat1traat1brāat1žvaan1kroap1smeūg1stiar1tmāin1gtiār1stiik1stēom1bveap1skoār1pleīk1smiug1sneap1krēen1skāen1szīāk1snees1preēr1ķtiāl1smaīr1skaat1slīus1krēus1skael1ptaen1ktoar1bgaār1trueņ1krūen1trēār1spuen1spual1ktāik1stiem1ztiāt1stāal1kciap1kļūel1nsiēr1nruir1dzaār1klīat1treil1dmaīk1plaap1sniel1kmeel1nbāak1smēāb1stoun1drāuz1gluuz1skaen1slīan1sliēr1sbaun1droel1ztouz1trāuz1spāap1dzēap1druin1dzeed1grieļ1blāan1kcios1krūiz1spāan1krūir1srait1skoir1msoun1ktīiz1slīer1ztoet1praur1traal1tmeiz1sluil1gtiiz1greek1šķīop1svauz1truar1ppain1dzēab1dziur1tniuz1briab1stuin1grauz1svaiz1krēap1dziug1šteum1bruat1droir1stiur1stiāl1skoat1kluen1kšout1skāil1pšuur1gšuar1knāap1knuim1braēk1stuiz1knāil1btoāp1slius1truak1šņoap1prāir1dzoen1krāār1spēar1kroiz1droār1brail1dnīel1dbaal1briuz1brēot1griat1tvēur1smeuz1šļaek1šteat1šņaen1sroāk1sloan1žsauz1plīan1trail1bšail1tnius1glāur1gtiīg1stuar1zvaol1lmēiz1kvear1glīin1kruap1kņuir1pšuec1skāar1dziod1ršual1tmauz1sleeg1spaap1šļiek1šķouz1spoar1ktoiz1zviuz1šķoil1trēor1treim1šļaiz1blēel1gtiuz1slēār1spoal1dkauz1breis1tzoim1fvaaz1praap1plīaš1kriir1pjiuz1šļuiz1slaem1ztour1krial1tnaer1dzien1ktiat1pļēēr1sloar1gtoūk1šķiin1dzues1pļaoņ1priuz1bļāus1troij1skāār1fraiz1truog1dziij1speij1stūuk1šķiār1trāuz1klaek1sčeik1stuar1ppiiz1šņuoņ1sliil1psiiz1groēg1stuuz1skuol1stīur1vciuz1smīur1zmaen1sveer1speuš1plēur1bšuat1stūiz1smeel1gšuec1staap1kraek1šdail1ddeel1kņail1dleel1psiap1stūap1pleuz1pleur1kšoār1dnīēr1pjuēk1šķair1mteug1ļķean1kvēil1gtaīr1šķiap1svāul1lpues1nvēuz1gveat1priug1šdaat1šķoiz1plīār1brial1dkāudz1maun1ssaos1prūiļ1ņveer1cheān1skāab1skaēr1sliār1krīal1kšuur1stoūg1snauk1stoir1mcēid1staid1slāut1skoir1stāār1proir1ktiār1kreap1gluas1tneiz1švīuz1spual1nrūār1spaun1ktāāb1slīār1pļēir1bjuur1btoel1sviun1ktūug1šgair1sliuz1friur1btaāb1stuem1brāom1proez1glāep1stoal1kmeiz1blīar1ksiīk1smoār1speap1krīiz1šķēur1tkāēk1lkoār1tnail1dsaal1dniel1dceon1truiz1stoūp1stoap1žvīap1triod1gruār1gtāiz1gveel1gsier1nhaat1švīār1hroil1tvāuz1smeat1sveim1tniuz1priēr1sraas1krāen1skaiz1glīus1tdēol1tmeūr1stuum1šviat1šļaār1knāuz1treok1šņoat1bliat1sniel1gtoek1šķeab1stiun1fteap1griir1steul1snien1tviam1pluam1zdaik1stīat1knāat1skūis1trois1trēīg1stair1spuam1svēār1bruec1stūul1dzail1kšoār1plāos1tniīk1snauz1staār1zdaār1šķiuz1bliek1troap1grēur1bšoir1slēiz1klauz1trūuz1traak1stoos1treuz1driir1smaak1šķēak1tliek1švēās1nkuel1ztier1cbaēr1ktoin1dsēal1kšaum1traip1snaeļ1skaār1šķīap1kriār1šķēel1drēim1pliuļ1dziir1ptaēr1ptail1praup1stīiz1fraus1treub1krēār1pļāin1frail1ktair1mpiap1šņoat1skuun1dzies1trēan1drīil1ptoadz1niar1pjuin1gtāiz1gruap1šķoēr1skāot1rpior1tfeir1mtiik1šķian1tmēam1briun1džail1pšoas1brāel1gšoap1kviug1smeil1pneēt1sviir1kšaas1skoek1speen1kšaiz1breem1ptiār1greiz1frāiv1stāul1šņaār1kroas1prail1ktāat1sleiz1gluik1snāok1šņaum1šmaār1gruār1smeat1snaur1ktoik1snauz1svīus1sloam1pdaem1ztāuz1žvais1smiēr1tnīār1gtuār1drūīg1stiap1troat1smeiz1plēir1tniak1šžoil1skuul1bšaum1spoāk1sliap1bloār1dzeār1kvauk1sneāt1rviap1žvaam1stuan1draār1gšoek1stēār1sloār1gtoek1ļveek1spoār1tsaiz1džiar1blāēg1stiar1bdiuk1šķīil1bšuor1proap1hloiz1trīas1trīuz1smēār1spāis1triab1klāuz1hlouļ1stiat1fliut1nkoiv1krāur1tdiap1glūār1glūom1skāat1stoum1staap1gleal1smael1traer1stoel1dviiz1friet1skoat1tvaār1kleāš1kruer1tceap1kruus1triuz1glaap1bleil1staap1sveiz1dzīas1tpaem1psiiz1tvēac1grīēr1dzīul1lciiz1šļiat1žņaov1smēas1skaen1tgeat1pluīs1šķiār1dzīēk1šņāel1nkoār1skuāv1stiāl1dziēp1stuīv1klaim1tmuos1proap1spēum1brāul1dziār1stāur1knēer1trūel1nbaār1broar1smeok1sneil1škaat1svēar1vdeat1sluiz1broēr1steāb1slius1skāat1grāāp1stuār1brūam1stīas1tmēiz1kņuen1klaiļ1slium1stoap1bļāuz1snaol1kloer1tmeiz1flial1stuap1špaar1stiāk1šķiār1džium1brair1dzual1kjūap1smīāb1staiz1kļaul1ptūap1smēār1tnīar1gvaudz1sous1stuap1steul1znaār1glāār1blāur1skail1stāel1nraak1triat1kņueg1smeap1grūēk1šķoin1spiik1staam1bliir1dzēēr1ktuur1kniel1tniiņ1krāiņ1kreiz1klean1spaun1skaam1stāēr1pšoār1fliir1mriēr1btāat1sviir1spaār1tnāap1šķūen1drāek1šniat1trīar1ktiiz1priig1znēon1spiul1kveek1šķuāt1skoek1sneīs1krāiz1klāēj1tveur1ktiog1ļhior1tmeaš1plūēj1slēam1plaēs1tniur1bsiis1tkais1dziiz1speab1staāp1stias1tmeos1triudz1daur1dzēat1šļuat1braun1klaer1ztiuz1pļāār1dreil1gšaiz1pleiz1žņaer1ztāel1dšeir1knēeņ1krāēr1ssial1snoūp1stīir1gsiiz1stair1sseuz1speek1sniīg1snēin1dziat1kliar1bveon1gloiv1skail1dniār1kraār1blēar1stāār1slieņ1ķmēēr1bsiik1smīāl1sciat1dreaž1brīiz1plāir1mveuz1group1jmauz1dzaem1ptoan1ktoež1staēr1šļuap1brīuz1krouz1skūuz1krīap1šmīuz1kviil1btāor1tjees1krāat1tveul1stuūk1stuen1ktaēr1stuar1bmauk1stuēr1nziuz1slīūk1stiat1svaap1pļēil1nmiir1snīin1dniāj1prāar1sbuat1spael1nmaek1stuis1grūis1nleāk1stīuz1stuif1šteār1spiīk1stāar1ktuur1ktāāj1dziēr1btoiz1zvaat1knuat1fraen1sraal1ctīār1brear1bniār1tniez1proan1tnīēp1stias1trāāp1stoīr1svaiz1šķaig1stuer1traes1truas1grāal1snaur1preur1mjāēn1prāat1proek1ļpaik1lveēr1kšoiz1glaap1snain1dzaār1grair1gtoiz1snaan1čkiap1tvaār1snaum1špeat1zvaig1zdoen1svaet1rgail1ggaīk1smeal1stāet1rriiz1dziār1praiz1trūār1pliēk1šķēāj1staiz1krour1kšuiž1knāor1bciem1ptāan1scēir1kšual1tdiēk1šņuīdz1šiot1rreāt1spēēk1mjuāt1krūil1ddaat1svīudz1kāār1trīar1ktāāl1skaen1slies1priur1btuug1stīuz1plāem1ztaiz1bļāīk1stiuz1spaār1tvean1dceel1dseuz1kraap1sliir1gtauz1slāir1klioņ1plūur1gtoan1grēūk1snaāv1zvaan1slāek1švāār1žvaār1šļuap1frāaž1skāat1preas1ttiiv1plāuz1grēek1šnoiz1grāuz1braes1tpaur1braiz1kļuim1stour1gtuom1dziir1gkaiz1šķeek1stiuk1šgaār1smael1tkaar1gmaal1nrauļ1krēar1gkaiz1svēēr1stoil1špaim1tciuk1plēel1ptiis1draer1smeul1snīār1krāāt1smair1stuat1pļāuk1smuan1dtāen1kšuar1skoēr1ptiēk1lvaor1skāuk1staep1staār1triir1kņiul1stāet1rviil1btuār1slaat1pliel1nsaur1kmēuz1broal1dneār1frēun1spūek1šķēen1proan1droat1bruak1snīuz1tvēik1spāuz1blīap1šķiel1draun1sviat1spuār1friep1stuēr1szāīb1stoār1dzaār1gliel1kneār1tneun1prāap1kveuz1kniap1draār1gšaār1kviir1zgaek1šgāek1sveat1gleār1stīes1proal1kmaiz1klīug1stoaz1proāj1slaen1tneul1stiat1kreār1svaār1šķeiz1kļūap1sluil1zkaek1šmeam1pšoūr1skouz1grāes1grāap1šņuir1kļaur1lmēel1dfēaz1druat1rpuum1stues1grīiz1knaas1smēur1spīeņ1skāār1slēudz1vīun1druar1skaeņ1traam1pliuz1kliul1gtuēk1brūus1dzīap1stāar1kšues1kraiz1brāir1staar1gceem1ptuur1steār1druuz1pļaat1glūad1skāov1skāak1stāēr1zgair1mgain1gtuīdz1teār1drīam1braīk1šķuur1gsiab1scion1driil1pjuāp1jvear1gbūul1gšuār1dvaār1tnoap1ploas1tkail1gšoiz1skaār1dniap1dvaīk1snāap1blāas1pļaap1kreal1preem1pšoap1truak1stīel1skuak1ņveak1špaaļ1skaūr1staat1bļāin1gveat1hloig1frīok1snēār1griak1šķiāt1snaul1tsias1tniir1stoan1sfoek1šlaul1tzoob1spios1priel1briār1žvīat1blīot1rtiil1gsiuz1zvēin1speir1ptuag1svaiz1kliok1sniel1graum1spēūp1stiak1stēur1ktaan1driir1ptoiz1pliīv1drēar1pzour1btiul1šņiat1blēog1ļraiz1sleil1proil1gtoeļ1traiz1slēār1kveur1btāār1frāal1tlaur1pmāēr1ksial1ksiir1kņoin1sraem1blēib1stain1sciur1ktuiz1šķūan1tniām1glāur1zvaīk1šķēup1rlail1ngail1glaēk1šņaen1prāuk1špaat1pļaiz1šķīār1gšuir1gšaul1dzēan1kkuul1tniun1dzēap1smaer1stiel1ztuir1gkoim1treus1snaūk1šķuik1tniat1brēas1kraan1džaam1plīar1kšaap1spean1skaih1svēod1sliēr1pšuar1gream1stoān1skaor1tvīat1svāuz1šķūūr1stoin1sceud1spiudz1gaal1snāāg1stual1troat1štaat1kļūudz1viap1sloap1greiz1šņoug1stuim1stiup1stuur1stīos1krair1skaog1ļdeum1dziin1kvied1kļūul1traiz1skoel1gtāur1gtāiz1pļēap1smuer1stīāt1ršuok1šņuap1šķaāt1dzīat1troat1brīal1staudz1ruar1gtēin1staiņ1ķveat1krial1snuiz1zvēiz1kluin1hroir1ptāas1kviur1spiiz1kvēār1skāir1gtuāp1stauz1brued1krāet1staal1vgaam1pšaar1pgauz1slaat1šķīat1džiār1kļūār1šroeņ1braīk1gruār1klāak1ņkood1prāat1klīiz1stēār1žņaat1triik1stūek1šzīār1kniār1preap1klāul1gtaēr1pjoār1gsiiz1šņaiz1gleēr1bjois1stūeļ1drāik1steēr1ngaap1tveuz1skāap1knāik1snīam1bleek1stāol1fgaem1briuz1spīel1dmaiz1sloar1gkāiz1svīūg1kriun1ktier1preuz1švīap1dzīiz1spīek1tdaēr1dzeil1skaār1tnuur1bšaap1traap1dzean1stein1ktūer1ztuas1pruen1scauz1svāil1dmēik1sniār1brēāk1stoāk1sluap1briap1stēiz1stiap1pļaār1štaīk1sneun1traok1šķiūs1tniok1trīiz1glāom1pleār1kriuv1braīv1stuāt1rgāār1pļauz1klīuz1sloat1greeļ1brias1prāig1žņaēr1glēūr1stiīv1svaah1tveūk1sneet1rsiuz1špaan1dzeum1praer1plēiņ1stiat1drīat1dvain1tnīin1gvial1šķīap1slēid1plēil1nvauz1glūiz1šviudz1puor1tliin1kriap1priem1dviār1drāas1troar1dzeāk1sniuz1skias1tvaum1sveār1gdiik1stoos1preat1frāel1dreil1dvaug1prāul1stīuz1sviur1tdaār1sluūp1stāez1gluīļ1knāan1cleūp1stuec1sviak1šķeir1dzīuz1dzeāl1spēij1droār1klaim1sliap1bliil1sruon1skāuz1spiul1dzeik1šķous1krūek1stīek1šroit1brias1priik1šķuor1tkuat1kniis1mjuim1stuez1prāat1sliur1vmaom1staer1staot1rpues1prauz1great1šķēur1dziūk1steap1smiār1stuan1skāūr1stēur1zmiār1krēer1smaat1šņuod1skoim1preal1snēap1dzaiz1pļail1krūat1speuz1krāin1traat1šķiat1broel1tgain1troon1tdaak1šķaas1tnair1skiaļ1stuos1kniēr1tniār1trūer1ztair1zmaiz1knuar1gkueļ1gleiz1dzēap1stios1trāuz1šķios1truir1kļues1brāar1stoap1grāus1tmeiz1skiin1svaum1skoun1kniat1kviuk1stīap1pliot1plāet1rmoel1djoub1stauz1sniiz1dzeul1gšoam1pjouz1drear1pniis1mmīal1dzīiz1žvīar1bmūat1spoal1šķiuz1kvēal1ktiudz1reār1spīiz1kraet1rreab1stouz1sluār1plēus1ttēur1staiz1griot1rtoen1stiāv1grūār1tvaun1slīon1greēk1sneir1kniel1dpūav1grīor1tjēīk1smāīdz1jues1smēiz1spoiz1brīum1bveis1kvaīg1ļlaīs1stūim1tkāār1gmeār1bleāč1plēēr1zciēp1stael1drāak1šķual1ngauk1šķēir1ktāod1skaīk1stoir1speir1pšoēj1spēat1hroid1smion1traat1gveil1dķein1skuel1dtīek1šķiuz1kreap1zvēār1skaān1sveudz1vāiz1steuz1plaan1ckaež1frēin1gšaap1hroin1gtīir1mdiir1mvaap1sviuz1dzīuz1proēr1snaap1drouz1bloal1tvaek1šsēudz1veih1stāuz1graēd1dziar1psiār1driat1klāiz1tveār1sleul1gšaal1tvīēr1ļveir1mziat1draos1pļair1ktoel1ngaēl1spiap1gruēr1btius1pliik1smaār1slīol1skaīt1skaap1džiur1tnīuz1dziār1šmīodz1niar1gdaat1skiuz1dzēel1tliov1skiel1ztāat1blāar1dzīis1trāas1traen1svīon1krēur1gtaen1tmēār1kruun1driār1glael1pvaas1prois1priiz1plūil1dkoār1šļiar1tneus1tneat1knaat1kraat1spiēr1ptāīk1stain1grīed1spiop1stuum1šsaap1preap1trūār1šķaat1brūum1šķiel1stual1stouz1kļaal1nzeat1gruon1froat1klaap1brūir1mtēīdz1nāuz1šmīap1graak1šzeap1blīan1knoil1skāir1ktuēt1spēal1vniar1griuz1kleul1stoes1krūiz1pļāuz1ploat1šļiug1šmaec1slaīg1stouz1blēib1stien1stoin1kliir1dziug1znain1groas1prūež1graiz1kreeg1slāām1grāig1znāam1fleir1pšaeg1smiuz1šķaap1šķēug1stial1steal1nciem1mviīdz1tiik1snoār1svēet1rkāul1gtāat1spēār1stoil1šmāet1rtiar1dzēer1ckoar1staēr1bšaāj1gleam1pjauz1dvaot1rkāak1šmauz1plēak1špuār1bļāir1gtāik1šķēuz1zvaal1stīos1kleār1steug1šžoēr1tneiz1dvais1truek1škuap1skāar1gtiar1gviuz1smiim1ptoār1skiār1plūuļ1skaib1snīiz1šķiap1skiun1sbīep1stēus1skoat1zvēat1stiel1dzoīk1smēan1skuum1slauz1šmaap1žņaek1šzeuz1kriir1mmāan1čkaēg1staat1kroet1rrāuz1knāuz1stāap1drīez1gloat1plear1šļaug1šņuār1kliot1rzial1kvīis1traib1stāor1dniel1dpain1gpoul1slauz1tveel1ttaap1plēuz1šņaār1staos1tbiār1gleog1ļrūer1stuiz1ploūv1briēl1spuiz1sliap1pluum1stiuk1švāus1trauz1džiēr1npael1pjoet1kreāb1slēik1lķean1spoim1tkuok1greiļ1skaan1tkuan1sjēil1pšaūk1snāāl1szāol1stous1trēij1krēan1floap1glāāl1sviat1slour1bjoel1smeat1smēop1dzīūg1stual1traer1tneat1švios1trēez1drāur1gšaen1spoov1skail1ktues1treiz1dveār1smēat1graāg1staūv1grias1tmāin1flāoņ1stūār1kluel1tneak1staār1dkoār1kvēan1troat1kruap1stoil1ptaedz1niis1proīr1groudz1siem1braār1zkoul1šņāus1stiēk1šķiudz1vēum1tniar1stuap1kleīk1smuup1staīk1smaār1zvaab1rkaēdz1niāb1stāēr1klien1troār1plīil1gšuap1kvēas1treak1steek1šķaāt1rmoan1scein1sdeiz1kruap1šļāat1breon1staēr1zlael1gšaām1brael1dziuz1druudz1diap1brāar1ktaeņ1slaar1šviiz1smiir1vjaen1griar1kšouz1drīul1staek1smeār1šņaār1zniār1troap1kliār1sviēr1stēīk1stīet1rtūīdz1ciur1tliek1stoim1tsaus1brāuk1šķoir1ztaār1stūun1ktuēr1mjuīk1šķaur1kliuz1fliap1plūil1dziap1dreaz1svaug1ļlaat1stīiz1pluuz1trois1sliiž1skāir1gšoen1ktāār1gtaiz1bliār1smīim1brīār1dzēār1svīek1spaīdz1kouz1svēat1ploor1tlaab1prāir1tneūk1slāiz1sveet1plāir1svail1btiuz1brūīt1spēuz1šķēudz1noat1slāiz1blāes1tdius1zviis1kriēl1slēob1skuēk1šņiul1šņuon1troil1stīiz1braur1pnial1dsēim1ttūis1spēes1tmein1gvīug1špuir1dneiļ1ņlaap1staik1smiad1grāiz1spēil1gtāiz1svail1nbāim1stāak1šveuz1prauz1grūār1skūiz1bruus1tsēug1snēār1dzoin1tniig1stier1gtuen1truas1krūār1slāap1tvēel1stiil1stoil1draot1rgaur1kņuap1braer1tzāat1stāer1cliēr1bšuuz1stēap1plāan1gviuz1šļiuz1blāed1rvias1tlaiz1stuot1spēus1proim1tdaam1krēop1proig1žņoat1bļaap1kniiz1smaiz1grūan1dpuīv1prāur1stuar1stīig1zneūk1staāj1skoek1škaub1stiur1dzeiz1hroap1šmaap1spaār1stēib1stuat1smīim1stail1ksiar1ndoon1krees1krēāl1plāuk1smain1grium1prouz1draār1plaār1pluat1steel1gtaen1gruil1tzeār1priiz1krīat1krēes1prūis1svēār1šviār1knuen1ktuap1treiz1kņūul1gsiin1driiz1drīek1steaļ1ķneuz1spēos1tmaug1sniat1grēal1sniur1ngaip1frūēr1skoat1stēēr1gliol1fraat1groun1kciār1kņuiz1skuek1sceap1slaat1slēap1štaap1šļues1triuz1pluār1bliār1grāuz1stoil1train1gruūk1snien1szāos1prāāp1jvīār1tnēil1ptuum1šzais1kreis1krēul1gtium1dzīek1špuur1zniuz1drous1tveās1trāūg1staap1brēer1vjeiz1grēar1gmuat1druap1kļaap1spiap1breel1ptoār1tvēal1kšouk1smeel1dzēil1kmeēn1skāir1gšuil1stiir1dsair1slīat1smiār1šķoar1spaal1dseuz1knuar1gpoiz1šļaat1šķaār1šņuuz1svean1stēek1trāār1gluur1vjuoņ1stiat1drāiļ1proiz1tvaiz1trāap1spāom1pliak1stuap1spuek1tdiok1steer1graam1breuz1bļaus1grael1gruam1staat1skoīb1stuek1triel1mlaan1sveat1skāun1dzīīk1graap1skain1dkoal1ktuul1dzues1trāat1spīol1dlaat1šķeeņ1pleos1tlaik1stāap1švīuz1prāap1kroūt1smēis1griem1pšuiz1bļair1mnoap1spīēr1ktial1gmeed1sviis1briun1sneen1sviuz1kveār1groer1stāuz1šķeeļ1krūod1rpaīv1grāet1rbaun1skuār1tmēāb1stīil1pjoiz1stāuz1žvīuz1šķīis1tkoos1prael1gtuad1smiom1kraut1svail1ptiug1preun1kteil1gruār1šķūez1gliiv1spēer1dloāt1ršāēj1grāur1dzoen1trāap1bļaēr1tņuem1dniin1ksaāl1šķēuz1hroiv1stoet1rjūuļ1gluir1psiel1zceum1slēat1griel1ptuuk1stāat1praar1gjouz1tvauz1skoiz1stīel1stoap1praov1skuar1šruēp1stoat1krāir1ksiok1šķeiz1šļāiz1drail1ptāil1dsēin1gtaūp1staug1ļkoar1džuiz1krāul1dzīur1stā_jā3a2_ne3a2_ie3a2_no3a2_pa3a2_sa3a2_uz3a2_ap3a2_at3a2_iz3a2_jā3ā2_ne3ā2_ie3ā2_no3ā2_pa3ā2_sa3ā2_uz3ā2_ap3ā2_at3ā2_iz3ā2_jā3e2_ne3e2_ie3e2_no3e2_pa3e2_sa3e2_uz3e2_ap3e2_at3e2_iz3e2_jā3ē2_ne3ē2_ie3ē2_no3ē2_pa3ē2_sa3ē2_uz3ē2_ap3ē2_at3ē2_iz3ē2_jā3i2_ne3i2_ie3i2_no3i2_pa3i2_sa3i2_uz3i2_ap3i2_at3i2_iz3i2_jā3ī2_ne3ī2_ie3ī2_no3ī2_pa3ī2_sa3ī2_uz3ī2_ap3ī2_at3ī2_iz3ī2_jā3o2_ne3o2_ie3o2_no3o2_pa3o2_sa3o2_uz3o2_ap3o2_at3o2_iz3o2_jā3u2_ne3u2_ie3u2_no3u2_pa3u2_sa3u2_uz3u2_ap3u2_at3u2_iz3u2_jā3ū2_ne3ū2_ie3ū2_no3ū2_pa3ū2_sa3ū2_uz3ū2_ap3ū2_at3ū2_iz3ū2_ne3satran2ssa2ls_ir2k3lir2k3ļ_ai4z5");
            put(7, "ārg1stiilg1stoakt1spoalt1gvaark1staugs1tlēuzs1pļaald1skāins1grēizs1prūilk1tniurb1stiezg1lvearp1proirk1snield1plēird1spuilp1stuīns1trāārs1kraird1smieln1svāirp1stiārg1stuens1staugš1stiirk1stiilg1staals1tpuārd1dziirm1dziabs1traumš1brūarb1spēils1blīurs1krūizs1praurb1stuudz1šķauzs1kraaps1preins1gruens1blaārs1praarg1krāilk1tneens1truulk1steupj1graunk1šķiurk1staaps1krēirs1drēērt1sliobs1truērt1ssūast1skoird1skairg1stoord1zniaks1tveikt1stēuzs1preizs1proilt1stēuzs1prāeks1tkoalk1stīīdz1proens1droirg1stuing1stoizs1kraink1stēalk1šķiātr1sliild1spaāls1trealk1stoubs1trāaps1truērk1šķaizs1trīats1krēārs1trīalk1stuuss1kriizs1preent1lmeirg1zdailb1stieks1treaps1prailk1stiunt1sziuzs1proeks1kluiss1priaps1trīulb1stourk1stiaps1proaht1kluāls1staens1krāilt1smāeks1preuzs1truaps1prāetr1klauzs1priīks1tmēeld1spēapj1draist1hreids1krēirs1plāirs1stuunk1stēilk1sniink1šķiird1smīirs1kreīdz1skaalk1snāīks1tsiizs1truars1tdaunt1snoēst1griuzs1treurk1stouns1droulg1stoātr1spiilg1spēerc1skoilb1stoāls1skāens1krūaps1triilk1tnēudr1skāurb1jmaats1praird1sliizs1trāekš1ņnīind1staaps1kraērk1stuiln1briuzs1praudz1plailb1stuizs1kriilk1stuirp1staeks1trēugs1tkault1zvaātr1griink1šķourk1šķaulb1stiuzs1trāaps1trāirk1stīulb1stuunk1tsions1trēīgt1spēark1stuilk1stoark1šķoalt1kvēuns1dzēirk1stēild1krēink1sliurs1trāunk1stoilk1stēārg1stoakt1sguert1briilg1stiērt1svēērs1griaps1trēeņs1krāamp1stuats1trāilp1stiežs1trāerk1šķieln1plaurk1sniakt1sviens1dziirg1stiark1šķuess1krāirk1stount1smaisn1grialk1sneild1plaudz1skaārs1truuzs1krūink1šķēērs1svīērk1šķoīks1tpiilt1rpaātr1braurk1stuārs1proals1stieks1ploamp1stoizs1treang1steirg1staizs1krēātr1spēust1knāark1šķēark1šķiārs1prāaps1prūilp1stoīgs1trāont1rreakt1sdeats1treuzs1trīaps1pļaurk1šķiurk1steink1stuājs1trāats1pļaērk1šķietr1stūink1staans1krieks1proald1drāārp1staurb1staunk1šķēakt1sdaakt1spualk1sniārg1staāls1traāls1steirg1zdeāgs1tviird1zniirt1skuons1trāērk1stailp1staisn1stūelk1sniilt1skoats1prūurk1šķuars1tgaugs1troens1šķiing1stiads1krūels1traark1šķaark1stoant1sbeink1šķaunk1stiird1sdeink1stians1plaugs1traats1preirk1šķiirp1stuils1druals1tniats1truins1truanž1dzeīks1proamp1stiars1tvīugš1stāanc1spēark1stiunk1stairm1skaakt1smīulg1stuamp1staeks1trīunk1šķourk1stēelz1szāārs1treens1kriink1šķeuks1trāink1stoult1spūelt1spēats1priild1spēuzs1prūeks1troegl1prāirp1stoalt1kriakņ1graārs1lveārs1pļaudz1stūurb1stoaps1treugs1tvēekļ1skāunk1šķaisn1prāats1triākļ1stāudz1krāimt1proing1staeks1pluakt1spailk1staalk1šņaats1prāīks1tčaent1rtiērk1stiirg1spēikt1spēizs1prāakt1smiizs1krūunk1stuats1krūārs1priunk1šķuult1spēunt1sgaugs1tsiizs1priārs1krūaps1krūārk1stiizs1pļaars1tpuērk1steuzs1triulb1staizs1trions1truirs1svāats1trīārs1krēakt1ssaeks1traakt1slourk1šķoing1stuult1kvaust1spoītņ1griežs1krūirm1sleirk1staurk1šķēort1preekš1ņlaiņs1trāalk1stairk1stuemm1dziirg1zdāirm1klaaks1tnions1traink1šķuats1kraind1rveakt1sjaens1bluaļķ1špault1svaogļ1skāārk1staulg1stiērk1stoird1sdāugs1tceuns1grēult1plairš1krāegt1spēārs1tniats1proakt1slaārs1triilg1stuīdz1svauzs1krēoks1krūārt1stailb1staalk1stioks1troekš1dzient1rbēiln1skairm1šķiārs1trāaps1prions1krēārs1preirk1steird1slēulg1staakš1svāalt1briārs1prū_jā1s2p_ne1s2p_ie1s2p_no1s2p_pa1s2p_sa1s2p_uz1s2p_ap1s2p_at1s2p_iz1s2p_jā1t2r_ne1t2r_ie1t2r_no1t2r_pa1t2r_sa1t2r_uz1t2r_ap1t2r_at1t2r_iz1t2r_jā1s2c_ne1s2c_ie1s2c_no1s2c_pa1s2c_sa1s2c_uz1s2c_ap1s2c_at1s2c_iz1s2c_jā1g2l_ne1g2l_ie1g2l_no1g2l_pa1g2l_sa1g2l_uz1g2l_ap1g2l_at1g2l_iz1g2l_jā1ž2v_ne1ž2v_ie1ž2v_no1ž2v_pa1ž2v_sa1ž2v_uz1ž2v_ap1ž2v_at1ž2v_iz1ž2v_jā1š2ļ_ne1š2ļ_ie1š2ļ_no1š2ļ_pa1š2ļ_sa1š2ļ_uz1š2ļ_ap1š2ļ_at1š2ļ_iz1š2ļ_jā1s2f_ne1s2f_ie1s2f_no1s2f_pa1s2f_sa1s2f_uz1s2f_ap1s2f_at1s2f_iz1s2f_jā1š2t_ne1š2t_ie1š2t_no1š2t_pa1š2t_sa1š2t_uz1š2t_ap1š2t_at1š2t_iz1š2t_jā1b2r_ne1b2r_ie1b2r_no1b2r_pa1b2r_sa1b2r_uz1b2r_ap1b2r_at1b2r_iz1b2r_jā1š2r_ne1š2r_ie1š2r_no1š2r_pa1š2r_sa1š2r_uz1š2r_ap1š2r_at1š2r_iz1š2r_jā1š2v_ne1š2v_ie1š2v_no1š2v_pa1š2v_sa1š2v_uz1š2v_ap1š2v_at1š2v_iz1š2v_jā1s2t_ne1s2t_ie1s2t_no1s2t_pa1s2t_sa1s2t_uz1s2t_ap1s2t_at1s2t_iz1s2t_jā1p2r_ne1p2r_ie1p2r_no1p2r_pa1p2r_sa1p2r_uz1p2r_ap1p2r_at1p2r_iz1p2r_jā1g2ļ_ne1g2ļ_ie1g2ļ_no1g2ļ_pa1g2ļ_sa1g2ļ_uz1g2ļ_ap1g2ļ_at1g2ļ_iz1g2ļ_jā1š2k_ne1š2k_ie1š2k_no1š2k_pa1š2k_sa1š2k_uz1š2k_ap1š2k_at1š2k_iz1š2k_jā1p2s_ne1p2s_ie1p2s_no1p2s_pa1p2s_sa1p2s_uz1p2s_ap1p2s_at1p2s_iz1p2s_jā1k2l_ne1k2l_ie1k2l_no1k2l_pa1k2l_sa1k2l_uz1k2l_ap1k2l_at1k2l_iz1k2l_jā1g2r_ne1g2r_ie1g2r_no1g2r_pa1g2r_sa1g2r_uz1g2r_ap1g2r_at1g2r_iz1g2r_jā1š2ķ_ne1š2ķ_ie1š2ķ_no1š2ķ_pa1š2ķ_sa1š2ķ_uz1š2ķ_ap1š2ķ_at1š2ķ_iz1š2ķ_jā1p2n_ne1p2n_ie1p2n_no1p2n_pa1p2n_sa1p2n_uz1p2n_ap1p2n_at1p2n_iz1p2n_jā1s2v_ne1s2v_ie1s2v_no1s2v_pa1s2v_sa1s2v_uz1s2v_ap1s2v_at1s2v_iz1s2v_jā1d2r_ne1d2r_ie1d2r_no1d2r_pa1d2r_sa1d2r_uz1d2r_ap1d2r_at1d2r_iz1d2r_jā1p2l_ne1p2l_ie1p2l_no1p2l_pa1p2l_sa1p2l_uz1p2l_ap1p2l_at1p2l_iz1p2l_jā1d2v_ne1d2v_ie1d2v_no1d2v_pa1d2v_sa1d2v_uz1d2v_ap1d2v_at1d2v_iz1d2v_jā1š2l_ne1š2l_ie1š2l_no1š2l_pa1š2l_sa1š2l_uz1š2l_ap1š2l_at1š2l_iz1š2l_jā1s2k_ne1s2k_ie1s2k_no1s2k_pa1s2k_sa1s2k_uz1s2k_ap1s2k_at1s2k_iz1s2k_jā1k2v_ne1k2v_ie1k2v_no1k2v_pa1k2v_sa1k2v_uz1k2v_ap1k2v_at1k2v_iz1k2v_jā1z2v_ne1z2v_ie1z2v_no1z2v_pa1z2v_sa1z2v_uz1z2v_ap1z2v_at1z2v_iz1z2v_jā1k2s_ne1k2s_ie1k2s_no1k2s_pa1k2s_sa1k2s_uz1k2s_ap1k2s_at1k2s_iz1k2s_jā1p2t_ne1p2t_ie1p2t_no1p2t_pa1p2t_sa1p2t_uz1p2t_ap1p2t_at1p2t_iz1p2t_jā1z2n_ne1z2n_ie1z2n_no1z2n_pa1z2n_sa1z2n_uz1z2n_ap1z2n_at1z2n_iz1z2n_jā1k2r_ne1k2r_ie1k2r_no1k2r_pa1k2r_sa1k2r_uz1k2r_ap1k2r_at1k2r_iz1k2r_jā1f2r_ne1f2r_ie1f2r_no1f2r_pa1f2r_sa1f2r_uz1f2r_ap1f2r_at1f2r_iz1f2r_jā1s2h_ne1s2h_ie1s2h_no1s2h_pa1s2h_sa1s2h_uz1s2h_ap1s2h_at1s2h_iz1s2h_jā1ž2ņ_ne1ž2ņ_ie1ž2ņ_no1ž2ņ_pa1ž2ņ_sa1ž2ņ_uz1ž2ņ_ap1ž2ņ_at1ž2ņ_iz1ž2ņ_jā1d2d_ne1d2d_ie1d2d_no1d2d_pa1d2d_sa1d2d_uz1d2d_ap1d2d_at1d2d_iz1d2d_jā1v2j_ne1v2j_ie1v2j_no1v2j_pa1v2j_sa1v2j_uz1v2j_ap1v2j_at1v2j_iz1v2j_jā1f2j_ne1f2j_ie1f2j_no1f2j_pa1f2j_sa1f2j_uz1f2j_ap1f2j_at1f2j_iz1f2j_jā1p2j_ne1p2j_ie1p2j_no1p2j_pa1p2j_sa1p2j_uz1p2j_ap1p2j_at1p2j_iz1p2j_jā1b2ļ_ne1b2ļ_ie1b2ļ_no1b2ļ_pa1b2ļ_sa1b2ļ_uz1b2ļ_ap1b2ļ_at1b2ļ_iz1b2ļ_jā1g2n_ne1g2n_ie1g2n_no1g2n_pa1g2n_sa1g2n_uz1g2n_ap1g2n_at1g2n_iz1g2n_jā1h2r_ne1h2r_ie1h2r_no1h2r_pa1h2r_sa1h2r_uz1h2r_ap1h2r_at1h2r_iz1h2r_jā1s2n_ne1s2n_ie1s2n_no1s2n_pa1s2n_sa1s2n_uz1s2n_ap1s2n_at1s2n_iz1s2n_jā1ž2m_ne1ž2m_ie1ž2m_no1ž2m_pa1ž2m_sa1ž2m_uz1ž2m_ap1ž2m_at1ž2m_iz1ž2m_jā1d2ž_ne1d2ž_ie1d2ž_no1d2ž_pa1d2ž_sa1d2ž_uz1d2ž_ap1d2ž_at1d2ž_iz1d2ž_jā1k2c_ne1k2c_ie1k2c_no1k2c_pa1k2c_sa1k2c_uz1k2c_ap1k2c_at1k2c_iz1k2c_jā1k2ņ_ne1k2ņ_ie1k2ņ_no1k2ņ_pa1k2ņ_sa1k2ņ_uz1k2ņ_ap1k2ņ_at1k2ņ_iz1k2ņ_jā1š2m_ne1š2m_ie1š2m_no1š2m_pa1š2m_sa1š2m_uz1š2m_ap1š2m_at1š2m_iz1š2m_jā1g2v_ne1g2v_ie1g2v_no1g2v_pa1g2v_sa1g2v_uz1g2v_ap1g2v_at1g2v_iz1g2v_jā1h2l_ne1h2l_ie1h2l_no1h2l_pa1h2l_sa1h2l_uz1h2l_ap1h2l_at1h2l_iz1h2l_jā1k2ļ_ne1k2ļ_ie1k2ļ_no1k2ļ_pa1k2ļ_sa1k2ļ_uz1k2ļ_ap1k2ļ_at1k2ļ_iz1k2ļ_jā1s2l_ne1s2l_ie1s2l_no1s2l_pa1s2l_sa1s2l_uz1s2l_ap1s2l_at1s2l_iz1s2l_jā1t2v_ne1t2v_ie1t2v_no1t2v_pa1t2v_sa1t2v_uz1t2v_ap1t2v_at1t2v_iz1t2v_jā1š2ņ_ne1š2ņ_ie1š2ņ_no1š2ņ_pa1š2ņ_sa1š2ņ_uz1š2ņ_ap1š2ņ_at1š2ņ_iz1š2ņ_jā1š2p_ne1š2p_ie1š2p_no1š2p_pa1š2p_sa1š2p_uz1š2p_ap1š2p_at1š2p_iz1š2p_jā1d2z_ne1d2z_ie1d2z_no1d2z_pa1d2z_sa1d2z_uz1d2z_ap1d2z_at1d2z_iz1d2z_jā1f2l_ne1f2l_ie1f2l_no1f2l_pa1f2l_sa1f2l_uz1f2l_ap1f2l_at1f2l_iz1f2l_jā1k2n_ne1k2n_ie1k2n_no1k2n_pa1k2n_sa1k2n_uz1k2n_ap1k2n_at1k2n_iz1k2n_jā1p2ļ_ne1p2ļ_ie1p2ļ_no1p2ļ_pa1p2ļ_sa1p2ļ_uz1p2ļ_ap1p2ļ_at1p2ļ_iz1p2ļ_jā1k2b_ne1k2b_ie1k2b_no1k2b_pa1k2b_sa1k2b_uz1k2b_ap1k2b_at1k2b_iz1k2b_jā1s2m_ne1s2m_ie1s2m_no1s2m_pa1s2m_sa1s2m_uz1s2m_ap1s2m_at1s2m_iz1s2m_jā1m2n_ne1m2n_ie1m2n_no1m2n_pa1m2n_sa1m2n_uz1m2n_ap1m2n_at1m2n_iz1m2n_jā1š2n_ne1š2n_ie1š2n_no1š2n_pa1š2n_sa1š2n_uz1š2n_ap1š2n_at1š2n_iz1š2n_jā1v2r_ne1v2r_ie1v2r_no1v2r_pa1v2r_sa1v2r_uz1v2r_ap1v2r_at1v2r_iz1v2r_jā1b2l_ne1b2l_ie1b2l_no1b2l_pa1b2l_sa1b2l_uz1b2l_ap1b2l_at1b2l_iz1b2l_pie3a2_aiz3a2_bez3a2_pār3a2_eks3a2_vis3a2_pie3ā2_aiz3ā2_bez3ā2_pār3ā2_eks3ā2_vis3ā2_pie3e2_aiz3e2_bez3e2_pār3e2_eks3e2_vis3e2_pie3ē2_aiz3ē2_bez3ē2_pār3ē2_eks3ē2_vis3ē2_pie3i2_aiz3i2_bez3i2_pār3i2_eks3i2_vis3i2_pie3ī2_aiz3ī2_bez3ī2_pār3ī2_eks3ī2_vis3ī2_pie3o2_aiz3o2_bez3o2_pār3o2_eks3o2_vis3o2_pie3u2_aiz3u2_bez3u2_pār3u2_eks3u2_vis3u2_pie3ū2_aiz3ū2_bez3ū2_pār3ū2_eks3ū2_vis3ū2_jā3ie1_jā3iz1_jā3no1_ne3ap1_ne3ie1_ne3at1_ne3in1_ne3iz1_ne3uz1g2š1galk2š1galvēs2t1nvēs2t1ksa2lds_sa2l2d1pir2m1rpir2m1kot2r1r2ot2r1k2_adā2m3apak2š3kār2t3n_at3e2j_vie2n1");
            put(8, "_pie1s2p_aiz1s2p_bez1s2p_pār1s2p_eks1s2p_vis1s2p_pie1t2r_aiz1t2r_bez1t2r_pār1t2r_eks1t2r_vis1t2r_pie1s2c_aiz1s2c_bez1s2c_pār1s2c_eks1s2c_vis1s2c_jā1s2tj_ne1s2tj_ie1s2tj_no1s2tj_pa1s2tj_sa1s2tj_uz1s2tj_ap1s2tj_at1s2tj_iz1s2tj_pie1g2l_aiz1g2l_bez1g2l_pār1g2l_eks1g2l_vis1g2l_pie1ž2v_aiz1ž2v_bez1ž2v_pār1ž2v_eks1ž2v_vis1ž2v_pie1š2ļ_aiz1š2ļ_bez1š2ļ_pār1š2ļ_eks1š2ļ_vis1š2ļ_pie1s2f_aiz1s2f_bez1s2f_pār1s2f_eks1s2f_vis1s2f_pie1š2t_aiz1š2t_bez1š2t_pār1š2t_eks1š2t_vis1š2t_jā1s2tr_ne1s2tr_ie1s2tr_no1s2tr_pa1s2tr_sa1s2tr_uz1s2tr_ap1s2tr_at1s2tr_iz1s2tr_pie1b2r_aiz1b2r_bez1b2r_pār1b2r_eks1b2r_vis1b2r_pie1š2r_aiz1š2r_bez1š2r_pār1š2r_eks1š2r_vis1š2r_pie1š2v_aiz1š2v_bez1š2v_pār1š2v_eks1š2v_vis1š2v_pie1s2t_aiz1s2t_bez1s2t_pār1s2t_eks1s2t_vis1s2t_pie1p2r_aiz1p2r_bez1p2r_pār1p2r_eks1p2r_vis1p2r_pie1g2ļ_aiz1g2ļ_bez1g2ļ_pār1g2ļ_eks1g2ļ_vis1g2ļ_pie1š2k_aiz1š2k_bez1š2k_pār1š2k_eks1š2k_vis1š2k_pie1p2s_aiz1p2s_bez1p2s_pār1p2s_eks1p2s_vis1p2s_pie1k2l_aiz1k2l_bez1k2l_pār1k2l_eks1k2l_vis1k2l_pie1g2r_aiz1g2r_bez1g2r_pār1g2r_eks1g2r_vis1g2r_pie1š2ķ_aiz1š2ķ_bez1š2ķ_pār1š2ķ_eks1š2ķ_vis1š2ķ_pie1p2n_aiz1p2n_bez1p2n_pār1p2n_eks1p2n_vis1p2n_pie1s2v_aiz1s2v_bez1s2v_pār1s2v_eks1s2v_vis1s2v_jā1s2pr_ne1s2pr_ie1s2pr_no1s2pr_pa1s2pr_sa1s2pr_uz1s2pr_ap1s2pr_at1s2pr_iz1s2pr_pie1d2r_aiz1d2r_bez1d2r_pār1d2r_eks1d2r_vis1d2r_pie1p2l_aiz1p2l_bez1p2l_pār1p2l_eks1p2l_vis1p2l_pie1d2v_aiz1d2v_bez1d2v_pār1d2v_eks1d2v_vis1d2v_pie1š2l_aiz1š2l_bez1š2l_pār1š2l_eks1š2l_vis1š2l_pie1s2k_aiz1s2k_bez1s2k_pār1s2k_eks1s2k_vis1s2k_jā1s2kv_ne1s2kv_ie1s2kv_no1s2kv_pa1s2kv_sa1s2kv_uz1s2kv_ap1s2kv_at1s2kv_iz1s2kv_pie1k2v_aiz1k2v_bez1k2v_pār1k2v_eks1k2v_vis1k2v_pie1z2v_aiz1z2v_bez1z2v_pār1z2v_eks1z2v_vis1z2v_pie1k2s_aiz1k2s_bez1k2s_pār1k2s_eks1k2s_vis1k2s_pie1p2t_aiz1p2t_bez1p2t_pār1p2t_eks1p2t_vis1p2t_pie1z2n_aiz1z2n_bez1z2n_pār1z2n_eks1z2n_vis1z2n_pie1k2r_aiz1k2r_bez1k2r_pār1k2r_eks1k2r_vis1k2r_jā1s2kr_ne1s2kr_ie1s2kr_no1s2kr_pa1s2kr_sa1s2kr_uz1s2kr_ap1s2kr_at1s2kr_iz1s2kr_pie1f2r_aiz1f2r_bez1f2r_pār1f2r_eks1f2r_vis1f2r_pie1s2h_aiz1s2h_bez1s2h_pār1s2h_eks1s2h_vis1s2h_pie1ž2ņ_aiz1ž2ņ_bez1ž2ņ_pār1ž2ņ_eks1ž2ņ_vis1ž2ņ_pie1d2d_aiz1d2d_bez1d2d_pār1d2d_eks1d2d_vis1d2d_jā1š2pr_ne1š2pr_ie1š2pr_no1š2pr_pa1š2pr_sa1š2pr_uz1š2pr_ap1š2pr_at1š2pr_iz1š2pr_pie1v2j_aiz1v2j_bez1v2j_pār1v2j_eks1v2j_vis1v2j_pie1f2j_aiz1f2j_bez1f2j_pār1f2j_eks1f2j_vis1f2j_pie1p2j_aiz1p2j_bez1p2j_pār1p2j_eks1p2j_vis1p2j_pie1b2ļ_aiz1b2ļ_bez1b2ļ_pār1b2ļ_eks1b2ļ_vis1b2ļ_pie1g2n_aiz1g2n_bez1g2n_pār1g2n_eks1g2n_vis1g2n_pie1h2r_aiz1h2r_bez1h2r_pār1h2r_eks1h2r_vis1h2r_pie1s2n_aiz1s2n_bez1s2n_pār1s2n_eks1s2n_vis1s2n_pie1ž2m_aiz1ž2m_bez1ž2m_pār1ž2m_eks1ž2m_vis1ž2m_pie1d2ž_aiz1d2ž_bez1d2ž_pār1d2ž_eks1d2ž_vis1d2ž_pie1k2c_aiz1k2c_bez1k2c_pār1k2c_eks1k2c_vis1k2c_pie1k2ņ_aiz1k2ņ_bez1k2ņ_pār1k2ņ_eks1k2ņ_vis1k2ņ_pie1š2m_aiz1š2m_bez1š2m_pār1š2m_eks1š2m_vis1š2m_pie1g2v_aiz1g2v_bez1g2v_pār1g2v_eks1g2v_vis1g2v_pie1h2l_aiz1h2l_bez1h2l_pār1h2l_eks1h2l_vis1h2l_pie1k2ļ_aiz1k2ļ_bez1k2ļ_pār1k2ļ_eks1k2ļ_vis1k2ļ_pie1s2l_aiz1s2l_bez1s2l_pār1s2l_eks1s2l_vis1s2l_pie1t2v_aiz1t2v_bez1t2v_pār1t2v_eks1t2v_vis1t2v_pie1š2ņ_aiz1š2ņ_bez1š2ņ_pār1š2ņ_eks1š2ņ_vis1š2ņ_pie1š2p_aiz1š2p_bez1š2p_pār1š2p_eks1š2p_vis1š2p_pie1d2z_aiz1d2z_bez1d2z_pār1d2z_eks1d2z_vis1d2z_pie1f2l_aiz1f2l_bez1f2l_pār1f2l_eks1f2l_vis1f2l_pie1k2n_aiz1k2n_bez1k2n_pār1k2n_eks1k2n_vis1k2n_pie1p2ļ_aiz1p2ļ_bez1p2ļ_pār1p2ļ_eks1p2ļ_vis1p2ļ_jā1s2pļ_ne1s2pļ_ie1s2pļ_no1s2pļ_pa1s2pļ_sa1s2pļ_uz1s2pļ_ap1s2pļ_at1s2pļ_iz1s2pļ_jā1s2kl_ne1s2kl_ie1s2kl_no1s2kl_pa1s2kl_sa1s2kl_uz1s2kl_ap1s2kl_at1s2kl_iz1s2kl_pie1k2b_aiz1k2b_bez1k2b_pār1k2b_eks1k2b_vis1k2b_pie1s2m_aiz1s2m_bez1s2m_pār1s2m_eks1s2m_vis1s2m_pie1m2n_aiz1m2n_bez1m2n_pār1m2n_eks1m2n_vis1m2n_pie1š2n_aiz1š2n_bez1š2n_pār1š2n_eks1š2n_vis1š2n_pie1v2r_aiz1v2r_bez1v2r_pār1v2r_eks1v2r_vis1v2r_pie1b2l_aiz1b2l_bez1b2l_pār1b2l_eks1b2l_vis1b2l2b3dams_2c3dams_2č3dams_2d3dams_2f3dams_2g3dams_2ģ3dams_2h3dams_2j3dams_2k3dams_2ķ3dams_2l3dams_2ļ3dams_2m3dams_2n3dams_2ņ3dams_2p3dams_2r3dams_2s3dams_2š3dams_2t3dams_2v3dams_2z3dams_2ž3dams_2b3gans_2c3gans_2č3gans_2d3gans_2f3gans_2g3gans_2ģ3gans_2h3gans_2j3gans_2k3gans_2ķ3gans_2l3gans_2ļ3gans_2m3gans_2n3gans_2ņ3gans_2p3gans_2r3gans_2s3gans_2š3gans_2t3gans_2v3gans_2z3gans_2ž3gans__ne3aiz14d5ze1me_tur2p1mil2k1tiemē1ne2š1pa2t3stāpa2s2t3kpa2s2t3mpa2r3ketpir2m2s1ak3me4ņ3aug2s2t3bal2t3ma");
            put(9, "d_vi1s2a_d_vi1s2ā_d_vi1s2i_d_vi1s2u__pie1s2tj_aiz1s2tj_bez1s2tj_pār1s2tj_eks1s2tj_vis1s2tj_pie1s2tr_aiz1s2tr_bez1s2tr_pār1s2tr_eks1s2tr_vis1s2tr_pie1s2pr_aiz1s2pr_bez1s2pr_pār1s2pr_eks1s2pr_vis1s2pr_pie1s2kv_aiz1s2kv_bez1s2kv_pār1s2kv_eks1s2kv_vis1s2kv_pie1s2kr_aiz1s2kr_bez1s2kr_pār1s2kr_eks1s2kr_vis1s2kr_pie1š2pr_aiz1š2pr_bez1š2pr_pār1š2pr_eks1š2pr_vis1š2pr_pie1s2pļ_aiz1s2pļ_bez1s2pļ_pār1s2pļ_eks1s2pļ_vis1s2pļ_pie1s2kl_aiz1s2kl_bez1s2kl_pār1s2kl_eks1s2kl_vis1s2kl2b3da3ma_2c3da3ma_2č3da3ma_2d3da3ma_2f3da3ma_2g3da3ma_2ģ3da3ma_2h3da3ma_2j3da3ma_2k3da3ma_2ķ3da3ma_2l3da3ma_2ļ3da3ma_2m3da3ma_2n3da3ma_2ņ3da3ma_2p3da3ma_2r3da3ma_2s3da3ma_2š3da3ma_2t3da3ma_2v3da3ma_2z3da3ma_2ž3da3ma_2b3ga3na_2c3ga3na_2č3ga3na_2d3ga3na_2f3ga3na_2g3ga3na_2ģ3ga3na_2h3ga3na_2j3ga3na_2k3ga3na_2ķ3ga3na_2l3ga3na_2ļ3ga3na_2m3ga3na_2n3ga3na_2ņ3ga3na_2p3ga3na_2r3ga3na_2s3ga3na_2š3ga3na_2t3ga3na_2v3ga3na_2z3ga3na_2ž3ga3na_2b3nieks_2c3nieks_2č3nieks_2d3nieks_2f3nieks_2g3nieks_2ģ3nieks_2h3nieks_2j3nieks_2k3nieks_2ķ3nieks_2l3nieks_2ļ3nieks_2m3nieks_2n3nieks_2ņ3nieks_2p3nieks_2r3nieks_2s3nieks_2š3nieks_2t3nieks_2v3nieks_2z3nieks_2ž3nieks_2b3nī3ca_2c3nī3ca_2č3nī3ca_2d3nī3ca_2f3nī3ca_2g3nī3ca_2ģ3nī3ca_2h3nī3ca_2j3nī3ca_2k3nī3ca_2ķ3nī3ca_2l3nī3ca_2ļ3nī3ca_2m3nī3ca_2n3nī3ca_2ņ3nī3ca_2p3nī3ca_2r3nī3ca_2s3nī3ca_2š3nī3ca_2t3nī3ca_2v3nī3ca_2z3nī3ca_2ž3nī3ca_2b3ša3na_2c3ša3na_2č3ša3na_2d3ša3na_2f3ša3na_2g3ša3na_2ģ3ša3na_2h3ša3na_2j3ša3na_2k3ša3na_2ķ3ša3na_2l3ša3na_2ļ3ša3na_2m3ša3na_2n3ša3na_2ņ3ša3na_2p3ša3na_2r3ša3na_2s3ša3na_2š3ša3na_2t3ša3na_2v3ša3na_2z3ša3na_2ž3ša3na_2b3ta3la_2c3ta3la_2č3ta3la_2d3ta3la_2f3ta3la_2g3ta3la_2ģ3ta3la_2h3ta3la_2j3ta3la_2k3ta3la_2ķ3ta3la_2l3ta3la_2ļ3ta3la_2m3ta3la_2n3ta3la_2ņ3ta3la_2p3ta3la_2r3ta3la_2s3ta3la_2š3ta3la_2t3ta3la_2v3ta3la_2z3ta3la_2ž3ta3la_2b3tu3ve_2c3tu3ve_2č3tu3ve_2d3tu3ve_2f3tu3ve_2g3tu3ve_2ģ3tu3ve_2h3tu3ve_2j3tu3ve_2k3tu3ve_2ķ3tu3ve_2l3tu3ve_2ļ3tu3ve_2m3tu3ve_2n3tu3ve_2ņ3tu3ve_2p3tu3ve_2r3tu3ve_2s3tu3ve_2š3tu3ve_2t3tu3ve_2v3tu3ve_2z3tu3ve_2ž3tu3ve__priek2š1_spil2g1tpa2s2t2s_pa2r2k2s_");
            put(10, "d_vi1s2os_2b3da3mās_2c3da3mās_2č3da3mās_2d3da3mās_2f3da3mās_2g3da3mās_2ģ3da3mās_2h3da3mās_2j3da3mās_2k3da3mās_2ķ3da3mās_2l3da3mās_2ļ3da3mās_2m3da3mās_2n3da3mās_2ņ3da3mās_2p3da3mās_2r3da3mās_2s3da3mās_2š3da3mās_2t3da3mās_2v3da3mās_2z3da3mās_2ž3da3mās_2b3nie3ce_2c3nie3ce_2č3nie3ce_2d3nie3ce_2f3nie3ce_2g3nie3ce_2ģ3nie3ce_2h3nie3ce_2j3nie3ce_2k3nie3ce_2ķ3nie3ce_2l3nie3ce_2ļ3nie3ce_2m3nie3ce_2n3nie3ce_2ņ3nie3ce_2p3nie3ce_2r3nie3ce_2s3nie3ce_2š3nie3ce_2t3nie3ce_2v3nie3ce_2z3nie3ce_2ž3nie3ce_2b3ša3nās_2c3ša3nās_2č3ša3nās_2d3ša3nās_2f3ša3nās_2g3ša3nās_2ģ3ša3nās_2h3ša3nās_2j3ša3nās_2k3ša3nās_2ķ3ša3nās_2l3ša3nās_2ļ3ša3nās_2m3ša3nās_2n3ša3nās_2ņ3ša3nās_2p3ša3nās_2r3ša3nās_2s3ša3nās_2š3ša3nās_2t3ša3nās_2v3ša3nās_2z3ša3nās_2ž3ša3nās_1pa1d2smit");
            put(11, "d_vi1s2iem_2b3da3mies_2c3da3mies_2č3da3mies_2d3da3mies_2f3da3mies_2g3da3mies_2ģ3da3mies_2h3da3mies_2j3da3mies_2k3da3mies_2ķ3da3mies_2l3da3mies_2ļ3da3mies_2m3da3mies_2n3da3mies_2ņ3da3mies_2p3da3mies_2r3da3mies_2s3da3mies_2š3da3mies_2t3da3mies_2v3da3mies_2z3da3mies_2ž3da3mies_");
        }
    }), ru("ru", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "1г1ж1м1п1ф1ц1ш1щъ1ы1ь11э1ю");
            put(3, "а1ба1да1еа1иа1ка1уа1ча1я1баб1вбг21бе2бжб1л1боб1т2бф2бц2бш2бщ1бы1бь1бя1вав1дв1л2вмвф22вц2вш2вщвъ21вы1вяг2а2ггг2и2гп2гф1дадв21де1дид1л1до2дп1ду2дфд1х2дщ2дъ1ды1дяе1а2ебе1ее1и2еоеэ2е1яжг2ж2м2жф2жц2жъ2зг1зе1зиз1лз1н2зт1зу2зцз1ч2зш1зы1зяи1аи1еи1ии1ки1л2ипи1ри1ти1чи1я2й1йд2йя12кг1ке2кмк2о2кп2кск2у2кф2кц2кш1кьк2ю2лб1ли2лм1ло2лпл1т2лцл1чл2ю1ля2мж2мм2мп2мф2мц2мщ2мэм2ю1на2нг1не1нин1л1но1нун1х2нц2нш2нщ1нын2э1няо1вог2о1ео3и2ойо1ко1т2оюо1япе1пх22пц2пш2пщ2рг2рз2рм2рп2рф2рх2рц2рш2рщ2рър2ю1сасг2с1зс2мс1н1сосп21ср1сусч2сш21сы1ся2тг2тжтм22тф4тц2тщ2тъ2ть2тэт2юу1ау1еу1иу1оу1у2уэу1я2фгф4и2фм2фф1ха2хг1хе1хи1хохп22хшца12цгци12цм3цу2цц3цыцю11чач1в1чеч2ж1чи1чм3чо1чуч2хш2в2шм2шфш1х2шц2шь2щмъю2ъя2ые2ыи2ыу2ьб2ь2еь2оь2юь2яэ1в2эгэ2мэ2нэ2пэс1э2фэх2э2цэя2ю1аю1бю1вю1ею1ию1к2юмю1хю1чю1яя1ея1ия1кя1ля1уа1ё1бё1дёе1ё2ёб1зёи1ё1кё1нёо1ёпё1у1ё1чёь2ёю1ё");
            put(4, "_аи2_ау2_ии2_ио2_ис3_ль2_оз4_ск2_ст2_уб2_уд2_уе2_ук2_уо3_уп2_ус2_ую2_юс14а3ааа2паа2раа2ца3буав1ва1веа1виа1воа2вта1вуа2вх2агаа2гд2агоа3гу2адва2длад2цае2ла2епае2сазв2азг2аз1ра2ихак1в1аккак2лак1са1лаа1леа3лиа1луа1лыа1лю2амаамб42амоа2мчан1ра1нь2а1оао2дао2као2рао2с2апоа1раа1реа1риа1роа1руар1ха1рыа1рюа1ряа1таа1тиа1тоа1туат2ха1тыа1тюа1тяа2убау2дау2хау2чауэ1ах2аах3с2ачаа2члач1та2шла2эрая2бая2вая2зба1зба2о2б1ббвы22б1д3бев3бее3бец2бещб1з21б2и3биаби2б2биж3бик3биоби1х2б3к2блы2бля2б3н3бот2бр_2брсб1ру2брьб1ряб3скбс4л1б2убу1с2б1х2б1чбы2с2бь_2бьс2бьтбэ1р3б2ю3вагва1звах13вац3вая2в1бв1вив1вр2вг21вев3вег1вее1вез1вес1вец1вею1веявзг2взд2взъ21визви1овиу3ви2ф2в1квк2лв2ла2вли2влю2вля1вме2в1нвно1в3нывов21вод1воквоп21вох1вою2вп22вр_1врюв1ряв1т21вуаву3г2вуиву3п1вхо2в1чвып2вых22вь_1вье2вьс2вьт1вью1вья1в2юга1зга2у2г3бгба2г1ви3ге_2г3ж2г1з2г1кг1ле2г3мг3няго1з3гойг2ол3гою2гр_2грюг4саг4сб2г3тгу1вгу1с2г1ч2г3ш2г3эда1зда2о2д1бд1ве1двид3вкд1вл2двя2дг23дез2дж_2джсдип2диу3ди1х2д1к2д1нд3надо1здоп2до1с2др_д1ред1рид1рыд1рядск22д1тду3гду2оду1х2дцу2дцы2д1ч2дыг2дыд2дыт2дыщ2дь_1дье2дьк2дьт1дью1дья1д2юеа2деа2зе1вее1вие1вое2вте1вуе1вхе1вьег2дед2жее2хе2жг2ежее3зее3зяеи2деи2меи2ое1каек2зе1кие1куе1лае1лее1луе1лые1люе3ляе2мче3наенс2е1нэе1оде2оие2омеоп2еос22епее2пле4пн2епое4пте1рае2рве1рее1рие1рое1руе1рые1рюе1ряе1сге1ск2есле3со2еспе1сте1тае1тие1тоет1ре1туе1тые1тюе1тяе1у22еубеуз2еф2л2ецве1чле2шлею2гея2зжа1з2ж1в2жгаж2гиж2гу2ж1дж2диждо3жду14ждь3жев2жжаж2жежи1о2ж1к2ж1лж3ма2ж1нжно1жоу32жп2жпо1ж2ру2ж1с2ж1ч2жь_2жьс2жьт1за1заа2заб2заг4зап2зас2зат2зау2зах2зая2з1б2з1вез1виз1воз1вр1звуз1вьз3га2зж2з3з23зи_3зис3зич2з1кзко12зм2з3мн2зне2зно2зну1зов1зое1зои1зон1зоозос21зохзош21зоэ1зоюз1раз1роз1руз2рюз1ря2з1сз1ти3зу_зу1в3зуе2зупзы2з2зыщ1зье1зьи1зью3зья1з2юи2аби2авиаг2иао2и2апи2аф2и1би1вии1ву2ивыиг2ди3ге2игли2гни1двид1ри1дьие2гие2дие2ри1зоиз1рийс2и3кои3куилп2и2ль2имаи3мии2мчинд21инжинс21инф1инъи1оби2оги1оди1ози1они1ори1ошип3ни2рви2рж1ирри2сби2сдис1ки4сси1сти2тми1у2иу3пиф1ли2фри1хуи2штию4лию2нию2тия2дйно1йп2лй2сбй2снй2сшй2тмй2хм1кавк2ад1кае1кай1кам1кан1кат1ках1каю2к1бк1вик1ву2к1дкда22кеа2к1з1кивки1о1киткк3ск3лы2кль1клю2к1н1ков1код1коз1кос1кош2кр_кс3гкс3мк3сок3су2к1ткт2р3куе1куй3кум1кур1кут2к1ч1ла_1лаел2аклау11лаял1брл1вел1вил1вол1вул2гллго11ле_1лен1лехл1зо2л1клк2в2л1лл2льллю12л1нлс3б1лу_лу1влу3г1луе1лунлу1с1лую1лы_1лые1лыж1лый1лым4ль_2льд3лье3льи2льк2льм2льн3льо2льт2льц2льч3лью3лья1лю_1люж3ля_2ляд3лям3лях3магма2умаф23мач4м1бм3бимб2л2мг22м1д3мкн2м1л2м1н3мод3мон3моп3мофмп2л2мрим1ры2м1смс2кмс2н2м1тмфи32м1х2мш2мым1мы2с2мь_2мьсмью1мэ1рмя1р2нач2нащ3ная2н1внг4лнг2р2н1днд2жн2длн2дцнег23недне3енеи23неунея23нийниу3ни1х3ниц3нищ2н1кнк2внк2лнк1с2н1нноб2ноэ2н3п2н1ро2н1сн2сгн2слн2сн2н1тн2тмну1х3ную2нф2нхо12н1чн2члнш2т3ны_2нь_1нье1ньи2ньк1ньо2ньс2ньт2ньч1нью1нья1н2юо3авоап12оба1обмоб1р1объ2обьов2то2вхо1дьое1бое2дое1оое2цо1зооие3ои2зои2мои2оойс2ок2в1окто3лао1лео3лоо1луо1лыо1люо3ляо3ма2омеом2чо2мьо3наонд2о1нронс2о1о2о2оло2офо1рао1рео1рио1ро2орцо1рыо1рюо1ряос2бо1ст2осхотв21отг1отдо3тио2тм1отхо1у2оуп2о3фе2охио1хро1хуо2цооч2ло1чтош2тоя2воя2доя2зпа3ф2п1дпе2з4п3к2пл_2п1нп3нап3ны3пой2пп22пр_при12прсп2руп3со2п1тп3ту3пуб2пф24п3ч2пь_2пьтп2ю11ра_раа21раю1рая2р1бр1вир1вор1вьр2гвр2гнрг2р2р1дрд2жр2длр2дц1ре_р1зори3ариб2р2ин1риу1риц1риш2р1кр2кврк1ср2льрлю1р3ляр2мч2р1н1ро_1роу2р1р4р1срс2кр2снрс2п2р1тр2тм1ру_1рулрф2лр2хврх1лрх1рр2цв2р1чр2члр2чмрш2т1ры_1рыб2рыз1рым2рь_1рье1рьи2рьк2рьс2рьт1рью1рьярэ1л1рю_1рюс1ряю1сб2с2бы2сбю1с2вс2гис2гнс2го1сд2с2дас2дес3дис2до1с2е1с2ж1с2и3сизси1х4ск_ск2л2скнск2рск1с2сль2снос2овсо1дс3пн2спь2ср_2с1сс2сбсс2лс2снсс2псст2сс2ч2ст_2стбс2те1сти2стк2стм2стн2стп2стс2стф2стц1стыс4тьсу2бсу1всу2зсу1хс1х22сца2сцо1счас1чл2счос3шн1съ2сы2зсы2с2сь_1сье2ськ2сьт1сью1сьясэ1рс2эс1с2юсю1с2сяз1тагт2ан1тас1тащ2тв_2тви2тву2твы2твя2т1д1т2ете1д2т1зтии2тик23ткн2т1лт2льт3мщ2т1нто1д1тощ2тп22трб2трв2трг2трд2трм2трн2трп2трр2трф2трщ2трът1рыт2сб2т1тт2тм1тущ2т1х2т1ч2тш24ть_3тье3тьить2м4тьттью1тю1т1тяг1тяж1тяпу2асуб1ру1виув2лу1воу1вуу2гву2глу2гнуд2ву3дууе2дуе2луе1суе2ху2жжу1зоу1каук1ву1киу1коу1лау1леу1луу1люу2мчу3нау1ньуо2буо2вуо2куо2пуо2суо2фу2плу1рау1реу1риу1роу3руу1рыу1рюу1ряу1сгус2лу1сму2снус2пус3су1сф2усцу2счу2сьу1тау1тиу1тоу1туу1ты1утюу1тяууг2уу2су3фиуф1лу2фру2хвух1лух1р1учру1чьу3шеу3шиу2шлу2шпуя2зфа2х3фашфаэ12ф1б2ф1в2ф1дфи2жфи1о3фит2ф1кф2лаф2лиф2ло2ф1н3фон3фотф1риф1роф1ру2ф3с2ф1тф2тм2фуф2ф1ч2фш22фь_ф2ю1ха2дхао32х1б1х2вх3вых3д2хео3х1з2хие2х1к2х1лу2х1нхоп2хоф2хоя2х1рых1ря2х1т1ху_2хуе2хуй1хун1хус1хуш2хуюх1х2хью13ца_3цам3цах2ц1бц2ве2цвы2ц1дце1зце1кце1т2ц1зцип2циу32ц1л2ц1н2цп22ц1р2ц1с2ц1тцы2п2ч1б2ч1дче1очжо23чик3чиц2ч1кч2ле2чли2чма2чмеч2мо2ч1н2ч1сч2те2чтм3чук2ч1ч2чь_1чье1чьи2чьс2чьт1чью1чья2ш1бше1кш1лыш2лю2ш1н4шниш2п2ш3пр2ш1р2ш1сш1ти2штс2ш1ч4шь_3шье3шьи3шью3шьяш2ю1щеи2ще1сще1хщеш22щ1н2щ1р2щь_ъе2гъе2дъе2лъе2съя3ны2блы3гаы3гиыг2лы2гны2длыз2ды2злы2зныиг1ык2лык1сы2льы2мчы3поыр2вы3саы3сеы2сны3соыс2пы2схыс2чы2сшыт2ры3шьь2вяь2дцье1кь2знь2и1ь2кльмо1ьс2кь2снь2тмьхо2ь2щаь2щеь2щуья1вэв1рэд1рэк1лэкс1э3маэ3ньэо2зэ1реэ1риэ1руэ1рыэск2эс3мэ2соэ2теэхо3ю2бвю2блю1дьюз2гю1зою1лаю1лею2лию1люю2мчю2нью1о1ю1раю1рею1рию1рою1рую1рыю1тию1тою1тую1тыю2щья2бря1воя1вуя2гняд1вяд1ря1зояк1ся2лья2мья3наянс2я1рая1рия1роя1рьяс1кяс1ляс2тя1таят3вя3тия1тоя1туя1тыя1тяях1ля1хуяце1я2шл2яю_2я1я6зь_й2кь6тр_а1вёа1лёа1рё1веё1вёз1вёс1вмё1вьёг1лёд1вёд1рё1дьёе1вё2ежёе3зёе1лё2епёе1рёё1веё1воё1ву2ёжеё3зеё1каё1киё1куё1лаё1леё1луё1лыё2мчё3наёнс22ёпеё2плё4пн2ёпоё4птё1раё1реё1риё1роё1руё1рыё1ск2ёслё3соё1стё1таё1тиё1тоёт1рё1туё1тыё1тюё1тя3жёвж2жёз1вё2знё3зуё1каё3куё1лён1лёх1луё3льёне3ё1ньёо1лё2омёо1рёо3фё1рьёс2дё1с2ёс2тё1сьё1т2ё3тьё_уё2у1лёу1рёу3шёц2вёч2тё1чьё3шьёы3сёь2щё_не88не_8бъ_8въ_8гъ_8дъ_8жъ_8зъ_8къ_8лъ_8мъ_8нъ_8пъ_8ръ_8съ_8тъ_8фъ_8хъ_8цъ_8чъ_8шъ_8щъ_");
            put(5, "_аб1р_ади2_ак1р_би2о_го2ф_дек2_ди1о_до3п_епи3_за3п_иг1р_изг2_из3н_ик1р_ле2о_на1в_на3т_не3т_ово1_ог3н_ос2п_от1в_ри2ч_ро2х_су2ж_тиа3_ти2г_ти2о_ум2ч_ур2в_ут2ра3блааб2люаб1риав3зоави2ааво1са2вотав1раав2сеа2глеаг2лиа2двеад2жиад1роаду3ча2дынае2гоае2диае2реаз1влаз1драз1обаи2г1аи3глако3т2акриа3лаг2алекало1залу2ша2льщ2аметамои2а2нафан2спанс1уаост1а3плаап2ра1аргуар2жа2ас1кас3миас3ноа1сьи1атакат3ваат1виат1ву2атезато2шат1риа1тьеа3тьюа3тьяау3доа2улеаут1рау3чьа2ф1лахми2аэ2лиаю1таба2бвба2дрба3зубалю1бас3мба1стба1трбе2глбе2гн3бе2збе3зибез3нбез1рбес3пби2обби2одби2онби2орби2тв1благб2ланб3ленб2луд2б2льб2людб2люеб2люлбо3вшбо2гдбо1з2бо2мчбо3мшбону1бо1рубо2сабо1скбо2твбот2рбоя2рб3рабб2равб2ран1брасб1рахб1рейб1рекб2ремб2рехб2ридб1рол1б2рю2б1с2бук1лбы2г1быс1кбыст1бю1тава2брвадь2ванс2ва1ства1трв2дохвед1рве3ду3везе3везлвез2у1вей_ве2п12вердвет3р1в2з2взо1бви2азви2акви2арвиа1тви3афви2гвви2гл1винт1винчв2левв2лекв2летв2лечв2лияв2люб4в3нав2несв3ну_во1б2во3вкво1двво1дрво2ерво2жжво3м2во1ру2ворц2ворьвос1кво1смво1снвот2рво1хл2вра_в2равв1рас2врац2вре_1вридв1риив1рикв1рилв1рисв1рит2в1ро2в1ры2в1с23все33в2сп3в2сювто3ш1ву1з2ву1кву1с2вух3вву1члвы3г2вы3знвы3т21вьин1в2э1г3дан2г3диге2б1гено1ге2обге2одге1орги2блги3брги2грги1слгист22гла_г2лавг1лай2глаяг2лет2гли_г2лин2гло_2глов2глог2глое2глой2глою2глую2г1лыг2ляж2глякг2навг2нанг3не_г2невг3ненг3непг3несг2нирг2ноег2ноиг2носго1б2го2влго2злгоз2нгоиг2гоми2го2сдго1сн2готдгоу3тго1члг1раег1райг1рарг1регг1рекг1рецг1рикг1рилг1ринг1рисг1ричг1ровг2розг1рокг1ронг1ропг1ротг1рофгру2пг1рывг1ряег1рялг1рят2г3с2да2б1да2грдат1р2двиз2дводд1воз2д1д23деврде2зиде2зудеио2де1кл3демеде2оддео3пде3плдес2кде2срде1хлд2жамд2ж3м2д1з2ди2аддиа2зди2арди2асди2обди2ордио1сди2пиди3птди3фрд2лев2д3м2днеа2днос24д3ныдо2блдов2лдо1д2до3дндоз2ндои2р2доктдо3плдос2п2дотд2дотл2дотъдо3ть3дохлдо2щуд1рабд1рард1рахд1рачд2раюд2реб2дрезд2релд2ремд2рий2дринд2рипд2рихд1родд1роед1ройд1ролд1ронд1росд1ротд1роюд1руб1друг1дружд1румд1рую2дрывд2рябд2рях2д1с2дс3кндуб3р2д1удду2дадуп1лдус1кд1услду1стду2чидуэ1т2д3це2д3ш2дъе2м2дымедь3яреади3еа3доеат1реба2се1браеб1рие1броеб1ры2евер2еволев1риев2хое2глее2глие2глоег2наег2но2ег2ред1вое1джее2дохе1друе2дуге2дусе2дынее2гиее1с2ее2стеж3дие2ж1резау3езд1реззу3е3зитез1обе1зомез1опез1отез1ошез2ряез1упез1усеи2г1еис1лека2б2е1ко2е1крек2роек1скеми3кемо1с2емуж2емыс2е1нрен3ш2е1о2бео3даео2деео2дое1о2жео3кле1ол_е1олаео3лие1олке1олые1олье1он_е2онае2ониео3ное1онсе1опеео2прео4пуео1ске1осме1оснео3схе1отле1о2че1о2щепат2е3плаеп1луе3плые4п3сер1вее3ре_ере3перо2б2еролер3ске3с2аес2бае2скее1слуе1слые1с4ме2спуе2стле3стует1веет1вие1тво2етечето1сет2ряе1тьее3тьюе3тьяеуб3реф1рееха2тех1обех1реех1ружа2блжа2бржат1в2ж1б23ж2глж2дакж2дачж2деп4ж2дл3ж2дяже3д2же1клже1о2же3п2же1с2же3ск2жжев2ж1з22жирр2ж3мо2ж1обжоу1сз1авуз1адрзае2дзае2хза3з2з1акт3з2анза3назанс2зар2взар2жзаст2за3ткзач2тза3ш2з2вавз2ван2зваяз2везз3в2кз1вла2зволз2глизг2наз2гнуз1д2вз2дешздож3зе2б1зе2евзе2од3зий_з1интзи2оззи1опзиу3мз2лащз2лобз2лопз2лорз2лющ2зна_з2навз2наез2найз2накз2нанз2натз2наю2зная2з3ни2з3ныз2обезо2бизо2глзо1дрзо1з21зой_1зок_з1окс1зол2зо1лгзо1лжзо3м21зом_2зомн2зонрзо2осзо2паз2оплз2опрз1оргз1оснзо1спзо2твз2отез1откз2отозо2шиз2ракзра2сз2рачз2ренз1ресз2риш2зуве2зу2г2зу1к3зумезу2прз1урбзъе2м2зыме2зымчи2агри2адеи2адииа2муи3анаианд2и3атуи2а1хиа2цеи2б1р2иваж2и1веи2в3з2и1вои1в2ри3в2сив2хои2глеи2глиигни3иг1роиг1руиг1рыи2дейи1д2жие3деие2зуи3ениие1о2иепи1и3ж2диз1в21из1дизо2ои3к2аик2ваи2квии2кляик1роик1скильт2имои2им3пли2м1рим2чаино1с1инсп1инсуио2боио2врио2деио3зои1окси1олеи1опти3ораио1руио2саи1отаи1отки1отсиоуг2ио2хоипат2ип2ляириу3ис3кеис3киис1лыис3меис3муис3нои2стли1сьиита2вит3ваит1виит1вуи2т1ри3тьюи3тьяиф2люиха3ди3х2оихо3ких1реих1рииш2лии2шлыию3тай2д3вй2о1сйо2трй3скайс2кейс4мой2с3фйх2с3ка2блказ3нка1зо1кал_1кало1калс3к2аска1стк2вакк2васк2вашк2возке2глкед1ркиос1ки2пл2к1к22клемк3ленк1леок2ликк2линк3лияк2лозк3ломкло3т1клук2кля_2клям2кляхк2ноп3ковако1др3конскоп2рко1руко1сккос3мко1сп1котнко2фрк1релкре1ок1реч1крибк1ридк2ризк2ритк1рихк1роак1робк2роек1рокк1роок1рорк1роск1рофк1рохк1роэкру1ск1рядк2с3вк2с3дк2сибк1скикс1клк1скокс3тек1стокс1трк1стукта2ккто1ску1ве1кулякуп1лку3рокус1кку1стку3ть1куче1куют3кующ2к1х22лабела2бл2лагола2грла1золак2р1лам_ла2усла2фр1ла1х2л3д2ле1влле1джле3доле1зрлек1л2лемнле2сбле2скле1твле1хрлиа2м3ливо3ливылиг2ллие3рли2кв2лимплио1сли2пллис3мли2твлиу3мли1хлли1хрл2к1ллни2ело2блло2влло1др2лоенло1звло2клло2рвло1рулос1к2лотдлот2рло2шл2л1с2лу1брлу1знлу1крлуо2длу3ть2л3ф22л1х2л2х3в1лых_2льск1льща1льще1льщу1люсьлю1таля1ви3ляво3лявыля1реля1рума2взма2гнма2дрма2дьма1зомас3лма2чтм3бля2м3в23м2глмеан2ме2егме2елме1зомеч1т2м1з2ми1зв2миздми1знми2крми2озми2ор2м1к2м2леем2лел4м3намне1д4мноем2нож4мной4мномм2нор4мноюм2нут4м3нымо1б2мо3влмо1дрмо2жжмо1звмо1зрмо3м2мо1румо1сммо1сн3мотим1раб2м1рому1стмут1рму3тьм2чавм2чалм2читм2чиш3м2щемы2мрмя1стнаб2рнаг2нна3ждна1з2на2илна2ин4наккнап2лна1с2на1твна1х2наэ1р2н1б2н2г1внги2онго1сн2дакн2д1внде3знде2сн3д2знд2рен2дрянд2спне1б22невннед2оне3дунее2дне1звне1знне1зоне1зрне1клне2олне3п2нес2кнест2не2фрне1хрне3шк2н1з2нзо1сни3б2ни2енни2клнила2ни1слнис3пнкоб2но1брно2влно1двно1дрно2ерно1звно2здно1зрно3кн3номеном3шно2рвно1руно2сч2нотдно3ф22н1ре2н1рин2с3внс2кен3слан2с3мнст2рнсу2рн2с3фн2съ3н2т1внт2рант2рент2рунт2рынут1рня1ви2о1а22обиоо1блюобо2с2обото3влаов3ноов2се2о3гео3гря2одано3де_о2дыно2дьбое2жиое1с2ое2сто2етоо3жди2озавоз2вио1здрозе1ооз3но2озоно2зопоз1уго2зымо3зысои2г1оиг2нои3мо2ок2ло3клюоко1бок1ск2окти2окумом2блом1риом2шео3мьяоно1боо3псоос3мо2отио3пако3паро2плиоп2лоо2пляоп2риоп2тоо1р2вор2тро1руео1руко1русо3садо2скеос1кио1с2лос3миос2пяос2свос2тао2сучо1с2чот3ваот1веот1виот1вло3терот1риот3смоту2ао3тьюо3тьяоус2коу3таоу3то2офаш2офит2офон2офото2фриох1лыо2хляох2ме2охороча1соч1лео3члиош3ваош2лаоэ1тиоя2рипави3пав3лпа2вьпа2дрпа2енпа1зопас1лпа2унпа1хупа2шт2п1в2пе2двпе3запе3зопе2льпе4плпе2снпе2сцпе2счпе2трпе2шт3пинк3пися4пла_пла1с2пленп1лею2плив2пло_2плов2плог2плый2плымп1лынп1лых2плю_п1лютп2лясп2ляшп3но1по1б2по3влпое2лпое2хпо1знпои2щ3полкп1оргпор2жпо1рупо1с43послпо3сспот2впот2рпо1х2поэ3мппо1д3превпре1зпрей2пре1л3претпри3вприг2при3кпри3лприп2п2риц3проипро3п2п1с2п3синп2т3впуг3нпу1стпу3тьпэ1рара2бл1рабора2гвра2глрад2жра2дцрак2в1ралг1рамк1рамн1раслрас3прас1трат1в2рахи1ращи2раятрб2лар2блерб2лорб2люрбо3ср3вакр3варр3вежр2вео1рветр3винр2витр2г1лрда1ср2д1врди2ардос2ре1вррег2нрее2врее2дрее2л1резкре1зррез2у1рейш1рекш3ремо1ренк1реньре1онре1опре1ох1репьре3р2ре1слре1счре1твре1чтре3шлр3жа_р3жамр3жанр3ж2др1з2ври3бр2риги2риджрие2лрие3рриз2врик2р1ринсрио2зрио2сри1отри3р2ри1с2ри3сб2риспри2флри3фрри1хлр2к1л2р1л2рнас4рне3оро2влро1двро1длро1др1родьрое2лрое2мрое2хро1зр1рокрро3псро1руро1ск1рослро1смрос2ф1росш1росю1роткроуг2ро2фрро1хлрош2лро3шн1роязрп2лор2плюрств2р2т1врт3варт2влрт1рарт1рерт1риртус1р3тьюрт1яч1рубаруг3н2руксрус1крус3лру3ть1руха1рухо1ручнр3ш2мры2двры2клры2х1ря1виса2блса2дьса2квса2клс1аппса1трса2унса1х22с3бусег2нсе1з2се1квсек1лсекс4семи1се2сксе2стси1омси1опси2пл2скам2скахск2вас2квис2кляс1кон2скошс1кра2скуе1слав1сладс1ламс3левс3леес1лейслео2с1летс3лею2слицс2ложс1люс2с3ля1смесс4меяс3мурс2нас2сная2сную2с3нысов2рсо1з2со3м2со1русо1сксо2сьсот2рсо1члсош2лс2павс2пеес2пелс2пенс2пехс2пешс2пеюс2пим2сполс2посс2рабсра2сс1ратсс3во4с5сис3с2к1ста_4ств_2ствлст2вя1стей1стелсте3хс3тешс2тиес2тиис2тичс2тиюст2ла2стли2стля1сто_1стов1стог1стод1стое1сток1стом1стон1стос1стотс2тоц1стою2стр_с1тут1стуюс2тыв2сть_2стьс3стью1стья1стям1стяхсуб1осу3глсу2евсу1крсума1супе2сус3лсус3псу1стсут1рсу2ф31с2фе1с2хе2с3цис2часс3чив2счикс2читсъе3дсъе3лсы2г1ся3тьта2блтаб2рта2гнта1з2та2плта1стта1тр2т1б22т2ват1вейт1велт1ветт1воет1вос2твою2т1врте2гнте1зо3текатек1л3текште1ох3терзтер3к3терятест2те2хотиа2мти2блти3д2тиис1т1импт1инд2тинж2тинфти1хр2т1к2тло2бтми2с2тобъто2влто1з2ток2р2томс2тонг1торг1торж1торсто1ру1торш2тотдто3тктпа1ттрдо2т1реат1регт1редт1реет1рецт1рею1трибт1ривт1рилт1римтри1от1риттри3фт1рищ2тройт1рортро3т2трою1трубт2руд2трукт2румт2рутт1ря_т1рявт1ряет1ряжт1ряйт3рякт1рятт1рящт1ряя4т1с2т2с3дтсеп2т2с3мт2с3пту2грту1слту1стту2фл1туша1тушо1тушьты2г12тя2чу2алеу3белубо1дубос21убрауб3рюу1ве_уг2науг2неуг1реуг1ряуда1суд1роуес2лу1з2вузо3пуко1бу1ку1у1лыху2озауост1уо2т1уп1люу3проурке3у2родурт2ру2садус1каус1киуск3лу1скрус3лиу1стеу1стяу3сьяу3терут2ляут1риу1тьеу3тьюуф2ляух1адуха2тух3ляу2чебуш1лафа2б1фа2гнфа1зофан2дфа1трфев1рфед1рфе1о3фи2глфи2зо2фобъфо2рвфо1руфос1кф1рабфра1зфра1сф1ратф2ренфре2сф2рижф2ризф2ронф2торфу3тлха2бл2х1акхан2дх1арш2х3ве2х3вихиат1хи1с2х1лавх1ласх1латх1лац1хлебх2лесх1летх3ло_х2лоп1х2му3х2ныхо2пехо1рух1осмхох1лх1раз1хранх1рейх2рисх1ров1хром2х1с2х1у2гх1у2рху3ра2х1ч2ца2плце1отцеп1лцес2лци2к1цик3лци2олци2скциф1р2ц1к2ц1о2б2ц1от2ц3ш2цып3лча2дрча2дцча2ер3чато3чатыче1влче2глчер2сче1сл1ч2лач3легч3лежч2ли_1ч2ло2ч1таша2блша2гнша2дрша1стш3венше2глше1о2ше3плше1с2ши2блши2плшиф1р2ш1к22шленш2ли_2шлив2шлилш2линш2лисш2лифш2ло_2шловш2лог2шляе2шлякш2ляп2шлят2шляч2шляю3ш2мыш2нуршу2евшуст12щ3в2ще2глщед1рщеис1ще3шкъе3доъ2е2ръе2хиыд2реы2дряы3ж2дыз2ваыз2наы2к1выко1зыре2хыс1киыс1куыт1виы3тьюы3тьяы2ш1лье1зоьми3дьми3кьне2оь2п1ль2стиь2стяьти3мь2тотьт2реьт2руьт2рыьхоз1ь3ягсэк2стэле1оэпи3кэс3теэт1раюзи2кю2к1вюре4мю2с1кю1стаю1стею1стою1стяюха1сяб1раяб3реяб1рияб3рюя1в2хя2г1ляз2гня2к1вя2к1ляст3вя1стояст1ряти1зя3тьюя3тьяа2ньшгст4ре2мьдзаи2лзао2ззаю2лз2рятзу2мьпое2ж2стьт6хуя_ы2рьмыя2вяьбат2а2двё2алёк2амёта1тьёб3лёнб2люёб1рёкб2рёмб2рёх3везёвёд1р2вёрдв2лёкв2лётв2нёс3всё3г2лётг2нёвг3нёнг2ноёд2рёбд2рёмдъё2м2евёре2глёер1вёет1вёе1тьёё1браёб1рыё1друё1зом2ё1ко2ё1крёк2ро2ёмужёпат2ё3плаёп1луё3плыё3ре_ёр3скё3с2аё2скеё3сту2ётечёто1сёха2тёх1ружё1с2з2вёзз2наёз2отёзъё2м2зымё2и1вёих1рёк3лёнк2роёлё3долёк1ллё2ск2лоён1льщё3м2щёнд2рёнё1б23номёоё2жио2скёот1вёо3тёрпё2тр2плёнп1лёюпоё2ж3прётр2блё1рвёт1рёзкрёз2у1рёкш3рёмо1рёнкроё2мсёкс4сё2ст2скуёс1лёт1стёлстё3хс3тёшт1вёлт1воётё2гнтё1зо3тёкатёк1л3тёкштёр3ктё2хоуг2нёуг1рёу1стёу3тёру1тьёу2чёб2х3вё1хлёбх2лёсчёр2с2шлёнъ2ё2рыд2рёырё2хьё1зояб3рё");
            put(6, "_аг1ро_аль3я_ас1то_аст1р_де1кв_ди2ак_до3т2_зав2р_ио4на_лес1к_люст1_ми1ом_мо2к1_на3ш2_не3вн_не1др_не1з2_не1сл_нос1к_нук1л_ос2ка_ос3пи_от1ро_от1ру_от1уж_по3в2_по3ж2_поз2н_прос2_ре2бр_ри2ск_септ2_те2о3_тиг1р_уз2наабе3ста3в2чеага1с2а2гитиа2глосаг2лотади2ода2д1руаза4ш3аз3веза2зовьа2зольа1зориаз2о1сак3лемако1б22аконсалуш1та2минтам2нетамо1з2ана2дцан2драан2сура2н1узап2ломапо4всап1релара2стар2бокар2валаре1дваре1олар2торар2т1р1ассигаст1вуас3темас2тинас2тияас1тооас1туха1стьеас2шедас2шесат1обеа2томнат1рахба2г1рбе2д1рбез1а2без5д4без1о2бе2с1кбе2с1тбес3тебес3ти1б2лазб3лази1б2лее1б2лея1б2луж2б3лю_бо1брабо1драбо1л2жбо1льсбо3м2лбо3скобо3стибра1зо1б2рал2б1рамб2рать1б2рач2б3рая1б2редб2ритоб2ритыб1ром_3брукс2б3рю_бу2г1рва2д1рва3ж2два2стрве2с1квзъе3д3в2кус2в3лаб3в2нук3в2нучвои2с1вос3пево2стрво3х2т2в1рам2в1рах2в1рен1в2ризвро3т2в3ская4в3ски4в3скувто1б2ву2х1а3в2шиввы3ш2лга1ст2г1лами2глась3г2лифг3лоблгнит2рго3ж2дго2с1аго1склго1спагу2с1кда2гендаст1р2д1вид2двинт2двинч2д1вис2д1вит1дворьде1б2лде1б2рдез1о2дерас2де2с3вди2алиди2алодио3деди1отиди3фто3дневн4д3но1дно3д23д2няшдо3в2мдо3ж2д2долимдо2м1р2допледо2предо2рубдот2ридо2ш3вдо3ш2кдо2шлы1дравш2дразвд1ране2д3реж1дрема1дремлдрем3н1дремы2д3рендре2скд2ресс1д2рож2д3роз1д2рыг1д2рягду2ста2дут1рды2г1р2ды2с1еб1ренеб1рове2б3рюе3в2меев2нимев2нятевра1с2е1вреев1рееев1рейев1реяега1с2е2гланедноу3ед1опре2дотве2д1още2дру_е2ду2бед1убое2дувеед1уст2е3душе2евидее2в1реест1ре4ждевеза2вре1з2ваез1о2гез1о2рез1у2дез1у2кезу2соезу2сыез1у2хез1учаеис1трек1стееле3скеле1сцеми3д2ен2д1реоб2рое2о3глео2гроеоде3зе2о3роеост1реот2руепа1трепис2кеп1лешеп1лющер1актере3доере1дрере1к2ере1х4ерио3зер1обл2ерови2ерокреро3ф2ес1кале2сковес1ласес2линес2ловес2ломес2пекес3полес2танес2четеук2лоефи3б2ех1атоех3валех3лопех1опоех1у2ч3ж2дел4ждемеже1к2вза2вруза3ж2дза3мнеза3р2д2з3ва_з3валь1з2вон2з1вуюзи2онози3т2рзко3п2зо3в2мзо2о3пзот2резот2ризро2с3зу2б3р2з1уз3з1у2моз1у2тезу2час2зы2г12зы2с1иа2зовиа2налиа1с2киа1стаиа1стоиат1роиг1рени2г1ряиди1омиди1оти2еводиз2гнеиз2налика1с2ик2с1тило1ски2менои2мену2имень1инстии3оновио3склио1с2пио2т1випа1трипо3к2ира2сти2р1ауири2скиро1з2ис3ка_ис3камис3кахис3ковис3ку_и2сламисо2ски2с3при2ст1вис1тязи2т1веит2ресит3роми2т1учи2х1асих2ло2ихлор1й2с3мука2брика3днека2д1рка2п1лка2прекар3трка1т2рка2ш1тке2с1кке2ст12к3ла_2к3ле_к3лем_2к3ли_2к3лив2к3лис2к3ло_2к3лос2к3лю_3к2ниж3к2няж1кольс2коминко2р3вкре2слкри2о3ксанд2к1стамк1стан3к2то_ку2п1рла3ж2д1лами_ла1сталаст1вла1стела1стола1стула1стяла1т2р1л2галлев1рале2г1лле1онтле1о2сле4скале1с2лле1спеле1т2рли2гро2л1испли2х3вло1б2р2ловия3ловодло2г3длого1слок3ла3лопас2л1оргло1с2плу1д4р1льсти1льстяма2к1р2м1аллма1с4тма2тобма2т1рме2с1кми2гремик1рими1опими1с2л3м2нешмоис1тмо2к3вмос1камо1с2пмо2т1рм2с1ор3м2стиму1с2кму1с4лнаби1она1в2рна3м2нна1рвана1т2рн1а2фрна3ш2лнд1рагнд1ражнд2риане1в2дне3вняне1д2лне2дране1дроне3ж2дне1з2лне1к2вне3м2н3не1о2не2одане1р2жне3с2нне1с2пне1с2хне1с2чне1т2вне3т2лне1т2р2нинспнист2рнко3п2н2к1ронно3п2но3з2оно1склно2слино1с2пн2сконн2с1окн3с2пентр1ажн2трарнтрас2н2тривн2трокнтр1удн2т1ря2н3ю2роб2левоб2лемобо3м2о2бра_о1браво1брано3в2лоо2в1риов3скоог3ла_ог3ли_ог3ло_од1вое2оди3а2о3димод2литодо3про2досио1драгод1ражод1разод1рако1дралод3ребо1дробод1рово2дымао2дымуо2е1вло3ежеко3ж2дуо1з2ваоз2вено1з2вяоз2глооз2доро2з1обозо1ру2о3кан2о3колол2ган1олимполу3д2о3множоне3ф2он2труоост1ро2пле_оп2литоп3лю_о3плясопо4всопоз2но3п2теора2с3ор2б3л2о3регоре2скор1испор1уксоса3ж2о2с3баос3кароск1воо2ски_о2сковос1койос1комос1коюос1куюос3лейос3логос3лыхос3мосос2нялос2пасо1с2пуос2с3мо3страос2цен2о3тек2о3техо3ткалот1работ1радот1разотра2сот1режот1рекот1речот1решот1родот1роеот1рокот1росот1рочот1ругот1у2чо2форио2ч1топас1тапа1степас1топас1тупа1тропери1опе2с1кпиаст1пи2ж3мпи2к1рп1лем_п1лемсп2ленкп1ле2оплес1к3п2ликпо3в2спод1вопо1звепо1здопо1з2лпо3мнопо3мну3по3п2по2шлопо2шлыпо2шляпре1огпри3д2приль2про1блпрод2лпро3ж2про1з2п1розопрофо23п2сал3п2сих3п2тихпус1кура2б1р1равняра2журра2зийра2зуб1ракизра2к3лра2нохран2сцра2п1лрас3к21растара2такра1т2р1р2вавр3ватарег2ляре2досре3ж2дре1з2лре1зна1ре1зоре1к2лре3мноре1о2рре1о2фре1о2црес1кире1с2пре3старе3сторе1т2рреуч3три3в2нри2глори3г2нри1д2рри3м2нри3м2чри3стври3т2рриэти2рне1с2рно3слро2блюро1б2р1рогол1рогруро3д2зрод2ле1розарро1з2в3розысрои2с31рокон1ролис1ролиц1ромор1ронаж1ронап1роносрооп1рро2плю2р1оргро1р2жро2скиро2скуро1с2п1рот2врот2рир3ствлр2таккр2т1обрт1оргрт2ранру2дар1ружейру1старуст1рр2х1инр1х2лор2х1опры2с1к2с1арк2с1атлса2ф1рсбезо3сбе3с22с3венсе2к1рсере2бсе3стасе3стесест1рс2канд1с2каф3скиноск3ляв2сконас2копс2скриб2с3ла_2с3лая2с3ли_2с3ло_с3лому2с3лос2с3лую2с3лые2с3лый2с3лым1с2наб1с2неж2с3никсно1з2со1б2рсо1л2гсо2риесо1с2п1с2пец2списяспо1з2сре2б1сре3доссанд2с3с2нес2сорист1верст2вол1с4те_1стен_с3тет_с3тете2стимп2стинд2стинф2стинъс2тишкс3т2лест2лилст2литс2то1б3с2тои2сторг2сторж2сторсстрас24страя2стредст1рей2стривст1риз2стрил2стрищст1роаст1родст1рохст2рубст1рушсуб1а2с2ценасы2п1лсыс1ката1вритак3лет1во1з2т1войтеле1отем2б1те2о3дте4п1лте2рактере2оте2скате2скути1знатила2м2т1инвти1с2лти3ствти3ф2р3т2кав3т2кан3т2кеттмист1то2бесто1б2лто3д2р2т1оммто1с2нто1с2пто1с2цт1рага2т1раж1требо1требут1ребьт1ревет1ревшт1резат1резнтреп1л3тре2стрес1кт1рестт1ретут2решь4тринст1роглт1роидтро3плт1росо4т3роц2т1рядту2жинты2с1к1у2бытуд1рамуе2с1кун2д1руро2длус1комус1ку_у3х4вофанд1рфе2с1кфиа2к1фи2нин2ф1оргфор3трфото3п2ф1у2п2х1изы1х2лор2х1о2кхо2пор2х1оснхри2плхро2мч2цетат2ц1о2дча2евоча2евычаст1вча1стеча1стуча1стячерст1ша2г1ршан2кршар3т2ша1тро3ш2кол2ш1лейш2лите4ш3мы_ще1б2лщи2п1лы2д1роы2к3лоынос3лыра2с3ье2с1кь3п2тоь2трабэри4трэро1с2эс2т1рэтил1аю2б1рею2идалюри2ск3явиксям2б3л_вст2р_реа2нбезу2свиз2гнвыб2редос2ня4ж3дик4ж3дичла2б1рлу3с4нни4сь_о2плюсоти4днпти4днреж4ди2стче_сы2мит2сься_аз3вёзам2нётас3тёмбё2д1р2в1рён2доплёдо2прё2д3рёж1дрёма1дрёмы2д3рёнеб1рён2е1врёерё3доерё1к2ес2чёт2ё1вре2ё3душёз1о2гён2д1рёс2танёх1атоёх3валёх3лопёх1опоза3мнёзот2рёиг1рёнла1стёлё4ска3м2нёшод3рёб2о3тёкот1рёкот1рёшп2лёнкплёс1к_рё2бррё1зна1рё1зорё3старё3стород2лёсе3стёсёст1р1стён_с3тёт_с3тётес3т2лётё4п1лтё2скатё2ску3т2кётт1ревёт2рёшьчёрст1");
            put(7, "_во2б3л_во3ж2д_за3м2н_ле2п3р_му2шт1_не1с2ц_обо3ж2_ра2с3т_ре2з3в_ро2з3в_ро2с3л_хо2р3в_че2с1ка2д1облаз2о1бра2н1о2бан1о2храпо3ч2тбили3т2б2лес1к2б3люсь1б2роди1б2росибро2с1кве2ст1вви2а1с2ви1с2ниво2б3лагри4в3нде2з1а2ди2с1тр2д1обладо1б2рад1о2сенд1о2син2д1осно2д1отря1д2разнд1ра2с3дро2г3неан2д1ре1д2лине1о2свие3п2лодере3м2не2р1у2пе2с1ка_е4с1ку_2ж1о2т1за2в1ри1з2о3ре2з1у2беи2л1а2ци2л1у2пино2к3лино3п2лисан2д1ки1с2ни2к3ласько1б2рикохо2р3ла2д1аглан2д1рла2ст1рле1з2о3лу3п2ломан2д1рме2ж1атме2ст1рна2и1с2на1р2вине2р1отни2л1ални2л1ам2н1инстнти1о2кобо1л2го3в2нуш1о2деяло2д1отчо2д1у2чоза2б3воко3п2ло3м2немо3м2нето2п1лейопо2ш3лоро2с3ло2с1ка_о1с2копо2с1ку_о1с2нимо1с2шивошпа2к3па2с1тыпе2д1инпе2к1лапе2ст1рподо3м2радо1б2рас3т2лрво1з2дремо2г3рес2с3мро2д1отро2ф1акр2т1акт2с1альп2сбе3з2сто2г3нс4т1ровсче2с1кте2с1ките2с1ко3т2ре2хтри2г1л2т1у2пруре2т3русла4ж3уто3п2сх1ра1с2ь2т1амп_бо2дра_об2люю_об2рее_об2рей_об2рею_об2рив_об2рил_об2рит_пом2ну_со2плаатро2скбино2скдро2ж3ж2дружейилло3к2ме2динсмис4с3ннар2ватне2о3рен2трассо4ж3девойс4ково2м3че_он2тратосо4м3нпо2додепо2стинпрем2норедо4плроб2лею2сбрук1б2лёс1кё2с1ка_ё4с1ку_1з2о3рёлё1з2о3о3м2нёмо3м2нёто2п1лёйпё2ст1рсчё2с1ктё2с1китё2с1ко3т2рё2х_чё2с1к");
            put(8, "_ар2т1о2_ме2ж1у2а2н1а2ме2д1о2бедло2к1а2ун2тр1а2го2д1о2пео2д1о2пыпо2д1о2кре2д1о2пр2т1у2чи_доб2рел_до1б2ри_па2н1ис_ро2с3пиди1с2лове2о3позиере3с2со2з1а2хавни1с2коло1и2с1трони3л2ампере1с2нсо2стритсо3т2калтро2етес_доб2рёлтро2етёс");
            put(9, "е2о3платои2л1а2минме2д1о2сммети2л1амо2д1о2болпо2д1у2роприче2с1крни3л2а3мпричё2с1к");
            put(10, "но4л1а2мин");
        }
    }), be("be", 2, 2, new HashMap<Integer, String>() {
        {
            put(3, "а1аа1еа1ёа1іа1оа1уа1ыа1эа1юа1яе1ае1ее1ёе1іе1ое1уе1ые1эе1юе1яё1аё1её1ёё1іё1оё1уё1ыё1эё1юё1яі1аі1еі1ёі1іі1оі1уі1ыі1эі1юі1яо1ао1ео1ёо1іо1оо1уо1ыо1эо1юо1яу1ау1еу1ёу1іу1оу1уу1ыу1эу1юу1яы1аы1еы1ёы1іы1оы1уы1ыы1эы1юы1яэ1аэ1еэ1ёэ1іэ1оэ1уэ1ыэ1ээ1юэ1яю1аю1ею1ёю1ію1ою1ую1ыю1эю1юю1яя1ая1ея1ёя1ія1оя1уя1ыя1эя1юя1я_б88б__в88в__г88г__ґ88ґ__д88д__ж88ж__з88з__й88й__к88к__л88л__м88м__н88н__п88п__р88р__с88с__т88т__ў88ў__ф88ф__х88х__ц88ц__ч88ч__ш88ш__ь88ь__а88а__е88е__ё88ё__і88і__о88о__у88у__ы88ы__э88э__ю88ю__я88я_б1бв1вг1гґ1ґд1дж1жз1зй1йк1кл1лм1мн1нп1пр1рс1ст1тў1ўф1фх1хц1цч1чш1шь1ьб8ьв8ьг8ьґ8ьд8ьж8ьз8ьй8ьк8ьл8ьм8ьн8ьп8ьр8ьс8ьт8ьў8ьф8ьх8ьц8ьч8ьш8ьь8ьд8зд8ж");
            put(4, "1б8а1б8е1б8ё1б8і1б8о1б8у1б8ы1б8э1б8ю1б8я1в8а1в8е1в8ё1в8і1в8о1в8у1в8ы1в8э1в8ю1в8я1г8а1г8е1г8ё1г8і1г8о1г8у1г8ы1г8э1г8ю1г8я1ґ8а1ґ8е1ґ8ё1ґ8і1ґ8о1ґ8у1ґ8ы1ґ8э1ґ8ю1ґ8я1д8а1д8е1д8ё1д8і1д8о1д8у1д8ы1д8э1д8ю1д8я1ж8а1ж8е1ж8ё1ж8і1ж8о1ж8у1ж8ы1ж8э1ж8ю1ж8я1з8а1з8е1з8ё1з8і1з8о1з8у1з8ы1з8э1з8ю1з8я1й8а1й8е1й8ё1й8і1й8о1й8у1й8ы1й8э1й8ю1й8я1к8а1к8е1к8ё1к8і1к8о1к8у1к8ы1к8э1к8ю1к8я1л8а1л8е1л8ё1л8і1л8о1л8у1л8ы1л8э1л8ю1л8я1м8а1м8е1м8ё1м8і1м8о1м8у1м8ы1м8э1м8ю1м8я1н8а1н8е1н8ё1н8і1н8о1н8у1н8ы1н8э1н8ю1н8я1п8а1п8е1п8ё1п8і1п8о1п8у1п8ы1п8э1п8ю1п8я1р8а1р8е1р8ё1р8і1р8о1р8у1р8ы1р8э1р8ю1р8я1с8а1с8е1с8ё1с8і1с8о1с8у1с8ы1с8э1с8ю1с8я1т8а1т8е1т8ё1т8і1т8о1т8у1т8ы1т8э1т8ю1т8я1ў8а1ў8е1ў8ё1ў8і1ў8о1ў8у1ў8ы1ў8э1ў8ю1ў8я1ф8а1ф8е1ф8ё1ф8і1ф8о1ф8у1ф8ы1ф8э1ф8ю1ф8я1х8а1х8е1х8ё1х8і1х8о1х8у1х8ы1х8э1х8ю1х8я1ц8а1ц8е1ц8ё1ц8і1ц8о1ц8у1ц8ы1ц8э1ц8ю1ц8я1ч8а1ч8е1ч8ё1ч8і1ч8о1ч8у1ч8ы1ч8э1ч8ю1ч8я1ш8а1ш8е1ш8ё1ш8і1ш8о1ш8у1ш8ы1ш8э1ш8ю1ш8я1ь8а1ь8е1ь8ё1ь8і1ь8о1ь8у1ь8ы1ь8э1ь8ю1ь8я_бб88бб__бв88бв__бг88бг__бґ88бґ__бд88бд__бж88бж__бз88бз__бй88бй__бк88бк__бл88бл__бм88бм__бн88бн__бп88бп__бр88бр__бс88бс__бт88бт__бў88бў__бф88бф__бх88бх__бц88бц__бч88бч__бш88бш__бь88бь__б'8_б’8_вб88вб__вв88вв__вг88вг__вґ88вґ__вд88вд__вж88вж__вз88вз__вй88вй__вк88вк__вл88вл__вм88вм__вн88вн__вп88вп__вр88вр__вс88вс__вт88вт__вў88вў__вф88вф__вх88вх__вц88вц__вч88вч__вш88вш__вь88вь__в'8_в’8_гб88гб__гв88гв__гг88гг__гґ88гґ__гд88гд__гж88гж__гз88гз__гй88гй__гк88гк__гл88гл__гм88гм__гн88гн__гп88гп__гр88гр__гс88гс__гт88гт__гў88гў__гф88гф__гх88гх__гц88гц__гч88гч__гш88гш__гь88гь__г'8_г’8_ґб88ґб__ґв88ґв__ґг88ґг__ґґ88ґґ__ґд88ґд__ґж88ґж__ґз88ґз__ґй88ґй__ґк88ґк__ґл88ґл__ґм88ґм__ґн88ґн__ґп88ґп__ґр88ґр__ґс88ґс__ґт88ґт__ґў88ґў__ґф88ґф__ґх88ґх__ґц88ґц__ґч88ґч__ґш88ґш__ґь88ґь__ґ'8_ґ’8_дб88дб__дв88дв__дг88дг__дґ88дґ__дд88дд__дж88дж__дз88дз__дй88дй__дк88дк__дл88дл__дм88дм__дн88дн__дп88дп__др88др__дс88дс__дт88дт__дў88дў__дф88дф__дх88дх__дц88дц__дч88дч__дш88дш__дь88дь__д'8_д’8_жб88жб__жв88жв__жг88жг__жґ88жґ__жд88жд__жж88жж__жз88жз__жй88жй__жк88жк__жл88жл__жм88жм__жн88жн__жп88жп__жр88жр__жс88жс__жт88жт__жў88жў__жф88жф__жх88жх__жц88жц__жч88жч__жш88жш__жь88жь__ж'8_ж’8_зб88зб__зв88зв__зг88зг__зґ88зґ__зд88зд__зж88зж__зз88зз__зй88зй__зк88зк__зл88зл__зм88зм__зн88зн__зп88зп__зр88зр__зс88зс__зт88зт__зў88зў__зф88зф__зх88зх__зц88зц__зч88зч__зш88зш__зь88зь__з'8_з’8_йб88йб__йв88йв__йг88йг__йґ88йґ__йд88йд__йж88йж__йз88йз__йй88йй__йк88йк__йл88йл__йм88йм__йн88йн__йп88йп__йр88йр__йс88йс__йт88йт__йў88йў__йф88йф__йх88йх__йц88йц__йч88йч__йш88йш__йь88йь__й'8_й’8_кб88кб__кв88кв__кг88кг__кґ88кґ__кд88кд__кж88кж__кз88кз__кй88кй__кк88кк__кл88кл__км88км__кн88кн__кп88кп__кр88кр__кс88кс__кт88кт__кў88кў__кф88кф__кх88кх__кц88кц__кч88кч__кш88кш__кь88кь__к'8_к’8_лб88лб__лв88лв__лг88лг__лґ88лґ__лд88лд__лж88лж__лз88лз__лй88лй__лк88лк__лл88лл__лм88лм__лн88лн__лп88лп__лр88лр__лс88лс__лт88лт__лў88лў__лф88лф__лх88лх__лц88лц__лч88лч__лш88лш__ль88ль__л'8_л’8_мб88мб__мв88мв__мг88мг__мґ88мґ__мд88мд__мж88мж__мз88мз__мй88мй__мк88мк__мл88мл__мм88мм__мн88мн__мп88мп__мр88мр__мс88мс__мт88мт__мў88мў__мф88мф__мх88мх__мц88мц__мч88мч__мш88мш__мь88мь__м'8_м’8_нб88нб__нв88нв__нг88нг__нґ88нґ__нд88нд__нж88нж__нз88нз__нй88нй__нк88нк__нл88нл__нм88нм__нн88нн__нп88нп__нр88нр__нс88нс__нт88нт__нў88нў__нф88нф__нх88нх__нц88нц__нч88нч__нш88нш__нь88нь__н'8_н’8_пб88пб__пв88пв__пг88пг__пґ88пґ__пд88пд__пж88пж__пз88пз__пй88пй__пк88пк__пл88пл__пм88пм__пн88пн__пп88пп__пр88пр__пс88пс__пт88пт__пў88пў__пф88пф__пх88пх__пц88пц__пч88пч__пш88пш__пь88пь__п'8_п’8_рб88рб__рв88рв__рг88рг__рґ88рґ__рд88рд__рж88рж__рз88рз__рй88рй__рк88рк__рл88рл__рм88рм__рн88рн__рп88рп__рр88рр__рс88рс__рт88рт__рў88рў__рф88рф__рх88рх__рц88рц__рч88рч__рш88рш__рь88рь__р'8_р’8_сб88сб__св88св__сг88сг__сґ88сґ__сд88сд__сж88сж__сз88сз__сй88сй__ск88ск__сл88сл__см88см__сн88сн__сп88сп__ср88ср__сс88сс__ст88ст__сў88сў__сф88сф__сх88сх__сц88сц__сч88сч__сш88сш__сь88сь__с'8_с’8_тб88тб__тв88тв__тг88тг__тґ88тґ__тд88тд__тж88тж__тз88тз__тй88тй__тк88тк__тл88тл__тм88тм__тн88тн__тп88тп__тр88тр__тс88тс__тт88тт__тў88тў__тф88тф__тх88тх__тц88тц__тч88тч__тш88тш__ть88ть__т'8_т’8_ўб88ўб__ўв88ўв__ўг88ўг__ўґ88ўґ__ўд88ўд__ўж88ўж__ўз88ўз__ўй88ўй__ўк88ўк__ўл88ўл__ўм88ўм__ўн88ўн__ўп88ўп__ўр88ўр__ўс88ўс__ўт88ўт__ўў88ўў__ўф88ўф__ўх88ўх__ўц88ўц__ўч88ўч__ўш88ўш__ўь88ўь__ў'8_ў’8_фб88фб__фв88фв__фг88фг__фґ88фґ__фд88фд__фж88фж__фз88фз__фй88фй__фк88фк__фл88фл__фм88фм__фн88фн__фп88фп__фр88фр__фс88фс__фт88фт__фў88фў__фф88фф__фх88фх__фц88фц__фч88фч__фш88фш__фь88фь__ф'8_ф’8_хб88хб__хв88хв__хг88хг__хґ88хґ__хд88хд__хж88хж__хз88хз__хй88хй__хк88хк__хл88хл__хм88хм__хн88хн__хп88хп__хр88хр__хс88хс__хт88хт__хў88хў__хф88хф__хх88хх__хц88хц__хч88хч__хш88хш__хь88хь__х'8_х’8_цб88цб__цв88цв__цг88цг__цґ88цґ__цд88цд__цж88цж__цз88цз__цй88цй__цк88цк__цл88цл__цм88цм__цн88цн__цп88цп__цр88цр__цс88цс__цт88цт__цў88цў__цф88цф__цх88цх__цц88цц__цч88цч__цш88цш__ць88ць__ц'8_ц’8_чб88чб__чв88чв__чг88чг__чґ88чґ__чд88чд__чж88чж__чз88чз__чй88чй__чк88чк__чл88чл__чм88чм__чн88чн__чп88чп__чр88чр__чс88чс__чт88чт__чў88чў__чф88чф__чх88чх__чц88чц__чч88чч__чш88чш__чь88чь__ч'8_ч’8_шб88шб__шв88шв__шг88шг__шґ88шґ__шд88шд__шж88шж__шз88шз__шй88шй__шк88шк__шл88шл__шм88шм__шн88шн__шп88шп__шр88шр__шс88шс__шт88шт__шў88шў__шф88шф__шх88шх__шц88шц__шч88шч__шш88шш__шь88шь__ш'8_ш’8_ьб88ьб__ьв88ьв__ьг88ьг__ьґ88ьґ__ьд88ьд__ьж88ьж__ьз88ьз__ьй88ьй__ьк88ьк__ьл88ьл__ьм88ьм__ьн88ьн__ьп88ьп__ьр88ьр__ьс88ьс__ьт88ьт__ьў88ьў__ьф88ьф__ьх88ьх__ьц88ьц__ьч88ьч__ьш88ьш__ьь88ьь__ь'8_ь’8б8'1б8’1в8'1в8’1г8'1г8’1ґ8'1ґ8’1д8'1д8’1ж8'1ж8’1з8'1з8’1й8'1й8’1к8'1к8’1л8'1л8’1м8'1м8’1н8'1н8’1п8'1п8’1р8'1р8’1с8'1с8’1т8'1т8’1ў8'1ў8’1ф8'1ф8’1х8'1х8’1ц8'1ц8’1ч8'1ч8’1ш8'1ш8’1ь8'1ь8’1б8а3б8у3б8о3б8е3б8ё3б8ы3б8э3б8і3в8а3в8у3в8о3в8е3в8ё3в8ы3в8э3в8і3г8а3г8у3г8о3г8е3г8ё3г8ы3г8э3г8і3ґ8а3ґ8у3ґ8о3ґ8е3ґ8ё3ґ8ы3ґ8э3ґ8і3д8а3д8у3д8о3д8е3д8ё3д8ы3д8э3д8і3ж8а3ж8у3ж8о3ж8е3ж8ё3ж8ы3ж8э3ж8і3з8а3з8у3з8о3з8е3з8ё3з8ы3з8э3з8і3к8а3к8у3к8о3к8е3к8ё3к8ы3к8э3к8і3л8а3л8у3л8о3л8е3л8ё3л8ы3л8э3л8і3м8а3м8у3м8о3м8е3м8ё3м8ы3м8э3м8і3н8а3н8у3н8о3н8е3н8ё3н8ы3н8э3н8і3п8а3п8у3п8о3п8е3п8ё3п8ы3п8э3п8і3р8а3р8у3р8о3р8е3р8ё3р8ы3р8э3р8і3с8а3с8у3с8о3с8е3с8ё3с8ы3с8э3с8і3т8а3т8у3т8о3т8е3т8ё3т8ы3т8э3т8і3ф8а3ф8у3ф8о3ф8е3ф8ё3ф8ы3ф8э3ф8і3х8а3х8у3х8о3х8е3х8ё3х8ы3х8э3х8і3ц8а3ц8у3ц8о3ц8е3ц8ё3ц8ы3ц8э3ц8і3ч8а3ч8у3ч8о3ч8е3ч8ё3ч8ы3ч8э3ч8і3ш8а3ш8у3ш8о3ш8е3ш8ё3ш8ы3ш8э3ш8і3а8й1о8й1е8й1і8й1э8й1ю8й1я8й1ё8й1ы8й1а8ў1о8ў1е8ў1і8ў1э8ў1ю8ў1я8ў1ё8ў1ы8ў1б8'1б8’1в8'1в8’1г8'1г8’1ґ8'1ґ8’1д8'1д8’1ж8'1ж8’1з8'1з8’1к8'1к8’1л8'1л8’1м8'1м8’1н8'1н8’1п8'1п8’1р8'1р8’1с8'1с8’1т8'1т8’1ф8'1ф8’1х8'1х8’1ц8'1ц8’1ч8'1ч8’1ш8'1ш8’1б8ь1в8ь1г8ь1ґ8ь1д8ь1ж8ь1з8ь1к8ь1л8ь1м8ь1н8ь1п8ь1р8ь1с8ь1т8ь1ф8ь1х8ь1ц8ь1ч8ь1ш8ь1");
            put(5, "_ад1б_ад1в_ад1г_ад1ґ_ад1д_ад1ж_ад1з_ад1к_ад1л_ад1м_ад1н_ад1п_ад1р_ад1с_ад1т_ад1ф_ад1х_ад1ц_ад1ч_ад1ш_аб1б_аб1в_аб1г_аб1ґ_аб1д_аб1ж_аб1з_аб1к_аб1л_аб1м_аб1н_аб1п_аб1р_аб1с_аб1т_аб1ф_аб1х_аб1ц_аб1ч_аб1ш_уз1б_уз1в_уз1г_уз1ґ_уз1д_уз1ж_уз1з_уз1к_уз1л_уз1м_уз1н_уз1п_уз1р_уз1с_уз1т_уз1ф_уз1х_уз1ц_уз1ч_уз1ш_ус1б_ус1в_ус1г_ус1ґ_ус1д_ус1ж_ус1з_ус1к_ус1л_ус1м_ус1н_ус1п_ус1р_ус1с_ус1т_ус1ф_ус1х_ус1ц_ус1ч_ус1ш8льш_8сць_8дзь_");
            put(6, "_над1б_над1в_над1г_над1ґ_над1д_над1ж_над1з_над1к_над1л_над1м_над1н_над1п_над1р_над1с_над1т_над1ф_над1х_над1ц_над1ч_над1ш_пад1б_пад1в_пад1г_пад1ґ_пад1д_пад1ж_пад1з_пад1к_пад1л_пад1м_пад1н_пад1п_пад1р_пад1с_пад1т_пад1ф_пад1х_пад1ц_пад1ч_пад1ш_раз1б_раз1в_раз1г_раз1ґ_раз1д_раз1ж_раз1з_раз1к_раз1л_раз1м_раз1н_раз1п_раз1р_раз1с_раз1т_раз1ф_раз1х_раз1ц_раз1ч_раз1ш_рас1б_рас1в_рас1г_рас1ґ_рас1д_рас1ж_рас1з_рас1к_рас1л_рас1м_рас1н_рас1п_рас1р_рас1с_рас1т_рас1ф_рас1х_рас1ц_рас1ч_рас1ш_роз1б_роз1в_роз1г_роз1ґ_роз1д_роз1ж_роз1з_роз1к_роз1л_роз1м_роз1н_роз1п_роз1р_роз1с_роз1т_роз1ф_роз1х_роз1ц_роз1ч_роз1ш_бяз1б_бяз1в_бяз1г_бяз1ґ_бяз1д_бяз1ж_бяз1з_бяз1к_бяз1л_бяз1м_бяз1н_бяз1п_бяз1р_бяз1с_бяз1т_бяз1ф_бяз1х_бяз1ц_бяз1ч_бяз1ш_без1б_без1в_без1г_без1ґ_без1д_без1ж_без1з_без1к_без1л_без1м_без1н_без1п_без1р_без1с_без1т_без1ф_без1х_без1ц_без1ч_без1ш_бяс1б_бяс1в_бяс1г_бяс1ґ_бяс1д_бяс1ж_бяс1з_бяс1к_бяс1л_бяс1м_бяс1н_бяс1п_бяс1р_бяс1с_бяс1т_бяс1ф_бяс1х_бяс1ц_бяс1ч_бяс1ш_бес1б_бес1в_бес1г_бес1ґ_бес1д_бес1ж_бес1з_бес1к_бес1л_бес1м_бес1н_бес1п_бес1р_бес1с_бес1т_бес1ф_бес1х_бес1ц_бес1ч_бес1ш_рос1б_рос1в_рос1г_рос1ґ_рос1д_рос1ж_рос1з_рос1к_рос1л_рос1м_рос1н_рос1п_рос1р_рос1с_рос1т_рос1ф_рос1х_рос1ц_рос1ч_рос1швё8рст");
            put(7, "_праз1б_праз1в_праз1г_праз1ґ_праз1д_праз1ж_праз1з_праз1к_праз1л_праз1м_праз1н_праз1п_праз1р_праз1с_праз1т_праз1ф_праз1х_праз1ц_праз1ч_праз1ш_ад8зінтэ8мбр__дву8х3_шма8т1");
            put(8, "_перад1б_перад1в_перад1г_перад1ґ_перад1д_перад1ж_перад1з_перад1к_перад1л_перад1м_перад1н_перад1п_перад1р_перад1с_перад1т_перад1ф_перад1х_перад1ц_перад1ч_перад1ш_цераз1б_цераз1в_цераз1г_цераз1ґ_цераз1д_цераз1ж_цераз1з_цераз1к_цераз1л_цераз1м_цераз1н_цераз1п_цераз1р_цераз1с_цераз1т_цераз1ф_цераз1х_цераз1ц_цераз1ч_цераз1ш_церас1б_церас1в_церас1г_церас1ґ_церас1д_церас1ж_церас1з_церас1к_церас1л_церас1м_церас1н_церас1п_церас1р_церас1с_церас1т_церас1ф_церас1х_церас1ц_церас1ч_церас1шна1д8вор");
            put(9, "за1п8люшч_па1д8зял_па1д8зелраз1г8лядраз1г8ледзло1ў8жыв_па1д8зяк_вы1к8люч");
            put(10, "віда1з8мянвіда1з8менза3ц8вярдз_па3г8лядз");
            put(12, "слова1ў8тваркрова3ў8твар");
        }
    }), sv("sv", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "c21df21hx12y");
            put(3, "_b4_d4_f4_g2_k4_l2_m2_n4_p4_r2_s4_t4_v2_x2a2ba1ja1oa1t2aua5å1b23ba4bb3be3bib3k3bo3bub3v3by3bå3bä3böc3c1ci4ck4cr4cs1cy3da2db4dc2dd3di2dj3do4ds3du3dy4dz3dödé4e1a4eb4ece2de1ee1fe1ge1me1o2epe1v4eä3faf3d3fef5h3fi1fl1fo2ft3fu4fv5fy1fä3fö2gb2gd2gg2gh2gl4gw3gyh5c4hdh3gh2ih1k2hl2hm4hnh3ph1s2hth2öi1ai2di1gi3ii1ti1ö1ja2jb2jd1je4jh1ji4jk2jmj2o4jp2jt5jé2kb4kc4kjkl2k2o2kskv41le2lh1lil1n2lv3lé1ma2mb2mc2md1me2mh1mi1mo4ms1na2nd1ne2nh2nk1no4nsn5zo1ao2bo2do1eo1go1io1jo1ko5qox5oy2o3åo3ö1pa2pc2php2jp2l1po2pp2ps1pu3péqu41ra2rb1re2rh4rj2rk2rsr3w1sa4sbs2c1se2sh1si2sm1sos2t1su1så1sä1sö1ta2tc2th1tit2j2ts2tt2tv2tz5téu1au2bu2du1eu3ju1ou5uu5åu3ö1ve2vhv4i1vo2vs3vy1wawe2w2hxk2xs4y1ay2dy1ey1iy5wy5å1za1ze1zi1zo4zpz5s3zuå1aå1eå1få3iå1må3oå1på1vä1aä2b2äcä2dä3eä3i4äk4äs2ätö1aö2dö1eö1iö1vé3e");
            put(4, "_a4b_ac3_a4d_e2s_ex3_ib4_ik4_o3o_o1u_sk4_st4_u3k_up2_y2a_y4ea5beab1la5buad3jad2sa5eda1gaa1geag1la4hjaib4a3iva3kaa5kea1kiak3na1koa1ku4aköa1laa4lja1loa1lua1lyam4iam1sa3möan3ca1nua5nya3nöa1pea1piap2sa5pya5pä2ara1arb2arha1ri4arla1ro4arp4arua3rya3rä2asaa1scas2has5la3suas3va1sya2söa5tea4tja2trau5b1avgav3rbbb4bb3l4b3dbe5ebe1kbe1sbe3u4bex2b3f2b5hb3je4b3m2b3n5bonbo1sboy54b3p3bry3brö4b3sb4spbst44b3tby5r5cap1c4e4ch_4chtcim2c3kac3kec3kick5jck1lck3nc3kock3rck5äck3öco2aco4m5da_2dak5dam4daxddd4d3djdd2s3d2ed4en5derde2sd4et4dex2d1f2d1gd3gl2d5hdi1o4d5l2d1m2d1nd2ol5dondo3y2d1pd2sed4sfd2sid2sjdsk2ds1ld2sod2suds1vd2sö2d3t4dupdu1s4dut2d1vd3vr2d3w5dåg2dås4dåt4dägdä2r4dög4döpe4ame2bre3che3coed3je3dåe2ede4eief4se3gae3geeg1legs3e5gåeig2e3ike1ine1joe3jue3jäe5jöe3kae1kie1klek3ne1koe1kue1kye1käe1lae1loel3p2enj2enye2ogeo4ie5ore1pee1pie1prep3se3påe1rie1roerp4e1rue3rye1räe1sc2esees2ke1sle1spes2ue1sye5tie1toet2se1tue1ty2etze1täeuk44eure4vjev3r3expfac44fav4f3b4feffe2l4fex2f1ffff4ff3lff3nf3foff3rffs4f3fäf3g22f3k4f3mfma44foffol24f3p2f3sfs2kf4slf4smf4snf4spf4stf4svf3taf3tif3toft5tft1vg4av4gaxge2a2gefg4emge2o2g1fg1gag1gegg5ggg1lg4gu1g2igi1o3givgi2ög2jog3jä4glj2g1m2g1ng2no1g2o3go_3gol2g1pg2r4g4rå2g2sg4sfgs1lgs1mgs3ngs3sgs1vgs1ä2g1tg3tr1g2u4gug4gup2gut2g1v1g2åg4älg2ärgä4s1g2ö4göghav24hirhi4th4leh2na4howh5ruhu2shä4shö2ghö4sia3gi3cai5coid1rid2si3dåi4dö2i1ei5fni1frig1li1kiik3ni1koik1vi3kyi3kåi3köi1lail5ki1loi3lui5läi1mui5måi3mäi5möi3niin5ji1nui1näi5oci1ogi3oki1oli5omion2i1opi1ori1osi1oti1pei1pii3rai1rii1roi1ruis2hi2skis3mis3nis5vi3syi4såit5ci4tj4i1ui1vai1viiv3riv2si1våix2tjd3rj4duje2a5jef2j1f4j3g4jinj4klj3kojk3v2j1l2j1n3job3jouj5pl2j3r2j1sj5saj4skjts42j2u4jur1k2a3ka_2kafka3i2kak2kap3kas4kau1k2e3ke_2kepke2s4kex2k1fkfö22kh44kif1kigk3jä2k3k2kle2k1m2k2nk4ny4koc1kom1kon1kor2k1pk2r4k2sok2su4k1tk2tr4kug3kusk2vek4vok1vå4kög3la_2laf2lak2lau2lav2lb44l1c2l2dl3dj3le_2lex2l1f2l1gl2gjlgs43lif3ligli1o2lip1ljul5jål1jä2l1kl3kel2kll2krlk3tl1lalld4ll3kll1ll1loll3pl1lull5vl5ly4l1m2loml1pel1pi4l3r2l1sl2scl2skl4sml2spls5sl2stl2sul2svl4så4l1tltu4lu5i2lunl1val1vil1vä2lå_4läc4löl4löm3lön1lösm4dim4domeu42mex2m1fm4fnmis22m1k2m3l2m1nm4odmo4i2m1pm2plm4på2m1rms2m2m1t4mud5mum3mur2m3v1mynmåg44mårmå1s4mägmäk31män1mäs1mät3möj3mös4möv3na_3nad2naf2nak2nb42n1cn2chn5de3ne_2nex2ng1n2gin2go1n2i4nid3ninni1o4nip2n1jn3jän1kin1kon1kun1kö2n1l2n1m2n1nnn3dn3nenn3k2n1p2n1rns2ins2k2n1t4nug3nui3num2nup2n1v4når4nä_4näc3näm3nät3nöj4nölnös4oby4o3däo4flo3fro4gjo4gäo4ilok3no2kvo1la1oljo1loo1luo1lyo1lä1omron3con3jo1nyon5åo1näo3nöoo4do3oro1peo1pio3på4orao1ri4orko1roo1ruo3ryo1räo1röo1too1tuo1tyo5tåo3täoun4oup44ourou4so1vao1viov3ro1väo3weo3än4pafpag43pappa3u2pb44pem4pex2p1f4p3g1pigpi1o3pipp3lj2p1m4p1np3ni5poa2poc2pofpo2i3pos4povp3pep1pipp3jpp1lpp1rp2pup5pypp3åp2r22pra3pro4prå4psop2sö2p1t4pug2p1v3päl4pör3que3ra_2rak3rarr4as2rav2r1c2r2dr3djr3dår3dä3re_re3b4recre3o4rex2r1f2r1g4ribri1or3jor5jur5jör1kirk3nr1kor1kur1kä2r1lrld22r1m2r1nrn1krn3tro3b2r1pr4pö4r1rrrd4rr1sr1spr1svr1sy2r1trt3t2rut5ruö2r1vry5o4rål4räm4räs2rögr3öi4röp3rör3sa_2safsa3i2sap2sau4s3dse2gsem22s1fsfö2s5hö5sie3sik3siosiu41s2j4sjn4sjts4ju3sjö4sk_4skhsk4i4skl4sknsk3s2skt2skv1skå2sl2s2lus3mjs4nå3soc2sod5soi2som3son3sots2p21spe4spls3ps3spö4s1r4s1sss2kss1lsss4s2sv2st_st3c2stj2stmst3t4stv1sty1stå1stä1stösu4b3sugsu3i3sum2sun2sup5suss2v24syk5syl3syn3syssyt25såg4såks4äds4äl2säp5säs3sät4söd2sög4söl4söp3ta_tat22tav3tax2tb43t2e5tec4tegte3i4tej5tib3tidt2il3tisti2ö4tje2t3l2t1m3tokt2opt4ov2t1pt2r42tra2tri5trét3sets2kt2sotss4t1stt2sut5syt1tot3tutt1vt3tyt3tä5tuöt1va4tve3typ5tys3tågtås44tåt4täm4tög4töpu4bou5clu5deud3ru4duu4dyu2esu1geugn4u5ieu1inu3isu5kiu4kluk3nu1kouk2su3kuuk3vu1lau1lou3luu1läu1löu1muu5nuu1peu1piu2plu3reu1riu1rou5ryu3seus3nu2spus3vu4såu4säu2sö1utbut3ju1tout3r2uttut1vu5ty2u1vu4vju4vä5vap4vau4vav2vb42v1c5vecve2k4vepves42v1f2v1gvi4c4vjo2v1l2v1m2vomvos42v1p2v2rv3ruv4scv2sov1stv2sö2v1t4vut2v1v3vägvä4l2vät3väx4vög4vöp3vörwhi2wi2ew4naxis4xli4xti2x4tåyb4sy4day4doyd3ryds4y4duy4döy1gay1gey1kiyk3ny1koy1lay3liyl5ky1loy3måy3ory5ouy1pey5poy1riy1roy1toyt5vy3vay3viy3väå3djå1gaå1geåg3lågå4å1kiå1laål3kå1läå2plå4pöå1riår5öås3nåss4ås4tåte2äd3rä1gaä1geäg1läg3rä5joä1kiäk3näk3rä1laä4noä3peä4prä1riä4såä3toä1vaä3viä5vuöd2sö4duö4döö1ga1ögdö1geögg4ög1lög2n1ögoö3joö1kiök3nök2sö1laöl2pö5läö3peö3piö4prörb4ör3gö1riör1uör3yör1äös3növe4ö2vj");
            put(5, "_ab5i_ab3r_a3dr_ad3s_a5kl_a5le_a3lu_a5mu_an5s_ap1p_as2k_as4t_a5ta_at3t_bo2k_cis4_där3_ek1v_e4nä_es4t_e3tr_gus3_he2m_im3p_i2n1_i4na_in3d_ink2_in3t_i3so_ner1_no4n_ok3t_o3kv_o2ma_o2mo_o3mu_on4k_o5sc_o3sl_o3sv_o3tr_sa2k_si5o_sjö1_ta4k_ti3o_u4ra_ur3s_u2t1_u4ta_ut5s_vä2g_ång3_å3st_ä3ro_ö3roab4buabe2sab3laab4scab4ska5daga5deka5delad5epad3opa3dread3ruaf4fo3affäa2ge_ag1grag3roa4gurak3vea5kårak5åta2linal2kval4käal3låal3tral4tual4täalu5salv3sa4mafam4pram3åtanci5a4nefan3gian1graniu4ank3rano2ia4noka4nopan4sjan1stan4tja2pe_ap3seaps5laps3papu5s4arbi2arbo4arbrar3drar3kaar5kr4arn_a2robar2saar2sva4rura5rusasbe4a2skoa4skras3kuas3paas2skas2spas2stas3taas3toas4tra4sulas2uta2s5åati5öat4tjatt3saut5s2a1va2a1vi4a3väba4diba4dobak5lba4koba4kub4bakb4b3rbb4so4beldbe5lube3lybe3låbe5löbeng4be3nåbe1röbe3slbes5sbe5sube3trbe3tvbi3d44binvb5larb5latb5len3bles5blidbo4grbo2klbo1mubo4sc4brarb5scebs3chb4sofb4stjbång3båt2sbör2sceu4s3chau3chef5chocchäs3chör4ci4lucipp4ck4reckus2ck3vack3veck3väcle2acros24dadrdags35dakoda3lida3må4d1ap4darb4dartda4trdat5tdcen3ddi4sd4dosdd3radd3redd3rid3drädds3vde1k44deko4deldde3prder1kde2rode4rude3sede3spde3trdias4di5eldi2grdi3kadi5ku4dinf4dinr4dins4dintdi4oddi3scdi4sjdis1pd3jor3djur2d3k2do5lo4domr4dori4dortd5ost2d2r2d3rad3drejd3ren5dresd3retd4ric3drifd3rigd3rind5rocd3ror4drot5dränd3rätd5rödd3skids3klds5knds4mod4småds5nåds3plds3s4ds4tedu2scdu5södu4vudy4rodöds1d5öste2akeecis4edd4redi4ued1skedso4ee2k5e4en_e4ene3efteege2le5gruei5gnei5she1iskek4leek5roe1kve3eld_el3k4el3liell3sel3läe4lobel2siel5uge5luv2e1läe5mate5mise2naven4cee4nede4neken3knen5kren5käeno2men3siens2men2spen4såe5nus2e1näe3plaep5leep4trepu3ber1ak4eraser3d4erg4ler4gue5riberlä4er5nae3robe2romer3raer5scer3sler3sve5rume5råde2sales4hiesi4ues2mies3ples2skes2stes4tre3ståeta3beti3öe5träets1lets3met4svett3ret4vaet5vuetäc4e5um_e5up4ext4r4fans4farbfa3shfa4stfa4töfi2brfi3lifi2tifolk12f5omfo2nafra2mf4rerfre4sf4ri_5fritfrån5f4taff4takf4tapfte4rf4texf4tinf4t3rft2saft4sjfts4tfu5rufu3tufy4mafå3töfö2rafö2riför3kfört4för1öga5br3g2ag4gakt3g2alga5läga4no2garb4garmga2ro4gartga4stga4sugaus4g3d4rge5b42ge4jg2eligel5y3gelägen5g3genj4genm4genvge5ny3genä5gesege4toget5sg4gapg4gosggs4mgh4tegi5sn3gjor2g3k2g1larg2lasg4lidg4lög5glömg4nag4gont2gord4gorm4gortgo3sl3graf5gral4gras5grecg3rig5grip3grisg5roigro2v4grum5grå_grä4ngs1ang3selgsi4dg3sjugs4kigs3kng3skyg4smegs4nigs4nögs1orgs3plgs3pogs3pugs3tjg4suggs3vigs3vågs3ytguld34gulägu2magu5rugus4kg3utbgö5roha3blha5geha4liha5raha4scha4sphas3thavs3he4athe4frhe4lähets1h2nitho5nuhop3shos3phyg5rhys4thäll2hä4rihög5ria3fria4luia4skia3tri2b3li4ce_i5chaid4gei4domid3roids3vi4dunifes44igani2gebig5ejig3noi3kloik3rei3kuli3kumi2linil1jö3illuil2tji4lupim5smim4soi4nau1induin4gai4nif5inre1inri3inräin3slins4min3snin5te1intrint3si4nunin3ymio4krio5lii3onoions3ipos4ip5pii4resirk5liro3pi5sceisel4is3kuis3kyi2s3pis3sais3seiss5nistå4i4teii4texit4tui2t5åi2vaki4vinix5tu4jarbjas5pjo4kr4joljjo5löjs4mejs4tejuk3sjul3kjuss4jus4tjä5lojär5sjör2sjös4t3kad_ka4dr5kafäka5ju4kalf4kalg3kamp3kamr3kan_5kano3kapi3kar_ka3ra4karbka5ri4kark4karp4karvka4sk3kat_2k3d4kdom42ked_2kedake3drked4ske4er2kefu4keldkels4ke5nå3kernkes3s2k5g4kid3skik4skilt45kimå4kins2kintki4nuki4trkiv3s5kjol1klag2klat5klavk2lej2kligk2lim3klipk2lis3klos1klub4kluk1klädk4nal5knip3k4nuk5nykko5dek5odlkog3nko4gr4kola4kolj3komm5kompkom4s3konf3kontko3nu3korgko3ri2korrko3sl3kost4k3ou3kraf1krig4krivk3ryg4krälk3rätks3chk4serks2k4ks3klks5kvk3skäk3sköks2lik5slyks3plk1s4tk4texk2todk2tomkt3rekt2stkt5t4k4tugk2tutk4tälk5ugnku5la4kuld3kulö5kunnku4ro3kursk1vär3kyrkkäl4m5kämp5känn3käns3kärl5köp_kör4l2ladm4ladr5lagmlag3r5lakila5lo2larb1larnlar5s4lartlas3h4laskla4st1lat_la5trla5vuld3ral5dryle5igle2klle4kv3ler_ler5k3lernle5tåle3umle4vul3g2llg5stli5chli4golig3slik2llik3s2lind2lini5linj2lintlis3cli4volivs1l2jak4l1jol3jörl5kjul5kläll3drlle5bll2sell2soll3trll5unl5lödllör4l4mollm3stlo2af4lodllo4do2lolj4lord2lorglor4slo4vol4pakl5plalp5lölp4stl4sjol4själ3skilsk3nl3skyl3skål3skäl3sluls4mol3spels3pll3stals4tel3stol3styl3stål3stäl5stöl5surl4svil4tefl4tifl4tihl4tosl4trölt5sklung32lupplu4pu4lutb4lutsl4voslv3rilv3splväv4lyg3rlåg3s1långlå4skläg5rlä4splö4väma5frmag5nmag5sma5jumak3rma3limand4ma5nimash5mas4vmb4skm4datm3d4r2medsme4dume4klme4ko4meldmelo5me5lumen5kme5nume5nyme4somes4t2metam4fes2m1g4mid3smi4lu2mind4mink4minvmi3nömi5sfmi4spmi4tr2m1m2mme5dmm3s4m4mulm2namm4navmn5drmn3g4mn5stmn5tum2n3å2momrmo3namos3kmo2tamo4tumot3vm2pakmpos4mp5p4mps4kmp5spm4salm4skems3lämste2m1stom2strms5äp3musi1mål_5mån_mäns43märkmö4blnads3na5gr3nako3nakrn1akt2nalf4nalgnal3sna2lun5amb5namn4nanv2narb2nark4narm2nartn3chan3chen3chincis4n4dakn4davnd3d4nde3sn4dilnd3rind3snnd5åsne4di5nedlned3sne4döne2gr4nek_ne5ly4nenlne1ut2n1f4nfis3n4garn4getng3igngi4sng4lyng5omng3orn4gröngs1kn4gödni5ecni4kini5lin4jarn3junnju4sn3knynk3rin1kronk5slnk3spnnis42nodlno4kl2nolj2nomr2nord2norgno5sano5scno4tun1skin4socn1spins3plns3pons3s4n1svans3vin4trönts3cnt4sen4tutn3tvån5ugnnums5n3upp2nutbny5gr4nög4nö2janö5kro2ard5o4bjo4blioc3kuode4kodi4a1odlio3droods4kod2sto4gavog3gro5gloo5glyo4grio4gröog3seo4kliok3slok4suo5lakol5auolfö4ol3kaolk3rol4kuol4käol3läolm4soln3sol4saol4tåo4lugo4lurol5åro3menom5paom3pl4omraom1skom4trom3tvon5gion1gron1k4ons3cons3mont4soom5sop4plop4prop4puo3priop4sto3rako2rap1ordno4reh1orgaor4gror4gåor4möor4nuor4näor4plor5pror5teor2trosk4lo3somos4skos4tr4oti_4otie4otino5troot3svot5tiott2so5tunou3röova4nov4siov3slpaki3pa5lapals5pa5lä2parb4parmpar3s2paskpa2st3patr2p3d44peld5peng3penn3perspi4elpi5so3pjäs4p3k2p4lacp3lev3plex3plic1plik4plit1plomp3lop4poljpoly32porgpo4väp4paxpp3lapp5lupp3lypp3läpp3löpp5ocpp3ofpp3p4pp3rapp3ripp3rupp3rypp3räpp3tr5prax1presp3rigp3rik5prilpro3gp3ror3präs3prövp2salps2lip3snap3sodp1s4tp3tri5pung3punkpus3tpå3drpä5ro4radrra4du5ra1era3frra5isra2lora3plr4ar_4rarbr4are4rargr4ark4rarmr4arnr4ars4rartra5röras3hra2stra5yor4dafr4dosr4dulr4dös5recore5du4reft4reggre1kr4reldre3lurem5p3remsr4en_2reni2renk2renlre3nö3rer_3rern3reso3ret_4retyre5tårg3g23rial3rifi2rifr3rifu3rigtrik2sri4mo2rind2rinr2rins2rint3riotriv3sr4jisr4kekrkes3rk2ler4klörk4ner4kodrk3trr4kupr5körr5lavrlds3rl5spr4milrm5trrnal4rn3g4r2nomrns4krns4tro2kr2roljrom4aron4vro3plro4ra2rord2rorg3rornro4snros3vro5ter4plörra4nrres4r5ribrr5k4r4robr4romrrs2kr4rurr4sexr2sinr1skir2skur3skör4sler4slors4mors5när2splr2spors3s4rs4ter1storst4rr3stur2svär2tafrt4anr4tomr3trär4tutru3brruks13rum_runn24rupprus2hru4virv4sjrå5rarå3st4räkträs3sräv5sröd5rröd3srök3srör4srö4str1övr3sad_3sade4sadjsad5ssa5lo3s2amsa2ma4sang2sanl2sarb2sarm3sarn2sart4sarv4sass5sat_sa4tus3auk2s1av2sch_1scha4schb1schi4schk4schm4schp3schy3schösci3p3seglsek3r3sel_se5ly3sen_3set_2sexp4s3g2shi1ssid5s3s2ig4sinrsis4t2sjak5sjuk4sjur2ska_s4kags2kal1skap4skar4skass2kats4kav4ske_3skif5skin5skiv3skju1skol1skot1skris4krus3kups4kve1s2kys4kyns4kål4skår4sla_4slass1lats2levs4lic4sliss2lits5lors3lucs3luf4slus3slut3slå_s4läks5läms2läts2maks2mals2mids2mit5smug5smygsmå5gsmå3ksmå3s3smäd3smäl4smäs3smör2s2n43snabs3nams5ner3snib3snil3snits3niv3snut5snår5snäcs4när3snö_snö5g3snörsnö3s5sock2solj5sommso4pu3sor_2sord2sorg3sorn4sott4spas4sped2spen2sper3spirs1plaspli4s5plä4spre2spros3pry3språ1s4på3spån3spår5späns5sads5silss5klss2läss2löss3nass3vi4sta_5stacs4taf1stau4stea2stia2stib2stid2stil1stits5tju5stoc1stol4stom1stru2styp4ståg5stål3stäl5sun_5sunes5ung5supasu2pu2s1utsu4tosu4tr5svam4svap4svass3vat4svec3sven5sveps5ves4sviss5våds3väss3vätsyn3ks3yrksys4tsy5thsång34sätas5ögasö4kosör2sta1ch4tadi2taff3taga5tak_4talf4talv3tame3tami3tan_4tanl3tar_4tarb3tarntars44tart4tarv4task3tasttats32tatt4tavetav2st3chat3che2t3d4te4aste3b4tej2ste4kl4teld5tema4temote4mute4nä5ter_5term5terster3tte4ru5tes_5testtets34texa2texp2t1f42t3g4t4hen3tial5tici5tideti4du4tidöti4ed3tighti4goti2gr3tigttik3l3tiks5tilj5time2tind2tinr2tintti4od3tionti2os4tisc5tisk3tiva4tjob2tjou4tjäl4tjäm3tjän2t3k22t5n4tne4r4todl4tol_4tolj2tomr4toms4torm3torntos4kt4raf4trar4treg4tren2troct4rogt4rup1tryc4tråk5trä_3träd3träf3träg4träkt4ränt4rött4segts4ent4sext1skits3klts3nät3snöts3plts4tets3tjt3sudt3tact4taut4tedt4temtte2nttes4t4text4tiptt3jatt3rett3ritt4rytt4sett2sit4tugtt4våt3tör2tund5tunn2tupptu5re2tutbt3utvt3utötu4vut3vigt3vit3tvivt3våg3tvånt3vänty5da5tyg_ty3pi4t5äg4tärm3tävl4tö4dtö5detö4piub5alu3chau4dakuds4auf4fäuf4to4u1gaugg3sugns5ug3s4u2kebuk5laukos4ukt5suk4täul4diul4duul4döul2trum4fäum4soums4tu3mörund3run4dåung3r3unifunk3lunk3nun4krun1skun4tr1uppgupp3sup5utur5aku4robu4romu2sakusen3u2s1kus3kaus4kru5skyus4kåus5läu4ståu4stäu4taku4tefute3sutik2u5tiluti3öu3toputo5sut4ro1utruut3slutt4jut3övu2vak1vagnval3k5valv5vama4vanp2varb4varkvar2sva1ru5vavi2v3d4ve3ke4veldve3nyve5növer5g3verkve1st3veta3vetevid3svil4tvi2novi5ny3vis_vi5savis5hvi4stvi2tr2v3k22v1n44vok_4vord2vorg5vrakv1s2kvs4miv3snivs4tevs3våvu4d1v1und4v5up5våld3vård4vårivå3ru3vänl4värj5värky5danygg3ryg4gåygs4pyl4gjyl5läyl4trym2flyng3rynk5lyn4sayns4typ3riyre4syr4kuyrk5vyrs4kyr5styr5tuy1rå3ys2stys3tays3tiy2taky4te_y4teaytt3rze4roz4zinåds4låge2låg3stå2linål3stånd4rån4duåns4tåns4vå5plaår4doård2så4relå5rorår2svås4keåt3riå3trååt2sjått5säck5vädd3säd4duäde4säd5seäd3stäg4goäg4reäg3seäl2tuämp3länd3räng5ränn3säns1län4stän4sväpp3läp4stä4rapärg5lär4grärib4är4käär2nåär4nöär5obä5rolä3ropä5rorä5rosär2siär2soär4spär2svär2trärt3säs3paäs5piäs4skäs4späs3taäst3rä4stää5treät5teätt3rät4tuät4tvä2vakö4dakö4dalö4disöd3raöd3seög5akö5garö5gerögn3eög3siög3sköj4svök3slöl4kvöl4kööman4öm2klö4nalö2nomön4soö4pelöp5liö5plo1öppnö3rasö3resö3retö5rigör5irör5ivör3olör1orör3slör5teört5sör3vrörö4dö2sakös4sjös2skös4spös3taöst3vö2taköt4stöver1öv3raöv3riöv4sk");
            put(6, "_ab5ol_a5gre_al4pr_am4br_amp3l_an5go_a3sti_au3st_a4val_av3s4_bak5s_ben5s_bort1_e3l4a_en5st_e2r3i_evan5_feb3r_fram3_fres5_för1a_gu4lä_hu5sa_in3s2_is5ka_ko5li_köp5s_lak5r_lu2st_me4re_mon2s_mån3s_må4st_nöd5r_oc1ku_om3s4_ord3s_o1s4k_re4gr_runs4_rym2d_röve5_seg3r_sta2m_sup3p_ta3bl_tak5l_tig3r_til4l_tre3s_trä5k_ult5r_ung2e_var4t_ved5s_väg3s_år4s5_åter1abel4sab3ortab5ricab3rioac4kesac4kisack3ska5dran1adresad3ril1af3riaf4toraga4raag5orda4kartak5ramakri5sak3robak4sta1aktigak3trial5admali2bra5lin_a3lineal3insalk3akall3stalms4kal5ortals5paana4boan3alfan3arkan5dakan4dunan4dänang4esan5sceans5kuans3lian4stoan4styan4treape4n3ap4lanapps4kap3ricap3rifa5prisa4ranna4rarvard5sta4rendarg5siar4nalarsk5lar4troarts5par4turar4vägasis5tas3kisas3pigass5upas5terasti5oas5töra4sundata5raa3tral4atrara4t3reat3riaa3tricat3riea5trika3trisa3t4roa4tro_at4ska1attacat2takat4tosa4tungau2t5a3automa4vartbad3s4bank5lbas4taba5stub4battbb4lerbe3d4rbe4stabe4stebis3kobi5skvble4mo5blera3blikr3bliksbor4tibort3rborts22b5raf3brik_b3rika3brike3briksb5riköbru4stb4slanbund4sbus2stcens3t3centrck5lisck3orgc4kortck3sla4dand_del2sade5lutden2tode5roldes3tidfö3ra2dinspdis3kodis1krdis5todi4tredjup5pdom2skdo4pak4d5ord3d4ragd3randd5rarbd5ratu4d5rik3d4riv3droppd3räkn3dräktd2s1ands5enhds3insd3skefds4kends4lotds3tald5statdste4ad5stigds3tinds5trodu4stedy4kaneb3rile4danse5draled2skoed3s2leg2lere4graneg5rateg3rinek3latek3orrek5visel1aktel4arbeleb3rel4fraeli5kuemon1sem5ortemp5leen5artene3röen5kloens5keens4teent4haen2t1rent3rient5ruepp2s3epps5ter4gåse4rinfers4leer4staer2steer3stres5alles3arme4skanes5kares3keres5kule5slagess5läe3stales3tine3struest4röe5tri_et3risets2adets3krets5paetu4rieu4se_eu5troe4varmfac5kefes5tafe3stoffö5refin5smfisk3rflo4dafor4mofost3rfram5p5frerifri5spf4tarmft4setft2s5ifts5väfäs5tifö2renför3smför3sugall3s5g2atig5avsn3gelisgel5stgel5änge4nap3g2enigenom5gen4sag4ense1g2ent1g2era3g2erigers5n5g2ettggs4lagg3s4tgg3s4vgi4stegis4trg4lans5glaseglas5k5glasögon3s4gra2m55grans5grett4g5rikgrus5t5gränsg5sattg5skafgs4kotgs4porgs5pregs3takgs3talgs4teng3stifg3stolgs3tragst4reg3stämg4s3vegul4dagytt3jgårds52g5åri2g5örthal4sohalv3åham4sthasp5lhets3thets3vhis2skhjäl3shos5tihust5rhys5tahälls1hälso3hä4varhö5genhörn5shöst5ri5brilick3u4iden3s3ifråni4kartik5läni5krobik5rofik5rosik5s2hik5u4til4danil5lakil4likill3s2il5läril2minim2b3rin4ge_ing5isin5kve1innehin4sem1inspein5sprin4ståin4trais5kepisk5nais4kuni5slamis3länis4priiss3täi1stalis4tesis3tigist5roit5rani5trini3trisit4t3r3jakt_jd4styje5staju4kosjus5krjus5tajäl4sa3kade_k3aktikal4lokall3s4kand_ka5plakap4prkaps5t3karnakarp5s4kart_4kartekas3ti3kats_4kensekfö3riking3r4kinnek2lamakla4mi3klass2k3läg3k4nap3k4nivkog4s3ko2linkol5tr5kolv_2k3omr3konstko5s4kko4str4krang5krerakrigs33kroppkråk5skrå4pakräk5lksaks5k2s5asks5kraks5tidkti5gek4tinnk2tinskt3rink5trodkt5rogkt3rolkt5rätkum5plkungs5ku4penkust3a3kvalik5vare3kvarnkvar3s3kvartk4vato1kvinn5kvire3kvällkydds3ky4linköks5tkör4sl1lade_3lagd_la4ginlan4dilder4slds4anle4ge_lem4sö2l5enlle5s2lli5kli5limerling5o4lingrli4stalk5lagl3k4rallok5vll4sanll3skall4svall4tigll5örtloc4kulod3stlo2ge_l5skotl3skrälskå4pls5nytls3poll4stakls5terl4stygls5vidlta2tul4tretluk4to4lull_5lust_l4varmlvers4ly4gatlyg3s23lyste5lystnly4strlång3slås5telå4stå1ländslä4sanlätt3s3lörermang2amani1k5ma3rimas3koma5skömas3time3stimet3roming4omin4krmiss3tmi4te_mitt3smnas3tmo4tinm4partmp3ladmp3latmp3linm3slagmulls3mult5rmun4komu3stamut4slmys4temäs5tamör4klna3kro5nalfl4nand_na4rapnast3rncyk3lnd5raknd5rasnd3ratn5driln3dropnd5rosnds3ornds5väne4d3rner5smnes3s4ne4stane3tren4gen_n4gendn4gensn4germng3radng4serngs3panings1nip4prni3t4rniv5skniv5stn4kartn4kis_nkrus4nk4tinnn3s4tnom3s4n4sintn4sis_n4sisens3kanns3korns5lasns5mitn3stapns4teln3stifns3tigns4transt5upn3s4tyns3värn4tarkn4tinfnt3radn3trahn3trakn5tramnt3repn3trernt3riant3rinnt3risn4trornt4strnufts4nös5keoc4k5rock3sko5dralods4tiod5stuoffs5tognos4og4s3toll4siolo5kvom4bräo4mordom4ste3omsätongs4lo4ninsonsi3son4treopp3leor4d5äor4spaort3reort3roo3s2fäo1skopos5pigos4s4tos3tigost5röos3tulot5runot4träotvin4o3ut3tovs4mepakis44pand_pan4trpa5skipent5rper4bl3perioper4slpe5tropi5stapi5sto5plan_p4lanep3larn3politp4partpp5askp4pinspp3linpp5lispp3lånpp3låtpres4t3princpring3p5riol3psalmp5s2hops4kenp4stakp4stävpul5trraci4t3rade_2raffär4anderand3s2ransvr3arta3rativra3trirda5grrd3ranrd3rat4reausre3d4r3regn_ress5kre1sti4retetret3ro2revigrfö3rir3ifrå3riktnrind3sring3rri5pleri2stäri4tutri4visrk3aktr3klasr5lakar4marbrm2s5jro4grorol4li5roman5ronau5rond_ropp2s2roriero4sinr4seldr4skidrsk3nars4kosr4s5lörs5natrs5takr5stekr4stonr3strörs4vagr4tinsr5tritrubb5lru4danruks3vrunns5ru5sha5rutigrut4rarydd5sråge5lrång3sräck5sräng3sräns5trä4sanrä5stiröd5elröns4tröst3r2sa3drsak5ri2s1aktsa2morsand3ss3anlä3s4ar_s5arm_2schau1schen1scher1schetse4at_2s3eggseg3rasek5lesek5trs5ersäs4fär_5s2hawsi4erisi4esksi2ettsikts35sill_silv3r2s1ind2s1inf3sinni2sin1ss1inst5sint_2sintrs3jaktsjäls3s2kado1skaft3skal_5skap_4skapiskaps1s4kara5skarv3sked_s4kene3skepp4skis_5skjorsk5laps3klas3s4ko_1s4kog3skolas4kolos4korp3skratsk4ret3skrev3skrifs3krig5skrin3skrips5kris3skrivs5kron5skrub3skruv5skräc3skulp2skyrk5skåp_5skänk3skärvs5lad_s3lands4lants3lar_3slev_slins3s3lustslu4to5s4lårs5länn3s4läp4s3lär3s2löj3smak_s3makts2met_3s4nacs5nares3nast1snittsol3s2son4stso5pras5ord_s4park5sparvs3passspa5tr3s4pek3s4pel5spets3spills3plans4plin5splits3pres3sprit5spränss3kunss3unn3stadi5stam_5stamm1stant1state3statl2s5te_5steg_s4tek_2stekn5stekts4tell3stem_3steme1stera3stick3stil_3stink3stisc3stjäl3stjär4stolkstor3s3strec3strejst3ren1strer2stria1stridst4rif3struks3tryc5stryk5stråk3strål3sträc4sträd5sträv3ström2st3s4s3tvis5svag_s3vagn4s3vaksvars33svart4s3ver4s3vils4vines5vitt3svåri3sväng2sålde2s5ägg2s3ört3tade_4tads5ta5kretak4totall5sta4nabt4ap3ltar4mita1strta4tan3tavlote2g1rte3grete4int5te5löten3g45tensiten3trte5nör5teriöter3k45ternates4tete5stu5tetiktifts5ti2gel5tikul3tillv3tilläti4van5torapt5ord_torm3stor1st4tort_t5ost_3trafit4rala5tralo3tralst4ralt3transt3ras_t3rat_t4rato4trer_4trern3tribu5tricktrids3t5rielt1ringt3rockt3rono5tross5trotnt4rump3truppträds4t3räkn5träni5tröjats5artt3s4att5slotts5läkts3ordts5tert3stolt4stont2strat4stryt4sturt5styrtte5g4t4tinstt3radtt3rattt4sta4t5ugn3tungatung3s3tvingtvär3s3tvätt3tyngdtäc4ko3törertörs3ttö4vasubb4leub3licud4retuf4tanu3itetuks5koulds2mull3änuls5tiun4domung5itungs4pu4pernu3pletup3lik3uppfaup4pin1uppla5uppläup4p3rupp5spur5arvur4stäus5anlu3schaus4klaus3penus5tatus3tigu3stikus5tinust5ro3utjämut4rerut5rop2utsid3utslä3utvecva5droval4lival4st4vand_van4stvan5trva4resva4ri_vart5rvas5ti5vattnve2s5pvet5savett5svild3s3vind_3vinklvis5kovis3tavi4varvmörk43vrerav2skrivs5tråv5stycvångs3vägg5s3värdevä4ril3världxan5d4y4brisyk5lonym4fory5schoyst3razo4nalåg3s4k5åklag1ålderåll4spål2s5eåman4sård4ra5årsavås4skräl4papäl4segäl4sluäl2t3räl4vinänd1stänni3säns5teän2t3rär2breär4nisärn3stär4skoät4s3kät4topö4darvöde4s5ö4karmöns3keönst3rö4raskör3d4rör1eniö3ringör3intör4kalör1k2lör5kliör4nisör1s2kör4släöts5ko5övere");
            put(7, "_a5g4ra_a2n5es_ang4er_a3sket_a5sten_bild3s_e2l5in_e5skad_es3kal_es5kap_fågel3_för1en_in4ger_kans4k_kort5s_kring3_lek5tr_mas2ke_minis4_mörk5r_o3stra_papp5s_pa3ste_pa5sti_pi5sti_pres2s_re2ste_slut3s_sten3s_tes3ta_topp5s_tred2s_u5trerack3u4pa5kvariandel2sansis3tans3par1ansvarapo3str1apparaa4rigenark3lanar5skalas2s5opa5stardast5raka5stralast3rolbors5tebort3sl2b5ratic4kordndels5tidenti5öder5stidin3g4odis3tradrotts3dub3bleechiff5e3glerae5gleriekord5sek4ret_enning5ens4vinerings3erk4liners4kene4s3kenes5ten_esti2gees5tor_est5rerfib5rigfi3skalfros5tafru5strfurs5te4gerarbg3starkgs3tillhands4lhan5g2ahop5plohy3sterhård5s4ic4kordik5skorilufts5ind5skäind5stiing4es_in5glasings5tein3skrä3instruis3kopais4s3tri1stansist5attis5ten_i1stentis5tingis5tor_is5toreit2t5opjor4dinjord3s4jut4stajäl4p5rjärn3sk5kaptenk5arbet3klang_k5lock_5klocka3korres5kra3gek4retenkrid5s2kropps5k5rädd_k5slag_kstavs32kvente5lakan_3laktis3lande_5laste_lat4tisler3ste2linga_lings5tli3strölläggs5lt5ratilus2s5plycks5tman5g4omask3romer2skome5trinm5planemst3rin4mun3g45målet_mö4gen_nd5skalne5gresne5s4tinfalls5n4gentings5timngs3valnings3knings5vnist3ranslags5n3stansn2striknst5vilnter5s4n2t5ombn5tralant3ralints5koroförmå4ogno5stoll5släon5stelons4teron3traso5plineoran3g45organi3orientors5tigo5stillost5ronota2lanpek5tripekt3ropel3s4ipos4terpre3stapres5to3rande_3raste_rek5trirgs5toprhands5rs5kollrs5tendr5stenirs5tillr2taktirv2s5käsamman3san3slasilver33s2kada3skaffn5skapet4skogsgskor1sts5kran_3s2langslotts33smitta5spann_4spelsls3plats4s3prissse4linss2lag_3stalla2stalli5stark_5stenar3s4tene3stense5stensms4teriu3sterne5stetiss4tiken5storis3straff3strato5stride2striel1striktst5risk2strumm3strängs1under5svärm_sys5ter2taktig3tande_2t3anfa2tappar5tavla_3tavlan5teknik5tekniste5stik3tillst5tivite3t4ral_3t4ralet3rets_t3ring_t5ronik4tropi_trus5ta5tryck_5trygght5s4andt5skallt3skatttt3randuk3trisull3ste5underl1undervun5g2efurs5tin2v1aktivensk3äving3s45vinst_5vinsteväll4s3xem3play5klistys4tik_åk4sträård4s3tår5s2liäls5kogär4tandö3randeö4reströr5evigör2p5la");
            put(8, "_and4rar_cy5klop_e5strad_krings2_mjölk5s_män5sko_skott3s_string4_vatten3ali5stikas5tikerelekt3riennings2ent4rat_ent3ratieri5stikgi5stralhandels35inspeln3instink5klist3r5korterakrings2kkru5stad2lapparallust3ral4skensv5längderni5sterinkrafts5n4tropinos5tikerpul2l5ov4ran4d3r5ringen_rreligi5rskotts3rslags4v5rullerasinne2s35stalgis5startad1steringstori4eu4strativ5tallise5tartavl5torietttran2s5atskotts5ts5tillf1undersöun3gerskun5tratiutlands35ventera4ändligh");
            put(9, "_ma5skeri_pub3likad5rasseragi5st4rat");
        }
    }), la("la", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "æ1œ11b1c1d1f1g1h1j1k1l1m1n1p1r1t1v1x1z");
            put(3, "2bb2bdb2l2bm2bnb2r2bt2bs2b_2ccc2l2cm2cn2cqc2r2cs2ct2cz2c_2dd2dg2dmd2r2ds2dv2d_2fff2l2fnf2r2ft2f_2gg2gd2gfg2l2gmg2ng2r2gs2gv2g_2hp2ht2h_2kk2lb2lc2ld2lf2lg2lk2ll2lm2ln2lp2lq2lr2ls2lt2lv2l_2mm2mb2mp2ml2mn2mq2mr2mv2m_2nb2nc2nd2nf2ng2nl2nm2nn2np2nq2nr2ns2nt2nv2nx2n_p2hp2l2pn2ppp2r2ps2pt2pz2p_2rb2rc2rd2rf2rgr2h2rl2rm2rn2rp2rq2rr2rs2rt2rv2rz2r_1s22s_2tb2tc2td2tf2tgt2ht2lt2r2tm2tn2tp2tq2tt2tv2t_v2lv2r2vv2xt2xx2x_2z_");
            put(4, "a1iaa1iea1ioa1iuae1aae1oae1ue1iuio1io1iao1ieo1ioo1iuuo3uc2h2k2h22php2pht1qu22s3s2stb2stc2std2stf2stg2stm2stn2stp2stq2sts2stt2stv2st_a1uaa1uea1uia1uoa1uue1uae1uee1uie1uoe1uui1uai1uei1uii1uoi1uuo1uao1ueo1uio1uoo1uuu1uau1ueu1uiu1uou1uu");
            put(5, "_e2x1_o2b3l3f2tn2s3mn2s3f2s3ph2st3l");
            put(6, "_a2b3l_anti13p2sic3p2neua2l1uaa2l1uea2l1uia2l1uoa2l1uue2l1uae2l1uee2l1uie2l1uoe2l1uui2l1uai2l1uei2l1uii2l1uoi2l1uuo2l1uao2l1ueo2l1uio2l1uoo2l1uuu2l1uau2l1ueu2l1uiu2l1uou2l1uua2m1uaa2m1uea2m1uia2m1uoa2m1uue2m1uae2m1uee2m1uie2m1uoe2m1uui2m1uai2m1uei2m1uii2m1uoi2m1uuo2m1uao2m1ueo2m1uio2m1uoo2m1uuu2m1uau2m1ueu2m1uiu2m1uou2m1uua2n1uaa2n1uea2n1uia2n1uoa2n1uue2n1uae2n1uee2n1uie2n1uoe2n1uui2n1uai2n1uei2n1uii2n1uoi2n1uuo2n1uao2n1ueo2n1uio2n1uoo2n1uuu2n1uau2n1ueu2n1uiu2n1uou2n1uua2r1uaa2r1uea2r1uia2r1uoa2r1uue2r1uae2r1uee2r1uie2r1uoe2r1uui2r1uai2r1uei2r1uii2r1uoi2r1uuo2r1uao2r1ueo2r1uio2r1uoo2r1uuu2r1uau2r1ueu2r1uiu2r1uou2r1uu");
            put(7, "_para1i_para1u_su2b3r2s3que_2s3dem_");
            put(8, "_su2b3lu");
            put(9, "_anti3m2n_circu2m1_co2n1iun");
            put(10, "_di2s3cine");
        }
    }), nl("nl", 2, 2, new HashMap<Integer, String>() {
        {
            put(2, "1b1çè1ê13ëî31ï3ñ1q1ü1z");
            put(3, "_a4_b4_c4_d4_e4_é2_f4_g4_h2_i4_j4_k4_l4_m4_n4_o4_p4_r4_s4_t4_u4_w4_y2_z44a_4aea2ë2aha2qa1ta4üä3hä3r4b_3ba4bbb4o4bvby34bz4c_1ca2cbc4d1ce1céc3g3cic3j1coc3w1cy4d_1da2db1de3dè1di1do2ds2dt1du2dv2dw1dy2dz4e_4eae1de4ee2ie3oé3aé1dé1gé3hé3jé3né3pé3ré1t4ècè2lè2sè5tê2pê5t4ë_ë2bë3cë3dëe2ë3jë1l5ënë3pë2së1t4f_1fa4fbf1c4fd1fe1fé3fè3fê1fif1jf1n1fo3föfr44ft1fu4fv2fz4g_1ga4gd1ge1gé3gè1gigl41go4gs4gt1gu4gv1gy2gz4h_4hb2hdh4eh3hh3j2hlh1n2hr4hs2ht4i_i1a4ic4iei1è4ifi1hi3ii2j4ik4is4iti5w4izît42ï_ï5aï1cï1dï3oï1tï5z4j_j3bj1cj1gj3hj3j2jkj3r2jsj3vj1w4k_1ka1ke1kik1j1ko2ks4kt1ku2kû2kvky32kz4l_4ld1li2lm4lp4lsl1w1ly4lz4m_1ma4mb1me3mé3mè3mê1mi1mo2ms2mt1mu2mv1my2mz4n_1na2nb4nd1ne3né2ng1nin3n2ns2nt2nvnx31ny2nz4o_4oao4e2oë4oio3ï2oko1ö2oso2v4owo4xö3lö1pö4rös44p_1pé3pêpr42ps2pv5qequ44r_r1cr1gr3hr3lr1mr1p4rs4rtr1wr3x4rz4s_1sc3se3sé3sès1h1sisj2s1ms4qs2t1sus4y4t_1te1tétè33titr44ts4tv4tzu1a4ucu1du3èu1hu2i2uk4up4uzü4bü1n1v22v_v4bv4e3viv3j3vlv3tvy32w_2wbw1cw1gw1hw1j2wnw1p2ws2wtwu2w1wx1cx4ex1fx1hx3lx1mx1px3rx1tx3wxy3y1ay1cy1ey3èy1fy1gy1hy1iy1oy1py1rys3y1t4z_4zb4zc4zdz4e4zf4zgz2i4zm2zs2zvz4w5zy");
            put(4, "_af3_es3_eu3_ik3_in1_om1_os5_st4_ts4_ui2_xe3a4a44aad4aag2abr4ac_4ace4ack2acl2acr4acu4ad_2add2adh4adk2adl2adp2adsad3w2adyae3ra3eua4ër4afa4afe4afiaf3l4afoaf1r2afy4ag_a2gr2agta1hiah3la3hoah5ra3hua3hyai1ea1ijai5ka2inaio4aiu4aïn42a1jaka2a2kr2aksak1wa1la4alda1lea3lèa1lo2alpa1lu4am_am4i4amm2anca1no4ans2a1oao4gao2la4oma3os4ap_a1paa1peap1j2apl4apr2apt2apu4ar_a1raa1rea1riark2a1roar2sa3ru4arwa1ry4asaa2sc2asea4sjas3kas3las3mas3n4asoas1pa2st2atg2atm2atnat3waua41augaup2aur44aus4auz4avia2vo4avy2a1way2a4b1cb5de3b4ebe1abee4be5gbet24b3f2b1g4b3h3b2i5bilbir34b1j4b1k3b4l2b1m4b1nbo2kbo4sbo3v4b1p3br4b5scb3sibs5s4bt4b3tab1trbts53b4u2b3w3ca_ca3bcae3cau3ca3v4c1ccca3c5do3cedcee43celceo4ce2s4ch_2chc1ché4chn2chp4cht4chw1chy5cij5cilci3o5circ3ky1c4l5clu2c1nco3dco4i5com2cooco5vc3p4c3soc3sp2c1tct5c1c2uça4o3da_3dae3dag3daida3ïd4am2d5cd5do3de_de3g2dei5dekde4ode2s2dex2d1f2d3gdg4l2d1hd5hedi2a3dig5dildi2o5div2d1j4d3l2d1md5ne3do_do3a3doi2dop5dou2dov2d3p1dr43dra2dredse2d2shds4ld2smds3nds5sdst4d1syd1tad1thd2tjd1tod1trd1tu5duedu4ndu2od1wed1wid3wre3aae1abe3ace1ade1afe1age3aie1ale3ane5ape3aqe1are1ase1ate1ave3boe5br3ecde3ce4eck4ect3eczed1seea4ee5bee2fee3iee2kee2l4eemee2nee2ree2tee5vee5zeën3e5ër4efie1fle1fr4e1ge2gle1h4e5haei5a4eidei1ee3ijei3o4eize1j2e3jee3koeku4e1lae1lee3lé2eli2ema4enf3enqe1nueny4eo3de5oee5one5ooe4ote1pae1pee1piep1je1ple1poe1prep2se1ree3rie3röe1rues4ee3sles2me1sne1soe1spe3sue3sye1tae3tee1the1toe1tre1tu1euceu3ee1ume3uu2euw4e1we5wae5weew2he5wi4ex_4exi1expeys4e5zae3zoezz4édi3èta5ëen3ën4eëns2ënt2ë1raë1reë1rië1roë3siës3tët4sëve54ëzu3fab2fadfa3gfa3mfa3vf3dafe2af4er4f1ff5fef5fiffs2f3fuf3g2fge34f5h3fib5fie5figfi3ofi4rfi4sf3kef2l24f1m3fob5foc5fokfoo4f4orfo3t4f1sf3scfse2f2shf2sifs2mfs2pfs4tf3syf1taft3hf1tof1trf1tu3fus2fuufva23fy13ga_3ganga4s3gat2g5b2g1cg3deg3drg3du3ge_ge3age3c4gex4g1fg5geg5gig5gl2g1hght4gi2f2gijgi2m5gir3gis4g1j4g1k4g1m2g1ng3nagn4e4gnu3go_3gob2goc2gofg4og4gohgo2kg2oogos12g5p1gr43grag2scgse4gs1jgs3lgs3ngs3pgs5qgs5wg5syg1tag3teg1tog3trg1tu5gu_3gueg5vo4g1wg5wa4gypha3gha3v2heahe2fhe4i2h3f4h5ghi5dh3la2h2mh3mah3meh2nahno32ho_ho3aho2fho3v2h1phpi4h4rehri4h3sah3sph3stht3w4h1w3hypi3aai4abi4aci3aei3aii2ami3ania3oi3ati3cei2drid3wieë2i2ekieo4i4epie2uie3vie3zi3ési1éti4ëgif3lif3rig4ai3geigs4i5ieii2ni5is4ij_ij5a4ijd4ijeij3i4ijnij5ui3kei3kli4krik1wi1lai3léil5fi3liil2mi1loi1lu4im_4imfi3mu1infi1noi1nu4i1oio5aio5bio3fi3oli3oni5ooio4si3oxi2ozi1pai1pei1piip1ji1pli1poi1pri4psi3rai3réi1rii1roir2si1rui1sai4sci4shi4skis3lis3pis5qi5syi1tait2ii4tji1toi3tuit3wiu4miu3ri3veiwi2i3zeïn3uï3riï3ro4ïs_ïs3aï4scïs3lï3soïs3tja3b2jaf1jag1jar3jawjaz4jda2j3drjd3wjea4jel4j1en5jepje2t5jeu2jewj3exjf3ljf3rjf2sjft2j3gejif3j3igj3kaj2krjk3wj1laj1lejl5fj1loj3luj3mijm3sjnt44joij3omj3opj4oujoy3j3paj1pejp1jj1pojps4js1ajs3nj2suj3syjt1hj3trjt1sj1tu1j4uju3d4jumjus32kafk3ahka3i3kamkao3ka4s2k3b2k1ck3ca2k5dk4eb2kefke2sk2et2k1f2k3gk3ho2kiëki3ok3jo2k1mk3makni2k4ockoo42k3p1kr43krak4siks1jkso4ks5sks4tk1syk1tak3tekt1hkt3jk1tok1trk3tuku5kku2rkut3k3ve2lac2laf2lall4anla3q2laula3v5lawl4az2lb42l1cl3drl3duld1wle2alee4le5ole2sl4folft42l1g4l1h3lid3lièl4ig2lixl3kel3kil3kolk2sl3kwl3ky2l1ll5lal3lol3mel3mil3mo2l3nlo3alog42lorlo3vl1pal1pel3pilp3jl1pll1pol1pr4l3rl3sils4jl1sll1spl1stl2sul3sy4l1tl3trl3tuly5im4agmaï4ma3qma3vm5blmb4r2m1c2m1dm5dam3dom3drm3dwme1cme4im2el3menm4es2mex2m1fmf4lm5fo2m5g2m1h3midm2is2m1j2m3l2m1m2m1nm5na5mo_mo3amog24mok3mom2mop5mosmo3vm3ox2m1pm3plmp2r2m1rms2cms2jm1slm1snmso4ms4tm3sym1tam1thm1tom3trm1tumue42muk5mut3muu5muzmve42m1wmy3emze43na_2nac5naen3aëna1h3nai3naï3nam2napnas22n1cn3cen5con3dend1wn3dy3ne_nee43nemne2n3nesne2u2nex2n3fng4ln3grng2s4n3h3nilni3o3nisn1j4n3je4n1knk2jn4kw2n3lnn4i3no_1noc3noï1nom1nos1notno3v3nox3noz2n1pn3ps2n3rn5ren5rin3sin1slns3mn1snn1sons5qns5sns4tn3syn3tan3ten3tèn3ton1trn3tu3nu_3nuc3nue4nuf2nui3numnu2n1nus4nuu2n1wn3xenxo4o3aao2ado3afo1ago3aho3aio1aloa2mo3auo3avo3ax2o3b4ob_3obj4obr4ocaod3woe3e2oep4oerof3l4ofoof1r4oftog1lo3gy2o1h3ohmoi1eoi3joi5k2o1joku4ok1wo1la4oldo1leo3lo4ols4oma4omeom2i4omm4omo3omz2onco4o24oo_oo3c4oofoo4goo4l4oonoo4soo4t2opa4opfo1piop3l1opno1poop1ro4ps2opto1rao1reo1ri4orpor1uo3ryos3fo3sio4sjo4skos3los4no3suo5syo3teo1tho4tjo1to2otro1tuot5w4ou_ou5aou1cou1e4ous2ovi4ovl4ovrovu3o1wao1weow3ho1wiow2no3woow3roys4öpe1ös5tö5su3pabpa3e1pag3pakpa4m1pap5paz2pb42p1c1ped3pegp4el3pes2p1f2p1g4pho2pidpi5op3jip1jo2p1kp2l22p1m2p1np3na3po_3poë1pol1pom1pospo3v4p3pp5pap5pep4psp2ra4psep3sip1slp1sp3psy4p1tp3tep5tipt3jp3tr1p2u3pubpu3e3pun2p1w1py12p5z5quor2aa2racra3ora3q2raur3cer3co2r1drd5lr3dor3du3re_r4ef1reg4reqre2ur3fer1flr1frr4igr5j4r3knrk2rrk1sr3mo2r1nr3narns4r3nuro1ar4oc3roë1roïro3v3royr3pa2r5rr1slrs4mr1snr1sor1spr3sur3syr1tart5cr3tor1trr1turt3wru1e4rufru2gru2kr2umru4r4rut4ruur4whr3yu5sa_s1aa1sab3sah3sai3saj2saks2alsa2p1sat1sax4s3bs5bas5bes5bo2sca4sce5scè2sci4scl2sco2scr2scu2scy4s1ds5des4dhs3dos5drs3dw5se_se2as4ebs4ees2els4ems4ens4esse4t4sez2s1f4sfi4sfu4s5g4shesh3l4shm5si_5sicsi5è3sirsi4s3sit3siu3siz4sj_s1jesjt4s5jusk4is3ko4skus2l4s2n43so_so1c1soe5soi3soï3soks2ols2om3soosos4s4ot2sov4sp_sp4asp4o4spt4s5rs5ses5sis5sls5sus5sy4st_2stb2std2stf4stg4sth2stk4stl2stm2stn2stp1stu2stv2stz5su_5sua5suc5sud3sug2sui5suk3sul5sum5supsu4s4s5v4s1ws5wo3sy_4syc3syn4s5z2tac4tadt2alta3ota3q3tas3tau3tax4t3b4t3ct4ch3tea3tectee2t4ef3teht4elt4emt4ent2er3test4ev2tex4t3ft5ge4th_4thm3thr2thu5ti_5tia5tibt4ilt2is1tj22tjo2tju4t3l4t3m4t3n5to_toa23toc3todt4oeto2f3toit2olto3vts2jt1slts5qts5st1sy4t3tt5te3tua3tub4tukt4umtu1ot3ve4t1w1ty13typtys4t3zat3zit5zwu3acu3anua3puat42u2bu5biu3bouda2ud1wu3ecu3efu3eiu1elu1eru1euu3ezu1fluf2su5gaug1lu2goui3e4uig4uik4uim4uisui3v4u3juk1wu1lau1leu1lou3lu2umeun2cun3gun4ou3olu3onu3oou1oru3osu1pau1peu3phu3piu1plu1pou1pru1ra4urfu1ri4urku1rou3ru4urvu4scu4sju4smuso2u1taut5cut2hu2tju1toutt4u1tuut5wu4u44uutuw1au1weu1wiuw1ouw1ruw3uuxa3u3yaü3riüs3lva2nva1pva3z4v3c3ve_5veb3vek5vel5vemve2rvi3ovje45vo_3voe3vog3voi3voovos33vot3vouvu2lw2adw4ag4wam3wapw4ar3way2w1dwe2a3wed3wegwe2mwe2n2wex2w1fw4ijwi4k3wil2w1k2w1l4w1mw3new3niw3now3obw2oewo4lw3scw1slw3spw1tow1trwva2xaf4xa3gxan3xi3gxi5ox4opx3sox3spy3aty3coy1d4y5dryes3y3ésygu2y4iny5isy3lay3ley3loy3nay3noyn1ty3ony3osyo3typo3yp3sy5riys4iy3syyto3yu5ay3uiy1w4ze5k2z3h3zifzi4t4z3k4z3lzoi4zo1pzo2tzo3v4z3p4z3r4z5tzus32z3z");
            put(5, "_aan5_aat5_ab5l_adi5_af5l_af5s_al3f_alk4_ar5d_as5h_as5l_as3t_as3u_at4a_bos1_coo5_cus5_da2k_dan2_de2k_di4a_di3o_do3v_du4w_ede2_ed3w_ee4n_eet3_ei3l_ei5t_en5s_ep4a_er2f_ert4_es5c_et4h_eus5_ge3s_gid4_go4m_ij4s_ink2_is5c_jor5_ka3d_ka5g_ke4s_ko3v_kun2_lof5_lu3e_lu4s_ma5d_ma5ï_me2s_mo4s_na3d_na3n_ne2p_ne4s_no5v_ol3f_on3a_on3d_on1e_on5g_on3i_on5k_on1o_opi5_op5l_op3r_op5s_org4_ove4_pu2t_re5o_ro4l_ro5v_sap3_sa5v_sci3_see3_set3_se5v_sno2_te4a_te4f_tek2_te4s_ti2n_to4p_to5v_tsa3_ty2r_ui5s_uit1_uke5_ur4a_zes5_zit5aad1aaad1oaad1raaf5aaag1aaag3eaag3oaag5raags4aai3laak1aaak1oaak5raal1eaal1iaal5kaal5maal1uaam1aaam3oaan1aaan5gaan5i3aanj3aannaan3oaant43aanvaap1aaap3iaap3raar3aaar1i4aarnaar3uaas3eaas3i4aastaat3aaat5eaat3haat3iaat1oaat5raba4la2bonab3rua3cala3car4ach_a3chaach3la1choa3chr4achsa1chuac3kl2a3co4actaa5da_ad3acada2dada4ladas5a5de_ad3eia5desa3det4ad4i4ado_a3dooad5sead3soad3uiaege4ae5k4a3e2pae2s3af3aaaf4asaf4atafd4iafd2rafee4a5fo_a2foeaf3opaf3s4afs2caf5se3afsl3afspaft4aaf5traf3uiag3afag3arag3dia5ge_ag3exa4gil4ag1lag3ofag4raag3ruag3slags2pag1stagu5a4a1ha4a5heah5t2ai5a2ai4drail3mai2loai3ovai3s4ai5scai5snai1soai1stai5tjai3traïns5ak3afak3agake2tak3idak5is1akkoa2k3nak5neak4nia3kofak3onak5ruak4soak1stak5toak3wia3lala5le_2alegalf3lalfu4al2gla3liealk3sal5leal5mealo2nal3ouals5jal2slals5mal4sna2luiama4f4amag5ambta2meu3ampèam2plam4sma3nad4anda2andja4nema3nen4aner4ang_an2granij4ani5t4aniv4ank_ano3sano5van1stan3th2antiant3w4a1nua5nufan3uian3uran3uua2op2aor5taos3paos5ta4paka4pas4a1piap3leap3liap3loa1pluapon5ap3ooapo3p1appaap3raa3preap3ruap2saap4siap3snap3tjar2daardo4ar4duard3wa3rega3remar4ena3revar3ghar2glarm3ua3roka3rotarpi4ars2ear3siars3lars5mar4soar4spar4su4artear2th4artoar3uias3adas4agas3akas1apas5cea4secas5haasis1as5jaas3jias5kaas5kias4luas5mias4neas4nias3obaso2laso4ras3pla4s5qas5sa4assm3assuas3teas3tèas1to4astras4tuat1acata3s2atekate2nat4euat3hua2t3jat4jea2tooat5ruatsi4ats5mats3nat2stau3chau3coau5deaud4jau3naaun3tau5reau3soau3t44aut_1autoauw3aave3cavee4a5vooa5voraxis44azifämme3ba4dabad3sba3gl5b2akbale4ba3lobals4ba4meba3saba4stba2trbbe2n4b1d4bdi5abe3asbe2aube3chbeet1beie4bei3sbe5kibe1kwbe3lebel5fbe3libel3kbel4obelt4be5otbe1raber4ibe3rube3rybe1s4be4shbe3sobe5spbes5sbe3twbid3sbi2dubi4enbij5dbij3fbij1pbik4abi3lobi5obbi3okbi5ombi5owbi4stbi1trb5ledbles3b5lidbli2kblu2sbody3boes4bolk4bo5nabond23bonebo3nobo3p2bos3abo5sibo5sobos5pbot3jbo4tobot3rbo2tubove4bri4lbro2nbru2l4b1s4b2s5absi3dbs5jeb2s5mbul4kbu4lub5urbbu5ribus5cbus3obut4abut3jbu2tobut4sca1ch5cadaca3doca3drca3g2ca3loca3nacant4ca2ofca1prca3racar4uca5secas3tca3tacces53ceelcel3dce5licel5k2cenece3no5centce3racer2nce5roce5scce3taceto43chaï5chao3chas1chau1chef5cheq5ches5chirci5abci3amcie3kci1euci5lecil3m4cindci5omci3t2ci5tac2k3ack3efck3idc2k3lck4lec2k3nc4k3rck5seck3sock5stcla2ncle3uco3adcoin5co3k4co3la5condcon1g5cons3copa4copico5ricor2o5corrcors4co3ruco5scco5seco5spco3thco3tr5coun2cout1c4r23crascre5d2crip3criscro5fcro5kcroo3cro5vcrus5c3stect3adc2t1hc2t3jc3tolct4orct3slct3spcu5d4cu3encu3éscui5scui2tcu3k4cu3racus3o3daagd4aald3aap5daat4daboda4ce4dadr2d1afda3geda2guda3ke2dakk4dalad3alcda3le4dalfda3li2dalmdam4a2d1ap5dapud3arb3dare3dari3darodar3s3das35dasa3d4atda3tadat5j5daue3dauwdbei54d3d4dde2nddi3addo3pde2alde1chdee4ldee4rd3eied3eigd3eild1eisd3eiwde3kedek3wdel3kdel2s2demh5demid2en_de3nude5oldeo3vder2edes3mdes3ndes3pde3stde3t4de5twdeve44dexpd4gafdge2tdi5aedi4ak5dichdi4dodie2fdie2tdi1eudi2gadi3jo2dinfdi4oldio1s3di4sdi5sedi5sidis5pdis1tdi3thdit3jdit3r2d3k2d5le_dli4n2d3n2dni3s2dobj3d4oe5doe_doe5d4doef5doek5doen5doetd4ole5domid3omr5domud3omv4domz5don_d4ona5donedo5nido3nudo5ny5donzdo3pad3opbd3opd5dopj3dopod3opsd3opzd3orkdo3spdot3j3dovl3dovo5dra_d4rac5draf4drap4drasd1redd2ree4dretd3ric3dris5drop2drou2drozd4saadsa4bd3salds2chd4sefd4seid5send4setds3hods2imds5isd4s3jds4jod1slads5mods4ned3snuds1o4ds3obds3omd4sonds2oods3opd4spad1spid1stad3steds3thd1stods5tyd2su4ds3uu2ducadu3endu3et5duid5duif5duikd3uil2duit5duivdun5idu4ol3durf3durv5du1sdut3jdvee3d3wacd3wasd3watd3wekd3wetd3wez4d1wod3wor4d3yody4spea3boea4caeac5tea3daea3doea3lae3alie4alsea5mie4an_eang3ean4sea3prear2ce2ascea3soe4at_eat3se1chee1chie3chuec5le4ecorec3taed4age3damede3aedem4ede5oed4ere5die4edired3ove3d2red5seed2sled4soed5sped3sue4d2wee5caee5deee5doeed3wee3faee3fieef3leef3reeg3lee3kaeek1eee3kiee3kleek3neek3weel3aee3leee3lieema4een3aeen5gee3nieen5kee5o2ee2paee3pleepo4eer1aee3reeer5kee2s3ee3sjee3snee5teeet5hee3tjee3toee3tref3adefa4zef3doef3eie5feref3lie3fluef3ome3fooef3opef3sfegas4e3g4iegip4e4go_e2goseg3s4eg5soegut4ehit4ei3do4eienei3f4ei3gl4eigneik4lei3knei5kreiks44eil_4eileeil5mein5kei2noei2saeis4p4eit2eive4e5kamek4eeek1eie3kemekes3e3kete5kice4kile5kisek4nie5kofe5koreks4eek3toek3urek1uuel1acel1ale3lane3lapel1aue3lazel4drel4due3le_e4lele3lere3lesel1flel3gue5liee5lig3elixelk3sel4kw4e1loe3lokel3ole3looe5loue5lozelp4oel4ps4e1luemes3e5mokem3opem3saem5scem4smem1stem3suemut4en1acen5afe2nale2nane3naten1avenci4en3daen3dre3neee3neuen5gaen3gleng4rengs4e3niee3niveno3sen3ouen3su3entèent4ren3twe2nunen3uren3uueodo3eoes3e5offeo3freo5nieo3paeo3peeo3ple5opseor5de5orge5orieo3roeo3s4eo5steo5tee3paaep3ace4pafepa4ke3pale3pape3pare5pe_e5per3epide3potepou4ep4rae3prieps3leps5neps3pep2tjep4tr4equae3ra_e1raae3rader3afe1raierd4o4erecer3efere2oerg2le5rife5rige5rike5rioe5riser2kner5moer5nue1ro_e3rober3ocer3ofero2ge3roker3omer1oner1ove3rozer3sjer5teer3tre3rube2ruie2rune3ruser5uu3erwte4safe3same5sanes3ape5sece5seles5exes2fees5hee4shie3side3siees1ine4sires5kres4laes4lee3soles4ooeso4pe3sples4sme3styesu4re3ta_et3acet3ade3take2tape5tate4taue2tave5teae5tek4etele5teset3haet5hue5tiee4tiqe5tise4tjae5toce3toee3toleto4pet4slets3nets4uetu4ret3weet2wi1eua4eu5dreu4lie3um_e2umdeu2naeun3t1eu1oeu2poeur5keus4peu4steu3tjeu1treu4wa4everewo3vex3af4exco3exeg3exemex3inex5ope3y4oey3ste3zeeédee4égee5ê3perënce3ën5scën5thën5twëro3sëven4f4aatfa2bof3accface4f1ach2f1affal3sf3angfant2f4armfa2tofda4gf5danfd1arfde4kfd3offd4rafd5sefd3sifd3sofd3spf4d2wfd3wofede3f3een5fees3felife3no3fes32f3exff3shff3sifge5tfi5acfi4alfi3amfia4sfi1chf3ijs3f2ilfi3lo4find3finif3inj4fink2finrfi5sef5isofjes54f1k4f1laff4lamf3leif4lesfle2t4flevf4lexf3lez2flie2flijf4likf4lipf4litf3lokfoe5d2f3of2fomsfo5nafo1no4fontfooi5f3oom5foon2fo4pfo5ri5formfo1ru4f1ov4f5p45fracf3radf2ras5frauf1recf3rek5freqf4rikf4rodfrus3f2sa4fs3adfs3anfs3arf5schf4scrf4seifs4fefs5hef3siefs3imfs1infs3mafs4mifs3mofs3mufs3obfs3omfs4oof3stef3stif3stof3strf3stuft1acfta4pft4smfts3nft4softs3pftu4r2fuitfu4ma3f2unfur4ofval34f1w4fzet5g4aat2g1acg4af_g3afdga3fr4gal_ga3lagal3s4gambgan5d5ganega3pl3gar_ga3reg1arm3garsgas5cgas3igas3ogas3pgat5jgat3s4gautga5veg1avog5dacg5daggd3atgd3img2ding5drugd3sagd5spgea3qge5au2gebbge3d4ge5drge5dw3gee4ge3f4ge5g44geig5geitge3kege5kige3krgek4ugel5fgel5kge5ma4gembge5mogems3g4en_3genigen5kge1no5genwge5omge5osge5otge5p4ge1rager4ige3sage3scge5sege3sige5slge3snge3soge5swge3tage2thget4oge3trge5tuge3ui5g4ev5g4ezgédi44g3g4g4g5hg2hetgh5teg2humgi1eugif5rgi3gag3ijs4gijzgi3na5ginggin3o2ginrgi4ocgi2odgi2org5lab3glaig5lat3gle_g3leng3lesg5lev3gliëg2lifg2limg2lob3glofg5log3glomg3lopg5loz3g2lygne5ggne5m3go2ag1och4goefgoe1r5gom_go2mag3oml4gomzgo5no3goot2g1opgo3pag4oprg4oragor2sgo3tr2g3ovgpes35gra_g5rakgra2m5gravgre4sg4reug3rev5griagrof5g3rok2grougro5vg3rupgs1a2gsa4ggs3eigs3engs3etgs3evgs5heg3siegs5isgs4lags1legs4logs4lug4snag5solgs3opgs4pigs5psgs5scgst2ag1stegs3thg3stugs5tygtes4gu4eu2guitgu4nigu2s3h3afdha5ge5hals5halz2hamp4han_hap2shat5jhat3she2ar3hechhe3co4hee_hee4kheis4he2klhek3whe3lehe3lihelo4he5mohe5ne4he5ohe2prhe1rahert4he2ruhe5sehe2sphi3kwhil3mhin5dh3ins2hir2his5phi3trh4lagh3leph3loch4merhoa3nho3chhoe4shoe3thof5dhof3eho3g2ho2kaho5mohon3ghoni4ho1no4hoom2hootho3paho1pehop3r5horlho3roho3ruho3sahot3jho3tr2ho4whow3ohra4bh5reahro2kht3ach3talh3te_ht5emh3tenh4tevht3exh2t5hh2t1jht1o4ht5oph4t1rhtse4ht2siht4slht1u2hu4ba3huizhut3jhy4lahypo1i5abii3adyi5ae_i3agri5ak_ia3klia3kri3al_i3alii5am_i3amiian4oia5pai5apiia3scia5seia3soiave4i5blei1chai1chei1chii1choi3chrick5licos4i3damide3aides4idi3ai3dokid3ruid2s1ids5iids5jids5lid4smid3uuidu3wie1a2ie3deied3wi1ee4ie3fiie2flie4frie3geie4klie2knie2kuiel4eiel5kie3mai3ennierk4ie3ruie3sfie2siie4slies3mie3tji3etyieu3ki1euri1eusi1euzi4ëvaif3aaif3adif4raif3uiig3aaig5aci5galige2sig3ijigi3oig5noig4opig3skig3slig3spig3unija4dij3efij3eiij3elij1erij3o4i3jou4ijso4ijsp4ijstij5teij4tr4ijvo4ijzoi4kamik3efiket3i2kijik3lai2k4ni3komi2kooiko2pik3reik3riik3roik5seik5siiks3nik3spik1sti3la_il4aail3acil3adil3afi3lakil3alil2dailds44i3leile3lile4tile3uilk4l1illuilme2il4moi3looil1orils5jil2thi2magim5auimee4im3exim3opim5paim1stin1aci2nau1induinek4ineo2i5neuin2goin4gr4ini_i3nie4inkjin2kn3innoi3noci3nodin1onin3ov1inri4ins_in5sein3slin3soin1spin5tein3thioas5i3o1ci3odeioes3io3g2i5ol_i5ongi2op4io3paio3pri3optio3rai3oriio3rui3os_ios3cio5shio5siio5soio5spi3osyi3otiiot3jio3tri2o3vip3afi3papip3luipo4gi2priip3ruipse4ip4siira3ki1r2eires4irk4siro3piro5vir4scir3spirt3ri2saais3apise2dis5hoisi2di2sijis3jais3kais3keis5lei4s5mi4s3nis5no5isoli4sooiso3si2sotis2piis5plis5sais5soi2s3tis1tais4this1toi3stri3styisu2mit3acita5di3teni3terites4ite4tit1hoit1huit1ruit1sp4i3u2ium3eium3oiwie2iwit3ize3tïe4n3ï2n3aïns5mïn3sp1jaarja3knja3mija3plja1pojare41jas3jas5pjba4ljd3anjdes4jdi3aj2do4j3domjd5onjd3opjd1stj2d3u3jebaje3ch2j1eeje3laje3rojers4je4s33jesajes5ljes5mjeso23jesr3jevrj2f1ajf5lejfs3ajf4scjfs5fjfs3ljfs5mjfs3njfs3pjf3stjf5tijf5twj2g3ljg3snjg2stjin3gj4kaaj4karj4kauj4kavj2kijj2k4lj4klejk5lij2knaj4krajk3rejk3roj3laaj2loejm3opj4naajn5acjn3akjn2amj2nefjne4njn3gljn3k4jn4sijn2spjn1stjn3trjoet3jol4e1j4onjone2jo3pejo3rajo3ru1jourjp3ijj1pinj3pioj1plajp3lij4prejp3rij4sefj2s1ijs5injs4irjs4lejs3lijs4mej5soejs3olj3spejs3plj4spoj1stajs3thjt1acj1tagj3takj3tanj3te_j3toejt3rajt3rijuve5jve2njve3tkabe2ka3bo2k1acka3dok3advk3afdk4affka3flka4gaka3le5kalfkal2k4kalt5kalv4kambkan5d4kang5kap_ka3pekap3lka1poka3prkap3sk3arckart4kas5ckati4kat5jk3atlkato4ka5trkat3s2kavokdi3a2k3ecke4dikee4r4keffk4ei_k4eiek2eilkei5tkel5f2kemm2kempken5kke3toket3w3k2euke4vl4k1ex2k1h42ki2d4kiedk3ijs4kijvki3loki3na4kinb5kingki5sekit4s2k3jak3jew2k3ju4k5k41k2l45klack4las5klemk3lesk5lic4klidk3ligk4limk5lob4klod3klok5klos4kluc1k2n44knamk4nap5kneck5nemknip13knol2knumko4bl5koekkoes3koge43k4okko5ko2kolm5koloko4ly4komgkom5p4komzk4onikoot3ko3pa4kopbko1pe4kopg5kopjko2pl2kops4kopz2kordko3rukos4jkoso44koss4k1ov4k3oxkpi3skra4bk3refk2regk4rit2krolk4ron2krou3k4ruk5rubkru4lk3salks3anks3apks1arks3asks2e2k5secks3edks3epks3etkse3vk5silks1ink5sisk5sitk1slaks3leks3lik4smoks3naks3noks3nuks3omk1spek3spik3spuk1stak1steks3thk3stik3stokt3ackte2ck4texk5tijkt3imkt3ink5titkt3omkto4pkt4orku5bekui2f2kuitku5me5kunsku3raku3rekur3s3ku2sk2wadk1wag4kwat2kwegk1wei5kwelk2wiek4wik2kwil2kwin4k1wo2laanla4cal4aci2ladj4ladmlad5sla2du4ladv3lae3la2fala3fllafo2la2golag3rlags4la4kila3kr3laldlal4o3land4lannlan2sla3pilap3l2larmlase4la2sila3telat5j5laufl2auwlava3la4vo4lazildak4l2dauldi3ald1ovld1reld3sald3slld5spld3uule3atleeg3lee5lleem33leen4leep2leeu2leffleg3lle4goleg5s4leig4leks5leldle2le5lelil3elp3lenele2no4lep_le4sale3scles3mle4sples3tlet4ileus45leuz4lexc4lexpl2faclfa3sl2faulfe4nlf3lilf3lul5foelf1opl5foul1fral3frulf4sllf4solf5talf5twlf3uul4gapl3glal3gogl3goolg3s4lgse5li3agli3am5lid_5lidmli3eu3liftli3go5lijn4lijp4lijtli5krli4kwlim4ali3mi2limp4linfli5ni3linn2linrl3inv4linzli3obli5omli3otli2pali3pi2lisol5iswlit3r4l1j2lk3afl5koel5korl5koul5kral2krelk4selk4solk3willa3dlle3kll4ellleo4l3l4illo5fl5lonll3shl3maalm3aflma5ïl3maklm3aul4medlme2sl5moglm3orlm5sclm3shlm3sulni4s2lobj4loeg4loesl3oeu5loevlog5llo3go5logrlo4krlo2ku2lo2llo3lal3omll3omtl3omv4lomz3lon_4lond5longlon3o2lont3looklo3pa4lopbl3opdlo1pe2lopn4loptlo3relo3rilo3rulost4lo2talot3jlot3rlou3s2love3lo5zl3paalp3aml3parl3paslpe2nl2pexlp3ofl3pomlp3onl3posl3potlrus5l4saal1samls3anl3sapls3asl2satls4cul4sefl5senl4sinls5jal3slal3slols3nal3snel3snol3socls3ofl3solls3opls1ovl2spals4pel3spil2sprl3stal3stels4til3stol3stuls5tyl3surls3uslt4aalt1acl4taml3thulto4llt3sllt3splu4b1lub5elub5llu1en3lui_5luia5luid2luitluk2slu3na3lunclu3talut3jlu3wily3stmaas3m3actm3aflma3frma3glma5goma3grma5kama5kema3kwma5noma5pama3prma1so5massma5tamat5jma3trmdi3amdis5mdo3pme5demee5g5meesm5eg_m5egdm5eggm5egtmei2n5melome4mim4en_me3namen5k4menqme5nume1ra5merkmes3mme3some4sp3metime5trmeve4mfa3tmf3limger44mid_5middmi3kn5milimi3lom3imp2minf5ming4minhmi5numis5fmi4stmi1tr2m3k25moda5mode2moef5moeimoe2s5mogemo3gl5mole2moli4moltmo5no5mons3mooimo3pam1opem4oppmop4smo3ramo3romo5scmot3j5mouwm5panm5penm4plum5ponm4ps2mp5scmp3shmp5sum3samms3apms3coms3cum3sjem2slem3s2mms3mam3solms3orm3s2pm3stam1stem1stim1stomst5smtes4mu5da2muitmul3pmu2m3mu3nomu3samut3jmuts2mvee3mzet53naal2naap5naatn3abd5nabena2can2aci3naconad4e3nadi4n1afn2akena3krn3albn3alm2naly4nambn4amin3ampn3ank3nantnap3s3naro4narsna1spn4at_nat5jna3tonats45nau_5naus2na3v3navinbe5tn3chencht2nch3un5da_n4dapn2darn4dasn4davndi3andi3on5do_n5docn4donnd3ovnd1rend4smnd3spnd3sune5acne3am3neckne2clne3don3edune5dw4neednee5k3neemne3g24n1ein2eigne2la4nelf5nenbne4ni5nenpne5ocne5okne5omneo5pne5osne5otne3pene1ra2nergner3une3ry4neumng3afn2garn3gavn5genng3ijng2lin3goeng3ofn3goïng5opn3gotng4senhek5n4i2d3nieunij3fnij3kni5krnik4s3nim_5nimfn3impn3inb2ninfn3inj2ninrni5ornip3lni4slnis5nni1trnits4njes4nje3tnk3afn3kefn3kennk3idn3knenk4rank5senk5sink3slnk3snnk1spnk1stnk3wi2n3m4n5n2enno5v1no3d2noefnoes3n5ogi1nogrno3klno2li1nolon2oman3omln1omsn3omv2nomz3nonc4nont3noodno1pen1opg2nops2nordno3re1norm4norr3nors3norzno3sfno3snno3sp3nota5notinot3jnot3r3nou_3novano4ven3sagn1saln1samns3ann1sapns4cin4scon4sefnse4gn2sinn1sjon4slen4smun2snan5snen2sofn3soln2sonns4orns1ovn1spens4pins1pon1sprn1stan3sten1stin1stons5tyn5tabnt1adnt4asn5tecn5temnt3han4thon5tignt4jont4ognt4oln5tonnt4oon4topn5trynts3ant1snnt1spnt1stntu4nnu3ennu3etnu2lo5numm3nuncn3uni2nu4rnu5ronu3tr5nuutnuw5a4n3yi4n3yoo1a2nobal4o3chao1cheo3chio3choo3chrocke44o3cooco3aoc3t4od5acoda3godes4odi3ao5druod5scod2slods4toe5anoe3asoe4droed3woe5er1oefeoe2fioe2floeg1loeii4oei3noe2kuoek1woel5foelo4oen3ooe4ploe4psoe1raoer4eoero24oes_oe3sioe2tjoet3wof3arof3ato4favofd3wo4flio4floof3omo3fooof3opo3forof3oxof5seof4slof2spof4tuof3uiog5acoga4log5deog3dioge4d2ogemo3ger2og5h1ogigog5neog3opog3spog3uioi3doo3ingoi3o4oi3s4oi5scois2poist2o3ka_o3kaaok3abok3ago3kalok3efo2k4lo4kliok5luo2k3nokos5o2k3rok4raok1saok3snok5teok3urok3uuok2wiol3aco3lalo3le_ole5gol1eio3leno5leroleu2ol2faolf3lol3frol2glo3liao3lico5lido3liko3lino3litol5keol2krolk4solk2vo5locolo3kol4omo4lopol5seol5siol1sjol3sool3sp4o1luolu4rom2aaom1acom1afo3manome5tomo5lomo3s5omroom3slom3uion1acon4agon4anon3apon2dro5ne_o3nebon3eiong2rongs4on5ido5nigon3knon5kwono3lon1onon3scons4eons2fon1st4ont_3ontvon1uion3ur4oo4dood1aood1oood1roo3fioog1aoog3eoo5gioog1roogs4ook3aoo3keook5loole2ool5fool5gool3kool1uoo3meoom3ioon5aoon1ooo4p1oopa2oop3roor3aoor5ioor5koor5moor1o4oortoos3aoo5seoos5noot1aoot3hoot5ooot3rop3adop3amo3pan3opdro3pe_op3eeop3eio1pelo5pico5pis4op1jopoe3op1ofo5pogo5poio5polo4pruop5seop5siops4mop3snop3soop3spop3su4opt_op5trop3uior1afora4gor4door3drord3w4orecoree4or2glo5ria3oriëork2aor3klor5knor3kwor3nior3oeo3rolor1onor1ooor3oro3rosor5ovor5scor5seor3soor3spor2too4saco5saso3sauosca4o4scios3cuo5sedos4elo5seros4feo4shao3shios2hoos5koo4s3mos5noo3s2oos3paos1pio4spro2s3tos4taos4thos4toos1tuo3sty4o1taot1acot3afo3tagotas4o5tato5tegot3eio5teno5terote4tot3huotli2o5tomoto3sot3ruot2slot3snot3spot3uio3tulou2doou3k4ou3saous5coust4ou2taout3hout1jout1rouw3a2o3vao5ve_o5ves4o3voo5wenozet54paan5paasp3acc2pachp4aci5pacu3pad_pa4da4padvpag2apa3ghpa4ki3palepal3fpa3lipa3na4pank5papipap3lpa3popa3pr4par_p3arbpard43park3parl4parmpa5ro4parrpa5rupa5sapas5cpa5sepa5sopa5te1pathp3atl2paut5pauzpa4vl2p3d2pe4al4pecipe3depe3dop4ee43pee_3peeë4peen5pees4peispek5spe3lepe3napen5k5pennpent4pep3opep5sp4er_pe1ra3perc1periper1o3persp2ertpe3sa3pet_pe5ta3petipetu53peuk5peutpge5s2p1h44p3hap4hispi3ampi5anpi4at5pieppi3gl3pij_pij3k3pijn5pijp2pijz2pind4pinr2pinspis5npi3thpit3jpit3r2p1japjes5p3la_p3lapp4lecp3lepp4lex4plijp4lompoda53poei3poezp2ofa3pogipo5grpol4s5ponypoo3d3poolpoot34popd2popepop5hpo3rop4ortpo3rupo1sapo3sfpo5tepot1jpot3r3poul3pra_p5rad4pram3praop4ratp4rax1prem3pres3pret4pric1prij3prik5priv1proj3promp4roq3pros4proypru2tp3sabp3sakps3arp4sinp5sisps3leps2meps5mip4sofp3solpso4rps2plp1s4tp3steps5thp3stups5ty5psycp3syspt3adp2t1hpu3ch4pun_3put_put1jput3rpvan4que4s2raan3raarra4cara3ce5raclrad4a3radbra3di4radm4radv2rafdr4affra5gira5gorag4s3raisrak5rr3altra3mir2amp4rana4ranj4rap_ra3pora4skra4slra1sora2spr4atirat5j3rausr1aut5ravrrces3r3chirda2mr3danrd3eirdi3ardi5or5docrdo3vrd2rurd3sard3sord1sprds4trd3surd2wird5wo1reac4reakre3co3recr3reda3redd3redure5dwree4kree2pree4s4refb2reff3reflre3fu4reg_4regd4regg3regire3gl4regt4reie4reil5reizre4kore4kure1kwrel5k3rem_2rempre2nar4end5renfr4enn4renqre4ofre5parer4s2rerwre3sare5sere4slres3mres3tret4i2retn3revo2r3exrf3alr3fasrf2s2rf3smrf3sprf3uurg3eir3glorg1s4rg2smrg5sori4agri2akri5anrias4ri4avri4bl4riceri3cori3diri1euri3flri3frri3glr4ijlrij5o4rijvrik5nril5mri3ma4rindri5ner4ingr3inl4rins4rintri5onri3scrit3j3rittr5ka_rk3afr2kahrke4nrke4sr2klor4kner2kobrk4rirk5sirks4prkt3hrk4tirkt3orkt1rr1kwar1kwirmes3rmi2sr5moer4moprm1strmun4rnes3r2ninr5notrn3smrn3sprn1strn3thrn5tjrn5tornu5rro5acro1ch3roe_4roef4roeg3roem4roevr4ofiro3flro3kl3rokmr4ol_2roliro5maro3mo4romzr2on_r2oner2onir2onkr2onnr2onsro3nu4ronv3roof2roog4roonro3pa4ropbro1pe4ropnr4oporo4puror5dro3roro3saro5sero3sfro3shro3spro5terot3jro3trr1oudro4ve4roxir5peerpi3sr2p3jrp4lorp4ror3psarp4sirp2slrre5orreu2r3salr3sanrs3aprs3arrs3asrs2crrs4etr4sj4r5sjtr3smers5mur5solr2sorrs1ovr3sper4spur1s4tr3ster3stir3stor3strr3styr5ta_rt1adrt3amr2tarr4taur2tavrtes4r4thart1hert3hir1thort3hurt3hyrt4ijr5tokr3trart3rirts5mrt1sprt2wi5rubrru4grruk3iru2lirul5sru2mi3run_r2undru5rar2u4srus3erut3jru3warves41saagsa3bo2s1acsa2ca3sacrs1adv2s1af3safe3safosa3frs5agg3sagnsa3go3sakss1akt5sal_3sald5salhs3all4salms3aln5sammsam5ps4ancs4ant3sap_sa3pasa4prsa3ras1arb3sardsa2res1armsaro4s4ars4sas_3sasasa3sc5satis3aud1saurs1aut3sauz4sch_sch4as2chi3scoosdi5asdis5se3akse3alsear4se3ause3cr5sect4secz5seeisee4t4seevs1effse3geseg2rs4ein2seis5seizse1kwse3le4selfsel5k5selmselo45selp5selts5emm5sen_5senhsen5ks4ergser4ise3roser2sse3ruse5scse3sf5sessse5tase5tise3tjset3rset3wse3um4s1exse2ze4sfeds5fei4s5frsfu5msgue4s4ha_sha4gs5hies3hoes3hoos2hot3shows5hul5s4iasi5acsi3amsi5ansici4si3co3sie_3sieësiep4sies4si1f45s2igs3ijv5sile3simu5sinas3inb2sinfsing4s3inhs4inn4sinr2sint5siros3irrsis3isi5tosi3trsi5tu5sjab4sj3ds5jeb3sjee1sjers3jes3sjew5sjofsj3s22s1k2s5kads5ken3skiës2k3js5kres3k4w4slabs4lac3slap4slaws3leds4leps5less3li_4slid2slies3lifs5ligsli2ms4lip3slofs3lols3los3slot4slun4s3ly3smad3smals5mapsmie2s4mijs5min5smoks3mons5nams4nar3snau3snees5negs3nies5nim4snods3nog2snoosno5v3snufs4nui2snumso4bls3oce2soef3soepsoes33soft2so2gs1ogeso3gl3sogy5sol_so3laso3le5sols5somms3omv2somz3sonas3onb2song3sonns4onss3onw2s1opso3prs2orbs3ordsor4oso3sfs3oudsou2lsou3ts1ove3so5z2spad2spaks4pans3paus4peks5pep4sper4spess3pezs3pids3piss3plos3plus2poe4spoë4spog4spols2poos3pop4spou4s3pss2p4u4spub4spuns4pur5spuwsro5v4s3s4s4scosseo4s4spa3stad2stafs4tags4taks4tap2stas4staus4tav4staz2st5c4stea4stecs4thast1hi2stia2stibs4tim2stiv2stob2stocs4tols4tops4tov1s4tr3strust3scst5sest3sfst3skst3slst3sost5spst5st4stub4stuc5stuk4stus2st3w2s4ty1styls5typsuba4sub5esu5bl5suik5survsus3esuur5sve4r1sys5t4aalt3aap3tabe3tablta2cata4de5tadot3adr2taf_4tafft4afr4tafztag3r5taka5takgta3kl5takn5takp5taks4talbta3li4talt4tamb4tamp5tan_t4ape5tapita3pl5tapota3ra5tari3tarw5tasa5tasj5tasota3sy4tatatat5j3tatr4tautt3a2ztba2lt5chat5chet5chit5chu4t3d2tdo3v4tecot3edutee4g4teekteem13teertee4tt5eff3tefl4teigt4ein5teit4tekk3teko3tekste3kwtel3ftel5ktels42temb4temmtene23tenh3tent5tenu3terj3termtes3mte3sote3tate5tr5tevl3tevr3tex_4texp4t3g2tger42t1hat3haat4hadt3hakt5hamt3hart3hav5theat3heb5theo3thes3thett4hint1hoet2hogt3hokt1hoot1hul4thumt4hurti5abti5aeti3ap5tica5tice5tici5ticuti3d45tie_5tiep5tiesti1euti3feti3frti2ga4tigm5tijdtije45tijntij5pti3koti5kr4tils5timm5timo4tinft3inht3inq4tinrti3nu4tinwti5omti5sati3slti3so5titeti3th5tiviti4vo2t1jat5jaat5jeet5jekt3jent5jet4tjeut1jou4t3k2t5le_5tlebt5lestli4ntmos5tne4rtnes4to3acto3arto5bl1tochto3da3toejtoe5k5toen3toer3toev5toeztof5dto4fr3togn5togrtok3sto3lato5let3olf2toli5tolot3oly4tom_t3omlto3mo5ton_4tondto3no5tonstoo4m5toont4op_to3pi2topmto4pot4oppto4pu5tor_to3rat3ordt4oritor3ktoro45torr3tors3tos4to3sato1sl5totato3tr3tourto3w44t3p4tpi3s3tra_3trag5trau4trea2trec3tref4trelt4reutrig22trij3trogt4roï5trojt4ros3troutro5v5truf4trugt3rukt4rumtsa4gts1amt3sapts3astse4dt2sijts3ja3tsjits2mets4nots3nuts3obtso2lts3omts1onts1ovt3spit3stat3stets3tht1stots5tyt4su4ts3urts3usts3uut5t4atte2nttop2t5t4rt5tumtt3uu3tuch3tu3e5tueutu3és3tuig5tuin4tuip2tuit5tune5tunn5turbtu3ritut3jtu3wat2winua5neu5ar_uar5tua3saub3acub5emub5oru1cheuc4kiucle3u5da_ud5amud3eiudi4oudoe2ud3ooud3ovu4d1ruds4mud1stue2cou1ee4u4eneue3stu5eulu1f4rug2doug4drug3ijug3oru2g1rugs4pui5acuid4suid3uui2fauif1luif5rui2fuuig1lui4guui2koui2kuui2lauil5muin5gui2nouis5cui4sluis5pui4st1uitguit1j3uitl3uitw3uitzuk3asu2k3lu2k3nu2k3ou3kocuko2pu4k3rul3aculam4ula4pul3flul5foul3frul5keu3losul2paul4piul2poul3saul3soum3afum3ar3umdaumee4umes4um3omum3opum3soum3stun3acund4sune4t1univuno3gun2tjuo3ruuota3upe3ku3polup3omup3opup4trur1acuras3urd4ou1r2eu4remure4nu3resur2faur3giur3oruro5sur5prur2slur2snur4spur3taur3uiu1r4y4usaaus3adus1apu5sieu4s5lu2s5nus3oïus3osu2s3pus5pius5puus4tau4stiustu4ut1acut3afu3tanu4tekut3emut3exut3houto5futo5suts2mut1snut3sput2stut5suuur5iuur3kuut3auut3ru3waguw3aruw3ecuwe5duwes4u3woeuzie2ût3s4va3deva3g4va2kiva4klva2koval5mva3lovalu5vand4va3nova3reva5seva3suva3tevat5jvee4lvees4ve3level3kvem4ave4na5vendven5k2venrver1aver3over5pver1uve3ryve2s3ve2tj5ve5zvi3euvijf5vik4sving4vi5omvi1sovis5pvi4stvi1trvjet1v3larv3lovvoge4vo2levo2livol5pvoo5dvo3ravot3jvous53v4r2vrei5vues4vul5pwaad3w2aarwa4b3wa2bawa5blwa3drwa2law5arc5wardwa2si1watewat5jwa3trw4doo2we2cwede4weg3lwei3swe3liwe2lowel3swem3awe3mewena4we3niwen3ower2f4wergwer4swe2s33wet_we2thwie4t3wijdwij4sw4ing2winrwin2swit3jwit3rwn3acwoes3wol3aws3a2w3somws2plw4sprw1s4twtes3xan5txen4dxe3roxie4txo3noxo3s4xpre2x2takxtie2ya3s4ycho3ydi3aydro3yl3alylo3lym5payn3ery3p4hypot4yp5siy3r4ey1s4ay3s4cy5s4eyse5ty3s4fy3s4hy3s4oy3s4pys5plys4tays5tryt3huy2tofytop4y3u2rza3f2zak3rzan2dza3poza3s4zee3kze5gezen5kze3rozer2sze4s3zes5ezes5lze4tizeve2zik2wzin4szi3o5zipi3zit3ezit3jzodi5zo3f2zo5iezo3lazome4zo2nazot3hzo3trzz3inzz3orz4z5w");
            put(6, "_ac5re_al3ee_al5ko_al5ma_al3om_al4st_ana3s_an3d2_an3en_an3gl_an5th_ar5tr_ave5n_be3la_be5ra_be5ri_co3ro_daar5_da4gi_dag5r_debe4_dek5l_dek5s_de5od_de3ro_die4p_doet3_eest3_ei5sc_ei3sp_el4s5_en5th_ere5s_erf3l_er3in_erts3_es5pe_es5tr_eten4_fel4s_gaat5_gea5v_ge5le_ge5ne_ge5no_ge3ra_ge5sk_ge5ta_ge5tj_ge5to_goot3_ho4lo_ide5o_ijs5l_ijs3p_ijs3t_in5d4_in3g4_in5gr_in5kr_in5kw_in3s4_in5sl_in5st_in5ta_koot5_ko5pe_kop5l_le4b5_leg3o_le5r4_le4s3_le5th_lin5d_loot3_lo4s1_me5la_me5ni_me4st_moot3_naat5_na3s4_nee5s_nep3a_ne5te_noot5_nos5t_oe4r5_oe4s5_oeve4_omme3_ono5v_on2t3_ont5s_op5ee_peri5_po4st_puit4_ran4d_ren4o_ro4st_se5re_side3_sneu3_so2k3_song5_ste4m_te3le_te3no_te3ra_ter5s_tin3a_tin3e_to4lo_ve4r3_ves5p_vet3j_vie4r_vol5s_we4l3_win4s_zooi5aag3saaag5soaag3spaak3e2aak3spaal5a2aal1o2aal3slaal5soaand4raan1e2aan5k4aan3sp3aantaaap3o2aar3e4aar1o2aas5trabat4sab5eunab3ijzabot4jace3st2a1che4a1chiac5resada2r3ade5rea5detaadi3aladi4ocadi4odad3reia3d4riad3rolad1s4tad5staae4s5ta2f3acaf5d4wafon4daf5orgag1a2dag3a2magee5tager4sag3indagi5ota4g3orag4o3vag5rapag4sleag5sluag3speag3spiag3staag5stra2g3uiag3u4ra2g3uuahe5riai4s5laïs3o4a4k3ara4k3edak3emiak3ink4a2k3lak3o2pak5speak5t4wa2k3u4al3adra3l4aga5lapral3artal3effa2l3elale5roale4tjal4fenal5fonal3intalk5eial5kleal4kuial4maca4l3olal3sanal3scrals5lial3thaalt4stal3uital3u4ralu2s5a4m3acam3adram3artame5tjam3oliam4pleam4s3oam4spra2m3uian3algan4a3nan3arcanda4dan4dexan4domanen3ian3estane3usan4gananga5pang5leaniet33animaan5ionan4kaaanka4nan2k3jan4kluank3ofan2k3ran3ochan3orkano3t4a4n3ouan3sanans3cran4segan4sidan2so4ans5orans3pian4tacante4nant5slanze5sap3as_ap3assap3ijzap3o4v4appena4premap2s3lara3s4ard3acard3akar2d1rar4draard3re5a2reaare4noare3sparij3sar3insark3acar3k4lar4mapa2r3obar3ogearo4koar3oogar5schar3scrar5seear4slaar3sniar5spoars3taar4strart4aaar4tanar4tapar3tarar4teiar5tij4ar4tjar5tofar2t3rar4troart5ruart4slarwe3sa4s3egaser5aase5tjaseve44as3taa4sta_as5tagas4tasas4tata3steka3stemas5tenas3tobast3opat3adeat3af_at3anka5tellate3noati5niatjes5at3oogatos5fato3stat3racat3reiat3ribat4roeat2s3lat4sloat4sneats3pra2t3uiaure3uau4s5pau3stoauto3p2auts3avast4aver3aave3re1a4vonbad3arba4d3rba3g4hbak4spba3lanba4larbal3dwbal3evba3liëbal4klbal3sfba5n2aban4klban4krbank3wba3trobben3abe5dwebe5dwibe5dwobei5tjbe3k4lbe3larbel5drbe4lexbel3scbel3spbe3nepbe5n4ober4glber4grbe1r4obero5vbes5acbe4sjebe3t4hbe5tonbe5twibe3undbeur4sbie4libij3g4bij5k4bij1s2bil3s2bin4drbin4stbi3osobit4se2b5lapble2t3blijs44b5loiblok5lboe4knboe4koboe3stbo3f4lbok3anbokje5bok4stbo2m3oboot3jbo5scobos5tobot4spbot4stbou5tabouw5sbrie4tb2s5lab4stijbuit4jbune5tcal4l3came5rca4praca5prica3s2pcas5trcate4nca3t4hcau4stceles5ce4l3oce3s2ace3s2hce3stacesu5rce4t3jcet3ogcet3oo5chauf5chef_5chefs5chemiche5riche3ruche3usc4k3edcke5rec5k4etc2k3o42co1no2co1p2cor4drco4relct3actctee5tcte2n3c4t3ofc2t1onct3rapc4t3recuit5ecula5p5cur3sdaar5e2d3accda5denda4g3rda4kerda4k1rd3alarda2l3uda5macdames3dam4pl2da2nadan3asdank3ldan4sidan4smdan4stda2r3adar4modar5stda3stu4d5atl4d5atmda2t3r4d1autddags4dden5addera4ddere4dder3od5dles5dedirde4ditdee4g3deel3i4d3een4d3eff4d5eg_4d5egg2d5egydek3ludel4aadel5dadel5dr4delemde4levdels3idel4soden4acden3eiden3evde4nocden3sh5denvlde5ofodeo4lide3rabde3rakde3ramde3rande3rapde3rasde4repde4retde5rijder3k4der3ondero4rder5thder5twde2r3ude3rupde3savde3spede4spldes5smde4stide3us_deu4tj4d1exadge3ladgeto4dge4trdheer43d4hi_di4anodia3s4di4atrdi3esrdie3stdiet3rdig5aadiges5dijk3r2d3ijz2d3impdi5n2a2d3ind4d3inj2d5inr2d3ins4d3int2d3inv2d3inw2d3inzdi4onedi4onidio5sc2d3irrdis5agdis4krdis5trdlot4s4d3obsd5oefe4d5oev2do2lid4olindolk5s5dol5s3d4om_dom4sn5d4onndo3pee4d1opl4d5orgdo4riëdors5mdo3stadpren4d3raamd3raapd5race5drachd3rad_d3rada5d4ragd4ramad3rame4d3raz4d1recd5reco4drendd4ress3d2rev5drevedries45d2rifdri5gad3rijdd3rijkd3rijmd3rijs5d4rin4d3ritd3roer5d2rog4d3rokd3romad3rond3droog4droosdrug4sd3ruimd3ruit4d3rusd2s1a2ds4ated5schids3ecod4s3edd4s5eeds3eisds3elfdse4lid4s3esd2s1i2d4s5iddsig5ads4ingds5jonds5lasds5licds5limd3slinds4makd3smijds5neud5spand5specd4s3pld5spoed5spokd5spord4stabds3takds4tand5stavds4te_d5steed4stekds4terd4stevd3s4tid4stitds3ure4duit_d3uitd5duite4duitgd3uitvdu5wendvaat5dve5nadvies53d2weidy2s4te5ademead3s2ead5shea5s4eease5tec4taae3d4ane4d4ased3ei_ede5leedi3aledi3ame3d4ooed3opved3roded3roled3uite5dwanee5cheee2d3aeed4aceed5aseed3rueed3sieef3acee4gapee5kaaeek3akee5keteek3reee3krieek3roeek5stee3ladeel4eeee5lijeel5k4ee3lobeel3ogee3lu4eel3ureel3uueena4reen3e2een5ieeep3aneep3rueer3aaee4radeera4lee3ramee3ranee4reeee5reiee4r3iee5riceer3ogee3rotee5schees5etees5loee3s4pees5plee3stueet5aaee3talee3taneetna4eet3ogeet3ooeeto4ree4troeet3spefde5lefie4tef3inse3fis5ef3looef3rije5froneg3as_ega5skeg3ebbe4ge4ceg3eigege4raege4roeg3ijzeg3orgeg3oude5grafeg5slee4g3uueheis5eid4sceien5seie5re4eild4eil5drei4levei2l3oein4doein5grein5slei5shaei3sloei4tooeit4s3eits5ceits5nek3aanekaat4ek3af_ek3al_ek3altek3ange5ker_e5kersekes4tekla4mek3leve5klime4k3obek3oliek3opzek5os_ek5osse5kranek3rozek5setek4strek5t4eek3uitek3winel3aanel4adeel3adjel3admel3adrel3advel1a4fel5anae5lap_e4lappel3arbel3arcel3armel3artel3asie4lautel5aziel4decel3eeuel5effe5leidel3eig3e2lemel3empe5l4eneler4sel3erveles4tele4trel3excelfi4delf3s4eli5kwel3impe3lingel5inzel4keee5loepel3oesel3omsel5ondel5onte5loode5loosel3opsel5optel5opvel3o2rel5orgelot4jel4s3kel5tweel3uiteluks5e4manaema3scema5toemees5emer4sem3oliem3orge4mo4vem4sliem3uiten3aape3naare2n1aken3al_en3alsen3amben4ameen1a2pe5narien3arsenas3p3ency_en5daaen3d4oenede4en3eedenee5ten5eg_en5eggen3elaen3elfen3emae2ne2pen3epoe5nere5energe4nerven3etaen3eteen5grieng5seeng3sme5nijde2n3imen3k2aen3offe2n1onenoot5e3nor_en3orde2n1oven5sceen4seiensek53ensemens4feen4sinen1s2pen4tacen5teeen5teien1t2hen5tomen3treent4slents3me4n1uie4o3k4eop4laeo3p2rep3aakep5akeep3aspep5eenep3ijsep3ijzep3insepit4sep3lede5ploeep3luseprot4ep4sereps3taeps5toeps3trep4takept3raep5troep3uite5raader3aane5raate4r1ace5rac_e5racee5racoe5rad_er3adoe3raffer3amaer3anae5raneer3arce3raree3rarie1rat4er3azier3d2aer3d4ier3d2rer3d4wer5eater3eene5reeper3eeter5effer5eg_er3egder5egger5egter3eieer3eiger3eilere3kler3elker3empe3rendere4nee3renme3rentere4oger3epier3e2qer3erie3res_er3eske3ressere4ster3etne4r5exeri5aberig5aer3ijler3ijser3ijver5inder3inser3inter3m4ier3oefe5roeper3oeve1ro2le5rol_er3olie5rolle3ron_e3roneer3onver3ooger3oore5roose4r3operop3ae2r3orer3oxier4pluer3screr3t2her5t4ier5t4oert5seerts5ler3t4uer3t4we3rug5er3uite3runse4r3ur3ervares3arre3sa3se3scope3s2cres5eenes5enees5je_es5jese3s4joes5jone4s3kae5sla_e5slages3lakes5lates5leges4muie3s4nees3orees5pases4pele3stake3stapes4tares4teaes3tenes3teres5teses4tete3steues4tice4stiee3stotest4sces4turet3aanet3afz3e2tage5tak_et4anae5tande4tappet3edie5tel_e5telset5embet5emmete3roet3hore5toevet3opeet3opleto3sfet3rece3troee5trone5trooetros4e4t3ruet5sluet3speets3pret3spuet4steet5stiet5suueudi5oeugd3reu3g2reu4lereu4radeu4receu3reneu4reseu4rijeuro5veur4sueu5scheu3spaeu5streu5wineval4sevari5eve4loeve3raewen4s2ex3aa4e3zenezers5ëro1g2ëts3tef3aanb2f3a2p3fa5sefbe5dwfdek3lfde4s3fdes5efdes5lfde5smfdes5tf2d3inf3d4rufec4trfe4delfel5drfe4lomfel3spfe3rabfe3ranfe3romfe3ronfe4t3jfetu5rfge5r4fi3apafi3apo2f1ijzfik4st4f3laaflet3j3f4lorflu4t3foe5tafon5tefop5s43fo5re2f3oudfraam5frie4sfrie4t4f3rolf4rolof3romaf4s3ecf4s5eef5slaaf5slacf5slagfs3lapf2s1o4fs4prefst3asfs5tecf5stiff4stonfta4klft3artf5tondf4tontft2s3lfum3ac4g3adm4g3afs4g3afw2g3a4hga5lerg4a3mi4g3arb2g3artgar5tjga3sliga5slogas3trgd3artgd5ateg5der_gd3ervg4d3idgea3drgea5nage4ari4g3eb_gedi3age4ditgeet3a2g3effgege4s2g3eikgeit3jge3k4age5k4lgek4stge3k4wge3lauge3l4egel5sigel3slgel3sp4g3emf2g3empge3m4uge3nakgen4az3ge3nege4noggeo5pegera4pge5regge3remge1r2oger4ofge5rolger4spge3r4u3ge1s44ge3skge5spoge3strget4aage5tamge5t4ige3t4jge5trage5troge5truge5tsjge5t4wgge3lagie5ragier4s4g3inb4g3infg5infeg5infr2g3inhgip4st1gla4sglas3e3g4lazg5leerglee5t2g5lep4g5ler3gle4tglet3jg5liceg5lichg5lijs3g4lio4g3long3loon3g2losgo4d3agod4s3gods5tgo3f2r2g3ong2g1ont2g3oor4go4rego5re_5g4orig4ram_gram3ag3rampgra4s32g3rec2g3red5gredig5redug3reekg3reelg4reepg3reis4g3rek2g3remgren4sg5rijdg5rijkg5rijmg5ring5g4risgrit5s2g3rivg3rookg3room2g3rugg3ruimgs3altgs3ecog4s3edgs5eengs5enegs3ervg2s1i2gs5lamgs5lasg3slepg4sleugs5liegs4lings5loggs5lokgs5long4s5mag3snijg4s1o4g5som_gs5onsg3specg3spieg3spilgs5pirgs5polgs5tacg5stadg5statg5stedg5steeg3steigs3tekg5stelg3steng3sterg5stofg5stopg5storg4strug2s1u4gsver3g2t3apgte3rogte3stgut4sthal2f1han4drhan3gahang5lhang5shan3sohan4sthap4sehar4tahart3jha2t3r4have_hee3g4heek3aheek5lheep4shei5tjhe2k3ahek4sthel3smhen4krhe3n4ohe4pijhe2p3lher4aahe4r3ihe3roshero5v3hersthe2s5theu5lehie4f3hie4r3hier5uhie4trhiet5shij4slhik4s5him4plhim4prhi2p5lhit4sthoes5lhon3drhond4shool3ehoort4ho2p3ohor5dehor4sthot4sthrok3ohroot3h4t1a2ht3alah5tansh4t3echt4ecoh2t3eeh2t3efh2t3eihter3aht5eveh5tevoht5oefht5rooht4sapht4serht5slaht3smeht4s3oht3spehts3plht3sprht4stihur4t5huur5si2a3f4i2a3g2i3ake4ia4kemi4a3lai2a1p4ia3staia3t2hi5atriiboot4i4dee_idi5abi2di5oid4makid3ranid4s3aid4serids5maid4s3oids3taid4stiids5trid3u4rie4droie3fleie3fonie4gasiek3liie5kluiek4spie3kwaie5lanie5lapiel5doiel3sciem3ovien4drien3ijien5spie5peniepou5iep3s4iep5stiep5trie4puiie3ramie3rapier3asie4ratie3r2oie4rofier4slier4uiie5sleies3liie2s3nie2so4ie3staie3stoie4taaie5talie5tenie3to4ie4tooie4topie4toriet3uriet3uuie3twiieu3spif4taaif4tarif4treiftu5ri4g5avig3eski4gindi3g4omig3stoik3aarike4rai4k3loi4k3lui4k5naik5o2gik3opeik3ordik3s4lik3snoik4spaik5staik5waril5aanil4acti5landil4d3ril3eenilet5rilie5gilie5til3inkilk3s2illa3sil4minilo4geil3ondi5loonil3oorilo4reilo4veil3s2hil4stii4magoim3eeni4m3emim3enci2m3ofim3orgind4aaind3scin3ediin3eedinet4sin2ga4ing3aaing3aging3al3inganing5loing4stini5onini5sl3inkomin4kriin4o2gino5pein5schin3smiin5spoin5swiintes51int4rinuut3i5oleni5olusion4s3ions5ci3o5sei3o5sfi5osi_io5s4ti5o5sui2p1aci4perwip4sleire3stir5stei4s3adis3a2gi2s1ari2s3asi5schai5schris5coli5scooi4s3eiis3ellis5engise3stiset3jis4feeis4feri2s3imis5lagis5lasis5nedis5nijis4ooris3ottis5pasi3stakist3apis4tatis5triit3eenite3stit3hieit5oefit3oogi3t2oui4to4vit3redit3sjeit3sliit3sopits4teit4tooium3a4iven5sive3reï3n4urï5schejan4stj2d3aaj4d3arj2d3eejden4sjde3spjde5stj4d3rej4d1rij4d3roj4d3rujd5seijd3spojec4taje2na2je3n4ojer3sp5jesalje5sch3jesknjes5pajes4prjes5tr5jesvo3jeswa3jeswijet3erjeto4vjet5stj2f3eij4f3ijjf3inkj2f3o4j3f4raj3f4rojfs5pajf4stajf4stijg4s5eji5t2jjk3arbj3klaajk5lakjk5lapjk5lasj5kledjk5lesj3klonjk5lopjk5lucj2k3ofj2k3onj2ko4pjk3opbjk3opejk3oplj3kopsjk3raaj5kranj4k5rujk3slojks3pljk4staj2k3uijl5anaj2l3efj2l3eljl3inkj2m3afj5m4arj2n1a4j3na5gjna5mej3n4anjn5d2rj4n3imj2n1o4jn2s3ljn3slujns5orjns3pljo5lijjou5rej4p3acjp3armj2p3emj2p3orjp3rokj5selij4s5emjs3leejs5liejs5meljs5metj4s1o4js3pacjs3parjs3pooj5sporj4starj2s3tej3steejs4tijj4stoojs3touj3taaljt3aarjt3optj5tredj5treejt3reij5trekj5trokjt3rotjver4sjvie5sk3aanbk3aanl5kaart4k3adm3k4aft2k3albka3l4ikalk3akamen4kam4pakam4plkam4prka5naakan4slkan4st4kappak4a3rokar3tr4k3asika3strka4tan2k1aut2k3eenkeer4skei3s4ke4lapkel5dakel5drke5lel4kelemke4lomkel3sp5k4emake4nauke5nenke2n1o4k3e4qke3ramker3klker4knker4kuker4kwker4noker3o4ke3rosker4sm4kerva4kerwtke3s4pke3stake3sto5ketelke2t3jke2t3r2k3e2zkie4spkie4tjkieze4kijk5l4k1ijzkilo5v4kindukin3en2k3inhkinie4k3inko4k1inr2k1ins2k3int4k3invki2p3lki3s4pkker4skke3stk3ladikla2p15klas_5klassk3lastk3lat_k3latt3k4lav3k4led5kledi5kleed4k5leg4k5lenk3ler_4klerak3lers2k3lij4klijskli4me3k4lin5klok_k5lokak3lokek3lood5kloofk3lope2k5loz4kluih3k4nar5knie_4k5nivk3note2k5oct4k1oefkoe3tj5ko5grkol2e2kolen3ko2m3ak3omslkonge4k3ontb2k1oogkoot4j4k3opd3ko5pikor5do2k1org2k3orkkor4takor4tr4k3os_kot4stk4plamkpren4k5raad4k5radk5rand2k1rea2k3reck4ree4k5reepkreet32k3rel2k1rick3rijkk3rijpkrij4tk5ritmkron3t5kroonkrop3akro4tok3ro5v5kruiskrul5aks3almks5ei_k4servks3labk4slank5songk2s3pak4sparks3pook5sporks3potks3pruks5teck3stenkste4rks5tonk5stook4stopk5stotks3trik3stuekt3aank3taarktaat5kt3artkt3ecokt5ordkt5orgkt5orikt3o4vkt3resktro3s3k4u2n4k5uni2k3wac5k2wal5k2wam3k4wark5warek3weer4k1wer5kwetsk3wijzk3wind4laandl3aanhlaa5rel3abon5lach_la4cha5lachela2d5ala4detla2d3o4la2dr4l3afsla2g3alag5sala2k3a4la2nalan3aclan4dalanel5lang5llank3wla4norlans3llan4stlap3aclap3o4la5prela2p3ular3da4larm_lar5stlas3a4las3to5lastt4lats4lat3sllau4stla4zijlber4tlboot4lce4l5ldaat5l2d3acld3alfl4da4rld3arcld3arild3artld3ecoldeks5ld5oefld3olil2d3oml2d3onld3oogl4do4pld3opild3ordld3ramld3ratl5dreeld3rijld3roeld3rolld3romld3ruild3smald5steld3uitle4aneleba4lleege4leeg5i4leekhleep3olees5elees5llega5sleg3ecle5go_3leidi4leierlei5tjleit5sle4ko4len5kwlen3oplen3sflen3sm3le1rale5reiler5g4le3r4ole4ronler4slles5etle3s4hle3speles4tale3strle4s3ule4t4hle3thale5tinle4tople2t3rlet4stle2t3uleu3koleum3aleur4ol3f4aglf3enel2fe2zl3f4lolf3o4llf5ordlf5orglfs5eilfs3lelf2s3ml5gaarl3g4oelid3s4lie4grlie3kalie4splie4tolijk3a4lijmv3lij2s4l3ijzlik5spli3kwilin4da4l3inhl3inna2l3insli2p3lli5seeli1t2hlit4salit4sllit4stlk3armlk3artl4k3eil4k3emlken5elken4sl4k3eplking4lk3laalk3lagl5klasl5klimlk3ontlkooi5lk3opblk3replk3reslk3rijl2k3rolk3sonlks3oolk3stelks5trl4k3uulla3g4lla5trll3eiglle5thlmaat5lm3arclm3artlma3s2lm3edil4m3eplme5telm3olilmro4zlo4booloed3rloe4grlo4faalof5d2lof4s4log2s3lon4grloo5pi3looshloot3e2l3oph2l3opllop4lalo3p2r4l3opv4l3opw3l4or_4l1org3l4orslo3spelos5tolo5s2ulo4tetlo2t3hlo4toflp3aanlp3a4gl5pinglp3insl3p4lal4plamlp3opelp3ramls1a2dls3a2gls4corls3ecol3s2hil4s3imls3injls3inkls3intl3s2kil2s4lels5ledls5leels5legls5lenl2s3lils4linls4medls4meel3smidls3norls3o4rls3pacl3spanls3parls3plil3spool3sporls3pral4stafl4stakl4stekl4stevl5tamel5t4anlt4hanl4t3hil2t3holt3oliltra3slt3rugluids35luie_luks3tlu3stalut4stlven5slvera4lzooi52m3adv2m3afs4m3afwma3l4ama5lacmal5st5m4an_man3acm3analman5daman5domand4s5m4ann5man2sman4seman4somans3pman4thmant4rm4a5ri5m4arkmar3shmar5tima4stema3str5materma4tommat4stmbo5st5media5mediumee3lomee5remee5rime3g2amega5smei5tjmel5drmel4komel4krmen4asme5norment3wme3p2j2m3e2qme4rapme3raume4ravmer3eimer4klmer4knmer4kwmer5ocme3roome3rotmer4simer4slmers5mme2ru4me3s4hme4s4lmes5lime5slomes3pame5spemesto4me3stume3t4hmf5liemie5klmie3st4m3ijs4m3ijzmimie4mi5nar2m5inr2m3ins4m3inwmi2s3imi3t4amit4stmoed4smoes3pmo4lie4m3omvmond3rmon4somon5tamo3r4emor4spmor4stmo4s5lmo3stamo3t2hmot3olmot4st2m3oudmou4wimp3achm4p3afmp3armm4p3ecmp3insmp3lamm5planmp3legmp3leimp3levmp3liempon4gmp3opemp3recmp3redm5presm5p4sems3anams3lenms3liems3neems5tecm5stelm5stenms5tocmte5remunt3jmus5tamvari5mver3e5n4aam4n1aann4aar_5naars5naast4n3actna5d4a3nade_3nades4n3admna5dra2n1advn2a3g4na3k4l3n4ale5nalen4n3alf4nalysn3a2na5nant_5nantenap3acna3p4rnap5st2n1arb5nares2n3arg2n1armnar4st4n1art3na3sana1s4lna3stana3stu3n4ati4n3atlnat3sp5naven3nazifna4zijnbe5stnces4tnch5trnd3aannd5aasnd3abond3actnd3adrnd3alfnd3almnd3artnd3assnda3stn4d1ein5den_ndera4n4dijsn3d2jin4d5ofnd3olind3omdn5donand5ondn5donsnd3ontnd3oognd3opend3oppnd5rapnd3ratnd4rekn4dresnd3rotnd3rugnd4secnd5setnd3s4ind3sjond4spond3uitnd5uren4d3uunebe4sne4ditneel5dneel3o4n1eennee5rinee5seneet3aneet5oneet3rneet5s4n1effne4gel5neienn5eier5neigd5nei5tne4k3r4nelem4n3emb5n4eme4n3emm4n3emp3n4en_nen5done5nignen5k4nen1o4nep3agnepi3snera4dn3erfene3rosner4slner4spner4stness5aness5tne3stanes3tene4ternet3onnet4sine3umsng3anan4ga4pnga5slnge4adng3embn4gigsn4gindng3inkng5ladng5lamng5lanng5ledng5leung5linng5lopn2g1onng5oorng3oreng3orgng3racng3radng3rain4grasng4redn4g4ring5rieng3rijn5gronng3ruings5lung3uitni3erinie4trnig3ra2n3ijzniks3p2n3in_2n1indning3r2n3inh2n1ins2n1int2n3invni4on_ni4oneni4sauni4selni3sfeni2s3ini3sotnis5toni3t2hnje5spnje5stnk3aann5k4amnkar5snk3effnk3empnken4enk3ladnk3lodnk3lucnk3lusn2k3nan4ko4gnk3ogenkoot5n4krimnk3rolnk3s4mnk4s5onk3waank3weznnee5tnne3nennepo4nne5tennet4jnnoot5noen5snoet5sn5offin3o2geno3k2w4n3om_2n3omw3n2on_3n4onb4n5ondn4o5ni4n5oof4n1oog3noot3noot4j3no3pa4n3opbno4poono4por2n3opz2n1orgnpi4s5npoor4ns3a4dns3alpn3sancn5schonsee5tns5egens3eisns5empns3idin5singns3injns3inkns3intn5sla_n5slagn5slepns4letn5sleun5slibns3lien5slimn5slipns5macn3s4men3smijn3smolns3nodn4snoon4snotn2s3obns3ongns3onzns4oppn2s3ouns3padn5speen5spelns3pern4spetns3poln4spotn3stalns5tecns5tesns3then3stign4stonn3storns3uiln5taalnt3achnt4actnt3agan5t4atn4t3einte4lon5te2nn5tholnt3inwnt5oognt3oplnt3opmnt3optnt3recnt3reint3relntre4snt5rijnt4rount3rusnt5slunt4snont4sprnt5ste4n3uilnu2m3anu4s3onut4stnu2w3inve5nanzet5sobalt31o4bliob5oorocaat55o2ceaoco3s4ode4moode5reod5seiod3s4iod3sliod4s3ood3spood4sprod5staod4steoe2d3aoeda4doede4noed3reoed3rioed3rooe2d3uoe4f1aoef3laoef5leoef3looe2f3roege3loeg5ijoe4gouoei5s4oei5tjoei3troe4kaaoeke4toe2k3loe4k3roe4lapoe4laroel5droe3lemoe5loeoelo5poel3spoem3o4oen3aloe5n4eoen5groen4snoe5plooe4p3roe3praoeps3eoe2p3uoe4raaoe3roeoer3ogoer5omoer4sloer4spoe3sfeoe4slioes4taoes4thoe3stooe4taaoe2t3hoe5t4ioe5toeofd3eiof2d3oof2d3ro3f2raof5slaofs3leof3speofs3plof3spoofs3profs3troft3uroft3uuog3al_oge4roog3staog3stoog4strois5tjok3ankok5letok3o2lok3op_o2k3ouok3s4lok1st4o3l4abol3a2pol3armol3d4ool3d2wol3eksol3emmole3umol3exaolf5slol2g1ool4greol2g3uo5lingol3intol3kafollie4ol3op_ol3oppolo4veol4praol4s5hol3s4lol3s4nol3uito4m3efom3elaomen4some5spo4n3amona3thon5derond3reond3roond5sjon3d4uon4duron3erfon3ervone3st4onet_on1e3vong3ap4ongenong5leong5seong3spong3ston3k2ionnes4o4n3ofo2n1ovon5seion3s4mon2s3nons5opon3soron1s2pons4peon3splon5stron4taa3ont1hon4tidont5sp1ont3wood1e4oo5de_ood3slood3spoog3shoog3slook3s4ook5stoo4k5wool5a2ool3edoo5ligool3ijool1o4oom5a4oom1o4oon5duoon5k4oon5taoop5eeoop3o4oop4spoor1e4oor3g4oor3smoor4thoot3esoot4slo4p3aco4p3afo4p3akop3andop3at_op3att3opbreop5eeto3pen_o5per_o4peraop3e4vop3i2dopie5top3ijzop3in_o5pinaop5losop3ondo5poniop3ontop3ordop3o4vop3ricop5s2c3ops4lop3smaop3staor3achor3actor3admor3anao5rateor4daaord3orore5adore4noo5rig_or3insor5k4eor4masor3ontor1o2por3sagor3slior3smior4sonor5spuor4tofort5sporzet54o3s2co5s4clos5li4os3peros4piros4s5mosta3cos5tanos5taro3staso3statos5te_os4temos5touost3reost3rio3stroot3aarot3aktot3appot3artot3e2do5tee_o5teesote4stot3etao2t1hoot3offot3olvot3ontot3opmoto5poot3opro5t4oro1t4root5s4iot3slaots3liot3smoot4stuou4d1aou4desoue2t3ou4renou2t3oout5spouw5do2o5veeovi5so4p3afdpa4genp4a5gipa2k3a4p4akepa4k5l2p3albpalle4pal4mo5panee5panelpan5sppan4tr3pa3rapar3dapar4kapar5ta3partipart3j3partnparu5r1pa4s3pas4thpas5topas5tr3pa3trp3e2co3pectupee5li1p4eilpek5eepe2k3lpe2k3npel5drpe3l4ipel5sipel3sopel3sp2p3emmpe4nakpe4nappe4naupe4nazp3encypenge5pen3sapen5slpen3smpen5sppen5to2p3epiper4atpe5reqperi3spe3ronpe5rosper4sm3p4hecpie4tjpi2g5apij5kepij4lipi4k3lpilo5gpi5nam3pinda3p4ing5ping_pin4ga4p3injpink3rpink5spin4tapis5tapit4sp2p3ladpla3dip4lant1p4las3p4lat5p4layp3leid3p4len2p3ligp3lonep5loodp3loonp3luie3pneumpoe2s3poes5tpo4kolpo5l4opolo3p2p3oml3pondspon4smpon4stpon5tapoo5de4poog_4poor_po4p3a2p3org2p3orkpor4topo4taappe5nippie5kppij5pp5raad3praktp5rand4p3rapp3remm3prentp3resopret3r4priet3princ5prins3p4rio3p4riu5p4rob3p2roc1p2rodp3roed3proef3proev5p4rof5p2rogpro3lap3roodprooi5pro5papro5sc3proto3pro5vps3a2gps3assps3erkp4s3etp4s3naps3neups3optps3plep3statps5tesps3torpt3albpt3ricpuil3opul4stpunt3jpu2t3oput4stpvari54raand5raar_5raarsra5den5radia3radio4r3adr3rad3sra3fra3ragezra3g2nraket3ra3k4l4r3alfra4manr5ameuran4drran4grra4nimran4klrank3wran4saran4str3antw4rappa2r3arbr4a5re4rarit2r1arm4r3arr2r1artra5seiras3pora4tomra4trara5trirat3sprat4stra3t4ura4zijrbe4tird3alkrd5amar2d3arrde5o4r4d3olrd3ontrd3oosrdo3perd3rasrd3resrd3s4crd5stard5stere4adere3amb4re5atrec5ta2r1eenr5eenhreeps54reersr3eerwree5shrege4s4reindrei5tjre4kapre2k3lre2k5nrek3sprel4direld3rre4mai3r4en_re4naare3nalre5ne_re4nel2r1enire4nocren4ogre3nov5r4enpren4slr4entor3entwre4op43repetre4piere3qua4r1erf2r1ergre3r2o2r3ert4r5ervres5lere2s1pre4temre3t4hre4tikre5tinreus4t3revisr4f3aarf3actrf3levr2f3lirf3lusr4f3opr4f3rer5frear4g3abrg3ambrg4eisr5gen_rge4rar5glasr4g3lurg4o3vr5grijrg3ritr3g4roridde4ri4dolri4doorie5drrie5klrie3kwrie4larie4rorie4tariet3ori4gaar5ijldr5ijltrij3plrij3prrij3spri4k5lri3k4orim4pr4r3inb4r5infring5l4r3inhri4nitr3inko4rinkt4r1inrr3inst4r1invri3o5sri4samri3sotris5torit3ovrit4strk3adrrk3angr2k3eirken4srk5ieprk3ijvrk3inbrkjes5rk3lagrk3loork3lusrk3olmrk3omgrkoot5rk3opgrk3ordrk5os_rk5ossr5krisr5kronrk3s4frk3uitrk3waark5watrk3weerk3winrlofs5rmaf4rr2m3ebr2m5egrm3inhrm3opmrmos5frm3s4arm3uitr5n4amr4n3aprn3arsrnee5trne5ter2n5idr2n1onrn3oorr5nootrn3opsrn3overn3staro3d4oroens4roep3lroet4jr5offiroges5rok3spro2l3arol3g2rol3ovron4daron4kar2o1no4ron2tront3jront3r2r1oorro4paaro4panro5peero4pinrop3shr4opter4o5siro3t2hro5tonrp3aanrp3advrp3ankrp3eisrp5lodrp3ricrp3slirp5sperrie4trron5krrot4jrs3a2drs3a2grs3almrs3ambrs3anarsa4ter5schirseve3r2s3ezrs4ferrs4halr3s2hirs3hotrs3inirs3intr5sjacr5sjour4slanr5slecr5slepr5sleur5slibrs4liers3lobrs5makr3smijrs5misr5smitr2s3nars3neur2s3nors3ongr3spaars3padr5specr5speer5spekr5spitr5spoer5spogr5sponr5spoors3potr5spulrs3putrs5tasr5statr5stesr4stitr4stonrs3usar4t1acrt3af_rt3affr5tansrt3artr5tecort3eigrt3eilrt5embr5ten_rte3norte3ror3therrt3holrtij3krt3offr5tofort3om_rt3ondr4t3opr5torirt4raprt3recr2t4rurt5rukrt5rusrt5seirt2s3lrt3slerts5lirt4slurts5nort4soorude3rr5uitr4ru3kerul3aarul3apru3linrunet3ru3nivru5re_ru5resrus5trrut4strvaat5rve3sprw2t3j5s2aaisaai4s3s2aal3s4aats4a3gi3sa3lasal5ma3s2ame4sa2nasa3nats2a3ne2s3apesa5prosar3ol4s1art3s4ast3sa3te2s3atl2s1att3s2aus5scena3s4ch25schak5schap4schau5sche_s5chec4schef5schen4scheq5scher5schev5schew4schir5schol5schoo5schotsch5ta3scope5scopi3scout4scris4s3ech4s5eed4s1eens5eenhsee5ts4s3ei_4s3eig5sein_5seineseis4tsei5tjsek4st5s4el_sel3adse4lakse4lassel3el5s4elssel3spse2l3usem3oose5nanse4net5sengrse4n3o4s5enqsen5tw5s4er_se1r4aser5ause4reese5ren5sergls5ergo5sergrse5rij4s3ernse5ropsers3pser3stsert5w2s5esk4s3eteset5st4s5etuse4vens5hal_3shampsheid45s4hir3s4hops3hotesie5frsie5klsie5slsie3sosie3stsie5tasie5tosi5go54s1ijz4s3inc4s1ind3sing_s3ingasin3gl4si2nisin5kr4s3inm2s1ins4s5inv4s3inzsis3e4sis5eesis5trsito5vsi4tru3s4ja_2s3je_3s2jeisje4ri3s4jez4sj5k44s3jons4kele3s2kes3s2ki_3skiedskie3sski5scsk3ste3s4la_5slaap4s3lad3s4lag5slagmsla4me3slang5slapesla3pl4s3las2s3lat3s4laz5sleeps4leet4s3leg2s5leis5lengs3leni3slent4s5ler3s4leus5leugs5leus5sleut2s5lev4s3lics5lieds3lief5slijps4li4kslim5as5lini4slinn4s3litslo4b52s3loc3s4loe4s3logs3loods5loons5loosslo4tr4s3lou4s5loz4s5luc1s4lui4sluid5sluit5sluiz2s5lus3smak_2s5mans4mart4s5mat4s5mec3smeed4s5mei4smelo4s5men5smid_smies55s4nap3s4nav3s4nedsnee5t5s4nel2s5nes4s5netsneus4s5neuz1s4nij3s4nip4s5niv3s4noes4nor_s3norm3s4o3d2s1off3so3gaso3lissolo5v3s4om_2s3oms5s4on_so5nar2s1ond3so3no4s3onv4s5oog4s3ooks3oord5soort3s4op_4s5opeso3phis2o5posop4re4s5orkso3rorsor4st3s2ort5spaaks3paal5spaan5spaat5spake3spann4s5pap5spar_s4pari5sparr2spas55spatt5s4pea3s4peespeet34s3pei5spell4s3pens5pen_spe4nas4per_s5peris4perm1s4pie4spijn4spijps5ping5s2pio2s1p4l4s5plas4plets2pli45splin3splits3poes2s3poms4pon_s4ponns4pori4s3pos5spots5sprays5pred5spreis4prek4sprem4spres5spreu4sprik4sprob4sproc4sprof4sprogs4proo4spros5s4puissa1s2s4s5cussei3ss5spaass5pas5staafs4taatst3abo5stads5staf_sta4fo5staki4stakkst3akt5stam_5stamm3stampstan4s4stapo4starist3aut4stavo4s5tax5steaks5tech5steco3s4ted4stedu3steek3steens5teerstee5t5stein5stekk3stell5stem_5stemd5stemm4stemo4stent4stenu4sterms5teru4ste4sst3hedst3heks5thems3thers4t1hos4t1hus4t3hy4sticus4t3ids5tiev4stijdst3ijs3stilsst3impsti5ni4stins4stitest3ivo4s4t1j4stoef3stoel4stoen4stoer4stoes4stoez3s4tof5s4toksto5li4stoma4stomzs4tong3s4too4stora4stordsto5ri4s5tos4stra_s5trag4strais5tref4streg5strel3strepst3rifs5trisst4rom4stroz4st1s42st5t25s4tud4stuin2s4tunst3uni5su4b14s1uit5suit_s5uitl4s1u2nsvaat5svari5sve5risy4n3e3taak_t3aankt3aanw4t3aas3t4acit3adertad4s3t3adve2t3afd5ta3fet3afhata3fro4t1afs2t3afwta4gaa5tagee5tak3rta3laa5tale_5taligtalm3ata4makt3amba5tament3amputa3nagta3nat4t3arb4t1armta2ro4tar5spt3artita3s2pta3stata3str4tatio4t3atl2t1avote3akt5tea4mte4dit4tee4n4t3eeutei4lot5eindtei5tj2t3eiw4tekerte4laptel5da4telec5telef5telegte5lel5televte4loetelo4r4telsetel3sotel5sute4mortem3ov5tempote3nakte4nauten3edten3eltene4tten5k44t5enqten3snten3sptensu45tentaten5tot3entwte4radter3agte3ralte4ranter3apter3as5terecte4reite4relte4rem4terfdter3fr4terk_4terkt5term_5termiter5octe3rodte3rofte3rog5terontero4rte3rostes3tatest3u4t3euvteve4r4t3exetgaat5tge3lat4haant4hans5thee_4t3hei4t3hel3t2hen1t2her4t1hout3houd5thous4t3hovtie5d45tiefstie3knti3enctie5tatie5totie5twtig5aati4gu4tig3urtij5katij4klt3ijs_tij3sttij3t2tij5trtij5tw4t1ijztina4dtin3as4t1indti4nit4t3injt3inko4t3inl4t3ins4t3invti3s4jti4sonti3s4pti3stati1t2rtkars3toe5d4toe5letoe5pl5toeri5toerntoe5sttoe3tj3toetstof5artof3thto4kan5tolaa5tolet5tolicto4lietolk5stolp3r5tomaa3t2one5toneeto5ner3t4ong5tong_3t4oni5t4onnton3sktoom3etop3asto3pento3petto5posto5pust3opvato5rec4t1orgt5orga3toriato4riëto3romto3r2uto1s2ptos5te2t3oudtpe4t35tracé3t4rai5train5trakat3rake3trakt3trans5trap_4t3raz3t4re_5tred_4treda4tredu4t5reg4treizt3reset3resutre2t3t3rib_5tribu5trico5t4riltri5nit3risit3rit_5trodyt3roedt3roes5trofy4trol_5trola5trolo5tromm5tron_5tronat5rond3trone5tronn5trono5tronst3rood5troont4roostro5pi5trotu5truc_5trui_5truiet3ruimts3a2dts5eent4s3eits3intt3sjents4laat3slacts3lamt2s3let5slibt5sloet3s4luts4moets3neuts5norts5notts3olits4oppts1o4rts3padt3spant5spect3spoet3spoots3pott4sprots4prut4start4stast5stedt5steet5stemt5steut1s4tit3stijt5stilts5tints5t4jt3stritte5rit5tlettt3oogtuit4jtu4k3itul5pi3tu4s3tvaat5ube4liuc4t3auc4tinud3essu4de4zud3ezeudi3omud3onduds5louds5maud3smeud3smiud4staud4stiuer3ilu4f3anug4da2ug4derug5sceug4secugs5paug1s4tui2d3aui2d1ouid3spuien4tui2g3oui4g3rui2k3aui4k3luil5aaui4loouil3ovui2m3aui3magui4n1auin5oguin3oruin5toui2p3lui2p3rui2s3aui5sluuit5aauit5alui5tarui2t1o1uit5ruit3sluit3snuit5spu2k3alu3klasuk3s2muk3spauk3spluk4stiul4d3aul5dopul4d3uule5spul3in_u5lingul3innul3k2aul2k3lul3o2pulp3acul2p3lul4p3rul2s3pume3stu2m3uiunch3run4draun4k3run5o2punst3aunst3oun4tagun4t3uupe4rour3aanur3adaur3advur3echur3eenuree5sure5luur3embur3essure3stur3etauri4glur3ijzur3indur3intur4kieur3k4lur5opburs5liur4s5murs5paurs5thur4stiur4trous3a2mu5s2cruse5tjus5tagust3alu2s3teust3oous5trous5truust3urust3uuut3aanutaar5uta3s4ut3eksut5emmut3ooguto3peutop4luto5poutop4rut3saaut3s2cut4spaut4spout3struur3a4uur3e4uur1o2uvel4suve5nauw5artuw3eenu2w3eiu2w3ijuw5ijzu4windu3wingu4winsuw3inzuwo4geuze3t4va2l3ava4loeval5sivan3acvang3avan4grva4nocva3s4ovast3rva2t3hveel5evee3p4ve3g4hvei3s4vei5tjve2n3oven4slven4spve4radvera4gver5dove3recver3edve3regve3reiver5k4ve3romvero5vver5twves5tive2to4vet3ogvet3oove3torve2t3rvid5stvie4s3vies5nvie4tjvings3vis5otvis5trvlot5svol3ijvond5uvooi5tvoorn4vorm3avrie4svrijs4vuur5swaar5ewa3lanwan4grwa2n1owan3s4war4stwart3jwar4towa4s5lwa4s5pwas5trwd3oomwe2d3iwe4d3rwee4kiwee3lowe4g1awe2g3owe4g5rwei5tjwe4k3rwe4le24welemwen3adwe3ne4we4nemwen5tower4kawer4knwer4prwe3spowe2t3jwet4stwe2t3uwie4lawij4kawijs3lwijs3pwind3awi4t3hw2s3lew5spraw4stijxi3staxi3stoxi4t3ixpres5ya4s5pyba2l3yksge4y4l3etym2f5lyvari5zaar5tzags4tza2k3azan3dizan4drzang3szeel5dzeer5szee3s4zeg4slzei3spzel5drze3lemzel2f1zel4soze4ninzen3o4zen4ogze3nonze4r3aze5schze5steze2t3aze2t3hze2t3jze2t3rzeven3ziek3lziek3wziel4szie5slzi2g5azij5klzij3pozij5s4zings3zins3tzit3u4zoet3jzon3sfzon5tazor4glzor4grzui4dr");
            put(7, "_aarts5_alko5v_as5tra_de5sta_edel5a_eesto4_gang5s_ge3l4a_gelo5v_ge3n4a_gena5z_ge5r4e_ge5r4o_her5in_hits5t_houd5s_ka4taa_kerk5l_kerk5r_kerk5u_le4g3r_len4s3_meel5d_merk5l_met5ee_ne4t3j_onde4r_on4tee_on4ter_ooi5tj_pee5tj_piet5j_pui5tj_rand5a_re4men_reno5v_rie4t3_rij5sp_roe5tj_ro4t3h_ski3s4_tan4da_ten5ac_toe5pr_tri3s4_tuit5j_uit4je_vaat5j_wee4ko_wee4t3_west5raad5sapaal5f4oaalfo5laal5speaal5steaam4staaam4ste5aandeeaans4poaarts5labak4s5aboot4jach5tecachuut5ad3e4te4a5gen_a4g3insajaars5a4l3achale5stea4l3o4val3s4agal4s3ooal4stemal5stenals5toualtaar5al4t3roament4jame4rana2m3o4vams5te_and5ankan5d4riand5rooands5loan4d3ulange5stang5snaangs4tea4n5islan4k3asa4n3ooran4servans5piran5struap5etenapo5staa5p4risap4ste_araat5ja4r3appar4d3omar4d3opar4d3ovarie4tja2r1o2pars5talar4t3akart5ankart5oogart5steast5remas5tro_ater5adater5slat5jesbat5jeshat5jesmat5jespat4s3a2at4s3ecat4s3idat4staaat4ste_at5stenat5stijats5tolat4t3u4ave4n3iaven5spave3r4ubaar5tjba4k3o4ban4k3aban4k3obe5l4asbe4l3ecbe3lo5vbemen4sbere5s4bes5te_be5stiebet5renbie4t3jbin4t3jbit4s3pblad5ijble5spebloot5jbo4d3ecboe4g3aboet5stbo2m3a4bond4s5bon4t3jbor4staborst5obraad5sbran4dabra5strbrei5s4bron3o4buts5tebuur4tj2ce3n4acen4t3jcer4t3rce3s4ti5chromocier4s53con5t4da2g3a4da4g3edda4g3ondag4s3td3a4matd2a5me4danoot5dan4s3pdans5ta4d3antw4d3a2pedarm5onddag5spddel5evdder5aldder5eedder5epd4e5dendel5eekdel4s3edem5ondden5ateden3e4p4d3engtden3o4rden5strde4r3adder3a4gder5ededer5egdde4r3eide4r3emde5re4nde4r3im4d3erosder4s3ader5steder5sto4d3ertsde5speldes5takde5stalde4s3tede5sticdes5topdget5ondget5ovdie4r3odi2k3o43d4ing_4d3inkodintel5di5ofon2d3i2rodo4m3o45do3n4odover5s4d3rand4d3reek4d3roei2d3ro5v5d4ru4kd4s5lieds5patid5s4peld4s3petd5staatd4s3tald3s4tatd4sterrds5tramea4k3o4eau3s4techt5ecechts5oede5nacede5rogedoe5tjeek5allee4k3loeel4as_eel5d4ueelo4geee4p3reeer5oomeer5stree4s5emees5potees5teneeto4geeet5rokeet5steefiet5jege4netegen5ofeger5onegiste4e2g3u4reil5antei4n3abei3n4aceind5ooein4d3rei3s4laei3s4taeits5tre4k3a4gekes5trek5etereklam5aek5looseks5erveks5trael5aande4l3as_e4l3aspe4l3assel5eierel3ei5sele5r4ae4l3etae4l3etue4l3indel3o4veel4s5emel5smedemie4tje4n3aase5n4acce4n3ange2n3a2sena4tele4n3atte2n3a2zend5amaen5dreke2n3e2cene4tenen4g5lee4ningae4n3inke4n3oche4n3olie4n3oore2n1o2pens5einen5slaken4s3onens5poten5stanen5stenen4stinente5reen4tervent5rolent4s3p5enveloe5o3t4he4p3appep5ingre4p3lodepoot4j3e4pos_ep5rodeep4s5eeeps5taaeps5taleps5troe4raak_er5aanpe4raap_era4gene4r3alle5randae5ra3pler3a4trer5eerser5einde4r3emmeren5eger5enthe5rentoeren5twere4t3je4r3etse4rijs_e4r3ijze4r3inier5inkte4r3oederoe5tjero5pener5slager5spaners4poter5steme4s3a2ge4s5enges5oor_e4spriee3s4tale4s3te_es4teelest5ei_e4stekae3s4temes5temoe4sten_es5tenbes5tra_es5traces5trake5stralest5rapes5treie4t5elfetens5ueten5tjete5r4aeter5sme4t5i4de4t3ince4t3orke4t5resets5lapet4s3ooets5teket5stenet5su5retui5tjeur4staeuw4strevel5opewest5rfan4t3jfant4s5feest5rfe4l3eefe4l3opfe4r3etfil4m3afilm5onflen4stfond5enfonds5lfon5engfor4t3jf4raak_friet5jf4s3ethf5stellfste4m3f4sterrf4st3ocfter5shgaar5tjga4l3apgan4s5tga5sla_gas5trag4d3elfgeest5rgei4l5a4ge4lem5ge3l4ogel5stege4n3edge4nend4g3engtge4n4ofgen5sfegen5stugeorke5ger5aalger5apeger5as_ge5ren_ger5iniger4sli4g3ertsge5sperge5stanges5te_gges5tiggings5gids5te5gigere5gigstegi4onetgmaat5jgne4t3jgnie4tjgo4n3azgraat5jgroet5jgroot5jgs5alarg3s4ke_gs5laagg5slinggs5pandg3s4pelg3s4petg5spin_g5spinng3s4pongs5taalg5s4tang4st3apg5s4te_g5ster_gs5terrg5stersg5s4ticg3s4tiggs5tijggst3o4vg4s3trags5tradgs5trakgst5ramgs5trapg5stratgst5resgs5troegs5trong5struchaar5slhaar5sphaar5tjhaf4t3uhal4stohand5slhan4s3lharte5lhar5trehart5slhee4l3oheeps5chee5stoheids5phe4l3eehel4m3ahel4p3ahe4r3adhe3r4auhie5renhie4t5ohin4t3jhoboot4hoe4kerhoor5trhop4strhor4t3jho4t3reh4ten5tht5entwhte4r5oh4t3eskh4t3intht5slotht5smijhul4deria4s5po5i4cepaichee4tic4t3opict4s5cider4spider4stids5takids5tekid4stemie4d3aciek3e4viek5ondiek4s5niel5d4riel5ei_i5enne_ien3s4mien4staien4striepiet5iep5oogiep5reliepro4sie5r4adier3a4lier5el_ier5elsie5ren_ie5ringier5sluie4s3plies5te_ie5steliet5antie4t3ogieto5reie4t3ovie5troeieu5r4eiezel5aij5e4n3iks5te_i4l3ervil3e4veilevin4i4l3e2zim4s3ooin4deneind5stein3e4deini5staino3s4tin5stenin4t3apioneel4i5othekipe4t3jips5te_ip5steni5scopei4s3ervi4s5tasis5terdis5tereist5ongi5stro_ite5reiitie5stit4ste_ïe5nen_jaar5tjjagers5jan4s3ljbe4l3ijde4n3ejdens5pj4d3ervj3d4wanjepiet5j2f1en5j3f4latjf4s3erjfs5takjf5stanjf4steljf4s5tojger5sljg3s4tejk5aardj4k3o4ljks5takjk5stanj3k4wasj4n3erkj4n3ervj4n3inkjns5lacjn4ste_jraads5j4s3elaj4s3e4rj3s4tekj3s4telj5stondjst5ranj5strokjvers5pjze4r5okade4t5k3a4genkalf4s5kame4rekan4t3j4k3artikast3o4kast5raka5strokas3u4rkat5aalka4t5ioka4t3ogkee4p5lke4l3opke4n3anken4ei_kens5pokepie5tker4kleker4k3rker4n3aker5speker4sprker4staker4sti4k3ertskes5ten4k3e2tukeviet5khoud5skie4s4tkie5stekings5lkits5tekke5neik5leer_5k4le4ukoe4ketkoers5pkom4strkon4t3jkon4t3rkooi5tjko5pen_3k4o4s3kraads54k3redekrijt5jkroet5jksges5tks5pandk5staank5staatk4st3edks5tentkster5ak4sterrks5trekkst5uitk5trollkven4t35k4waalkwen4st5k2wes1kwes5trlaar5tjlach5telacht4sla4gentlam4p3jlam4p5llam4po4lam4s3pland5aalan4d3rla4n3ec5lange_lang5splan4k3alan4k3llan4t3jla4t3hela4t3rolbert5jl4d3e4zl5dradeld5ranglees5polek5strlen3a4kler5spo4l3erts4l3essales5taale3t4releu5steleven4sl4f3endlge4n5alie4g3alie3s4tlij4m3alijst5alim4p3jlin4k3alin4t3jli5o5s4l4k3ankl4k3levlks5taalks5telller5onlle3s4mllevie5lm3a4caloe4d5aloen4stlo4k3arlo2k3o2lom4p3jlom4p3llon4gaalon4g3olon4t3jlo4s5trlot3a4llraads5l4s3e2dl4s3e2plsge4stl3s4kells4maakls5tak_l5straals5trakl5stratl2t3o4vlts5te_2l3u2nimaat5stma5esto5ma3k4rmans5eeman4s3tmans5tamariet5mar4s5tma3s4pomboot4jmee3k4rmee5lasmee5strme4l4asmel5as_mel3s4mmeng5ramen4t3jme4r4amme5rong4m3erosmers5tame5spotme5stelmest5ovme5ta5nm3e4venmi3s4lami5stramis5tromoers5tmoes4temogen4smol4m3amp5artsm4p3ervmp5oliem4s5tonmte5stamuts5te4n3aardnaar5tjnacee5tna3f4luname5stnan4t3j3na3p4lnarie5tnd5adelndags5pn4d3anan4d3a4zn4d3edinde5laan4d3emmnder5alnder5ognde4tenndie4tjnd5ijs_n4d3inknd3s4cund4spran2d3u4rnege4re5n4end_nen5t4a3n2e5rene4r3idners5tenes4teineu5stengaat5jn2g1a2dn4g3eennge4rapnge4rasn4gigern4g3insng5rassngs5lopng4s5neng5strinie5klenie4s3pni4g3eeni5o5s4ni4s3evni5stelnk5aardn4k3arbn4k3aspnker5kunning5rnooi5tjno4p3asnot5a4pn3s4caln3s4laans5laagns5lap_ns5lappns5lot_n4s3paanst3a4gn4st3eins5teksn5sten_ns5tentn5ster_n4stijvnst5oefn5streens5troens5trogn4t3artnte5radnte4rofn4t5olint5ribbn5troosnts5pren4t3uitn5twijfn5t4wis3n4u5rioa4tievo4b5o4rods5lamod5slanod5smakods5te_od5stekod5stenoe2d3o2oe4f5o4oek5erkoe4k3opoe4l3eioe4m3acoep5indoer5aaloer5ei_oer5eieoer4staoe4s3o4oe4t3o4oe4t3raoet4s3pof4d1a4ofs5traoge5laaogel5eioger5onoge4s3tog4stonogs5troo4k3aaso4k3a4zok3o4peok5sprioks5te_ok5stenok4s5trokter4sola3s4molg5rapol4g3riolo3s4tol5sterome5renomer5klo4m3intom4p5eiom4ste_on4d3acon5d4asond5eteon4d3idond5ijsond5om_ond5sloo2n1e2cong5aanong5aapon4k3apon4k3loonne5ston5sten3ont1s4oon3in5oord5aaoor5dopoor5steoor5sto3o4peniop3e4teop3o4reo2p3u2no4r3algor4d3asor4denvord5ondord3o4vor4drado4r3inkor4m3acor4m3eior4n3acorno3s4or4p3acorp4s5cor5s4paor4t3akort5eenor4t3ooor4tredort5steos5jer_os5taalos5taarost3a4gos5toliost3o4vos5tra_os5traaos5trumote4lanoter5spotje5spot4s3paot4ste_ots5tekot5stenou5ren_ou5rennou2r3o2out5steouw5ins3o4vergover5sppaar5dupaar5tjpacht5spalm5acpa4pe4tpar4k5lpei4l3ape3l4aape4l3akpe4l3eepe3l4orpen5d4rpera3s4pe4r5egper5stiper4str5pe5terpe4t3rapets5tepiek5lapie4r3opie4s3ppij4p3apin5griplaat5j4p3lamp4p3langpla4t3rplee5tjpleu5ropmans5tpo2k3i2poo5lenpoor4tj5portefpo4t3aspotes5tppe4l3opraat5j4preekupre4t3j4p3riekproet5jpro4s5tpro3t4aprut3o4p4s3i2dps5tentps5tronp4t3o4v4r3aardraar5tjraf5ond4r3a2lara4l3eer3a4limran4g3oran4t3jrap5roerast5rir4d3actrden5drr4dervarde5s4trd5olierd5roosrede4s3ree3n4erege5ne5rekenire4k3rerel4d3ore4l3eire4lu4rre5mo5vren5aarre5nadere4n3anren3a4r5rendeere5nen_ren5enkren3e4pre5ner_ren5erfren5erv5r4enklren4oplre4t3ooreur5esreu5ster2f3a4gr4f3engr4f3lagr4f3u4rr4g3eenrgel5drrge5rapr4g3insrg4s5prri5abelriel5aarie4lei5rigste4r5ijl_rij4strrin4k3l4r3innarjaars5r4k3artrker4slr4k3ervr4k3inkr4k3latrk5leidr5k4ranrle4g3rrlink4srlui5t4r4m3artrme4t3jrmet5str4n3enerne4t3jroe4g3rroen5smroe4reirole5stron3a4d5r4onalron4d3oron4d3rron4d5uron4stero3p4larop5rakros4s5tro5stelros5trarot4ste3rou5t4ro5verir4p3o4vr4p3recrp4s5torre4l3urren5s4rri5er_rs4asser4s3eisr3s4hocr3s4katr5slingrs5loepr4s3loor5sluisr5smaakrs5maalr4s3parrs4parers4pener4s3petr5spraar4s3te_r5ster_r5sterkrs5termr5stersrste5str4stevars5tomarst5orars5traprs5treir5strenrs5trogrst5rozr4t3aanrt5aandrt5aanvrte4leirte5star2t5e2vr4t3inir4t3inkrt5jescr4t3rasr3t4rekr4t3resr4t3rolrt4s3prrts5tenrt3ui4tru4l3ij4r5u2nirval4strvloot5rwen4strzet5st3s4a3losan4t3jsart5se3s4cola2s5e2go4se4lemse5ling4s3elitse4m3ac5se3r4ese5t4rasheids5s3in5gr4s3inkosk5ruim5s4laan4s5laars5lamp_s5lampe4s5land3s4la5v3s4lee_4s5leerslee5tjslen4stsle4t3j3s4lier4s3lijf4s5lijs4s5lui_5sluis_sluis4t4s5maat5smeden5s4meet4s5mes3s5muile5smuiltsneu5st4s3oor_4s3oorl3s4opra2s1or3g4spectu5s4perrspie5tjspi5sto5s4pore4sprakt5spriet4s5prij4s5prod5s4pron5staan_4staang4staanwstaat5j2s4t1ac4s3tali3s4tands4t3arcstasie45statio4steenh5stekar5steldhste4leest5elemste5ranster5og4s4t3exs4t3e2zst5heer5stiefe3s4tijg5s4tijl4s5tint5stoel_5stoelest3o4ge4st3oogstoot5jst3o5pest5optosto4rat4st4rad3stra4f5straf_4st3rec4s3treist5rijp4s3troes5troep5strook5stroom4stroos4s5trou4strui_5struikstui5tjst5uitkstu4nie5suits_t5aandotaan4sttaar5sptaat4st5ta5g4l5takkenta5lact5talentt5allia4t3a2natan4d3rtan4k5rtar5taatdor5st4t3echttee4k3lt5eenhetee5rin4t3eier5tekene5tekenste4k3omte4k3witel5ant5telecot5electtel5eentel5ei_tel5eietel5eit5te5lextel5oogte4l3opte4l3uu5temperten4achten3a4gte5narete5noreten5scrtens5uuter3a4btera5catera4dete4r5after5eikte5ren_4t4erf_4t4erftter3k4wte5ronstero5pe5terrei5terreu5terrorter4sprte3s4apte5steltes5tentest5optest5rit5e4van5the3ra4t3heretie4kontien5sttie5s4l5tieven4t3incutin4g3iting4sati3o4p5tmen4sttna4m3o5toelicto5ende5toe1s45toets_5toetsetomaat5tom4p3j4t3om5s5to5nentop5artto4r3ag5torenstor4m3atou4r3etove5nato4vens4toverg4t3raad5trafo_4tragez5transat5redes4t3reistrie5ta5t4rio45t4rititront5j4t5routtrui5t4ts5eindt4s5enet4s3engt4s3ergts5erget4s3e2vt4s3inkt5slag_t4s3pett4s3pilt5s4port4staakts5tantts5tekot5stellt5stelst5ster_t4sterrt5sterst5stijgts5toepts5tongt4storets5tradts5treits5troette5loe3t4wijfucht5sluds5takuge4l5ougs5traui4g5aaui4l3emui4l3ogui4p3o4ui4t3a4ukkers5uk4o3pluld5erkuls5te_uls5telunds5taund5steun4ste_un4st5runst5uiunt5eenun4t5o4unt3s4muper5stu4p3leiu2r3a4ru4r3a2zurelu5rurken5surk4s5tur4servur4s3evur3s4feurs5laaur5spelur5sporurs5tikur5troeus4t3eius5tra_us5tre_u4t3eesuter5anuts5enguts5takut4ste_ut5stenuur5steuur5stiuwe4nenvaar4tavaart5rval4s5pvel4d3ove5nareven4s3evens5lover5aasve4randver5eisve5ren_ve5rendver3e4tver5ijdver5ijlver5ijsve5ringver5spever5staver5stovet4roevet5ste4vicepavie4r3avil4t3jvi4s3anvlei3s4vlie4s5voe4t3avoe4t3rvoet5spvol4g3avol4gravon4detvoor5navrij5k4wan4d5rwang5slwars5tewee4k3rwee3s4twee5stewe4gervwe5nen_wen5enkwen4k3awer4k5lwer4k3ower4k3rwerk5ruwer4k3wwer4p3awer4p3lwer5stewes4t5owijs5tawin4d3rwinst5rwi2t3o4woest5awolf4s5woon5sfwor4g3ewren4stwtje5spxamen5tyber4t3zand5a4zee3r4ozeero5vzen4d3azer4s5ezie4k3ozi4n3a4zin4k3lzins5tazin5strzooi5tjzor4g3azui4d3i");
            put(8, "_aftu5re_den4k5r_eer5ste_ets5te__gerst5a_leid5st_lui5t4j_mij4n5i_neu4t5j_nie4t5j_oot5jes_poort5j_ring5s4_seks5te_taart5j_ten4t5j_ter4p5a_ven4t5j_wen4s5taar4d5asaar5spelaar4t5onan4d3e4dan4s5te_apij4t5jar4s5tekart5jesvart5o4gear4t3o4vataart5jaten4t5rat4s5takats5top_ats5trekbaar5stebbe4l5agbbe4l5eebe4l5intber4g5afber4g5etbes5ten_bis5trooblij5stebon4t5o4bor4st5rda4g3e4tdbou4w5i4d3e4lek4d3e4lit4d3e4maiden4k5ofde4r5as_de4r5assder4s5omder5stra4d3e4tapdeu4r3o44d5ingelds5trekkdtaart5je4d5ernsedors5teeer5stonegel5ei_ege4l5oveger5engeits5te_eit5stenekaart5je4l5inktel4k3u4remens5te5endertie4n3en5te4n3i4voenst5ijven4stu4repits5tee4p5o4geepoort5jerd5uit_er5editie5rendeler5enen_erkeers5errie5tjerui5t4je5smuil_esp5riemes5tatiees5tekamestere5oeters5laeurs5taaeurs5te_eur4s5trevaar5tjeve5n4aafdors5tegast5rolgel4d3a4gen5stongenstu5rger5aap_ge4r3a4lger5slangers5lijge5spendges5ten_gge4r5ongou4d5eegrie4t5jgst5aangguts5te_haams5tahaars5tehar4t3o4hee5tjesheks5te_hek5stenherm5engher4p5aaherts5tehets5te_hits5te_hit5stenhors5te_hor5stenhots5te_hts5taalht4s5takht4s5tekhts5torehuts5te_idde4r5aid5s4meeie4g5insien4st5oienst5uries5tereiets5te_itper5stjks5taakjks5taalj5s4tengkeers5toke4l5intke4r5enkker5ste_ke5straakets5te_4k5indelkors5te_kor4t3o4ko5sjerekots5te_laat5stalan4d5oolang5stalecht5stle4n3a4dle4n3e4m4l3en5thle4r3a4kle4r3e4vle5s4tellets5te_levink5jlicht5stlits5te_lit5stenl4o1r2o3l4s5pootluts5te_ma4l5entmats5te_meest5almee5stovmen4s5uume4r5aakme4r3a4kmer5antemets5te_mits5te_mit5stenmkaart5jmors5te_mots5te_5muilde_naars5tr5n4a5denn5antennnars5te_nar5stennder5aalnde4r5annder5in_nds5taalnegen5en4n3e4migne4n5enkne5s4tekngs5tak_ngs5takengs5treknkaart5jnne4p5olnpoort5jnraads5ln5s4liepnst5aangnst5aansn4s5tekonst5radens5trekknst5roosn4t5aardntaar5tjnte5nachode4m5aroe4r3a4loers5takoers5te_og4st5eionke5lapooms5te_o5rigereor4t5ijlo5steroïover5stepaling5spa4n3a4dpats5te_pe4l3e4tpkaart5jplooi5tjpols5te_pons5te_por4t5rapper5stepren4t5jprie4t5jpring5s4puter5inputs5te_r5angst_rats5te_4re4ditiree5r4adreer5steremie5tjr5endertr5enveerre4t3o4grets5te_rie4k5aprij5ster4r5inganr5ingenirits5te_rit5stenrkaart5jrk4t5e4vrme4r3a4rmors5terons5te_root5sterots5te_rpoort5jrsek5stersorkes5r4s5taakrst5aangr4st5redrte5nachrt4s5ecoruts5te_3s4co5reseks5tense4l3a4g4s3e4lekse4n3a4g4s5impers5ingeniskaart5j5s4loot3slui5ste3so5l4o32s1on4t3sraads5lstaart5jst5e4ros5sterrenstraat5jst5roos_taats5tatament5jte4l3o4g5tenten_teraads5te4r5aakte4r5enkte4r5envte4r5in_ter5ste_ter5stonthoof5ditmens5te5toe3l4atoemaat5to4r5olitors5te_t4s5tankt5s4tes_tte5l4optten4t5jtuurs5lauid5spreuid5ste_uin4s5louits5te_urs5takevals5tekve4l3a4gvens5lanvens5tekven4s3u4vors5te_vor5stenvrij5stewaar5stewer4k3u4wezen4s5winst5aawoor4d5rzoet5ste");
            put(9, "_acht5end_handels5_ker5sten_laat5ste_mor5sten_pers5te__pits5te__raads5le_spoor5tj_wals5te_asting5spboots5te_brie5tje_ebots5te_ekwet5steemor5stenepers5te_espit5steewens5te_flens5te_fpers5te_fpits5te_gfijn5stehaats5te_heers5takhielsges5hts5trekki5otorensjspoort5jkaart5jeskaats5te_ka4t5a4leketting5skinds5te_kkers5tenklots5te_koets5te_kwens5te_lands5te_loens5te_nbots5te_n4d5e4recngels5te_n5opleidinpers5te_ntene5tenomen5ste_poets5te_r4d5e4lasrke5streerke5strerrlaat5sterlinks5ter5treden_rvals5te_rvers5te_rwens5te_slens5te_5smuildenteeds5te_toets5te_udi5ologevens5taakvens5takewrens5te_zwets5te_");
        }
    });

    public String lang;
    public final int leftMin;
    public final int rightMin;

    public final Map<Integer, String> patternObject;

    private HyphenPattern(String lang, int leftMin, int rightMin, Map<Integer, String> patternObject) {
        this.lang = lang;
        this.leftMin = leftMin;
        this.rightMin = rightMin;
        this.patternObject = patternObject;
    }

}
