---
layout: main
---

# Customizing the Look and Feel of Your Library

> **Librera** allows you to adjust the way your books are displayed on the "shelves" of your Library. You can change the number of books on a shelf, their appearance, shelf size, book grouping and listing, etc.

Your books are shown in the _Library_ tab, where you can make adjustments to the book presentation. Additional settings affecting your Library view are located in the slide-out _Preferences_ tab, the _Book Covers_ panel.

* To change the book layout (list, grid, condensed, etc.), tap on the hamburger icon in the upper right corner of the _Library_ tab
* Swipe right from the left edge of the screen to open the _Preferences_ tab

> If you have the _Preferences_ box checked (no animation), you will find the _Preferences_ tab alongside the _Library_ tab on top.

* Swipe down and find the _Book Covers_ panel

||||
|-|-|-|
|![](3.jpg)|![](1.jpg)|![](2.jpg)|

* Examples of the views of just a few layout choices are given below:
 
> Remember, another layout is just two taps away. You can switch to the most convenient one at any time.

||||
|-|-|-|
|![](7.jpg)|![](8.jpg)|![](9.jpg)|

## The _Book Covers_ Panel

* You can opt out of seeing book covers altogether by unchecking the respective box
* You still have plenty of layout options

||||
|-|-|-|
|![](4.jpg)|![](5.jpg)|![](6.jpg)|

* Your manipulations with the size of book covers will depend on the layout you've chosen (list or grid)
* For "list," use the respective slider to change the size of the book covers (shelf size)

||||
|-|-|-|
|![](10.jpg)|![](11.jpg)|![](12.jpg)|

You will have more options for "grid."

* Use the respective slider to change the size of the book covers
* You can also choose the number of columns in your Library's grid

> Note: You can always revert to your initial settings by tapping _Restore default_ and confirming the operation with _OK_.

**If you choose displaying the covers of your books, use other options in the _Book Covers_ panel to pretty up the view.**

||||
|-|-|-|
|![](13.jpg)|![](14.jpg)|![](15.jpg)|
