# DetoxDroid

![GitHub Repo stars](https://img.shields.io/github/stars/flxapps/DetoxDroid)
[![GitHub release](https://img.shields.io/github/release/flxapps/DetoxDroid.svg)](https://github.com/flxapps/DetoxDroid/releases/) [![GitHub license](https://img.shields.io/github/license/flxapps/DetoxDroid.svg)](https://github.com/flxapps/DetoxDroid/blob/master/LICENSE) [![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/flxapps/DetoxDroid/graphs/commit-activity) [![Ko-Fi](https://img.shields.io/static/v1?label=Buy%20me%20a%20coffee&message=3%20EUR&color=red)](https://ko-fi.com/flxapps/3) [![LiberaPay](https://img.shields.io/liberapay/receives/DetoxDroid)](https://liberapay.com/DetoxDroid) 

## Digital Detoxing as Your New Default

<img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" width="165" /><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" width="165" /><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/3.jpg" width="165" /><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/4.jpg" width="165" /><img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/5.jpg" width="165" />

## What it is about

Usually, "Digital Detoxing" apps in Android are about opting-in for a contract to not use our phones for the next X minutes. Or that we will not use the app Y for more than Z minutes. These contracts are often reinforced with financial incentives, i.e. if we fail we will have to pay a fee of a few dollars to the developers.

This app follows a different approach by default, stripping away all the attention-grabbing and manipulative features of other apps. DetoxDroid does not require you to choose a time and place when you want to "detox", or punish you if you fail. Instead, it aims to enable you to use your phone rather than letting your phone use you.

## Features

### 1. Grayscale Your Screen While Making Exceptions
According to former Google design ethicist Tristan Harris, founder of the Center for Humane Technology, going grayscale removes positive reinforcements and dampens compulsive smartphone use. But while this might prove helpful in regards to reducing your smartphone time, there are obvious downsides. For example, you do want to see colors on your screen when you take a photo. With DetoxDroid you can allow specific apps to show colors, while the rest of your phone stays gray.

### 2. Automatically enter the "Do Not Disturb" mode
Notifications are the number one way for apps to draw our attention. Any app on our phones competes for our attention, and even games will remind us to play them if we have not opened them for a while. Reclaim your time by turning them off with the "Do Not Disturb" mode.

### 3. Make Apps Disappear
You can select apps that will completely vanish and be deactivated while DetoxDroid is running. Move Twitter, Reddit and other distractions into this vault during your productive hours and only open these apps, when you deliberately take pauses. Hence, you can completely forget about them, rather than being bothered by lockout screens.

### 4. Break "Infinite Scrolling"
Infinite scrolling (sometimes also referred as "doom scrolling") is a manipulative design technology that eliminates those brief moments where you might turn to another activity. DetoxDroid can try to detect if you have been lost in such behavior and offer you an exit strategy.

### 5. Opt-out > Opt-in
You are encouraged to deliberately to pause DetoxDroid, allowing colors and notifications. If the pause is over, DetoxDroid automatically comes back into life. Let this become your new default rather than having to repeatedly decide for it.

## Installation
1. [Enable developer mode and USB debugging](https://www.youtube.com/watch?v=0usgePpr8_Y):
    1. Go to Android Settings → About Phone
    2. Look for the build number option and touch it multiple times until developer mode is enabled
    3. Go to Android Settings → Developer Options, look for USB debugging and enable it
    (Some devices might require enabling the "USB Debugging (Security Settings)" option or else `pm` commands won't work at all. Certain Mi devices require you to sign into a Mi Account to enable this feature.)
    4. Connect your device with your computer.
2. [Download, unzip and run the installation script](https://downgit.github.io/#/home?url=https://github.com/flxapps/DetoxDroid/tree/master/install) for your OS
    - If you are on Windows, you should be able to run `install_windows.bat` by simply double-clicking the file.
    - If you are on Mac/Linux, you should be able to run the installation script from the console using `bash install_<os-name>.sh`
    - If at any point a prompt on your phone asks you whether you want to allow debugging by your computer, press Allow.
3. Optionally, disable USB debugging again.

### Alternative Method
If the installation script does not work or you do not trust it, follow the [manual installation steps](https://github.com/flxapps/DetoxDroid/wiki/Manual-Installation).

## Support
If you like the project, feel free to support further development.
- [Submit feature suggestions and bug reports](https://github.com/flxapps/DetoxDroid/issues/new)
- [Buy me a coffee via Ko-Fi](https://ko-fi.com/flxapps)
- [Become a patron on LiberaPay](https://liberapay.com/DetoxDroid/donate)
- [Donate via PayPal](https://www.paypal.com/donate/?cmd=_s-xclick&hosted_button_id=K6T2HPXE7HQBG)

## Troubleshooting

### “App was denied access” on Pixel / Android 12+

On some Pixel and other Android 12+ devices, you may see this dialog when DetoxDroid can’t access your usage data:

<p float="left">
  <img src="https://github.com/user-attachments/assets/81c0d990-4b8e-40dd-9466-ac10c4833606" width="200" />
  <img src="https://github.com/user-attachments/assets/2b8fb76b-def0-4a80-a77b-b0b6af0a374d" width="200" />
</p>

To resolve it:

1. Open **Settings** → **Apps** → **DetoxDroid**.  
2. Tap the overflow menu (⋮) and select **Allow restricted settings**.  
3. Grant the permission.  

After this, DetoxDroid will be able to read your app-usage data normally.

