package com.flux.ui.theme

import androidx.compose.ui.graphics.Color
import androidx.compose.material3.lightColorScheme
import androidx.compose.material3.darkColorScheme

private val primaryLight = Color(0xFF87521B)
private val onPrimaryLight = Color(0xFFFFFFFF)
private val primaryContainerLight = Color(0xFFFFDCC0)
private val onPrimaryContainerLight = Color(0xFF6A3B03)
private val secondaryLight = Color(0xFF735943)
private val onSecondaryLight = Color(0xFFFFFFFF)
private val secondaryContainerLight = Color(0xFFFFDCC0)
private val onSecondaryContainerLight = Color(0xFF5A422D)
private val tertiaryLight = Color(0xFF5A6238)
private val onTertiaryLight = Color(0xFFFFFFFF)
private val tertiaryContainerLight = Color(0xFFDEE8B2)
private val onTertiaryContainerLight = Color(0xFF424A23)
private val errorLight = Color(0xFFBA1A1A)
private val onErrorLight = Color(0xFFFFFFFF)
private val errorContainerLight = Color(0xFFFFDAD6)
private val onErrorContainerLight = Color(0xFF93000A)
private val backgroundLight = Color(0xFFFFF8F5)
private val onBackgroundLight = Color(0xFF221A14)
private val surfaceLight = Color(0xFFFFF8F5)
private val onSurfaceLight = Color(0xFF221A14)
private val surfaceVariantLight = Color(0xFFF2DFD1)
private val onSurfaceVariantLight = Color(0xFF51443A)
private val outlineLight = Color(0xFF837469)
private val outlineVariantLight = Color(0xFFD5C3B6)
private val scrimLight = Color(0xFF000000)
private val inverseSurfaceLight = Color(0xFF372F28)
private val inverseOnSurfaceLight = Color(0xFFFEEEE3)
private val inversePrimaryLight = Color(0xFFFEB877)
private val surfaceDimLight = Color(0xFFE6D7CD)
private val surfaceBrightLight = Color(0xFFFFF8F5)
private val surfaceContainerLowestLight = Color(0xFFFFFFFF)
private val surfaceContainerLowLight = Color(0xFFFFF1E8)
private val surfaceContainerLight = Color(0xFFFBEBE0)
private val surfaceContainerHighLight = Color(0xFFF5E5DB)
private val surfaceContainerHighestLight = Color(0xFFEFE0D5)

private val primaryLightMediumContrast = Color(0xFF532C00)
private val onPrimaryLightMediumContrast = Color(0xFFFFFFFF)
private val primaryContainerLightMediumContrast = Color(0xFF986028)
private val onPrimaryContainerLightMediumContrast = Color(0xFFFFFFFF)
private val secondaryLightMediumContrast = Color(0xFF47321E)
private val onSecondaryLightMediumContrast = Color(0xFFFFFFFF)
private val secondaryContainerLightMediumContrast = Color(0xFF836850)
private val onSecondaryContainerLightMediumContrast = Color(0xFFFFFFFF)
private val tertiaryLightMediumContrast = Color(0xFF323914)
private val onTertiaryLightMediumContrast = Color(0xFFFFFFFF)
private val tertiaryContainerLightMediumContrast = Color(0xFF687146)
private val onTertiaryContainerLightMediumContrast = Color(0xFFFFFFFF)
private val errorLightMediumContrast = Color(0xFF740006)
private val onErrorLightMediumContrast = Color(0xFFFFFFFF)
private val errorContainerLightMediumContrast = Color(0xFFCF2C27)
private val onErrorContainerLightMediumContrast = Color(0xFFFFFFFF)
private val backgroundLightMediumContrast = Color(0xFFFFF8F5)
private val onBackgroundLightMediumContrast = Color(0xFF221A14)
private val surfaceLightMediumContrast = Color(0xFFFFF8F5)
private val onSurfaceLightMediumContrast = Color(0xFF17100A)
private val surfaceVariantLightMediumContrast = Color(0xFFF2DFD1)
private val onSurfaceVariantLightMediumContrast = Color(0xFF3F342A)
private val outlineLightMediumContrast = Color(0xFF5D5046)
private val outlineVariantLightMediumContrast = Color(0xFF796A5F)
private val scrimLightMediumContrast = Color(0xFF000000)
private val inverseSurfaceLightMediumContrast = Color(0xFF372F28)
private val inverseOnSurfaceLightMediumContrast = Color(0xFFFEEEE3)
private val inversePrimaryLightMediumContrast = Color(0xFFFEB877)
private val surfaceDimLightMediumContrast = Color(0xFFD2C4BA)
private val surfaceBrightLightMediumContrast = Color(0xFFFFF8F5)
private val surfaceContainerLowestLightMediumContrast = Color(0xFFFFFFFF)
private val surfaceContainerLowLightMediumContrast = Color(0xFFFFF1E8)
private val surfaceContainerLightMediumContrast = Color(0xFFF5E5DB)
private val surfaceContainerHighLightMediumContrast = Color(0xFFE9DAD0)
private val surfaceContainerHighestLightMediumContrast = Color(0xFFDECFC5)

private val primaryLightHighContrast = Color(0xFF452400)
private val onPrimaryLightHighContrast = Color(0xFFFFFFFF)
private val primaryContainerLightHighContrast = Color(0xFF6D3D05)
private val onPrimaryContainerLightHighContrast = Color(0xFFFFFFFF)
private val secondaryLightHighContrast = Color(0xFF3C2815)
private val onSecondaryLightHighContrast = Color(0xFFFFFFFF)
private val secondaryContainerLightHighContrast = Color(0xFF5C442F)
private val onSecondaryContainerLightHighContrast = Color(0xFFFFFFFF)
private val tertiaryLightHighContrast = Color(0xFF282F0A)
private val onTertiaryLightHighContrast = Color(0xFFFFFFFF)
private val tertiaryContainerLightHighContrast = Color(0xFF454D25)
private val onTertiaryContainerLightHighContrast = Color(0xFFFFFFFF)
private val errorLightHighContrast = Color(0xFF600004)
private val onErrorLightHighContrast = Color(0xFFFFFFFF)
private val errorContainerLightHighContrast = Color(0xFF98000A)
private val onErrorContainerLightHighContrast = Color(0xFFFFFFFF)
private val backgroundLightHighContrast = Color(0xFFFFF8F5)
private val onBackgroundLightHighContrast = Color(0xFF221A14)
private val surfaceLightHighContrast = Color(0xFFFFF8F5)
private val onSurfaceLightHighContrast = Color(0xFF000000)
private val surfaceVariantLightHighContrast = Color(0xFFF2DFD1)
private val onSurfaceVariantLightHighContrast = Color(0xFF000000)
private val outlineLightHighContrast = Color(0xFF352A21)
private val outlineVariantLightHighContrast = Color(0xFF53473D)
private val scrimLightHighContrast = Color(0xFF000000)
private val inverseSurfaceLightHighContrast = Color(0xFF372F28)
private val inverseOnSurfaceLightHighContrast = Color(0xFFFFFFFF)
private val inversePrimaryLightHighContrast = Color(0xFFFEB877)
private val surfaceDimLightHighContrast = Color(0xFFC4B6AC)
private val surfaceBrightLightHighContrast = Color(0xFFFFF8F5)
private val surfaceContainerLowestLightHighContrast = Color(0xFFFFFFFF)
private val surfaceContainerLowLightHighContrast = Color(0xFFFEEEE3)
private val surfaceContainerLightHighContrast = Color(0xFFEFE0D5)
private val surfaceContainerHighLightHighContrast = Color(0xFFE0D2C8)
private val surfaceContainerHighestLightHighContrast = Color(0xFFD2C4BA)

private val primaryDark = Color(0xFFFEB877)
private val onPrimaryDark = Color(0xFF4B2800)
private val primaryContainerDark = Color(0xFF6A3B03)
private val onPrimaryContainerDark = Color(0xFFFFDCC0)
private val secondaryDark = Color(0xFFE2C0A5)
private val onSecondaryDark = Color(0xFF412C19)
private val secondaryContainerDark = Color(0xFF5A422D)
private val onSecondaryContainerDark = Color(0xFFFFDCC0)
private val tertiaryDark = Color(0xFFC2CB98)
private val onTertiaryDark = Color(0xFF2C340E)
private val tertiaryContainerDark = Color(0xFF424A23)
private val onTertiaryContainerDark = Color(0xFFDEE8B2)
private val errorDark = Color(0xFFFFB4AB)
private val onErrorDark = Color(0xFF690005)
private val errorContainerDark = Color(0xFF93000A)
private val onErrorContainerDark = Color(0xFFFFDAD6)
private val backgroundDark = Color(0xFF19120C)
private val onBackgroundDark = Color(0xFFEFE0D5)
private val surfaceDark = Color(0xFF19120C)
private val onSurfaceDark = Color(0xFFEFE0D5)
private val surfaceVariantDark = Color(0xFF51443A)
private val onSurfaceVariantDark = Color(0xFFD5C3B6)
private val outlineDark = Color(0xFF9E8E82)
private val outlineVariantDark = Color(0xFF51443A)
private val scrimDark = Color(0xFF000000)
private val inverseSurfaceDark = Color(0xFFEFE0D5)
private val inverseOnSurfaceDark = Color(0xFF372F28)
private val inversePrimaryDark = Color(0xFF87521B)
private val surfaceDimDark = Color(0xFF19120C)
private val surfaceBrightDark = Color(0xFF403730)
private val surfaceContainerLowestDark = Color(0xFF130D07)
private val surfaceContainerLowDark = Color(0xFF221A14)
private val surfaceContainerDark = Color(0xFF261E18)
private val surfaceContainerHighDark = Color(0xFF312822)
private val surfaceContainerHighestDark = Color(0xFF3C332C)

private val primaryDarkMediumContrast = Color(0xFFFFD4B1)
private val onPrimaryDarkMediumContrast = Color(0xFF3C1E00)
private val primaryContainerDarkMediumContrast = Color(0xFFC18348)
private val onPrimaryContainerDarkMediumContrast = Color(0xFF000000)
private val secondaryDarkMediumContrast = Color(0xFFF9D6B9)
private val onSecondaryDarkMediumContrast = Color(0xFF35210F)
private val secondaryContainerDarkMediumContrast = Color(0xFFA98B72)
private val onSecondaryContainerDarkMediumContrast = Color(0xFF000000)
private val tertiaryDarkMediumContrast = Color(0xFFD8E1AD)
private val onTertiaryDarkMediumContrast = Color(0xFF212905)
private val tertiaryContainerDarkMediumContrast = Color(0xFF8C9566)
private val onTertiaryContainerDarkMediumContrast = Color(0xFF000000)
private val errorDarkMediumContrast = Color(0xFFFFD2CC)
private val onErrorDarkMediumContrast = Color(0xFF540003)
private val errorContainerDarkMediumContrast = Color(0xFFFF5449)
private val onErrorContainerDarkMediumContrast = Color(0xFF000000)
private val backgroundDarkMediumContrast = Color(0xFF19120C)
private val onBackgroundDarkMediumContrast = Color(0xFFEFE0D5)
private val surfaceDarkMediumContrast = Color(0xFF19120C)
private val onSurfaceDarkMediumContrast = Color(0xFFFFFFFF)
private val surfaceVariantDarkMediumContrast = Color(0xFF51443A)
private val onSurfaceVariantDarkMediumContrast = Color(0xFFECD9CB)
private val outlineDarkMediumContrast = Color(0xFFC0AFA2)
private val outlineVariantDarkMediumContrast = Color(0xFF9D8D81)
private val scrimDarkMediumContrast = Color(0xFF000000)
private val inverseSurfaceDarkMediumContrast = Color(0xFFEFE0D5)
private val inverseOnSurfaceDarkMediumContrast = Color(0xFF312822)
private val inversePrimaryDarkMediumContrast = Color(0xFF6C3C04)
private val surfaceDimDarkMediumContrast = Color(0xFF19120C)
private val surfaceBrightDarkMediumContrast = Color(0xFF4C433B)
private val surfaceContainerLowestDarkMediumContrast = Color(0xFF0C0603)
private val surfaceContainerLowDarkMediumContrast = Color(0xFF241C16)
private val surfaceContainerDarkMediumContrast = Color(0xFF2E2620)
private val surfaceContainerHighDarkMediumContrast = Color(0xFF3A312A)
private val surfaceContainerHighestDarkMediumContrast = Color(0xFF453C35)

private val primaryDarkHighContrast = Color(0xFFFFEDE0)
private val onPrimaryDarkHighContrast = Color(0xFF000000)
private val primaryContainerDarkHighContrast = Color(0xFFFAB474)
private val onPrimaryContainerDarkHighContrast = Color(0xFF160800)
private val secondaryDarkHighContrast = Color(0xFFFFEDE0)
private val onSecondaryDarkHighContrast = Color(0xFF000000)
private val secondaryContainerDarkHighContrast = Color(0xFFDEBCA1)
private val onSecondaryContainerDarkHighContrast = Color(0xFF160800)
private val tertiaryDarkHighContrast = Color(0xFFECF5BF)
private val onTertiaryDarkHighContrast = Color(0xFF000000)
private val tertiaryContainerDarkHighContrast = Color(0xFFBEC895)
private val onTertiaryContainerDarkHighContrast = Color(0xFF090D00)
private val errorDarkHighContrast = Color(0xFFFFECE9)
private val onErrorDarkHighContrast = Color(0xFF000000)
private val errorContainerDarkHighContrast = Color(0xFFFFAEA4)
private val onErrorContainerDarkHighContrast = Color(0xFF220001)
private val backgroundDarkHighContrast = Color(0xFF19120C)
private val onBackgroundDarkHighContrast = Color(0xFFEFE0D5)
private val surfaceDarkHighContrast = Color(0xFF19120C)
private val onSurfaceDarkHighContrast = Color(0xFFFFFFFF)
private val surfaceVariantDarkHighContrast = Color(0xFF51443A)
private val onSurfaceVariantDarkHighContrast = Color(0xFFFFFFFF)
private val outlineDarkHighContrast = Color(0xFFFFEDE0)
private val outlineVariantDarkHighContrast = Color(0xFFD1BFB2)
private val scrimDarkHighContrast = Color(0xFF000000)
private val inverseSurfaceDarkHighContrast = Color(0xFFEFE0D5)
private val inverseOnSurfaceDarkHighContrast = Color(0xFF000000)
private val inversePrimaryDarkHighContrast = Color(0xFF6C3C04)
private val surfaceDimDarkHighContrast = Color(0xFF19120C)
private val surfaceBrightDarkHighContrast = Color(0xFF584E46)
private val surfaceContainerLowestDarkHighContrast = Color(0xFF000000)
private val surfaceContainerLowDarkHighContrast = Color(0xFF261E18)
private val surfaceContainerDarkHighContrast = Color(0xFF372F28)
private val surfaceContainerHighDarkHighContrast = Color(0xFF433A33)
private val surfaceContainerHighestDarkHighContrast = Color(0xFF4F453D)

val theme6LightScheme = lightColorScheme(
    primary = primaryLight,
    onPrimary = onPrimaryLight,
    primaryContainer = primaryContainerLight,
    onPrimaryContainer = onPrimaryContainerLight,
    secondary = secondaryLight,
    onSecondary = onSecondaryLight,
    secondaryContainer = secondaryContainerLight,
    onSecondaryContainer = onSecondaryContainerLight,
    tertiary = tertiaryLight,
    onTertiary = onTertiaryLight,
    tertiaryContainer = tertiaryContainerLight,
    onTertiaryContainer = onTertiaryContainerLight,
    error = errorLight,
    onError = onErrorLight,
    errorContainer = errorContainerLight,
    onErrorContainer = onErrorContainerLight,
    background = backgroundLight,
    onBackground = onBackgroundLight,
    surface = surfaceLight,
    onSurface = onSurfaceLight,
    surfaceVariant = surfaceVariantLight,
    onSurfaceVariant = onSurfaceVariantLight,
    outline = outlineLight,
    outlineVariant = outlineVariantLight,
    scrim = scrimLight,
    inverseSurface = inverseSurfaceLight,
    inverseOnSurface = inverseOnSurfaceLight,
    inversePrimary = inversePrimaryLight,
    surfaceDim = surfaceDimLight,
    surfaceBright = surfaceBrightLight,
    surfaceContainerLowest = surfaceContainerLowestLight,
    surfaceContainerLow = surfaceContainerLowLight,
    surfaceContainer = surfaceContainerLight,
    surfaceContainerHigh = surfaceContainerHighLight,
    surfaceContainerHighest = surfaceContainerHighestLight,
)

val theme6DarkScheme = darkColorScheme(
    primary = primaryDark,
    onPrimary = onPrimaryDark,
    primaryContainer = primaryContainerDark,
    onPrimaryContainer = onPrimaryContainerDark,
    secondary = secondaryDark,
    onSecondary = onSecondaryDark,
    secondaryContainer = secondaryContainerDark,
    onSecondaryContainer = onSecondaryContainerDark,
    tertiary = tertiaryDark,
    onTertiary = onTertiaryDark,
    tertiaryContainer = tertiaryContainerDark,
    onTertiaryContainer = onTertiaryContainerDark,
    error = errorDark,
    onError = onErrorDark,
    errorContainer = errorContainerDark,
    onErrorContainer = onErrorContainerDark,
    background = backgroundDark,
    onBackground = onBackgroundDark,
    surface = surfaceDark,
    onSurface = onSurfaceDark,
    surfaceVariant = surfaceVariantDark,
    onSurfaceVariant = onSurfaceVariantDark,
    outline = outlineDark,
    outlineVariant = outlineVariantDark,
    scrim = scrimDark,
    inverseSurface = inverseSurfaceDark,
    inverseOnSurface = inverseOnSurfaceDark,
    inversePrimary = inversePrimaryDark,
    surfaceDim = surfaceDimDark,
    surfaceBright = surfaceBrightDark,
    surfaceContainerLowest = surfaceContainerLowestDark,
    surfaceContainerLow = surfaceContainerLowDark,
    surfaceContainer = surfaceContainerDark,
    surfaceContainerHigh = surfaceContainerHighDark,
    surfaceContainerHighest = surfaceContainerHighestDark,
)

val theme6MediumContrastLightColorScheme = lightColorScheme(
    primary = primaryLightMediumContrast,
    onPrimary = onPrimaryLightMediumContrast,
    primaryContainer = primaryContainerLightMediumContrast,
    onPrimaryContainer = onPrimaryContainerLightMediumContrast,
    secondary = secondaryLightMediumContrast,
    onSecondary = onSecondaryLightMediumContrast,
    secondaryContainer = secondaryContainerLightMediumContrast,
    onSecondaryContainer = onSecondaryContainerLightMediumContrast,
    tertiary = tertiaryLightMediumContrast,
    onTertiary = onTertiaryLightMediumContrast,
    tertiaryContainer = tertiaryContainerLightMediumContrast,
    onTertiaryContainer = onTertiaryContainerLightMediumContrast,
    error = errorLightMediumContrast,
    onError = onErrorLightMediumContrast,
    errorContainer = errorContainerLightMediumContrast,
    onErrorContainer = onErrorContainerLightMediumContrast,
    background = backgroundLightMediumContrast,
    onBackground = onBackgroundLightMediumContrast,
    surface = surfaceLightMediumContrast,
    onSurface = onSurfaceLightMediumContrast,
    surfaceVariant = surfaceVariantLightMediumContrast,
    onSurfaceVariant = onSurfaceVariantLightMediumContrast,
    outline = outlineLightMediumContrast,
    outlineVariant = outlineVariantLightMediumContrast,
    scrim = scrimLightMediumContrast,
    inverseSurface = inverseSurfaceLightMediumContrast,
    inverseOnSurface = inverseOnSurfaceLightMediumContrast,
    inversePrimary = inversePrimaryLightMediumContrast,
    surfaceDim = surfaceDimLightMediumContrast,
    surfaceBright = surfaceBrightLightMediumContrast,
    surfaceContainerLowest = surfaceContainerLowestLightMediumContrast,
    surfaceContainerLow = surfaceContainerLowLightMediumContrast,
    surfaceContainer = surfaceContainerLightMediumContrast,
    surfaceContainerHigh = surfaceContainerHighLightMediumContrast,
    surfaceContainerHighest = surfaceContainerHighestLightMediumContrast,
)

val theme6HighContrastLightColorScheme = lightColorScheme(
    primary = primaryLightHighContrast,
    onPrimary = onPrimaryLightHighContrast,
    primaryContainer = primaryContainerLightHighContrast,
    onPrimaryContainer = onPrimaryContainerLightHighContrast,
    secondary = secondaryLightHighContrast,
    onSecondary = onSecondaryLightHighContrast,
    secondaryContainer = secondaryContainerLightHighContrast,
    onSecondaryContainer = onSecondaryContainerLightHighContrast,
    tertiary = tertiaryLightHighContrast,
    onTertiary = onTertiaryLightHighContrast,
    tertiaryContainer = tertiaryContainerLightHighContrast,
    onTertiaryContainer = onTertiaryContainerLightHighContrast,
    error = errorLightHighContrast,
    onError = onErrorLightHighContrast,
    errorContainer = errorContainerLightHighContrast,
    onErrorContainer = onErrorContainerLightHighContrast,
    background = backgroundLightHighContrast,
    onBackground = onBackgroundLightHighContrast,
    surface = surfaceLightHighContrast,
    onSurface = onSurfaceLightHighContrast,
    surfaceVariant = surfaceVariantLightHighContrast,
    onSurfaceVariant = onSurfaceVariantLightHighContrast,
    outline = outlineLightHighContrast,
    outlineVariant = outlineVariantLightHighContrast,
    scrim = scrimLightHighContrast,
    inverseSurface = inverseSurfaceLightHighContrast,
    inverseOnSurface = inverseOnSurfaceLightHighContrast,
    inversePrimary = inversePrimaryLightHighContrast,
    surfaceDim = surfaceDimLightHighContrast,
    surfaceBright = surfaceBrightLightHighContrast,
    surfaceContainerLowest = surfaceContainerLowestLightHighContrast,
    surfaceContainerLow = surfaceContainerLowLightHighContrast,
    surfaceContainer = surfaceContainerLightHighContrast,
    surfaceContainerHigh = surfaceContainerHighLightHighContrast,
    surfaceContainerHighest = surfaceContainerHighestLightHighContrast,
)

val theme6MediumContrastDarkColorScheme = darkColorScheme(
    primary = primaryDarkMediumContrast,
    onPrimary = onPrimaryDarkMediumContrast,
    primaryContainer = primaryContainerDarkMediumContrast,
    onPrimaryContainer = onPrimaryContainerDarkMediumContrast,
    secondary = secondaryDarkMediumContrast,
    onSecondary = onSecondaryDarkMediumContrast,
    secondaryContainer = secondaryContainerDarkMediumContrast,
    onSecondaryContainer = onSecondaryContainerDarkMediumContrast,
    tertiary = tertiaryDarkMediumContrast,
    onTertiary = onTertiaryDarkMediumContrast,
    tertiaryContainer = tertiaryContainerDarkMediumContrast,
    onTertiaryContainer = onTertiaryContainerDarkMediumContrast,
    error = errorDarkMediumContrast,
    onError = onErrorDarkMediumContrast,
    errorContainer = errorContainerDarkMediumContrast,
    onErrorContainer = onErrorContainerDarkMediumContrast,
    background = backgroundDarkMediumContrast,
    onBackground = onBackgroundDarkMediumContrast,
    surface = surfaceDarkMediumContrast,
    onSurface = onSurfaceDarkMediumContrast,
    surfaceVariant = surfaceVariantDarkMediumContrast,
    onSurfaceVariant = onSurfaceVariantDarkMediumContrast,
    outline = outlineDarkMediumContrast,
    outlineVariant = outlineVariantDarkMediumContrast,
    scrim = scrimDarkMediumContrast,
    inverseSurface = inverseSurfaceDarkMediumContrast,
    inverseOnSurface = inverseOnSurfaceDarkMediumContrast,
    inversePrimary = inversePrimaryDarkMediumContrast,
    surfaceDim = surfaceDimDarkMediumContrast,
    surfaceBright = surfaceBrightDarkMediumContrast,
    surfaceContainerLowest = surfaceContainerLowestDarkMediumContrast,
    surfaceContainerLow = surfaceContainerLowDarkMediumContrast,
    surfaceContainer = surfaceContainerDarkMediumContrast,
    surfaceContainerHigh = surfaceContainerHighDarkMediumContrast,
    surfaceContainerHighest = surfaceContainerHighestDarkMediumContrast,
)

val theme6HighContrastDarkColorScheme = darkColorScheme(
    primary = primaryDarkHighContrast,
    onPrimary = onPrimaryDarkHighContrast,
    primaryContainer = primaryContainerDarkHighContrast,
    onPrimaryContainer = onPrimaryContainerDarkHighContrast,
    secondary = secondaryDarkHighContrast,
    onSecondary = onSecondaryDarkHighContrast,
    secondaryContainer = secondaryContainerDarkHighContrast,
    onSecondaryContainer = onSecondaryContainerDarkHighContrast,
    tertiary = tertiaryDarkHighContrast,
    onTertiary = onTertiaryDarkHighContrast,
    tertiaryContainer = tertiaryContainerDarkHighContrast,
    onTertiaryContainer = onTertiaryContainerDarkHighContrast,
    error = errorDarkHighContrast,
    onError = onErrorDarkHighContrast,
    errorContainer = errorContainerDarkHighContrast,
    onErrorContainer = onErrorContainerDarkHighContrast,
    background = backgroundDarkHighContrast,
    onBackground = onBackgroundDarkHighContrast,
    surface = surfaceDarkHighContrast,
    onSurface = onSurfaceDarkHighContrast,
    surfaceVariant = surfaceVariantDarkHighContrast,
    onSurfaceVariant = onSurfaceVariantDarkHighContrast,
    outline = outlineDarkHighContrast,
    outlineVariant = outlineVariantDarkHighContrast,
    scrim = scrimDarkHighContrast,
    inverseSurface = inverseSurfaceDarkHighContrast,
    inverseOnSurface = inverseOnSurfaceDarkHighContrast,
    inversePrimary = inversePrimaryDarkHighContrast,
    surfaceDim = surfaceDimDarkHighContrast,
    surfaceBright = surfaceBrightDarkHighContrast,
    surfaceContainerLowest = surfaceContainerLowestDarkHighContrast,
    surfaceContainerLow = surfaceContainerLowDarkHighContrast,
    surfaceContainer = surfaceContainerDarkHighContrast,
    surfaceContainerHigh = surfaceContainerHighDarkHighContrast,
    surfaceContainerHighest = surfaceContainerHighestDarkHighContrast,
)