// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class AppLocalizationsJa extends AppLocalizations {
  AppLocalizationsJa([String locale = 'ja']) : super(locale);

  @override
  String get appName => 'Converter NOW';

  @override
  String get reorder => '並び替え';

  @override
  String get myOrdering => 'マイ並び替え';

  @override
  String get about => 'このアプリについて';

  @override
  String get lastCurrenciesUpdate => '最終更新: ';

  @override
  String get today => '今日';

  @override
  String get enableDarkTheme => 'ダークテーマを有効化';

  @override
  String get settings => '設定';

  @override
  String get menu => 'メニュー';

  @override
  String get donation => '寄付をする';

  @override
  String get buyMeACoffee => '開発者にコーヒーを購入';

  @override
  String get donationDialog =>
      'こんにちは、ご存知かもしれませんが、このアプリは無料でオープンソースです。あなたがこのアプリを無料で使用してソースコードをコピー、編集できることを意味します。開発者はそれに対して何も得られません。しかし、このプロジェクトに賛同し、新しい機能を見たい場合は、私にコーヒーを買うことを検討してください。';

  @override
  String get drawerLogo => 'ロゴドロワー';

  @override
  String get rateApp => 'アプリを評価する';

  @override
  String get repoGithub => 'GitHubでリポジトリを開く';

  @override
  String get contributeTranslating => 'アプリの翻訳に参加する';

  @override
  String get search => '検索';

  @override
  String get clearAll => 'すべて削除';

  @override
  String get calculator => '電卓';

  @override
  String get significantFigures => '有効数字';

  @override
  String get removeTrailingZeros => '末尾の0を削除する';

  @override
  String get longPressAdvice => '長押しでアイテムを移動できます';

  @override
  String get back => '戻る';

  @override
  String get save => '保存';

  @override
  String get invalidCharacters => 'エラー、無効な文字';

  @override
  String get theme => 'テーマ';

  @override
  String get dark => 'ダーク';

  @override
  String get light => 'ライト';

  @override
  String get system => 'システムの設定';

  @override
  String get pureBlackTheme => 'AMOLEDダークテーマ';

  @override
  String get propertySelectionOnStartup => 'Property selection on startup';

  @override
  String get propertySelectionOnStartupSubtitle =>
      'Show the property selection page on startup on small screen devices';

  @override
  String get copy => 'コピー';

  @override
  String get paste => 'Paste';

  @override
  String get more => 'さらに';

  @override
  String get language => '言語';

  @override
  String get reorderProperties => 'グループを並び替える';

  @override
  String get reorderUnits => '項目を並び替える';

  @override
  String get chooseProperty => 'グループを選択してください';

  @override
  String reorderProperty(String property) {
    return '$propertyを並び替える';
  }

  @override
  String get otherPlatforms => 'その他のプラットフォームで使用する';

  @override
  String get sourceCode => 'ソースコード';

  @override
  String get undoClearAllMessage => 'すべて削除しました。もとに戻しますか?';

  @override
  String get undo => '元に戻す';

  @override
  String get routeError1 => 'このページは存在しません。';

  @override
  String get routeError2 => '先頭ページに戻る';

  @override
  String get ok => 'Ok';

  @override
  String get revokeInternetAccess => 'Revoke internet access';

  @override
  String get revokeInternetExplanation =>
      'This app uses the internet to update currency exchange rates once a day upon opening. This download only requires a few kilobytes. However, if you don\'t need this feature, you can prevent the app from accessing the internet by enabling this option.';

  @override
  String get useDeviceColor => 'Use device color';

  @override
  String get pickColor => 'Pick a color';

  @override
  String get themeColor => 'Theme color';

  @override
  String get appearance => 'Appearance';

  @override
  String get conversions => 'Conversions';

  @override
  String get findOutMore => 'Find out more';

  @override
  String get hideUnits => 'Hide units';

  @override
  String visibleUnits(String property) {
    return '$property, visible units';
  }

  @override
  String get hiddenUnits => 'Hidden units';

  @override
  String get selectAll => 'Select all';

  @override
  String get unselectAll => 'Unselect all';

  @override
  String get length => '長さ';

  @override
  String get area => '面積';

  @override
  String get volume => '体積';

  @override
  String get time => '時間';

  @override
  String get temperature => '温度';

  @override
  String get speed => '速度';

  @override
  String get siPrefixes => '国際単位変換';

  @override
  String get mass => '質量';

  @override
  String get pressure => '圧力';

  @override
  String get energy => 'エネルギー';

  @override
  String get angles => '角度';

  @override
  String get currencies => '通貨';

  @override
  String get shoeSize => '靴のサイズ';

  @override
  String get digitalData => 'デジタルデータ';

  @override
  String get power => '仕事率';

  @override
  String get density => 'Density';

  @override
  String get torque => 'トルク';

  @override
  String get force => '力';

  @override
  String get fuelConsumption => '燃費';

  @override
  String get numeralSystems => '記数法';

  @override
  String get meters => 'メートル';

  @override
  String get centimeters => 'センチメートル';

  @override
  String get inches => 'インチ';

  @override
  String get feet => 'フィート';

  @override
  String get nauticalMiles => '海里';

  @override
  String get yards => 'ヤード';

  @override
  String get miles => 'マイル';

  @override
  String get millimeters => 'ミリメートル';

  @override
  String get micrometers => 'マイクロメートル';

  @override
  String get nanometers => 'ナノメートル';

  @override
  String get angstroms => 'オングストローム';

  @override
  String get picometers => 'ピコメートル';

  @override
  String get kilometers => 'キロメートル';

  @override
  String get astronomicalUnits => '天文単位';

  @override
  String get lightYears => '光年';

  @override
  String get parsec => 'パーセク';

  @override
  String get mils => 'ミル';

  @override
  String get feetUsSurvey => '測量フィート';

  @override
  String get squareMeters => '平方メートル';

  @override
  String get squareCentimeters => '平方センチメートル';

  @override
  String get squareInches => '平方インチ';

  @override
  String get squareFeet => '平方フィート';

  @override
  String get squareMiles => '平方マイル';

  @override
  String get squareYard => '平方ヤード';

  @override
  String get squareMillimeters => '平方ミリメートル';

  @override
  String get squareKilometers => '平方キロメートル';

  @override
  String get hectares => 'ヘクタール';

  @override
  String get acres => 'エーカー';

  @override
  String get are => 'アール';

  @override
  String get squareFeetUsSurvey => '平方フィート(アメリカ)';

  @override
  String get gramsPerCubicCentimeter => 'Grams per Cubic Centimeter';

  @override
  String get gramsPerLiter => 'Grams per Liter';

  @override
  String get gramsPerMilliliter => 'Grams per Milliliter';

  @override
  String get gramsPerDeciliter => 'Grams per Deciliter';

  @override
  String get kilogramsPerLiter => 'Kilograms per Liter';

  @override
  String get kilogramsPerCubicMeter => 'Kilograms per Cubic Meter';

  @override
  String get milligramsPerLiter => 'Milligrams per Liter';

  @override
  String get milligramsPerDeciliter => 'Milligrams per Deciliter';

  @override
  String get milligramsPerMilliliter => 'Milligrams per Milliliter';

  @override
  String get milligramsPerCubicMeter => 'Milligrams per Cubic Meter';

  @override
  String get milligramsPerCubicCentimeter => 'Milligrams per Cubic Centimeter';

  @override
  String get microgramsPerLiter => 'Micrograms per Liter';

  @override
  String get microgramsPerDeciliter => 'Micrograms per Deciliter';

  @override
  String get microgramsPerMilliliter => 'Micrograms per Milliliter';

  @override
  String get poundsPerCubicInches => 'Pounds per Cubic Inches';

  @override
  String get poundsPerCubicFeet => 'Pounds per Cubic Feet';

  @override
  String get cubicMeters => '立方メートル';

  @override
  String get liters => 'リットル';

  @override
  String get imperialGallons => '英ガロン';

  @override
  String get usGallons => '米国乾量ガロン';

  @override
  String get imperialPints => '英パイント';

  @override
  String get usPints => '米乾量パイント';

  @override
  String get milliliters => 'ミリリットル';

  @override
  String get tablespoonUs => '大さじ(アメリカ)';

  @override
  String get tablespoonAustralian => '大さじ(オーストラリア)';

  @override
  String get cups => 'カップ';

  @override
  String get cubicCentimeters => '立方センチメートル';

  @override
  String get cubicFeet => '立方フィート';

  @override
  String get cubicInches => '立方インチ';

  @override
  String get cubicMillimeters => '立方ミリメートル';

  @override
  String get imperialFluidOunces => '英液用オンス';

  @override
  String get usFluidOunces => '米液用オンス';

  @override
  String get imperialGill => 'ジル(イギリス)';

  @override
  String get usGill => 'ジル(アメリカ)';

  @override
  String get usQuarts => 'US Quarts';

  @override
  String get microliters => 'Microliters';

  @override
  String get deciliters => 'Deciliters';

  @override
  String get centiliters => 'Centiliters';

  @override
  String get seconds => '秒';

  @override
  String get deciseconds => 'デシ秒';

  @override
  String get centiseconds => 'センチ秒';

  @override
  String get milliseconds => 'ミリ秒';

  @override
  String get microseconds => 'マイクロ秒';

  @override
  String get nanoseconds => 'ナノ秒';

  @override
  String get minutes => '分';

  @override
  String get hours => '時間';

  @override
  String get days => '日';

  @override
  String get weeks => '週';

  @override
  String get years => '年 (365)';

  @override
  String get lustrum => '5年紀';

  @override
  String get decades => '10年紀';

  @override
  String get centuries => '世紀';

  @override
  String get millennium => 'ミレニアム';

  @override
  String get fahrenheit => '華氏';

  @override
  String get celsius => '摂氏 (センティグレイド)';

  @override
  String get kelvin => 'ケルビン';

  @override
  String get reamur => 'レオミュール';

  @override
  String get romer => 'レーマー';

  @override
  String get delisle => 'ドリール';

  @override
  String get rankine => 'ランキン';

  @override
  String get metersSecond => 'メートル毎秒';

  @override
  String get kilometersHour => 'キロ毎時';

  @override
  String get milesHour => 'マイル毎時';

  @override
  String get knots => 'ノット';

  @override
  String get feetSecond => 'フィート毎秒';

  @override
  String get minutesPerKilometer => '分毎キロ';

  @override
  String get grams => 'グラム';

  @override
  String get ettograms => 'エット';

  @override
  String get kilograms => 'キログラム';

  @override
  String get pounds => 'ポンド';

  @override
  String get ounces => 'オンス';

  @override
  String get quintals => 'キンタル';

  @override
  String get tons => 'トン';

  @override
  String get milligrams => 'ミリグラム';

  @override
  String get uma => '原子質量単位';

  @override
  String get carats => 'カラット';

  @override
  String get centigrams => 'センチグラム';

  @override
  String get pennyweights => 'ペニーウェイト';

  @override
  String get troyOunces => 'トロイオンス';

  @override
  String get stones => 'ストーン';

  @override
  String get pascal => 'パスカル';

  @override
  String get atmosphere => '気圧';

  @override
  String get bar => 'バール';

  @override
  String get millibar => 'ミリバール';

  @override
  String get psi => '重量ポンド毎平方インチ';

  @override
  String get torr => 'トル';

  @override
  String get hectoPascal => 'ヘクトパスカル';

  @override
  String get inchesOfMercury => '水銀柱インチ';

  @override
  String get kiloPascal => 'Kilopascal';

  @override
  String get ksi => 'Kilopounds per square inch';

  @override
  String get megaPascal => 'Megapascal';

  @override
  String get gigaPascal => 'Gigapascal';

  @override
  String get joule => 'ジュール';

  @override
  String get calories => 'カロリー';

  @override
  String get kilowattHour => 'キロワット時';

  @override
  String get electronvolt => '電子ボルト';

  @override
  String get footPound => 'フィート重量ポンド';

  @override
  String get kilocalories => 'キロカロリー';

  @override
  String get kilojoules => 'Kilojoules';

  @override
  String get degree => '角度';

  @override
  String get minutesDegree => '分';

  @override
  String get secondsDegree => '秒';

  @override
  String get radiansDegree => 'ラジアン';

  @override
  String get usd => '米ドル';

  @override
  String get eur => 'ユーロ';

  @override
  String get gbp => 'スターリングポンド';

  @override
  String get inr => 'インドルピー';

  @override
  String get cny => '人民元';

  @override
  String get jpy => '日本円';

  @override
  String get chf => 'スイスフラン';

  @override
  String get sek => 'スウェーデンクローナ';

  @override
  String get rub => 'ロシアルーブル';

  @override
  String get cad => 'カナダドル';

  @override
  String get krw => '大韓民国ウォン';

  @override
  String get brl => 'レアル';

  @override
  String get hkd => '香港ドル';

  @override
  String get aud => '豪ドル';

  @override
  String get nzd => 'NZドル';

  @override
  String get mxn => 'メキシコペソ';

  @override
  String get sgd => 'シンガポールドル';

  @override
  String get nok => 'ノルウェークローネ';

  @override
  String get trY => 'トルコリラ';

  @override
  String get zar => 'ランド';

  @override
  String get dkk => 'デンマーククローネ';

  @override
  String get pln => 'ズウォティ';

  @override
  String get thb => 'バーツ';

  @override
  String get myr => 'リンギット';

  @override
  String get huf => 'フォリント';

  @override
  String get czk => 'チェココルナ';

  @override
  String get ils => '新シェケル';

  @override
  String get idr => 'ルピア';

  @override
  String get php => 'フィリピンペソ';

  @override
  String get ron => 'ルーマニアレウ';

  @override
  String get bgn => 'レフ';

  @override
  String get isk => 'アイスランドクローナ';

  @override
  String get twd => '新台湾ドル';

  @override
  String get mad => 'モロッコディルハム';

  @override
  String get euChina => 'EU & 中国';

  @override
  String get ukIndiaChild => 'イギリス & インド - 子供';

  @override
  String get ukIndiaMan => 'イギリス & インド - 男性';

  @override
  String get ukIndiaWoman => 'イギリス & インド - 女性';

  @override
  String get usaCanadaChild => 'アメリカ & ・カナダ - 子供';

  @override
  String get usaCanadaMan => 'アメリカ & カナダ - 男性';

  @override
  String get usaCanadaWoman => 'アメリカ & カナダ - 女性';

  @override
  String get japan => '日本';

  @override
  String get watt => 'ワット';

  @override
  String get milliwatt => 'ミリワット';

  @override
  String get kilowatt => 'キロワット';

  @override
  String get megawatt => 'メガワット';

  @override
  String get gigawatt => 'ギガワット';

  @override
  String get europeanHorsePower => 'ヨーロッパ馬力';

  @override
  String get imperialHorsePower => '英馬力';

  @override
  String get newton => 'ニュートン';

  @override
  String get dyne => 'ダイン';

  @override
  String get poundForce => '重量ポンド';

  @override
  String get kilogramForce => '重量キログラム';

  @override
  String get poundal => 'パウンダル';

  @override
  String get newtonMeter => 'ニュートンメートル';

  @override
  String get dyneMeter => 'ダインメートル';

  @override
  String get poundForceFeet => 'フィート重量ポンド';

  @override
  String get kilogramForceMeter => '重量キログラムメートル';

  @override
  String get poundalMeter => 'パウンダルメートル';

  @override
  String get kilometersLiter => 'キロメートル毎リットル';

  @override
  String get liters100km => '100キロメートル毎リットル';

  @override
  String get milesUsGallon => 'マイル毎米国液量ガロン';

  @override
  String get milesImperialGallon => 'マイル毎英ガロン';

  @override
  String get decimal => '10進数';

  @override
  String get hexadecimal => '16進数';

  @override
  String get octal => '8進数';

  @override
  String get binary => '2進数';

  @override
  String get bit => 'ビット';

  @override
  String get nibble => 'ビブル';

  @override
  String get kilobit => 'キロビット';

  @override
  String get megabit => 'メガビット';

  @override
  String get gigabit => 'ギガビット';

  @override
  String get terabit => 'テラビット';

  @override
  String get petabit => 'ペタビット';

  @override
  String get exabit => 'エクサビット';

  @override
  String get kibibit => 'キビビット';

  @override
  String get mebibit => 'メビビット';

  @override
  String get gibibit => 'ギビビット';

  @override
  String get tebibit => 'テビビット';

  @override
  String get pebibit => 'ペビビット';

  @override
  String get exbibit => 'エクスビビット';

  @override
  String get byte => 'バイト';

  @override
  String get kilobyte => 'キロバイト';

  @override
  String get megabyte => 'メガバイト';

  @override
  String get gigabyte => 'ギガバイト';

  @override
  String get terabyte => 'テラバイト';

  @override
  String get petabyte => 'ペタバイト';

  @override
  String get exabyte => 'エクサバイト';

  @override
  String get kibibyte => 'キビバイト';

  @override
  String get mebibyte => 'メビバイト';

  @override
  String get gibibyte => 'ギビバイト';

  @override
  String get tebibyte => 'テビバイト';

  @override
  String get pebibyte => 'ペビバイト';

  @override
  String get exbibyte => 'エクサビバイト';

  @override
  String get base => '基数';

  @override
  String get deca => 'デカ-';

  @override
  String get hecto => 'ヘクト-';

  @override
  String get kilo => 'キロ-';

  @override
  String get mega => 'メガ-';

  @override
  String get giga => 'ギガ-';

  @override
  String get tera => 'テラ-';

  @override
  String get peta => 'ペタ-';

  @override
  String get exa => 'エクサ-';

  @override
  String get zetta => 'ゼタ-';

  @override
  String get yotta => 'ヨタ-';

  @override
  String get deci => 'デシ-';

  @override
  String get centi => 'センチ-';

  @override
  String get milli => 'ミリ-';

  @override
  String get micro => 'マイクロ-';

  @override
  String get nano => 'ナノ-';

  @override
  String get pico => 'ピコ-';

  @override
  String get femto => 'フェムト-';

  @override
  String get atto => 'アト-';

  @override
  String get zepto => 'ゼプト-';

  @override
  String get yocto => 'ヨクト-';
}
