import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_ar.dart';
import 'app_localizations_bn.dart';
import 'app_localizations_ca.dart';
import 'app_localizations_de.dart';
import 'app_localizations_el.dart';
import 'app_localizations_en.dart';
import 'app_localizations_es.dart';
import 'app_localizations_fr.dart';
import 'app_localizations_hr.dart';
import 'app_localizations_id.dart';
import 'app_localizations_it.dart';
import 'app_localizations_ja.dart';
import 'app_localizations_nb.dart';
import 'app_localizations_nl.dart';
import 'app_localizations_pl.dart';
import 'app_localizations_pt.dart';
import 'app_localizations_ru.dart';
import 'app_localizations_tr.dart';
import 'app_localizations_zh.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'lib/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale)
    : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations? of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations);
  }

  static const LocalizationsDelegate<AppLocalizations> delegate =
      _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
        delegate,
        GlobalMaterialLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
      ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('ar'),
    Locale('bn'),
    Locale('ca'),
    Locale('de'),
    Locale('el'),
    Locale('en'),
    Locale('es'),
    Locale('fr'),
    Locale('hr'),
    Locale('id'),
    Locale('it'),
    Locale('ja'),
    Locale('nb'),
    Locale('nl'),
    Locale('pl'),
    Locale('pt'),
    Locale('ru'),
    Locale('tr'),
    Locale('zh'),
    Locale('zh', 'TW'),
  ];

  /// No description provided for @appName.
  ///
  /// In en, this message translates to:
  /// **'Converter NOW'**
  String get appName;

  /// No description provided for @reorder.
  ///
  /// In en, this message translates to:
  /// **'Reorder'**
  String get reorder;

  /// No description provided for @myOrdering.
  ///
  /// In en, this message translates to:
  /// **'My ordering'**
  String get myOrdering;

  /// No description provided for @about.
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get about;

  /// No description provided for @lastCurrenciesUpdate.
  ///
  /// In en, this message translates to:
  /// **'Last update: '**
  String get lastCurrenciesUpdate;

  /// No description provided for @today.
  ///
  /// In en, this message translates to:
  /// **'today'**
  String get today;

  /// No description provided for @enableDarkTheme.
  ///
  /// In en, this message translates to:
  /// **'Enable dark theme'**
  String get enableDarkTheme;

  /// No description provided for @settings.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settings;

  /// No description provided for @menu.
  ///
  /// In en, this message translates to:
  /// **'Menu'**
  String get menu;

  /// No description provided for @donation.
  ///
  /// In en, this message translates to:
  /// **'Make a donation'**
  String get donation;

  /// No description provided for @buyMeACoffee.
  ///
  /// In en, this message translates to:
  /// **'Buy me a coffee'**
  String get buyMeACoffee;

  /// No description provided for @donationDialog.
  ///
  /// In en, this message translates to:
  /// **'Hi, as you might know this app is free and open source. It means that you can use it for free and copy/edit the source code. The developer will not gain nothing for it. But if you also believe in this project and would like to see new features, please consider buying me a coffee.'**
  String get donationDialog;

  /// No description provided for @drawerLogo.
  ///
  /// In en, this message translates to:
  /// **'Drawer logo'**
  String get drawerLogo;

  /// No description provided for @rateApp.
  ///
  /// In en, this message translates to:
  /// **'Rate the app'**
  String get rateApp;

  /// No description provided for @repoGithub.
  ///
  /// In en, this message translates to:
  /// **'Open repo on GitHub'**
  String get repoGithub;

  /// No description provided for @contributeTranslating.
  ///
  /// In en, this message translates to:
  /// **'Contribute translating the app'**
  String get contributeTranslating;

  /// No description provided for @search.
  ///
  /// In en, this message translates to:
  /// **'Search'**
  String get search;

  /// No description provided for @clearAll.
  ///
  /// In en, this message translates to:
  /// **'Clear all'**
  String get clearAll;

  /// No description provided for @calculator.
  ///
  /// In en, this message translates to:
  /// **'Calculator'**
  String get calculator;

  /// No description provided for @significantFigures.
  ///
  /// In en, this message translates to:
  /// **'Significant figures'**
  String get significantFigures;

  /// No description provided for @removeTrailingZeros.
  ///
  /// In en, this message translates to:
  /// **'Remove trailing zeros'**
  String get removeTrailingZeros;

  /// No description provided for @longPressAdvice.
  ///
  /// In en, this message translates to:
  /// **'Long press to move items'**
  String get longPressAdvice;

  /// No description provided for @back.
  ///
  /// In en, this message translates to:
  /// **'Back'**
  String get back;

  /// No description provided for @save.
  ///
  /// In en, this message translates to:
  /// **'Save'**
  String get save;

  /// No description provided for @invalidCharacters.
  ///
  /// In en, this message translates to:
  /// **'Error, invalid characters'**
  String get invalidCharacters;

  /// No description provided for @theme.
  ///
  /// In en, this message translates to:
  /// **'Theme'**
  String get theme;

  /// No description provided for @dark.
  ///
  /// In en, this message translates to:
  /// **'Dark'**
  String get dark;

  /// No description provided for @light.
  ///
  /// In en, this message translates to:
  /// **'Light'**
  String get light;

  /// No description provided for @system.
  ///
  /// In en, this message translates to:
  /// **'System default'**
  String get system;

  /// No description provided for @pureBlackTheme.
  ///
  /// In en, this message translates to:
  /// **'Pure black theme'**
  String get pureBlackTheme;

  /// No description provided for @propertySelectionOnStartup.
  ///
  /// In en, this message translates to:
  /// **'Property selection on startup'**
  String get propertySelectionOnStartup;

  /// No description provided for @propertySelectionOnStartupSubtitle.
  ///
  /// In en, this message translates to:
  /// **'Show the property selection page on startup on small screen devices'**
  String get propertySelectionOnStartupSubtitle;

  /// No description provided for @copy.
  ///
  /// In en, this message translates to:
  /// **'Copy'**
  String get copy;

  /// No description provided for @paste.
  ///
  /// In en, this message translates to:
  /// **'Paste'**
  String get paste;

  /// No description provided for @more.
  ///
  /// In en, this message translates to:
  /// **'More'**
  String get more;

  /// No description provided for @language.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get language;

  /// No description provided for @reorderProperties.
  ///
  /// In en, this message translates to:
  /// **'Reorder properties'**
  String get reorderProperties;

  /// No description provided for @reorderUnits.
  ///
  /// In en, this message translates to:
  /// **'Reorder units'**
  String get reorderUnits;

  /// No description provided for @chooseProperty.
  ///
  /// In en, this message translates to:
  /// **'Choose a property'**
  String get chooseProperty;

  /// No description provided for @reorderProperty.
  ///
  /// In en, this message translates to:
  /// **'Reorder {property}'**
  String reorderProperty(String property);

  /// No description provided for @otherPlatforms.
  ///
  /// In en, this message translates to:
  /// **'Converter NOW for other platforms'**
  String get otherPlatforms;

  /// No description provided for @sourceCode.
  ///
  /// In en, this message translates to:
  /// **'Source code'**
  String get sourceCode;

  /// No description provided for @undoClearAllMessage.
  ///
  /// In en, this message translates to:
  /// **'Cleared all. Do you want to undo it?'**
  String get undoClearAllMessage;

  /// No description provided for @undo.
  ///
  /// In en, this message translates to:
  /// **'Undo'**
  String get undo;

  /// No description provided for @routeError1.
  ///
  /// In en, this message translates to:
  /// **'This page doesn\'t exist'**
  String get routeError1;

  /// No description provided for @routeError2.
  ///
  /// In en, this message translates to:
  /// **'Go back to the first page'**
  String get routeError2;

  /// No description provided for @ok.
  ///
  /// In en, this message translates to:
  /// **'Ok'**
  String get ok;

  /// No description provided for @revokeInternetAccess.
  ///
  /// In en, this message translates to:
  /// **'Revoke internet access'**
  String get revokeInternetAccess;

  /// No description provided for @revokeInternetExplanation.
  ///
  /// In en, this message translates to:
  /// **'This app uses the internet to update currency exchange rates once a day upon opening. This download only requires a few kilobytes. However, if you don\'t need this feature, you can prevent the app from accessing the internet by enabling this option.'**
  String get revokeInternetExplanation;

  /// No description provided for @useDeviceColor.
  ///
  /// In en, this message translates to:
  /// **'Use device color'**
  String get useDeviceColor;

  /// No description provided for @pickColor.
  ///
  /// In en, this message translates to:
  /// **'Pick a color'**
  String get pickColor;

  /// No description provided for @themeColor.
  ///
  /// In en, this message translates to:
  /// **'Theme color'**
  String get themeColor;

  /// No description provided for @appearance.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get appearance;

  /// No description provided for @conversions.
  ///
  /// In en, this message translates to:
  /// **'Conversions'**
  String get conversions;

  /// No description provided for @findOutMore.
  ///
  /// In en, this message translates to:
  /// **'Find out more'**
  String get findOutMore;

  /// No description provided for @hideUnits.
  ///
  /// In en, this message translates to:
  /// **'Hide units'**
  String get hideUnits;

  /// No description provided for @visibleUnits.
  ///
  /// In en, this message translates to:
  /// **'{property}, visible units'**
  String visibleUnits(String property);

  /// No description provided for @hiddenUnits.
  ///
  /// In en, this message translates to:
  /// **'Hidden units'**
  String get hiddenUnits;

  /// No description provided for @selectAll.
  ///
  /// In en, this message translates to:
  /// **'Select all'**
  String get selectAll;

  /// No description provided for @unselectAll.
  ///
  /// In en, this message translates to:
  /// **'Unselect all'**
  String get unselectAll;

  /// No description provided for @length.
  ///
  /// In en, this message translates to:
  /// **'Length'**
  String get length;

  /// No description provided for @area.
  ///
  /// In en, this message translates to:
  /// **'Area'**
  String get area;

  /// No description provided for @volume.
  ///
  /// In en, this message translates to:
  /// **'Volume'**
  String get volume;

  /// No description provided for @time.
  ///
  /// In en, this message translates to:
  /// **'Time'**
  String get time;

  /// No description provided for @temperature.
  ///
  /// In en, this message translates to:
  /// **'Temperature'**
  String get temperature;

  /// No description provided for @speed.
  ///
  /// In en, this message translates to:
  /// **'Speed'**
  String get speed;

  /// No description provided for @siPrefixes.
  ///
  /// In en, this message translates to:
  /// **'SI Prefix'**
  String get siPrefixes;

  /// No description provided for @mass.
  ///
  /// In en, this message translates to:
  /// **'Mass'**
  String get mass;

  /// No description provided for @pressure.
  ///
  /// In en, this message translates to:
  /// **'Pressure'**
  String get pressure;

  /// No description provided for @energy.
  ///
  /// In en, this message translates to:
  /// **'Energy'**
  String get energy;

  /// No description provided for @angles.
  ///
  /// In en, this message translates to:
  /// **'Angles'**
  String get angles;

  /// No description provided for @currencies.
  ///
  /// In en, this message translates to:
  /// **'Currencies'**
  String get currencies;

  /// No description provided for @shoeSize.
  ///
  /// In en, this message translates to:
  /// **'Shoe size'**
  String get shoeSize;

  /// No description provided for @digitalData.
  ///
  /// In en, this message translates to:
  /// **'Digital data'**
  String get digitalData;

  /// No description provided for @power.
  ///
  /// In en, this message translates to:
  /// **'Power'**
  String get power;

  /// No description provided for @density.
  ///
  /// In en, this message translates to:
  /// **'Density'**
  String get density;

  /// No description provided for @torque.
  ///
  /// In en, this message translates to:
  /// **'Torque'**
  String get torque;

  /// No description provided for @force.
  ///
  /// In en, this message translates to:
  /// **'Force'**
  String get force;

  /// No description provided for @fuelConsumption.
  ///
  /// In en, this message translates to:
  /// **'Fuel consumption'**
  String get fuelConsumption;

  /// No description provided for @numeralSystems.
  ///
  /// In en, this message translates to:
  /// **'Numeral systems'**
  String get numeralSystems;

  /// No description provided for @meters.
  ///
  /// In en, this message translates to:
  /// **'Meters'**
  String get meters;

  /// No description provided for @centimeters.
  ///
  /// In en, this message translates to:
  /// **'Centimeters'**
  String get centimeters;

  /// No description provided for @inches.
  ///
  /// In en, this message translates to:
  /// **'Inches'**
  String get inches;

  /// No description provided for @feet.
  ///
  /// In en, this message translates to:
  /// **'Feet'**
  String get feet;

  /// No description provided for @nauticalMiles.
  ///
  /// In en, this message translates to:
  /// **'Nautical miles'**
  String get nauticalMiles;

  /// No description provided for @yards.
  ///
  /// In en, this message translates to:
  /// **'Yards'**
  String get yards;

  /// No description provided for @miles.
  ///
  /// In en, this message translates to:
  /// **'Miles'**
  String get miles;

  /// No description provided for @millimeters.
  ///
  /// In en, this message translates to:
  /// **'Millimeters'**
  String get millimeters;

  /// No description provided for @micrometers.
  ///
  /// In en, this message translates to:
  /// **'Micrometers'**
  String get micrometers;

  /// No description provided for @nanometers.
  ///
  /// In en, this message translates to:
  /// **'Nanometers'**
  String get nanometers;

  /// No description provided for @angstroms.
  ///
  /// In en, this message translates to:
  /// **'Ångström'**
  String get angstroms;

  /// No description provided for @picometers.
  ///
  /// In en, this message translates to:
  /// **'Picometers'**
  String get picometers;

  /// No description provided for @kilometers.
  ///
  /// In en, this message translates to:
  /// **'Kilometers'**
  String get kilometers;

  /// No description provided for @astronomicalUnits.
  ///
  /// In en, this message translates to:
  /// **'Astronomical Units'**
  String get astronomicalUnits;

  /// No description provided for @lightYears.
  ///
  /// In en, this message translates to:
  /// **'Light-years'**
  String get lightYears;

  /// No description provided for @parsec.
  ///
  /// In en, this message translates to:
  /// **'Parsec'**
  String get parsec;

  /// No description provided for @mils.
  ///
  /// In en, this message translates to:
  /// **'Mils'**
  String get mils;

  /// No description provided for @feetUsSurvey.
  ///
  /// In en, this message translates to:
  /// **'Feet (US survey)'**
  String get feetUsSurvey;

  /// No description provided for @squareMeters.
  ///
  /// In en, this message translates to:
  /// **'Square Meters'**
  String get squareMeters;

  /// No description provided for @squareCentimeters.
  ///
  /// In en, this message translates to:
  /// **'Square Centimeters'**
  String get squareCentimeters;

  /// No description provided for @squareInches.
  ///
  /// In en, this message translates to:
  /// **'Square Inches'**
  String get squareInches;

  /// No description provided for @squareFeet.
  ///
  /// In en, this message translates to:
  /// **'Square Feet'**
  String get squareFeet;

  /// No description provided for @squareMiles.
  ///
  /// In en, this message translates to:
  /// **'Square Miles'**
  String get squareMiles;

  /// No description provided for @squareYard.
  ///
  /// In en, this message translates to:
  /// **'Square Yard'**
  String get squareYard;

  /// No description provided for @squareMillimeters.
  ///
  /// In en, this message translates to:
  /// **'Square Millimeters'**
  String get squareMillimeters;

  /// No description provided for @squareKilometers.
  ///
  /// In en, this message translates to:
  /// **'Square Kilometers'**
  String get squareKilometers;

  /// No description provided for @hectares.
  ///
  /// In en, this message translates to:
  /// **'Hectares'**
  String get hectares;

  /// No description provided for @acres.
  ///
  /// In en, this message translates to:
  /// **'Acres'**
  String get acres;

  /// No description provided for @are.
  ///
  /// In en, this message translates to:
  /// **'Are'**
  String get are;

  /// No description provided for @squareFeetUsSurvey.
  ///
  /// In en, this message translates to:
  /// **'Square Feet (US survey)'**
  String get squareFeetUsSurvey;

  /// No description provided for @gramsPerCubicCentimeter.
  ///
  /// In en, this message translates to:
  /// **'Grams per Cubic Centimeter'**
  String get gramsPerCubicCentimeter;

  /// No description provided for @gramsPerLiter.
  ///
  /// In en, this message translates to:
  /// **'Grams per Liter'**
  String get gramsPerLiter;

  /// No description provided for @gramsPerMilliliter.
  ///
  /// In en, this message translates to:
  /// **'Grams per Milliliter'**
  String get gramsPerMilliliter;

  /// No description provided for @gramsPerDeciliter.
  ///
  /// In en, this message translates to:
  /// **'Grams per Deciliter'**
  String get gramsPerDeciliter;

  /// No description provided for @kilogramsPerLiter.
  ///
  /// In en, this message translates to:
  /// **'Kilograms per Liter'**
  String get kilogramsPerLiter;

  /// No description provided for @kilogramsPerCubicMeter.
  ///
  /// In en, this message translates to:
  /// **'Kilograms per Cubic Meter'**
  String get kilogramsPerCubicMeter;

  /// No description provided for @milligramsPerLiter.
  ///
  /// In en, this message translates to:
  /// **'Milligrams per Liter'**
  String get milligramsPerLiter;

  /// No description provided for @milligramsPerDeciliter.
  ///
  /// In en, this message translates to:
  /// **'Milligrams per Deciliter'**
  String get milligramsPerDeciliter;

  /// No description provided for @milligramsPerMilliliter.
  ///
  /// In en, this message translates to:
  /// **'Milligrams per Milliliter'**
  String get milligramsPerMilliliter;

  /// No description provided for @milligramsPerCubicMeter.
  ///
  /// In en, this message translates to:
  /// **'Milligrams per Cubic Meter'**
  String get milligramsPerCubicMeter;

  /// No description provided for @milligramsPerCubicCentimeter.
  ///
  /// In en, this message translates to:
  /// **'Milligrams per Cubic Centimeter'**
  String get milligramsPerCubicCentimeter;

  /// No description provided for @microgramsPerLiter.
  ///
  /// In en, this message translates to:
  /// **'Micrograms per Liter'**
  String get microgramsPerLiter;

  /// No description provided for @microgramsPerDeciliter.
  ///
  /// In en, this message translates to:
  /// **'Micrograms per Deciliter'**
  String get microgramsPerDeciliter;

  /// No description provided for @microgramsPerMilliliter.
  ///
  /// In en, this message translates to:
  /// **'Micrograms per Milliliter'**
  String get microgramsPerMilliliter;

  /// No description provided for @poundsPerCubicInches.
  ///
  /// In en, this message translates to:
  /// **'Pounds per Cubic Inches'**
  String get poundsPerCubicInches;

  /// No description provided for @poundsPerCubicFeet.
  ///
  /// In en, this message translates to:
  /// **'Pounds per Cubic Feet'**
  String get poundsPerCubicFeet;

  /// No description provided for @cubicMeters.
  ///
  /// In en, this message translates to:
  /// **'Cubic Meters'**
  String get cubicMeters;

  /// No description provided for @liters.
  ///
  /// In en, this message translates to:
  /// **'Liters'**
  String get liters;

  /// No description provided for @imperialGallons.
  ///
  /// In en, this message translates to:
  /// **'Imperial gallons'**
  String get imperialGallons;

  /// No description provided for @usGallons.
  ///
  /// In en, this message translates to:
  /// **'US Gallons'**
  String get usGallons;

  /// No description provided for @imperialPints.
  ///
  /// In en, this message translates to:
  /// **'Imperial Pints'**
  String get imperialPints;

  /// No description provided for @usPints.
  ///
  /// In en, this message translates to:
  /// **'US Pints'**
  String get usPints;

  /// No description provided for @milliliters.
  ///
  /// In en, this message translates to:
  /// **'Milliliters'**
  String get milliliters;

  /// No description provided for @tablespoonUs.
  ///
  /// In en, this message translates to:
  /// **'Tablespoons US'**
  String get tablespoonUs;

  /// No description provided for @tablespoonAustralian.
  ///
  /// In en, this message translates to:
  /// **'Australian Tablespoons'**
  String get tablespoonAustralian;

  /// No description provided for @cups.
  ///
  /// In en, this message translates to:
  /// **'Cups'**
  String get cups;

  /// No description provided for @cubicCentimeters.
  ///
  /// In en, this message translates to:
  /// **'Cubic Centimeters'**
  String get cubicCentimeters;

  /// No description provided for @cubicFeet.
  ///
  /// In en, this message translates to:
  /// **'Cubic Feet'**
  String get cubicFeet;

  /// No description provided for @cubicInches.
  ///
  /// In en, this message translates to:
  /// **'Cubic Inches'**
  String get cubicInches;

  /// No description provided for @cubicMillimeters.
  ///
  /// In en, this message translates to:
  /// **'Cubic Millimeters'**
  String get cubicMillimeters;

  /// No description provided for @imperialFluidOunces.
  ///
  /// In en, this message translates to:
  /// **'Imperial Fluid Ounces'**
  String get imperialFluidOunces;

  /// No description provided for @usFluidOunces.
  ///
  /// In en, this message translates to:
  /// **'US Fluid Ounces'**
  String get usFluidOunces;

  /// No description provided for @imperialGill.
  ///
  /// In en, this message translates to:
  /// **'Imperial Gill'**
  String get imperialGill;

  /// No description provided for @usGill.
  ///
  /// In en, this message translates to:
  /// **'US Gill'**
  String get usGill;

  /// No description provided for @usQuarts.
  ///
  /// In en, this message translates to:
  /// **'US Quarts'**
  String get usQuarts;

  /// No description provided for @microliters.
  ///
  /// In en, this message translates to:
  /// **'Microliters'**
  String get microliters;

  /// No description provided for @deciliters.
  ///
  /// In en, this message translates to:
  /// **'Deciliters'**
  String get deciliters;

  /// No description provided for @centiliters.
  ///
  /// In en, this message translates to:
  /// **'Centiliters'**
  String get centiliters;

  /// No description provided for @seconds.
  ///
  /// In en, this message translates to:
  /// **'Seconds'**
  String get seconds;

  /// No description provided for @deciseconds.
  ///
  /// In en, this message translates to:
  /// **'Deciseconds'**
  String get deciseconds;

  /// No description provided for @centiseconds.
  ///
  /// In en, this message translates to:
  /// **'Centiseconds'**
  String get centiseconds;

  /// No description provided for @milliseconds.
  ///
  /// In en, this message translates to:
  /// **'Milliseconds'**
  String get milliseconds;

  /// No description provided for @microseconds.
  ///
  /// In en, this message translates to:
  /// **'Microseconds'**
  String get microseconds;

  /// No description provided for @nanoseconds.
  ///
  /// In en, this message translates to:
  /// **'Nanoseconds'**
  String get nanoseconds;

  /// No description provided for @minutes.
  ///
  /// In en, this message translates to:
  /// **'Minutes'**
  String get minutes;

  /// No description provided for @hours.
  ///
  /// In en, this message translates to:
  /// **'Hours'**
  String get hours;

  /// No description provided for @days.
  ///
  /// In en, this message translates to:
  /// **'Days'**
  String get days;

  /// No description provided for @weeks.
  ///
  /// In en, this message translates to:
  /// **'Weeks'**
  String get weeks;

  /// No description provided for @years.
  ///
  /// In en, this message translates to:
  /// **'Years (365)'**
  String get years;

  /// No description provided for @lustrum.
  ///
  /// In en, this message translates to:
  /// **'Lustrum'**
  String get lustrum;

  /// No description provided for @decades.
  ///
  /// In en, this message translates to:
  /// **'Decades'**
  String get decades;

  /// No description provided for @centuries.
  ///
  /// In en, this message translates to:
  /// **'Centuries'**
  String get centuries;

  /// No description provided for @millennium.
  ///
  /// In en, this message translates to:
  /// **'Millennium'**
  String get millennium;

  /// No description provided for @fahrenheit.
  ///
  /// In en, this message translates to:
  /// **'Fahrenheit'**
  String get fahrenheit;

  /// No description provided for @celsius.
  ///
  /// In en, this message translates to:
  /// **'Celsius (Centigrade)'**
  String get celsius;

  /// No description provided for @kelvin.
  ///
  /// In en, this message translates to:
  /// **'Kelvin'**
  String get kelvin;

  /// No description provided for @reamur.
  ///
  /// In en, this message translates to:
  /// **'Reamur'**
  String get reamur;

  /// No description provided for @romer.
  ///
  /// In en, this message translates to:
  /// **'Rømer'**
  String get romer;

  /// No description provided for @delisle.
  ///
  /// In en, this message translates to:
  /// **'Delisle'**
  String get delisle;

  /// No description provided for @rankine.
  ///
  /// In en, this message translates to:
  /// **'Rankine'**
  String get rankine;

  /// No description provided for @metersSecond.
  ///
  /// In en, this message translates to:
  /// **'Meters per Second'**
  String get metersSecond;

  /// No description provided for @kilometersHour.
  ///
  /// In en, this message translates to:
  /// **'Kilometers per Hour'**
  String get kilometersHour;

  /// No description provided for @milesHour.
  ///
  /// In en, this message translates to:
  /// **'Miles per Hour'**
  String get milesHour;

  /// No description provided for @knots.
  ///
  /// In en, this message translates to:
  /// **'Knots'**
  String get knots;

  /// No description provided for @feetSecond.
  ///
  /// In en, this message translates to:
  /// **'Feet per Second'**
  String get feetSecond;

  /// No description provided for @minutesPerKilometer.
  ///
  /// In en, this message translates to:
  /// **'Minutes per Kilometer'**
  String get minutesPerKilometer;

  /// No description provided for @grams.
  ///
  /// In en, this message translates to:
  /// **'Grams'**
  String get grams;

  /// No description provided for @ettograms.
  ///
  /// In en, this message translates to:
  /// **'Ettograms'**
  String get ettograms;

  /// No description provided for @kilograms.
  ///
  /// In en, this message translates to:
  /// **'Kilograms'**
  String get kilograms;

  /// No description provided for @pounds.
  ///
  /// In en, this message translates to:
  /// **'Pounds'**
  String get pounds;

  /// No description provided for @ounces.
  ///
  /// In en, this message translates to:
  /// **'Ounces'**
  String get ounces;

  /// No description provided for @quintals.
  ///
  /// In en, this message translates to:
  /// **'Quintals'**
  String get quintals;

  /// No description provided for @tons.
  ///
  /// In en, this message translates to:
  /// **'Tons'**
  String get tons;

  /// No description provided for @milligrams.
  ///
  /// In en, this message translates to:
  /// **'Milligrams'**
  String get milligrams;

  /// No description provided for @uma.
  ///
  /// In en, this message translates to:
  /// **'Unified atomic mass unit'**
  String get uma;

  /// No description provided for @carats.
  ///
  /// In en, this message translates to:
  /// **'Carats'**
  String get carats;

  /// No description provided for @centigrams.
  ///
  /// In en, this message translates to:
  /// **'Centigrams'**
  String get centigrams;

  /// No description provided for @pennyweights.
  ///
  /// In en, this message translates to:
  /// **'Pennyweights'**
  String get pennyweights;

  /// No description provided for @troyOunces.
  ///
  /// In en, this message translates to:
  /// **'Troy ounces'**
  String get troyOunces;

  /// No description provided for @stones.
  ///
  /// In en, this message translates to:
  /// **'Stones'**
  String get stones;

  /// No description provided for @pascal.
  ///
  /// In en, this message translates to:
  /// **'Pascal'**
  String get pascal;

  /// No description provided for @atmosphere.
  ///
  /// In en, this message translates to:
  /// **'Atmosphere'**
  String get atmosphere;

  /// No description provided for @bar.
  ///
  /// In en, this message translates to:
  /// **'Bar'**
  String get bar;

  /// No description provided for @millibar.
  ///
  /// In en, this message translates to:
  /// **'Millibar'**
  String get millibar;

  /// No description provided for @psi.
  ///
  /// In en, this message translates to:
  /// **'Pounds per square inch'**
  String get psi;

  /// No description provided for @torr.
  ///
  /// In en, this message translates to:
  /// **'Millimeter of mercury (Torr)'**
  String get torr;

  /// No description provided for @hectoPascal.
  ///
  /// In en, this message translates to:
  /// **'Hectopascal'**
  String get hectoPascal;

  /// No description provided for @inchesOfMercury.
  ///
  /// In en, this message translates to:
  /// **'Inches of mercury'**
  String get inchesOfMercury;

  /// No description provided for @kiloPascal.
  ///
  /// In en, this message translates to:
  /// **'Kilopascal'**
  String get kiloPascal;

  /// No description provided for @ksi.
  ///
  /// In en, this message translates to:
  /// **'Kilopounds per square inch'**
  String get ksi;

  /// No description provided for @megaPascal.
  ///
  /// In en, this message translates to:
  /// **'Megapascal'**
  String get megaPascal;

  /// No description provided for @gigaPascal.
  ///
  /// In en, this message translates to:
  /// **'Gigapascal'**
  String get gigaPascal;

  /// No description provided for @joule.
  ///
  /// In en, this message translates to:
  /// **'Joule'**
  String get joule;

  /// No description provided for @calories.
  ///
  /// In en, this message translates to:
  /// **'Calories'**
  String get calories;

  /// No description provided for @kilowattHour.
  ///
  /// In en, this message translates to:
  /// **'Kilowatt hour'**
  String get kilowattHour;

  /// No description provided for @electronvolt.
  ///
  /// In en, this message translates to:
  /// **'Electron volt'**
  String get electronvolt;

  /// No description provided for @footPound.
  ///
  /// In en, this message translates to:
  /// **'Foot pound'**
  String get footPound;

  /// No description provided for @kilocalories.
  ///
  /// In en, this message translates to:
  /// **'Kilocalories'**
  String get kilocalories;

  /// No description provided for @kilojoules.
  ///
  /// In en, this message translates to:
  /// **'Kilojoules'**
  String get kilojoules;

  /// No description provided for @degree.
  ///
  /// In en, this message translates to:
  /// **'Degree'**
  String get degree;

  /// No description provided for @minutesDegree.
  ///
  /// In en, this message translates to:
  /// **'Minutes'**
  String get minutesDegree;

  /// No description provided for @secondsDegree.
  ///
  /// In en, this message translates to:
  /// **'Seconds'**
  String get secondsDegree;

  /// No description provided for @radiansDegree.
  ///
  /// In en, this message translates to:
  /// **'Radians'**
  String get radiansDegree;

  /// No description provided for @usd.
  ///
  /// In en, this message translates to:
  /// **'US Dollar'**
  String get usd;

  /// No description provided for @eur.
  ///
  /// In en, this message translates to:
  /// **'Euro'**
  String get eur;

  /// No description provided for @gbp.
  ///
  /// In en, this message translates to:
  /// **'British Pound'**
  String get gbp;

  /// No description provided for @inr.
  ///
  /// In en, this message translates to:
  /// **'Indian Rupee'**
  String get inr;

  /// No description provided for @cny.
  ///
  /// In en, this message translates to:
  /// **'Chinese Yuan'**
  String get cny;

  /// No description provided for @jpy.
  ///
  /// In en, this message translates to:
  /// **'Japanese Yen'**
  String get jpy;

  /// No description provided for @chf.
  ///
  /// In en, this message translates to:
  /// **'Swiss Franc'**
  String get chf;

  /// No description provided for @sek.
  ///
  /// In en, this message translates to:
  /// **'Swedish Krona'**
  String get sek;

  /// No description provided for @rub.
  ///
  /// In en, this message translates to:
  /// **'Russian Ruble'**
  String get rub;

  /// No description provided for @cad.
  ///
  /// In en, this message translates to:
  /// **'Canadian Dollar'**
  String get cad;

  /// No description provided for @krw.
  ///
  /// In en, this message translates to:
  /// **'South Korean Won'**
  String get krw;

  /// No description provided for @brl.
  ///
  /// In en, this message translates to:
  /// **'Brazilian Real'**
  String get brl;

  /// No description provided for @hkd.
  ///
  /// In en, this message translates to:
  /// **'Hong Kong Dollar'**
  String get hkd;

  /// No description provided for @aud.
  ///
  /// In en, this message translates to:
  /// **'Australian Dollar'**
  String get aud;

  /// No description provided for @nzd.
  ///
  /// In en, this message translates to:
  /// **'New Zealand Dollar'**
  String get nzd;

  /// No description provided for @mxn.
  ///
  /// In en, this message translates to:
  /// **'Mexican Peso'**
  String get mxn;

  /// No description provided for @sgd.
  ///
  /// In en, this message translates to:
  /// **'Singapore Dollar'**
  String get sgd;

  /// No description provided for @nok.
  ///
  /// In en, this message translates to:
  /// **'Norwegian Krone'**
  String get nok;

  /// No description provided for @trY.
  ///
  /// In en, this message translates to:
  /// **'Turkish Lira'**
  String get trY;

  /// No description provided for @zar.
  ///
  /// In en, this message translates to:
  /// **'South African Rand'**
  String get zar;

  /// No description provided for @dkk.
  ///
  /// In en, this message translates to:
  /// **'Danish Krone'**
  String get dkk;

  /// No description provided for @pln.
  ///
  /// In en, this message translates to:
  /// **'Polish Złoty'**
  String get pln;

  /// No description provided for @thb.
  ///
  /// In en, this message translates to:
  /// **'Thai Baht'**
  String get thb;

  /// No description provided for @myr.
  ///
  /// In en, this message translates to:
  /// **'Malaysian Ringgit'**
  String get myr;

  /// No description provided for @huf.
  ///
  /// In en, this message translates to:
  /// **'Hungarian Forint'**
  String get huf;

  /// No description provided for @czk.
  ///
  /// In en, this message translates to:
  /// **'Czech Koruna'**
  String get czk;

  /// No description provided for @ils.
  ///
  /// In en, this message translates to:
  /// **'Israeli Shekel'**
  String get ils;

  /// No description provided for @idr.
  ///
  /// In en, this message translates to:
  /// **'Indonesian Rupiah'**
  String get idr;

  /// No description provided for @php.
  ///
  /// In en, this message translates to:
  /// **'Philippine Peso'**
  String get php;

  /// No description provided for @ron.
  ///
  /// In en, this message translates to:
  /// **'Romanian Leu'**
  String get ron;

  /// No description provided for @bgn.
  ///
  /// In en, this message translates to:
  /// **'Bulgarian Lev'**
  String get bgn;

  /// No description provided for @isk.
  ///
  /// In en, this message translates to:
  /// **'Icelandic Króna'**
  String get isk;

  /// No description provided for @twd.
  ///
  /// In en, this message translates to:
  /// **'New Taiwan Dollar'**
  String get twd;

  /// No description provided for @mad.
  ///
  /// In en, this message translates to:
  /// **'Moroccan Dirham'**
  String get mad;

  /// No description provided for @euChina.
  ///
  /// In en, this message translates to:
  /// **'EU & China'**
  String get euChina;

  /// No description provided for @ukIndiaChild.
  ///
  /// In en, this message translates to:
  /// **'UK & India - Child'**
  String get ukIndiaChild;

  /// No description provided for @ukIndiaMan.
  ///
  /// In en, this message translates to:
  /// **'UK & India - Man'**
  String get ukIndiaMan;

  /// No description provided for @ukIndiaWoman.
  ///
  /// In en, this message translates to:
  /// **'UK & India - Woman'**
  String get ukIndiaWoman;

  /// No description provided for @usaCanadaChild.
  ///
  /// In en, this message translates to:
  /// **'USA & Canada - Child'**
  String get usaCanadaChild;

  /// No description provided for @usaCanadaMan.
  ///
  /// In en, this message translates to:
  /// **'USA & Canada - Man'**
  String get usaCanadaMan;

  /// No description provided for @usaCanadaWoman.
  ///
  /// In en, this message translates to:
  /// **'USA & Canada - Woman'**
  String get usaCanadaWoman;

  /// No description provided for @japan.
  ///
  /// In en, this message translates to:
  /// **'Japan'**
  String get japan;

  /// No description provided for @watt.
  ///
  /// In en, this message translates to:
  /// **'Watt'**
  String get watt;

  /// No description provided for @milliwatt.
  ///
  /// In en, this message translates to:
  /// **'Milliwatt'**
  String get milliwatt;

  /// No description provided for @kilowatt.
  ///
  /// In en, this message translates to:
  /// **'Kilowatt'**
  String get kilowatt;

  /// No description provided for @megawatt.
  ///
  /// In en, this message translates to:
  /// **'Megawatt'**
  String get megawatt;

  /// No description provided for @gigawatt.
  ///
  /// In en, this message translates to:
  /// **'GigaWatt'**
  String get gigawatt;

  /// No description provided for @europeanHorsePower.
  ///
  /// In en, this message translates to:
  /// **'European horsepower'**
  String get europeanHorsePower;

  /// No description provided for @imperialHorsePower.
  ///
  /// In en, this message translates to:
  /// **'Imperial horsepower'**
  String get imperialHorsePower;

  /// No description provided for @newton.
  ///
  /// In en, this message translates to:
  /// **'Newton'**
  String get newton;

  /// No description provided for @dyne.
  ///
  /// In en, this message translates to:
  /// **'Dyne'**
  String get dyne;

  /// No description provided for @poundForce.
  ///
  /// In en, this message translates to:
  /// **'Pound-force'**
  String get poundForce;

  /// No description provided for @kilogramForce.
  ///
  /// In en, this message translates to:
  /// **'Kilogram-force'**
  String get kilogramForce;

  /// No description provided for @poundal.
  ///
  /// In en, this message translates to:
  /// **'Poundal'**
  String get poundal;

  /// No description provided for @newtonMeter.
  ///
  /// In en, this message translates to:
  /// **'Newton meter'**
  String get newtonMeter;

  /// No description provided for @dyneMeter.
  ///
  /// In en, this message translates to:
  /// **'Dyne meter'**
  String get dyneMeter;

  /// No description provided for @poundForceFeet.
  ///
  /// In en, this message translates to:
  /// **'Pound-force feet'**
  String get poundForceFeet;

  /// No description provided for @kilogramForceMeter.
  ///
  /// In en, this message translates to:
  /// **'Kilogram-force meter'**
  String get kilogramForceMeter;

  /// No description provided for @poundalMeter.
  ///
  /// In en, this message translates to:
  /// **'Poundal meter'**
  String get poundalMeter;

  /// No description provided for @kilometersLiter.
  ///
  /// In en, this message translates to:
  /// **'Kilometers per liter'**
  String get kilometersLiter;

  /// No description provided for @liters100km.
  ///
  /// In en, this message translates to:
  /// **'Liters per 100 km'**
  String get liters100km;

  /// No description provided for @milesUsGallon.
  ///
  /// In en, this message translates to:
  /// **'Miles per US Gallon'**
  String get milesUsGallon;

  /// No description provided for @milesImperialGallon.
  ///
  /// In en, this message translates to:
  /// **'Miles per imperial Gallon'**
  String get milesImperialGallon;

  /// No description provided for @decimal.
  ///
  /// In en, this message translates to:
  /// **'Decimal'**
  String get decimal;

  /// No description provided for @hexadecimal.
  ///
  /// In en, this message translates to:
  /// **'Hexadecimal'**
  String get hexadecimal;

  /// No description provided for @octal.
  ///
  /// In en, this message translates to:
  /// **'Octal'**
  String get octal;

  /// No description provided for @binary.
  ///
  /// In en, this message translates to:
  /// **'Binary'**
  String get binary;

  /// No description provided for @bit.
  ///
  /// In en, this message translates to:
  /// **'Bit'**
  String get bit;

  /// No description provided for @nibble.
  ///
  /// In en, this message translates to:
  /// **'Nibble'**
  String get nibble;

  /// No description provided for @kilobit.
  ///
  /// In en, this message translates to:
  /// **'KiloBit'**
  String get kilobit;

  /// No description provided for @megabit.
  ///
  /// In en, this message translates to:
  /// **'MegaBit'**
  String get megabit;

  /// No description provided for @gigabit.
  ///
  /// In en, this message translates to:
  /// **'GigaBit'**
  String get gigabit;

  /// No description provided for @terabit.
  ///
  /// In en, this message translates to:
  /// **'TeraBit'**
  String get terabit;

  /// No description provided for @petabit.
  ///
  /// In en, this message translates to:
  /// **'PetaBit'**
  String get petabit;

  /// No description provided for @exabit.
  ///
  /// In en, this message translates to:
  /// **'ExaBit'**
  String get exabit;

  /// No description provided for @kibibit.
  ///
  /// In en, this message translates to:
  /// **'Kibibit'**
  String get kibibit;

  /// No description provided for @mebibit.
  ///
  /// In en, this message translates to:
  /// **'Mebibit'**
  String get mebibit;

  /// No description provided for @gibibit.
  ///
  /// In en, this message translates to:
  /// **'GibiBit'**
  String get gibibit;

  /// No description provided for @tebibit.
  ///
  /// In en, this message translates to:
  /// **'Tebibit'**
  String get tebibit;

  /// No description provided for @pebibit.
  ///
  /// In en, this message translates to:
  /// **'Pebibit'**
  String get pebibit;

  /// No description provided for @exbibit.
  ///
  /// In en, this message translates to:
  /// **'Exbibit'**
  String get exbibit;

  /// No description provided for @byte.
  ///
  /// In en, this message translates to:
  /// **'Byte'**
  String get byte;

  /// No description provided for @kilobyte.
  ///
  /// In en, this message translates to:
  /// **'KiloByte'**
  String get kilobyte;

  /// No description provided for @megabyte.
  ///
  /// In en, this message translates to:
  /// **'MegaByte'**
  String get megabyte;

  /// No description provided for @gigabyte.
  ///
  /// In en, this message translates to:
  /// **'GigaByte'**
  String get gigabyte;

  /// No description provided for @terabyte.
  ///
  /// In en, this message translates to:
  /// **'TeraByte'**
  String get terabyte;

  /// No description provided for @petabyte.
  ///
  /// In en, this message translates to:
  /// **'PetaByte'**
  String get petabyte;

  /// No description provided for @exabyte.
  ///
  /// In en, this message translates to:
  /// **'ExaByte'**
  String get exabyte;

  /// No description provided for @kibibyte.
  ///
  /// In en, this message translates to:
  /// **'Kibibyte'**
  String get kibibyte;

  /// No description provided for @mebibyte.
  ///
  /// In en, this message translates to:
  /// **'Mebibyte'**
  String get mebibyte;

  /// No description provided for @gibibyte.
  ///
  /// In en, this message translates to:
  /// **'GibiByte'**
  String get gibibyte;

  /// No description provided for @tebibyte.
  ///
  /// In en, this message translates to:
  /// **'Tebibyte'**
  String get tebibyte;

  /// No description provided for @pebibyte.
  ///
  /// In en, this message translates to:
  /// **'Pebibyte'**
  String get pebibyte;

  /// No description provided for @exbibyte.
  ///
  /// In en, this message translates to:
  /// **'Exbibyte'**
  String get exbibyte;

  /// No description provided for @base.
  ///
  /// In en, this message translates to:
  /// **'Base'**
  String get base;

  /// No description provided for @deca.
  ///
  /// In en, this message translates to:
  /// **'Deca-'**
  String get deca;

  /// No description provided for @hecto.
  ///
  /// In en, this message translates to:
  /// **'Hecto-'**
  String get hecto;

  /// No description provided for @kilo.
  ///
  /// In en, this message translates to:
  /// **'Kilo-'**
  String get kilo;

  /// No description provided for @mega.
  ///
  /// In en, this message translates to:
  /// **'Mega-'**
  String get mega;

  /// No description provided for @giga.
  ///
  /// In en, this message translates to:
  /// **'Giga-'**
  String get giga;

  /// No description provided for @tera.
  ///
  /// In en, this message translates to:
  /// **'Tera-'**
  String get tera;

  /// No description provided for @peta.
  ///
  /// In en, this message translates to:
  /// **'Peta-'**
  String get peta;

  /// No description provided for @exa.
  ///
  /// In en, this message translates to:
  /// **'Exa-'**
  String get exa;

  /// No description provided for @zetta.
  ///
  /// In en, this message translates to:
  /// **'Zetta-'**
  String get zetta;

  /// No description provided for @yotta.
  ///
  /// In en, this message translates to:
  /// **'Yotta-'**
  String get yotta;

  /// No description provided for @deci.
  ///
  /// In en, this message translates to:
  /// **'Deci-'**
  String get deci;

  /// No description provided for @centi.
  ///
  /// In en, this message translates to:
  /// **'Centi-'**
  String get centi;

  /// No description provided for @milli.
  ///
  /// In en, this message translates to:
  /// **'Milli-'**
  String get milli;

  /// No description provided for @micro.
  ///
  /// In en, this message translates to:
  /// **'Micro-'**
  String get micro;

  /// No description provided for @nano.
  ///
  /// In en, this message translates to:
  /// **'Nano-'**
  String get nano;

  /// No description provided for @pico.
  ///
  /// In en, this message translates to:
  /// **'Pico-'**
  String get pico;

  /// No description provided for @femto.
  ///
  /// In en, this message translates to:
  /// **'Femto-'**
  String get femto;

  /// No description provided for @atto.
  ///
  /// In en, this message translates to:
  /// **'Atto-'**
  String get atto;

  /// No description provided for @zepto.
  ///
  /// In en, this message translates to:
  /// **'Zepto-'**
  String get zepto;

  /// No description provided for @yocto.
  ///
  /// In en, this message translates to:
  /// **'Yocto-'**
  String get yocto;
}

class _AppLocalizationsDelegate
    extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>[
    'ar',
    'bn',
    'ca',
    'de',
    'el',
    'en',
    'es',
    'fr',
    'hr',
    'id',
    'it',
    'ja',
    'nb',
    'nl',
    'pl',
    'pt',
    'ru',
    'tr',
    'zh',
  ].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when language+country codes are specified.
  switch (locale.languageCode) {
    case 'zh':
      {
        switch (locale.countryCode) {
          case 'TW':
            return AppLocalizationsZhTw();
        }
        break;
      }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'ar':
      return AppLocalizationsAr();
    case 'bn':
      return AppLocalizationsBn();
    case 'ca':
      return AppLocalizationsCa();
    case 'de':
      return AppLocalizationsDe();
    case 'el':
      return AppLocalizationsEl();
    case 'en':
      return AppLocalizationsEn();
    case 'es':
      return AppLocalizationsEs();
    case 'fr':
      return AppLocalizationsFr();
    case 'hr':
      return AppLocalizationsHr();
    case 'id':
      return AppLocalizationsId();
    case 'it':
      return AppLocalizationsIt();
    case 'ja':
      return AppLocalizationsJa();
    case 'nb':
      return AppLocalizationsNb();
    case 'nl':
      return AppLocalizationsNl();
    case 'pl':
      return AppLocalizationsPl();
    case 'pt':
      return AppLocalizationsPt();
    case 'ru':
      return AppLocalizationsRu();
    case 'tr':
      return AppLocalizationsTr();
    case 'zh':
      return AppLocalizationsZh();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.',
  );
}
