# Welcome

We invite you to join our team! Everyone is welcome to contribute by submitting
code, pull requests, or reporting issues on GitHub. There are many ways to get
involved, and you don't need to be an expert to make a difference. Think you're
not ready to contribute? Let us show you otherwise! Let's get started!

## Translating the app

The app is currently translated into several languages, but if you know another
language and would like to help with further internationalization, please check
out the latest instructions
[here](https://github.com/ferraridamiano/ConverterNOW/wiki/Translations). You
can also contribute by translating the Play Store/F-Droid app page, which can
be found
[here](https://github.com/ferraridamiano/ConverterNOW/tree/master/fastlane/metadata/android/en-US).
If you have any questions, feel free to contact me via email or open a new
issue. I'll handle the rest. Thank you for your support!

## Design a new logo

If you think you can create a better app icon, feel free to open a new issue or
pull request with your proposal. I’ll guide you on how to integrate your idea
into the project. Thank you!

## Submit a PR

If you're confident with Flutter coding, you can help improve the app by submitting a pull request. But first, let me explain how the project is organized.

### Project structure

The project uses [riverpod](https://github.com/rrousselGit/riverpod) for state
management, with providers located in
[`lib/models`](https://github.com/ferraridamiano/ConverterNOW/tree/master/lib/models).
The app is structured as a monorepo and managed with
[`melos`](https://github.com/invertase/melos).

### Add new units

If you want to add new units I wrote a
[wiki page](https://github.com/ferraridamiano/ConverterNOW/wiki/Add-a-new-unit-of-measurement),
it is a step by step guide.

## Donations

This project is a labor of love, managed by a single person. Your
[donations](https://www.paypal.com/paypalme/DemApps) are invaluable — they help
keep the development going and provide the motivation to continue improving the
app. Every contribution, big or small, makes a difference. If you enjoy using
the app and believe in its future, please consider supporting the project.
Thank you!
