// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get appName => 'Converter NOW';

  @override
  String get reorder => '排序';

  @override
  String get myOrdering => '我的排序';

  @override
  String get contactDeveloper => '联系开发者';

  @override
  String get about => '关于此程序';

  @override
  String get lastCurrenciesUpdate => '最终更新：';

  @override
  String get today => '今天';

  @override
  String get enableDarkTheme => '打开夜间模式';

  @override
  String get settings => '设置';

  @override
  String get menu => '菜单';

  @override
  String get donation => '捐赠';

  @override
  String get buyMeACoffee => '给开发者买一杯咖啡';

  @override
  String get donationDialog =>
      '你好！有可能你知道，这个程序开源且免费。这意味着你可以免费使用此软件，复制和编辑源代码。而开发者得不到任何利益。如果你赞同此项目，或者想看到一些新功能，请考虑给我买一杯咖啡。';

  @override
  String get drawerLogo => 'Drawer logo';

  @override
  String get rateApp => '评价此程序';

  @override
  String get repoGithub => '打开GitHub仓库';

  @override
  String get contributeTranslating => '参加此程序的翻译';

  @override
  String get search => '搜索';

  @override
  String get clearAll => '全部删除';

  @override
  String get calculator => '计算器';

  @override
  String get significantFigures => '有效数字';

  @override
  String get removeTrailingZeros => '删除末尾的0';

  @override
  String get longPressAdvice => '长按以移动';

  @override
  String get back => '返回';

  @override
  String get save => '保存';

  @override
  String get invalidCharacters => '错误，无效的文字';

  @override
  String get theme => '主题';

  @override
  String get dark => '深色';

  @override
  String get light => '浅色';

  @override
  String get system => '系统设置';

  @override
  String get pureBlackTheme => 'AMOLED黑暗模式';

  @override
  String get copy => '复制';

  @override
  String get more => '更多';

  @override
  String get language => '语言';

  @override
  String get reorderProperties => '排序组';

  @override
  String get reorderUnits => '排序项目';

  @override
  String get chooseProperty => '请选择组';

  @override
  String reorderProperty(String property) {
    return '排序$property';
  }

  @override
  String get otherPlatforms => '在其他平台上使用此程序';

  @override
  String get sourceCode => '源代码';

  @override
  String get undoClearAllMessage => '已全部清除。 你想撤消它吗？';

  @override
  String get undo => '撤消';

  @override
  String get routeError1 => '不存在此页面';

  @override
  String get routeError2 => '返回上一级';

  @override
  String get ok => 'OK';

  @override
  String get revokeInternetAccess => '禁用网络连接';

  @override
  String get revokeInternetExplanation =>
      '该应用在每次启动时通过网络更新汇率。所需下载的数据只有几 kiB。不过，您若不需此功能，启用该选项可阻止该应用连接互联网。';

  @override
  String get useDeviceColor => '使用系统设置的强调色';

  @override
  String get pickColor => '选择颜色';

  @override
  String get themeColor => '主题色';

  @override
  String get appearance => '外观';

  @override
  String get conversions => '转换';

  @override
  String get findOutMore => '更多';

  @override
  String get hideUnits => 'Hide units';

  @override
  String visibleUnits(String property) {
    return '$property, visible units';
  }

  @override
  String get hiddenUnits => 'Hidden units';

  @override
  String get selectAll => 'Select all';

  @override
  String get unselectAll => 'Unselect all';

  @override
  String get length => '长度';

  @override
  String get area => '面积';

  @override
  String get volume => '体积';

  @override
  String get time => '时间';

  @override
  String get temperature => '温度';

  @override
  String get speed => '速度';

  @override
  String get siPrefixes => '国际单位前缀';

  @override
  String get mass => '质量';

  @override
  String get pressure => '压强';

  @override
  String get energy => '能量';

  @override
  String get angles => '角度';

  @override
  String get currencies => '货币';

  @override
  String get shoeSize => '鞋子尺寸';

  @override
  String get digitalData => '电子数据';

  @override
  String get power => '功率';

  @override
  String get density => 'Density';

  @override
  String get torque => '力矩';

  @override
  String get force => '力';

  @override
  String get fuelConsumption => '燃费';

  @override
  String get numeralSystems => '数制';

  @override
  String get meters => '米';

  @override
  String get centimeters => '厘米';

  @override
  String get inches => '英寸';

  @override
  String get feet => '英尺';

  @override
  String get nauticalMiles => '海里';

  @override
  String get yards => '码数';

  @override
  String get miles => '英里';

  @override
  String get millimeters => '毫米';

  @override
  String get micrometers => '微米';

  @override
  String get nanometers => '纳米';

  @override
  String get angstroms => '埃米';

  @override
  String get picometers => '皮米';

  @override
  String get kilometers => '公里';

  @override
  String get astronomicalUnits => '天文单位';

  @override
  String get lightYears => '光年';

  @override
  String get parsec => '秒差距';

  @override
  String get mils => 'Mils';

  @override
  String get feetUsSurvey => '英尺(美国)';

  @override
  String get squareMeters => '平方米';

  @override
  String get squareCentimeters => '平方厘米';

  @override
  String get squareInches => '平方英寸';

  @override
  String get squareFeet => '平方英尺';

  @override
  String get squareMiles => '平方英里';

  @override
  String get squareYard => '平方码';

  @override
  String get squareMillimeters => '平方毫米';

  @override
  String get squareKilometers => '平方公里';

  @override
  String get hectares => '公顷';

  @override
  String get acres => '英亩';

  @override
  String get are => '公亩';

  @override
  String get squareFeetUsSurvey => '平方英尺(美国)';

  @override
  String get gramsPerCubicCentimeter => 'Grams per Cubic Centimeter';

  @override
  String get gramsPerLiter => 'Grams per Liter';

  @override
  String get gramsPerMilliliter => 'Grams per Milliliter';

  @override
  String get gramsPerDeciliter => 'Grams per Deciliter';

  @override
  String get kilogramsPerLiter => 'Kilograms per Liter';

  @override
  String get kilogramsPerCubicMeter => 'Kilograms per Cubic Meter';

  @override
  String get milligramsPerLiter => 'Milligrams per Liter';

  @override
  String get milligramsPerDeciliter => 'Milligrams per Deciliter';

  @override
  String get milligramsPerMilliliter => 'Milligrams per Milliliter';

  @override
  String get milligramsPerCubicMeter => 'Milligrams per Cubic Meter';

  @override
  String get milligramsPerCubicCentimeter => 'Milligrams per Cubic Centimeter';

  @override
  String get microgramsPerLiter => 'Micrograms per Liter';

  @override
  String get microgramsPerDeciliter => 'Micrograms per Deciliter';

  @override
  String get microgramsPerMilliliter => 'Micrograms per Milliliter';

  @override
  String get poundsPerCubicInches => 'Pounds per Cubic Inches';

  @override
  String get poundsPerCubicFeet => 'Pounds per Cubic Feet';

  @override
  String get cubicMeters => '立方米';

  @override
  String get liters => '公升';

  @override
  String get imperialGallons => '英制加仑';

  @override
  String get usGallons => '美制加仑';

  @override
  String get imperialPints => '英制品脱';

  @override
  String get usPints => '美制品脱';

  @override
  String get milliliters => '毫升';

  @override
  String get tablespoonUs => '一汤匙(美国)';

  @override
  String get tablespoonAustralian => '一汤匙(澳洲)';

  @override
  String get cups => '杯';

  @override
  String get cubicCentimeters => '立方厘米';

  @override
  String get cubicFeet => '立方英尺';

  @override
  String get cubicInches => '立方英寸';

  @override
  String get cubicMillimeters => '立方毫米';

  @override
  String get imperialFluidOunces => '英液盎司';

  @override
  String get usFluidOunces => '美液盎司';

  @override
  String get imperialGill => '英制及耳';

  @override
  String get usGill => '美制及耳';

  @override
  String get usQuarts => 'US Quarts';

  @override
  String get microliters => 'Microliters';

  @override
  String get deciliters => 'Deciliters';

  @override
  String get centiliters => 'Centiliters';

  @override
  String get seconds => '秒';

  @override
  String get deciseconds => '分秒';

  @override
  String get centiseconds => '厘秒';

  @override
  String get milliseconds => '毫秒';

  @override
  String get microseconds => '微秒';

  @override
  String get nanoseconds => '纳秒';

  @override
  String get minutes => '分';

  @override
  String get hours => '小时';

  @override
  String get days => '日';

  @override
  String get weeks => '周';

  @override
  String get years => '年 (365)';

  @override
  String get lustrum => '五年纪';

  @override
  String get decades => '十年纪';

  @override
  String get centuries => '世纪';

  @override
  String get millennium => '千年纪';

  @override
  String get fahrenheit => '华氏度';

  @override
  String get celsius => '摄氏度';

  @override
  String get kelvin => '开尔文';

  @override
  String get reamur => '列氏度';

  @override
  String get romer => '罗氏温标';

  @override
  String get delisle => '德利尔温标';

  @override
  String get rankine => '兰金温标';

  @override
  String get metersSecond => '米/秒';

  @override
  String get kilometersHour => '公里/小时';

  @override
  String get milesHour => '英里/小时';

  @override
  String get knots => '节(海里/小时)';

  @override
  String get feetSecond => '英尺/秒';

  @override
  String get minutesPerKilometer => '公里/分';

  @override
  String get grams => '克';

  @override
  String get ettograms => '百克';

  @override
  String get kilograms => '千克';

  @override
  String get pounds => '磅';

  @override
  String get ounces => '盎司';

  @override
  String get quintals => '公担';

  @override
  String get tons => '吨';

  @override
  String get milligrams => '毫克';

  @override
  String get uma => '原子质量单位';

  @override
  String get carats => '克拉';

  @override
  String get centigrams => '厘克';

  @override
  String get pennyweights => '英钱';

  @override
  String get troyOunces => '金衡盎司';

  @override
  String get stones => '英石';

  @override
  String get pascal => '帕斯卡';

  @override
  String get atmosphere => '标准大气压';

  @override
  String get bar => '巴';

  @override
  String get millibar => '毫巴';

  @override
  String get psi => '磅/平方英寸';

  @override
  String get torr => '托';

  @override
  String get hectoPascal => '百帕';

  @override
  String get inchesOfMercury => '英寸汞柱';

  @override
  String get kiloPascal => 'Kilopascal';

  @override
  String get ksi => 'Kilopounds per square inch';

  @override
  String get megaPascal => 'Megapascal';

  @override
  String get gigaPascal => 'Gigapascal';

  @override
  String get joule => '焦耳';

  @override
  String get calories => '卡';

  @override
  String get kilowattHour => '千瓦时';

  @override
  String get electronvolt => '电子伏特';

  @override
  String get footPound => '英尺磅';

  @override
  String get kilocalories => '大卡';

  @override
  String get kilojoules => 'Kilojoules';

  @override
  String get degree => '度';

  @override
  String get minutesDegree => '分';

  @override
  String get secondsDegree => '秒';

  @override
  String get radiansDegree => '弧度';

  @override
  String get usd => '美元';

  @override
  String get eur => '欧元';

  @override
  String get gbp => '英镑';

  @override
  String get inr => '印度卢比';

  @override
  String get cny => '人民币';

  @override
  String get jpy => '日元';

  @override
  String get chf => '瑞士法郎';

  @override
  String get sek => '瑞典克朗';

  @override
  String get rub => '俄罗斯卢布';

  @override
  String get cad => '加元';

  @override
  String get krw => '韩元';

  @override
  String get brl => '巴西雷亚尔';

  @override
  String get hkd => '港元';

  @override
  String get aud => '澳元';

  @override
  String get nzd => '新西兰元';

  @override
  String get mxn => '墨西哥比索';

  @override
  String get sgd => '新加坡元';

  @override
  String get nok => '挪威克朗';

  @override
  String get trY => '土耳其里拉';

  @override
  String get zar => '南非兰特';

  @override
  String get dkk => '丹麦克朗';

  @override
  String get pln => '波兰兹罗提';

  @override
  String get thb => '泰铢';

  @override
  String get myr => '马来西亚林吉特';

  @override
  String get huf => '匈牙利福林';

  @override
  String get czk => '捷克克朗';

  @override
  String get ils => '以色列新锡克尔';

  @override
  String get idr => '印尼卢比';

  @override
  String get php => '菲律宾比索';

  @override
  String get ron => '罗马尼亚列伊';

  @override
  String get bgn => '保加利亚列弗';

  @override
  String get isk => '冰岛克朗';

  @override
  String get twd => '新台币';

  @override
  String get mad => '摩洛哥道拉姆';

  @override
  String get euChina => '欧盟 & 中国';

  @override
  String get ukIndiaChild => '英国 & 印度 - 小孩';

  @override
  String get ukIndiaMan => '英国 & 印度 - 男性';

  @override
  String get ukIndiaWoman => '英国 & 印度 - 女性';

  @override
  String get usaCanadaChild => '美国 & 加拿大 - 小孩';

  @override
  String get usaCanadaMan => '美国 & 加拿大 - 男性';

  @override
  String get usaCanadaWoman => '美国 & 加拿大 - 女性';

  @override
  String get japan => '日本';

  @override
  String get watt => '瓦特';

  @override
  String get milliwatt => '毫瓦';

  @override
  String get kilowatt => '千瓦';

  @override
  String get megawatt => '兆瓦';

  @override
  String get gigawatt => '千兆瓦';

  @override
  String get europeanHorsePower => '公制马力';

  @override
  String get imperialHorsePower => '英制马力';

  @override
  String get newton => '牛顿';

  @override
  String get dyne => '达因';

  @override
  String get poundForce => '磅力';

  @override
  String get kilogramForce => '千克力';

  @override
  String get poundal => '磅达';

  @override
  String get newtonMeter => '牛顿米';

  @override
  String get dyneMeter => '达因计';

  @override
  String get poundForceFeet => '磅力英尺';

  @override
  String get kilogramForceMeter => '千克力米';

  @override
  String get poundalMeter => '磅达米';

  @override
  String get kilometersLiter => '公里/升';

  @override
  String get liters100km => '百公里/升';

  @override
  String get milesUsGallon => '英里/美制加仑';

  @override
  String get milesImperialGallon => '英里/英制加仑';

  @override
  String get decimal => '十进制';

  @override
  String get hexadecimal => '十六进制';

  @override
  String get octal => '八进制';

  @override
  String get binary => '二进制';

  @override
  String get bit => '比特';

  @override
  String get nibble => '半字节';

  @override
  String get kilobit => '千比特';

  @override
  String get megabit => '兆比特';

  @override
  String get gigabit => '吉比特';

  @override
  String get terabit => '太比特';

  @override
  String get petabit => '拍比特';

  @override
  String get exabit => '艾比特';

  @override
  String get kibibit => '千比特（二进）';

  @override
  String get mebibit => '兆比特（二进）';

  @override
  String get gibibit => '吉比特（二进）';

  @override
  String get tebibit => '太比特（二进）';

  @override
  String get pebibit => '拍比特（二进）';

  @override
  String get exbibit => '艾比特（二进）';

  @override
  String get byte => '字节';

  @override
  String get kilobyte => '千字节';

  @override
  String get megabyte => '兆字节';

  @override
  String get gigabyte => '吉字节';

  @override
  String get terabyte => '太字节';

  @override
  String get petabyte => '拍字节';

  @override
  String get exabyte => '艾字节';

  @override
  String get kibibyte => '千字节（二进）';

  @override
  String get mebibyte => '兆字节（二进）';

  @override
  String get gibibyte => '吉字节（二进）';

  @override
  String get tebibyte => '太字节（二进）';

  @override
  String get pebibyte => '拍字节（二进）';

  @override
  String get exbibyte => '艾字节（二进）';

  @override
  String get base => '基数';

  @override
  String get deca => '十-';

  @override
  String get hecto => '百-';

  @override
  String get kilo => '千-';

  @override
  String get mega => '兆-';

  @override
  String get giga => '吉-';

  @override
  String get tera => '太-';

  @override
  String get peta => '拍-';

  @override
  String get exa => '艾-';

  @override
  String get zetta => '泽-';

  @override
  String get yotta => '尧-';

  @override
  String get deci => '分-';

  @override
  String get centi => '厘-';

  @override
  String get milli => '毫-';

  @override
  String get micro => '微-';

  @override
  String get nano => '纳-';

  @override
  String get pico => '皮-';

  @override
  String get femto => '飞-';

  @override
  String get atto => '阿托-';

  @override
  String get zepto => '仄普托-';

  @override
  String get yocto => '幺科托-';
}

/// The translations for Chinese, as used in Taiwan (`zh_TW`).
class AppLocalizationsZhTw extends AppLocalizationsZh {
  AppLocalizationsZhTw() : super('zh_TW');

  @override
  String get appName => 'Converter NOW';

  @override
  String get reorder => '排序';

  @override
  String get myOrdering => '我的排序';

  @override
  String get contactDeveloper => '聯絡開發者';

  @override
  String get about => '關於';

  @override
  String get lastCurrenciesUpdate => '最後更新：';

  @override
  String get today => '今日';

  @override
  String get enableDarkTheme => '啟用深色主題';

  @override
  String get settings => '設定';

  @override
  String get menu => '選單';

  @override
  String get donation => '捐贈';

  @override
  String get buyMeACoffee => '給我買一杯咖啡';

  @override
  String get donationDialog =>
      '嗨！您也許知道此應用程式是免費與開放原始碼的。這意味著您可以免費使用它與複製、編輯原始碼。開發者並不會因此獲得任何利益。但假如您認同此專案，或者想要看到新功能，請考慮給我買一杯咖啡。';

  @override
  String get drawerLogo => '抽屜標誌';

  @override
  String get rateApp => '為此應用程式評分';

  @override
  String get repoGithub => '在 GitHub 開啟儲存庫';

  @override
  String get contributeTranslating => '為此應用程式貢獻翻譯';

  @override
  String get search => '搜尋';

  @override
  String get clearAll => '清除全部';

  @override
  String get calculator => '計算器';

  @override
  String get significantFigures => '有效數字';

  @override
  String get removeTrailingZeros => '移除尾隨零';

  @override
  String get longPressAdvice => '長按以移動項目';

  @override
  String get back => '返回';

  @override
  String get save => '儲存';

  @override
  String get invalidCharacters => '錯誤，無效的字元';

  @override
  String get theme => '主題';

  @override
  String get dark => '深色';

  @override
  String get light => '淺色';

  @override
  String get system => '系統預設';

  @override
  String get pureBlackTheme => 'AMOLED 深色主題';

  @override
  String get copy => '複製';

  @override
  String get more => '更多';

  @override
  String get language => '語言';

  @override
  String get reorderProperties => '排序屬性';

  @override
  String get reorderUnits => '排序單位';

  @override
  String get chooseProperty => '選擇屬性';

  @override
  String reorderProperty(String property) {
    return '排序 $property';
  }

  @override
  String get otherPlatforms => '其他平台的 Converter NOW';

  @override
  String get sourceCode => '原始碼';

  @override
  String get undoClearAllMessage => '已清除全部。您是否想取消？';

  @override
  String get undo => '取消';

  @override
  String get routeError1 => '此頁面不存在';

  @override
  String get routeError2 => '返回至第一頁';

  @override
  String get ok => 'OK';

  @override
  String get revokeInternetAccess => '禁用網路連線';

  @override
  String get revokeInternetExplanation =>
      '該應用在每次啟動時透過網路更新匯率。所需下載的數據只有幾 kiB。不過，您若不需此功能，啟用該選項可阻止該應用連線網際網路。';

  @override
  String get useDeviceColor => '使用系統設定的強調色';

  @override
  String get pickColor => '選擇顏色';

  @override
  String get themeColor => '主題色';

  @override
  String get appearance => '外觀';

  @override
  String get conversions => '轉換';

  @override
  String get findOutMore => '進一步了解';

  @override
  String get hideUnits => '隱藏單位';

  @override
  String visibleUnits(String property) {
    return '$property, 可見單位';
  }

  @override
  String get hiddenUnits => '隱藏的單位';

  @override
  String get selectAll => '選擇所有';

  @override
  String get unselectAll => '取消選擇';

  @override
  String get length => '長度';

  @override
  String get area => '面積';

  @override
  String get volume => '體積';

  @override
  String get time => '時間';

  @override
  String get temperature => '溫度';

  @override
  String get speed => '速度';

  @override
  String get siPrefixes => '國際單位制前置詞';

  @override
  String get mass => '質量';

  @override
  String get pressure => '壓力';

  @override
  String get energy => '能量';

  @override
  String get angles => '角度';

  @override
  String get currencies => '貨幣';

  @override
  String get shoeSize => '鞋號';

  @override
  String get digitalData => '數位資料';

  @override
  String get power => '功率';

  @override
  String get density => 'Density';

  @override
  String get torque => '力矩';

  @override
  String get force => '力';

  @override
  String get fuelConsumption => '燃料消耗量';

  @override
  String get numeralSystems => '數值系統';

  @override
  String get meters => '公尺；米';

  @override
  String get centimeters => '公分';

  @override
  String get inches => '英寸';

  @override
  String get feet => '英尺';

  @override
  String get nauticalMiles => '海里';

  @override
  String get yards => '碼';

  @override
  String get miles => '英里';

  @override
  String get millimeters => '公厘；毫米';

  @override
  String get micrometers => '微米';

  @override
  String get nanometers => '奈米';

  @override
  String get angstroms => '埃';

  @override
  String get picometers => '皮米';

  @override
  String get kilometers => '公里';

  @override
  String get astronomicalUnits => '天文單位';

  @override
  String get lightYears => '光年';

  @override
  String get parsec => '秒差距';

  @override
  String get mils => '密耳';

  @override
  String get feetUsSurvey => '英尺 (美國)';

  @override
  String get squareMeters => '平方公尺；平方米';

  @override
  String get squareCentimeters => '平方公分';

  @override
  String get squareInches => '平方英寸';

  @override
  String get squareFeet => '平方英尺';

  @override
  String get squareMiles => '平方英里';

  @override
  String get squareYard => '平方碼';

  @override
  String get squareMillimeters => '平方公厘；平方毫米';

  @override
  String get squareKilometers => '平方公里';

  @override
  String get hectares => '公頃';

  @override
  String get acres => '英畝';

  @override
  String get are => '公畝';

  @override
  String get squareFeetUsSurvey => '平方英尺 (美國)';

  @override
  String get gramsPerCubicCentimeter => 'Grams per Cubic Centimeter';

  @override
  String get gramsPerLiter => 'Grams per Liter';

  @override
  String get gramsPerMilliliter => 'Grams per Milliliter';

  @override
  String get gramsPerDeciliter => 'Grams per Deciliter';

  @override
  String get kilogramsPerLiter => 'Kilograms per Liter';

  @override
  String get kilogramsPerCubicMeter => 'Kilograms per Cubic Meter';

  @override
  String get milligramsPerLiter => 'Milligrams per Liter';

  @override
  String get milligramsPerDeciliter => 'Milligrams per Deciliter';

  @override
  String get milligramsPerMilliliter => 'Milligrams per Milliliter';

  @override
  String get milligramsPerCubicMeter => 'Milligrams per Cubic Meter';

  @override
  String get milligramsPerCubicCentimeter => 'Milligrams per Cubic Centimeter';

  @override
  String get microgramsPerLiter => 'Micrograms per Liter';

  @override
  String get microgramsPerDeciliter => 'Micrograms per Deciliter';

  @override
  String get microgramsPerMilliliter => 'Micrograms per Milliliter';

  @override
  String get poundsPerCubicInches => 'Pounds per Cubic Inches';

  @override
  String get poundsPerCubicFeet => 'Pounds per Cubic Feet';

  @override
  String get cubicMeters => '立方公尺';

  @override
  String get liters => '公升';

  @override
  String get imperialGallons => '英制加侖';

  @override
  String get usGallons => '美制加侖';

  @override
  String get imperialPints => '英制品脫';

  @override
  String get usPints => '美制品脫';

  @override
  String get milliliters => '毫升';

  @override
  String get tablespoonUs => '一湯匙 (美國)';

  @override
  String get tablespoonAustralian => '一湯匙 (澳大利亞)';

  @override
  String get cups => '杯';

  @override
  String get cubicCentimeters => '立方公分';

  @override
  String get cubicFeet => '立方英尺';

  @override
  String get cubicInches => '立方英寸';

  @override
  String get cubicMillimeters => '立方公厘；立方毫米';

  @override
  String get imperialFluidOunces => '英制液盎司';

  @override
  String get usFluidOunces => '美制液盎司';

  @override
  String get imperialGill => '英制及耳';

  @override
  String get usGill => '美制及耳';

  @override
  String get usQuarts => '美制夸脫';

  @override
  String get microliters => '微升';

  @override
  String get deciliters => '公合；分升';

  @override
  String get centiliters => '公勺；厘升';

  @override
  String get seconds => '秒';

  @override
  String get deciseconds => '分秒';

  @override
  String get centiseconds => '厘秒';

  @override
  String get milliseconds => '毫秒';

  @override
  String get microseconds => '微秒';

  @override
  String get nanoseconds => '奈秒';

  @override
  String get minutes => '分[鐘]';

  @override
  String get hours => '[小]時';

  @override
  String get days => '日';

  @override
  String get weeks => '週';

  @override
  String get years => '年 (365)';

  @override
  String get lustrum => '五年紀';

  @override
  String get decades => '十年紀';

  @override
  String get centuries => '世紀';

  @override
  String get millennium => '千年紀';

  @override
  String get fahrenheit => '華氏';

  @override
  String get celsius => '攝氏';

  @override
  String get kelvin => '克氏；克耳文';

  @override
  String get reamur => '列氏';

  @override
  String get romer => '羅氏';

  @override
  String get delisle => '德利爾';

  @override
  String get rankine => '蘭氏；蘭金';

  @override
  String get metersSecond => '公尺每秒；米每秒';

  @override
  String get kilometersHour => '公里每小時';

  @override
  String get milesHour => '英里每小時';

  @override
  String get knots => '節';

  @override
  String get feetSecond => '英尺每秒';

  @override
  String get minutesPerKilometer => '分鐘每公里';

  @override
  String get grams => '公克';

  @override
  String get ettograms => '百克';

  @override
  String get kilograms => '公斤';

  @override
  String get pounds => '磅';

  @override
  String get ounces => '盎司';

  @override
  String get quintals => '公擔';

  @override
  String get tons => '噸';

  @override
  String get milligrams => '毫克';

  @override
  String get uma => '統一原子質量單位';

  @override
  String get carats => '克拉';

  @override
  String get centigrams => '公毫';

  @override
  String get pennyweights => '便士法碼';

  @override
  String get troyOunces => '金衡盎司';

  @override
  String get stones => '英石';

  @override
  String get pascal => '帕[斯卡]';

  @override
  String get atmosphere => '大氣壓';

  @override
  String get bar => '巴';

  @override
  String get millibar => '毫巴';

  @override
  String get psi => '磅每平方英寸';

  @override
  String get torr => '托';

  @override
  String get hectoPascal => '百帕[斯卡]';

  @override
  String get inchesOfMercury => '英寸汞柱';

  @override
  String get kiloPascal => '千帕[斯卡]';

  @override
  String get ksi => 'Kilopounds per square inch';

  @override
  String get megaPascal => 'Megapascal';

  @override
  String get gigaPascal => 'Gigapascal';

  @override
  String get joule => '焦耳';

  @override
  String get calories => '卡[路里]';

  @override
  String get kilowattHour => '千瓦小時';

  @override
  String get electronvolt => '電子伏特';

  @override
  String get footPound => '英尺磅';

  @override
  String get kilocalories => '大卡';

  @override
  String get kilojoules => '千焦耳';

  @override
  String get degree => '度';

  @override
  String get minutesDegree => '分';

  @override
  String get secondsDegree => '秒';

  @override
  String get radiansDegree => '弧度';

  @override
  String get usd => '美金';

  @override
  String get eur => '歐元';

  @override
  String get gbp => '英鎊';

  @override
  String get inr => '印度盧比';

  @override
  String get cny => '人民幣';

  @override
  String get jpy => '日圓';

  @override
  String get chf => '瑞士法郎';

  @override
  String get sek => '瑞典幣';

  @override
  String get rub => '俄羅斯盧布';

  @override
  String get cad => '加拿大幣';

  @override
  String get krw => '韓元';

  @override
  String get brl => '巴西雷亞爾';

  @override
  String get hkd => '港幣';

  @override
  String get aud => '澳幣';

  @override
  String get nzd => '紐元';

  @override
  String get mxn => '墨西哥披索';

  @override
  String get sgd => '新加坡幣';

  @override
  String get nok => '挪威克朗';

  @override
  String get trY => '土耳其里拉';

  @override
  String get zar => '南非幣';

  @override
  String get dkk => '丹麥克朗';

  @override
  String get pln => '波蘭茲羅提';

  @override
  String get thb => '泰幣';

  @override
  String get myr => '馬來幣';

  @override
  String get huf => '匈牙利福林';

  @override
  String get czk => '捷克克朗';

  @override
  String get ils => '以色列新謝克爾';

  @override
  String get idr => '印尼幣';

  @override
  String get php => '菲國比索';

  @override
  String get ron => '羅馬尼亞列伊';

  @override
  String get bgn => '保加利亞列弗';

  @override
  String get isk => '冰島克朗';

  @override
  String get twd => '新台幣';

  @override
  String get mad => '摩洛哥迪拉姆';

  @override
  String get euChina => '歐盟 & 中國';

  @override
  String get ukIndiaChild => '英國 & 印度 - 孩童';

  @override
  String get ukIndiaMan => '英國 & 印度 - 男性';

  @override
  String get ukIndiaWoman => '英國 & 印度 - 女性';

  @override
  String get usaCanadaChild => '美國 & 加拿大 - 孩童';

  @override
  String get usaCanadaMan => '美國 & 加拿大 - 男性';

  @override
  String get usaCanadaWoman => '美國 & 加拿大 - 女性';

  @override
  String get japan => '日本';

  @override
  String get watt => '瓦特';

  @override
  String get milliwatt => '毫瓦';

  @override
  String get kilowatt => '千瓦';

  @override
  String get megawatt => '百萬瓦';

  @override
  String get gigawatt => '吉瓦';

  @override
  String get europeanHorsePower => '公制馬力';

  @override
  String get imperialHorsePower => '英制馬力';

  @override
  String get newton => '牛頓';

  @override
  String get dyne => '達因';

  @override
  String get poundForce => '磅力';

  @override
  String get kilogramForce => '公斤力';

  @override
  String get poundal => '磅達';

  @override
  String get newtonMeter => '牛頓公尺；牛頓米';

  @override
  String get dyneMeter => '達因公尺；達因米';

  @override
  String get poundForceFeet => '磅力英尺';

  @override
  String get kilogramForceMeter => '公斤力公尺';

  @override
  String get poundalMeter => '磅達公尺；磅達米';

  @override
  String get kilometersLiter => '公里每公升';

  @override
  String get liters100km => '公升每百公里';

  @override
  String get milesUsGallon => '英里每美制加侖';

  @override
  String get milesImperialGallon => '英里每英制加侖';

  @override
  String get decimal => '十進位制';

  @override
  String get hexadecimal => '十六進位制';

  @override
  String get octal => '八進位制';

  @override
  String get binary => '二進位制';

  @override
  String get bit => '位元';

  @override
  String get nibble => '半位元組';

  @override
  String get kilobit => '千位元';

  @override
  String get megabit => '百萬位元';

  @override
  String get gigabit => '吉位元';

  @override
  String get terabit => '兆位元';

  @override
  String get petabit => '拍位元';

  @override
  String get exabit => '艾位元';

  @override
  String get kibibit => '千位元（二進）';

  @override
  String get mebibit => '百萬位元（二進）';

  @override
  String get gibibit => '吉位元（二進）';

  @override
  String get tebibit => '兆位元（二進）';

  @override
  String get pebibit => '拍位元（二進）';

  @override
  String get exbibit => '艾位元（二進）';

  @override
  String get byte => '位元組';

  @override
  String get kilobyte => '千位元組';

  @override
  String get megabyte => '百萬位元組';

  @override
  String get gigabyte => '吉位元組';

  @override
  String get terabyte => '兆位元組';

  @override
  String get petabyte => '拍位元組';

  @override
  String get exabyte => '艾位元組';

  @override
  String get kibibyte => '千位元組';

  @override
  String get mebibyte => '百萬位元組';

  @override
  String get gibibyte => '吉位元組';

  @override
  String get tebibyte => '兆位元組';

  @override
  String get pebibyte => '拍位元組';

  @override
  String get exbibyte => '艾位元組';

  @override
  String get base => '基數';

  @override
  String get deca => '十-';

  @override
  String get hecto => '百-';

  @override
  String get kilo => '千-';

  @override
  String get mega => '百萬-';

  @override
  String get giga => '吉-';

  @override
  String get tera => '兆-';

  @override
  String get peta => '拍-';

  @override
  String get exa => '艾-';

  @override
  String get zetta => '皆-';

  @override
  String get yotta => '佑-';

  @override
  String get deci => '分-';

  @override
  String get centi => '厘-';

  @override
  String get milli => '毫-';

  @override
  String get micro => '微-';

  @override
  String get nano => '奈-';

  @override
  String get pico => '皮-';

  @override
  String get femto => '飛-';

  @override
  String get atto => '阿-';

  @override
  String get zepto => '介-';

  @override
  String get yocto => '攸-';
}
