package com.exner.tools.jkbikemechanicaldisasterprevention.ui.notifications

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import androidx.core.app.ActivityCompat
import androidx.core.app.NotificationCompat
import androidx.core.app.NotificationCompat.PRIORITY_DEFAULT
import androidx.core.app.NotificationCompat.VISIBILITY_PRIVATE
import androidx.core.app.NotificationManagerCompat
import com.exner.tools.jkbikemechanicaldisasterprevention.R

class Notifications {

    fun makeNotification(context: Context, title: String, content: String, notificationId: Int) {
        var builder = NotificationCompat.Builder(context, CHANNEL_ID)
            .setSmallIcon(R.drawable.ic_notification_icon)
            .setContentTitle(title)
            .setContentText(content)
            .setPriority(PRIORITY_DEFAULT)
            .setVisibility(VISIBILITY_PRIVATE)

        with(NotificationManagerCompat.from(context)) {
            if (ActivityCompat.checkSelfPermission(
                    context,
                    Manifest.permission.POST_NOTIFICATIONS
                ) != PackageManager.PERMISSION_GRANTED
            ) {
                // TODO: Consider calling
                // ActivityCompat#requestPermissions
                // here to request the missing permissions, and then overriding
                // public fun onRequestPermissionsResult(requestCode: Int, permissions: Array&lt;out String&gt;,
                //                                        grantResults: IntArray)
                // to handle the case where the user grants the permission. See the documentation
                // for ActivityCompat#requestPermissions for more details.

                return@with
            }
            // notificationId is a unique int for each notification that you must define.
            notify(notificationId, builder.build())
        }
    }

    companion object {
        val CHANNEL_ID = "com.exner.tools.jkbikemechanicaldisasterprevention"
        val CHANNEL_NAME = "J-K Bike Periodic Checks"
        val CHANNEL_DESCRIPTION = "Notification for Activities created through periodic checks"

    }
}