package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.templateActivities

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.filled.Delete
import androidx.compose.material.icons.filled.Done
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.livedata.observeAsState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.input.KeyboardCapitalization
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsGlobalScaffoldViewModel
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsResponsiveNavigation
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultRideLevelSelectorTemplate
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultTextFieldWithSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.TextAndSwitch
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsAction
import com.ramcosta.composedestinations.annotation.Destination
import com.ramcosta.composedestinations.annotation.RootGraph
import com.ramcosta.composedestinations.generated.destinations.TemplateActivityDeleteDestination
import com.ramcosta.composedestinations.generated.destinations.TemplateActivityEditDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator

@Destination<RootGraph>
@Composable
fun TemplateActivityEdit(
    templateActivityUid: Long,
    kJsGlobalScaffoldViewModel: KJsGlobalScaffoldViewModel,
    destinationsNavigator: DestinationsNavigator,
    windowSizeClass: WindowSizeClass
) {
    kJsGlobalScaffoldViewModel.setDestinationTitle(stringResource(R.string.hdr_edit_template_activity))

    val templateActivityEditViewModel =
        hiltViewModel<TemplateActivityEditViewModel, TemplateActivityEditViewModel.TemplateActivityEditViewModelFactory> { factory ->
            factory.create(templateActivityUid = templateActivityUid)
        }

    var modified by remember { mutableStateOf(false) }

    val advancedFunctionality by kJsGlobalScaffoldViewModel.advancedFunctionality.collectAsStateWithLifecycle()

    KJsResponsiveNavigation(
        TemplateActivityEditDestination,
        destinationsNavigator,
        windowSizeClass,
        myActions = listOf(
            KJsAction(
                imageVector = Icons.AutoMirrored.Filled.ArrowBack,
                contentDescription = stringResource(R.string.btn_text_cancel),
                onClick = {
                    destinationsNavigator.navigateUp()
                }
            ),
            KJsAction(
                imageVector = Icons.Default.Delete,
                contentDescription = stringResource(R.string.btn_text_delete),
                onClick = {
                    destinationsNavigator.navigate(
                        TemplateActivityDeleteDestination(
                            templateActivityUid
                        )
                    )
                }
            )
        ),
        myFloatingActionButton = KJsAction(
            imageVector = Icons.Default.Done,
            contentDescription = stringResource(R.string.btn_text_save),
            onClick = {
                templateActivityEditViewModel.commitActivity()
                modified = false
                destinationsNavigator.navigateUp()
            },
            enabled = modified
        ),
        headline = stringResource(R.string.hdr_edit_template_activity),
        advancedFunctionality = advancedFunctionality
    ) {
        val templateActivity by templateActivityEditViewModel.templateActivity.observeAsState()

        Column(
            modifier = Modifier.verticalScroll(rememberScrollState())
        ) {
            DefaultRideLevelSelectorTemplate(
                templateActivity?.rideLevel,
            ) {
                templateActivityEditViewModel.updateRideLevel(it)
                modified = true
            }
            DefaultSpacer()
            DefaultTextFieldWithSpacer(
                value = templateActivity?.title ?: "",
                label = stringResource(R.string.lbl_activity_title),
                placeholder = stringResource(R.string.placehldr_title),
                onValueChange = {
                    templateActivityEditViewModel.updateTitle(it)
                    modified = true
                },
            )
            OutlinedTextField(
                value = templateActivity?.description ?: "",
                onValueChange = {
                    templateActivityEditViewModel.updateDescription(it)
                    modified = true
                },
                modifier = Modifier.fillMaxWidth(),
                placeholder = { Text(text = stringResource(R.string.placehldr_description)) },
                label = { Text(text = stringResource(R.string.lbl_description)) },
                singleLine = false,
                keyboardOptions = KeyboardOptions.Default.copy(
                    capitalization = KeyboardCapitalization.Sentences
                )
            )
            DefaultSpacer()
            TextAndSwitch(
                text = stringResource(R.string.is_ebike_specific),
                checked = templateActivity?.isEBikeSpecific == true
            ) {
                templateActivityEditViewModel.updateIsEBikeSpecific(it)
                modified = true
            }
        }
    }
}