package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.templateActivities

import android.util.Log
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Clear
import androidx.compose.material.icons.filled.Save
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.input.KeyboardCapitalization
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.TemplateActivity
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.TemplateActivityType
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsGlobalScaffoldViewModel
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsResponsiveNavigation
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultRideLevelSelectorTemplate
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultTextFieldWithSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.TextAndSwitch
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsAction
import com.ramcosta.composedestinations.annotation.Destination
import com.ramcosta.composedestinations.annotation.RootGraph
import com.ramcosta.composedestinations.generated.destinations.TemplateActivityAddDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator

@Destination<RootGraph>
@Composable
fun TemplateActivityAdd(
    templateActivityAddViewModel: TemplateActivityAddViewModel = hiltViewModel(),
    kJsGlobalScaffoldViewModel: KJsGlobalScaffoldViewModel,
    destinationsNavigator: DestinationsNavigator,
    windowSizeClass: WindowSizeClass
) {
    kJsGlobalScaffoldViewModel.setDestinationTitle(stringResource(R.string.hdr_add_template_activity))

    var title by remember { mutableStateOf("") }
    var description by remember { mutableStateOf("") }
    var rideLevel: Int? by remember { mutableStateOf(null) }
    var isEbikeSpecific by remember { mutableStateOf(false) }

    var modified by remember { mutableStateOf(false) }

    val advancedFunctionality by kJsGlobalScaffoldViewModel.advancedFunctionality.collectAsStateWithLifecycle()

    KJsResponsiveNavigation(
        TemplateActivityAddDestination,
        destinationsNavigator,
        windowSizeClass,
        myActions = listOf(
            KJsAction(
                imageVector = Icons.Default.Clear,
                contentDescription = stringResource(R.string.btn_text_cancel),
                onClick = {
                    destinationsNavigator.navigateUp()
                }
            )
        ),
        myFloatingActionButton = KJsAction(
            imageVector = Icons.Default.Save,
            contentDescription = stringResource(R.string.btn_text_save),
            onClick = {
                val templateActivity = TemplateActivity(
                    rideLevel = rideLevel,
                    title = title,
                    description = description,
                    isEBikeSpecific = isEbikeSpecific,
                    typeOfTemplate = TemplateActivityType.CUSTOM
                )
                Log.d(
                    "TemplateActivityAdd",
                    "Saving template activity $templateActivity"
                )
                templateActivityAddViewModel.saveTemplateActivity(
                    templateActivity
                )
                modified = false
                destinationsNavigator.navigateUp()
            },
            enabled = modified && title.isNotBlank()
        ),
        headline = stringResource(R.string.hdr_add_template_activity),
        advancedFunctionality = advancedFunctionality
    ) {
        Column(
            modifier = Modifier
                .verticalScroll(rememberScrollState())
        ) {
            DefaultRideLevelSelectorTemplate(
                rideLevel,
            ) {
                rideLevel = it
                modified = true
            }
            DefaultSpacer()
            DefaultTextFieldWithSpacer(
                value = title,
                label = stringResource(R.string.lbl_activity_title),
                placeholder = stringResource(R.string.placehldr_title),
                onValueChange = {
                    title = it
                    modified = true
                },
            )
            OutlinedTextField(
                value = description,
                onValueChange = {
                    description = it
                    modified = true
                },
                modifier = Modifier.fillMaxWidth(),
                placeholder = { Text(text = stringResource(R.string.placehldr_description)) },
                label = { Text(text = stringResource(R.string.lbl_description)) },
                singleLine = false,
                keyboardOptions = KeyboardOptions.Default.copy(
                    capitalization = KeyboardCapitalization.Sentences
                )
            )
            DefaultSpacer()
            TextAndSwitch(
                text = stringResource(R.string.is_ebike_specific),
                checked = isEbikeSpecific
            ) {
                isEbikeSpecific = it
                modified = true
            }
        }
    }
}