package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.templateActivities

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class ManageTemplateActivitiesViewModel @Inject constructor(
    private val userPreferencesManager: UserPreferencesManager,
    val repository: KJsRepository
) : ViewModel() {

    val templateActivities = repository.observeTemplateActivity

    val showBuiltInTemplateActivities: StateFlow<Boolean> = userPreferencesManager.showBuiltInTemplateActivities().stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(),
        true
    )

    fun updateShowBuiltInTemplateActivities(enabled: Boolean) {
        viewModelScope.launch {
            userPreferencesManager.setShowBuiltInTemplateActivities(enabled)
        }
    }
}