package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.rides

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Activity
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Bike
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Ride
import dagger.assisted.Assisted
import dagger.assisted.AssistedFactory
import dagger.assisted.AssistedInject
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

@HiltViewModel(assistedFactory = ViewRideViewModel.ViewRideViewModelFactory::class)
class ViewRideViewModel @AssistedInject constructor(
    @Assisted val rideUid: Long,
    val repository: KJsRepository
) : ViewModel() {

    private val _ride: MutableStateFlow<Ride?> = MutableStateFlow(null)
    val ride: StateFlow<Ride?> = _ride

    private val _bike: MutableStateFlow<Bike?> = MutableStateFlow(null)
    val bike: StateFlow<Bike?> = _bike

    private val _activities: MutableStateFlow<List<Activity>> = MutableStateFlow(
        emptyList()
    )
    val activities: StateFlow<List<Activity>> = _activities

    init {
        if (rideUid > 0L) {
            viewModelScope.launch {
                _ride.value = repository.getRideByUid(rideUid)
                if (ride.value?.bikeUid != null) {
                    _bike.value = repository.getBikeByUid(ride.value!!.bikeUid!!)
                }
                _activities.value = repository.getActivitiesForRide(rideUid)
            }
        }
    }

    @AssistedFactory
    interface ViewRideViewModelFactory {
        fun create(rideUid: Long): ViewRideViewModel
    }
}