package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.rides

import android.util.Log
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material3.ListItem
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsGlobalScaffoldViewModel
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsResponsiveNavigation
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsAction
import com.ramcosta.composedestinations.annotation.Destination
import com.ramcosta.composedestinations.annotation.RootGraph
import com.ramcosta.composedestinations.generated.destinations.ListRideHistoryDestination
import com.ramcosta.composedestinations.generated.destinations.ViewRideDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator

@Destination<RootGraph>
@Composable
fun ListRideHistory(
    listRideHistoryViewModel: ListRideHistoryViewModel = hiltViewModel(),
    kJsGlobalScaffoldViewModel: KJsGlobalScaffoldViewModel,
    destinationsNavigator: DestinationsNavigator,
    windowSizeClass: WindowSizeClass
) {
    kJsGlobalScaffoldViewModel.setDestinationTitle(stringResource(R.string.hdr_ride_history))

    val advancedFunctionality by kJsGlobalScaffoldViewModel.advancedFunctionality.collectAsStateWithLifecycle()

    KJsResponsiveNavigation(
        ListRideHistoryDestination,
        destinationsNavigator,
        windowSizeClass,
        myActions = listOf(
            KJsAction(
                imageVector = Icons.AutoMirrored.Filled.ArrowBack,
                contentDescription = stringResource(R.string.btn_desc_back),
                onClick = {
                    destinationsNavigator.navigateUp()
                }
            )
        ),
        headline = stringResource(R.string.hdr_list_ride_history),
        advancedFunctionality = advancedFunctionality
    ) {
        val rideWithBikeAndActivityTotals by listRideHistoryViewModel.observeRidesWithBikeAndActivityTotals.collectAsStateWithLifecycle(
            initialValue = emptyList()
        )

        Column(
            modifier = Modifier
                .fillMaxSize()
        ) {

            LazyColumn(
                modifier = Modifier
                    .fillMaxWidth()
                    .weight(0.7f)
            ) {
                stickyHeader {
                    Text(
                        modifier = Modifier
                            .fillMaxWidth()
                            .background(MaterialTheme.colorScheme.primaryContainer)
                            .padding(8.dp),
                        text = stringResource(R.string.hdr_rides),
                        style = MaterialTheme.typography.bodyMedium,
                    )
                }

                Log.d(
                    "ListRideHistory",
                    "rides ${rideWithBikeAndActivityTotals.size}: $rideWithBikeAndActivityTotals"
                )
                items(rideWithBikeAndActivityTotals.filter { rideWithBikeAndActivityTotals ->
                    rideWithBikeAndActivityTotals.rideIsCompleted == true
                }, key = { "ride.${it.rideUid}" }) { rideWithBikeAndActivityTotals ->
                    Surface(
                        modifier = Modifier.clickable(
                            enabled = true,
                            onClick = {
                                destinationsNavigator.navigate(
                                    ViewRideDestination(
                                        rideWithBikeAndActivityTotals.rideUid
                                    )
                                )
                            }
                        )
                    ) {
                        ListItem(
                            overlineContent = {
                                Text(text = rideWithBikeAndActivityTotals.bikeName ?: "")
                            },
                            headlineContent = {
                                Text(
                                    text = rideWithBikeAndActivityTotals.rideName ?: stringResource(
                                        R.string.text_unnamed_ride
                                    )
                                )
                            },
                            supportingContent = {
                                Text(text = "Activities: ${rideWithBikeAndActivityTotals.numberOfActivitiesTotal} total, ${rideWithBikeAndActivityTotals.numberOfActivitiesCompleted} completed.")
                            }
                        )
                    }
                }
            }
        }
    }
}