package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.importExport

import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.Export
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class ExportDataViewModel @Inject constructor(
    val userPreferencesManager: UserPreferencesManager,
    val repository: KJsRepository
) : ViewModel() {

    val exportBuiltInTemplates: StateFlow<Boolean> =
        userPreferencesManager.exportInternalTemplateActivities().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            false
        )

    fun setExportBuiltInTemplates(enabled: Boolean) {
        viewModelScope.launch {
            userPreferencesManager.setExportInternalTemplateActivities(enabled)
        }
    }

    val exportCompletedActivitiesAndRides: StateFlow<Boolean> =
        userPreferencesManager.exportCompletedThings().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            true
        )

    fun setExportCompletedActivitiesAndRides(enabled: Boolean) {
        viewModelScope.launch {
            userPreferencesManager.setExportCompletedThings(enabled)
        }
    }

    val allBikes = repository.observeBikes
    val allActivities = repository.observeActivities
    val allTemplates = repository.observeTemplateActivity
    val allComponents = repository.observeComponents
    val allRides = repository.observeRides

    // partial ones
    val activitiesButNotForCompletedRides = repository.observeActivitiesButNotForCompletedRides

    val numberOfCustomTemplateActivities = repository.observeNumberOfCustomTemplateActivities

    fun commitExport(
        context: Context,
        successCallback: (() -> Unit)? = null,
        failureCallback: ((String) -> Unit)? = null
    ) {
        val export = Export(
            repository = repository,
            context = context
        )
        export.commitExport(
            exportType = "export",
            exportBuiltInTemplates = exportBuiltInTemplates.value,
            exportCompletedActivitiesAndRides = exportCompletedActivitiesAndRides.value,
            successCallback = successCallback,
            failureCallback = failureCallback,
        )
    }
}