package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.components

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Bike
import dagger.assisted.Assisted
import dagger.assisted.AssistedFactory
import dagger.assisted.AssistedInject
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

enum class ComponentType {
    ON_BIKE,
    ON_SHELF,
    RETIRED
}

@HiltViewModel(assistedFactory = ManageComponentsViewModel.ManageComponentsViewModelFactory::class)
class ManageComponentsViewModel @AssistedInject constructor(
    @Assisted val bikeUid: Long? = null,
    val repository: KJsRepository
) : ViewModel() {

    private val _selectedBike: MutableStateFlow<Bike?> = MutableStateFlow(null)
    val selectedBike: StateFlow<Bike?> = _selectedBike

    fun updateSelectedBike(bikeUid: Long?) {
        if (bikeUid == null) {
            _selectedBike.value = null
        } else {
            viewModelScope.launch {
                val bike = repository.getBikeByUid(bikeUid)
                _selectedBike.value = bike
            }
        }
    }

    val components = repository.observeNonRetiredComponents

    val componentsOnShelf = repository.observerShelvedComponents

    val retiredComponents = repository.observeRetiredComponents

    val bikes = repository.observeBikes

    init {
        if (bikeUid != null && bikeUid > 0) {
            updateSelectedBike(bikeUid)
        }
    }

    @AssistedFactory
    interface ManageComponentsViewModelFactory {
        fun create(bikeUid: Long?): ManageComponentsViewModel
    }
}