package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.bikes

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.DistanceMeasure
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import javax.inject.Inject

@HiltViewModel
class ManageBikesViewModel @Inject constructor(
    userPreferencesManager: UserPreferencesManager,
    repository: KJsRepository,
) : ViewModel() {

    val bikes = repository.observeBikes

    val allBikes = repository.observeAllBikes

    val distanceMeasure: StateFlow<DistanceMeasure> =
        userPreferencesManager.distanceMeasure().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            DistanceMeasure.KM
        )

    val stravaEnabled: StateFlow<Boolean> = userPreferencesManager.stravaEnabled().stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(),
        false
    )
    val isAllowedToReadAllProfileData: StateFlow<Boolean> =
        userPreferencesManager.stravaAllowedAllProfileData().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            false
        )

    val intervalsEnabled: StateFlow<Boolean> = userPreferencesManager.intervalsEnabled().stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(),
        false
    )
    val isAllowedToReadAthleteData: StateFlow<Boolean> =
        userPreferencesManager.intervalsAllowedAthleteSettings().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            false
        )

}