package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.bikes

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.filled.Delete
import androidx.compose.material3.Text
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.livedata.observeAsState
import androidx.compose.ui.res.stringResource
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsGlobalScaffoldViewModel
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsResponsiveNavigation
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsAction
import com.ramcosta.composedestinations.annotation.Destination
import com.ramcosta.composedestinations.annotation.RootGraph
import com.ramcosta.composedestinations.generated.destinations.BikeDeleteDestination
import com.ramcosta.composedestinations.generated.destinations.HomeDestination
import com.ramcosta.composedestinations.generated.destinations.ManageBikesDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator

@Destination<RootGraph>
@Composable
fun BikeDelete(
    bikeUid: Long,
    kJsGlobalScaffoldViewModel: KJsGlobalScaffoldViewModel,
    destinationsNavigator: DestinationsNavigator,
    windowSizeClass: WindowSizeClass
) {
    kJsGlobalScaffoldViewModel.setDestinationTitle(stringResource(R.string.hdr_delete_a_bike))

    val bikeDeleteViewModel =
        hiltViewModel<BikeDeleteViewModel, BikeDeleteViewModel.BikeDeleteViewModelFactory> { factory ->
            factory.create(bikeUid = bikeUid)
        }

    val advancedFunctionality by kJsGlobalScaffoldViewModel.advancedFunctionality.collectAsStateWithLifecycle()

    KJsResponsiveNavigation(
        BikeDeleteDestination,
        destinationsNavigator,
        windowSizeClass,
        myActions = listOf(
            KJsAction(
                imageVector = Icons.AutoMirrored.Filled.ArrowBack,
                contentDescription = stringResource(R.string.btn_text_cancel),
                onClick = {
                    destinationsNavigator.navigateUp()
                }
            )
        ),
        myFloatingActionButton = KJsAction(
            imageVector = Icons.Default.Delete,
            contentDescription = stringResource(R.string.btn_text_delete),
            onClick = {
                bikeDeleteViewModel.commitDelete()
                val goBackTo = destinationsNavigator.getBackStackEntry(ManageBikesDestination)
                if (goBackTo != null) {
                    destinationsNavigator.popBackStack(
                        ManageBikesDestination,
                        inclusive = false
                    )
                } else {
                    destinationsNavigator.popBackStack(
                        HomeDestination,
                        inclusive = false
                    )
                }
            }
        ),
        headline = stringResource(R.string.hdr_delete_a_bike),
        advancedFunctionality = advancedFunctionality
    ) {
        val bike by bikeDeleteViewModel.bike.observeAsState()

        if (bike != null) {
            Text(text = "${stringResource(R.string.you_are_about_to_delete_the_bike)} ${bike!!.name}")
        } else {
            Text(text = stringResource(R.string.we_can_not_find_this_bike))
        }
    }
}
