package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.activities

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Bike
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class ManageActivitiesViewModel @Inject constructor(
    private val userPreferencesManager: UserPreferencesManager,
    val repository: KJsRepository
) : ViewModel() {

    val activities = repository.observeActivities

    val observeBikes = repository.observeBikes
    private val _currentBike: MutableStateFlow<Bike?> = MutableStateFlow(null)
    val currentBike: StateFlow<Bike?> = _currentBike

    fun updateCurrentBike(bike: Bike?) {
        _currentBike.value = bike
    }

    val showCompletedActivities: StateFlow<Boolean> = userPreferencesManager.showCompletedActivities().stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(),
        true
    )

    fun updateShowCompletedActivities(enabled: Boolean) {
        viewModelScope.launch {
            userPreferencesManager.setShowCompletedActivities(enabled)
        }
    }
}