package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.activities

import androidx.compose.foundation.layout.Column
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.filled.Delete
import androidx.compose.material3.Text
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.livedata.observeAsState
import androidx.compose.ui.res.stringResource
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsGlobalScaffoldViewModel
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.KJsResponsiveNavigation
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.ShowActivityDetails
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsAction
import com.ramcosta.composedestinations.annotation.Destination
import com.ramcosta.composedestinations.annotation.RootGraph
import com.ramcosta.composedestinations.generated.destinations.ActivityDeleteDestination
import com.ramcosta.composedestinations.generated.destinations.HomeDestination
import com.ramcosta.composedestinations.generated.destinations.ManageActivitiesDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator
import com.ramcosta.composedestinations.utils.route

@Destination<RootGraph>
@Composable
fun ActivityDelete(
    activityUid: Long,
    kJsGlobalScaffoldViewModel: KJsGlobalScaffoldViewModel,
    destinationsNavigator: DestinationsNavigator,
    windowSizeClass: WindowSizeClass
) {
    kJsGlobalScaffoldViewModel.setDestinationTitle(stringResource(R.string.hdr_delete_an_activity))

    val activityDeleteViewModel =
        hiltViewModel<ActivityDeleteViewModel, ActivityDeleteViewModel.ActivityDeleteViewModelFactory> { factory ->
            factory.create(activityUid)
        }

    val advancedFunctionality by kJsGlobalScaffoldViewModel.advancedFunctionality.collectAsStateWithLifecycle()

    KJsResponsiveNavigation(
        ActivityDeleteDestination,
        destinationsNavigator,
        windowSizeClass,
        myActions = listOf(
            KJsAction(
                imageVector = Icons.AutoMirrored.Filled.ArrowBack,
                contentDescription = stringResource(R.string.btn_text_cancel),
                onClick = {
                    destinationsNavigator.navigateUp()
                }
            )
        ),
        myFloatingActionButton = KJsAction(
            imageVector = Icons.Default.Delete,
            contentDescription = stringResource(R.string.btn_text_delete),
            onClick = {
                activityDeleteViewModel.commitDelete()
                val goBackTo = destinationsNavigator.getBackStackEntry(ManageActivitiesDestination)?.route()
                if (goBackTo != null) {
                    destinationsNavigator.popBackStack(goBackTo, inclusive = false)
                } else {
                    destinationsNavigator.popBackStack(HomeDestination, inclusive = false)
                }
            }
        ),
        headline = stringResource(R.string.hdr_delete_an_activity),
        advancedFunctionality = advancedFunctionality
    ) {
        val activity by activityDeleteViewModel.activity.observeAsState()

        Column {
            if (activity != null) {
                Text(text = "${stringResource(R.string.you_are_about_to_delete_activity)} ${activity?.title}")
                DefaultSpacer()
                ShowActivityDetails(activity)
            } else {
                Text(text = stringResource(R.string.we_can_not_find_this_activity))
            }
        }
    }
}