package com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.activities

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Activity
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Bike
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Component
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class ActivityAddViewModel @Inject constructor(
    userPreferencesManager: UserPreferencesManager,
    val repository: KJsRepository
) : ViewModel() {

    val observeBikes = repository.observeBikes
    private val _currentBike: MutableStateFlow<Bike?> = MutableStateFlow(null)
    val currentBike: StateFlow<Bike?> = _currentBike

    val advancedFunctionality: StateFlow<Boolean> =
        userPreferencesManager.advancedFunctionality().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            false
        )
    val observeComponents = repository.observeComponents
    private val _currentComponent: MutableStateFlow<Component?> = MutableStateFlow(null)
    val currentComponent: StateFlow<Component?> = _currentComponent

    fun updateAttachedBike(bikeUid: Long?) {
        if (bikeUid != null) {
            viewModelScope.launch {
                _currentBike.value = repository.getBikeByUid(bikeUid)
            }
        } else {
            _currentBike.value = null
        }
    }

    fun updateAttachedComponent(componentUid: Long?) {
        if (componentUid != null) {
            viewModelScope.launch {
                _currentComponent.value = repository.getComponentByUid(componentUid)
            }
        } else {
            _currentComponent.value = null
        }
    }

    fun saveActivity(activity: Activity) {
        viewModelScope.launch {
            repository.insertActivity(activity)
        }
    }
}