package com.exner.tools.jkbikemechanicaldisasterprevention.ui.integrations

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.IconSpacer

@Composable
fun IntervalsAttributionTextAndLogo() {
    Row(
        modifier = Modifier
            .padding(8.dp, 0.dp)
            .fillMaxWidth(),
        horizontalArrangement = Arrangement.End,
        verticalAlignment = Alignment.CenterVertically
    ) {
        Text(text = stringResource(R.string.data_from_intervals_icu))
        IconSpacer()
        Icon(
            painterResource(R.drawable.intervals_icu_logo_192),
            contentDescription = "Intervals.icu logo",
            tint = Color.Unspecified,
            modifier = Modifier.height(24.dp)
        )
    }
}