package com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers

import android.content.Context
import android.util.Log
import androidx.core.os.LocaleListCompat
import kotlin.collections.contains

private const val TAG = "SupportedLanguages"

class SupportedLanguages {

    companion object {
        fun getSupportedLanguageDefault(): String {
            return "default"
        }

        fun getSupportedLanguageEnglish(): String {
            return "en"
        }

        fun getSupportedLanguageFrench(): String {
            return "fr"
        }

        fun getSupportedLanguageGerman(): String {
            return "de"
        }

        fun getSupportedLanguageGermanSwiss(): String {
            return "de-rCH"
        }

        fun getListOfSupportedLanguages(): List<String> {
            return listOf("en", "fr", "de", "de-rCH")
        }

        fun getLabel(context: Context, languageCode: String?): String {
            when (languageCode) {
                "default" -> return "Default"

                "en" -> return "English"

                "fr" -> return "Français"

                "de" -> return "Deutsch"

                "de-rCH" -> return "Deutsch (Schweiz)"
            }

            return "Default"
        }

        fun determineLocaleToLoad(): String {
            val listOfDefaultLocales = LocaleListCompat.getDefault()
            Log.d(TAG, "LocaleListCompat: $listOfDefaultLocales")
            val listOfMyLocales = listOf("en", "de", "fr")
            val numLocales = listOfDefaultLocales.size()
            for (i in 0..numLocales) {
                val tempLocale = listOfDefaultLocales.get(i)
                Log.d(TAG, "Step $i: ${tempLocale?.language}/${tempLocale?.country}")
                val tempLanguage = tempLocale?.language
                if (tempLanguage in listOfMyLocales) {
                    if (tempLanguage == "de" && tempLocale.country == "CH") {
                        return "de-rCH"
                    } else if (tempLanguage != null) {
                        return tempLanguage
                    }
                }
            }
            return "en" // fallback
        }
    }
}
